// ui/accessibility/mojom/ax_tree_data.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_TREE_DATA_MOJOM_SHARED_H_
#define UI_ACCESSIBILITY_MOJOM_AX_TREE_DATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ui/accessibility/mojom/ax_tree_data.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"







namespace ax {
namespace mojom {
class AXTreeDataDataView;



}  // namespace mojom
}  // namespace ax

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::AXTreeDataDataView> {
  using Data = ::ax::mojom::internal::AXTreeData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ax {
namespace mojom {


class AXTreeDataDataView {
 public:
  AXTreeDataDataView() {}

  AXTreeDataDataView(
      internal::AXTreeData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetTreeIdDataView(
      ::ax::mojom::AXTreeIDDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTreeId(UserType* output) {
    
    auto* pointer = !data_->tree_id.is_null() ? &data_->tree_id : nullptr;
    return mojo::internal::Deserialize<::ax::mojom::AXTreeIDDataView>(
        pointer, output, context_);
  }
  inline void GetParentTreeIdDataView(
      ::ax::mojom::AXTreeIDDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParentTreeId(UserType* output) {
    
    auto* pointer = !data_->parent_tree_id.is_null() ? &data_->parent_tree_id : nullptr;
    return mojo::internal::Deserialize<::ax::mojom::AXTreeIDDataView>(
        pointer, output, context_);
  }
  inline void GetFocusedTreeIdDataView(
      ::ax::mojom::AXTreeIDDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFocusedTreeId(UserType* output) {
    
    auto* pointer = !data_->focused_tree_id.is_null() ? &data_->focused_tree_id : nullptr;
    return mojo::internal::Deserialize<::ax::mojom::AXTreeIDDataView>(
        pointer, output, context_);
  }
  inline void GetDoctypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDoctype(UserType* output) {
    
    auto* pointer = data_->doctype.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  bool loaded() const {
    return data_->loaded;
  }
  float loading_progress() const {
    return data_->loading_progress;
  }
  inline void GetMimetypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMimetype(UserType* output) {
    
    auto* pointer = data_->mimetype.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  int32_t focus_id() const {
    return data_->focus_id;
  }
  bool sel_is_backward() const {
    return data_->sel_is_backward;
  }
  int32_t sel_anchor_object_id() const {
    return data_->sel_anchor_object_id;
  }
  int32_t sel_anchor_offset() const {
    return data_->sel_anchor_offset;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSelAnchorAffinity(UserType* output) const {
    auto data_value = data_->sel_anchor_affinity;
    return mojo::internal::Deserialize<::ax::mojom::TextAffinity>(
        data_value, output);
  }

  ::ax::mojom::TextAffinity sel_anchor_affinity() const {
    return static_cast<::ax::mojom::TextAffinity>(data_->sel_anchor_affinity);
  }
  int32_t sel_focus_object_id() const {
    return data_->sel_focus_object_id;
  }
  int32_t sel_focus_offset() const {
    return data_->sel_focus_offset;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSelFocusAffinity(UserType* output) const {
    auto data_value = data_->sel_focus_affinity;
    return mojo::internal::Deserialize<::ax::mojom::TextAffinity>(
        data_value, output);
  }

  ::ax::mojom::TextAffinity sel_focus_affinity() const {
    return static_cast<::ax::mojom::TextAffinity>(data_->sel_focus_affinity);
  }
  int32_t root_scroller_id() const {
    return data_->root_scroller_id;
  }
 private:
  internal::AXTreeData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace ax

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXTreeDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXTreeDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::ax::mojom::internal::AXTreeData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::tree_id(input)) in_tree_id = Traits::tree_id(input);
    typename decltype((*output)->tree_id)::BufferWriter tree_id_writer;
    tree_id_writer.AllocateInline(buffer, &(*output)->tree_id);
    mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
        in_tree_id, buffer, &tree_id_writer, true, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->tree_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tree_id in AXTreeData struct");
    decltype(Traits::parent_tree_id(input)) in_parent_tree_id = Traits::parent_tree_id(input);
    typename decltype((*output)->parent_tree_id)::BufferWriter parent_tree_id_writer;
    parent_tree_id_writer.AllocateInline(buffer, &(*output)->parent_tree_id);
    mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
        in_parent_tree_id, buffer, &parent_tree_id_writer, true, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->parent_tree_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null parent_tree_id in AXTreeData struct");
    decltype(Traits::focused_tree_id(input)) in_focused_tree_id = Traits::focused_tree_id(input);
    typename decltype((*output)->focused_tree_id)::BufferWriter focused_tree_id_writer;
    focused_tree_id_writer.AllocateInline(buffer, &(*output)->focused_tree_id);
    mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
        in_focused_tree_id, buffer, &focused_tree_id_writer, true, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->focused_tree_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null focused_tree_id in AXTreeData struct");
    decltype(Traits::doctype(input)) in_doctype = Traits::doctype(input);
    typename decltype((*output)->doctype)::BaseType::BufferWriter
        doctype_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_doctype, buffer, &doctype_writer, context);
    (*output)->doctype.Set(
        doctype_writer.is_null() ? nullptr : doctype_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->doctype.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null doctype in AXTreeData struct");
    (*output)->loaded = Traits::loaded(input);
    (*output)->loading_progress = Traits::loading_progress(input);
    decltype(Traits::mimetype(input)) in_mimetype = Traits::mimetype(input);
    typename decltype((*output)->mimetype)::BaseType::BufferWriter
        mimetype_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_mimetype, buffer, &mimetype_writer, context);
    (*output)->mimetype.Set(
        mimetype_writer.is_null() ? nullptr : mimetype_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->mimetype.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mimetype in AXTreeData struct");
    decltype(Traits::title(input)) in_title = Traits::title(input);
    typename decltype((*output)->title)::BaseType::BufferWriter
        title_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_title, buffer, &title_writer, context);
    (*output)->title.Set(
        title_writer.is_null() ? nullptr : title_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->title.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in AXTreeData struct");
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in AXTreeData struct");
    (*output)->focus_id = Traits::focus_id(input);
    (*output)->sel_is_backward = Traits::sel_is_backward(input);
    (*output)->sel_anchor_object_id = Traits::sel_anchor_object_id(input);
    (*output)->sel_anchor_offset = Traits::sel_anchor_offset(input);
    mojo::internal::Serialize<::ax::mojom::TextAffinity>(
        Traits::sel_anchor_affinity(input), &(*output)->sel_anchor_affinity);
    (*output)->sel_focus_object_id = Traits::sel_focus_object_id(input);
    (*output)->sel_focus_offset = Traits::sel_focus_offset(input);
    mojo::internal::Serialize<::ax::mojom::TextAffinity>(
        Traits::sel_focus_affinity(input), &(*output)->sel_focus_affinity);
    (*output)->root_scroller_id = Traits::root_scroller_id(input);
  }

  static bool Deserialize(::ax::mojom::internal::AXTreeData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::AXTreeDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ax {
namespace mojom {

inline void AXTreeDataDataView::GetTreeIdDataView(
    ::ax::mojom::AXTreeIDDataView* output) {
  auto pointer = &data_->tree_id;
  *output = ::ax::mojom::AXTreeIDDataView(pointer, context_);
}
inline void AXTreeDataDataView::GetParentTreeIdDataView(
    ::ax::mojom::AXTreeIDDataView* output) {
  auto pointer = &data_->parent_tree_id;
  *output = ::ax::mojom::AXTreeIDDataView(pointer, context_);
}
inline void AXTreeDataDataView::GetFocusedTreeIdDataView(
    ::ax::mojom::AXTreeIDDataView* output) {
  auto pointer = &data_->focused_tree_id;
  *output = ::ax::mojom::AXTreeIDDataView(pointer, context_);
}
inline void AXTreeDataDataView::GetDoctypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->doctype.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void AXTreeDataDataView::GetMimetypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mimetype.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void AXTreeDataDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void AXTreeDataDataView::GetUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace ax

#endif  // UI_ACCESSIBILITY_MOJOM_AX_TREE_DATA_MOJOM_SHARED_H_