// third_party/blink/public/mojom/digital_goods/digital_goods.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIGITAL_GOODS_DIGITAL_GOODS_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIGITAL_GOODS_DIGITAL_GOODS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-shared.h"
#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-blink-forward.h"
#include "components/payments/mojom/payment_request_data.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"




namespace WTF {
struct payments_mojom_internal_BillingResponseCode_DataHashFn {
  static unsigned GetHash(const ::payments::mojom::BillingResponseCode& value) {
    using utype = std::underlying_type<::payments::mojom::BillingResponseCode>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::payments::mojom::BillingResponseCode& left, const ::payments::mojom::BillingResponseCode& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::payments::mojom::BillingResponseCode>
    : public GenericHashTraits<::payments::mojom::BillingResponseCode> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::payments::mojom::BillingResponseCode& value) {
    return value == static_cast<::payments::mojom::BillingResponseCode>(-1000000);
  }
  static void ConstructDeletedValue(::payments::mojom::BillingResponseCode& slot, bool) {
    slot = static_cast<::payments::mojom::BillingResponseCode>(-1000001);
  }
  static bool IsDeletedValue(const ::payments::mojom::BillingResponseCode& value) {
    return value == static_cast<::payments::mojom::BillingResponseCode>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct payments_mojom_internal_CreateDigitalGoodsResponseCode_DataHashFn {
  static unsigned GetHash(const ::payments::mojom::CreateDigitalGoodsResponseCode& value) {
    using utype = std::underlying_type<::payments::mojom::CreateDigitalGoodsResponseCode>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::payments::mojom::CreateDigitalGoodsResponseCode& left, const ::payments::mojom::CreateDigitalGoodsResponseCode& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::payments::mojom::CreateDigitalGoodsResponseCode>
    : public GenericHashTraits<::payments::mojom::CreateDigitalGoodsResponseCode> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::payments::mojom::CreateDigitalGoodsResponseCode& value) {
    return value == static_cast<::payments::mojom::CreateDigitalGoodsResponseCode>(-1000000);
  }
  static void ConstructDeletedValue(::payments::mojom::CreateDigitalGoodsResponseCode& slot, bool) {
    slot = static_cast<::payments::mojom::CreateDigitalGoodsResponseCode>(-1000001);
  }
  static bool IsDeletedValue(const ::payments::mojom::CreateDigitalGoodsResponseCode& value) {
    return value == static_cast<::payments::mojom::CreateDigitalGoodsResponseCode>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace payments {
namespace mojom {
namespace blink {

class DigitalGoodsProxy;

template <typename ImplRefTraits>
class DigitalGoodsStub;

class DigitalGoodsRequestValidator;
class DigitalGoodsResponseValidator;


class PLATFORM_EXPORT DigitalGoods
    : public DigitalGoodsInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DigitalGoodsInterfaceBase;
  using Proxy_ = DigitalGoodsProxy;

  template <typename ImplRefTraits>
  using Stub_ = DigitalGoodsStub<ImplRefTraits>;

  using RequestValidator_ = DigitalGoodsRequestValidator;
  using ResponseValidator_ = DigitalGoodsResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetDetailsMinVersion = 0,
    kAcknowledgeMinVersion = 0,
  };
  virtual ~DigitalGoods() {}


  using GetDetailsCallback = base::OnceCallback<void(BillingResponseCode, WTF::Vector<ItemDetailsPtr>)>;
  
  virtual void GetDetails(const WTF::Vector<WTF::String>& item_ids, GetDetailsCallback callback) = 0;


  using AcknowledgeCallback = base::OnceCallback<void(BillingResponseCode)>;
  
  virtual void Acknowledge(const WTF::String& purchase_token, bool make_available_again, AcknowledgeCallback callback) = 0;
};

class DigitalGoodsFactoryProxy;

template <typename ImplRefTraits>
class DigitalGoodsFactoryStub;

class DigitalGoodsFactoryRequestValidator;
class DigitalGoodsFactoryResponseValidator;


class PLATFORM_EXPORT DigitalGoodsFactory
    : public DigitalGoodsFactoryInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DigitalGoodsFactoryInterfaceBase;
  using Proxy_ = DigitalGoodsFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = DigitalGoodsFactoryStub<ImplRefTraits>;

  using RequestValidator_ = DigitalGoodsFactoryRequestValidator;
  using ResponseValidator_ = DigitalGoodsFactoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateDigitalGoodsMinVersion = 0,
  };
  virtual ~DigitalGoodsFactory() {}


  using CreateDigitalGoodsCallback = base::OnceCallback<void(CreateDigitalGoodsResponseCode, ::mojo::PendingRemote<DigitalGoods>)>;
  
  virtual void CreateDigitalGoods(const WTF::String& payment_method, CreateDigitalGoodsCallback callback) = 0;
};



class PLATFORM_EXPORT DigitalGoodsProxy
    : public DigitalGoods {
 public:
  using InterfaceType = DigitalGoods;

  explicit DigitalGoodsProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDetails(const WTF::Vector<WTF::String>& item_ids, GetDetailsCallback callback) final;
  
  void Acknowledge(const WTF::String& purchase_token, bool make_available_again, AcknowledgeCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT DigitalGoodsFactoryProxy
    : public DigitalGoodsFactory {
 public:
  using InterfaceType = DigitalGoodsFactory;

  explicit DigitalGoodsFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateDigitalGoods(const WTF::String& payment_method, CreateDigitalGoodsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT DigitalGoodsStubDispatch {
 public:
  static bool Accept(DigitalGoods* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DigitalGoods* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DigitalGoods>>
class DigitalGoodsStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DigitalGoodsStub() {}
  ~DigitalGoodsStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DigitalGoodsStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DigitalGoodsStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT DigitalGoodsFactoryStubDispatch {
 public:
  static bool Accept(DigitalGoodsFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DigitalGoodsFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DigitalGoodsFactory>>
class DigitalGoodsFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DigitalGoodsFactoryStub() {}
  ~DigitalGoodsFactoryStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DigitalGoodsFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DigitalGoodsFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT DigitalGoodsRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT DigitalGoodsFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT DigitalGoodsResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT DigitalGoodsFactoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class PLATFORM_EXPORT ItemDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ItemDetails, T>::value>;
  using DataView = ItemDetailsDataView;
  using Data_ = internal::ItemDetails_Data;

  template <typename... Args>
  static ItemDetailsPtr New(Args&&... args) {
    return ItemDetailsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ItemDetailsPtr From(const U& u) {
    return mojo::TypeConverter<ItemDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ItemDetails>::Convert(*this);
  }


  ItemDetails();

  ItemDetails(
      const WTF::String& item_id,
      const WTF::String& title,
      const WTF::String& description,
      ::payments::mojom::blink::PaymentCurrencyAmountPtr price);

  ~ItemDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ItemDetailsPtr>
  ItemDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ItemDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ItemDetails::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ItemDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ItemDetails_UnserializedMessageContext<
            UserType, ItemDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ItemDetails::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ItemDetails::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ItemDetails_UnserializedMessageContext<
            UserType, ItemDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ItemDetails::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String item_id;
  
  WTF::String title;
  
  WTF::String description;
  
  ::payments::mojom::blink::PaymentCurrencyAmountPtr price;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ItemDetails);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ItemDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ItemDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ItemDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ItemDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ItemDetailsPtr ItemDetails::Clone() const {
  return New(
      mojo::Clone(item_id),
      mojo::Clone(title),
      mojo::Clone(description),
      mojo::Clone(price)
  );
}

template <typename T, ItemDetails::EnableIfSame<T>*>
bool ItemDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->item_id, other_struct.item_id))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->price, other_struct.price))
    return false;
  return true;
}

template <typename T, ItemDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.item_id, rhs.item_id))
    return true;
  if (std::less<>{}(rhs.item_id, lhs.item_id))
    return false;
  if (std::less<>{}(lhs.title, rhs.title))
    return true;
  if (std::less<>{}(rhs.title, lhs.title))
    return false;
  if (std::less<>{}(lhs.description, rhs.description))
    return true;
  if (std::less<>{}(rhs.description, lhs.description))
    return false;
  if (std::less<>{}(lhs.price, rhs.price))
    return true;
  if (std::less<>{}(rhs.price, lhs.price))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace payments

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::payments::mojom::blink::ItemDetails::DataView,
                                         ::payments::mojom::blink::ItemDetailsPtr> {
  static bool IsNull(const ::payments::mojom::blink::ItemDetailsPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::blink::ItemDetailsPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::blink::ItemDetails::item_id)& item_id(
      const ::payments::mojom::blink::ItemDetailsPtr& input) {
    return input->item_id;
  }

  static const decltype(::payments::mojom::blink::ItemDetails::title)& title(
      const ::payments::mojom::blink::ItemDetailsPtr& input) {
    return input->title;
  }

  static const decltype(::payments::mojom::blink::ItemDetails::description)& description(
      const ::payments::mojom::blink::ItemDetailsPtr& input) {
    return input->description;
  }

  static const decltype(::payments::mojom::blink::ItemDetails::price)& price(
      const ::payments::mojom::blink::ItemDetailsPtr& input) {
    return input->price;
  }

  static bool Read(::payments::mojom::blink::ItemDetails::DataView input, ::payments::mojom::blink::ItemDetailsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIGITAL_GOODS_DIGITAL_GOODS_MOJOM_BLINK_H_