// gpu/ipc/common/vulkan_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "gpu/ipc/common/vulkan_types.mojom-shared-internal.h"







namespace gpu {
namespace mojom {
class VkExtensionPropertiesDataView;

class VkLayerPropertiesDataView;

class VkPhysicalDeviceLimitsDataView;

class VkPhysicalDeviceSparsePropertiesDataView;

class VkPhysicalDevicePropertiesDataView;

class VkPhysicalDeviceFeaturesDataView;

class VkExtent3DDataView;

class VkQueueFamilyPropertiesDataView;



}  // namespace mojom
}  // namespace gpu

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::VkExtensionPropertiesDataView> {
  using Data = ::gpu::mojom::internal::VkExtensionProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkLayerPropertiesDataView> {
  using Data = ::gpu::mojom::internal::VkLayerProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkPhysicalDeviceLimitsDataView> {
  using Data = ::gpu::mojom::internal::VkPhysicalDeviceLimits_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView> {
  using Data = ::gpu::mojom::internal::VkPhysicalDeviceSparseProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkPhysicalDevicePropertiesDataView> {
  using Data = ::gpu::mojom::internal::VkPhysicalDeviceProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkPhysicalDeviceFeaturesDataView> {
  using Data = ::gpu::mojom::internal::VkPhysicalDeviceFeatures_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkExtent3DDataView> {
  using Data = ::gpu::mojom::internal::VkExtent3D_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkQueueFamilyPropertiesDataView> {
  using Data = ::gpu::mojom::internal::VkQueueFamilyProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu {
namespace mojom {


enum class VkPhysicalDeviceType : int32_t {
  
  OTHER = 0,
  
  INTEGRATED_GPU = 1,
  
  DISCRETE_GPU = 2,
  
  VIRTUAL_GPU = 3,
  
  CPU = 4,
  
  INVALID_VALUE = -1,
  kMinValue = -1,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, VkPhysicalDeviceType value);
inline bool IsKnownEnumValue(VkPhysicalDeviceType value) {
  return internal::VkPhysicalDeviceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class VkExtensionPropertiesDataView {
 public:
  VkExtensionPropertiesDataView() {}

  VkExtensionPropertiesDataView(
      internal::VkExtensionProperties_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadExtensionName(UserType* output) {
    
    auto* pointer = data_->extensionName.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  uint32_t specVersion() const {
    return data_->specVersion;
  }
 private:
  internal::VkExtensionProperties_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VkLayerPropertiesDataView {
 public:
  VkLayerPropertiesDataView() {}

  VkLayerPropertiesDataView(
      internal::VkLayerProperties_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetLayerNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLayerName(UserType* output) {
    
    auto* pointer = data_->layerName.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  uint32_t specVersion() const {
    return data_->specVersion;
  }
  uint32_t implementationVersion() const {
    return data_->implementationVersion;
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::VkLayerProperties_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VkPhysicalDeviceLimitsDataView {
 public:
  VkPhysicalDeviceLimitsDataView() {}

  VkPhysicalDeviceLimitsDataView(
      internal::VkPhysicalDeviceLimits_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint32_t maxImageDimension1D() const {
    return data_->maxImageDimension1D;
  }
  uint32_t maxImageDimension2D() const {
    return data_->maxImageDimension2D;
  }
  uint32_t maxImageDimension3D() const {
    return data_->maxImageDimension3D;
  }
  uint32_t maxImageDimensionCube() const {
    return data_->maxImageDimensionCube;
  }
  uint32_t maxImageArrayLayers() const {
    return data_->maxImageArrayLayers;
  }
  uint32_t maxTexelBufferElements() const {
    return data_->maxTexelBufferElements;
  }
  uint32_t maxUniformBufferRange() const {
    return data_->maxUniformBufferRange;
  }
  uint32_t maxStorageBufferRange() const {
    return data_->maxStorageBufferRange;
  }
  uint32_t maxPushConstantsSize() const {
    return data_->maxPushConstantsSize;
  }
  uint32_t maxMemoryAllocationCount() const {
    return data_->maxMemoryAllocationCount;
  }
  uint32_t maxSamplerAllocationCount() const {
    return data_->maxSamplerAllocationCount;
  }
  uint64_t bufferImageGranularity() const {
    return data_->bufferImageGranularity;
  }
  uint64_t sparseAddressSpaceSize() const {
    return data_->sparseAddressSpaceSize;
  }
  uint32_t maxBoundDescriptorSets() const {
    return data_->maxBoundDescriptorSets;
  }
  uint32_t maxPerStageDescriptorSamplers() const {
    return data_->maxPerStageDescriptorSamplers;
  }
  uint32_t maxPerStageDescriptorUniformBuffers() const {
    return data_->maxPerStageDescriptorUniformBuffers;
  }
  uint32_t maxPerStageDescriptorStorageBuffers() const {
    return data_->maxPerStageDescriptorStorageBuffers;
  }
  uint32_t maxPerStageDescriptorSampledImages() const {
    return data_->maxPerStageDescriptorSampledImages;
  }
  uint32_t maxPerStageDescriptorStorageImages() const {
    return data_->maxPerStageDescriptorStorageImages;
  }
  uint32_t maxPerStageDescriptorInputAttachments() const {
    return data_->maxPerStageDescriptorInputAttachments;
  }
  uint32_t maxPerStageResources() const {
    return data_->maxPerStageResources;
  }
  uint32_t maxDescriptorSetSamplers() const {
    return data_->maxDescriptorSetSamplers;
  }
  uint32_t maxDescriptorSetUniformBuffers() const {
    return data_->maxDescriptorSetUniformBuffers;
  }
  uint32_t maxDescriptorSetUniformBuffersDynamic() const {
    return data_->maxDescriptorSetUniformBuffersDynamic;
  }
  uint32_t maxDescriptorSetStorageBuffers() const {
    return data_->maxDescriptorSetStorageBuffers;
  }
  uint32_t maxDescriptorSetStorageBuffersDynamic() const {
    return data_->maxDescriptorSetStorageBuffersDynamic;
  }
  uint32_t maxDescriptorSetSampledImages() const {
    return data_->maxDescriptorSetSampledImages;
  }
  uint32_t maxDescriptorSetStorageImages() const {
    return data_->maxDescriptorSetStorageImages;
  }
  uint32_t maxDescriptorSetInputAttachments() const {
    return data_->maxDescriptorSetInputAttachments;
  }
  uint32_t maxVertexInputAttributes() const {
    return data_->maxVertexInputAttributes;
  }
  uint32_t maxVertexInputBindings() const {
    return data_->maxVertexInputBindings;
  }
  uint32_t maxVertexInputAttributeOffset() const {
    return data_->maxVertexInputAttributeOffset;
  }
  uint32_t maxVertexInputBindingStride() const {
    return data_->maxVertexInputBindingStride;
  }
  uint32_t maxVertexOutputComponents() const {
    return data_->maxVertexOutputComponents;
  }
  uint32_t maxTessellationGenerationLevel() const {
    return data_->maxTessellationGenerationLevel;
  }
  uint32_t maxTessellationPatchSize() const {
    return data_->maxTessellationPatchSize;
  }
  uint32_t maxTessellationControlPerVertexInputComponents() const {
    return data_->maxTessellationControlPerVertexInputComponents;
  }
  uint32_t maxTessellationControlPerVertexOutputComponents() const {
    return data_->maxTessellationControlPerVertexOutputComponents;
  }
  uint32_t maxTessellationControlPerPatchOutputComponents() const {
    return data_->maxTessellationControlPerPatchOutputComponents;
  }
  uint32_t maxTessellationControlTotalOutputComponents() const {
    return data_->maxTessellationControlTotalOutputComponents;
  }
  uint32_t maxTessellationEvaluationInputComponents() const {
    return data_->maxTessellationEvaluationInputComponents;
  }
  uint32_t maxTessellationEvaluationOutputComponents() const {
    return data_->maxTessellationEvaluationOutputComponents;
  }
  uint32_t maxGeometryShaderInvocations() const {
    return data_->maxGeometryShaderInvocations;
  }
  uint32_t maxGeometryInputComponents() const {
    return data_->maxGeometryInputComponents;
  }
  uint32_t maxGeometryOutputComponents() const {
    return data_->maxGeometryOutputComponents;
  }
  uint32_t maxGeometryOutputVertices() const {
    return data_->maxGeometryOutputVertices;
  }
  uint32_t maxGeometryTotalOutputComponents() const {
    return data_->maxGeometryTotalOutputComponents;
  }
  uint32_t maxFragmentInputComponents() const {
    return data_->maxFragmentInputComponents;
  }
  uint32_t maxFragmentOutputAttachments() const {
    return data_->maxFragmentOutputAttachments;
  }
  uint32_t maxFragmentDualSrcAttachments() const {
    return data_->maxFragmentDualSrcAttachments;
  }
  uint32_t maxFragmentCombinedOutputResources() const {
    return data_->maxFragmentCombinedOutputResources;
  }
  uint32_t maxComputeSharedMemorySize() const {
    return data_->maxComputeSharedMemorySize;
  }
  inline void GetMaxComputeWorkGroupCountDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMaxComputeWorkGroupCount(UserType* output) {
    
    auto* pointer = data_->maxComputeWorkGroupCount.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, context_);
  }
  uint32_t maxComputeWorkGroupInvocations() const {
    return data_->maxComputeWorkGroupInvocations;
  }
  inline void GetMaxComputeWorkGroupSizeDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMaxComputeWorkGroupSize(UserType* output) {
    
    auto* pointer = data_->maxComputeWorkGroupSize.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, context_);
  }
  uint32_t subPixelPrecisionBits() const {
    return data_->subPixelPrecisionBits;
  }
  uint32_t subTexelPrecisionBits() const {
    return data_->subTexelPrecisionBits;
  }
  uint32_t mipmapPrecisionBits() const {
    return data_->mipmapPrecisionBits;
  }
  uint32_t maxDrawIndexedIndexValue() const {
    return data_->maxDrawIndexedIndexValue;
  }
  uint32_t maxDrawIndirectCount() const {
    return data_->maxDrawIndirectCount;
  }
  float maxSamplerLodBias() const {
    return data_->maxSamplerLodBias;
  }
  float maxSamplerAnisotropy() const {
    return data_->maxSamplerAnisotropy;
  }
  uint32_t maxViewports() const {
    return data_->maxViewports;
  }
  inline void GetMaxViewportDimensionsDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMaxViewportDimensions(UserType* output) {
    
    auto* pointer = data_->maxViewportDimensions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, context_);
  }
  inline void GetViewportBoundsRangeDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadViewportBoundsRange(UserType* output) {
    
    auto* pointer = data_->viewportBoundsRange.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, context_);
  }
  uint32_t viewportSubPixelBits() const {
    return data_->viewportSubPixelBits;
  }
  uint64_t minMemoryMapAlignment() const {
    return data_->minMemoryMapAlignment;
  }
  uint64_t minTexelBufferOffsetAlignment() const {
    return data_->minTexelBufferOffsetAlignment;
  }
  uint64_t minUniformBufferOffsetAlignment() const {
    return data_->minUniformBufferOffsetAlignment;
  }
  uint64_t minStorageBufferOffsetAlignment() const {
    return data_->minStorageBufferOffsetAlignment;
  }
  int32_t minTexelOffset() const {
    return data_->minTexelOffset;
  }
  uint32_t maxTexelOffset() const {
    return data_->maxTexelOffset;
  }
  int32_t minTexelGatherOffset() const {
    return data_->minTexelGatherOffset;
  }
  uint32_t maxTexelGatherOffset() const {
    return data_->maxTexelGatherOffset;
  }
  float minInterpolationOffset() const {
    return data_->minInterpolationOffset;
  }
  float maxInterpolationOffset() const {
    return data_->maxInterpolationOffset;
  }
  uint32_t subPixelInterpolationOffsetBits() const {
    return data_->subPixelInterpolationOffsetBits;
  }
  uint32_t maxFramebufferWidth() const {
    return data_->maxFramebufferWidth;
  }
  uint32_t maxFramebufferHeight() const {
    return data_->maxFramebufferHeight;
  }
  uint32_t maxFramebufferLayers() const {
    return data_->maxFramebufferLayers;
  }
  uint32_t framebufferColorSampleCounts() const {
    return data_->framebufferColorSampleCounts;
  }
  uint32_t framebufferDepthSampleCounts() const {
    return data_->framebufferDepthSampleCounts;
  }
  uint32_t framebufferStencilSampleCounts() const {
    return data_->framebufferStencilSampleCounts;
  }
  uint32_t framebufferNoAttachmentsSampleCounts() const {
    return data_->framebufferNoAttachmentsSampleCounts;
  }
  uint32_t maxColorAttachments() const {
    return data_->maxColorAttachments;
  }
  uint32_t sampledImageColorSampleCounts() const {
    return data_->sampledImageColorSampleCounts;
  }
  uint32_t sampledImageIntegerSampleCounts() const {
    return data_->sampledImageIntegerSampleCounts;
  }
  uint32_t sampledImageDepthSampleCounts() const {
    return data_->sampledImageDepthSampleCounts;
  }
  uint32_t sampledImageStencilSampleCounts() const {
    return data_->sampledImageStencilSampleCounts;
  }
  uint32_t storageImageSampleCounts() const {
    return data_->storageImageSampleCounts;
  }
  uint32_t maxSampleMaskWords() const {
    return data_->maxSampleMaskWords;
  }
  bool timestampComputeAndGraphics() const {
    return data_->timestampComputeAndGraphics;
  }
  float timestampPeriod() const {
    return data_->timestampPeriod;
  }
  uint32_t maxClipDistances() const {
    return data_->maxClipDistances;
  }
  uint32_t maxCullDistances() const {
    return data_->maxCullDistances;
  }
  uint32_t maxCombinedClipAndCullDistances() const {
    return data_->maxCombinedClipAndCullDistances;
  }
  uint32_t discreteQueuePriorities() const {
    return data_->discreteQueuePriorities;
  }
  inline void GetPointSizeRangeDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPointSizeRange(UserType* output) {
    
    auto* pointer = data_->pointSizeRange.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, context_);
  }
  inline void GetLineWidthRangeDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLineWidthRange(UserType* output) {
    
    auto* pointer = data_->lineWidthRange.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, context_);
  }
  float pointSizeGranularity() const {
    return data_->pointSizeGranularity;
  }
  float lineWidthGranularity() const {
    return data_->lineWidthGranularity;
  }
  bool strictLines() const {
    return data_->strictLines;
  }
  bool standardSampleLocations() const {
    return data_->standardSampleLocations;
  }
  uint64_t optimalBufferCopyOffsetAlignment() const {
    return data_->optimalBufferCopyOffsetAlignment;
  }
  uint64_t optimalBufferCopyRowPitchAlignment() const {
    return data_->optimalBufferCopyRowPitchAlignment;
  }
  uint64_t nonCoherentAtomSize() const {
    return data_->nonCoherentAtomSize;
  }
 private:
  internal::VkPhysicalDeviceLimits_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VkPhysicalDeviceSparsePropertiesDataView {
 public:
  VkPhysicalDeviceSparsePropertiesDataView() {}

  VkPhysicalDeviceSparsePropertiesDataView(
      internal::VkPhysicalDeviceSparseProperties_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool residencyStandard2DBlockShape() const {
    return data_->residencyStandard2DBlockShape;
  }
  bool residencyStandard2DMultisampleBlockShape() const {
    return data_->residencyStandard2DMultisampleBlockShape;
  }
  bool residencyStandard3DBlockShape() const {
    return data_->residencyStandard3DBlockShape;
  }
  bool residencyAlignedMipSize() const {
    return data_->residencyAlignedMipSize;
  }
  bool residencyNonResidentStrict() const {
    return data_->residencyNonResidentStrict;
  }
 private:
  internal::VkPhysicalDeviceSparseProperties_Data* data_ = nullptr;
};



class VkPhysicalDevicePropertiesDataView {
 public:
  VkPhysicalDevicePropertiesDataView() {}

  VkPhysicalDevicePropertiesDataView(
      internal::VkPhysicalDeviceProperties_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint32_t apiVersion() const {
    return data_->apiVersion;
  }
  uint32_t driverVersion() const {
    return data_->driverVersion;
  }
  uint32_t vendorID() const {
    return data_->vendorID;
  }
  uint32_t deviceID() const {
    return data_->deviceID;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDeviceType(UserType* output) const {
    auto data_value = data_->deviceType;
    return mojo::internal::Deserialize<::gpu::mojom::VkPhysicalDeviceType>(
        data_value, output);
  }

  VkPhysicalDeviceType deviceType() const {
    return static_cast<VkPhysicalDeviceType>(data_->deviceType);
  }
  inline void GetDeviceNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDeviceName(UserType* output) {
    
    auto* pointer = data_->deviceName.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetPipelineCacheUuidDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPipelineCacheUuid(UserType* output) {
    
    auto* pointer = data_->pipelineCacheUUID.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
  inline void GetLimitsDataView(
      VkPhysicalDeviceLimitsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLimits(UserType* output) {
    
    auto* pointer = data_->limits.Get();
    return mojo::internal::Deserialize<::gpu::mojom::VkPhysicalDeviceLimitsDataView>(
        pointer, output, context_);
  }
  inline void GetSparsePropertiesDataView(
      VkPhysicalDeviceSparsePropertiesDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSparseProperties(UserType* output) {
    
    auto* pointer = data_->sparseProperties.Get();
    return mojo::internal::Deserialize<::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView>(
        pointer, output, context_);
  }
 private:
  internal::VkPhysicalDeviceProperties_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VkPhysicalDeviceFeaturesDataView {
 public:
  VkPhysicalDeviceFeaturesDataView() {}

  VkPhysicalDeviceFeaturesDataView(
      internal::VkPhysicalDeviceFeatures_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool robustBufferAccess() const {
    return data_->robustBufferAccess;
  }
  bool fullDrawIndexUint32() const {
    return data_->fullDrawIndexUint32;
  }
  bool imageCubeArray() const {
    return data_->imageCubeArray;
  }
  bool independentBlend() const {
    return data_->independentBlend;
  }
  bool geometryShader() const {
    return data_->geometryShader;
  }
  bool tessellationShader() const {
    return data_->tessellationShader;
  }
  bool sampleRateShading() const {
    return data_->sampleRateShading;
  }
  bool dualSrcBlend() const {
    return data_->dualSrcBlend;
  }
  bool logicOp() const {
    return data_->logicOp;
  }
  bool multiDrawIndirect() const {
    return data_->multiDrawIndirect;
  }
  bool drawIndirectFirstInstance() const {
    return data_->drawIndirectFirstInstance;
  }
  bool depthClamp() const {
    return data_->depthClamp;
  }
  bool depthBiasClamp() const {
    return data_->depthBiasClamp;
  }
  bool fillModeNonSolid() const {
    return data_->fillModeNonSolid;
  }
  bool depthBounds() const {
    return data_->depthBounds;
  }
  bool wideLines() const {
    return data_->wideLines;
  }
  bool largePoints() const {
    return data_->largePoints;
  }
  bool alphaToOne() const {
    return data_->alphaToOne;
  }
  bool multiViewport() const {
    return data_->multiViewport;
  }
  bool samplerAnisotropy() const {
    return data_->samplerAnisotropy;
  }
  bool textureCompressionETC2() const {
    return data_->textureCompressionETC2;
  }
  bool textureCompressionASTC_LDR() const {
    return data_->textureCompressionASTC_LDR;
  }
  bool textureCompressionBC() const {
    return data_->textureCompressionBC;
  }
  bool occlusionQueryPrecise() const {
    return data_->occlusionQueryPrecise;
  }
  bool pipelineStatisticsQuery() const {
    return data_->pipelineStatisticsQuery;
  }
  bool vertexPipelineStoresAndAtomics() const {
    return data_->vertexPipelineStoresAndAtomics;
  }
  bool fragmentStoresAndAtomics() const {
    return data_->fragmentStoresAndAtomics;
  }
  bool shaderTessellationAndGeometryPointSize() const {
    return data_->shaderTessellationAndGeometryPointSize;
  }
  bool shaderImageGatherExtended() const {
    return data_->shaderImageGatherExtended;
  }
  bool shaderStorageImageExtendedFormats() const {
    return data_->shaderStorageImageExtendedFormats;
  }
  bool shaderStorageImageMultisample() const {
    return data_->shaderStorageImageMultisample;
  }
  bool shaderStorageImageReadWithoutFormat() const {
    return data_->shaderStorageImageReadWithoutFormat;
  }
  bool shaderStorageImageWriteWithoutFormat() const {
    return data_->shaderStorageImageWriteWithoutFormat;
  }
  bool shaderUniformBufferArrayDynamicIndexing() const {
    return data_->shaderUniformBufferArrayDynamicIndexing;
  }
  bool shaderSampledImageArrayDynamicIndexing() const {
    return data_->shaderSampledImageArrayDynamicIndexing;
  }
  bool shaderStorageBufferArrayDynamicIndexing() const {
    return data_->shaderStorageBufferArrayDynamicIndexing;
  }
  bool shaderStorageImageArrayDynamicIndexing() const {
    return data_->shaderStorageImageArrayDynamicIndexing;
  }
  bool shaderClipDistance() const {
    return data_->shaderClipDistance;
  }
  bool shaderCullDistance() const {
    return data_->shaderCullDistance;
  }
  bool shaderFloat64() const {
    return data_->shaderFloat64;
  }
  bool shaderInt64() const {
    return data_->shaderInt64;
  }
  bool shaderInt16() const {
    return data_->shaderInt16;
  }
  bool shaderResourceResidency() const {
    return data_->shaderResourceResidency;
  }
  bool shaderResourceMinLod() const {
    return data_->shaderResourceMinLod;
  }
  bool sparseBinding() const {
    return data_->sparseBinding;
  }
  bool sparseResidencyBuffer() const {
    return data_->sparseResidencyBuffer;
  }
  bool sparseResidencyImage2D() const {
    return data_->sparseResidencyImage2D;
  }
  bool sparseResidencyImage3D() const {
    return data_->sparseResidencyImage3D;
  }
  bool sparseResidency2Samples() const {
    return data_->sparseResidency2Samples;
  }
  bool sparseResidency4Samples() const {
    return data_->sparseResidency4Samples;
  }
  bool sparseResidency8Samples() const {
    return data_->sparseResidency8Samples;
  }
  bool sparseResidency16Samples() const {
    return data_->sparseResidency16Samples;
  }
  bool sparseResidencyAliased() const {
    return data_->sparseResidencyAliased;
  }
  bool variableMultisampleRate() const {
    return data_->variableMultisampleRate;
  }
  bool inheritedQueries() const {
    return data_->inheritedQueries;
  }
 private:
  internal::VkPhysicalDeviceFeatures_Data* data_ = nullptr;
};



class VkExtent3DDataView {
 public:
  VkExtent3DDataView() {}

  VkExtent3DDataView(
      internal::VkExtent3D_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t width() const {
    return data_->width;
  }
  uint32_t height() const {
    return data_->height;
  }
  uint32_t depth() const {
    return data_->depth;
  }
 private:
  internal::VkExtent3D_Data* data_ = nullptr;
};



class VkQueueFamilyPropertiesDataView {
 public:
  VkQueueFamilyPropertiesDataView() {}

  VkQueueFamilyPropertiesDataView(
      internal::VkQueueFamilyProperties_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint32_t queueFlags() const {
    return data_->queueFlags;
  }
  uint32_t queueCount() const {
    return data_->queueCount;
  }
  uint32_t timestampValidBits() const {
    return data_->timestampValidBits;
  }
  inline void GetMinImageTransferGranularityDataView(
      VkExtent3DDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMinImageTransferGranularity(UserType* output) {
    
    auto* pointer = data_->minImageTransferGranularity.Get();
    return mojo::internal::Deserialize<::gpu::mojom::VkExtent3DDataView>(
        pointer, output, context_);
  }
 private:
  internal::VkQueueFamilyProperties_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace gpu

namespace std {

template <>
struct hash<::gpu::mojom::VkPhysicalDeviceType>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::VkPhysicalDeviceType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::gpu::mojom::VkPhysicalDeviceType, ::gpu::mojom::VkPhysicalDeviceType> {
  static ::gpu::mojom::VkPhysicalDeviceType ToMojom(::gpu::mojom::VkPhysicalDeviceType input) { return input; }
  static bool FromMojom(::gpu::mojom::VkPhysicalDeviceType input, ::gpu::mojom::VkPhysicalDeviceType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkPhysicalDeviceType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::VkPhysicalDeviceType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::gpu::mojom::VkPhysicalDeviceType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkExtensionPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkExtensionPropertiesDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gpu::mojom::internal::VkExtensionProperties_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::extensionName(input)) in_extensionName = Traits::extensionName(input);
    typename decltype((*output)->extensionName)::BaseType::BufferWriter
        extensionName_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_extensionName, buffer, &extensionName_writer, context);
    (*output)->extensionName.Set(
        extensionName_writer.is_null() ? nullptr : extensionName_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->extensionName.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extensionName in VkExtensionProperties struct");
    (*output)->specVersion = Traits::specVersion(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VkExtensionProperties_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkExtensionPropertiesDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkLayerPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkLayerPropertiesDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gpu::mojom::internal::VkLayerProperties_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::layerName(input)) in_layerName = Traits::layerName(input);
    typename decltype((*output)->layerName)::BaseType::BufferWriter
        layerName_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_layerName, buffer, &layerName_writer, context);
    (*output)->layerName.Set(
        layerName_writer.is_null() ? nullptr : layerName_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->layerName.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null layerName in VkLayerProperties struct");
    (*output)->specVersion = Traits::specVersion(input);
    (*output)->implementationVersion = Traits::implementationVersion(input);
    decltype(Traits::description(input)) in_description = Traits::description(input);
    typename decltype((*output)->description)::BaseType::BufferWriter
        description_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_description, buffer, &description_writer, context);
    (*output)->description.Set(
        description_writer.is_null() ? nullptr : description_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->description.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null description in VkLayerProperties struct");
  }

  static bool Deserialize(::gpu::mojom::internal::VkLayerProperties_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkLayerPropertiesDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkPhysicalDeviceLimitsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkPhysicalDeviceLimitsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gpu::mojom::internal::VkPhysicalDeviceLimits_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->maxImageDimension1D = Traits::maxImageDimension1D(input);
    (*output)->maxImageDimension2D = Traits::maxImageDimension2D(input);
    (*output)->maxImageDimension3D = Traits::maxImageDimension3D(input);
    (*output)->maxImageDimensionCube = Traits::maxImageDimensionCube(input);
    (*output)->maxImageArrayLayers = Traits::maxImageArrayLayers(input);
    (*output)->maxTexelBufferElements = Traits::maxTexelBufferElements(input);
    (*output)->maxUniformBufferRange = Traits::maxUniformBufferRange(input);
    (*output)->maxStorageBufferRange = Traits::maxStorageBufferRange(input);
    (*output)->maxPushConstantsSize = Traits::maxPushConstantsSize(input);
    (*output)->maxMemoryAllocationCount = Traits::maxMemoryAllocationCount(input);
    (*output)->maxSamplerAllocationCount = Traits::maxSamplerAllocationCount(input);
    (*output)->bufferImageGranularity = Traits::bufferImageGranularity(input);
    (*output)->sparseAddressSpaceSize = Traits::sparseAddressSpaceSize(input);
    (*output)->maxBoundDescriptorSets = Traits::maxBoundDescriptorSets(input);
    (*output)->maxPerStageDescriptorSamplers = Traits::maxPerStageDescriptorSamplers(input);
    (*output)->maxPerStageDescriptorUniformBuffers = Traits::maxPerStageDescriptorUniformBuffers(input);
    (*output)->maxPerStageDescriptorStorageBuffers = Traits::maxPerStageDescriptorStorageBuffers(input);
    (*output)->maxPerStageDescriptorSampledImages = Traits::maxPerStageDescriptorSampledImages(input);
    (*output)->maxPerStageDescriptorStorageImages = Traits::maxPerStageDescriptorStorageImages(input);
    (*output)->maxPerStageDescriptorInputAttachments = Traits::maxPerStageDescriptorInputAttachments(input);
    (*output)->maxPerStageResources = Traits::maxPerStageResources(input);
    (*output)->maxDescriptorSetSamplers = Traits::maxDescriptorSetSamplers(input);
    (*output)->maxDescriptorSetUniformBuffers = Traits::maxDescriptorSetUniformBuffers(input);
    (*output)->maxDescriptorSetUniformBuffersDynamic = Traits::maxDescriptorSetUniformBuffersDynamic(input);
    (*output)->maxDescriptorSetStorageBuffers = Traits::maxDescriptorSetStorageBuffers(input);
    (*output)->maxDescriptorSetStorageBuffersDynamic = Traits::maxDescriptorSetStorageBuffersDynamic(input);
    (*output)->maxDescriptorSetSampledImages = Traits::maxDescriptorSetSampledImages(input);
    (*output)->maxDescriptorSetStorageImages = Traits::maxDescriptorSetStorageImages(input);
    (*output)->maxDescriptorSetInputAttachments = Traits::maxDescriptorSetInputAttachments(input);
    (*output)->maxVertexInputAttributes = Traits::maxVertexInputAttributes(input);
    (*output)->maxVertexInputBindings = Traits::maxVertexInputBindings(input);
    (*output)->maxVertexInputAttributeOffset = Traits::maxVertexInputAttributeOffset(input);
    (*output)->maxVertexInputBindingStride = Traits::maxVertexInputBindingStride(input);
    (*output)->maxVertexOutputComponents = Traits::maxVertexOutputComponents(input);
    (*output)->maxTessellationGenerationLevel = Traits::maxTessellationGenerationLevel(input);
    (*output)->maxTessellationPatchSize = Traits::maxTessellationPatchSize(input);
    (*output)->maxTessellationControlPerVertexInputComponents = Traits::maxTessellationControlPerVertexInputComponents(input);
    (*output)->maxTessellationControlPerVertexOutputComponents = Traits::maxTessellationControlPerVertexOutputComponents(input);
    (*output)->maxTessellationControlPerPatchOutputComponents = Traits::maxTessellationControlPerPatchOutputComponents(input);
    (*output)->maxTessellationControlTotalOutputComponents = Traits::maxTessellationControlTotalOutputComponents(input);
    (*output)->maxTessellationEvaluationInputComponents = Traits::maxTessellationEvaluationInputComponents(input);
    (*output)->maxTessellationEvaluationOutputComponents = Traits::maxTessellationEvaluationOutputComponents(input);
    (*output)->maxGeometryShaderInvocations = Traits::maxGeometryShaderInvocations(input);
    (*output)->maxGeometryInputComponents = Traits::maxGeometryInputComponents(input);
    (*output)->maxGeometryOutputComponents = Traits::maxGeometryOutputComponents(input);
    (*output)->maxGeometryOutputVertices = Traits::maxGeometryOutputVertices(input);
    (*output)->maxGeometryTotalOutputComponents = Traits::maxGeometryTotalOutputComponents(input);
    (*output)->maxFragmentInputComponents = Traits::maxFragmentInputComponents(input);
    (*output)->maxFragmentOutputAttachments = Traits::maxFragmentOutputAttachments(input);
    (*output)->maxFragmentDualSrcAttachments = Traits::maxFragmentDualSrcAttachments(input);
    (*output)->maxFragmentCombinedOutputResources = Traits::maxFragmentCombinedOutputResources(input);
    (*output)->maxComputeSharedMemorySize = Traits::maxComputeSharedMemorySize(input);
    decltype(Traits::maxComputeWorkGroupCount(input)) in_maxComputeWorkGroupCount = Traits::maxComputeWorkGroupCount(input);
    typename decltype((*output)->maxComputeWorkGroupCount)::BaseType::BufferWriter
        maxComputeWorkGroupCount_writer;
    const mojo::internal::ContainerValidateParams maxComputeWorkGroupCount_validate_params(
        3, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
        in_maxComputeWorkGroupCount, buffer, &maxComputeWorkGroupCount_writer, &maxComputeWorkGroupCount_validate_params,
        context);
    (*output)->maxComputeWorkGroupCount.Set(
        maxComputeWorkGroupCount_writer.is_null() ? nullptr : maxComputeWorkGroupCount_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->maxComputeWorkGroupCount.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null maxComputeWorkGroupCount in VkPhysicalDeviceLimits struct");
    (*output)->maxComputeWorkGroupInvocations = Traits::maxComputeWorkGroupInvocations(input);
    decltype(Traits::maxComputeWorkGroupSize(input)) in_maxComputeWorkGroupSize = Traits::maxComputeWorkGroupSize(input);
    typename decltype((*output)->maxComputeWorkGroupSize)::BaseType::BufferWriter
        maxComputeWorkGroupSize_writer;
    const mojo::internal::ContainerValidateParams maxComputeWorkGroupSize_validate_params(
        3, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
        in_maxComputeWorkGroupSize, buffer, &maxComputeWorkGroupSize_writer, &maxComputeWorkGroupSize_validate_params,
        context);
    (*output)->maxComputeWorkGroupSize.Set(
        maxComputeWorkGroupSize_writer.is_null() ? nullptr : maxComputeWorkGroupSize_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->maxComputeWorkGroupSize.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null maxComputeWorkGroupSize in VkPhysicalDeviceLimits struct");
    (*output)->subPixelPrecisionBits = Traits::subPixelPrecisionBits(input);
    (*output)->subTexelPrecisionBits = Traits::subTexelPrecisionBits(input);
    (*output)->mipmapPrecisionBits = Traits::mipmapPrecisionBits(input);
    (*output)->maxDrawIndexedIndexValue = Traits::maxDrawIndexedIndexValue(input);
    (*output)->maxDrawIndirectCount = Traits::maxDrawIndirectCount(input);
    (*output)->maxSamplerLodBias = Traits::maxSamplerLodBias(input);
    (*output)->maxSamplerAnisotropy = Traits::maxSamplerAnisotropy(input);
    (*output)->maxViewports = Traits::maxViewports(input);
    decltype(Traits::maxViewportDimensions(input)) in_maxViewportDimensions = Traits::maxViewportDimensions(input);
    typename decltype((*output)->maxViewportDimensions)::BaseType::BufferWriter
        maxViewportDimensions_writer;
    const mojo::internal::ContainerValidateParams maxViewportDimensions_validate_params(
        2, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
        in_maxViewportDimensions, buffer, &maxViewportDimensions_writer, &maxViewportDimensions_validate_params,
        context);
    (*output)->maxViewportDimensions.Set(
        maxViewportDimensions_writer.is_null() ? nullptr : maxViewportDimensions_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->maxViewportDimensions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null maxViewportDimensions in VkPhysicalDeviceLimits struct");
    decltype(Traits::viewportBoundsRange(input)) in_viewportBoundsRange = Traits::viewportBoundsRange(input);
    typename decltype((*output)->viewportBoundsRange)::BaseType::BufferWriter
        viewportBoundsRange_writer;
    const mojo::internal::ContainerValidateParams viewportBoundsRange_validate_params(
        2, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
        in_viewportBoundsRange, buffer, &viewportBoundsRange_writer, &viewportBoundsRange_validate_params,
        context);
    (*output)->viewportBoundsRange.Set(
        viewportBoundsRange_writer.is_null() ? nullptr : viewportBoundsRange_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->viewportBoundsRange.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null viewportBoundsRange in VkPhysicalDeviceLimits struct");
    (*output)->viewportSubPixelBits = Traits::viewportSubPixelBits(input);
    (*output)->minMemoryMapAlignment = Traits::minMemoryMapAlignment(input);
    (*output)->minTexelBufferOffsetAlignment = Traits::minTexelBufferOffsetAlignment(input);
    (*output)->minUniformBufferOffsetAlignment = Traits::minUniformBufferOffsetAlignment(input);
    (*output)->minStorageBufferOffsetAlignment = Traits::minStorageBufferOffsetAlignment(input);
    (*output)->minTexelOffset = Traits::minTexelOffset(input);
    (*output)->maxTexelOffset = Traits::maxTexelOffset(input);
    (*output)->minTexelGatherOffset = Traits::minTexelGatherOffset(input);
    (*output)->maxTexelGatherOffset = Traits::maxTexelGatherOffset(input);
    (*output)->minInterpolationOffset = Traits::minInterpolationOffset(input);
    (*output)->maxInterpolationOffset = Traits::maxInterpolationOffset(input);
    (*output)->subPixelInterpolationOffsetBits = Traits::subPixelInterpolationOffsetBits(input);
    (*output)->maxFramebufferWidth = Traits::maxFramebufferWidth(input);
    (*output)->maxFramebufferHeight = Traits::maxFramebufferHeight(input);
    (*output)->maxFramebufferLayers = Traits::maxFramebufferLayers(input);
    (*output)->framebufferColorSampleCounts = Traits::framebufferColorSampleCounts(input);
    (*output)->framebufferDepthSampleCounts = Traits::framebufferDepthSampleCounts(input);
    (*output)->framebufferStencilSampleCounts = Traits::framebufferStencilSampleCounts(input);
    (*output)->framebufferNoAttachmentsSampleCounts = Traits::framebufferNoAttachmentsSampleCounts(input);
    (*output)->maxColorAttachments = Traits::maxColorAttachments(input);
    (*output)->sampledImageColorSampleCounts = Traits::sampledImageColorSampleCounts(input);
    (*output)->sampledImageIntegerSampleCounts = Traits::sampledImageIntegerSampleCounts(input);
    (*output)->sampledImageDepthSampleCounts = Traits::sampledImageDepthSampleCounts(input);
    (*output)->sampledImageStencilSampleCounts = Traits::sampledImageStencilSampleCounts(input);
    (*output)->storageImageSampleCounts = Traits::storageImageSampleCounts(input);
    (*output)->maxSampleMaskWords = Traits::maxSampleMaskWords(input);
    (*output)->timestampComputeAndGraphics = Traits::timestampComputeAndGraphics(input);
    (*output)->timestampPeriod = Traits::timestampPeriod(input);
    (*output)->maxClipDistances = Traits::maxClipDistances(input);
    (*output)->maxCullDistances = Traits::maxCullDistances(input);
    (*output)->maxCombinedClipAndCullDistances = Traits::maxCombinedClipAndCullDistances(input);
    (*output)->discreteQueuePriorities = Traits::discreteQueuePriorities(input);
    decltype(Traits::pointSizeRange(input)) in_pointSizeRange = Traits::pointSizeRange(input);
    typename decltype((*output)->pointSizeRange)::BaseType::BufferWriter
        pointSizeRange_writer;
    const mojo::internal::ContainerValidateParams pointSizeRange_validate_params(
        2, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
        in_pointSizeRange, buffer, &pointSizeRange_writer, &pointSizeRange_validate_params,
        context);
    (*output)->pointSizeRange.Set(
        pointSizeRange_writer.is_null() ? nullptr : pointSizeRange_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->pointSizeRange.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pointSizeRange in VkPhysicalDeviceLimits struct");
    decltype(Traits::lineWidthRange(input)) in_lineWidthRange = Traits::lineWidthRange(input);
    typename decltype((*output)->lineWidthRange)::BaseType::BufferWriter
        lineWidthRange_writer;
    const mojo::internal::ContainerValidateParams lineWidthRange_validate_params(
        2, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
        in_lineWidthRange, buffer, &lineWidthRange_writer, &lineWidthRange_validate_params,
        context);
    (*output)->lineWidthRange.Set(
        lineWidthRange_writer.is_null() ? nullptr : lineWidthRange_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->lineWidthRange.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lineWidthRange in VkPhysicalDeviceLimits struct");
    (*output)->pointSizeGranularity = Traits::pointSizeGranularity(input);
    (*output)->lineWidthGranularity = Traits::lineWidthGranularity(input);
    (*output)->strictLines = Traits::strictLines(input);
    (*output)->standardSampleLocations = Traits::standardSampleLocations(input);
    (*output)->optimalBufferCopyOffsetAlignment = Traits::optimalBufferCopyOffsetAlignment(input);
    (*output)->optimalBufferCopyRowPitchAlignment = Traits::optimalBufferCopyRowPitchAlignment(input);
    (*output)->nonCoherentAtomSize = Traits::nonCoherentAtomSize(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VkPhysicalDeviceLimits_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkPhysicalDeviceLimitsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gpu::mojom::internal::VkPhysicalDeviceSparseProperties_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->residencyStandard2DBlockShape = Traits::residencyStandard2DBlockShape(input);
    (*output)->residencyStandard2DMultisampleBlockShape = Traits::residencyStandard2DMultisampleBlockShape(input);
    (*output)->residencyStandard3DBlockShape = Traits::residencyStandard3DBlockShape(input);
    (*output)->residencyAlignedMipSize = Traits::residencyAlignedMipSize(input);
    (*output)->residencyNonResidentStrict = Traits::residencyNonResidentStrict(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VkPhysicalDeviceSparseProperties_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkPhysicalDevicePropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkPhysicalDevicePropertiesDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gpu::mojom::internal::VkPhysicalDeviceProperties_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->apiVersion = Traits::apiVersion(input);
    (*output)->driverVersion = Traits::driverVersion(input);
    (*output)->vendorID = Traits::vendorID(input);
    (*output)->deviceID = Traits::deviceID(input);
    mojo::internal::Serialize<::gpu::mojom::VkPhysicalDeviceType>(
        Traits::deviceType(input), &(*output)->deviceType);
    decltype(Traits::deviceName(input)) in_deviceName = Traits::deviceName(input);
    typename decltype((*output)->deviceName)::BaseType::BufferWriter
        deviceName_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_deviceName, buffer, &deviceName_writer, context);
    (*output)->deviceName.Set(
        deviceName_writer.is_null() ? nullptr : deviceName_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->deviceName.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null deviceName in VkPhysicalDeviceProperties struct");
    decltype(Traits::pipelineCacheUUID(input)) in_pipelineCacheUUID = Traits::pipelineCacheUUID(input);
    typename decltype((*output)->pipelineCacheUUID)::BaseType::BufferWriter
        pipelineCacheUUID_writer;
    const mojo::internal::ContainerValidateParams pipelineCacheUUID_validate_params(
        16, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_pipelineCacheUUID, buffer, &pipelineCacheUUID_writer, &pipelineCacheUUID_validate_params,
        context);
    (*output)->pipelineCacheUUID.Set(
        pipelineCacheUUID_writer.is_null() ? nullptr : pipelineCacheUUID_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->pipelineCacheUUID.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pipelineCacheUUID in VkPhysicalDeviceProperties struct");
    decltype(Traits::limits(input)) in_limits = Traits::limits(input);
    typename decltype((*output)->limits)::BaseType::BufferWriter
        limits_writer;
    mojo::internal::Serialize<::gpu::mojom::VkPhysicalDeviceLimitsDataView>(
        in_limits, buffer, &limits_writer, context);
    (*output)->limits.Set(
        limits_writer.is_null() ? nullptr : limits_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->limits.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null limits in VkPhysicalDeviceProperties struct");
    decltype(Traits::sparseProperties(input)) in_sparseProperties = Traits::sparseProperties(input);
    typename decltype((*output)->sparseProperties)::BaseType::BufferWriter
        sparseProperties_writer;
    mojo::internal::Serialize<::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView>(
        in_sparseProperties, buffer, &sparseProperties_writer, context);
    (*output)->sparseProperties.Set(
        sparseProperties_writer.is_null() ? nullptr : sparseProperties_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->sparseProperties.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sparseProperties in VkPhysicalDeviceProperties struct");
  }

  static bool Deserialize(::gpu::mojom::internal::VkPhysicalDeviceProperties_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkPhysicalDevicePropertiesDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkPhysicalDeviceFeaturesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkPhysicalDeviceFeaturesDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gpu::mojom::internal::VkPhysicalDeviceFeatures_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->robustBufferAccess = Traits::robustBufferAccess(input);
    (*output)->fullDrawIndexUint32 = Traits::fullDrawIndexUint32(input);
    (*output)->imageCubeArray = Traits::imageCubeArray(input);
    (*output)->independentBlend = Traits::independentBlend(input);
    (*output)->geometryShader = Traits::geometryShader(input);
    (*output)->tessellationShader = Traits::tessellationShader(input);
    (*output)->sampleRateShading = Traits::sampleRateShading(input);
    (*output)->dualSrcBlend = Traits::dualSrcBlend(input);
    (*output)->logicOp = Traits::logicOp(input);
    (*output)->multiDrawIndirect = Traits::multiDrawIndirect(input);
    (*output)->drawIndirectFirstInstance = Traits::drawIndirectFirstInstance(input);
    (*output)->depthClamp = Traits::depthClamp(input);
    (*output)->depthBiasClamp = Traits::depthBiasClamp(input);
    (*output)->fillModeNonSolid = Traits::fillModeNonSolid(input);
    (*output)->depthBounds = Traits::depthBounds(input);
    (*output)->wideLines = Traits::wideLines(input);
    (*output)->largePoints = Traits::largePoints(input);
    (*output)->alphaToOne = Traits::alphaToOne(input);
    (*output)->multiViewport = Traits::multiViewport(input);
    (*output)->samplerAnisotropy = Traits::samplerAnisotropy(input);
    (*output)->textureCompressionETC2 = Traits::textureCompressionETC2(input);
    (*output)->textureCompressionASTC_LDR = Traits::textureCompressionASTC_LDR(input);
    (*output)->textureCompressionBC = Traits::textureCompressionBC(input);
    (*output)->occlusionQueryPrecise = Traits::occlusionQueryPrecise(input);
    (*output)->pipelineStatisticsQuery = Traits::pipelineStatisticsQuery(input);
    (*output)->vertexPipelineStoresAndAtomics = Traits::vertexPipelineStoresAndAtomics(input);
    (*output)->fragmentStoresAndAtomics = Traits::fragmentStoresAndAtomics(input);
    (*output)->shaderTessellationAndGeometryPointSize = Traits::shaderTessellationAndGeometryPointSize(input);
    (*output)->shaderImageGatherExtended = Traits::shaderImageGatherExtended(input);
    (*output)->shaderStorageImageExtendedFormats = Traits::shaderStorageImageExtendedFormats(input);
    (*output)->shaderStorageImageMultisample = Traits::shaderStorageImageMultisample(input);
    (*output)->shaderStorageImageReadWithoutFormat = Traits::shaderStorageImageReadWithoutFormat(input);
    (*output)->shaderStorageImageWriteWithoutFormat = Traits::shaderStorageImageWriteWithoutFormat(input);
    (*output)->shaderUniformBufferArrayDynamicIndexing = Traits::shaderUniformBufferArrayDynamicIndexing(input);
    (*output)->shaderSampledImageArrayDynamicIndexing = Traits::shaderSampledImageArrayDynamicIndexing(input);
    (*output)->shaderStorageBufferArrayDynamicIndexing = Traits::shaderStorageBufferArrayDynamicIndexing(input);
    (*output)->shaderStorageImageArrayDynamicIndexing = Traits::shaderStorageImageArrayDynamicIndexing(input);
    (*output)->shaderClipDistance = Traits::shaderClipDistance(input);
    (*output)->shaderCullDistance = Traits::shaderCullDistance(input);
    (*output)->shaderFloat64 = Traits::shaderFloat64(input);
    (*output)->shaderInt64 = Traits::shaderInt64(input);
    (*output)->shaderInt16 = Traits::shaderInt16(input);
    (*output)->shaderResourceResidency = Traits::shaderResourceResidency(input);
    (*output)->shaderResourceMinLod = Traits::shaderResourceMinLod(input);
    (*output)->sparseBinding = Traits::sparseBinding(input);
    (*output)->sparseResidencyBuffer = Traits::sparseResidencyBuffer(input);
    (*output)->sparseResidencyImage2D = Traits::sparseResidencyImage2D(input);
    (*output)->sparseResidencyImage3D = Traits::sparseResidencyImage3D(input);
    (*output)->sparseResidency2Samples = Traits::sparseResidency2Samples(input);
    (*output)->sparseResidency4Samples = Traits::sparseResidency4Samples(input);
    (*output)->sparseResidency8Samples = Traits::sparseResidency8Samples(input);
    (*output)->sparseResidency16Samples = Traits::sparseResidency16Samples(input);
    (*output)->sparseResidencyAliased = Traits::sparseResidencyAliased(input);
    (*output)->variableMultisampleRate = Traits::variableMultisampleRate(input);
    (*output)->inheritedQueries = Traits::inheritedQueries(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VkPhysicalDeviceFeatures_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkPhysicalDeviceFeaturesDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkExtent3DDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkExtent3DDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gpu::mojom::internal::VkExtent3D_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->width = Traits::width(input);
    (*output)->height = Traits::height(input);
    (*output)->depth = Traits::depth(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VkExtent3D_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkExtent3DDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkQueueFamilyPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkQueueFamilyPropertiesDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gpu::mojom::internal::VkQueueFamilyProperties_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->queueFlags = Traits::queueFlags(input);
    (*output)->queueCount = Traits::queueCount(input);
    (*output)->timestampValidBits = Traits::timestampValidBits(input);
    decltype(Traits::minImageTransferGranularity(input)) in_minImageTransferGranularity = Traits::minImageTransferGranularity(input);
    typename decltype((*output)->minImageTransferGranularity)::BaseType::BufferWriter
        minImageTransferGranularity_writer;
    mojo::internal::Serialize<::gpu::mojom::VkExtent3DDataView>(
        in_minImageTransferGranularity, buffer, &minImageTransferGranularity_writer, context);
    (*output)->minImageTransferGranularity.Set(
        minImageTransferGranularity_writer.is_null() ? nullptr : minImageTransferGranularity_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->minImageTransferGranularity.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null minImageTransferGranularity in VkQueueFamilyProperties struct");
  }

  static bool Deserialize(::gpu::mojom::internal::VkQueueFamilyProperties_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkQueueFamilyPropertiesDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu {
namespace mojom {

inline void VkExtensionPropertiesDataView::GetExtensionNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->extensionName.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void VkLayerPropertiesDataView::GetLayerNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->layerName.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void VkLayerPropertiesDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void VkPhysicalDeviceLimitsDataView::GetMaxComputeWorkGroupCountDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->maxComputeWorkGroupCount.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, context_);
}
inline void VkPhysicalDeviceLimitsDataView::GetMaxComputeWorkGroupSizeDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->maxComputeWorkGroupSize.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, context_);
}
inline void VkPhysicalDeviceLimitsDataView::GetMaxViewportDimensionsDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->maxViewportDimensions.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, context_);
}
inline void VkPhysicalDeviceLimitsDataView::GetViewportBoundsRangeDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->viewportBoundsRange.Get();
  *output = mojo::ArrayDataView<float>(pointer, context_);
}
inline void VkPhysicalDeviceLimitsDataView::GetPointSizeRangeDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->pointSizeRange.Get();
  *output = mojo::ArrayDataView<float>(pointer, context_);
}
inline void VkPhysicalDeviceLimitsDataView::GetLineWidthRangeDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->lineWidthRange.Get();
  *output = mojo::ArrayDataView<float>(pointer, context_);
}




inline void VkPhysicalDevicePropertiesDataView::GetDeviceNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->deviceName.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void VkPhysicalDevicePropertiesDataView::GetPipelineCacheUuidDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->pipelineCacheUUID.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}
inline void VkPhysicalDevicePropertiesDataView::GetLimitsDataView(
    VkPhysicalDeviceLimitsDataView* output) {
  auto pointer = data_->limits.Get();
  *output = VkPhysicalDeviceLimitsDataView(pointer, context_);
}
inline void VkPhysicalDevicePropertiesDataView::GetSparsePropertiesDataView(
    VkPhysicalDeviceSparsePropertiesDataView* output) {
  auto pointer = data_->sparseProperties.Get();
  *output = VkPhysicalDeviceSparsePropertiesDataView(pointer, context_);
}






inline void VkQueueFamilyPropertiesDataView::GetMinImageTransferGranularityDataView(
    VkExtent3DDataView* output) {
  auto pointer = data_->minImageTransferGranularity.Get();
  *output = VkExtent3DDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace gpu

#endif  // GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_SHARED_H_