// components/web_package/mojom/web_bundle_parser.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace web_package {
namespace mojom {
namespace internal {
class  WebBundleParserFactory_GetParserForFile_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebBundleParserFactory_GetParserForFile_Params_Data));
      new (data()) WebBundleParserFactory_GetParserForFile_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebBundleParserFactory_GetParserForFile_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebBundleParserFactory_GetParserForFile_Params_Data>(index_);
    }
    WebBundleParserFactory_GetParserForFile_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::File_Data> file;

 private:
  WebBundleParserFactory_GetParserForFile_Params_Data();
  ~WebBundleParserFactory_GetParserForFile_Params_Data() = delete;
};
static_assert(sizeof(WebBundleParserFactory_GetParserForFile_Params_Data) == 24,
              "Bad sizeof(WebBundleParserFactory_GetParserForFile_Params_Data)");
class  WebBundleParserFactory_GetParserForDataSource_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebBundleParserFactory_GetParserForDataSource_Params_Data));
      new (data()) WebBundleParserFactory_GetParserForDataSource_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebBundleParserFactory_GetParserForDataSource_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebBundleParserFactory_GetParserForDataSource_Params_Data>(index_);
    }
    WebBundleParserFactory_GetParserForDataSource_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  mojo::internal::Interface_Data data_source;
  uint8_t padfinal_[4];

 private:
  WebBundleParserFactory_GetParserForDataSource_Params_Data();
  ~WebBundleParserFactory_GetParserForDataSource_Params_Data() = delete;
};
static_assert(sizeof(WebBundleParserFactory_GetParserForDataSource_Params_Data) == 24,
              "Bad sizeof(WebBundleParserFactory_GetParserForDataSource_Params_Data)");
class  WebBundleParser_ParseMetadata_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebBundleParser_ParseMetadata_Params_Data));
      new (data()) WebBundleParser_ParseMetadata_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebBundleParser_ParseMetadata_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebBundleParser_ParseMetadata_Params_Data>(index_);
    }
    WebBundleParser_ParseMetadata_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  WebBundleParser_ParseMetadata_Params_Data();
  ~WebBundleParser_ParseMetadata_Params_Data() = delete;
};
static_assert(sizeof(WebBundleParser_ParseMetadata_Params_Data) == 8,
              "Bad sizeof(WebBundleParser_ParseMetadata_Params_Data)");
class  WebBundleParser_ParseMetadata_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebBundleParser_ParseMetadata_ResponseParams_Data));
      new (data()) WebBundleParser_ParseMetadata_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebBundleParser_ParseMetadata_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebBundleParser_ParseMetadata_ResponseParams_Data>(index_);
    }
    WebBundleParser_ParseMetadata_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::BundleMetadata_Data> Result;
  mojo::internal::Pointer<internal::BundleMetadataParseError_Data> error;

 private:
  WebBundleParser_ParseMetadata_ResponseParams_Data();
  ~WebBundleParser_ParseMetadata_ResponseParams_Data() = delete;
};
static_assert(sizeof(WebBundleParser_ParseMetadata_ResponseParams_Data) == 24,
              "Bad sizeof(WebBundleParser_ParseMetadata_ResponseParams_Data)");
class  WebBundleParser_ParseResponse_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebBundleParser_ParseResponse_Params_Data));
      new (data()) WebBundleParser_ParseResponse_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebBundleParser_ParseResponse_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebBundleParser_ParseResponse_Params_Data>(index_);
    }
    WebBundleParser_ParseResponse_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t response_offset;
  uint64_t response_length;

 private:
  WebBundleParser_ParseResponse_Params_Data();
  ~WebBundleParser_ParseResponse_Params_Data() = delete;
};
static_assert(sizeof(WebBundleParser_ParseResponse_Params_Data) == 24,
              "Bad sizeof(WebBundleParser_ParseResponse_Params_Data)");
class  WebBundleParser_ParseResponse_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebBundleParser_ParseResponse_ResponseParams_Data));
      new (data()) WebBundleParser_ParseResponse_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebBundleParser_ParseResponse_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebBundleParser_ParseResponse_ResponseParams_Data>(index_);
    }
    WebBundleParser_ParseResponse_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::BundleResponse_Data> Result;
  mojo::internal::Pointer<internal::BundleResponseParseError_Data> error;

 private:
  WebBundleParser_ParseResponse_ResponseParams_Data();
  ~WebBundleParser_ParseResponse_ResponseParams_Data() = delete;
};
static_assert(sizeof(WebBundleParser_ParseResponse_ResponseParams_Data) == 24,
              "Bad sizeof(WebBundleParser_ParseResponse_ResponseParams_Data)");
class  BundleDataSource_Read_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(BundleDataSource_Read_Params_Data));
      new (data()) BundleDataSource_Read_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    BundleDataSource_Read_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<BundleDataSource_Read_Params_Data>(index_);
    }
    BundleDataSource_Read_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t offset;
  uint64_t length;

 private:
  BundleDataSource_Read_Params_Data();
  ~BundleDataSource_Read_Params_Data() = delete;
};
static_assert(sizeof(BundleDataSource_Read_Params_Data) == 24,
              "Bad sizeof(BundleDataSource_Read_Params_Data)");
class  BundleDataSource_Read_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(BundleDataSource_Read_ResponseParams_Data));
      new (data()) BundleDataSource_Read_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    BundleDataSource_Read_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<BundleDataSource_Read_ResponseParams_Data>(index_);
    }
    BundleDataSource_Read_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> buffer;

 private:
  BundleDataSource_Read_ResponseParams_Data();
  ~BundleDataSource_Read_ResponseParams_Data() = delete;
};
static_assert(sizeof(BundleDataSource_Read_ResponseParams_Data) == 16,
              "Bad sizeof(BundleDataSource_Read_ResponseParams_Data)");

}  // namespace internal


class WebBundleParserFactory_GetParserForFile_ParamsDataView {
 public:
  WebBundleParserFactory_GetParserForFile_ParamsDataView() {}

  WebBundleParserFactory_GetParserForFile_ParamsDataView(
      internal::WebBundleParserFactory_GetParserForFile_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::web_package::mojom::WebBundleParserInterfaceBase>>(
            &data_->receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFile(UserType* output) {
    
    auto* pointer = data_->file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, context_);
  }
 private:
  internal::WebBundleParserFactory_GetParserForFile_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class WebBundleParserFactory_GetParserForDataSource_ParamsDataView {
 public:
  WebBundleParserFactory_GetParserForDataSource_ParamsDataView() {}

  WebBundleParserFactory_GetParserForDataSource_ParamsDataView(
      internal::WebBundleParserFactory_GetParserForDataSource_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::web_package::mojom::WebBundleParserInterfaceBase>>(
            &data_->receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDataSource() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::web_package::mojom::BundleDataSourceInterfaceBase>>(
            &data_->data_source, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::WebBundleParserFactory_GetParserForDataSource_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class WebBundleParser_ParseMetadata_ParamsDataView {
 public:
  WebBundleParser_ParseMetadata_ParamsDataView() {}

  WebBundleParser_ParseMetadata_ParamsDataView(
      internal::WebBundleParser_ParseMetadata_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::WebBundleParser_ParseMetadata_Params_Data* data_ = nullptr;
};



class WebBundleParser_ParseMetadata_ResponseParamsDataView {
 public:
  WebBundleParser_ParseMetadata_ResponseParamsDataView() {}

  WebBundleParser_ParseMetadata_ResponseParamsDataView(
      internal::WebBundleParser_ParseMetadata_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      BundleMetadataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResult(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::web_package::mojom::BundleMetadataDataView, UserType>(),
    "Attempting to read the optional `Result` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResult` instead "
    "of `ReadResult if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->Result.Get();
    return mojo::internal::Deserialize<::web_package::mojom::BundleMetadataDataView>(
        pointer, output, context_);
  }
  inline void GetErrorDataView(
      BundleMetadataParseErrorDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadError(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::web_package::mojom::BundleMetadataParseErrorDataView, UserType>(),
    "Attempting to read the optional `error` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadError` instead "
    "of `ReadError if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->error.Get();
    return mojo::internal::Deserialize<::web_package::mojom::BundleMetadataParseErrorDataView>(
        pointer, output, context_);
  }
 private:
  internal::WebBundleParser_ParseMetadata_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class WebBundleParser_ParseResponse_ParamsDataView {
 public:
  WebBundleParser_ParseResponse_ParamsDataView() {}

  WebBundleParser_ParseResponse_ParamsDataView(
      internal::WebBundleParser_ParseResponse_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t response_offset() const {
    return data_->response_offset;
  }
  uint64_t response_length() const {
    return data_->response_length;
  }
 private:
  internal::WebBundleParser_ParseResponse_Params_Data* data_ = nullptr;
};



class WebBundleParser_ParseResponse_ResponseParamsDataView {
 public:
  WebBundleParser_ParseResponse_ResponseParamsDataView() {}

  WebBundleParser_ParseResponse_ResponseParamsDataView(
      internal::WebBundleParser_ParseResponse_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      BundleResponseDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResult(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::web_package::mojom::BundleResponseDataView, UserType>(),
    "Attempting to read the optional `Result` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResult` instead "
    "of `ReadResult if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->Result.Get();
    return mojo::internal::Deserialize<::web_package::mojom::BundleResponseDataView>(
        pointer, output, context_);
  }
  inline void GetErrorDataView(
      BundleResponseParseErrorDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadError(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::web_package::mojom::BundleResponseParseErrorDataView, UserType>(),
    "Attempting to read the optional `error` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadError` instead "
    "of `ReadError if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->error.Get();
    return mojo::internal::Deserialize<::web_package::mojom::BundleResponseParseErrorDataView>(
        pointer, output, context_);
  }
 private:
  internal::WebBundleParser_ParseResponse_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class BundleDataSource_Read_ParamsDataView {
 public:
  BundleDataSource_Read_ParamsDataView() {}

  BundleDataSource_Read_ParamsDataView(
      internal::BundleDataSource_Read_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t length() const {
    return data_->length;
  }
 private:
  internal::BundleDataSource_Read_Params_Data* data_ = nullptr;
};



class BundleDataSource_Read_ResponseParamsDataView {
 public:
  BundleDataSource_Read_ResponseParamsDataView() {}

  BundleDataSource_Read_ResponseParamsDataView(
      internal::BundleDataSource_Read_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetBufferDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBuffer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `buffer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBuffer` instead "
    "of `ReadBuffer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->buffer.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
 private:
  internal::BundleDataSource_Read_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void WebBundleParserFactory_GetParserForFile_ParamsDataView::GetFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, context_);
}






inline void WebBundleParser_ParseMetadata_ResponseParamsDataView::GetResultDataView(
    BundleMetadataDataView* output) {
  auto pointer = data_->Result.Get();
  *output = BundleMetadataDataView(pointer, context_);
}
inline void WebBundleParser_ParseMetadata_ResponseParamsDataView::GetErrorDataView(
    BundleMetadataParseErrorDataView* output) {
  auto pointer = data_->error.Get();
  *output = BundleMetadataParseErrorDataView(pointer, context_);
}




inline void WebBundleParser_ParseResponse_ResponseParamsDataView::GetResultDataView(
    BundleResponseDataView* output) {
  auto pointer = data_->Result.Get();
  *output = BundleResponseDataView(pointer, context_);
}
inline void WebBundleParser_ParseResponse_ResponseParamsDataView::GetErrorDataView(
    BundleResponseParseErrorDataView* output) {
  auto pointer = data_->error.Get();
  *output = BundleResponseParseErrorDataView(pointer, context_);
}




inline void BundleDataSource_Read_ResponseParamsDataView::GetBufferDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->buffer.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}

}  // namespace mojom
}  // namespace web_package

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_PARAMS_DATA_H_