// components/services/quarantine/public/mojom/quarantine.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/quarantine/public/mojom/quarantine.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "components/services/quarantine/public/mojom/quarantine.mojom-params-data.h"
namespace quarantine {
namespace mojom {

std::ostream& operator<<(std::ostream& os, QuarantineFileResult value) {
  switch(value) {
    case QuarantineFileResult::OK:
      return os << "QuarantineFileResult::OK";
    case QuarantineFileResult::ACCESS_DENIED:
      return os << "QuarantineFileResult::ACCESS_DENIED";
    case QuarantineFileResult::BLOCKED_BY_POLICY:
      return os << "QuarantineFileResult::BLOCKED_BY_POLICY";
    case QuarantineFileResult::ANNOTATION_FAILED:
      return os << "QuarantineFileResult::ANNOTATION_FAILED";
    case QuarantineFileResult::FILE_MISSING:
      return os << "QuarantineFileResult::FILE_MISSING";
    case QuarantineFileResult::SECURITY_CHECK_FAILED:
      return os << "QuarantineFileResult::SECURITY_CHECK_FAILED";
    case QuarantineFileResult::VIRUS_INFECTED:
      return os << "QuarantineFileResult::VIRUS_INFECTED";
    default:
      return os << "Unknown QuarantineFileResult value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool Quarantine_QuarantineFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Quarantine_QuarantineFile_Params_Data* object = static_cast<const Quarantine_QuarantineFile_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 40 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->full_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->full_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_guid, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams client_guid_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->client_guid, validation_context,
                                         &client_guid_validate_params)) {
    return false;
  }

  return true;
}

Quarantine_QuarantineFile_Params_Data::Quarantine_QuarantineFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Quarantine_QuarantineFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Quarantine_QuarantineFile_ResponseParams_Data* object = static_cast<const Quarantine_QuarantineFile_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::quarantine::mojom::internal::QuarantineFileResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

Quarantine_QuarantineFile_ResponseParams_Data::Quarantine_QuarantineFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace quarantine