/*=========================================================================

   Program: ParaView
   Module:  vtkVisItOVERFLOWReader.cxx

   Copyright (c) 2005,2006 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.2.

   See License_v1.2.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

========================================================================*/
#include "vtkVisItOVERFLOWReader.h"
#include "vtkInformation.h"
#include "vtkInformationVector.h"
#include "vtkObjectFactory.h"
#include "vtkMultiBlockDataSet.h"

#include "avtOVERFLOWFileFormat.h"
#include "avtDatabaseMetaData.h"
#include "avtMeshMetaData.h"
#include "avtVariableCache.h"

#define _add_visit_reader_VISIT_READER_USES_OPTIONS 0

#if _add_visit_reader_VISIT_READER_USES_OPTIONS
#include ".h"
#endif

#if _add_visit_reader_uses_interface
#include "vtkVisItOVERFLOWReader.h"
#endif

vtkStandardNewMacro(vtkVisItOVERFLOWReader);

//-----------------------------------------------------------------------------
vtkVisItOVERFLOWReader::vtkVisItOVERFLOWReader()
{
  this->FileName = nullptr;
}

//-----------------------------------------------------------------------------
vtkVisItOVERFLOWReader::~vtkVisItOVERFLOWReader()
{
  this->SetFileName(nullptr);
}

#if _add_visit_reader_uses_interface
//-----------------------------------------------------------------------------
int vtkVisItOVERFLOWReader::CanReadFile(const char *fname)
{
  int valid = 0;
  try
    {
    valid = vtkVisItOVERFLOWReader::;
    }
  catch(...){} // NOLINT(bugprone-empty-catch)
  return valid;
}
#endif

//-----------------------------------------------------------------------------
bool vtkVisItOVERFLOWReader::InitializeAVTReader(  const int&  )
{
  if (this->MetaDataSource != this->FileName)
  {
    this->CleanupAVTReader();
    this->MetaDataSource = this->FileName;
  }

  if (!this->MetaData)
    {
    this->MetaData = new avtDatabaseMetaData( );
    }

  if (!this->Cache)
    {
    this->Cache = new avtVariableCache( );
    }

  if (!this->AvtFile)
    {
    try
      {
#if _add_visit_reader_VISIT_READER_USES_OPTIONS
       *options =
        new ();
      this->AvtFile = new avtOVERFLOWFileFormat(
        this->FileName, options->GetReadOptions() );
      delete options;
#else
      this->AvtFile = new avtOVERFLOWFileFormat(this->FileName);
#endif
      }
    catch(const VisItException& e)
      {
      vtkErrorMacro(<<e.Message());
      this->AvtFile = nullptr;
      return false;
      }
    catch(const std::exception& e)
      {
      vtkErrorMacro(<<e.what());
      this->AvtFile = nullptr;
      return false;
      }
    avtOVERFLOWFileFormat *file = dynamic_cast<avtOVERFLOWFileFormat*>
      (this->AvtFile);
    if ( file )
      {
      //we have to make sure the visit reader populates its cache
      //before activating a time step
      try
        {
        file->SetCache( this->Cache );
        file->ActivateTimestep();

        //only fill database after choosing timestep to activate
        file->SetDatabaseMetaData( this->MetaData );
        }
      catch(const VisItException& e)
        {
        vtkErrorMacro(<<e.Message());
        return false;
        }
      catch(const std::exception& e)
        {
        vtkErrorMacro(<<e.what());
        return false;
        }
      }
    else
      {
      return false;
      }
    }

  return true;
}


//-----------------------------------------------------------------------------
void vtkVisItOVERFLOWReader::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}
