// python wrapper for vtkPVHistogramChartRepresentation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSmartPointer.h"
#include "vtkPVHistogramChartRepresentation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVHistogramChartRepresentation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVHistogramChartRepresentation_ClassNew(); }

#ifndef DECLARED_PyvtkXYChartRepresentation_ClassNew
extern "C" { PyObject *PyvtkXYChartRepresentation_ClassNew(); }
#define DECLARED_PyvtkXYChartRepresentation_ClassNew
#endif

static PyObject *
PyvtkPVHistogramChartRepresentation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVHistogramChartRepresentation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVHistogramChartRepresentation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVHistogramChartRepresentation *tempr = vtkPVHistogramChartRepresentation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVHistogramChartRepresentation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVHistogramChartRepresentation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVHistogramChartRepresentation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVHistogramChartRepresentation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_SetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComponent(temp0);
    }
    else
    {
      op->vtkPVHistogramChartRepresentation::SetComponent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_GetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetComponent() :
      op->vtkPVHistogramChartRepresentation::GetComponent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_SetBinCount(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBinCount");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBinCount(temp0);
    }
    else
    {
      op->vtkPVHistogramChartRepresentation::SetBinCount(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_GetBinCount(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBinCount");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBinCount() :
      op->vtkPVHistogramChartRepresentation::GetBinCount());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_SetCenterBinsAroundMinAndMax(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCenterBinsAroundMinAndMax");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCenterBinsAroundMinAndMax(temp0);
    }
    else
    {
      op->vtkPVHistogramChartRepresentation::SetCenterBinsAroundMinAndMax(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_GetCenterBinsAroundMinAndMax(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCenterBinsAroundMinAndMax");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetCenterBinsAroundMinAndMax() :
      op->vtkPVHistogramChartRepresentation::GetCenterBinsAroundMinAndMax());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_SetCustomBinRanges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCustomBinRanges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  double temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetCustomBinRanges(temp0, temp1);
    }
    else
    {
      op->vtkPVHistogramChartRepresentation::SetCustomBinRanges(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_GetCustomBinRanges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCustomBinRanges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetCustomBinRanges() :
      op->vtkPVHistogramChartRepresentation::GetCustomBinRanges());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_SetUseCustomBinRanges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseCustomBinRanges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseCustomBinRanges(temp0);
    }
    else
    {
      op->vtkPVHistogramChartRepresentation::SetUseCustomBinRanges(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_GetUseCustomBinRanges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseCustomBinRanges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseCustomBinRanges() :
      op->vtkPVHistogramChartRepresentation::GetUseCustomBinRanges());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_SetHistogramColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetHistogramColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVHistogramChartRepresentation::SetHistogramColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_SetUseColorMapping(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseColorMapping");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseColorMapping(temp0);
    }
    else
    {
      op->vtkPVHistogramChartRepresentation::SetUseColorMapping(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_SetLookupTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLookupTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  vtkScalarsToColors *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetLookupTable(temp0);
    }
    else
    {
      op->vtkPVHistogramChartRepresentation::SetLookupTable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_SetHistogramLineStyle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramLineStyle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHistogramLineStyle(temp0);
    }
    else
    {
      op->vtkPVHistogramChartRepresentation::SetHistogramLineStyle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_TransformInputData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "TransformInputData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  vtkDataObject *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkDataObject"))
  {
    vtkSmartPointer<vtkDataObject> tempr = (ap.IsBound() ?
      op->TransformInputData(temp0) :
      op->vtkPVHistogramChartRepresentation::TransformInputData(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_SetInputArrayToProcess_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputArrayToProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  const char *temp4 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkPVHistogramChartRepresentation::SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVHistogramChartRepresentation_SetInputArrayToProcess_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputArrayToProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetInputArrayToProcess(temp0, temp1);
    }
    else
    {
      op->vtkPVHistogramChartRepresentation::SetInputArrayToProcess(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVHistogramChartRepresentation_SetInputArrayToProcess_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputArrayToProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  int temp4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkPVHistogramChartRepresentation::SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVHistogramChartRepresentation_SetInputArrayToProcess_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputArrayToProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  int temp0;
  vtkInformation *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkInformation"))
  {
    if (ap.IsBound())
    {
      op->SetInputArrayToProcess(temp0, temp1);
    }
    else
    {
      op->vtkPVHistogramChartRepresentation::SetInputArrayToProcess(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVHistogramChartRepresentation_SetInputArrayToProcess_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputArrayToProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  int temp0;
  int temp1;
  int temp2;
  const char *temp3 = nullptr;
  const char *temp4 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkPVHistogramChartRepresentation::SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVHistogramChartRepresentation_SetInputArrayToProcess_Methods[] = {
  {"SetInputArrayToProcess", PyvtkPVHistogramChartRepresentation_SetInputArrayToProcess_s1, METH_VARARGS,
   "@iiiiz"},
  {"SetInputArrayToProcess", PyvtkPVHistogramChartRepresentation_SetInputArrayToProcess_s2, METH_VARARGS,
   "@zi"},
  {"SetInputArrayToProcess", PyvtkPVHistogramChartRepresentation_SetInputArrayToProcess_s3, METH_VARARGS,
   "@iiiii"},
  {"SetInputArrayToProcess", PyvtkPVHistogramChartRepresentation_SetInputArrayToProcess_s4, METH_VARARGS,
   "@iV *vtkInformation"},
  {"SetInputArrayToProcess", PyvtkPVHistogramChartRepresentation_SetInputArrayToProcess_s5, METH_VARARGS,
   "@iiizz"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPVHistogramChartRepresentation_SetInputArrayToProcess(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkPVHistogramChartRepresentation_SetInputArrayToProcess_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
    case 5:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetInputArrayToProcess");
  return nullptr;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_MapSelectionToInput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MapSelectionToInput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  vtkSelection *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSelection"))
  {
    bool tempr = (ap.IsBound() ?
      op->MapSelectionToInput(temp0) :
      op->vtkPVHistogramChartRepresentation::MapSelectionToInput(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHistogramChartRepresentation_MapSelectionToView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MapSelectionToView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHistogramChartRepresentation *op = static_cast<vtkPVHistogramChartRepresentation *>(vp);

  vtkSelection *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSelection"))
  {
    bool tempr = (ap.IsBound() ?
      op->MapSelectionToView(temp0) :
      op->vtkPVHistogramChartRepresentation::MapSelectionToView(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVHistogramChartRepresentation_Methods[] = {
  {"IsTypeOf", PyvtkPVHistogramChartRepresentation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVHistogramChartRepresentation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVHistogramChartRepresentation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVHistogramChartRepresentation\nC++: static vtkPVHistogramChartRepresentation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVHistogramChartRepresentation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVHistogramChartRepresentation\nC++: vtkPVHistogramChartRepresentation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVHistogramChartRepresentation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVHistogramChartRepresentation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetComponent", PyvtkPVHistogramChartRepresentation_SetComponent, METH_VARARGS,
   "SetComponent(self, __a:int) -> None\nC++: void SetComponent(int)\n\nControls which input data component should be binned, for input\narrays with more-than-one component\n"},
  {"GetComponent", PyvtkPVHistogramChartRepresentation_GetComponent, METH_VARARGS,
   "GetComponent(self) -> int\nC++: int GetComponent()\n\n"},
  {"SetBinCount", PyvtkPVHistogramChartRepresentation_SetBinCount, METH_VARARGS,
   "SetBinCount(self, __a:int) -> None\nC++: void SetBinCount(int)\n\nControls the number of bins N in the output histogram data\n"},
  {"GetBinCount", PyvtkPVHistogramChartRepresentation_GetBinCount, METH_VARARGS,
   "GetBinCount(self) -> int\nC++: int GetBinCount()\n\n"},
  {"SetCenterBinsAroundMinAndMax", PyvtkPVHistogramChartRepresentation_SetCenterBinsAroundMinAndMax, METH_VARARGS,
   "SetCenterBinsAroundMinAndMax(self, __a:bool) -> None\nC++: void SetCenterBinsAroundMinAndMax(bool)\n\nGet/Set if first and last bins must be centered around the min\nand max data. This is only used when UseCustomBinRanges is set to\nfalse. Default is false.\n"},
  {"GetCenterBinsAroundMinAndMax", PyvtkPVHistogramChartRepresentation_GetCenterBinsAroundMinAndMax, METH_VARARGS,
   "GetCenterBinsAroundMinAndMax(self) -> bool\nC++: bool GetCenterBinsAroundMinAndMax()\n\n"},
  {"SetCustomBinRanges", PyvtkPVHistogramChartRepresentation_SetCustomBinRanges, METH_VARARGS,
   "SetCustomBinRanges(self, min:float, max:float) -> None\nC++: void SetCustomBinRanges(double min, double max)\n\nGet/Set custom bin ranges to use. These are used only when\nUseCustomBinRanges is set to true.\n"},
  {"GetCustomBinRanges", PyvtkPVHistogramChartRepresentation_GetCustomBinRanges, METH_VARARGS,
   "GetCustomBinRanges(self) -> Pointer\nC++: double *GetCustomBinRanges()\n\n"},
  {"SetUseCustomBinRanges", PyvtkPVHistogramChartRepresentation_SetUseCustomBinRanges, METH_VARARGS,
   "SetUseCustomBinRanges(self, __a:bool) -> None\nC++: void SetUseCustomBinRanges(bool)\n\nWhen set to true, CustomBinRanges will  be used instead of using\nthe full range for the selected array. By default, set to false.\n"},
  {"GetUseCustomBinRanges", PyvtkPVHistogramChartRepresentation_GetUseCustomBinRanges, METH_VARARGS,
   "GetUseCustomBinRanges(self) -> bool\nC++: bool GetUseCustomBinRanges()\n\n"},
  {"SetHistogramColor", PyvtkPVHistogramChartRepresentation_SetHistogramColor, METH_VARARGS,
   "SetHistogramColor(self, r:float, g:float, b:float) -> None\nC++: void SetHistogramColor(double r, double g, double b)\n\nSets the color for the histograms.\n"},
  {"SetUseColorMapping", PyvtkPVHistogramChartRepresentation_SetUseColorMapping, METH_VARARGS,
   "SetUseColorMapping(self, colorMapping:bool) -> None\nC++: void SetUseColorMapping(bool colorMapping)\n\nSets the histogram to be color mapped by the scalar.\n"},
  {"SetLookupTable", PyvtkPVHistogramChartRepresentation_SetLookupTable, METH_VARARGS,
   "SetLookupTable(self, lut:vtkScalarsToColors) -> None\nC++: void SetLookupTable(vtkScalarsToColors *lut)\n\nSets the lookup table that is used for color mapping by the\nscalar.\n"},
  {"SetHistogramLineStyle", PyvtkPVHistogramChartRepresentation_SetHistogramLineStyle, METH_VARARGS,
   "SetHistogramLineStyle(self, style:int) -> None\nC++: void SetHistogramLineStyle(int style)\n\nSet the line style for the histogram.\n"},
  {"TransformInputData", PyvtkPVHistogramChartRepresentation_TransformInputData, METH_VARARGS,
   "TransformInputData(self, data:vtkDataObject) -> vtkDataObject\nC++: vtkSmartPointer<vtkDataObject> TransformInputData(\n    vtkDataObject *data) override;\n\nMethod to be overridden to transform input data to a vtkTable.\n"},
  {"SetInputArrayToProcess", PyvtkPVHistogramChartRepresentation_SetInputArrayToProcess, METH_VARARGS,
   "SetInputArrayToProcess(self, idx:int, port:int, connection:int,\n    fieldAssociation:int, name:str) -> None\nC++: void SetInputArrayToProcess(int idx, int port,\n    int connection, int fieldAssociation, const char *name)\n    override;\nSetInputArrayToProcess(self, name:str, fieldAssociation:int)\n    -> None\nC++: void SetInputArrayToProcess(const char *name,\n    int fieldAssociation)\nSetInputArrayToProcess(self, idx:int, port:int, connection:int,\n    fieldAssociation:int, fieldAttributeType:int) -> None\nC++: virtual void SetInputArrayToProcess(int idx, int port,\n    int connection, int fieldAssociation, int fieldAttributeType)\nSetInputArrayToProcess(self, idx:int, info:vtkInformation) -> None\nC++: virtual void SetInputArrayToProcess(int idx,\n    vtkInformation *info)\nSetInputArrayToProcess(self, idx:int, port:int, connection:int,\n    fieldAssociation:str, attributeTypeorName:str) -> None\nC++: virtual void SetInputArrayToProcess(int idx, int port,\n    int connection, const char *fieldAssociation,\n    const char *attributeTypeorName)\n\nOverload the vtkAlgorithm method to update after the change\n"},
  {"MapSelectionToInput", PyvtkPVHistogramChartRepresentation_MapSelectionToInput, METH_VARARGS,
   "MapSelectionToInput(self, __a:vtkSelection) -> bool\nC++: bool MapSelectionToInput(vtkSelection *) override;\n\nOverridden to transform id-based selection produced by the\nhistogram view to a threshold-based selection.\n"},
  {"MapSelectionToView", PyvtkPVHistogramChartRepresentation_MapSelectionToView, METH_VARARGS,
   "MapSelectionToView(self, sel:vtkSelection) -> bool\nC++: bool MapSelectionToView(vtkSelection *sel) override;\n\nInverse of MapSelectionToInput().\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVHistogramChartRepresentation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("component"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVHistogramChartRepresentation_GetComponent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVHistogramChartRepresentation_SetComponent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVHistogramChartRepresentation_SetComponent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComponent/SetComponent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bin_count"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVHistogramChartRepresentation_GetBinCount(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVHistogramChartRepresentation_SetBinCount(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVHistogramChartRepresentation_SetBinCount(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBinCount/SetBinCount\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("center_bins_around_min_and_max"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVHistogramChartRepresentation_GetCenterBinsAroundMinAndMax(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVHistogramChartRepresentation_SetCenterBinsAroundMinAndMax(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVHistogramChartRepresentation_SetCenterBinsAroundMinAndMax(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCenterBinsAroundMinAndMax/SetCenterBinsAroundMinAndMax\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("custom_bin_ranges"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVHistogramChartRepresentation_SetCustomBinRanges(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVHistogramChartRepresentation_SetCustomBinRanges(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCustomBinRanges\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_custom_bin_ranges"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVHistogramChartRepresentation_GetUseCustomBinRanges(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVHistogramChartRepresentation_SetUseCustomBinRanges(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVHistogramChartRepresentation_SetUseCustomBinRanges(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseCustomBinRanges/SetUseCustomBinRanges\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVHistogramChartRepresentation_SetHistogramColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVHistogramChartRepresentation_SetHistogramColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_color_mapping"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVHistogramChartRepresentation_SetUseColorMapping(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVHistogramChartRepresentation_SetUseColorMapping(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseColorMapping\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("lookup_table"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVHistogramChartRepresentation_SetLookupTable(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVHistogramChartRepresentation_SetLookupTable(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLookupTable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_line_style"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVHistogramChartRepresentation_SetHistogramLineStyle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVHistogramChartRepresentation_SetHistogramLineStyle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramLineStyle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("input_array_to_process"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVHistogramChartRepresentation_SetInputArrayToProcess(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVHistogramChartRepresentation_SetInputArrayToProcess(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInputArrayToProcess\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("custom_bin_ranges"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVHistogramChartRepresentation_GetCustomBinRanges(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCustomBinRanges\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVHistogramChartRepresentation_Doc =
  "vtkPVHistogramChartRepresentation - representation for \"Histogram\n\n"
  "Superclass: vtkXYChartRepresentation\n\n"
  "View\".\n\n"
  "vtkPVHistogramChartRepresentation is the vtkPVDataRepresentation\n"
  "subclass for showing an data in the \"Histogram View\". The\n"
  "representation pipeline extracts histogram from the input dataset and\n"
  "then shows that in the view.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVHistogramChartRepresentation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVHistogramChartRepresentation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVHistogramChartRepresentation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVHistogramChartRepresentation_StaticNew()
{
  return vtkPVHistogramChartRepresentation::New();
}

PyObject *PyvtkPVHistogramChartRepresentation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVHistogramChartRepresentation_Type, PyvtkPVHistogramChartRepresentation_Methods,
    "vtkPVHistogramChartRepresentation",
 &PyvtkPVHistogramChartRepresentation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkXYChartRepresentation_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVHistogramChartRepresentation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVHistogramChartRepresentation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVHistogramChartRepresentation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVHistogramChartRepresentation", o) != 0)
  {
    Py_DECREF(o);
  }

}

