// python wrapper for vtkPVSession
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVSession.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVSession(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVSession_ClassNew(); }

#ifndef DECLARED_PyvtkSession_ClassNew
extern "C" { PyObject *PyvtkSession_ClassNew(); }
#define DECLARED_PyvtkSession_ClassNew
#endif
#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVSession_ServerFlags_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVSession.ServerFlags", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkPVSession_ServerFlags_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkPVSession_ServerFlags_Type, static_cast<int>(val));
}


static PyObject *
PyvtkPVSession_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVSession::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSession_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSession *op = static_cast<vtkPVSession *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVSession::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSession_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVSession *tempr = vtkPVSession::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSession_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSession *op = static_cast<vtkPVSession *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVSession *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVSession::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSession_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVSession::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSession_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSession *op = static_cast<vtkPVSession *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVSession::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSession_GetProcessRoles(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProcessRoles");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSession *op = static_cast<vtkPVSession *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    typedef vtkPVSession::ServerFlags tempr_type;
  tempr_type tempr = (ap.IsBound() ?
      op->GetProcessRoles() :
      op->vtkPVSession::GetProcessRoles());

    if (!ap.ErrorOccurred())
    {
      result = PyvtkPVSession_ServerFlags_FromEnum(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSession_HasProcessRole(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasProcessRole");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSession *op = static_cast<vtkPVSession *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasProcessRole(temp0) :
      op->vtkPVSession::HasProcessRole(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSession_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSession *op = static_cast<vtkPVSession *>(vp);

  typedef vtkPVSession::ServerFlags temp0_type;
  temp0_type temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkPVSession.ServerFlags"))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController(temp0) :
      op->vtkPVSession::GetController(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSession_GetMPIMToNSocketConnection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMPIMToNSocketConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSession *op = static_cast<vtkPVSession *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMPIMToNSocketConnection *tempr = (ap.IsBound() ?
      op->GetMPIMToNSocketConnection() :
      op->vtkPVSession::GetMPIMToNSocketConnection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSession_GetServerInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetServerInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSession *op = static_cast<vtkPVSession *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    vtkPVServerInformation *tempr = op->GetServerInformation();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSession_IsMultiClients(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsMultiClients");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSession *op = static_cast<vtkPVSession *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsMultiClients() :
      op->vtkPVSession::IsMultiClients());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSession_GetProgressHandler(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProgressHandler");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSession *op = static_cast<vtkPVSession *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVProgressHandler *tempr = (ap.IsBound() ?
      op->GetProgressHandler() :
      op->vtkPVSession::GetProgressHandler());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSession_PrepareProgress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PrepareProgress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSession *op = static_cast<vtkPVSession *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PrepareProgress();
    }
    else
    {
      op->vtkPVSession::PrepareProgress();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSession_CleanupPendingProgress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CleanupPendingProgress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSession *op = static_cast<vtkPVSession *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CleanupPendingProgress();
    }
    else
    {
      op->vtkPVSession::CleanupPendingProgress();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSession_GetPendingProgress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPendingProgress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSession *op = static_cast<vtkPVSession *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPendingProgress() :
      op->vtkPVSession::GetPendingProgress());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVSession_Methods[] = {
  {"IsTypeOf", PyvtkPVSession_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVSession_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVSession_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVSession\nC++: static vtkPVSession *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVSession_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVSession\nC++: vtkPVSession *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVSession_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVSession_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetProcessRoles", PyvtkPVSession_GetProcessRoles, METH_VARARGS,
   "GetProcessRoles(self) -> ServerFlags\nC++: virtual ServerFlags GetProcessRoles()\n\nReturns a ServerFlags indicate the nature of the current\nprocesses. e.g. if the current processes acts as a data-server\nand a render-server, it returns DATA_SERVER | RENDER_SERVER.\n"},
  {"HasProcessRole", PyvtkPVSession_HasProcessRole, METH_VARARGS,
   "HasProcessRole(self, flag:int) -> bool\nC++: bool HasProcessRole(vtkTypeUInt32 flag)\n\nConvenience method that returns true if the current session is\nserving the indicated role on this process.\n"},
  {"GetController", PyvtkPVSession_GetController, METH_VARARGS,
   "GetController(self, processType:ServerFlags)\n    -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController(\n    ServerFlags processType)\n\nReturns the controller used to communicate with the process.\nValue must be DATA_SERVER_ROOT or RENDER_SERVER_ROOT or CLIENT.\nDefault implementation returns nullptr.\n"},
  {"GetMPIMToNSocketConnection", PyvtkPVSession_GetMPIMToNSocketConnection, METH_VARARGS,
   "GetMPIMToNSocketConnection(self) -> vtkMPIMToNSocketConnection\nC++: virtual vtkMPIMToNSocketConnection *GetMPIMToNSocketConnection(\n    )\n\nThis is socket connection, if any to communicate between the\ndata-server and render-server nodes.\n"},
  {"GetServerInformation", PyvtkPVSession_GetServerInformation, METH_VARARGS,
   "GetServerInformation(self) -> vtkPVServerInformation\nC++: virtual vtkPVServerInformation *GetServerInformation()\n\nvtkPVServerInformation is an information-object that provides\ninformation about the server processes. These include server-side\ncapabilities as well as server-side command line arguments e.g.\ntile-display parameters. Use this method to obtain the\nserver-side information. NOTE: For now, we are not bothering to\nprovide separate information from data-server and render-server\n(as was the case earlier). We can easily add API for the same if\nneeded.\n"},
  {"IsMultiClients", PyvtkPVSession_IsMultiClients, METH_VARARGS,
   "IsMultiClients(self) -> bool\nC++: virtual bool IsMultiClients()\n\nAllow anyone to know easily if the current session is involved in\ncollaboration or not. This is mostly true for the Client side.\n"},
  {"GetProgressHandler", PyvtkPVSession_GetProgressHandler, METH_VARARGS,
   "GetProgressHandler(self) -> vtkPVProgressHandler\nC++: virtual vtkPVProgressHandler *GetProgressHandler()\n\nProvides access to the progress handler.\n"},
  {"PrepareProgress", PyvtkPVSession_PrepareProgress, METH_VARARGS,
   "PrepareProgress(self) -> None\nC++: void PrepareProgress()\n\nShould be called to begin/end receiving progresses on this\nsession.\n"},
  {"CleanupPendingProgress", PyvtkPVSession_CleanupPendingProgress, METH_VARARGS,
   "CleanupPendingProgress(self) -> None\nC++: void CleanupPendingProgress()\n\n"},
  {"GetPendingProgress", PyvtkPVSession_GetPendingProgress, METH_VARARGS,
   "GetPendingProgress(self) -> bool\nC++: bool GetPendingProgress()\n\nReturns true if the session is within a PrepareProgress() and\nCleanupPendingProgress() block.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVSession_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("process_roles"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSession_GetProcessRoles(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetProcessRoles\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("mpim_to_n_socket_connection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSession_GetMPIMToNSocketConnection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMPIMToNSocketConnection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("server_information"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSession_GetServerInformation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetServerInformation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("progress_handler"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSession_GetProgressHandler(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetProgressHandler\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pending_progress"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSession_GetPendingProgress(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPendingProgress\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVSession_Doc =
  "vtkPVSession - extends vtkSession to add API for ParaView sessions.\n\n"
  "Superclass: vtkSession\n\n"
  "vtkPVSession adds APIs to vtkSession for ParaView-specific sessions,\n"
  "namely those that are used to communicate between\n"
  "data-server,render-server and client. This is an abstract class.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVSession_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVSession", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVSession_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkPVSession_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVSession_Type, PyvtkPVSession_Methods,
    "vtkPVSession",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSession_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkPVSession_ServerFlags_Type);
  PyVTKEnum_Add(&PyvtkPVSession_ServerFlags_Type, "vtkPVSession.ServerFlags");

  o = (PyObject *)&PyvtkPVSession_ServerFlags_Type;
  if (PyDict_SetItemString(d, "ServerFlags", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 8; c++)
  {
    typedef vtkPVSession::ServerFlags cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[8] = {
        { "NONE", vtkPVSession::NONE },
        { "DATA_SERVER", vtkPVSession::DATA_SERVER },
        { "DATA_SERVER_ROOT", vtkPVSession::DATA_SERVER_ROOT },
        { "RENDER_SERVER", vtkPVSession::RENDER_SERVER },
        { "RENDER_SERVER_ROOT", vtkPVSession::RENDER_SERVER_ROOT },
        { "SERVERS", vtkPVSession::SERVERS },
        { "CLIENT", vtkPVSession::CLIENT },
        { "CLIENT_AND_SERVERS", vtkPVSession::CLIENT_AND_SERVERS },
      };

    o = PyvtkPVSession_ServerFlags_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVSession_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVSession(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVSession_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVSession", o) != 0)
  {
    Py_DECREF(o);
  }

}

