// python wrapper for vtkReductionFilter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkReductionFilter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkReductionFilter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkReductionFilter_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkReductionFilter_ReductionModeType_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsMisc.vtkReductionFilter.ReductionModeType", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkReductionFilter_ReductionModeType_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkReductionFilter_ReductionModeType_Type, static_cast<int>(val));
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkReductionFilter_Tags_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsMisc.vtkReductionFilter.Tags", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkReductionFilter_Tags_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkReductionFilter_Tags_Type, static_cast<int>(val));
}


static PyObject *
PyvtkReductionFilter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkReductionFilter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkReductionFilter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkReductionFilter *tempr = vtkReductionFilter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkReductionFilter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkReductionFilter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkReductionFilter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkReductionFilter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_SetReductionMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetReductionMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetReductionMode(temp0);
    }
    else
    {
      op->vtkReductionFilter::SetReductionMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_GetReductionModeMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReductionModeMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetReductionModeMinValue() :
      op->vtkReductionFilter::GetReductionModeMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_GetReductionModeMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReductionModeMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetReductionModeMaxValue() :
      op->vtkReductionFilter::GetReductionModeMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_GetReductionMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReductionMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetReductionMode() :
      op->vtkReductionFilter::GetReductionMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_SetReductionProcessId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetReductionProcessId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetReductionProcessId(temp0);
    }
    else
    {
      op->vtkReductionFilter::SetReductionProcessId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_GetReductionProcessId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReductionProcessId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetReductionProcessId() :
      op->vtkReductionFilter::GetReductionProcessId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_SetPreGatherHelper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPreGatherHelper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  vtkAlgorithm *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithm"))
  {
    if (ap.IsBound())
    {
      op->SetPreGatherHelper(temp0);
    }
    else
    {
      op->vtkReductionFilter::SetPreGatherHelper(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_SetPreGatherHelperName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPreGatherHelperName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPreGatherHelperName(temp0);
    }
    else
    {
      op->vtkReductionFilter::SetPreGatherHelperName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_GetPreGatherHelper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPreGatherHelper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAlgorithm *tempr = (ap.IsBound() ?
      op->GetPreGatherHelper() :
      op->vtkReductionFilter::GetPreGatherHelper());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_SetPostGatherHelper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPostGatherHelper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  vtkAlgorithm *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithm"))
  {
    if (ap.IsBound())
    {
      op->SetPostGatherHelper(temp0);
    }
    else
    {
      op->vtkReductionFilter::SetPostGatherHelper(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_SetPostGatherHelperName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPostGatherHelperName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPostGatherHelperName(temp0);
    }
    else
    {
      op->vtkReductionFilter::SetPostGatherHelperName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_GetPostGatherHelper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPostGatherHelper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAlgorithm *tempr = (ap.IsBound() ?
      op->GetPostGatherHelper() :
      op->vtkReductionFilter::GetPostGatherHelper());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkReductionFilter::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_SetPassThrough(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPassThrough");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPassThrough(temp0);
    }
    else
    {
      op->vtkReductionFilter::SetPassThrough(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_GetPassThrough(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPassThrough");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPassThrough() :
      op->vtkReductionFilter::GetPassThrough());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_SetGenerateProcessIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateProcessIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateProcessIds(temp0);
    }
    else
    {
      op->vtkReductionFilter::SetGenerateProcessIds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkReductionFilter_GetGenerateProcessIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateProcessIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReductionFilter *op = static_cast<vtkReductionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGenerateProcessIds() :
      op->vtkReductionFilter::GetGenerateProcessIds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkReductionFilter_Methods[] = {
  {"IsTypeOf", PyvtkReductionFilter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkReductionFilter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkReductionFilter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkReductionFilter\nC++: static vtkReductionFilter *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkReductionFilter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkReductionFilter\nC++: vtkReductionFilter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkReductionFilter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkReductionFilter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetReductionMode", PyvtkReductionFilter_SetReductionMode, METH_VARARGS,
   "SetReductionMode(self, _arg:int) -> None\nC++: virtual void SetReductionMode(int _arg)\n\nGet/Set the Reduction Mode. REDUCE_ALL_TO_ONE is the default\nbehavior. It reduces all data on a single node, while other nodes\nkeeps their data. MOVE_ALL_TO_ONE Reduce all data on a single\nnode while other nodes delete their data. ALL NODES Reduce all\ndata on all nodes.\n"},
  {"GetReductionModeMinValue", PyvtkReductionFilter_GetReductionModeMinValue, METH_VARARGS,
   "GetReductionModeMinValue(self) -> int\nC++: virtual int GetReductionModeMinValue()\n\n"},
  {"GetReductionModeMaxValue", PyvtkReductionFilter_GetReductionModeMaxValue, METH_VARARGS,
   "GetReductionModeMaxValue(self) -> int\nC++: virtual int GetReductionModeMaxValue()\n\n"},
  {"GetReductionMode", PyvtkReductionFilter_GetReductionMode, METH_VARARGS,
   "GetReductionMode(self) -> int\nC++: virtual int GetReductionMode()\n\n"},
  {"SetReductionProcessId", PyvtkReductionFilter_SetReductionProcessId, METH_VARARGS,
   "SetReductionProcessId(self, _arg:int) -> None\nC++: virtual void SetReductionProcessId(int _arg)\n\nGet/Set the node to reduce to, default is 0. Not used with\nREDUCE_ALL_TO_ALL Reduction mode\n"},
  {"GetReductionProcessId", PyvtkReductionFilter_GetReductionProcessId, METH_VARARGS,
   "GetReductionProcessId(self) -> int\nC++: virtual int GetReductionProcessId()\n\n"},
  {"SetPreGatherHelper", PyvtkReductionFilter_SetPreGatherHelper, METH_VARARGS,
   "SetPreGatherHelper(self, __a:vtkAlgorithm) -> None\nC++: void SetPreGatherHelper(vtkAlgorithm *)\n\nGet/Set the pre-reduction helper. Pre-Reduction helper is an\nalgorithm that runs on each node's data before it is sent to the\nroot.\n"},
  {"SetPreGatherHelperName", PyvtkReductionFilter_SetPreGatherHelperName, METH_VARARGS,
   "SetPreGatherHelperName(self, __a:str) -> None\nC++: void SetPreGatherHelperName(const char *)\n\n"},
  {"GetPreGatherHelper", PyvtkReductionFilter_GetPreGatherHelper, METH_VARARGS,
   "GetPreGatherHelper(self) -> vtkAlgorithm\nC++: virtual vtkAlgorithm *GetPreGatherHelper()\n\n"},
  {"SetPostGatherHelper", PyvtkReductionFilter_SetPostGatherHelper, METH_VARARGS,
   "SetPostGatherHelper(self, __a:vtkAlgorithm) -> None\nC++: void SetPostGatherHelper(vtkAlgorithm *)\n\nGet/Set the reduction helper. Reduction helper is an algorithm\nwith multiple input connections, that produces a single output as\nthe reduced output. This is run on the root node to produce a\nresult from the gathered results of each node.\n"},
  {"SetPostGatherHelperName", PyvtkReductionFilter_SetPostGatherHelperName, METH_VARARGS,
   "SetPostGatherHelperName(self, __a:str) -> None\nC++: void SetPostGatherHelperName(const char *)\n\n"},
  {"GetPostGatherHelper", PyvtkReductionFilter_GetPostGatherHelper, METH_VARARGS,
   "GetPostGatherHelper(self) -> vtkAlgorithm\nC++: virtual vtkAlgorithm *GetPostGatherHelper()\n\n"},
  {"SetController", PyvtkReductionFilter_SetController, METH_VARARGS,
   "SetController(self, __a:vtkMultiProcessController) -> None\nC++: void SetController(vtkMultiProcessController *)\n\nGet/Set the MPI controller used for gathering.\n"},
  {"SetPassThrough", PyvtkReductionFilter_SetPassThrough, METH_VARARGS,
   "SetPassThrough(self, _arg:int) -> None\nC++: virtual void SetPassThrough(int _arg)\n\nGet/Set the PassThrough flag which (when set to a nonnegative\nnumber N) tells the filter to produce results that come from node\nN only. The data from that node still runs through the\nPreReduction and PostGatherHelper algorithms.\n"},
  {"GetPassThrough", PyvtkReductionFilter_GetPassThrough, METH_VARARGS,
   "GetPassThrough(self) -> int\nC++: virtual int GetPassThrough()\n\n"},
  {"SetGenerateProcessIds", PyvtkReductionFilter_SetGenerateProcessIds, METH_VARARGS,
   "SetGenerateProcessIds(self, _arg:int) -> None\nC++: virtual void SetGenerateProcessIds(int _arg)\n\nWhen set, a new array vtkOriginalProcessIds will be added to the\noutput of the the pre-gather helper (or input, if no pre-gather\nhelper is set). The values in the array indicate the process id.\nNote that the array is added only if the number of processes is >\n1.\n"},
  {"GetGenerateProcessIds", PyvtkReductionFilter_GetGenerateProcessIds, METH_VARARGS,
   "GetGenerateProcessIds(self) -> int\nC++: virtual int GetGenerateProcessIds()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkReductionFilter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("reduction_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkReductionFilter_GetReductionMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkReductionFilter_SetReductionMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkReductionFilter_SetReductionMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetReductionMode/SetReductionMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("reduction_process_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkReductionFilter_GetReductionProcessId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkReductionFilter_SetReductionProcessId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkReductionFilter_SetReductionProcessId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetReductionProcessId/SetReductionProcessId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pre_gather_helper"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkReductionFilter_GetPreGatherHelper(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkReductionFilter_SetPreGatherHelper(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkReductionFilter_SetPreGatherHelper(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPreGatherHelper/SetPreGatherHelper\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pre_gather_helper_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkReductionFilter_SetPreGatherHelperName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkReductionFilter_SetPreGatherHelperName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPreGatherHelperName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("post_gather_helper"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkReductionFilter_GetPostGatherHelper(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkReductionFilter_SetPostGatherHelper(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkReductionFilter_SetPostGatherHelper(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPostGatherHelper/SetPostGatherHelper\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("post_gather_helper_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkReductionFilter_SetPostGatherHelperName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkReductionFilter_SetPostGatherHelperName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPostGatherHelperName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("controller"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkReductionFilter_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkReductionFilter_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pass_through"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkReductionFilter_GetPassThrough(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkReductionFilter_SetPassThrough(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkReductionFilter_SetPassThrough(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPassThrough/SetPassThrough\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_process_ids"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkReductionFilter_GetGenerateProcessIds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkReductionFilter_SetGenerateProcessIds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkReductionFilter_SetGenerateProcessIds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateProcessIds/SetGenerateProcessIds\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkReductionFilter_Doc =
  "vtkReductionFilter - A generic filter that can reduce any type of\ndataset using any reduction algorithm.\n\n"
  "Superclass: vtkDataObjectAlgorithm\n\n"
  "A generic filter that can reduce any type of dataset using any\n"
  "reduction algorithm. Actual reduction is performed by running the\n"
  "PreGatherHelper and PostGatherHelper algorithms. The PreGatherHelper\n"
  "runs on each node in parallel. Next the intermediate results are\n"
  "gathered to the root node. Then the root node then runs the\n"
  "PostGatherHelper algorithm to produce a single result. The\n"
  "PostGatherHelper must be an algorithm that takes multiple input\n"
  "connections and produces a single reduced output.\n\n"
  "In addition to doing reduction the PassThrough variable lets you\n"
  "choose to pass through the results of any one node instead of\n"
  "aggregating all of them together.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkReductionFilter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsMisc.vtkReductionFilter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkReductionFilter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkReductionFilter_StaticNew()
{
  return vtkReductionFilter::New();
}

PyObject *PyvtkReductionFilter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkReductionFilter_Type, PyvtkReductionFilter_Methods,
    "vtkReductionFilter",
 &PyvtkReductionFilter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDataObjectAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkReductionFilter_ReductionModeType_Type);
  PyVTKEnum_Add(&PyvtkReductionFilter_ReductionModeType_Type, "vtkReductionFilter.ReductionModeType");

  o = (PyObject *)&PyvtkReductionFilter_ReductionModeType_Type;
  if (PyDict_SetItemString(d, "ReductionModeType", o) != 0)
  {
    Py_DECREF(o);
  }

  PyType_Ready(&PyvtkReductionFilter_Tags_Type);
  PyVTKEnum_Add(&PyvtkReductionFilter_Tags_Type, "vtkReductionFilter.Tags");

  o = (PyObject *)&PyvtkReductionFilter_Tags_Type;
  if (PyDict_SetItemString(d, "Tags", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 3; c++)
  {
    typedef vtkReductionFilter::ReductionModeType cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[3] = {
        { "REDUCE_ALL_TO_ONE", vtkReductionFilter::REDUCE_ALL_TO_ONE },
        { "MOVE_ALL_TO_ONE", vtkReductionFilter::MOVE_ALL_TO_ONE },
        { "REDUCE_ALL_TO_ALL", vtkReductionFilter::REDUCE_ALL_TO_ALL },
      };

    o = PyvtkReductionFilter_ReductionModeType_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  o = PyvtkReductionFilter_Tags_FromEnum(vtkReductionFilter::TRANSMIT_DATA_OBJECT);
  if (o)
  {
    PyDict_SetItemString(d, "TRANSMIT_DATA_OBJECT", o);
    Py_DECREF(o);
  }
  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkReductionFilter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkReductionFilter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkReductionFilter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkReductionFilter", o) != 0)
  {
    Py_DECREF(o);
  }

}

