// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <LightList.h>
#include <DataNode.h>

// ****************************************************************************
// Method: LightList::LightList
//
// Purpose:
//   Init utility for the LightList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void LightList::Init()
{
    SetDefaultEnabledStates();

    LightList::SelectAll();
}

// ****************************************************************************
// Method: LightList::LightList
//
// Purpose:
//   Copy utility for the LightList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void LightList::Copy(const LightList &obj)
{
    light0 = obj.light0;
    light1 = obj.light1;
    light2 = obj.light2;
    light3 = obj.light3;
    light4 = obj.light4;
    light5 = obj.light5;
    light6 = obj.light6;
    light7 = obj.light7;

    LightList::SelectAll();
}

// Type map format string
const char *LightList::TypeMapFormatString = LIGHTLIST_TMFS;
const AttributeGroup::private_tmfs_t LightList::TmfsStruct = {LIGHTLIST_TMFS};


// ****************************************************************************
// Method: LightList::LightList
//
// Purpose:
//   Default constructor for the LightList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

LightList::LightList() :
    AttributeSubject(LightList::TypeMapFormatString)
{
    LightList::Init();
}

// ****************************************************************************
// Method: LightList::LightList
//
// Purpose:
//   Constructor for the derived classes of LightList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

LightList::LightList(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    LightList::Init();
}

// ****************************************************************************
// Method: LightList::LightList
//
// Purpose:
//   Copy constructor for the LightList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

LightList::LightList(const LightList &obj) :
    AttributeSubject(LightList::TypeMapFormatString)
{
    LightList::Copy(obj);
}

// ****************************************************************************
// Method: LightList::LightList
//
// Purpose:
//   Copy constructor for derived classes of the LightList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

LightList::LightList(const LightList &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    LightList::Copy(obj);
}

// ****************************************************************************
// Method: LightList::~LightList
//
// Purpose:
//   Destructor for the LightList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

LightList::~LightList()
{
    // nothing here
}

// ****************************************************************************
// Method: LightList::operator =
//
// Purpose:
//   Assignment operator for the LightList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

LightList&
LightList::operator = (const LightList &obj)
{
    if (this == &obj) return *this;

    LightList::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: LightList::operator ==
//
// Purpose:
//   Comparison operator == for the LightList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
LightList::operator == (const LightList &obj) const
{
    // Create the return value
    return ((light0 == obj.light0) &&
            (light1 == obj.light1) &&
            (light2 == obj.light2) &&
            (light3 == obj.light3) &&
            (light4 == obj.light4) &&
            (light5 == obj.light5) &&
            (light6 == obj.light6) &&
            (light7 == obj.light7));
}

// ****************************************************************************
// Method: LightList::operator !=
//
// Purpose:
//   Comparison operator != for the LightList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
LightList::operator != (const LightList &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: LightList::TypeName
//
// Purpose:
//   Type name method for the LightList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
LightList::TypeName() const
{
    return "LightList";
}

// ****************************************************************************
// Method: LightList::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the LightList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
LightList::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const LightList *tmp = (const LightList *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: LightList::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the LightList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
LightList::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new LightList(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: LightList::NewInstance
//
// Purpose:
//   NewInstance method for the LightList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
LightList::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new LightList(*this);
    else
        retval = new LightList;

    return retval;
}

// ****************************************************************************
// Method: LightList::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
LightList::SelectAll()
{
    Select(ID_light0, (void *)&light0);
    Select(ID_light1, (void *)&light1);
    Select(ID_light2, (void *)&light2);
    Select(ID_light3, (void *)&light3);
    Select(ID_light4, (void *)&light4);
    Select(ID_light5, (void *)&light5);
    Select(ID_light6, (void *)&light6);
    Select(ID_light7, (void *)&light7);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LightList::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
LightList::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    LightList defaultObject;
    bool addToParent = false;
    // Create a node for LightList.
    DataNode *node = new DataNode("LightList");

    if(completeSave || !FieldsEqual(ID_light0, &defaultObject))
    {
        DataNode *light0Node = new DataNode("light0");
        if(light0.CreateNode(light0Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(light0Node);
        }
        else
            delete light0Node;
    }

    if(completeSave || !FieldsEqual(ID_light1, &defaultObject))
    {
        DataNode *light1Node = new DataNode("light1");
        if(light1.CreateNode(light1Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(light1Node);
        }
        else
            delete light1Node;
    }

    if(completeSave || !FieldsEqual(ID_light2, &defaultObject))
    {
        DataNode *light2Node = new DataNode("light2");
        if(light2.CreateNode(light2Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(light2Node);
        }
        else
            delete light2Node;
    }

    if(completeSave || !FieldsEqual(ID_light3, &defaultObject))
    {
        DataNode *light3Node = new DataNode("light3");
        if(light3.CreateNode(light3Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(light3Node);
        }
        else
            delete light3Node;
    }

    if(completeSave || !FieldsEqual(ID_light4, &defaultObject))
    {
        DataNode *light4Node = new DataNode("light4");
        if(light4.CreateNode(light4Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(light4Node);
        }
        else
            delete light4Node;
    }

    if(completeSave || !FieldsEqual(ID_light5, &defaultObject))
    {
        DataNode *light5Node = new DataNode("light5");
        if(light5.CreateNode(light5Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(light5Node);
        }
        else
            delete light5Node;
    }

    if(completeSave || !FieldsEqual(ID_light6, &defaultObject))
    {
        DataNode *light6Node = new DataNode("light6");
        if(light6.CreateNode(light6Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(light6Node);
        }
        else
            delete light6Node;
    }

    if(completeSave || !FieldsEqual(ID_light7, &defaultObject))
    {
        DataNode *light7Node = new DataNode("light7");
        if(light7.CreateNode(light7Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(light7Node);
        }
        else
            delete light7Node;
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: LightList::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
LightList::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("LightList");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("light0")) != 0)
        light0.SetFromNode(node);
    if((node = searchNode->GetNode("light1")) != 0)
        light1.SetFromNode(node);
    if((node = searchNode->GetNode("light2")) != 0)
        light2.SetFromNode(node);
    if((node = searchNode->GetNode("light3")) != 0)
        light3.SetFromNode(node);
    if((node = searchNode->GetNode("light4")) != 0)
        light4.SetFromNode(node);
    if((node = searchNode->GetNode("light5")) != 0)
        light5.SetFromNode(node);
    if((node = searchNode->GetNode("light6")) != 0)
        light6.SetFromNode(node);
    if((node = searchNode->GetNode("light7")) != 0)
        light7.SetFromNode(node);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
LightList::SetLight0(const LightAttributes &light0_)
{
    light0 = light0_;
    Select(ID_light0, (void *)&light0);
}

void
LightList::SetLight1(const LightAttributes &light1_)
{
    light1 = light1_;
    Select(ID_light1, (void *)&light1);
}

void
LightList::SetLight2(const LightAttributes &light2_)
{
    light2 = light2_;
    Select(ID_light2, (void *)&light2);
}

void
LightList::SetLight3(const LightAttributes &light3_)
{
    light3 = light3_;
    Select(ID_light3, (void *)&light3);
}

void
LightList::SetLight4(const LightAttributes &light4_)
{
    light4 = light4_;
    Select(ID_light4, (void *)&light4);
}

void
LightList::SetLight5(const LightAttributes &light5_)
{
    light5 = light5_;
    Select(ID_light5, (void *)&light5);
}

void
LightList::SetLight6(const LightAttributes &light6_)
{
    light6 = light6_;
    Select(ID_light6, (void *)&light6);
}

void
LightList::SetLight7(const LightAttributes &light7_)
{
    light7 = light7_;
    Select(ID_light7, (void *)&light7);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const LightAttributes &
LightList::GetLight0() const
{
    return light0;
}

LightAttributes &
LightList::GetLight0()
{
    return light0;
}

const LightAttributes &
LightList::GetLight1() const
{
    return light1;
}

LightAttributes &
LightList::GetLight1()
{
    return light1;
}

const LightAttributes &
LightList::GetLight2() const
{
    return light2;
}

LightAttributes &
LightList::GetLight2()
{
    return light2;
}

const LightAttributes &
LightList::GetLight3() const
{
    return light3;
}

LightAttributes &
LightList::GetLight3()
{
    return light3;
}

const LightAttributes &
LightList::GetLight4() const
{
    return light4;
}

LightAttributes &
LightList::GetLight4()
{
    return light4;
}

const LightAttributes &
LightList::GetLight5() const
{
    return light5;
}

LightAttributes &
LightList::GetLight5()
{
    return light5;
}

const LightAttributes &
LightList::GetLight6() const
{
    return light6;
}

LightAttributes &
LightList::GetLight6()
{
    return light6;
}

const LightAttributes &
LightList::GetLight7() const
{
    return light7;
}

LightAttributes &
LightList::GetLight7()
{
    return light7;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
LightList::SelectLight0()
{
    Select(ID_light0, (void *)&light0);
}

void
LightList::SelectLight1()
{
    Select(ID_light1, (void *)&light1);
}

void
LightList::SelectLight2()
{
    Select(ID_light2, (void *)&light2);
}

void
LightList::SelectLight3()
{
    Select(ID_light3, (void *)&light3);
}

void
LightList::SelectLight4()
{
    Select(ID_light4, (void *)&light4);
}

void
LightList::SelectLight5()
{
    Select(ID_light5, (void *)&light5);
}

void
LightList::SelectLight6()
{
    Select(ID_light6, (void *)&light6);
}

void
LightList::SelectLight7()
{
    Select(ID_light7, (void *)&light7);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LightList::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
LightList::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_light0: return "light0";
    case ID_light1: return "light1";
    case ID_light2: return "light2";
    case ID_light3: return "light3";
    case ID_light4: return "light4";
    case ID_light5: return "light5";
    case ID_light6: return "light6";
    case ID_light7: return "light7";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LightList::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
LightList::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_light0: return FieldType_att;
    case ID_light1: return FieldType_att;
    case ID_light2: return FieldType_att;
    case ID_light3: return FieldType_att;
    case ID_light4: return FieldType_att;
    case ID_light5: return FieldType_att;
    case ID_light6: return FieldType_att;
    case ID_light7: return FieldType_att;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: LightList::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
LightList::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_light0: return "att";
    case ID_light1: return "att";
    case ID_light2: return "att";
    case ID_light3: return "att";
    case ID_light4: return "att";
    case ID_light5: return "att";
    case ID_light6: return "att";
    case ID_light7: return "att";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LightList::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
LightList::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const LightList &obj = *((const LightList*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_light0:
        {  // new scope
        retval = (light0 == obj.light0);
        }
        break;
    case ID_light1:
        {  // new scope
        retval = (light1 == obj.light1);
        }
        break;
    case ID_light2:
        {  // new scope
        retval = (light2 == obj.light2);
        }
        break;
    case ID_light3:
        {  // new scope
        retval = (light3 == obj.light3);
        }
        break;
    case ID_light4:
        {  // new scope
        retval = (light4 == obj.light4);
        }
        break;
    case ID_light5:
        {  // new scope
        retval = (light5 == obj.light5);
        }
        break;
    case ID_light6:
        {  // new scope
        retval = (light6 == obj.light6);
        }
        break;
    case ID_light7:
        {  // new scope
        retval = (light7 == obj.light7);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

const LightAttributes &
LightList::GetLight(int i) const
{
    if(i == 0)
        return light0;
    else if(i == 1)
        return light1;
    else if(i == 2)
        return light2;
    else if(i == 3)
        return light3;
    else if(i == 4)
        return light4;
    else if(i == 5)
        return light5;
    else if(i == 6)
        return light6;
    else
        return light7;
}

LightAttributes &
LightList::GetLight(int i)
{
    if(i == 0)
        return light0;
    else if(i == 1)
        return light1;
    else if(i == 2)
        return light2;
    else if(i == 3)
        return light3;
    else if(i == 4)
        return light4;
    else if(i == 5)
        return light5;
    else if(i == 6)
        return light6;
    else
        return light7;
}

int
LightList::NumLights() const
{
    return 8;
}

void
LightList::SelectLight(int i)
{
    if(i == 0)
        SelectLight0();
    else if(i == 1)
        SelectLight1();
    else if(i == 2)
        SelectLight2();
    else if(i == 3)
        SelectLight3();
    else if(i == 4)
        SelectLight4();
    else if(i == 5)
        SelectLight5();
    else if(i == 6)
        SelectLight6();
    else
        SelectLight7();
}

void
LightList::SetLight(int i, const LightAttributes &l)
{
    if(i == 0)
        SetLight0(l);
    else if(i == 1)
        SetLight1(l);
    else if(i == 2)
        SetLight2(l);
    else if(i == 3)
        SetLight3(l);
    else if(i == 4)
        SetLight4(l);
    else if(i == 5)
        SetLight5(l);
    else if(i == 6)
        SetLight6(l);
    else
        SetLight7(l);
}

void
LightList::SetDefaultEnabledStates()
{
    light0.SetEnabledFlag(true);
    light0.SetEnabledFlagCanBeToggled(false);
    light1.SetEnabledFlag(false);
    light2.SetEnabledFlag(false);
    light3.SetEnabledFlag(false);
    light4.SetEnabledFlag(false);
    light5.SetEnabledFlag(false);
    light6.SetEnabledFlag(false);
    light7.SetEnabledFlag(false);
}

