/* CellRendererExpander.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CellRendererExpander.vala, do not modify */

/*
 * Copyright 2012–2019 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "codecore.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CODE_WIDGETS_CELL_RENDERER_EXPANDER_0_PROPERTY,
	CODE_WIDGETS_CELL_RENDERER_EXPANDER_IS_CATEGORY_EXPANDER_PROPERTY,
	CODE_WIDGETS_CELL_RENDERER_EXPANDER_NUM_PROPERTIES
};
static GParamSpec* code_widgets_cell_renderer_expander_properties[CODE_WIDGETS_CELL_RENDERER_EXPANDER_NUM_PROPERTIES];

struct _CodeWidgetsCellRendererExpanderPrivate {
	gboolean _is_category_expander;
};

static gint CodeWidgetsCellRendererExpander_private_offset;
static gpointer code_widgets_cell_renderer_expander_parent_class = NULL;

static GtkSizeRequestMode code_widgets_cell_renderer_expander_real_get_request_mode (GtkCellRenderer* base);
static void code_widgets_cell_renderer_expander_real_get_preferred_width (GtkCellRenderer* base,
                                                                   GtkWidget* widget,
                                                                   gint* minimum_size,
                                                                   gint* natural_size);
static GtkStyleContext* code_widgets_cell_renderer_expander_apply_style_changes (CodeWidgetsCellRendererExpander* self,
                                                                          GtkWidget* widget);
static void code_widgets_cell_renderer_expander_revert_style_changes (CodeWidgetsCellRendererExpander* self,
                                                               GtkWidget* widget);
static void code_widgets_cell_renderer_expander_real_get_preferred_height_for_width (GtkCellRenderer* base,
                                                                              GtkWidget* widget,
                                                                              gint width,
                                                                              gint* minimum_height,
                                                                              gint* natural_height);
static gint code_widgets_cell_renderer_expander_real_get_arrow_size (CodeWidgetsCellRendererExpander* self,
                                                              GtkWidget* widget);
static void code_widgets_cell_renderer_expander_real_render (GtkCellRenderer* base,
                                                      cairo_t* context,
                                                      GtkWidget* widget,
                                                      GdkRectangle* bg_area,
                                                      GdkRectangle* cell_area,
                                                      GtkCellRendererState flags);
static void code_widgets_cell_renderer_expander_finalize (GObject * obj);
static GType code_widgets_cell_renderer_expander_get_type_once (void);
static void _vala_code_widgets_cell_renderer_expander_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec);
static void _vala_code_widgets_cell_renderer_expander_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec);

static inline gpointer
code_widgets_cell_renderer_expander_get_instance_private (CodeWidgetsCellRendererExpander* self)
{
	return G_STRUCT_MEMBER_P (self, CodeWidgetsCellRendererExpander_private_offset);
}

CodeWidgetsCellRendererExpander*
code_widgets_cell_renderer_expander_construct (GType object_type)
{
	CodeWidgetsCellRendererExpander * self = NULL;
	self = (CodeWidgetsCellRendererExpander*) g_object_new (object_type, NULL);
	return self;
}

CodeWidgetsCellRendererExpander*
code_widgets_cell_renderer_expander_new (void)
{
	return code_widgets_cell_renderer_expander_construct (CODE_WIDGETS_TYPE_CELL_RENDERER_EXPANDER);
}

static GtkSizeRequestMode
code_widgets_cell_renderer_expander_real_get_request_mode (GtkCellRenderer* base)
{
	CodeWidgetsCellRendererExpander * self;
	GtkSizeRequestMode result;
	self = (CodeWidgetsCellRendererExpander*) base;
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}

static void
code_widgets_cell_renderer_expander_real_get_preferred_width (GtkCellRenderer* base,
                                                              GtkWidget* widget,
                                                              gint* minimum_size,
                                                              gint* natural_size)
{
	CodeWidgetsCellRendererExpander * self;
	gint _vala_minimum_size = 0;
	gint _vala_natural_size = 0;
	guint _tmp0_;
	guint _tmp1_;
	self = (CodeWidgetsCellRendererExpander*) base;
	g_return_if_fail (widget != NULL);
	code_widgets_cell_renderer_expander_apply_style_changes (self, widget);
	g_object_get ((GtkCellRenderer*) self, "xpad", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_vala_natural_size = code_widgets_cell_renderer_expander_get_arrow_size (self, widget) + (2 * ((gint) _tmp1_));
	_vala_minimum_size = _vala_natural_size;
	code_widgets_cell_renderer_expander_revert_style_changes (self, widget);
	if (minimum_size) {
		*minimum_size = _vala_minimum_size;
	}
	if (natural_size) {
		*natural_size = _vala_natural_size;
	}
}

static void
code_widgets_cell_renderer_expander_real_get_preferred_height_for_width (GtkCellRenderer* base,
                                                                         GtkWidget* widget,
                                                                         gint width,
                                                                         gint* minimum_height,
                                                                         gint* natural_height)
{
	CodeWidgetsCellRendererExpander * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	guint _tmp0_;
	guint _tmp1_;
	self = (CodeWidgetsCellRendererExpander*) base;
	g_return_if_fail (widget != NULL);
	code_widgets_cell_renderer_expander_apply_style_changes (self, widget);
	g_object_get ((GtkCellRenderer*) self, "ypad", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_vala_natural_height = code_widgets_cell_renderer_expander_get_arrow_size (self, widget) + (2 * ((gint) _tmp1_));
	_vala_minimum_height = _vala_natural_height;
	code_widgets_cell_renderer_expander_revert_style_changes (self, widget);
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}

/**
     * Gets the size of the expander arrow.
     *
     * The default implementation tries to retrieve the "expander-size" style property from
     * //widget//, as it is primarily meant to be used along with a {@link Gtk.TreeView}.
     * For those with special needs, it is recommended to override this method.
     *
     * @param widget Widget used to query the "expander-size" style property (should be a Gtk.TreeView.)
     * @return Size of the expander arrow.
     * @since 0.2
     */
static gint
code_widgets_cell_renderer_expander_real_get_arrow_size (CodeWidgetsCellRendererExpander* self,
                                                         GtkWidget* widget)
{
	gint arrow_size = 0;
	gint _tmp0_ = 0;
	gint result;
	g_return_val_if_fail (widget != NULL, 0);
	gtk_widget_style_get (widget, "expander-size", &_tmp0_, NULL);
	arrow_size = _tmp0_;
	result = arrow_size;
	return result;
}

gint
code_widgets_cell_renderer_expander_get_arrow_size (CodeWidgetsCellRendererExpander* self,
                                                    GtkWidget* widget)
{
	CodeWidgetsCellRendererExpanderClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = CODE_WIDGETS_CELL_RENDERER_EXPANDER_GET_CLASS (self);
	if (_klass_->get_arrow_size) {
		return _klass_->get_arrow_size (self, widget);
	}
	return -1;
}

static void
code_widgets_cell_renderer_expander_real_render (GtkCellRenderer* base,
                                                 cairo_t* context,
                                                 GtkWidget* widget,
                                                 GdkRectangle* bg_area,
                                                 GdkRectangle* cell_area,
                                                 GtkCellRendererState flags)
{
	CodeWidgetsCellRendererExpander * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkStyleContext* ctx = NULL;
	GtkStyleContext* _tmp2_;
	GdkRectangle aligned_area = {0};
	GdkRectangle _tmp3_;
	GdkRectangle _tmp4_ = {0};
	gint arrow_size = 0;
	GdkRectangle _tmp5_;
	gint offset = 0;
	gint x = 0;
	GdkRectangle _tmp6_;
	GdkRectangle _tmp7_;
	gint y = 0;
	GdkRectangle _tmp8_;
	GdkRectangle _tmp9_;
	GtkStateFlags state = 0U;
	GtkStyleContext* _tmp10_;
	static const GtkStateFlags EXPANDED_FLAG = GTK_STATE_FLAG_CHECKED;
	GtkStateFlags _tmp11_ = 0U;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GtkStyleContext* _tmp14_;
	GtkStyleContext* _tmp15_;
	self = (CodeWidgetsCellRendererExpander*) base;
	g_return_if_fail (context != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (bg_area != NULL);
	g_return_if_fail (cell_area != NULL);
	g_object_get ((GtkCellRenderer*) self, "is-expander", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = code_widgets_cell_renderer_expander_apply_style_changes (self, widget);
	ctx = _tmp2_;
	_tmp3_ = *cell_area;
	gtk_cell_renderer_get_aligned_area ((GtkCellRenderer*) self, widget, flags, &_tmp3_, &_tmp4_);
	aligned_area = _tmp4_;
	_tmp5_ = aligned_area;
	arrow_size = MIN (code_widgets_cell_renderer_expander_get_arrow_size (self, widget), _tmp5_.width);
	offset = arrow_size / 2;
	_tmp6_ = aligned_area;
	_tmp7_ = aligned_area;
	x = (_tmp6_.x + (_tmp7_.width / 2)) - offset;
	_tmp8_ = aligned_area;
	_tmp9_ = aligned_area;
	y = (_tmp8_.y + (_tmp9_.height / 2)) - offset;
	_tmp10_ = ctx;
	state = gtk_style_context_get_state (_tmp10_);
	g_object_get ((GtkCellRenderer*) self, "is-expanded", &_tmp12_, NULL);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		_tmp11_ = state | EXPANDED_FLAG;
	} else {
		_tmp11_ = state & (~EXPANDED_FLAG);
	}
	_tmp14_ = ctx;
	gtk_style_context_set_state (_tmp14_, _tmp11_);
	_tmp15_ = ctx;
	gtk_render_expander (_tmp15_, context, (gdouble) x, (gdouble) y, (gdouble) arrow_size, (gdouble) arrow_size);
	code_widgets_cell_renderer_expander_revert_style_changes (self, widget);
}

static GtkStyleContext*
code_widgets_cell_renderer_expander_apply_style_changes (CodeWidgetsCellRendererExpander* self,
                                                         GtkWidget* widget)
{
	GtkStyleContext* ctx = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	gboolean _tmp2_;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = gtk_widget_get_style_context (widget);
	ctx = _tmp0_;
	_tmp1_ = ctx;
	gtk_style_context_save (_tmp1_);
	_tmp2_ = self->priv->_is_category_expander;
	if (_tmp2_) {
		GtkStyleContext* _tmp3_;
		_tmp3_ = ctx;
		gtk_style_context_add_class (_tmp3_, GRANITE_STYLE_CLASS_CATEGORY_EXPANDER);
	} else {
		GtkStyleContext* _tmp4_;
		_tmp4_ = ctx;
		gtk_style_context_add_class (_tmp4_, GTK_STYLE_CLASS_EXPANDER);
	}
	_tmp5_ = ctx;
	result = _tmp5_;
	return result;
}

static void
code_widgets_cell_renderer_expander_revert_style_changes (CodeWidgetsCellRendererExpander* self,
                                                          GtkWidget* widget)
{
	GtkStyleContext* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_widget_get_style_context (widget);
	gtk_style_context_restore (_tmp0_);
}

gboolean
code_widgets_cell_renderer_expander_get_is_category_expander (CodeWidgetsCellRendererExpander* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_category_expander;
	return result;
}

void
code_widgets_cell_renderer_expander_set_is_category_expander (CodeWidgetsCellRendererExpander* self,
                                                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = code_widgets_cell_renderer_expander_get_is_category_expander (self);
	if (old_value != value) {
		self->priv->_is_category_expander = value;
		g_object_notify_by_pspec ((GObject *) self, code_widgets_cell_renderer_expander_properties[CODE_WIDGETS_CELL_RENDERER_EXPANDER_IS_CATEGORY_EXPANDER_PROPERTY]);
	}
}

static void
code_widgets_cell_renderer_expander_class_init (CodeWidgetsCellRendererExpanderClass * klass,
                                                gpointer klass_data)
{
	code_widgets_cell_renderer_expander_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CodeWidgetsCellRendererExpander_private_offset);
	((GtkCellRendererClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkCellRenderer*)) code_widgets_cell_renderer_expander_real_get_request_mode;
	((GtkCellRendererClass *) klass)->get_preferred_width = (void (*) (GtkCellRenderer*, GtkWidget*, gint*, gint*)) code_widgets_cell_renderer_expander_real_get_preferred_width;
	((GtkCellRendererClass *) klass)->get_preferred_height_for_width = (void (*) (GtkCellRenderer*, GtkWidget*, gint, gint*, gint*)) code_widgets_cell_renderer_expander_real_get_preferred_height_for_width;
	((CodeWidgetsCellRendererExpanderClass *) klass)->get_arrow_size = (gint (*) (CodeWidgetsCellRendererExpander*, GtkWidget*)) code_widgets_cell_renderer_expander_real_get_arrow_size;
	((GtkCellRendererClass *) klass)->render = (void (*) (GtkCellRenderer*, cairo_t*, GtkWidget*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) code_widgets_cell_renderer_expander_real_render;
	G_OBJECT_CLASS (klass)->get_property = _vala_code_widgets_cell_renderer_expander_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_code_widgets_cell_renderer_expander_set_property;
	G_OBJECT_CLASS (klass)->finalize = code_widgets_cell_renderer_expander_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_WIDGETS_CELL_RENDERER_EXPANDER_IS_CATEGORY_EXPANDER_PROPERTY, code_widgets_cell_renderer_expander_properties[CODE_WIDGETS_CELL_RENDERER_EXPANDER_IS_CATEGORY_EXPANDER_PROPERTY] = g_param_spec_boolean ("is-category-expander", "is-category-expander", "is-category-expander", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
code_widgets_cell_renderer_expander_instance_init (CodeWidgetsCellRendererExpander * self,
                                                   gpointer klass)
{
	self->priv = code_widgets_cell_renderer_expander_get_instance_private (self);
	self->priv->_is_category_expander = FALSE;
}

static void
code_widgets_cell_renderer_expander_finalize (GObject * obj)
{
	CodeWidgetsCellRendererExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CODE_WIDGETS_TYPE_CELL_RENDERER_EXPANDER, CodeWidgetsCellRendererExpander);
	G_OBJECT_CLASS (code_widgets_cell_renderer_expander_parent_class)->finalize (obj);
}

/**
 * An expander renderer.
 *
 * For it to draw an expander, the the {@link Gtk.CellRenderer.is_expander} property must
 * be set to true; otherwise nothing is drawn. The state of the expander (i.e. expanded or
 * collapsed) is controlled by the {@link Gtk.CellRenderer.is_expanded} property.
 *
 * @since 0.2
 */
 G_GNUC_NO_INLINE static GType
code_widgets_cell_renderer_expander_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CodeWidgetsCellRendererExpanderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) code_widgets_cell_renderer_expander_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CodeWidgetsCellRendererExpander), 0, (GInstanceInitFunc) code_widgets_cell_renderer_expander_instance_init, NULL };
	GType code_widgets_cell_renderer_expander_type_id;
	code_widgets_cell_renderer_expander_type_id = g_type_register_static (gtk_cell_renderer_get_type (), "CodeWidgetsCellRendererExpander", &g_define_type_info, 0);
	CodeWidgetsCellRendererExpander_private_offset = g_type_add_instance_private (code_widgets_cell_renderer_expander_type_id, sizeof (CodeWidgetsCellRendererExpanderPrivate));
	return code_widgets_cell_renderer_expander_type_id;
}

GType
code_widgets_cell_renderer_expander_get_type (void)
{
	static gsize code_widgets_cell_renderer_expander_type_id__once = 0;
	if (g_once_init_enter (&code_widgets_cell_renderer_expander_type_id__once)) {
		GType code_widgets_cell_renderer_expander_type_id;
		code_widgets_cell_renderer_expander_type_id = code_widgets_cell_renderer_expander_get_type_once ();
		g_once_init_leave (&code_widgets_cell_renderer_expander_type_id__once, code_widgets_cell_renderer_expander_type_id);
	}
	return code_widgets_cell_renderer_expander_type_id__once;
}

static void
_vala_code_widgets_cell_renderer_expander_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec)
{
	CodeWidgetsCellRendererExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CODE_WIDGETS_TYPE_CELL_RENDERER_EXPANDER, CodeWidgetsCellRendererExpander);
	switch (property_id) {
		case CODE_WIDGETS_CELL_RENDERER_EXPANDER_IS_CATEGORY_EXPANDER_PROPERTY:
		g_value_set_boolean (value, code_widgets_cell_renderer_expander_get_is_category_expander (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_code_widgets_cell_renderer_expander_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec)
{
	CodeWidgetsCellRendererExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CODE_WIDGETS_TYPE_CELL_RENDERER_EXPANDER, CodeWidgetsCellRendererExpander);
	switch (property_id) {
		case CODE_WIDGETS_CELL_RENDERER_EXPANDER_IS_CATEGORY_EXPANDER_PROPERTY:
		code_widgets_cell_renderer_expander_set_is_category_expander (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

