/* SearchItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SearchItem.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2019-2025 elementary, Inc. (https://elementary.io)
 *                         2011-2012 Giulio Collura
 */

#include "slingshot.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define SLINGSHOT_WIDGETS_SEARCH_ITEM_ICON_SIZE 32
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SLINGSHOT_WIDGETS_SEARCH_ITEM_0_PROPERTY,
	SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_PROPERTY,
	SLINGSHOT_WIDGETS_SEARCH_ITEM_SEARCH_TERM_PROPERTY,
	SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_PROPERTY,
	SLINGSHOT_WIDGETS_SEARCH_ITEM_IMAGE_PROPERTY,
	SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_URI_PROPERTY,
	SLINGSHOT_WIDGETS_SEARCH_ITEM_NUM_PROPERTIES
};
static GParamSpec* slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
enum  {
	SLINGSHOT_WIDGETS_SEARCH_ITEM_LAUNCH_APP_SIGNAL,
	SLINGSHOT_WIDGETS_SEARCH_ITEM_NUM_SIGNALS
};
static guint slingshot_widgets_search_item_signals[SLINGSHOT_WIDGETS_SEARCH_ITEM_NUM_SIGNALS] = {0};

struct _SlingshotWidgetsSearchItemPrivate {
	SlingshotBackendApp* _app;
	gchar* _search_term;
	SlingshotWidgetsResultType _result_type;
	GtkImage* _image;
	gchar* _app_uri;
	GtkLabel* name_label;
};

static gint SlingshotWidgetsSearchItem_private_offset;
static gpointer slingshot_widgets_search_item_parent_class = NULL;

static gchar* slingshot_widgets_search_item_markup_string_with_search (const gchar* text,
                                                                const gchar* pattern);
static void slingshot_widgets_search_item_set_image (SlingshotWidgetsSearchItem* self,
                                              GtkImage* value);
static void slingshot_widgets_search_item_set_app_uri (SlingshotWidgetsSearchItem* self,
                                                const gchar* value);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static GObject * slingshot_widgets_search_item_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static gboolean _slingshot_backend_app_launch_slingshot_widgets_search_item_launch_app (SlingshotWidgetsSearchItem* _sender,
                                                                                 gpointer self);
static void slingshot_widgets_search_item_finalize (GObject * obj);
static GType slingshot_widgets_search_item_get_type_once (void);
static void _vala_slingshot_widgets_search_item_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_slingshot_widgets_search_item_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static inline gpointer
slingshot_widgets_search_item_get_instance_private (SlingshotWidgetsSearchItem* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotWidgetsSearchItem_private_offset);
}

SlingshotWidgetsSearchItem*
slingshot_widgets_search_item_construct (GType object_type,
                                         SlingshotBackendApp* app,
                                         const gchar* search_term,
                                         SlingshotWidgetsResultType result_type)
{
	SlingshotWidgetsSearchItem * self = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (search_term != NULL, NULL);
	self = (SlingshotWidgetsSearchItem*) g_object_new (object_type, "app", app, "search-term", search_term, "result-type", result_type, NULL);
	return self;
}

SlingshotWidgetsSearchItem*
slingshot_widgets_search_item_new (SlingshotBackendApp* app,
                                   const gchar* search_term,
                                   SlingshotWidgetsResultType result_type)
{
	return slingshot_widgets_search_item_construct (SLINGSHOT_WIDGETS_TYPE_SEARCH_ITEM, app, search_term, result_type);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
slingshot_widgets_search_item_markup_string_with_search (const gchar* text,
                                                         const gchar* pattern)
{
	static const char MARKUP[] = "%s";
	GeeList* matchers = NULL;
	GeeList* _tmp8_;
	gchar* highlighted = NULL;
	const gchar* _tmp49_;
	gchar* result;
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (pattern != NULL, NULL);
	if (g_strcmp0 (pattern, "") == 0) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = g_markup_escape_text (text, (gssize) -1);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strdup_printf (MARKUP, _tmp1_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		result = _tmp3_;
		return result;
	}
	if (g_strcmp0 (text, "") == 0) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = g_markup_escape_text (pattern, (gssize) -1);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf (MARKUP, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = synapse_query_get_matchers_for_query (pattern, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
	matchers = _tmp8_;
	highlighted = NULL;
	{
		GeeList* _matcher_list = NULL;
		GeeList* _tmp9_;
		gint _matcher_size = 0;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _matcher_index = 0;
		_tmp9_ = matchers;
		_matcher_list = _tmp9_;
		_tmp10_ = _matcher_list;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_matcher_size = _tmp12_;
		_matcher_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			GeeMapEntry* matcher = NULL;
			GeeList* _tmp15_;
			gpointer _tmp16_;
			GMatchInfo* mi = NULL;
			GeeMapEntry* _tmp17_;
			gconstpointer _tmp18_;
			gconstpointer _tmp19_;
			GMatchInfo* _tmp20_ = NULL;
			gboolean _tmp21_;
			_matcher_index = _matcher_index + 1;
			_tmp13_ = _matcher_index;
			_tmp14_ = _matcher_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _matcher_list;
			_tmp16_ = gee_list_get (_tmp15_, _matcher_index);
			matcher = (GeeMapEntry*) _tmp16_;
			_tmp17_ = matcher;
			_tmp18_ = gee_map_entry_get_key (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp21_ = g_regex_match ((GRegex*) _tmp19_, text, 0, &_tmp20_);
			_g_match_info_unref0 (mi);
			mi = _tmp20_;
			if (_tmp21_) {
				gint start_pos = 0;
				gint end_pos = 0;
				gint last_pos = 0;
				gint cnt = 0;
				GMatchInfo* _tmp22_;
				GString* res = NULL;
				GString* _tmp23_;
				GString* _tmp46_;
				const gchar* _tmp47_;
				gchar* _tmp48_;
				last_pos = 0;
				_tmp22_ = mi;
				cnt = g_match_info_get_match_count (_tmp22_);
				_tmp23_ = g_string_new ("");
				res = _tmp23_;
				{
					gint i = 0;
					i = 1;
					{
						gboolean _tmp24_ = FALSE;
						_tmp24_ = TRUE;
						while (TRUE) {
							GMatchInfo* _tmp26_;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							gboolean _tmp29_ = FALSE;
							GString* _tmp30_;
							gchar* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							GString* _tmp35_;
							GMatchInfo* _tmp36_;
							gchar* _tmp37_;
							gchar* _tmp38_;
							gchar* _tmp39_;
							gchar* _tmp40_;
							if (!_tmp24_) {
								gint _tmp25_;
								_tmp25_ = i;
								i = _tmp25_ + 1;
							}
							_tmp24_ = FALSE;
							if (!(i < cnt)) {
								break;
							}
							_tmp26_ = mi;
							g_match_info_fetch_pos (_tmp26_, i, &_tmp27_, &_tmp28_);
							start_pos = _tmp27_;
							end_pos = _tmp28_;
							if (start_pos >= 0) {
								_tmp29_ = end_pos >= 0;
							} else {
								_tmp29_ = FALSE;
							}
							g_warn_if_fail (_tmp29_);
							_tmp30_ = res;
							_tmp31_ = string_substring (text, (glong) last_pos, (glong) (start_pos - last_pos));
							_tmp32_ = _tmp31_;
							_tmp33_ = g_markup_escape_text (_tmp32_, (gssize) -1);
							_tmp34_ = _tmp33_;
							g_string_append (_tmp30_, _tmp34_);
							_g_free0 (_tmp34_);
							_g_free0 (_tmp32_);
							last_pos = end_pos;
							_tmp35_ = res;
							_tmp36_ = mi;
							_tmp37_ = g_match_info_fetch (_tmp36_, i);
							_tmp38_ = _tmp37_;
							_tmp39_ = g_markup_printf_escaped ("<b>%s</b>", _tmp38_);
							_tmp40_ = _tmp39_;
							g_string_append (_tmp35_, _tmp40_);
							_g_free0 (_tmp40_);
							_g_free0 (_tmp38_);
							if (i == (cnt - 1)) {
								GString* _tmp41_;
								gchar* _tmp42_;
								gchar* _tmp43_;
								gchar* _tmp44_;
								gchar* _tmp45_;
								_tmp41_ = res;
								_tmp42_ = string_substring (text, (glong) last_pos, (glong) -1);
								_tmp43_ = _tmp42_;
								_tmp44_ = g_markup_escape_text (_tmp43_, (gssize) -1);
								_tmp45_ = _tmp44_;
								g_string_append (_tmp41_, _tmp45_);
								_g_free0 (_tmp45_);
								_g_free0 (_tmp43_);
							}
						}
					}
				}
				_tmp46_ = res;
				_tmp47_ = _tmp46_->str;
				_tmp48_ = g_strdup (_tmp47_);
				_g_free0 (highlighted);
				highlighted = _tmp48_;
				_g_string_free0 (res);
				_g_match_info_unref0 (mi);
				_g_object_unref0 (matcher);
				break;
			}
			_g_match_info_unref0 (mi);
			_g_object_unref0 (matcher);
		}
	}
	_tmp49_ = highlighted;
	if (_tmp49_ != NULL) {
		const gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp50_ = highlighted;
		_tmp51_ = g_strdup_printf (MARKUP, _tmp50_);
		result = _tmp51_;
		_g_free0 (highlighted);
		_g_object_unref0 (matchers);
		return result;
	} else {
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp52_ = g_markup_escape_text (text, (gssize) -1);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strdup_printf (MARKUP, _tmp53_);
		_tmp55_ = _tmp54_;
		_g_free0 (_tmp53_);
		result = _tmp55_;
		_g_free0 (highlighted);
		_g_object_unref0 (matchers);
		return result;
	}
}

GtkMenu*
slingshot_widgets_search_item_create_context_menu (SlingshotWidgetsSearchItem* self)
{
	SlingshotWidgetsResultType _tmp0_;
	GtkMenu* context_menu = NULL;
	SlingshotBackendApp* _tmp1_;
	GMenu* _tmp2_;
	GMenu* _tmp3_;
	GtkMenu* _tmp4_;
	GtkMenu* _tmp5_;
	GtkMenu* _tmp6_;
	SlingshotBackendApp* _tmp7_;
	GSimpleActionGroup* _tmp8_;
	GSimpleActionGroup* _tmp9_;
	GtkMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_result_type;
	if (_tmp0_ != SLINGSHOT_WIDGETS_RESULT_TYPE_APPLICATION) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_app;
	_tmp2_ = slingshot_backend_app_get_menu_model (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = (GtkMenu*) gtk_menu_new_from_model ((GMenuModel*) _tmp3_);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	context_menu = _tmp5_;
	_tmp6_ = context_menu;
	_tmp7_ = self->priv->_app;
	_tmp8_ = slingshot_backend_app_get_action_group (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_widget_insert_action_group ((GtkWidget*) _tmp6_, SLINGSHOT_BACKEND_APP_ACTION_GROUP_PREFIX, (GActionGroup*) _tmp9_);
	result = context_menu;
	return result;
}

SlingshotBackendApp*
slingshot_widgets_search_item_get_app (SlingshotWidgetsSearchItem* self)
{
	SlingshotBackendApp* result;
	SlingshotBackendApp* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
slingshot_widgets_search_item_set_app (SlingshotWidgetsSearchItem* self,
                                       SlingshotBackendApp* value)
{
	SlingshotBackendApp* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_widgets_search_item_get_app (self);
	if (old_value != value) {
		SlingshotBackendApp* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app);
		self->priv->_app = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_PROPERTY]);
	}
}

const gchar*
slingshot_widgets_search_item_get_search_term (SlingshotWidgetsSearchItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_term;
	result = _tmp0_;
	return result;
}

static void
slingshot_widgets_search_item_set_search_term (SlingshotWidgetsSearchItem* self,
                                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_widgets_search_item_get_search_term (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_search_term);
		self->priv->_search_term = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_SEARCH_TERM_PROPERTY]);
	}
}

SlingshotWidgetsResultType
slingshot_widgets_search_item_get_result_type (SlingshotWidgetsSearchItem* self)
{
	SlingshotWidgetsResultType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_result_type;
	return result;
}

static void
slingshot_widgets_search_item_set_result_type (SlingshotWidgetsSearchItem* self,
                                               SlingshotWidgetsResultType value)
{
	SlingshotWidgetsResultType old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_widgets_search_item_get_result_type (self);
	if (old_value != value) {
		self->priv->_result_type = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_PROPERTY]);
	}
}

GtkImage*
slingshot_widgets_search_item_get_image (SlingshotWidgetsSearchItem* self)
{
	GtkImage* result;
	GtkImage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_image;
	result = _tmp0_;
	return result;
}

static void
slingshot_widgets_search_item_set_image (SlingshotWidgetsSearchItem* self,
                                         GtkImage* value)
{
	GtkImage* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_widgets_search_item_get_image (self);
	if (old_value != value) {
		GtkImage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_image);
		self->priv->_image = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_IMAGE_PROPERTY]);
	}
}

const gchar*
slingshot_widgets_search_item_get_app_uri (SlingshotWidgetsSearchItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_uri;
	result = _tmp0_;
	return result;
}

static void
slingshot_widgets_search_item_set_app_uri (SlingshotWidgetsSearchItem* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_widgets_search_item_get_app_uri (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_uri);
		self->priv->_app_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_URI_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_boolean (return_value, v_return);
}

static gboolean
_slingshot_backend_app_launch_slingshot_widgets_search_item_launch_app (SlingshotWidgetsSearchItem* _sender,
                                                                        gpointer self)
{
	gboolean result;
	result = slingshot_backend_app_launch ((SlingshotBackendApp*) self);
	return result;
}

static GObject *
slingshot_widgets_search_item_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotWidgetsSearchItem * self;
	gchar* markup = NULL;
	SlingshotWidgetsResultType _tmp0_;
	const gchar* _tmp20_;
	GtkLabel* _tmp21_ = NULL;
	GIcon* icon = NULL;
	SlingshotBackendApp* _tmp22_;
	GIcon* _tmp23_;
	GIcon* _tmp24_;
	GIcon* _tmp25_;
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp26_;
	gboolean _tmp27_ = FALSE;
	GIcon* _tmp28_;
	GIcon* _tmp34_;
	GIcon* _tmp35_;
	GtkImage* _tmp36_ = NULL;
	GtkImage* _tmp37_;
	SlingshotBackendApp* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gboolean _tmp41_ = FALSE;
	SlingshotBackendApp* _tmp42_;
	SynapseMatch* _tmp43_;
	SynapseMatch* _tmp44_;
	GtkBox* box = NULL;
	GtkBox* _tmp57_ = NULL;
	GtkBox* _tmp58_;
	GtkImage* _tmp59_;
	GtkBox* _tmp60_;
	GtkLabel* _tmp61_;
	GtkBox* _tmp62_;
	SlingshotWidgetsResultType _tmp63_;
	SynapseApplicationMatch* app_match = NULL;
	SlingshotBackendApp* _tmp65_;
	SynapseMatch* _tmp66_;
	SynapseMatch* _tmp67_;
	SynapseApplicationMatch* _tmp68_;
	gboolean _tmp69_ = FALSE;
	SynapseApplicationMatch* _tmp70_;
	parent_class = G_OBJECT_CLASS (slingshot_widgets_search_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_TYPE_SEARCH_ITEM, SlingshotWidgetsSearchItem);
	_tmp0_ = self->priv->_result_type;
	if (_tmp0_ == SLINGSHOT_WIDGETS_RESULT_TYPE_TEXT) {
		SlingshotBackendApp* _tmp1_;
		SynapseMatch* _tmp2_;
		SynapseMatch* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = self->priv->_app;
		_tmp2_ = slingshot_backend_app_get_match (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = synapse_match_get_title (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (markup);
		markup = _tmp6_;
	} else {
		SlingshotWidgetsResultType _tmp7_;
		_tmp7_ = self->priv->_result_type;
		if (_tmp7_ == SLINGSHOT_WIDGETS_RESULT_TYPE_APP_ACTIONS) {
			SlingshotBackendApp* _tmp8_;
			SynapseMatch* _tmp9_;
			SynapseMatch* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp8_ = self->priv->_app;
			_tmp9_ = slingshot_backend_app_get_match (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = synapse_match_get_title (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = self->priv->_search_term;
			_tmp14_ = slingshot_widgets_search_item_markup_string_with_search (_tmp12_, _tmp13_);
			_g_free0 (markup);
			markup = _tmp14_;
		} else {
			SlingshotBackendApp* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp15_ = self->priv->_app;
			_tmp16_ = slingshot_backend_app_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = self->priv->_search_term;
			_tmp19_ = slingshot_widgets_search_item_markup_string_with_search (_tmp17_, _tmp18_);
			_g_free0 (markup);
			markup = _tmp19_;
		}
	}
	_tmp20_ = markup;
	_tmp21_ = (GtkLabel*) gtk_label_new (_tmp20_);
	gtk_label_set_ellipsize (_tmp21_, PANGO_ELLIPSIZE_END);
	gtk_label_set_use_markup (_tmp21_, TRUE);
	gtk_label_set_xalign (_tmp21_, (gfloat) 0);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->name_label);
	self->priv->name_label = _tmp21_;
	_tmp22_ = self->priv->_app;
	_tmp23_ = slingshot_backend_app_get_icon (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = _g_object_ref0 (_tmp24_);
	icon = _tmp25_;
	_tmp26_ = gtk_icon_theme_get_default ();
	theme = _tmp26_;
	_tmp28_ = icon;
	if (_tmp28_ == NULL) {
		_tmp27_ = TRUE;
	} else {
		GtkIconTheme* _tmp29_;
		GIcon* _tmp30_;
		GtkIconInfo* _tmp31_;
		GtkIconInfo* _tmp32_;
		_tmp29_ = theme;
		_tmp30_ = icon;
		_tmp31_ = gtk_icon_theme_lookup_by_gicon (_tmp29_, _tmp30_, SLINGSHOT_WIDGETS_SEARCH_ITEM_ICON_SIZE, GTK_ICON_LOOKUP_USE_BUILTIN);
		_tmp32_ = _tmp31_;
		_tmp27_ = _tmp32_ == NULL;
		_g_object_unref0 (_tmp32_);
	}
	if (_tmp27_) {
		GThemedIcon* _tmp33_;
		_tmp33_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
		_g_object_unref0 (icon);
		icon = (GIcon*) _tmp33_;
	}
	_tmp34_ = icon;
	_tmp35_ = _g_object_ref0 (_tmp34_);
	_tmp36_ = (GtkImage*) gtk_image_new ();
	g_object_set (_tmp36_, "gicon", _tmp35_, NULL);
	_g_object_unref0 (_tmp35_);
	gtk_image_set_pixel_size (_tmp36_, SLINGSHOT_WIDGETS_SEARCH_ITEM_ICON_SIZE);
	g_object_ref_sink (_tmp36_);
	_tmp37_ = _tmp36_;
	slingshot_widgets_search_item_set_image (self, _tmp37_);
	_g_object_unref0 (_tmp37_);
	_tmp38_ = self->priv->_app;
	_tmp39_ = slingshot_backend_app_get_description (_tmp38_);
	_tmp40_ = _tmp39_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) self, _tmp40_);
	_tmp42_ = self->priv->_app;
	_tmp43_ = slingshot_backend_app_get_match (_tmp42_);
	_tmp44_ = _tmp43_;
	if (_tmp44_ != NULL) {
		SlingshotBackendApp* _tmp45_;
		SynapseMatch* _tmp46_;
		SynapseMatch* _tmp47_;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		_tmp45_ = self->priv->_app;
		_tmp46_ = slingshot_backend_app_get_match (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = synapse_match_get_icon_name (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp41_ = g_str_has_prefix (_tmp49_, G_DIR_SEPARATOR_S);
	} else {
		_tmp41_ = FALSE;
	}
	if (_tmp41_) {
		GdkPixbuf* pixbuf = NULL;
		SlingshotBackendApp* _tmp50_;
		SynapseMatch* _tmp51_;
		SynapseMatch* _tmp52_;
		GdkPixbuf* _tmp53_;
		GdkPixbuf* _tmp54_;
		_tmp50_ = self->priv->_app;
		_tmp51_ = slingshot_backend_app_get_match (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = slingshot_backend_synapse_search_get_pathicon_for_match (_tmp52_, SLINGSHOT_WIDGETS_SEARCH_ITEM_ICON_SIZE);
		pixbuf = _tmp53_;
		_tmp54_ = pixbuf;
		if (_tmp54_ != NULL) {
			GtkImage* _tmp55_;
			GdkPixbuf* _tmp56_;
			_tmp55_ = self->priv->_image;
			_tmp56_ = pixbuf;
			gtk_image_set_from_pixbuf (_tmp55_, _tmp56_);
		}
		_g_object_unref0 (pixbuf);
	}
	_tmp57_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp57_, 6);
	g_object_ref_sink (_tmp57_);
	box = _tmp57_;
	_tmp58_ = box;
	_tmp59_ = self->priv->_image;
	gtk_container_add ((GtkContainer*) _tmp58_, (GtkWidget*) _tmp59_);
	_tmp60_ = box;
	_tmp61_ = self->priv->name_label;
	gtk_container_add ((GtkContainer*) _tmp60_, (GtkWidget*) _tmp61_);
	_tmp62_ = box;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp62_, NULL);
	_tmp63_ = self->priv->_result_type;
	if (_tmp63_ != SLINGSHOT_WIDGETS_RESULT_TYPE_APP_ACTIONS) {
		SlingshotBackendApp* _tmp64_;
		_tmp64_ = self->priv->_app;
		g_signal_connect_object (self, "launch-app", (GCallback) _slingshot_backend_app_launch_slingshot_widgets_search_item_launch_app, _tmp64_, 0);
	}
	slingshot_widgets_search_item_set_app_uri (self, NULL);
	_tmp65_ = self->priv->_app;
	_tmp66_ = slingshot_backend_app_get_match (_tmp65_);
	_tmp67_ = _tmp66_;
	_tmp68_ = _g_object_ref0 (SYNAPSE_IS_APPLICATION_MATCH (_tmp67_) ? ((SynapseApplicationMatch*) _tmp67_) : NULL);
	app_match = _tmp68_;
	_tmp70_ = app_match;
	if (_tmp70_ != NULL) {
		SynapseApplicationMatch* _tmp71_;
		const gchar* _tmp72_;
		const gchar* _tmp73_;
		_tmp71_ = app_match;
		_tmp72_ = synapse_application_match_get_filename (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp69_ = _tmp73_ != NULL;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		SynapseApplicationMatch* _tmp74_;
		const gchar* _tmp75_;
		const gchar* _tmp76_;
		GFile* _tmp77_;
		GFile* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		_tmp74_ = app_match;
		_tmp75_ = synapse_application_match_get_filename (_tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = g_file_new_for_path (_tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = g_file_get_uri (_tmp78_);
		_tmp80_ = _tmp79_;
		slingshot_widgets_search_item_set_app_uri (self, _tmp80_);
		_g_free0 (_tmp80_);
		_g_object_unref0 (_tmp78_);
	}
	_g_object_unref0 (app_match);
	_g_object_unref0 (box);
	_g_object_unref0 (icon);
	_g_free0 (markup);
	return obj;
}

static void
slingshot_widgets_search_item_base_init (SlingshotWidgetsSearchItemClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "modelbutton");
}

static void
slingshot_widgets_search_item_class_init (SlingshotWidgetsSearchItemClass * klass,
                                          gpointer klass_data)
{
	slingshot_widgets_search_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotWidgetsSearchItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_widgets_search_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_widgets_search_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_widgets_search_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_widgets_search_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_PROPERTY, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_PROPERTY] = g_param_spec_object ("app", "app", "app", SLINGSHOT_BACKEND_TYPE_APP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_SEARCH_ITEM_SEARCH_TERM_PROPERTY, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_SEARCH_TERM_PROPERTY] = g_param_spec_string ("search-term", "search-term", "search-term", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_PROPERTY, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_PROPERTY] = g_param_spec_enum ("result-type", "result-type", "result-type", SLINGSHOT_WIDGETS_TYPE_RESULT_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_SEARCH_ITEM_IMAGE_PROPERTY, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_IMAGE_PROPERTY] = g_param_spec_object ("image", "image", "image", gtk_image_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_URI_PROPERTY, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_URI_PROPERTY] = g_param_spec_string ("app-uri", "app-uri", "app-uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	slingshot_widgets_search_item_signals[SLINGSHOT_WIDGETS_SEARCH_ITEM_LAUNCH_APP_SIGNAL] = g_signal_new ("launch-app", SLINGSHOT_WIDGETS_TYPE_SEARCH_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
}

static void
slingshot_widgets_search_item_instance_init (SlingshotWidgetsSearchItem * self,
                                             gpointer klass)
{
	self->priv = slingshot_widgets_search_item_get_instance_private (self);
}

static void
slingshot_widgets_search_item_finalize (GObject * obj)
{
	SlingshotWidgetsSearchItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_TYPE_SEARCH_ITEM, SlingshotWidgetsSearchItem);
	_g_object_unref0 (self->priv->_app);
	_g_free0 (self->priv->_search_term);
	_g_object_unref0 (self->priv->_image);
	_g_free0 (self->priv->_app_uri);
	_g_object_unref0 (self->priv->name_label);
	G_OBJECT_CLASS (slingshot_widgets_search_item_parent_class)->finalize (obj);
}

static GType
slingshot_widgets_search_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotWidgetsSearchItemClass), (GBaseInitFunc) slingshot_widgets_search_item_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_widgets_search_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotWidgetsSearchItem), 0, (GInstanceInitFunc) slingshot_widgets_search_item_instance_init, NULL };
	GType slingshot_widgets_search_item_type_id;
	slingshot_widgets_search_item_type_id = g_type_register_static (gtk_list_box_row_get_type (), "SlingshotWidgetsSearchItem", &g_define_type_info, 0);
	SlingshotWidgetsSearchItem_private_offset = g_type_add_instance_private (slingshot_widgets_search_item_type_id, sizeof (SlingshotWidgetsSearchItemPrivate));
	return slingshot_widgets_search_item_type_id;
}

GType
slingshot_widgets_search_item_get_type (void)
{
	static volatile gsize slingshot_widgets_search_item_type_id__once = 0;
	if (g_once_init_enter (&slingshot_widgets_search_item_type_id__once)) {
		GType slingshot_widgets_search_item_type_id;
		slingshot_widgets_search_item_type_id = slingshot_widgets_search_item_get_type_once ();
		g_once_init_leave (&slingshot_widgets_search_item_type_id__once, slingshot_widgets_search_item_type_id);
	}
	return slingshot_widgets_search_item_type_id__once;
}

static void
_vala_slingshot_widgets_search_item_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	SlingshotWidgetsSearchItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_WIDGETS_TYPE_SEARCH_ITEM, SlingshotWidgetsSearchItem);
	switch (property_id) {
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_PROPERTY:
		g_value_set_object (value, slingshot_widgets_search_item_get_app (self));
		break;
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_SEARCH_TERM_PROPERTY:
		g_value_set_string (value, slingshot_widgets_search_item_get_search_term (self));
		break;
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_PROPERTY:
		g_value_set_enum (value, slingshot_widgets_search_item_get_result_type (self));
		break;
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_IMAGE_PROPERTY:
		g_value_set_object (value, slingshot_widgets_search_item_get_image (self));
		break;
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_URI_PROPERTY:
		g_value_set_string (value, slingshot_widgets_search_item_get_app_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_widgets_search_item_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	SlingshotWidgetsSearchItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_WIDGETS_TYPE_SEARCH_ITEM, SlingshotWidgetsSearchItem);
	switch (property_id) {
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_PROPERTY:
		slingshot_widgets_search_item_set_app (self, g_value_get_object (value));
		break;
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_SEARCH_TERM_PROPERTY:
		slingshot_widgets_search_item_set_search_term (self, g_value_get_string (value));
		break;
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_PROPERTY:
		slingshot_widgets_search_item_set_result_type (self, g_value_get_enum (value));
		break;
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_IMAGE_PROPERTY:
		slingshot_widgets_search_item_set_image (self, g_value_get_object (value));
		break;
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_URI_PROPERTY:
		slingshot_widgets_search_item_set_app_uri (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

