// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the VPC resources, VPC endpoint services, Amazon Lattice services, or
// service networks associated with the VPC endpoint.
func (c *Client) DescribeVpcEndpointAssociations(ctx context.Context, params *DescribeVpcEndpointAssociationsInput, optFns ...func(*Options)) (*DescribeVpcEndpointAssociationsOutput, error) {
	if params == nil {
		params = &DescribeVpcEndpointAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeVpcEndpointAssociations", params, optFns, c.addOperationDescribeVpcEndpointAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeVpcEndpointAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeVpcEndpointAssociationsInput struct {

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The filters.
	//
	//   - vpc-endpoint-id - The ID of the VPC endpoint.
	//
	//   - associated-resource-accessibility - The association state. When the state is
	//   accessible , it returns AVAILABLE . When the state is inaccessible , it
	//   returns PENDING or FAILED .
	//
	//   - association-id - The ID of the VPC endpoint association.
	//
	//   - associated-resource-id - The ID of the associated resource configuration.
	//
	//   - service-network-arn - The Amazon Resource Name (ARN) of the associated
	//   service network. Only VPC endpoints of type service network will be returned.
	//
	//   - resource-configuration-group-arn - The Amazon Resource Name (ARN) of the
	//   resource configuration of type GROUP.
	//
	//   - service-network-resource-association-id - The ID of the association.
	Filters []types.Filter

	// The maximum page size.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	// The IDs of the VPC endpoints.
	VpcEndpointIds []string

	noSmithyDocumentSerde
}

type DescribeVpcEndpointAssociationsOutput struct {

	// The pagination token.
	NextToken *string

	// Details of the endpoint associations.
	VpcEndpointAssociations []types.VpcEndpointAssociation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeVpcEndpointAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeVpcEndpointAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeVpcEndpointAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeVpcEndpointAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeVpcEndpointAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeVpcEndpointAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeVpcEndpointAssociations",
	}
}
