#include "src/objects/hole.h"

namespace v8 {
namespace internal {

// Definition https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/hole.tq?l=5&c=1
class TorqueGeneratedHoleAsserts {
  static constexpr int kStartOfWeakFieldsOffset = sizeof(HeapObjectLayout);
  static constexpr int kEndOfWeakFieldsOffset = sizeof(HeapObjectLayout);
  static constexpr int kStartOfStrongFieldsOffset = sizeof(HeapObjectLayout);
  static constexpr int kEndOfStrongFieldsOffset = sizeof(HeapObjectLayout);
  static constexpr int kHeaderSize = sizeof(HeapObjectLayout);
  static constexpr int kSize = sizeof(HeapObjectLayout);

  static_assert(kSize == sizeof(Hole));
};

// Definition https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/hole.tq?l=9&c=1
class TorqueGeneratedTheHoleAsserts {
  static constexpr int kStartOfWeakFieldsOffset = sizeof(Hole);
  static constexpr int kEndOfWeakFieldsOffset = sizeof(Hole);
  static constexpr int kStartOfStrongFieldsOffset = sizeof(Hole);
  static constexpr int kEndOfStrongFieldsOffset = sizeof(Hole);
  static constexpr int kHeaderSize = sizeof(Hole);
  static constexpr int kSize = sizeof(Hole);

  static_assert(kSize == sizeof(TheHole));
};

// Definition https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/hole.tq?l=14&c=1
class TorqueGeneratedPromiseHoleAsserts {
  static constexpr int kStartOfWeakFieldsOffset = sizeof(Hole);
  static constexpr int kEndOfWeakFieldsOffset = sizeof(Hole);
  static constexpr int kStartOfStrongFieldsOffset = sizeof(Hole);
  static constexpr int kEndOfStrongFieldsOffset = sizeof(Hole);
  static constexpr int kHeaderSize = sizeof(Hole);
  static constexpr int kSize = sizeof(Hole);

  static_assert(kSize == sizeof(PromiseHole));
};

} // namespace internal
} // namespace v8
