/* parsed class NVC6B5 */

#include "nvtypes.h"
#include "clc6b5.h"

#include <assert.h>
#include <stdio.h>
#include "util/u_math.h"

struct nv_nvc6b5_NOP {
    uint32_t parameter;
};

static inline void
__NVC6B5_NOP(uint32_t *val_out, struct nv_nvc6b5_NOP st)
{
    uint32_t val = 0;
    
    val |= st.parameter;
    *val_out = val;
}

#define V_NVC6B5_NOP(val, args...) { \
    struct nv_nvc6b5_NOP __data = { .parameter = (args) }; \
    __NVC6B5_NOP(&val, __data); \
}

#define VA_NVC6B5_NOP V_NVC6B5_NOP

#define P_NVC6B5_NOP(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_NOP(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_NOP, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_PM_TRIGGER {
    uint32_t v;
};

static inline void
__NVC6B5_PM_TRIGGER(uint32_t *val_out, struct nv_nvc6b5_PM_TRIGGER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC6B5_PM_TRIGGER(val, args...) { \
    struct nv_nvc6b5_PM_TRIGGER __data = { .v = (args) }; \
    __NVC6B5_PM_TRIGGER(&val, __data); \
}

#define VA_NVC6B5_PM_TRIGGER V_NVC6B5_PM_TRIGGER

#define P_NVC6B5_PM_TRIGGER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_PM_TRIGGER(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_PM_TRIGGER, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_SEMAPHORE_A {
    uint32_t upper;
};

static inline void
__NVC6B5_SET_SEMAPHORE_A(uint32_t *val_out, struct nv_nvc6b5_SET_SEMAPHORE_A st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 17));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NVC6B5_SET_SEMAPHORE_A(val, args...) { \
    struct nv_nvc6b5_SET_SEMAPHORE_A __data = { .upper = (args) }; \
    __NVC6B5_SET_SEMAPHORE_A(&val, __data); \
}

#define VA_NVC6B5_SET_SEMAPHORE_A V_NVC6B5_SET_SEMAPHORE_A

#define P_NVC6B5_SET_SEMAPHORE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_SEMAPHORE_A(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_SEMAPHORE_A, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_SEMAPHORE_B {
    uint32_t lower;
};

static inline void
__NVC6B5_SET_SEMAPHORE_B(uint32_t *val_out, struct nv_nvc6b5_SET_SEMAPHORE_B st)
{
    uint32_t val = 0;
    
    val |= st.lower;
    *val_out = val;
}

#define V_NVC6B5_SET_SEMAPHORE_B(val, args...) { \
    struct nv_nvc6b5_SET_SEMAPHORE_B __data = { .lower = (args) }; \
    __NVC6B5_SET_SEMAPHORE_B(&val, __data); \
}

#define VA_NVC6B5_SET_SEMAPHORE_B V_NVC6B5_SET_SEMAPHORE_B

#define P_NVC6B5_SET_SEMAPHORE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_SEMAPHORE_B(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_SEMAPHORE_B, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_SEMAPHORE_PAYLOAD {
    uint32_t payload;
};

static inline void
__NVC6B5_SET_SEMAPHORE_PAYLOAD(uint32_t *val_out, struct nv_nvc6b5_SET_SEMAPHORE_PAYLOAD st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVC6B5_SET_SEMAPHORE_PAYLOAD(val, args...) { \
    struct nv_nvc6b5_SET_SEMAPHORE_PAYLOAD __data = { .payload = (args) }; \
    __NVC6B5_SET_SEMAPHORE_PAYLOAD(&val, __data); \
}

#define VA_NVC6B5_SET_SEMAPHORE_PAYLOAD V_NVC6B5_SET_SEMAPHORE_PAYLOAD

#define P_NVC6B5_SET_SEMAPHORE_PAYLOAD(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_SEMAPHORE_PAYLOAD(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_SEMAPHORE_PAYLOAD, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_RENDER_ENABLE_A {
    uint32_t upper;
};

static inline void
__NVC6B5_SET_RENDER_ENABLE_A(uint32_t *val_out, struct nv_nvc6b5_SET_RENDER_ENABLE_A st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 8));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NVC6B5_SET_RENDER_ENABLE_A(val, args...) { \
    struct nv_nvc6b5_SET_RENDER_ENABLE_A __data = { .upper = (args) }; \
    __NVC6B5_SET_RENDER_ENABLE_A(&val, __data); \
}

#define VA_NVC6B5_SET_RENDER_ENABLE_A V_NVC6B5_SET_RENDER_ENABLE_A

#define P_NVC6B5_SET_RENDER_ENABLE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_RENDER_ENABLE_A(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_RENDER_ENABLE_A, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_RENDER_ENABLE_B {
    uint32_t lower;
};

static inline void
__NVC6B5_SET_RENDER_ENABLE_B(uint32_t *val_out, struct nv_nvc6b5_SET_RENDER_ENABLE_B st)
{
    uint32_t val = 0;
    
    val |= st.lower;
    *val_out = val;
}

#define V_NVC6B5_SET_RENDER_ENABLE_B(val, args...) { \
    struct nv_nvc6b5_SET_RENDER_ENABLE_B __data = { .lower = (args) }; \
    __NVC6B5_SET_RENDER_ENABLE_B(&val, __data); \
}

#define VA_NVC6B5_SET_RENDER_ENABLE_B V_NVC6B5_SET_RENDER_ENABLE_B

#define P_NVC6B5_SET_RENDER_ENABLE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_RENDER_ENABLE_B(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_RENDER_ENABLE_B, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_RENDER_ENABLE_C {
    uint32_t mode;
};

static inline void
__NVC6B5_SET_RENDER_ENABLE_C(uint32_t *val_out, struct nv_nvc6b5_SET_RENDER_ENABLE_C st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 3));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NVC6B5_SET_RENDER_ENABLE_C(val, args...) { \
    UNUSED uint32_t MODE_FALSE = NVC6B5_SET_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NVC6B5_SET_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NVC6B5_SET_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NVC6B5_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NVC6B5_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    struct nv_nvc6b5_SET_RENDER_ENABLE_C __data = { .mode = (args) }; \
    __NVC6B5_SET_RENDER_ENABLE_C(&val, __data); \
}

#define VA_NVC6B5_SET_RENDER_ENABLE_C V_NVC6B5_SET_RENDER_ENABLE_C

#define P_NVC6B5_SET_RENDER_ENABLE_C(push, args...) do { \
    UNUSED uint32_t MODE_FALSE = NVC6B5_SET_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NVC6B5_SET_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NVC6B5_SET_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NVC6B5_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NVC6B5_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_RENDER_ENABLE_C(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_RENDER_ENABLE_C, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_SRC_PHYS_MODE {
    uint32_t target;
    uint32_t basic_kind;
    uint32_t peer_id;
    uint32_t fla;
};

static inline void
__NVC6B5_SET_SRC_PHYS_MODE(uint32_t *val_out, struct nv_nvc6b5_SET_SRC_PHYS_MODE st)
{
    uint32_t val = 0;
    
    assert(st.target < (1ULL << 2));
    val |= st.target << 0;
    
    assert(st.basic_kind < (1ULL << 4));
    val |= st.basic_kind << 2;
    
    assert(st.peer_id < (1ULL << 3));
    val |= st.peer_id << 6;
    
    assert(st.fla < (1ULL << 1));
    val |= st.fla << 9;
    *val_out = val;
}

#define V_NVC6B5_SET_SRC_PHYS_MODE(val, args...) { \
    UNUSED uint32_t TARGET_LOCAL_FB = NVC6B5_SET_SRC_PHYS_MODE_TARGET_LOCAL_FB; \
    UNUSED uint32_t TARGET_COHERENT_SYSMEM = NVC6B5_SET_SRC_PHYS_MODE_TARGET_COHERENT_SYSMEM; \
    UNUSED uint32_t TARGET_NONCOHERENT_SYSMEM = NVC6B5_SET_SRC_PHYS_MODE_TARGET_NONCOHERENT_SYSMEM; \
    UNUSED uint32_t TARGET_PEERMEM = NVC6B5_SET_SRC_PHYS_MODE_TARGET_PEERMEM; \
    struct nv_nvc6b5_SET_SRC_PHYS_MODE __data = args; \
    __NVC6B5_SET_SRC_PHYS_MODE(&val, __data); \
}

#define VA_NVC6B5_SET_SRC_PHYS_MODE V_NVC6B5_SET_SRC_PHYS_MODE

#define P_NVC6B5_SET_SRC_PHYS_MODE(push, args...) do { \
    UNUSED uint32_t TARGET_LOCAL_FB = NVC6B5_SET_SRC_PHYS_MODE_TARGET_LOCAL_FB; \
    UNUSED uint32_t TARGET_COHERENT_SYSMEM = NVC6B5_SET_SRC_PHYS_MODE_TARGET_COHERENT_SYSMEM; \
    UNUSED uint32_t TARGET_NONCOHERENT_SYSMEM = NVC6B5_SET_SRC_PHYS_MODE_TARGET_NONCOHERENT_SYSMEM; \
    UNUSED uint32_t TARGET_PEERMEM = NVC6B5_SET_SRC_PHYS_MODE_TARGET_PEERMEM; \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_SRC_PHYS_MODE(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_SRC_PHYS_MODE, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_DST_PHYS_MODE {
    uint32_t target;
    uint32_t basic_kind;
    uint32_t peer_id;
    uint32_t fla;
};

static inline void
__NVC6B5_SET_DST_PHYS_MODE(uint32_t *val_out, struct nv_nvc6b5_SET_DST_PHYS_MODE st)
{
    uint32_t val = 0;
    
    assert(st.target < (1ULL << 2));
    val |= st.target << 0;
    
    assert(st.basic_kind < (1ULL << 4));
    val |= st.basic_kind << 2;
    
    assert(st.peer_id < (1ULL << 3));
    val |= st.peer_id << 6;
    
    assert(st.fla < (1ULL << 1));
    val |= st.fla << 9;
    *val_out = val;
}

#define V_NVC6B5_SET_DST_PHYS_MODE(val, args...) { \
    UNUSED uint32_t TARGET_LOCAL_FB = NVC6B5_SET_DST_PHYS_MODE_TARGET_LOCAL_FB; \
    UNUSED uint32_t TARGET_COHERENT_SYSMEM = NVC6B5_SET_DST_PHYS_MODE_TARGET_COHERENT_SYSMEM; \
    UNUSED uint32_t TARGET_NONCOHERENT_SYSMEM = NVC6B5_SET_DST_PHYS_MODE_TARGET_NONCOHERENT_SYSMEM; \
    UNUSED uint32_t TARGET_PEERMEM = NVC6B5_SET_DST_PHYS_MODE_TARGET_PEERMEM; \
    struct nv_nvc6b5_SET_DST_PHYS_MODE __data = args; \
    __NVC6B5_SET_DST_PHYS_MODE(&val, __data); \
}

#define VA_NVC6B5_SET_DST_PHYS_MODE V_NVC6B5_SET_DST_PHYS_MODE

#define P_NVC6B5_SET_DST_PHYS_MODE(push, args...) do { \
    UNUSED uint32_t TARGET_LOCAL_FB = NVC6B5_SET_DST_PHYS_MODE_TARGET_LOCAL_FB; \
    UNUSED uint32_t TARGET_COHERENT_SYSMEM = NVC6B5_SET_DST_PHYS_MODE_TARGET_COHERENT_SYSMEM; \
    UNUSED uint32_t TARGET_NONCOHERENT_SYSMEM = NVC6B5_SET_DST_PHYS_MODE_TARGET_NONCOHERENT_SYSMEM; \
    UNUSED uint32_t TARGET_PEERMEM = NVC6B5_SET_DST_PHYS_MODE_TARGET_PEERMEM; \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_DST_PHYS_MODE(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_DST_PHYS_MODE, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_LAUNCH_DMA {
    uint32_t data_transfer_type;
    uint32_t flush_enable;
    uint32_t flush_type;
    uint32_t semaphore_type;
    uint32_t interrupt_type;
    uint32_t src_memory_layout;
    uint32_t dst_memory_layout;
    uint32_t multi_line_enable;
    uint32_t remap_enable;
    uint32_t force_rmwdisable;
    uint32_t src_type;
    uint32_t dst_type;
    uint32_t semaphore_reduction;
    uint32_t semaphore_reduction_sign;
    uint32_t semaphore_reduction_enable;
    uint32_t vprmode;
    uint32_t reserved_start_of_copy;
    uint32_t disable_plc;
    uint32_t reserved_err_code;
};

static inline void
__NVC6B5_LAUNCH_DMA(uint32_t *val_out, struct nv_nvc6b5_LAUNCH_DMA st)
{
    uint32_t val = 0;
    
    assert(st.data_transfer_type < (1ULL << 2));
    val |= st.data_transfer_type << 0;
    
    assert(st.flush_enable < (1ULL << 1));
    val |= st.flush_enable << 2;
    
    assert(st.flush_type < (1ULL << 1));
    val |= st.flush_type << 25;
    
    assert(st.semaphore_type < (1ULL << 2));
    val |= st.semaphore_type << 3;
    
    assert(st.interrupt_type < (1ULL << 2));
    val |= st.interrupt_type << 5;
    
    assert(st.src_memory_layout < (1ULL << 1));
    val |= st.src_memory_layout << 7;
    
    assert(st.dst_memory_layout < (1ULL << 1));
    val |= st.dst_memory_layout << 8;
    
    assert(st.multi_line_enable < (1ULL << 1));
    val |= st.multi_line_enable << 9;
    
    assert(st.remap_enable < (1ULL << 1));
    val |= st.remap_enable << 10;
    
    assert(st.force_rmwdisable < (1ULL << 1));
    val |= st.force_rmwdisable << 11;
    
    assert(st.src_type < (1ULL << 1));
    val |= st.src_type << 12;
    
    assert(st.dst_type < (1ULL << 1));
    val |= st.dst_type << 13;
    
    assert(st.semaphore_reduction < (1ULL << 4));
    val |= st.semaphore_reduction << 14;
    
    assert(st.semaphore_reduction_sign < (1ULL << 1));
    val |= st.semaphore_reduction_sign << 18;
    
    assert(st.semaphore_reduction_enable < (1ULL << 1));
    val |= st.semaphore_reduction_enable << 19;
    
    assert(st.vprmode < (1ULL << 2));
    val |= st.vprmode << 22;
    
    assert(st.reserved_start_of_copy < (1ULL << 1));
    val |= st.reserved_start_of_copy << 24;
    
    assert(st.disable_plc < (1ULL << 1));
    val |= st.disable_plc << 26;
    
    assert(st.reserved_err_code < (1ULL << 4));
    val |= st.reserved_err_code << 28;
    *val_out = val;
}

#define V_NVC6B5_LAUNCH_DMA(val, args...) { \
    UNUSED uint32_t DATA_TRANSFER_TYPE_NONE = NVC6B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NONE; \
    UNUSED uint32_t DATA_TRANSFER_TYPE_PIPELINED = NVC6B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_PIPELINED; \
    UNUSED uint32_t DATA_TRANSFER_TYPE_NON_PIPELINED = NVC6B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NON_PIPELINED; \
    UNUSED uint32_t FLUSH_ENABLE_FALSE = NVC6B5_LAUNCH_DMA_FLUSH_ENABLE_FALSE; \
    UNUSED uint32_t FLUSH_ENABLE_TRUE = NVC6B5_LAUNCH_DMA_FLUSH_ENABLE_TRUE; \
    UNUSED uint32_t FLUSH_TYPE_SYS = NVC6B5_LAUNCH_DMA_FLUSH_TYPE_SYS; \
    UNUSED uint32_t FLUSH_TYPE_GL = NVC6B5_LAUNCH_DMA_FLUSH_TYPE_GL; \
    UNUSED uint32_t SEMAPHORE_TYPE_NONE = NVC6B5_LAUNCH_DMA_SEMAPHORE_TYPE_NONE; \
    UNUSED uint32_t SEMAPHORE_TYPE_RELEASE_ONE_WORD_SEMAPHORE = NVC6B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_ONE_WORD_SEMAPHORE; \
    UNUSED uint32_t SEMAPHORE_TYPE_RELEASE_FOUR_WORD_SEMAPHORE = NVC6B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_FOUR_WORD_SEMAPHORE; \
    UNUSED uint32_t SEMAPHORE_TYPE_RELEASE_CONDITIONAL_INTR_SEMAPHORE = NVC6B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_CONDITIONAL_INTR_SEMAPHORE; \
    UNUSED uint32_t INTERRUPT_TYPE_NONE = NVC6B5_LAUNCH_DMA_INTERRUPT_TYPE_NONE; \
    UNUSED uint32_t INTERRUPT_TYPE_BLOCKING = NVC6B5_LAUNCH_DMA_INTERRUPT_TYPE_BLOCKING; \
    UNUSED uint32_t INTERRUPT_TYPE_NON_BLOCKING = NVC6B5_LAUNCH_DMA_INTERRUPT_TYPE_NON_BLOCKING; \
    UNUSED uint32_t SRC_MEMORY_LAYOUT_BLOCKLINEAR = NVC6B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_BLOCKLINEAR; \
    UNUSED uint32_t SRC_MEMORY_LAYOUT_PITCH = NVC6B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_PITCH; \
    UNUSED uint32_t DST_MEMORY_LAYOUT_BLOCKLINEAR = NVC6B5_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR; \
    UNUSED uint32_t DST_MEMORY_LAYOUT_PITCH = NVC6B5_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH; \
    UNUSED uint32_t MULTI_LINE_ENABLE_FALSE = NVC6B5_LAUNCH_DMA_MULTI_LINE_ENABLE_FALSE; \
    UNUSED uint32_t MULTI_LINE_ENABLE_TRUE = NVC6B5_LAUNCH_DMA_MULTI_LINE_ENABLE_TRUE; \
    UNUSED uint32_t REMAP_ENABLE_FALSE = NVC6B5_LAUNCH_DMA_REMAP_ENABLE_FALSE; \
    UNUSED uint32_t REMAP_ENABLE_TRUE = NVC6B5_LAUNCH_DMA_REMAP_ENABLE_TRUE; \
    UNUSED uint32_t FORCE_RMWDISABLE_FALSE = NVC6B5_LAUNCH_DMA_FORCE_RMWDISABLE_FALSE; \
    UNUSED uint32_t FORCE_RMWDISABLE_TRUE = NVC6B5_LAUNCH_DMA_FORCE_RMWDISABLE_TRUE; \
    UNUSED uint32_t SRC_TYPE_VIRTUAL = NVC6B5_LAUNCH_DMA_SRC_TYPE_VIRTUAL; \
    UNUSED uint32_t SRC_TYPE_PHYSICAL = NVC6B5_LAUNCH_DMA_SRC_TYPE_PHYSICAL; \
    UNUSED uint32_t DST_TYPE_VIRTUAL = NVC6B5_LAUNCH_DMA_DST_TYPE_VIRTUAL; \
    UNUSED uint32_t DST_TYPE_PHYSICAL = NVC6B5_LAUNCH_DMA_DST_TYPE_PHYSICAL; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IMIN = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMIN; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IMAX = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMAX; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IXOR = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IXOR; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IAND = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IAND; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IOR = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IOR; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IADD = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IADD; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_INC = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_INC; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_DEC = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_DEC; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_FADD = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FADD; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_SIGN_SIGNED = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN_SIGNED; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_SIGN_UNSIGNED = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN_UNSIGNED; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_ENABLE_FALSE = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE_FALSE; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_ENABLE_TRUE = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE_TRUE; \
    UNUSED uint32_t VPRMODE_VPR_NONE = NVC6B5_LAUNCH_DMA_VPRMODE_VPR_NONE; \
    UNUSED uint32_t VPRMODE_VPR_VID2VID = NVC6B5_LAUNCH_DMA_VPRMODE_VPR_VID2VID; \
    UNUSED uint32_t DISABLE_PLC_FALSE = NVC6B5_LAUNCH_DMA_DISABLE_PLC_FALSE; \
    UNUSED uint32_t DISABLE_PLC_TRUE = NVC6B5_LAUNCH_DMA_DISABLE_PLC_TRUE; \
    struct nv_nvc6b5_LAUNCH_DMA __data = args; \
    __NVC6B5_LAUNCH_DMA(&val, __data); \
}

#define VA_NVC6B5_LAUNCH_DMA V_NVC6B5_LAUNCH_DMA

#define P_NVC6B5_LAUNCH_DMA(push, args...) do { \
    UNUSED uint32_t DATA_TRANSFER_TYPE_NONE = NVC6B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NONE; \
    UNUSED uint32_t DATA_TRANSFER_TYPE_PIPELINED = NVC6B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_PIPELINED; \
    UNUSED uint32_t DATA_TRANSFER_TYPE_NON_PIPELINED = NVC6B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NON_PIPELINED; \
    UNUSED uint32_t FLUSH_ENABLE_FALSE = NVC6B5_LAUNCH_DMA_FLUSH_ENABLE_FALSE; \
    UNUSED uint32_t FLUSH_ENABLE_TRUE = NVC6B5_LAUNCH_DMA_FLUSH_ENABLE_TRUE; \
    UNUSED uint32_t FLUSH_TYPE_SYS = NVC6B5_LAUNCH_DMA_FLUSH_TYPE_SYS; \
    UNUSED uint32_t FLUSH_TYPE_GL = NVC6B5_LAUNCH_DMA_FLUSH_TYPE_GL; \
    UNUSED uint32_t SEMAPHORE_TYPE_NONE = NVC6B5_LAUNCH_DMA_SEMAPHORE_TYPE_NONE; \
    UNUSED uint32_t SEMAPHORE_TYPE_RELEASE_ONE_WORD_SEMAPHORE = NVC6B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_ONE_WORD_SEMAPHORE; \
    UNUSED uint32_t SEMAPHORE_TYPE_RELEASE_FOUR_WORD_SEMAPHORE = NVC6B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_FOUR_WORD_SEMAPHORE; \
    UNUSED uint32_t SEMAPHORE_TYPE_RELEASE_CONDITIONAL_INTR_SEMAPHORE = NVC6B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_CONDITIONAL_INTR_SEMAPHORE; \
    UNUSED uint32_t INTERRUPT_TYPE_NONE = NVC6B5_LAUNCH_DMA_INTERRUPT_TYPE_NONE; \
    UNUSED uint32_t INTERRUPT_TYPE_BLOCKING = NVC6B5_LAUNCH_DMA_INTERRUPT_TYPE_BLOCKING; \
    UNUSED uint32_t INTERRUPT_TYPE_NON_BLOCKING = NVC6B5_LAUNCH_DMA_INTERRUPT_TYPE_NON_BLOCKING; \
    UNUSED uint32_t SRC_MEMORY_LAYOUT_BLOCKLINEAR = NVC6B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_BLOCKLINEAR; \
    UNUSED uint32_t SRC_MEMORY_LAYOUT_PITCH = NVC6B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_PITCH; \
    UNUSED uint32_t DST_MEMORY_LAYOUT_BLOCKLINEAR = NVC6B5_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR; \
    UNUSED uint32_t DST_MEMORY_LAYOUT_PITCH = NVC6B5_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH; \
    UNUSED uint32_t MULTI_LINE_ENABLE_FALSE = NVC6B5_LAUNCH_DMA_MULTI_LINE_ENABLE_FALSE; \
    UNUSED uint32_t MULTI_LINE_ENABLE_TRUE = NVC6B5_LAUNCH_DMA_MULTI_LINE_ENABLE_TRUE; \
    UNUSED uint32_t REMAP_ENABLE_FALSE = NVC6B5_LAUNCH_DMA_REMAP_ENABLE_FALSE; \
    UNUSED uint32_t REMAP_ENABLE_TRUE = NVC6B5_LAUNCH_DMA_REMAP_ENABLE_TRUE; \
    UNUSED uint32_t FORCE_RMWDISABLE_FALSE = NVC6B5_LAUNCH_DMA_FORCE_RMWDISABLE_FALSE; \
    UNUSED uint32_t FORCE_RMWDISABLE_TRUE = NVC6B5_LAUNCH_DMA_FORCE_RMWDISABLE_TRUE; \
    UNUSED uint32_t SRC_TYPE_VIRTUAL = NVC6B5_LAUNCH_DMA_SRC_TYPE_VIRTUAL; \
    UNUSED uint32_t SRC_TYPE_PHYSICAL = NVC6B5_LAUNCH_DMA_SRC_TYPE_PHYSICAL; \
    UNUSED uint32_t DST_TYPE_VIRTUAL = NVC6B5_LAUNCH_DMA_DST_TYPE_VIRTUAL; \
    UNUSED uint32_t DST_TYPE_PHYSICAL = NVC6B5_LAUNCH_DMA_DST_TYPE_PHYSICAL; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IMIN = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMIN; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IMAX = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMAX; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IXOR = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IXOR; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IAND = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IAND; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IOR = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IOR; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IADD = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IADD; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_INC = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_INC; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_DEC = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_DEC; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_FADD = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FADD; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_SIGN_SIGNED = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN_SIGNED; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_SIGN_UNSIGNED = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN_UNSIGNED; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_ENABLE_FALSE = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE_FALSE; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_ENABLE_TRUE = NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE_TRUE; \
    UNUSED uint32_t VPRMODE_VPR_NONE = NVC6B5_LAUNCH_DMA_VPRMODE_VPR_NONE; \
    UNUSED uint32_t VPRMODE_VPR_VID2VID = NVC6B5_LAUNCH_DMA_VPRMODE_VPR_VID2VID; \
    UNUSED uint32_t DISABLE_PLC_FALSE = NVC6B5_LAUNCH_DMA_DISABLE_PLC_FALSE; \
    UNUSED uint32_t DISABLE_PLC_TRUE = NVC6B5_LAUNCH_DMA_DISABLE_PLC_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC6B5_LAUNCH_DMA(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_LAUNCH_DMA, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_OFFSET_IN_UPPER {
    uint32_t upper;
};

static inline void
__NVC6B5_OFFSET_IN_UPPER(uint32_t *val_out, struct nv_nvc6b5_OFFSET_IN_UPPER st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 17));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NVC6B5_OFFSET_IN_UPPER(val, args...) { \
    struct nv_nvc6b5_OFFSET_IN_UPPER __data = { .upper = (args) }; \
    __NVC6B5_OFFSET_IN_UPPER(&val, __data); \
}

#define VA_NVC6B5_OFFSET_IN_UPPER V_NVC6B5_OFFSET_IN_UPPER

#define P_NVC6B5_OFFSET_IN_UPPER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_OFFSET_IN_UPPER(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_OFFSET_IN_UPPER, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_OFFSET_IN_LOWER {
    uint32_t value;
};

static inline void
__NVC6B5_OFFSET_IN_LOWER(uint32_t *val_out, struct nv_nvc6b5_OFFSET_IN_LOWER st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC6B5_OFFSET_IN_LOWER(val, args...) { \
    struct nv_nvc6b5_OFFSET_IN_LOWER __data = { .value = (args) }; \
    __NVC6B5_OFFSET_IN_LOWER(&val, __data); \
}

#define VA_NVC6B5_OFFSET_IN_LOWER V_NVC6B5_OFFSET_IN_LOWER

#define P_NVC6B5_OFFSET_IN_LOWER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_OFFSET_IN_LOWER(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_OFFSET_IN_LOWER, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_OFFSET_OUT_UPPER {
    uint32_t upper;
};

static inline void
__NVC6B5_OFFSET_OUT_UPPER(uint32_t *val_out, struct nv_nvc6b5_OFFSET_OUT_UPPER st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 17));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NVC6B5_OFFSET_OUT_UPPER(val, args...) { \
    struct nv_nvc6b5_OFFSET_OUT_UPPER __data = { .upper = (args) }; \
    __NVC6B5_OFFSET_OUT_UPPER(&val, __data); \
}

#define VA_NVC6B5_OFFSET_OUT_UPPER V_NVC6B5_OFFSET_OUT_UPPER

#define P_NVC6B5_OFFSET_OUT_UPPER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_OFFSET_OUT_UPPER(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_OFFSET_OUT_UPPER, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_OFFSET_OUT_LOWER {
    uint32_t value;
};

static inline void
__NVC6B5_OFFSET_OUT_LOWER(uint32_t *val_out, struct nv_nvc6b5_OFFSET_OUT_LOWER st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC6B5_OFFSET_OUT_LOWER(val, args...) { \
    struct nv_nvc6b5_OFFSET_OUT_LOWER __data = { .value = (args) }; \
    __NVC6B5_OFFSET_OUT_LOWER(&val, __data); \
}

#define VA_NVC6B5_OFFSET_OUT_LOWER V_NVC6B5_OFFSET_OUT_LOWER

#define P_NVC6B5_OFFSET_OUT_LOWER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_OFFSET_OUT_LOWER(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_OFFSET_OUT_LOWER, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_PITCH_IN {
    uint32_t value;
};

static inline void
__NVC6B5_PITCH_IN(uint32_t *val_out, struct nv_nvc6b5_PITCH_IN st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC6B5_PITCH_IN(val, args...) { \
    struct nv_nvc6b5_PITCH_IN __data = { .value = (args) }; \
    __NVC6B5_PITCH_IN(&val, __data); \
}

#define VA_NVC6B5_PITCH_IN V_NVC6B5_PITCH_IN

#define P_NVC6B5_PITCH_IN(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_PITCH_IN(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_PITCH_IN, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_PITCH_OUT {
    uint32_t value;
};

static inline void
__NVC6B5_PITCH_OUT(uint32_t *val_out, struct nv_nvc6b5_PITCH_OUT st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC6B5_PITCH_OUT(val, args...) { \
    struct nv_nvc6b5_PITCH_OUT __data = { .value = (args) }; \
    __NVC6B5_PITCH_OUT(&val, __data); \
}

#define VA_NVC6B5_PITCH_OUT V_NVC6B5_PITCH_OUT

#define P_NVC6B5_PITCH_OUT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_PITCH_OUT(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_PITCH_OUT, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_LINE_LENGTH_IN {
    uint32_t value;
};

static inline void
__NVC6B5_LINE_LENGTH_IN(uint32_t *val_out, struct nv_nvc6b5_LINE_LENGTH_IN st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC6B5_LINE_LENGTH_IN(val, args...) { \
    struct nv_nvc6b5_LINE_LENGTH_IN __data = { .value = (args) }; \
    __NVC6B5_LINE_LENGTH_IN(&val, __data); \
}

#define VA_NVC6B5_LINE_LENGTH_IN V_NVC6B5_LINE_LENGTH_IN

#define P_NVC6B5_LINE_LENGTH_IN(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_LINE_LENGTH_IN(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_LINE_LENGTH_IN, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_LINE_COUNT {
    uint32_t value;
};

static inline void
__NVC6B5_LINE_COUNT(uint32_t *val_out, struct nv_nvc6b5_LINE_COUNT st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC6B5_LINE_COUNT(val, args...) { \
    struct nv_nvc6b5_LINE_COUNT __data = { .value = (args) }; \
    __NVC6B5_LINE_COUNT(&val, __data); \
}

#define VA_NVC6B5_LINE_COUNT V_NVC6B5_LINE_COUNT

#define P_NVC6B5_LINE_COUNT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_LINE_COUNT(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_LINE_COUNT, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_REMAP_CONST_A {
    uint32_t v;
};

static inline void
__NVC6B5_SET_REMAP_CONST_A(uint32_t *val_out, struct nv_nvc6b5_SET_REMAP_CONST_A st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC6B5_SET_REMAP_CONST_A(val, args...) { \
    struct nv_nvc6b5_SET_REMAP_CONST_A __data = { .v = (args) }; \
    __NVC6B5_SET_REMAP_CONST_A(&val, __data); \
}

#define VA_NVC6B5_SET_REMAP_CONST_A V_NVC6B5_SET_REMAP_CONST_A

#define P_NVC6B5_SET_REMAP_CONST_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_REMAP_CONST_A(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_REMAP_CONST_A, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_REMAP_CONST_B {
    uint32_t v;
};

static inline void
__NVC6B5_SET_REMAP_CONST_B(uint32_t *val_out, struct nv_nvc6b5_SET_REMAP_CONST_B st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC6B5_SET_REMAP_CONST_B(val, args...) { \
    struct nv_nvc6b5_SET_REMAP_CONST_B __data = { .v = (args) }; \
    __NVC6B5_SET_REMAP_CONST_B(&val, __data); \
}

#define VA_NVC6B5_SET_REMAP_CONST_B V_NVC6B5_SET_REMAP_CONST_B

#define P_NVC6B5_SET_REMAP_CONST_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_REMAP_CONST_B(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_REMAP_CONST_B, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_REMAP_COMPONENTS {
    uint32_t dst_x;
    uint32_t dst_y;
    uint32_t dst_z;
    uint32_t dst_w;
    uint32_t component_size;
    uint32_t num_src_components;
    uint32_t num_dst_components;
};

static inline void
__NVC6B5_SET_REMAP_COMPONENTS(uint32_t *val_out, struct nv_nvc6b5_SET_REMAP_COMPONENTS st)
{
    uint32_t val = 0;
    
    assert(st.dst_x < (1ULL << 3));
    val |= st.dst_x << 0;
    
    assert(st.dst_y < (1ULL << 3));
    val |= st.dst_y << 4;
    
    assert(st.dst_z < (1ULL << 3));
    val |= st.dst_z << 8;
    
    assert(st.dst_w < (1ULL << 3));
    val |= st.dst_w << 12;
    
    assert(st.component_size < (1ULL << 2));
    val |= st.component_size << 16;
    
    assert(st.num_src_components < (1ULL << 2));
    val |= st.num_src_components << 20;
    
    assert(st.num_dst_components < (1ULL << 2));
    val |= st.num_dst_components << 24;
    *val_out = val;
}

#define V_NVC6B5_SET_REMAP_COMPONENTS(val, args...) { \
    UNUSED uint32_t DST_X_SRC_X = NVC6B5_SET_REMAP_COMPONENTS_DST_X_SRC_X; \
    UNUSED uint32_t DST_X_SRC_Y = NVC6B5_SET_REMAP_COMPONENTS_DST_X_SRC_Y; \
    UNUSED uint32_t DST_X_SRC_Z = NVC6B5_SET_REMAP_COMPONENTS_DST_X_SRC_Z; \
    UNUSED uint32_t DST_X_SRC_W = NVC6B5_SET_REMAP_COMPONENTS_DST_X_SRC_W; \
    UNUSED uint32_t DST_X_CONST_A = NVC6B5_SET_REMAP_COMPONENTS_DST_X_CONST_A; \
    UNUSED uint32_t DST_X_CONST_B = NVC6B5_SET_REMAP_COMPONENTS_DST_X_CONST_B; \
    UNUSED uint32_t DST_X_NO_WRITE = NVC6B5_SET_REMAP_COMPONENTS_DST_X_NO_WRITE; \
    UNUSED uint32_t DST_Y_SRC_X = NVC6B5_SET_REMAP_COMPONENTS_DST_Y_SRC_X; \
    UNUSED uint32_t DST_Y_SRC_Y = NVC6B5_SET_REMAP_COMPONENTS_DST_Y_SRC_Y; \
    UNUSED uint32_t DST_Y_SRC_Z = NVC6B5_SET_REMAP_COMPONENTS_DST_Y_SRC_Z; \
    UNUSED uint32_t DST_Y_SRC_W = NVC6B5_SET_REMAP_COMPONENTS_DST_Y_SRC_W; \
    UNUSED uint32_t DST_Y_CONST_A = NVC6B5_SET_REMAP_COMPONENTS_DST_Y_CONST_A; \
    UNUSED uint32_t DST_Y_CONST_B = NVC6B5_SET_REMAP_COMPONENTS_DST_Y_CONST_B; \
    UNUSED uint32_t DST_Y_NO_WRITE = NVC6B5_SET_REMAP_COMPONENTS_DST_Y_NO_WRITE; \
    UNUSED uint32_t DST_Z_SRC_X = NVC6B5_SET_REMAP_COMPONENTS_DST_Z_SRC_X; \
    UNUSED uint32_t DST_Z_SRC_Y = NVC6B5_SET_REMAP_COMPONENTS_DST_Z_SRC_Y; \
    UNUSED uint32_t DST_Z_SRC_Z = NVC6B5_SET_REMAP_COMPONENTS_DST_Z_SRC_Z; \
    UNUSED uint32_t DST_Z_SRC_W = NVC6B5_SET_REMAP_COMPONENTS_DST_Z_SRC_W; \
    UNUSED uint32_t DST_Z_CONST_A = NVC6B5_SET_REMAP_COMPONENTS_DST_Z_CONST_A; \
    UNUSED uint32_t DST_Z_CONST_B = NVC6B5_SET_REMAP_COMPONENTS_DST_Z_CONST_B; \
    UNUSED uint32_t DST_Z_NO_WRITE = NVC6B5_SET_REMAP_COMPONENTS_DST_Z_NO_WRITE; \
    UNUSED uint32_t DST_W_SRC_X = NVC6B5_SET_REMAP_COMPONENTS_DST_W_SRC_X; \
    UNUSED uint32_t DST_W_SRC_Y = NVC6B5_SET_REMAP_COMPONENTS_DST_W_SRC_Y; \
    UNUSED uint32_t DST_W_SRC_Z = NVC6B5_SET_REMAP_COMPONENTS_DST_W_SRC_Z; \
    UNUSED uint32_t DST_W_SRC_W = NVC6B5_SET_REMAP_COMPONENTS_DST_W_SRC_W; \
    UNUSED uint32_t DST_W_CONST_A = NVC6B5_SET_REMAP_COMPONENTS_DST_W_CONST_A; \
    UNUSED uint32_t DST_W_CONST_B = NVC6B5_SET_REMAP_COMPONENTS_DST_W_CONST_B; \
    UNUSED uint32_t DST_W_NO_WRITE = NVC6B5_SET_REMAP_COMPONENTS_DST_W_NO_WRITE; \
    UNUSED uint32_t COMPONENT_SIZE_ONE = NVC6B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_ONE; \
    UNUSED uint32_t COMPONENT_SIZE_TWO = NVC6B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_TWO; \
    UNUSED uint32_t COMPONENT_SIZE_THREE = NVC6B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_THREE; \
    UNUSED uint32_t COMPONENT_SIZE_FOUR = NVC6B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_FOUR; \
    UNUSED uint32_t NUM_SRC_COMPONENTS_ONE = NVC6B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_ONE; \
    UNUSED uint32_t NUM_SRC_COMPONENTS_TWO = NVC6B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_TWO; \
    UNUSED uint32_t NUM_SRC_COMPONENTS_THREE = NVC6B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_THREE; \
    UNUSED uint32_t NUM_SRC_COMPONENTS_FOUR = NVC6B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_FOUR; \
    UNUSED uint32_t NUM_DST_COMPONENTS_ONE = NVC6B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_ONE; \
    UNUSED uint32_t NUM_DST_COMPONENTS_TWO = NVC6B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_TWO; \
    UNUSED uint32_t NUM_DST_COMPONENTS_THREE = NVC6B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_THREE; \
    UNUSED uint32_t NUM_DST_COMPONENTS_FOUR = NVC6B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_FOUR; \
    struct nv_nvc6b5_SET_REMAP_COMPONENTS __data = args; \
    __NVC6B5_SET_REMAP_COMPONENTS(&val, __data); \
}

#define VA_NVC6B5_SET_REMAP_COMPONENTS V_NVC6B5_SET_REMAP_COMPONENTS

#define P_NVC6B5_SET_REMAP_COMPONENTS(push, args...) do { \
    UNUSED uint32_t DST_X_SRC_X = NVC6B5_SET_REMAP_COMPONENTS_DST_X_SRC_X; \
    UNUSED uint32_t DST_X_SRC_Y = NVC6B5_SET_REMAP_COMPONENTS_DST_X_SRC_Y; \
    UNUSED uint32_t DST_X_SRC_Z = NVC6B5_SET_REMAP_COMPONENTS_DST_X_SRC_Z; \
    UNUSED uint32_t DST_X_SRC_W = NVC6B5_SET_REMAP_COMPONENTS_DST_X_SRC_W; \
    UNUSED uint32_t DST_X_CONST_A = NVC6B5_SET_REMAP_COMPONENTS_DST_X_CONST_A; \
    UNUSED uint32_t DST_X_CONST_B = NVC6B5_SET_REMAP_COMPONENTS_DST_X_CONST_B; \
    UNUSED uint32_t DST_X_NO_WRITE = NVC6B5_SET_REMAP_COMPONENTS_DST_X_NO_WRITE; \
    UNUSED uint32_t DST_Y_SRC_X = NVC6B5_SET_REMAP_COMPONENTS_DST_Y_SRC_X; \
    UNUSED uint32_t DST_Y_SRC_Y = NVC6B5_SET_REMAP_COMPONENTS_DST_Y_SRC_Y; \
    UNUSED uint32_t DST_Y_SRC_Z = NVC6B5_SET_REMAP_COMPONENTS_DST_Y_SRC_Z; \
    UNUSED uint32_t DST_Y_SRC_W = NVC6B5_SET_REMAP_COMPONENTS_DST_Y_SRC_W; \
    UNUSED uint32_t DST_Y_CONST_A = NVC6B5_SET_REMAP_COMPONENTS_DST_Y_CONST_A; \
    UNUSED uint32_t DST_Y_CONST_B = NVC6B5_SET_REMAP_COMPONENTS_DST_Y_CONST_B; \
    UNUSED uint32_t DST_Y_NO_WRITE = NVC6B5_SET_REMAP_COMPONENTS_DST_Y_NO_WRITE; \
    UNUSED uint32_t DST_Z_SRC_X = NVC6B5_SET_REMAP_COMPONENTS_DST_Z_SRC_X; \
    UNUSED uint32_t DST_Z_SRC_Y = NVC6B5_SET_REMAP_COMPONENTS_DST_Z_SRC_Y; \
    UNUSED uint32_t DST_Z_SRC_Z = NVC6B5_SET_REMAP_COMPONENTS_DST_Z_SRC_Z; \
    UNUSED uint32_t DST_Z_SRC_W = NVC6B5_SET_REMAP_COMPONENTS_DST_Z_SRC_W; \
    UNUSED uint32_t DST_Z_CONST_A = NVC6B5_SET_REMAP_COMPONENTS_DST_Z_CONST_A; \
    UNUSED uint32_t DST_Z_CONST_B = NVC6B5_SET_REMAP_COMPONENTS_DST_Z_CONST_B; \
    UNUSED uint32_t DST_Z_NO_WRITE = NVC6B5_SET_REMAP_COMPONENTS_DST_Z_NO_WRITE; \
    UNUSED uint32_t DST_W_SRC_X = NVC6B5_SET_REMAP_COMPONENTS_DST_W_SRC_X; \
    UNUSED uint32_t DST_W_SRC_Y = NVC6B5_SET_REMAP_COMPONENTS_DST_W_SRC_Y; \
    UNUSED uint32_t DST_W_SRC_Z = NVC6B5_SET_REMAP_COMPONENTS_DST_W_SRC_Z; \
    UNUSED uint32_t DST_W_SRC_W = NVC6B5_SET_REMAP_COMPONENTS_DST_W_SRC_W; \
    UNUSED uint32_t DST_W_CONST_A = NVC6B5_SET_REMAP_COMPONENTS_DST_W_CONST_A; \
    UNUSED uint32_t DST_W_CONST_B = NVC6B5_SET_REMAP_COMPONENTS_DST_W_CONST_B; \
    UNUSED uint32_t DST_W_NO_WRITE = NVC6B5_SET_REMAP_COMPONENTS_DST_W_NO_WRITE; \
    UNUSED uint32_t COMPONENT_SIZE_ONE = NVC6B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_ONE; \
    UNUSED uint32_t COMPONENT_SIZE_TWO = NVC6B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_TWO; \
    UNUSED uint32_t COMPONENT_SIZE_THREE = NVC6B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_THREE; \
    UNUSED uint32_t COMPONENT_SIZE_FOUR = NVC6B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_FOUR; \
    UNUSED uint32_t NUM_SRC_COMPONENTS_ONE = NVC6B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_ONE; \
    UNUSED uint32_t NUM_SRC_COMPONENTS_TWO = NVC6B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_TWO; \
    UNUSED uint32_t NUM_SRC_COMPONENTS_THREE = NVC6B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_THREE; \
    UNUSED uint32_t NUM_SRC_COMPONENTS_FOUR = NVC6B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_FOUR; \
    UNUSED uint32_t NUM_DST_COMPONENTS_ONE = NVC6B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_ONE; \
    UNUSED uint32_t NUM_DST_COMPONENTS_TWO = NVC6B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_TWO; \
    UNUSED uint32_t NUM_DST_COMPONENTS_THREE = NVC6B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_THREE; \
    UNUSED uint32_t NUM_DST_COMPONENTS_FOUR = NVC6B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_FOUR; \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_REMAP_COMPONENTS(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_REMAP_COMPONENTS, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_DST_BLOCK_SIZE {
    uint32_t width;
    uint32_t height;
    uint32_t depth;
    uint32_t gob_height;
};

static inline void
__NVC6B5_SET_DST_BLOCK_SIZE(uint32_t *val_out, struct nv_nvc6b5_SET_DST_BLOCK_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.width < (1ULL << 4));
    val |= st.width << 0;
    
    assert(st.height < (1ULL << 4));
    val |= st.height << 4;
    
    assert(st.depth < (1ULL << 4));
    val |= st.depth << 8;
    
    assert(st.gob_height < (1ULL << 4));
    val |= st.gob_height << 12;
    *val_out = val;
}

#define V_NVC6B5_SET_DST_BLOCK_SIZE(val, args...) { \
    UNUSED uint32_t WIDTH_ONE_GOB = NVC6B5_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    UNUSED uint32_t GOB_HEIGHT_GOB_HEIGHT_FERMI_8 = NVC6B5_SET_DST_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_FERMI_8; \
    struct nv_nvc6b5_SET_DST_BLOCK_SIZE __data = args; \
    __NVC6B5_SET_DST_BLOCK_SIZE(&val, __data); \
}

#define VA_NVC6B5_SET_DST_BLOCK_SIZE V_NVC6B5_SET_DST_BLOCK_SIZE

#define P_NVC6B5_SET_DST_BLOCK_SIZE(push, args...) do { \
    UNUSED uint32_t WIDTH_ONE_GOB = NVC6B5_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    UNUSED uint32_t GOB_HEIGHT_GOB_HEIGHT_FERMI_8 = NVC6B5_SET_DST_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_FERMI_8; \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_DST_BLOCK_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_DST_BLOCK_SIZE, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_DST_WIDTH {
    uint32_t v;
};

static inline void
__NVC6B5_SET_DST_WIDTH(uint32_t *val_out, struct nv_nvc6b5_SET_DST_WIDTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC6B5_SET_DST_WIDTH(val, args...) { \
    struct nv_nvc6b5_SET_DST_WIDTH __data = { .v = (args) }; \
    __NVC6B5_SET_DST_WIDTH(&val, __data); \
}

#define VA_NVC6B5_SET_DST_WIDTH V_NVC6B5_SET_DST_WIDTH

#define P_NVC6B5_SET_DST_WIDTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_DST_WIDTH(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_DST_WIDTH, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_DST_HEIGHT {
    uint32_t v;
};

static inline void
__NVC6B5_SET_DST_HEIGHT(uint32_t *val_out, struct nv_nvc6b5_SET_DST_HEIGHT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC6B5_SET_DST_HEIGHT(val, args...) { \
    struct nv_nvc6b5_SET_DST_HEIGHT __data = { .v = (args) }; \
    __NVC6B5_SET_DST_HEIGHT(&val, __data); \
}

#define VA_NVC6B5_SET_DST_HEIGHT V_NVC6B5_SET_DST_HEIGHT

#define P_NVC6B5_SET_DST_HEIGHT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_DST_HEIGHT(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_DST_HEIGHT, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_DST_DEPTH {
    uint32_t v;
};

static inline void
__NVC6B5_SET_DST_DEPTH(uint32_t *val_out, struct nv_nvc6b5_SET_DST_DEPTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC6B5_SET_DST_DEPTH(val, args...) { \
    struct nv_nvc6b5_SET_DST_DEPTH __data = { .v = (args) }; \
    __NVC6B5_SET_DST_DEPTH(&val, __data); \
}

#define VA_NVC6B5_SET_DST_DEPTH V_NVC6B5_SET_DST_DEPTH

#define P_NVC6B5_SET_DST_DEPTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_DST_DEPTH(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_DST_DEPTH, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_DST_LAYER {
    uint32_t v;
};

static inline void
__NVC6B5_SET_DST_LAYER(uint32_t *val_out, struct nv_nvc6b5_SET_DST_LAYER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC6B5_SET_DST_LAYER(val, args...) { \
    struct nv_nvc6b5_SET_DST_LAYER __data = { .v = (args) }; \
    __NVC6B5_SET_DST_LAYER(&val, __data); \
}

#define VA_NVC6B5_SET_DST_LAYER V_NVC6B5_SET_DST_LAYER

#define P_NVC6B5_SET_DST_LAYER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_DST_LAYER(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_DST_LAYER, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_DST_ORIGIN {
    uint32_t x;
    uint32_t y;
};

static inline void
__NVC6B5_SET_DST_ORIGIN(uint32_t *val_out, struct nv_nvc6b5_SET_DST_ORIGIN st)
{
    uint32_t val = 0;
    
    assert(st.x < (1ULL << 16));
    val |= st.x << 0;
    
    assert(st.y < (1ULL << 16));
    val |= st.y << 16;
    *val_out = val;
}

#define V_NVC6B5_SET_DST_ORIGIN(val, args...) { \
    struct nv_nvc6b5_SET_DST_ORIGIN __data = args; \
    __NVC6B5_SET_DST_ORIGIN(&val, __data); \
}

#define VA_NVC6B5_SET_DST_ORIGIN V_NVC6B5_SET_DST_ORIGIN

#define P_NVC6B5_SET_DST_ORIGIN(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_DST_ORIGIN(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_DST_ORIGIN, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_SRC_BLOCK_SIZE {
    uint32_t width;
    uint32_t height;
    uint32_t depth;
    uint32_t gob_height;
};

static inline void
__NVC6B5_SET_SRC_BLOCK_SIZE(uint32_t *val_out, struct nv_nvc6b5_SET_SRC_BLOCK_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.width < (1ULL << 4));
    val |= st.width << 0;
    
    assert(st.height < (1ULL << 4));
    val |= st.height << 4;
    
    assert(st.depth < (1ULL << 4));
    val |= st.depth << 8;
    
    assert(st.gob_height < (1ULL << 4));
    val |= st.gob_height << 12;
    *val_out = val;
}

#define V_NVC6B5_SET_SRC_BLOCK_SIZE(val, args...) { \
    UNUSED uint32_t WIDTH_ONE_GOB = NVC6B5_SET_SRC_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    UNUSED uint32_t GOB_HEIGHT_GOB_HEIGHT_FERMI_8 = NVC6B5_SET_SRC_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_FERMI_8; \
    struct nv_nvc6b5_SET_SRC_BLOCK_SIZE __data = args; \
    __NVC6B5_SET_SRC_BLOCK_SIZE(&val, __data); \
}

#define VA_NVC6B5_SET_SRC_BLOCK_SIZE V_NVC6B5_SET_SRC_BLOCK_SIZE

#define P_NVC6B5_SET_SRC_BLOCK_SIZE(push, args...) do { \
    UNUSED uint32_t WIDTH_ONE_GOB = NVC6B5_SET_SRC_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    UNUSED uint32_t GOB_HEIGHT_GOB_HEIGHT_FERMI_8 = NVC6B5_SET_SRC_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_FERMI_8; \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_SRC_BLOCK_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_SRC_BLOCK_SIZE, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_SRC_WIDTH {
    uint32_t v;
};

static inline void
__NVC6B5_SET_SRC_WIDTH(uint32_t *val_out, struct nv_nvc6b5_SET_SRC_WIDTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC6B5_SET_SRC_WIDTH(val, args...) { \
    struct nv_nvc6b5_SET_SRC_WIDTH __data = { .v = (args) }; \
    __NVC6B5_SET_SRC_WIDTH(&val, __data); \
}

#define VA_NVC6B5_SET_SRC_WIDTH V_NVC6B5_SET_SRC_WIDTH

#define P_NVC6B5_SET_SRC_WIDTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_SRC_WIDTH(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_SRC_WIDTH, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_SRC_HEIGHT {
    uint32_t v;
};

static inline void
__NVC6B5_SET_SRC_HEIGHT(uint32_t *val_out, struct nv_nvc6b5_SET_SRC_HEIGHT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC6B5_SET_SRC_HEIGHT(val, args...) { \
    struct nv_nvc6b5_SET_SRC_HEIGHT __data = { .v = (args) }; \
    __NVC6B5_SET_SRC_HEIGHT(&val, __data); \
}

#define VA_NVC6B5_SET_SRC_HEIGHT V_NVC6B5_SET_SRC_HEIGHT

#define P_NVC6B5_SET_SRC_HEIGHT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_SRC_HEIGHT(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_SRC_HEIGHT, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_SRC_DEPTH {
    uint32_t v;
};

static inline void
__NVC6B5_SET_SRC_DEPTH(uint32_t *val_out, struct nv_nvc6b5_SET_SRC_DEPTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC6B5_SET_SRC_DEPTH(val, args...) { \
    struct nv_nvc6b5_SET_SRC_DEPTH __data = { .v = (args) }; \
    __NVC6B5_SET_SRC_DEPTH(&val, __data); \
}

#define VA_NVC6B5_SET_SRC_DEPTH V_NVC6B5_SET_SRC_DEPTH

#define P_NVC6B5_SET_SRC_DEPTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_SRC_DEPTH(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_SRC_DEPTH, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_SRC_LAYER {
    uint32_t v;
};

static inline void
__NVC6B5_SET_SRC_LAYER(uint32_t *val_out, struct nv_nvc6b5_SET_SRC_LAYER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC6B5_SET_SRC_LAYER(val, args...) { \
    struct nv_nvc6b5_SET_SRC_LAYER __data = { .v = (args) }; \
    __NVC6B5_SET_SRC_LAYER(&val, __data); \
}

#define VA_NVC6B5_SET_SRC_LAYER V_NVC6B5_SET_SRC_LAYER

#define P_NVC6B5_SET_SRC_LAYER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_SRC_LAYER(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_SRC_LAYER, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SET_SRC_ORIGIN {
    uint32_t x;
    uint32_t y;
};

static inline void
__NVC6B5_SET_SRC_ORIGIN(uint32_t *val_out, struct nv_nvc6b5_SET_SRC_ORIGIN st)
{
    uint32_t val = 0;
    
    assert(st.x < (1ULL << 16));
    val |= st.x << 0;
    
    assert(st.y < (1ULL << 16));
    val |= st.y << 16;
    *val_out = val;
}

#define V_NVC6B5_SET_SRC_ORIGIN(val, args...) { \
    struct nv_nvc6b5_SET_SRC_ORIGIN __data = args; \
    __NVC6B5_SET_SRC_ORIGIN(&val, __data); \
}

#define VA_NVC6B5_SET_SRC_ORIGIN V_NVC6B5_SET_SRC_ORIGIN

#define P_NVC6B5_SET_SRC_ORIGIN(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SET_SRC_ORIGIN(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SET_SRC_ORIGIN, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SRC_ORIGIN_X {
    uint32_t value;
};

static inline void
__NVC6B5_SRC_ORIGIN_X(uint32_t *val_out, struct nv_nvc6b5_SRC_ORIGIN_X st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC6B5_SRC_ORIGIN_X(val, args...) { \
    struct nv_nvc6b5_SRC_ORIGIN_X __data = { .value = (args) }; \
    __NVC6B5_SRC_ORIGIN_X(&val, __data); \
}

#define VA_NVC6B5_SRC_ORIGIN_X V_NVC6B5_SRC_ORIGIN_X

#define P_NVC6B5_SRC_ORIGIN_X(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SRC_ORIGIN_X(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SRC_ORIGIN_X, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_SRC_ORIGIN_Y {
    uint32_t value;
};

static inline void
__NVC6B5_SRC_ORIGIN_Y(uint32_t *val_out, struct nv_nvc6b5_SRC_ORIGIN_Y st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC6B5_SRC_ORIGIN_Y(val, args...) { \
    struct nv_nvc6b5_SRC_ORIGIN_Y __data = { .value = (args) }; \
    __NVC6B5_SRC_ORIGIN_Y(&val, __data); \
}

#define VA_NVC6B5_SRC_ORIGIN_Y V_NVC6B5_SRC_ORIGIN_Y

#define P_NVC6B5_SRC_ORIGIN_Y(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_SRC_ORIGIN_Y(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_SRC_ORIGIN_Y, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_DST_ORIGIN_X {
    uint32_t value;
};

static inline void
__NVC6B5_DST_ORIGIN_X(uint32_t *val_out, struct nv_nvc6b5_DST_ORIGIN_X st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC6B5_DST_ORIGIN_X(val, args...) { \
    struct nv_nvc6b5_DST_ORIGIN_X __data = { .value = (args) }; \
    __NVC6B5_DST_ORIGIN_X(&val, __data); \
}

#define VA_NVC6B5_DST_ORIGIN_X V_NVC6B5_DST_ORIGIN_X

#define P_NVC6B5_DST_ORIGIN_X(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_DST_ORIGIN_X(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_DST_ORIGIN_X, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_DST_ORIGIN_Y {
    uint32_t value;
};

static inline void
__NVC6B5_DST_ORIGIN_Y(uint32_t *val_out, struct nv_nvc6b5_DST_ORIGIN_Y st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC6B5_DST_ORIGIN_Y(val, args...) { \
    struct nv_nvc6b5_DST_ORIGIN_Y __data = { .value = (args) }; \
    __NVC6B5_DST_ORIGIN_Y(&val, __data); \
}

#define VA_NVC6B5_DST_ORIGIN_Y V_NVC6B5_DST_ORIGIN_Y

#define P_NVC6B5_DST_ORIGIN_Y(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_DST_ORIGIN_Y(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_DST_ORIGIN_Y, nvk_p_ret); \
} while(0)

struct nv_nvc6b5_PM_TRIGGER_END {
    uint32_t v;
};

static inline void
__NVC6B5_PM_TRIGGER_END(uint32_t *val_out, struct nv_nvc6b5_PM_TRIGGER_END st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC6B5_PM_TRIGGER_END(val, args...) { \
    struct nv_nvc6b5_PM_TRIGGER_END __data = { .v = (args) }; \
    __NVC6B5_PM_TRIGGER_END(&val, __data); \
}

#define VA_NVC6B5_PM_TRIGGER_END V_NVC6B5_PM_TRIGGER_END

#define P_NVC6B5_PM_TRIGGER_END(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC6B5_PM_TRIGGER_END(nvk_p_ret, args); \
    nv_push_val(push, NVC6B5_PM_TRIGGER_END, nvk_p_ret); \
} while(0)


const char *P_PARSE_NVC6B5_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVC6B5_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                              const char *prefix) ATTRIBUTE_COLD;
