#ifndef INCLUDED_COM_SUN_STAR_SHEET_LOCALIZEDNAME_HPP
#define INCLUDED_COM_SUN_STAR_SHEET_LOCALIZEDNAME_HPP

#include "sal/config.h"

#include "com/sun/star/sheet/LocalizedName.hdl"

#include "com/sun/star/lang/Locale.hpp"
#include "com/sun/star/uno/Type.hxx"
#include "cppu/unotype.hxx"
#include "rtl/ustring.hxx"
#include "sal/types.h"
#include "typelib/typeclass.h"
#include "typelib/typedescription.h"

namespace com { namespace sun { namespace star { namespace sheet {

inline LocalizedName::LocalizedName()
    : Locale()
    , Name()
{
}

inline LocalizedName::LocalizedName(const ::css::lang::Locale& Locale_, const ::rtl::OUString& Name_)
    : Locale(Locale_)
    , Name(Name_)
{
}


inline bool operator==(const LocalizedName& the_lhs, const LocalizedName& the_rhs)
{
    return the_lhs.Locale == the_rhs.Locale
        && the_lhs.Name == the_rhs.Name;
}

inline bool operator!=(const LocalizedName& the_lhs, const LocalizedName& the_rhs)
{
return !operator==(the_lhs, the_rhs);
}
} } } }

namespace com { namespace sun { namespace star { namespace sheet {

inline ::css::uno::Type const & cppu_detail_getUnoType(SAL_UNUSED_PARAMETER ::css::sheet::LocalizedName const *) {
    //TODO: On certain platforms with weak memory models, the following code can result in some threads observing that the_type points to garbage
    static ::typelib_TypeDescriptionReference * the_type = 0;
    if (the_type == 0) {
        ::typelib_static_type_init(&the_type, typelib_TypeClass_STRUCT, "com.sun.star.sheet.LocalizedName");
    }
    return *reinterpret_cast< ::css::uno::Type * >(&the_type);
}

} } } }

SAL_DEPRECATED("use cppu::UnoType") inline ::css::uno::Type const & SAL_CALL getCppuType(SAL_UNUSED_PARAMETER ::css::sheet::LocalizedName const *) {
    return ::cppu::UnoType< ::css::sheet::LocalizedName >::get();
}

#endif // INCLUDED_COM_SUN_STAR_SHEET_LOCALIZEDNAME_HPP
