
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kmultitabbar_wrapper.h"

// Wrappers providing overrides
#include "kurllabel_wrapper.h"
#include "kxyselector_wrapper.h"

// Argument includes
#include <QString>
#include <kmultitabbar.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qfont.h>
#include <qicon.h>
#include <qmenu.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KMultiTabBar_Type = nullptr;
static PyTypeObject *Sbk_KMultiTabBar_TypeF(void)
{
    return _Sbk_KMultiTabBar_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KMultiTabBarWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KMultiTabBarWrapper::KMultiTabBarWrapper(::KMultiTabBar::KMultiTabBarPosition pos, ::QWidget * parent) : KMultiTabBar(pos, parent)
{
}

KMultiTabBarWrapper::KMultiTabBarWrapper(::QWidget * parent) : KMultiTabBar(parent)
{
}

void KMultiTabBarWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KMultiTabBar", funcName, gil, pyOverride, signal);
}

void KMultiTabBarWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

int KMultiTabBarWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KMultiTabBar", funcName, gil, pyOverride);
}

void KMultiTabBarWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KMultiTabBar", funcName, gil, pyOverride, signal);
}

void KMultiTabBarWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

bool KMultiTabBarWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KMultiTabBar", funcName, gil, pyOverride, event);
}

bool KMultiTabBarWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KMultiTabBar", funcName, gil, pyOverride, watched, event);
}

void KMultiTabBarWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

bool KMultiTabBarWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KMultiTabBar", funcName, gil, pyOverride, next);
}

void KMultiTabBarWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::fontChange(const ::QFont & arg__1)
{
    static const char *funcName = "fontChange";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMultiTabBar::fontChange(arg__1);
    }
    KUrlLabelWrapper::sbk_o_setFont("KMultiTabBar", funcName, gil, pyOverride, arg__1);
}

bool KMultiTabBarWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KMultiTabBar", funcName, gil, pyOverride);
}

int KMultiTabBarWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KMultiTabBar", funcName, gil, pyOverride, arg__1);
}

void KMultiTabBarWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KMultiTabBar", funcName, gil, pyOverride, painter);
}

void KMultiTabBarWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

::QVariant KMultiTabBarWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KMultiTabBar", funcName, gil, pyOverride, arg__1);
}

void KMultiTabBarWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

int KMultiTabBarWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KMultiTabBar", funcName, gil, pyOverride, arg__1);
}

::QSize KMultiTabBarWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KMultiTabBar", funcName, gil, pyOverride);
}

void KMultiTabBarWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

bool KMultiTabBarWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KMultiTabBar", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KMultiTabBarWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KMultiTabBar", funcName, gil, pyOverride);
}

void KMultiTabBarWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMultiTabBar::paintEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KMultiTabBar", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * KMultiTabBarWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KMultiTabBar", funcName, gil, pyOverride, offset);
}

void KMultiTabBarWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KMultiTabBar", funcName, gil, pyOverride, visible);
}

::QPainter * KMultiTabBarWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KMultiTabBar", funcName, gil, pyOverride);
}

void KMultiTabBarWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

::QSize KMultiTabBarWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KMultiTabBar", funcName, gil, pyOverride);
}

void KMultiTabBarWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

void KMultiTabBarWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBar_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KMultiTabBar", funcName, gil, pyOverride, event);
}

const QMetaObject *KMultiTabBarWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KMultiTabBar::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KMultiTabBarWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KMultiTabBar::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KMultiTabBarWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KMultiTabBarWrapper *>(this));
    }
    return KMultiTabBar::qt_metacast(_clname);
}

KMultiTabBarWrapper::~KMultiTabBarWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KMultiTabBar_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KMultiTabBar_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KMultiTabBar >()))
        return -1;

    KMultiTabBarWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KMultiTabBar", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KMultiTabBar::KMultiTabBar(KMultiTabBar::KMultiTabBarPosition,QWidget*=)
    // 1: KMultiTabBar::KMultiTabBar(QWidget*=)
    if (numArgs == 0) {
        overloadId = 1; // KMultiTabBar(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 1; // KMultiTabBar(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_KMultiTabBarPosition_IDX])))->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KMultiTabBar(KMultiTabBar::KMultiTabBarPosition,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            overloadId = 0; // KMultiTabBar(KMultiTabBar::KMultiTabBarPosition,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KMultiTabBar(KMultiTabBar::KMultiTabBarPosition pos, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);
                }
            }
            ::KMultiTabBar::KMultiTabBarPosition cppArg0{KMultiTabBar::Left};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QWidget *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KMultiTabBar(KMultiTabBar::KMultiTabBarPosition,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KMultiTabBarWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KMultiTabBarWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
        case 1: // KMultiTabBar(QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KMultiTabBar(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KMultiTabBarWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KMultiTabBarWrapper(cppArg0);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KMultiTabBar >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KMultiTabBarFunc_appendButton(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "appendButton", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:appendButton", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KMultiTabBar::appendButton(QIcon,int=,QMenu*=,const QString&=)->int
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // appendButton(QIcon,int,QMenu*,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // appendButton(QIcon,int,QMenu*,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // appendButton(QIcon,int,QMenu*,QString)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                    overloadId = 0; // appendButton(QIcon,int,QMenu*,QString)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "appendButton", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"id", 1}, {"popup", 2}, {"not_used_yet", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "appendButton", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1 = -1;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QMenu *cppArg2 = nullptr;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // appendButton(QIcon,int,QMenu*,QString)
            int cppResult = cppSelf->appendButton(*cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMultiTabBarFunc_appendTab(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "appendTab", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:appendTab", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KMultiTabBar::appendTab(QIcon,int=,const QString&=)->int
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // appendTab(QIcon,int,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // appendTab(QIcon,int,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                overloadId = 0; // appendTab(QIcon,int,QString)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "appendTab", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"id", 1}, {"text", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "appendTab", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1 = -1;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // appendTab(QIcon,int,QString)
            int cppResult = cppSelf->appendTab(*cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMultiTabBarFunc_button(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMultiTabBar::button(int)const->KMultiTabBarButton*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // button(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "button", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // button(int)const
            KMultiTabBarButton * cppResult = const_cast<const ::KMultiTabBar *>(cppSelf)->button(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMultiTabBarFunc_fontChange(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMultiTabBar::fontChange(QFont)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFont_IDX]), (pyArg)))) {
        overloadId = 0; // fontChange(QFont)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "fontChange", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // fontChange(QFont)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KMultiTabBar::fontChange(*cppArg0)
                : cppSelf->fontChange(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMultiTabBarFunc_isTabRaised(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMultiTabBar::isTabRaised(int)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // isTabRaised(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isTabRaised", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isTabRaised(int)const
            bool cppResult = const_cast<const ::KMultiTabBar *>(cppSelf)->isTabRaised(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMultiTabBarFunc_paintEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::paintEvent(QPaintEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintEvent_IDX]), (pyArg)))) {
        overloadId = 0; // paintEvent(QPaintEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "paintEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paintEvent(QPaintEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KMultiTabBar::paintEvent(cppArg0)
                : cppSelf->paintEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMultiTabBarFunc_position(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // position()const
        KMultiTabBar::KMultiTabBarPosition cppResult = const_cast<const ::KMultiTabBar *>(cppSelf)->position();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_KMultiTabBarPosition_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMultiTabBarFunc_removeButton(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMultiTabBar::removeButton(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // removeButton(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeButton", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeButton(int)
            cppSelf->removeButton(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMultiTabBarFunc_removeTab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMultiTabBar::removeTab(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // removeTab(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeTab", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeTab(int)
            cppSelf->removeTab(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMultiTabBarFunc_setPosition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMultiTabBar::setPosition(KMultiTabBar::KMultiTabBarPosition)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_KMultiTabBarPosition_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setPosition(KMultiTabBar::KMultiTabBarPosition)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPosition", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);

    // Call function/method
    {
        ::KMultiTabBar::KMultiTabBarPosition cppArg0{KMultiTabBar::Left};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPosition(KMultiTabBar::KMultiTabBarPosition)
            cppSelf->setPosition(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMultiTabBarFunc_setStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMultiTabBar::setStyle(KMultiTabBar::KMultiTabBarStyle)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_KMultiTabBarStyle_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setStyle(KMultiTabBar::KMultiTabBarStyle)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setStyle", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);

    // Call function/method
    {
        ::KMultiTabBar::KMultiTabBarStyle cppArg0{KMultiTabBar::VSNET};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setStyle(KMultiTabBar::KMultiTabBarStyle)
            cppSelf->setStyle(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMultiTabBarFunc_setTab(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setTab", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KMultiTabBar::setTab(int,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setTab(int,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setTab", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTab(int,bool)
            cppSelf->setTab(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMultiTabBarFunc_tab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMultiTabBar::tab(int)const->KMultiTabBarTab*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // tab(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tab", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tab(int)const
            KMultiTabBarTab * cppResult = const_cast<const ::KMultiTabBar *>(cppSelf)->tab(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarTab_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMultiTabBarFunc_tabStyle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tabStyle()const
        KMultiTabBar::KMultiTabBarStyle cppResult = const_cast<const ::KMultiTabBar *>(cppSelf)->tabStyle();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_KMultiTabBarStyle_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMultiTabBarFunc_updateSeparator(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // updateSeparator()
        cppSelf->updateSeparator();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KMultiTabBar_PropertyStrings[] = {
    "position::",
    "tabStyle::setStyle",
    nullptr // Sentinel
};

static const char *Sbk_KMultiTabBar_EnumFlagInfo[] = {
    "KMultiTabBarPosition:IntEnum",
    "KMultiTabBarStyle:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KMultiTabBar_methods[] = {
    {"appendButton", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarFunc_appendButton), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"appendTab", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarFunc_appendTab), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"button", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarFunc_button), METH_O, nullptr},
    {"fontChange", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarFunc_fontChange), METH_O, nullptr},
    {"isTabRaised", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarFunc_isTabRaised), METH_O, nullptr},
    {"paintEvent", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarFunc_paintEvent), METH_O, nullptr},
    {"position", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarFunc_position), METH_NOARGS, nullptr},
    {"removeButton", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarFunc_removeButton), METH_O, nullptr},
    {"removeTab", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarFunc_removeTab), METH_O, nullptr},
    {"setPosition", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarFunc_setPosition), METH_O, nullptr},
    {"setStyle", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarFunc_setStyle), METH_O, nullptr},
    {"setTab", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarFunc_setTab), METH_VARARGS, nullptr},
    {"tab", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarFunc_tab), METH_O, nullptr},
    {"tabStyle", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarFunc_tabStyle), METH_NOARGS, nullptr},
    {"updateSeparator", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarFunc_updateSeparator), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KMultiTabBar_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KMultiTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KMultiTabBarWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KMultiTabBar_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KMultiTabBar_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KMultiTabBarSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KMultiTabBar *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KMultiTabBar_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KMultiTabBar_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KMultiTabBar_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KMultiTabBar_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KMultiTabBar_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KMultiTabBar_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KMultiTabBar_spec = {
    "1:KWidgetsAddons.KMultiTabBar",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KMultiTabBar_slots
};

} //extern "C"

static void *Sbk_KMultiTabBar_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KMultiTabBar *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KMultiTabBar *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KMultiTabBar *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KMultiTabBar_KMultiTabBarPosition(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KMultiTabBar::KMultiTabBarPosition>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KMultiTabBar::KMultiTabBarPosition *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KMultiTabBar_KMultiTabBarPosition_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_KMultiTabBarPosition_IDX])))
        return Enum_PythonToCpp_KMultiTabBar_KMultiTabBarPosition;
    return {};
}

static PyObject *KMultiTabBar_KMultiTabBarPosition_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KMultiTabBar::KMultiTabBarPosition>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KMultiTabBar::KMultiTabBarPosition *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KMultiTabBar_KMultiTabBarStyle(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KMultiTabBar::KMultiTabBarStyle>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KMultiTabBar::KMultiTabBarStyle *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KMultiTabBar_KMultiTabBarStyle_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_KMultiTabBarStyle_IDX])))
        return Enum_PythonToCpp_KMultiTabBar_KMultiTabBarStyle;
    return {};
}

static PyObject *KMultiTabBar_KMultiTabBarStyle_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KMultiTabBar::KMultiTabBarStyle>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KMultiTabBar::KMultiTabBarStyle *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KMultiTabBar_PythonToCpp_KMultiTabBar_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KMultiTabBar_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KMultiTabBar_PythonToCpp_KMultiTabBar_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KMultiTabBar_TypeF()))
        return KMultiTabBar_PythonToCpp_KMultiTabBar_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KMultiTabBar_PTR_CppToPython_KMultiTabBar(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KMultiTabBar *>(const_cast<void *>(cppIn)), Sbk_KMultiTabBar_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KMultiTabBar_SignatureStrings[] = {
    "1:KWidgetsAddons.KMultiTabBar(self,pos:KWidgetsAddons.KMultiTabBar.KMultiTabBarPosition,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,position:KWidgetsAddons.KMultiTabBar.KMultiTabBarPosition=None,tabStyle:KWidgetsAddons.KMultiTabBar.KMultiTabBarStyle=None)",
    "0:KWidgetsAddons.KMultiTabBar(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,position:KWidgetsAddons.KMultiTabBar.KMultiTabBarPosition=None,tabStyle:KWidgetsAddons.KMultiTabBar.KMultiTabBarStyle=None)",
    "KWidgetsAddons.KMultiTabBar.appendButton(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],id:int=-1,popup:PySide6.QtWidgets.QMenu=nullptr,not_used_yet:QString=QString())->int",
    "KWidgetsAddons.KMultiTabBar.appendTab(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],id:int=-1,text:QString=QString())->int",
    "KWidgetsAddons.KMultiTabBar.button(self,id:int)->KWidgetsAddons.KMultiTabBarButton",
    "KWidgetsAddons.KMultiTabBar.fontChange(self,arg__1:typing.Union[PySide6.QtGui.QFont, QString, QStringList])",
    "KWidgetsAddons.KMultiTabBar.isTabRaised(self,id:int)->bool",
    "KWidgetsAddons.KMultiTabBar.paintEvent(self,arg__1:PySide6.QtGui.QPaintEvent)",
    "KWidgetsAddons.KMultiTabBar.position(self)->KWidgetsAddons.KMultiTabBar.KMultiTabBarPosition",
    "KWidgetsAddons.KMultiTabBar.removeButton(self,id:int)",
    "KWidgetsAddons.KMultiTabBar.removeTab(self,id:int)",
    "KWidgetsAddons.KMultiTabBar.setPosition(self,pos:KWidgetsAddons.KMultiTabBar.KMultiTabBarPosition)",
    "KWidgetsAddons.KMultiTabBar.setStyle(self,style:KWidgetsAddons.KMultiTabBar.KMultiTabBarStyle)",
    "KWidgetsAddons.KMultiTabBar.setTab(self,id:int,state:bool)",
    "KWidgetsAddons.KMultiTabBar.tab(self,id:int)->KWidgetsAddons.KMultiTabBarTab",
    "KWidgetsAddons.KMultiTabBar.tabStyle(self)->KWidgetsAddons.KMultiTabBar.KMultiTabBarStyle",
    "KWidgetsAddons.KMultiTabBar.updateSeparator(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KMultiTabBar_SignatureByteSize = 408;
static constexpr uint8_t KMultiTabBar_SignatureBytes[408] = {
    0x78, 0xda, 0xd5, 0x54, 0x4d, 0x4f, 0xc2, 0x40, 0x10, 0xbd, 0xf3, 0x2b, 0x38, 0x82, 0x29, 0x8d,
    0x5c, 0x3c, 0x34, 0xa9, 0x89, 0x18, 0x35, 0x06, 0xd1, 0x62, 0x35, 0x1e, 0x0c, 0x21, 0x5b, 0x77,
    0xc0, 0x4d, 0xca, 0xee, 0xa6, 0x3b, 0x8b, 0xf4, 0xdf, 0x3b, 0xb4, 0xc8, 0x47, 0x25, 0x4b, 0x21,
    0x5e, 0xbc, 0xb4, 0xdb, 0x66, 0xde, 0x9b, 0x79, 0x6f, 0x67, 0xa6, 0x1b, 0xf4, 0xdf, 0x04, 0x9f,
    0x02, 0x9a, 0x2b, 0xce, 0x95, 0x34, 0x7e, 0x7f, 0x60, 0x53, 0x14, 0x2f, 0x2c, 0xe9, 0xb1, 0xac,
    0x65, 0x20, 0x9d, 0x78, 0x5a, 0x19, 0x57, 0xd0, 0xce, 0x47, 0xa4, 0x8c, 0x40, 0xa1, 0xa4, 0xa7,
    0x59, 0x06, 0x12, 0x83, 0x28, 0x8f, 0x05, 0x87, 0x0b, 0x7f, 0x88, 0x2b, 0x02, 0x7f, 0x58, 0x1e,
    0x42, 0x69, 0xd3, 0x54, 0x63, 0xe6, 0x9d, 0x05, 0x7d, 0xc8, 0xbf, 0x54, 0xc6, 0x9f, 0x64, 0x9a,
    0x87, 0x8f, 0x4a, 0xc2, 0x32, 0x61, 0x41, 0x72, 0x74, 0xd6, 0x12, 0x8e, 0x2c, 0x89, 0x31, 0x4f,
    0xa1, 0x36, 0xbc, 0x88, 0x2e, 0xb0, 0xed, 0xc6, 0x79, 0x0d, 0x3f, 0xfe, 0xa9, 0x34, 0x17, 0x86,
    0x69, 0x0d, 0x92, 0xf7, 0x2c, 0xa2, 0x92, 0xa5, 0x4a, 0xf1, 0x41, 0x55, 0x62, 0xae, 0x85, 0x9c,
    0xfa, 0xaf, 0x92, 0x2a, 0x78, 0xdf, 0x08, 0xbe, 0xb3, 0xc2, 0x1f, 0xde, 0x53, 0x80, 0xd7, 0xac,
    0xfc, 0x8c, 0xc4, 0x62, 0xc6, 0xf4, 0xc8, 0x13, 0x3c, 0x10, 0x12, 0xc3, 0x4e, 0x97, 0x14, 0x6b,
    0xab, 0xf7, 0x99, 0x35, 0x00, 0x69, 0xd7, 0x56, 0x49, 0x85, 0x63, 0x6b, 0x80, 0x8f, 0x73, 0xc0,
    0x60, 0x18, 0x63, 0x46, 0x69, 0xc3, 0xd5, 0xbb, 0xd5, 0x6e, 0x77, 0x2e, 0x89, 0xad, 0x86, 0x00,
    0xfa, 0xf8, 0xdb, 0xea, 0x11, 0x16, 0xa7, 0xd5, 0x93, 0x6c, 0x5b, 0x59, 0xd0, 0x11, 0xc8, 0x01,
    0x28, 0xad, 0x77, 0x52, 0x4e, 0x94, 0xc4, 0xeb, 0x4f, 0x26, 0xa7, 0x50, 0xd2, 0xb2, 0x6c, 0x3a,
    0x1e, 0x77, 0x9d, 0x2a, 0x6f, 0x09, 0xe2, 0x35, 0x57, 0x75, 0xaf, 0x0f, 0x0f, 0xc2, 0xe0, 0xc8,
    0xdd, 0x0f, 0xc2, 0xd0, 0xe1, 0x99, 0x09, 0xba, 0x92, 0x8a, 0x86, 0x44, 0xa9, 0xd4, 0x09, 0xd5,
    0x8c, 0x02, 0x6f, 0xe6, 0x34, 0x22, 0x3b, 0x65, 0x56, 0xad, 0x5e, 0x47, 0xb9, 0x0b, 0xf9, 0x19,
    0x98, 0x82, 0xcb, 0x6d, 0xe1, 0xde, 0xb9, 0x71, 0x92, 0x67, 0x30, 0x53, 0x73, 0xe8, 0xfd, 0xbe,
    0xaa, 0x1a, 0xa8, 0x4d, 0xab, 0xd5, 0x80, 0x18, 0xc0, 0x68, 0x5b, 0xc8, 0x49, 0x3b, 0xf5, 0x60,
    0x8a, 0x62, 0xd8, 0x4b, 0x7e, 0x73, 0xfc, 0x96, 0x38, 0x48, 0x5f, 0x51, 0x4c, 0x39, 0x18, 0x42,
    0xb0, 0xec, 0x07, 0x37, 0x14, 0x2b, 0x4e, 0x39, 0x2f, 0x91, 0x9e, 0x87, 0xc8, 0x36, 0x32, 0x8f,
    0xe8, 0x87, 0x02, 0xe4, 0x64, 0xb6, 0x9a, 0x93, 0x9e, 0x18, 0x68, 0xbd, 0x33, 0x54, 0xe5, 0xae,
    0x6f, 0x37, 0xbe, 0x01, 0xbc, 0xc0, 0x9c, 0x1d
};
#endif

PyTypeObject *init_KMultiTabBar(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX].type;

    Shiboken::AutoDecRef Sbk_KMultiTabBar_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KMultiTabBar_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KMultiTabBar",
        "KMultiTabBar*",
        &Sbk_KMultiTabBar_spec,
        &Shiboken::callCppDestructor< KMultiTabBar >,
        Sbk_KMultiTabBar_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KMultiTabBar_Type; // references _Sbk_KMultiTabBar_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KMultiTabBar_SignatureStrings);
#else
    InitSignatureBytes(pyType, KMultiTabBar_SignatureBytes, KMultiTabBar_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KMultiTabBar_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KMultiTabBar_PythonToCpp_KMultiTabBar_PTR,
        is_KMultiTabBar_PythonToCpp_KMultiTabBar_PTR_Convertible,
        KMultiTabBar_PTR_CppToPython_KMultiTabBar);

    Shiboken::Conversions::registerConverterName(converter, "KMultiTabBar");
    Shiboken::Conversions::registerConverterName(converter, "KMultiTabBar*");
    Shiboken::Conversions::registerConverterName(converter, "KMultiTabBar&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KMultiTabBar).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KMultiTabBarWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KMultiTabBar_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KMultiTabBar_TypeF(), &Sbk_KMultiTabBarSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KMultiTabBar_TypeF(), &Sbk_KMultiTabBar_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KMultiTabBar_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'KMultiTabBarPosition'.
    const char *KMultiTabBarPosition_Initializer[] = {
        "Left",
        "Right",
        "Top",
        "Bottom",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t KMultiTabBarPosition_InitializerValues[] = {
        uint8_t(KMultiTabBar::KMultiTabBarPosition::Left),  //  0x00  0
        uint8_t(KMultiTabBar::KMultiTabBarPosition::Right), //  0x01  1
        uint8_t(KMultiTabBar::KMultiTabBarPosition::Top),   //  0x02  2
        uint8_t(KMultiTabBar::KMultiTabBarPosition::Bottom) //  0x03  3
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KMultiTabBar_TypeF(),
        "1:KWidgetsAddons.KMultiTabBar.KMultiTabBarPosition",
        KMultiTabBarPosition_Initializer, KMultiTabBarPosition_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_KMultiTabBarPosition_IDX].type = EType;
    // Register converter for enum 'KMultiTabBar::KMultiTabBarPosition'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KMultiTabBar_KMultiTabBarPosition_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KMultiTabBar_KMultiTabBarPosition,
            is_Enum_PythonToCpp_KMultiTabBar_KMultiTabBarPosition_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KMultiTabBar::KMultiTabBarPosition");
        Shiboken::Conversions::registerConverterAlias(converter, "KMultiTabBarPosition");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'KMultiTabBarPosition' enum.

    // Initialization of enum 'KMultiTabBarStyle'.
    const char *KMultiTabBarStyle_Initializer[] = {
        "VSNET",
        "KDEV3ICON",
        "STYLELAST",
        nullptr};
    // "uint16_t" used instead of "unsigned int"
    constexpr uint16_t KMultiTabBarStyle_InitializerValues[] = {
        uint16_t(KMultiTabBar::KMultiTabBarStyle::VSNET),     //  0x0000  0
        uint16_t(KMultiTabBar::KMultiTabBarStyle::KDEV3ICON), //  0x0002  2
        uint16_t(KMultiTabBar::KMultiTabBarStyle::STYLELAST)  //  0xffff  65535
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KMultiTabBar_TypeF(),
        "1:KWidgetsAddons.KMultiTabBar.KMultiTabBarStyle",
        KMultiTabBarStyle_Initializer, KMultiTabBarStyle_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_KMultiTabBarStyle_IDX].type = EType;
    // Register converter for enum 'KMultiTabBar::KMultiTabBarStyle'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KMultiTabBar_KMultiTabBarStyle_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KMultiTabBar_KMultiTabBarStyle,
            is_Enum_PythonToCpp_KMultiTabBar_KMultiTabBarStyle_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KMultiTabBar::KMultiTabBarStyle");
        Shiboken::Conversions::registerConverterAlias(converter, "KMultiTabBarStyle");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'KMultiTabBarStyle' enum.

    qRegisterMetaType< ::KMultiTabBar::KMultiTabBarPosition >("KMultiTabBar::KMultiTabBarPosition");
    qRegisterMetaType< ::KMultiTabBar::KMultiTabBarStyle >("KMultiTabBar::KMultiTabBarStyle");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KMultiTabBar::staticMetaObject, sizeof(KMultiTabBarWrapper));

    return pyType;
}
