
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "ktwofingertaprecognizer_wrapper.h"

// Argument includes
#include <qcoreevent.h>
#include <qgesture.h>
#include <qobject.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KTwoFingerTapRecognizer_Type = nullptr;
static PyTypeObject *Sbk_KTwoFingerTapRecognizer_TypeF(void)
{
    return _Sbk_KTwoFingerTapRecognizer_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KTwoFingerTapRecognizerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KTwoFingerTapRecognizerWrapper::KTwoFingerTapRecognizerWrapper()
{
}

::QGesture * KTwoFingerTapRecognizerWrapper::create(::QObject * target)
{
    static const char *funcName = "create";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerTapRecognizer_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTwoFingerTapRecognizer::create(target);
    }
    return sbk_o_create("KTwoFingerTapRecognizer", funcName, gil, pyOverride, target);
}

::QGesture * KTwoFingerTapRecognizerWrapper::sbk_o_create(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * target)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), target)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), target)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    bool invalidateArg0 = Py_REFCNT(pyResult) == 1;
    if (invalidateArg0)
        Shiboken::Object::releaseOwnership(pyResult.object());
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QGesture_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QGesture >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QGesture *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QFlags<QGestureRecognizer::ResultFlag> KTwoFingerTapRecognizerWrapper::recognize(::QGesture * gesture, ::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "recognize";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerTapRecognizer_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTwoFingerTapRecognizer::recognize(gesture, watched, event);
    }
    return sbk_o_recognize("KTwoFingerTapRecognizer", funcName, gil, pyOverride, gesture, watched, event);
}

::QFlags<QGestureRecognizer::ResultFlag> KTwoFingerTapRecognizerWrapper::sbk_o_recognize(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QGesture * gesture, ::QObject * watched, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QGesture_IDX]), gesture),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), watched),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QGesture_IDX]), gesture),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), watched),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return QFlags<QGestureRecognizer::ResultFlag>(0);
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFlags_QGestureRecognizer_ResultFlag_IDX])))->flagsConverter, pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QFlags<QGestureRecognizer::ResultFlag> >()), Py_TYPE(pyResult)->tp_name);
        return QFlags<QGestureRecognizer::ResultFlag>(0);
    }
    ::QFlags<QGestureRecognizer::ResultFlag> cppResult = QFlags<QGestureRecognizer::ResultFlag>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KTwoFingerTapRecognizerWrapper::reset(::QGesture * state)
{
    static const char *funcName = "reset";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerTapRecognizer_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QGestureRecognizer::reset(state);
    }
    sbk_o_reset("KTwoFingerTapRecognizer", funcName, gil, pyOverride, state);
}

void KTwoFingerTapRecognizerWrapper::sbk_o_reset(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QGesture * state)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QGesture_IDX]), state)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QGesture_IDX]), state)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

KTwoFingerTapRecognizerWrapper::~KTwoFingerTapRecognizerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KTwoFingerTapRecognizer_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KTwoFingerTapRecognizer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KTwoFingerTapRecognizer >()))
        return -1;

    KTwoFingerTapRecognizerWrapper *cptr{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTapRecognizer_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // KTwoFingerTapRecognizer()
        cptr = new KTwoFingerTapRecognizerWrapper();
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KTwoFingerTapRecognizer >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KTwoFingerTapRecognizerFunc_create(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerTapRecognizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTapRecognizer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGestureRecognizer::create(QObject*)->QGesture*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArg)))) {
        overloadId = 0; // create(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "create", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTapRecognizer_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // create(QObject*)
            QGesture * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KTwoFingerTapRecognizer::create(cppArg0)
                : cppSelf->create(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QGesture_IDX]), cppResult);

            // Ownership transferences.
            Shiboken::Object::releaseOwnership(pyResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTwoFingerTapRecognizerFunc_recognize(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerTapRecognizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTapRecognizer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "recognize", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QGestureRecognizer::recognize(QGesture*,QObject*,QEvent*)->QFlags<QGestureRecognizer::ResultFlag>
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QGesture_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[2])))) {
        overloadId = 0; // recognize(QGesture*,QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "recognize", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTapRecognizer_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QGesture *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // recognize(QGesture*,QObject*,QEvent*)
            QFlags<QGestureRecognizer::ResultFlag> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KTwoFingerTapRecognizer::recognize(cppArg0, cppArg1, cppArg2)
                : cppSelf->recognize(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFlags_QGestureRecognizer_ResultFlag_IDX])))->flagsConverter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTwoFingerTapRecognizerFunc_setTapRadius(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerTapRecognizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTapRecognizer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTwoFingerTapRecognizer::setTapRadius(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setTapRadius(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTapRadius", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTapRecognizer_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTapRadius(int)
            cppSelf->setTapRadius(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTwoFingerTapRecognizerFunc_tapRadius(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerTapRecognizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTapRecognizer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tapRadius()const
        int cppResult = const_cast<const ::KTwoFingerTapRecognizer *>(cppSelf)->tapRadius();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KTwoFingerTapRecognizer_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KTwoFingerTapRecognizer_methods[] = {
    {"create", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerTapRecognizerFunc_create), METH_O, nullptr},
    {"recognize", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerTapRecognizerFunc_recognize), METH_VARARGS, nullptr},
    {"setTapRadius", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerTapRecognizerFunc_setTapRadius), METH_O, nullptr},
    {"tapRadius", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerTapRecognizerFunc_tapRadius), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KTwoFingerTapRecognizer_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KTwoFingerTapRecognizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTapRecognizer_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KTwoFingerTapRecognizerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KTwoFingerTapRecognizer_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KTwoFingerTapRecognizer_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KTwoFingerTapRecognizer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KTwoFingerTapRecognizer_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KTwoFingerTapRecognizer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KTwoFingerTapRecognizer_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KTwoFingerTapRecognizer_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KTwoFingerTapRecognizer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KTwoFingerTapRecognizer_spec = {
    "1:KWidgetsAddons.KTwoFingerTapRecognizer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KTwoFingerTapRecognizer_slots
};

} //extern "C"

static void *Sbk_KTwoFingerTapRecognizer_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QGestureRecognizer >())
        return dynamic_cast< ::KTwoFingerTapRecognizer *>(reinterpret_cast< ::QGestureRecognizer *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KTwoFingerTapRecognizer_PythonToCpp_KTwoFingerTapRecognizer_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KTwoFingerTapRecognizer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KTwoFingerTapRecognizer_PythonToCpp_KTwoFingerTapRecognizer_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KTwoFingerTapRecognizer_TypeF()))
        return KTwoFingerTapRecognizer_PythonToCpp_KTwoFingerTapRecognizer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KTwoFingerTapRecognizer_PTR_CppToPython_KTwoFingerTapRecognizer(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KTwoFingerTapRecognizer_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    auto *tCppIn = reinterpret_cast<const ::KTwoFingerTapRecognizer *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    return Shiboken::Object::newObjectForPointer(Sbk_KTwoFingerTapRecognizer_TypeF(), const_cast<void *>(cppIn), false, typeName);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KTwoFingerTapRecognizer_SignatureStrings[] = {
    "KWidgetsAddons.KTwoFingerTapRecognizer(self)",
    "KWidgetsAddons.KTwoFingerTapRecognizer.create(self,target:PySide6.QtCore.QObject)->PySide6.QtWidgets.QGesture",
    "KWidgetsAddons.KTwoFingerTapRecognizer.recognize(self,gesture:PySide6.QtWidgets.QGesture,watched:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->PySide6.QtWidgets.QGestureRecognizer.ResultFlag",
    "KWidgetsAddons.KTwoFingerTapRecognizer.setTapRadius(self,i:int)",
    "KWidgetsAddons.KTwoFingerTapRecognizer.tapRadius(self)->int",
    nullptr}; // Sentinel
#else
static constexpr size_t KTwoFingerTapRecognizer_SignatureByteSize = 180;
static constexpr uint8_t KTwoFingerTapRecognizer_SignatureBytes[180] = {
    0x78, 0xda, 0x8d, 0x8f, 0xb1, 0x0a, 0xc2, 0x30, 0x10, 0x86, 0xf7, 0x3e, 0x89, 0x42, 0xcd, 0xe8,
    0xd0, 0x41, 0x10, 0xb1, 0x0e, 0x1d, 0xb4, 0xb5, 0xe0, 0x1c, 0x93, 0xdf, 0x18, 0x29, 0x89, 0x24,
    0x57, 0x8b, 0x3e, 0xbd, 0xa9, 0x55, 0x54, 0xa4, 0xd2, 0xed, 0xb8, 0xbb, 0xef, 0xfe, 0xef, 0xb2,
    0x9d, 0x96, 0x0a, 0xe4, 0xe7, 0x52, 0x5a, 0xe3, 0x59, 0x56, 0x36, 0x36, 0xd5, 0x46, 0xc1, 0x95,
    0xfc, 0x5c, 0x40, 0x58, 0x65, 0xf4, 0x0d, 0x6e, 0xe4, 0x51, 0x1d, 0xc6, 0x51, 0x36, 0x68, 0x99,
    0x09, 0x07, 0x4e, 0x78, 0x30, 0x31, 0x71, 0x17, 0x88, 0x64, 0x73, 0xdd, 0x6a, 0x89, 0x29, 0xcb,
    0x69, 0x61, 0x1d, 0x58, 0xbe, 0xde, 0x9f, 0x20, 0x68, 0x3c, 0x99, 0xbd, 0x07, 0xcf, 0xdb, 0x2c,
    0x5f, 0xc1, 0x53, 0xed, 0x30, 0x34, 0xcd, 0xbd, 0xca, 0x2e, 0x50, 0x75, 0x74, 0xd2, 0x7f, 0x38,
    0x6e, 0x38, 0x89, 0x23, 0x64, 0x8f, 0x54, 0x8c, 0x0b, 0xcc, 0xaf, 0xf1, 0xb2, 0xed, 0xfe, 0x15,
    0xfe, 0x70, 0x2a, 0xe0, 0xeb, 0x8a, 0xd2, 0x8a, 0xab, 0xa1, 0x5f, 0x78, 0x50, 0xdb, 0xe0, 0x52,
    0xd7, 0xbe, 0x7b, 0x44, 0x27, 0x3a, 0x04, 0x0e, 0xe5, 0xe9, 0x0b, 0x0e, 0x9e, 0x01, 0x8e, 0xee,
    0x40, 0x30, 0xb0, 0xa6
};
#endif

PyTypeObject *init_KTwoFingerTapRecognizer(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTapRecognizer_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTapRecognizer_IDX].type;

    Shiboken::AutoDecRef Sbk_KTwoFingerTapRecognizer_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QGestureRecognizer_IDX]))));

    _Sbk_KTwoFingerTapRecognizer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KTwoFingerTapRecognizer",
        "KTwoFingerTapRecognizer*",
        &Sbk_KTwoFingerTapRecognizer_spec,
        &Shiboken::callCppDestructor< KTwoFingerTapRecognizer >,
        Sbk_KTwoFingerTapRecognizer_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KTwoFingerTapRecognizer_Type; // references _Sbk_KTwoFingerTapRecognizer_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KTwoFingerTapRecognizer_SignatureStrings);
#else
    InitSignatureBytes(pyType, KTwoFingerTapRecognizer_SignatureBytes, KTwoFingerTapRecognizer_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KTwoFingerTapRecognizer_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTapRecognizer_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KTwoFingerTapRecognizer_PythonToCpp_KTwoFingerTapRecognizer_PTR,
        is_KTwoFingerTapRecognizer_PythonToCpp_KTwoFingerTapRecognizer_PTR_Convertible,
        KTwoFingerTapRecognizer_PTR_CppToPython_KTwoFingerTapRecognizer);

    Shiboken::Conversions::registerConverterName(converter, "KTwoFingerTapRecognizer");
    Shiboken::Conversions::registerConverterName(converter, "KTwoFingerTapRecognizer*");
    Shiboken::Conversions::registerConverterName(converter, "KTwoFingerTapRecognizer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KTwoFingerTapRecognizer).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KTwoFingerTapRecognizerWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KTwoFingerTapRecognizer_TypeF(), &Sbk_KTwoFingerTapRecognizer_typeDiscovery);

    qRegisterMetaType< ::KTwoFingerTapRecognizer *>();

    return pyType;
}
