
#include <sbkpep.h>
#include <shiboken.h>
#include <sbkbindingutils.h>
#include <algorithm>
#include <signature.h>
#include <sbkcontainer.h>
#include <sbkstaticstrings.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysidecleanup.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <pysidestaticstrings.h>
#include "kcoreaddons_python.h"

#include <QHash>
#include <QList>
#include <QMap>
#include <QString>
#include <QStringList>
#include <kaboutdata.h>
#include <kautosavefile.h>
#include <kfuzzymatcher.h>
#include <kjob.h>
#include <kpluginmetadata.h>
#include <kprocesslist.h>
#include <kuser.h>
#include <qchar.h>
#include <qurl.h>
#include <qvariant.h>
#include <utility>


// Current module's type array.
Shiboken::Module::TypeInitStruct *SbkKCoreAddonsTypeStructs = nullptr;
// Backwards compatible structure with identical indexing.
PyTypeObject **SbkKCoreAddonsTypes = nullptr;
// Current module's converter array.
SbkConverter **SbkKCoreAddonsTypeConverters = nullptr;

void cleanTypesAttributes() {
    static PyObject *attrName = Shiboken::PyName::qtStaticMetaObject();
    const int imax = SBK_KCoreAddons_IDX_COUNT;
    for (int i = 0; i < imax && SbkKCoreAddonsTypeStructs[i].fullName != nullptr; ++i) {
        auto *pyType = reinterpret_cast<PyObject *>(SbkKCoreAddonsTypeStructs[i].type);
        if (pyType != nullptr && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}

// Global functions ------------------------------------------------------------

static PyMethodDef KCoreAddonsMethods[] = {
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
PyTypeObject *init_KUserId(PyObject *enclosing);
PyTypeObject *init_KUserGroup(PyObject *enclosing);
PyTypeObject *init_KUser(PyObject *enclosing);
PyTypeObject *init_KCoreAddonsKUrlMimeData(PyObject *enclosing);
PyTypeObject *init_KCoreAddonsKTextToHTML(PyObject *enclosing);
PyTypeObject *init_KCoreAddonsKStringHandler(PyObject *enclosing);
PyTypeObject *init_KSignalHandler(PyObject *enclosing);
PyTypeObject *init_KCoreAddonsKShell(PyObject *enclosing);
PyTypeObject *init_KSharedDataCache(PyObject *enclosing);
PyTypeObject *init_KCoreAddonsKSandbox(PyObject *enclosing);
PyTypeObject *init_KSandbox_ProcessContext(PyObject *enclosing);
PyTypeObject *init_KCoreAddonsKRuntimePlatform(PyObject *enclosing);
PyTypeObject *init_KCoreAddonsKRandom(PyObject *enclosing);
PyTypeObject *init_KCoreAddonsKProcessList(PyObject *enclosing);
PyTypeObject *init_KProcessList_KProcessInfo(PyObject *enclosing);
PyTypeObject *init_KProcess(PyObject *enclosing);
PyTypeObject *init_KPluginMetaData(PyObject *enclosing);
PyTypeObject *init_KPluginFactory(PyObject *enclosing);
PyTypeObject *init_KOSRelease(PyObject *enclosing);
PyTypeObject *init_KNetworkMounts(PyObject *enclosing);
PyTypeObject *init_KMemoryInfo(PyObject *enclosing);
PyTypeObject *init_KMacroExpanderBase(PyObject *enclosing);
PyTypeObject *init_KWordMacroExpander(PyObject *enclosing);
PyTypeObject *init_KCoreAddonsKMacroExpander(PyObject *enclosing);
PyTypeObject *init_KCoreAddonsKLibexec(PyObject *enclosing);
PyTypeObject *init_KCoreAddonsKJsonUtils(PyObject *enclosing);
PyTypeObject *init_KJobUiDelegate(PyObject *enclosing);
PyTypeObject *init_KJobTrackerInterface(PyObject *enclosing);
PyTypeObject *init_KJob(PyObject *enclosing);
PyTypeObject *init_KListOpenFilesJob(PyObject *enclosing);
PyTypeObject *init_KGroupId(PyObject *enclosing);
PyTypeObject *init_KCoreAddonsKFuzzyMatcher(PyObject *enclosing);
PyTypeObject *init_KFuzzyMatcher_Result(PyObject *enclosing);
PyTypeObject *init_KFuzzyMatcher_Range(PyObject *enclosing);
PyTypeObject *init_KFormat(PyObject *enclosing);
PyTypeObject *init_KCoreAddonsKFileUtils(PyObject *enclosing);
PyTypeObject *init_KCoreAddonsKFileSystemType(PyObject *enclosing);
PyTypeObject *init_KDirWatch(PyObject *enclosing);
PyTypeObject *init_KCoreAddonsKCoreAddons(PyObject *enclosing);
PyTypeObject *init_KCompositeJob(PyObject *enclosing);
PyTypeObject *init_KCharMacroExpander(PyObject *enclosing);
PyTypeObject *init_KCoreAddonsKBackup(PyObject *enclosing);
PyTypeObject *init_KAutoSaveFile(PyObject *enclosing);
PyTypeObject *init_KAboutPerson(PyObject *enclosing);
PyTypeObject *init_KAboutLicense(PyObject *enclosing);
PyTypeObject *init_KAboutData(PyObject *enclosing);
PyTypeObject *init_KAboutComponent(PyObject *enclosing);

// Required modules' type and converter arrays.
Shiboken::Module::TypeInitStruct *SbkPySide6_QtCoreTypeStructs;
SbkConverter **SbkPySide6_QtCoreTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for container type 'QList<int>'.
static PyObject *_QList_int__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<int> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_int_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<int> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_int__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return PySequence_PythonToCpp__QList_int_;
    return {};
}


// Binding for QList<int>

template <>
struct ShibokenContainerValueConverter<int>
{
    static bool checkValue(PyObject *pyArg)
    {
        return PyLong_Check(pyArg);
    }

    static PyObject *convertValueToPython(int cppArg)
    {
        return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppArg);
    }

    static std::optional<int> convertValueToCpp(PyObject *pyArg)
    {
        Shiboken::Conversions::PythonToCppConversion pythonToCpp;
        if (!(PyLong_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg))))) {
            Shiboken::Errors::setWrongContainerType();
            return {};
        }
        int cppArg;
        pythonToCpp(pyArg, &cppArg);
        return cppArg;
    }
};

static PyMethodDef QIntList_methods[] = {
    {"push_back", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_back), METH_O, "push_back"},
    {"append", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_back), METH_O, "append"},
    {"clear", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::clear), METH_NOARGS, "clear"},
    {"pop_back", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_back), METH_NOARGS, "pop_back"},
    {"removeLast", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_back), METH_NOARGS, "removeLast"},
    {"push_front", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_front), METH_O, "push_front"},
    {"prepend", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_front), METH_O, "prepend"},
    {"pop_front", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_front), METH_NOARGS, "pop_front"},
    {"removeFirst", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_front), METH_O, "removeFirst"},
    {"reserve", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::reserve), METH_O, "reserve"},
    {"capacity", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::capacity), METH_NOARGS, "capacity"},
    {"data", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::data), METH_NOARGS, "data"},
    {"constData", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::constData), METH_NOARGS, "constData"},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyType_Slot QIntList_slots[] = {
    {Py_tp_init, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpInit)},
    {Py_tp_new, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpNew)},
    {Py_tp_free, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpFree)},
    {Py_tp_dealloc, reinterpret_cast<void *>(Sbk_object_dealloc)},
    {Py_tp_methods, reinterpret_cast<void *>(QIntList_methods)},
    {Py_sq_ass_item, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqSetItem)},
    {Py_sq_length, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqLen)},
    {Py_sq_item, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqGetItem)},
    {0, nullptr}
};

static PyType_Spec QIntList_spec = {
    "1:KCoreAddons.QIntList",
    sizeof(ShibokenContainer),
    0,
    Py_TPFLAGS_DEFAULT,
    QIntList_slots
};

static inline PyTypeObject *createQIntListType()
{
    auto *result = SbkType_FromSpec(&QIntList_spec);
    Py_INCREF(Py_True);
    Shiboken::AutoDecRef tpDict(PepType_GetDict(result));
    PyDict_SetItem(tpDict.object(), Shiboken::PyMagicName::opaque_container(), Py_True);
    return result;
}

static PyTypeObject *QIntList_TypeF()
{
    static PyTypeObject *type = createQIntListType();
    return type;
}

extern "C" PyObject *createQIntList(QList<int>* ct)
{
    auto *container = PyObject_New(ShibokenContainer, QIntList_TypeF());
    auto *d = new ShibokenSequenceContainerPrivate<QList<int>>();
    d->m_list = ct;
    container->d = d;
    return reinterpret_cast<PyObject *>(container);
}

extern "C" PyObject *createConstQIntList(const QList<int>* ct)
{
    auto *container = PyObject_New(ShibokenContainer, QIntList_TypeF());
    auto *d = new ShibokenSequenceContainerPrivate<QList<int>>();
    d->m_list = const_cast<QList<int> *>(ct);
    d->m_const = true;
    container->d = d;
    return reinterpret_cast<PyObject *>(container);
}

extern "C" int QIntList_Check(PyObject *pyArg)
{
    return pyArg != nullptr && pyArg != Py_None && pyArg->ob_type == QIntList_TypeF();
}

extern "C" void PythonToCppQIntList(PyObject *pyArg, void *cppOut)
{
    auto *d = ShibokenSequenceContainerPrivate<QList<int>>::get(pyArg);
    *reinterpret_cast<QList<int>**>(cppOut) = d->m_list;
}

extern "C" PythonToCppFunc isQIntListPythonToCppConvertible(PyObject *pyArg)
{
    if (QIntList_Check(pyArg))
        return PythonToCppQIntList;
    return {};
}

extern "C" void PythonToQVariantQIntList(PyObject *pyArg, void *cppOut)
{
    auto *d = ShibokenSequenceContainerPrivate<QList<int>>::get(pyArg);
    *reinterpret_cast<QVariant *>(cppOut) = QVariant::fromValue(*d->m_list);
}

extern "C" PythonToCppFunc isQIntListPythonToQVariantConvertible(PyObject *pyArg)
{
    if (QIntList_Check(pyArg))
        return PythonToQVariantQIntList;
    return {};
}

// C++ to Python conversion for container type 'QList<KUserGroup>'.
static PyObject *_QList_KUserGroup__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<KUserGroup> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_KUserGroup_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<KUserGroup> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::KUserGroup cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_KUserGroup__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_KUserGroup_;
    return {};
}

// C++ to Python conversion for container type 'QList<KUser>'.
static PyObject *_QList_KUser__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<KUser> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_KUser_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<KUser> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::KUser cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_KUser__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_KUser_;
    return {};
}

// C++ to Python conversion for container type 'QMap<QString,QString>'.
static PyObject *_QMap_QString_QString__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QMap<QString,QString> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QMap_QString_QString_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QString> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], key, &(cppKey));
        ::QString cppValue;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QMap_QString_QString__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, pyIn))
        return PyDict_PythonToCpp__QMap_QString_QString_;
    return {};
}

// C++ to Python conversion for container type 'QList<QUrl>'.
static PyObject *_QList_QUrl__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QUrl> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QUrl_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QUrl> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QUrl cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QUrl__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QUrl_;
    return {};
}

// C++ to Python conversion for container type 'QList<KProcessList::KProcessInfo>'.
static PyObject *_QList_KProcessList_KProcessInfo__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<KProcessList::KProcessInfo> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_KProcessList_KProcessInfo_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<KProcessList::KProcessInfo> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::KProcessList::KProcessInfo cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_KProcessList_KProcessInfo__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_KProcessList_KProcessInfo_;
    return {};
}

// C++ to Python conversion for container type 'QList<KAboutPerson>'.
static PyObject *_QList_KAboutPerson__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<KAboutPerson> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_KAboutPerson_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<KAboutPerson> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::KAboutPerson cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_KAboutPerson__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_KAboutPerson_;
    return {};
}

// C++ to Python conversion for container type 'QList<KPluginMetaData>'.
static PyObject *_QList_KPluginMetaData__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<KPluginMetaData> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_KPluginMetaData_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<KPluginMetaData> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::KPluginMetaData* cppItem{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(*cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_KPluginMetaData__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_KPluginMetaData_;
    return {};
}

// C++ to Python conversion for container type 'QHash<QChar,QString>'.
static PyObject *_QHash_QChar_QString__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QHash<QChar,QString> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QHash_QChar_QString_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QHash<QChar,QString> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QChar cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], key, &(cppKey));
        ::QString cppValue;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QHash_QChar_QString__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], false, SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, pyIn))
        return PyDict_PythonToCpp__QHash_QChar_QString_;
    return {};
}

// C++ to Python conversion for container type 'QHash<QChar,QStringList>'.
static PyObject *_QHash_QChar_QStringList__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QHash<QChar,QStringList> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QHash_QChar_QStringList_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QHash<QChar,QStringList> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QChar cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], key, &(cppKey));
        ::QStringList cppValue;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QHash_QChar_QStringList__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], false, SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], false, pyIn))
        return PyDict_PythonToCpp__QHash_QChar_QStringList_;
    return {};
}

// C++ to Python conversion for container type 'QHash<QString,QString>'.
static PyObject *_QHash_QString_QString__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QHash<QString,QString> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QHash_QString_QString_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QHash<QString,QString> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], key, &(cppKey));
        ::QString cppValue;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QHash_QString_QString__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, pyIn))
        return PyDict_PythonToCpp__QHash_QString_QString_;
    return {};
}

// C++ to Python conversion for container type 'QHash<QString,QStringList>'.
static PyObject *_QHash_QString_QStringList__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QHash<QString,QStringList> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QHash_QString_QStringList_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QHash<QString,QStringList> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], key, &(cppKey));
        ::QStringList cppValue;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QHash_QString_QStringList__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], false, pyIn))
        return PyDict_PythonToCpp__QHash_QString_QStringList_;
    return {};
}

// C++ to Python conversion for container type 'std::pair<QString,QString>'.
static PyObject *std_pair_QString_QString__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const std::pair<QString,QString> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cpppair_to_pytuple - START
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SetItem(pyOut, 0, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppInRef.first));
    PyTuple_SetItem(pyOut, 1, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppInRef.second));
    return pyOut;
    // TEMPLATE - shiboken_conversion_cpppair_to_pytuple - END

}
static void PySequence_PythonToCpp_std_pair_QString_QString_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<std::pair<QString,QString> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pysequence_to_cpppair - START
    Shiboken::AutoDecRef objfirst(PySequence_GetItem(pyIn, 0));
    Shiboken::AutoDecRef objsecond(PySequence_GetItem(pyIn, 1));
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], objfirst, &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], objsecond, &(cppOutRef.second));
    // TEMPLATE - shiboken_conversion_pysequence_to_cpppair - END

}
static PythonToCppFunc is_PySequence_PythonToCpp_std_pair_QString_QString__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertiblePairTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, pyIn))
        return PySequence_PythonToCpp_std_pair_QString_QString_;
    return {};
}

// C++ to Python conversion for container type 'QList<KFuzzyMatcher::Range>'.
static PyObject *_QList_KFuzzyMatcher_Range__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<KFuzzyMatcher::Range> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_KFuzzyMatcher_Range_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<KFuzzyMatcher::Range> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::KFuzzyMatcher::Range cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_KFuzzyMatcher_Range__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_KFuzzyMatcher_Range_;
    return {};
}

// C++ to Python conversion for container type 'QList<KJob*>'.
static PyObject *_QList_KJobPTR__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<KJob*> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_KJobPTR_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<KJob*> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::KJob* cppItem{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_KJobPTR__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::checkSequenceTypes(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_KJobPTR_;
    return {};
}

// C++ to Python conversion for container type 'QList<KAutoSaveFile*>'.
static PyObject *_QList_KAutoSaveFilePTR__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<KAutoSaveFile*> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_KAutoSaveFilePTR_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<KAutoSaveFile*> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::KAutoSaveFile* cppItem{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_KAutoSaveFilePTR__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::checkSequenceTypes(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_KAutoSaveFilePTR_;
    return {};
}

// C++ to Python conversion for container type 'QList<KAboutComponent>'.
static PyObject *_QList_KAboutComponent__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<KAboutComponent> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_KAboutComponent_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<KAboutComponent> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::KAboutComponent cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_KAboutComponent__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_KAboutComponent_;
    return {};
}

// C++ to Python conversion for container type 'QList<KAboutLicense>'.
static PyObject *_QList_KAboutLicense__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<KAboutLicense> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_KAboutLicense_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<KAboutLicense> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::KAboutLicense cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_KAboutLicense__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_KAboutLicense_;
    return {};
}

// C++ to Python conversion for container type 'QList<QVariant>'.
static PyObject *_QList_QVariant__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QVariant> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], pyIn))
        return PySequence_PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for container type 'QList<QString>'.
static PyObject *_QList_QString__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QString> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QString> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QString__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyIn))
        return PySequence_PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for container type 'QMap<QString,QVariant>'.
static PyObject *_QMap_QString_QVariant__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QMap<QString,QVariant> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], key, &(cppKey));
        ::QVariant cppValue;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], false, pyIn))
        return PyDict_PythonToCpp__QMap_QString_QVariant_;
    return {};
}


// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddons_SignatureStrings[] = {
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddons_SignatureByteSize = 0;
static constexpr uint8_t KCoreAddons_SignatureBytes[1] = {
    0x00
};
#endif

static void initInheritance()
{
    auto &bm = Shiboken::BindingManager::instance();
    SBK_UNUSED(bm)
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKCoreAddonsTypeStructs[SBK_KSignalHandler_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QProcess_IDX],
                           &SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKCoreAddonsTypeStructs[SBK_KPluginFactory_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]);
    bm.addClassInheritance(&SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX],
                           &SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);
    bm.addClassInheritance(&SbkKCoreAddonsTypeStructs[SBK_KJob_IDX],
                           &SbkKCoreAddonsTypeStructs[SBK_KListOpenFilesJob_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);
    bm.addClassInheritance(&SbkKCoreAddonsTypeStructs[SBK_KJob_IDX],
                           &SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]);
    bm.addClassInheritance(&SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX],
                           &SbkKCoreAddonsTypeStructs[SBK_KCharMacroExpander_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QFile_IDX],
                           &SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);
}

static void initConverters_KCoreAddons()
{
    // Register primitive types converters.
    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "K_GID");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "K_UID");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blksize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "__caddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__clock_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__clockid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__compar_d_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__compar_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__daddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__dev_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsblkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsblkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsfilcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsfilcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__fsword_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__gid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__id_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__ino64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__ino_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<short>(), "__int16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__int32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__int64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "__int8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<short>(), "__int_least16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__int_least32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__int_least64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "__int_least8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__intmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__intptr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__key_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__loff_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__mode_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__nlink_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__off64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__off_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__pid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__poll_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__rlim64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__rlim_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__sig_atomic_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__socklen_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__ssize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__suseconds64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__suseconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__syscall_slong_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__syscall_ulong_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__time_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__u_char");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__u_int");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__u_long");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__u_quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__u_short");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__uint16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uint32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uint64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__uint8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__uint_least16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uint_least32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uint_least64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__uint_least8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uintmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__useconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blksize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "caddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "comparison_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "daddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "dev_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsblkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsblkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsfilcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsfilcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "gid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "id_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "ino64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "ino_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "int_fast8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "intmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "key_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "loff_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "mode_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "nlink_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "off64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "off_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "pid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "qInternalCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "register_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "ssize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "suseconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "u_char");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "u_int");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "u_int16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "u_int32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_int64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "u_int8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_long");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "u_short");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "uid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "uint_fast8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uintmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "useconds_t");

}

static void initContainerConverters_KCoreAddons()
{
    // Register converter for type 'QList<int>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_int_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_int__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_int_IDX], "QList<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_int_IDX],
        PySequence_PythonToCpp__QList_int_,
        is_PySequence_PythonToCpp__QList_int__Convertible);
    Shiboken::Conversions::setPythonToCppPointerFunctions(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_int_IDX],
        PythonToCppQIntList,
        isQIntListPythonToCppConvertible);

    // Register converter for type 'QList<KUserGroup>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KUserGroup_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_KUserGroup__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KUserGroup_IDX], "QList<KUserGroup>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KUserGroup_IDX],
        PySequence_PythonToCpp__QList_KUserGroup_,
        is_PySequence_PythonToCpp__QList_KUserGroup__Convertible);

    // Register converter for type 'QList<KUser>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KUser_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_KUser__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KUser_IDX], "QList<KUser>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KUser_IDX],
        PySequence_PythonToCpp__QList_KUser_,
        is_PySequence_PythonToCpp__QList_KUser__Convertible);

    // Register converter for type 'QMap<QString,QString>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QMap_QString_QString_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QString__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QMap_QString_QString_IDX], "QMap<QString,QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QMap_QString_QString_IDX],
        PyDict_PythonToCpp__QMap_QString_QString_,
        is_PyDict_PythonToCpp__QMap_QString_QString__Convertible);
    // Register converters for type aliases of QMap<QString,QString>'.
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QMap_QString_QString_IDX], "KUrlMimeData::MetaDataMap");

    // Register converter for type 'QList<QUrl>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_QUrl_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QUrl__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_QUrl_IDX], "QList<QUrl>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_QUrl_IDX],
        PySequence_PythonToCpp__QList_QUrl_,
        is_PySequence_PythonToCpp__QList_QUrl__Convertible);

    // Register converter for type 'QList<KProcessList::KProcessInfo>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KProcessList_KProcessInfo_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_KProcessList_KProcessInfo__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KProcessList_KProcessInfo_IDX], "QList<KProcessList::KProcessInfo>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KProcessList_KProcessInfo_IDX],
        PySequence_PythonToCpp__QList_KProcessList_KProcessInfo_,
        is_PySequence_PythonToCpp__QList_KProcessList_KProcessInfo__Convertible);
    // Register converters for type aliases of QList<KProcessList::KProcessInfo>'.
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KProcessList_KProcessInfo_IDX], "KProcessList::KProcessInfoList");

    // Register converter for type 'QList<KAboutPerson>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutPerson_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_KAboutPerson__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutPerson_IDX], "QList<KAboutPerson>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutPerson_IDX],
        PySequence_PythonToCpp__QList_KAboutPerson_,
        is_PySequence_PythonToCpp__QList_KAboutPerson__Convertible);

    // Register converter for type 'QList<KPluginMetaData>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KPluginMetaData_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_KPluginMetaData__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KPluginMetaData_IDX], "QList<KPluginMetaData>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KPluginMetaData_IDX],
        PySequence_PythonToCpp__QList_KPluginMetaData_,
        is_PySequence_PythonToCpp__QList_KPluginMetaData__Convertible);

    // Register converter for type 'QHash<QChar,QString>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QChar_QString_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QHash_QChar_QString__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QChar_QString_IDX], "QHash<QChar,QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QChar_QString_IDX],
        PyDict_PythonToCpp__QHash_QChar_QString_,
        is_PyDict_PythonToCpp__QHash_QChar_QString__Convertible);

    // Register converter for type 'QHash<QChar,QStringList>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QChar_QStringList_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QHash_QChar_QStringList__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QChar_QStringList_IDX], "QHash<QChar,QStringList>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QChar_QStringList_IDX],
        PyDict_PythonToCpp__QHash_QChar_QStringList_,
        is_PyDict_PythonToCpp__QHash_QChar_QStringList__Convertible);

    // Register converter for type 'QHash<QString,QString>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QString_QString_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QHash_QString_QString__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QString_QString_IDX], "QHash<QString,QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QString_QString_IDX],
        PyDict_PythonToCpp__QHash_QString_QString_,
        is_PyDict_PythonToCpp__QHash_QString_QString__Convertible);

    // Register converter for type 'QHash<QString,QStringList>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QString_QStringList_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QHash_QString_QStringList__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QString_QStringList_IDX], "QHash<QString,QStringList>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QString_QStringList_IDX],
        PyDict_PythonToCpp__QHash_QString_QStringList_,
        is_PyDict_PythonToCpp__QHash_QString_QStringList__Convertible);

    // Register converter for type 'std::pair<QString,QString>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_std_pair_QString_QString_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, std_pair_QString_QString__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_std_pair_QString_QString_IDX], "std::pair<QString,QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_std_pair_QString_QString_IDX],
        PySequence_PythonToCpp_std_pair_QString_QString_,
        is_PySequence_PythonToCpp_std_pair_QString_QString__Convertible);

    // Register converter for type 'QList<KFuzzyMatcher::Range>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KFuzzyMatcher_Range_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_KFuzzyMatcher_Range__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KFuzzyMatcher_Range_IDX], "QList<KFuzzyMatcher::Range>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KFuzzyMatcher_Range_IDX],
        PySequence_PythonToCpp__QList_KFuzzyMatcher_Range_,
        is_PySequence_PythonToCpp__QList_KFuzzyMatcher_Range__Convertible);

    // Register converter for type 'QList<KJob*>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KJobPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_KJobPTR__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KJobPTR_IDX], "QList<KJob*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KJobPTR_IDX],
        PySequence_PythonToCpp__QList_KJobPTR_,
        is_PySequence_PythonToCpp__QList_KJobPTR__Convertible);

    // Register converter for type 'QList<KAutoSaveFile*>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAutoSaveFilePTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_KAutoSaveFilePTR__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAutoSaveFilePTR_IDX], "QList<KAutoSaveFile*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAutoSaveFilePTR_IDX],
        PySequence_PythonToCpp__QList_KAutoSaveFilePTR_,
        is_PySequence_PythonToCpp__QList_KAutoSaveFilePTR__Convertible);

    // Register converter for type 'QList<KAboutComponent>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutComponent_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_KAboutComponent__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutComponent_IDX], "QList<KAboutComponent>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutComponent_IDX],
        PySequence_PythonToCpp__QList_KAboutComponent_,
        is_PySequence_PythonToCpp__QList_KAboutComponent__Convertible);

    // Register converter for type 'QList<KAboutLicense>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutLicense_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_KAboutLicense__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutLicense_IDX], "QList<KAboutLicense>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutLicense_IDX],
        PySequence_PythonToCpp__QList_KAboutLicense_,
        is_PySequence_PythonToCpp__QList_KAboutLicense__Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_QVariant_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_QVariant_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_QVariant_IDX],
        PySequence_PythonToCpp__QList_QVariant_,
        is_PySequence_PythonToCpp__QList_QVariant__Convertible);
    // Register converters for type aliases of QList<QVariant>'.
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_QVariant_IDX], "QVariantList");

    // Register converter for type 'QList<QString>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_QString_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_QString_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_QString_IDX],
        PySequence_PythonToCpp__QList_QString_,
        is_PySequence_PythonToCpp__QList_QString__Convertible);
    // Register converters for type aliases of QList<QString>'.

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QMap_QString_QVariant_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QMap_QString_QVariant_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QMap_QString_QVariant_IDX],
        PyDict_PythonToCpp__QMap_QString_QVariant_,
        is_PyDict_PythonToCpp__QMap_QString_QVariant__Convertible);
    // Register converters for type aliases of QMap<QString,QVariant>'.
    Shiboken::Conversions::registerConverterName(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QMap_QString_QVariant_IDX], "QVariantMap");

}

static void registerOpaqueContainers_KCoreAddons(PyObject *module)
{
    PyTypeObject *pyType{};
    auto *qVariantConverter = Shiboken::Conversions::getConverter("QVariant");
    Q_ASSERT(qVariantConverter != nullptr);
    pyType = QIntList_TypeF();
    Py_XINCREF(reinterpret_cast<PyObject *>(pyType));
    PepModule_AddType(module, pyType);
    if constexpr (QMetaTypeId2<int>::Defined) {
        Shiboken::Conversions::prependPythonToCppValueConversion(qVariantConverter,
            PythonToQVariantQIntList, isQIntListPythonToQVariantConvertible);
    }
}

extern "C" {
static int exec_KCoreAddons(PyObject *module)
{
    Shiboken::Module::exec(module);

    // Initialize classes in the type system
    Shiboken::Module::AddTypeCreationFunction(module, "KUserId", init_KUserId);
    Shiboken::Module::AddTypeCreationFunction(module, "KUserGroup", init_KUserGroup);
    Shiboken::Module::AddTypeCreationFunction(module, "KUser", init_KUser);
    Shiboken::Module::AddTypeCreationFunction(module, "KUrlMimeData", init_KCoreAddonsKUrlMimeData);
    Shiboken::Module::AddTypeCreationFunction(module, "KTextToHTML", init_KCoreAddonsKTextToHTML);
    Shiboken::Module::AddTypeCreationFunction(module, "KStringHandler", init_KCoreAddonsKStringHandler);
    Shiboken::Module::AddTypeCreationFunction(module, "KSignalHandler", init_KSignalHandler);
    Shiboken::Module::AddTypeCreationFunction(module, "KShell", init_KCoreAddonsKShell);
    Shiboken::Module::AddTypeCreationFunction(module, "KSharedDataCache", init_KSharedDataCache);
    Shiboken::Module::AddTypeCreationFunction(module, "KSandbox", init_KCoreAddonsKSandbox);
    Shiboken::Module::AddTypeCreationFunction(module, "KSandbox", init_KSandbox_ProcessContext, "KSandbox.ProcessContext");
    Shiboken::Module::AddTypeCreationFunction(module, "KRuntimePlatform", init_KCoreAddonsKRuntimePlatform);
    Shiboken::Module::AddTypeCreationFunction(module, "KRandom", init_KCoreAddonsKRandom);
    Shiboken::Module::AddTypeCreationFunction(module, "KProcessList", init_KCoreAddonsKProcessList);
    Shiboken::Module::AddTypeCreationFunction(module, "KProcessList", init_KProcessList_KProcessInfo, "KProcessList.KProcessInfo");
    Shiboken::Module::AddTypeCreationFunction(module, "KProcess", init_KProcess);
    Shiboken::Module::AddTypeCreationFunction(module, "KPluginMetaData", init_KPluginMetaData);
    Shiboken::Module::AddTypeCreationFunction(module, "KPluginFactory", init_KPluginFactory);
    Shiboken::Module::AddTypeCreationFunction(module, "KOSRelease", init_KOSRelease);
    Shiboken::Module::AddTypeCreationFunction(module, "KNetworkMounts", init_KNetworkMounts);
    Shiboken::Module::AddTypeCreationFunction(module, "KMemoryInfo", init_KMemoryInfo);
    Shiboken::Module::AddTypeCreationFunction(module, "KMacroExpanderBase", init_KMacroExpanderBase);
    Shiboken::Module::AddTypeCreationFunction(module, "KWordMacroExpander", init_KWordMacroExpander);
    Shiboken::Module::AddTypeCreationFunction(module, "KMacroExpander", init_KCoreAddonsKMacroExpander);
    Shiboken::Module::AddTypeCreationFunction(module, "KLibexec", init_KCoreAddonsKLibexec);
    Shiboken::Module::AddTypeCreationFunction(module, "KJsonUtils", init_KCoreAddonsKJsonUtils);
    Shiboken::Module::AddTypeCreationFunction(module, "KJobUiDelegate", init_KJobUiDelegate);
    Shiboken::Module::AddTypeCreationFunction(module, "KJobTrackerInterface", init_KJobTrackerInterface);
    Shiboken::Module::AddTypeCreationFunction(module, "KJob", init_KJob);
    Shiboken::Module::AddTypeCreationFunction(module, "KListOpenFilesJob", init_KListOpenFilesJob);
    Shiboken::Module::AddTypeCreationFunction(module, "KGroupId", init_KGroupId);
    Shiboken::Module::AddTypeCreationFunction(module, "KFuzzyMatcher", init_KCoreAddonsKFuzzyMatcher);
    Shiboken::Module::AddTypeCreationFunction(module, "KFuzzyMatcher", init_KFuzzyMatcher_Result, "KFuzzyMatcher.Result");
    Shiboken::Module::AddTypeCreationFunction(module, "KFuzzyMatcher", init_KFuzzyMatcher_Range, "KFuzzyMatcher.Range");
    Shiboken::Module::AddTypeCreationFunction(module, "KFormat", init_KFormat);
    Shiboken::Module::AddTypeCreationFunction(module, "KFileUtils", init_KCoreAddonsKFileUtils);
    Shiboken::Module::AddTypeCreationFunction(module, "KFileSystemType", init_KCoreAddonsKFileSystemType);
    Shiboken::Module::AddTypeCreationFunction(module, "KDirWatch", init_KDirWatch);
    Shiboken::Module::AddTypeCreationFunction(module, "KCoreAddons", init_KCoreAddonsKCoreAddons);
    Shiboken::Module::AddTypeCreationFunction(module, "KCompositeJob", init_KCompositeJob);
    Shiboken::Module::AddTypeCreationFunction(module, "KCharMacroExpander", init_KCharMacroExpander);
    Shiboken::Module::AddTypeCreationFunction(module, "KBackup", init_KCoreAddonsKBackup);
    Shiboken::Module::AddTypeCreationFunction(module, "KAutoSaveFile", init_KAutoSaveFile);
    Shiboken::Module::AddTypeCreationFunction(module, "KAboutPerson", init_KAboutPerson);
    Shiboken::Module::AddTypeCreationFunction(module, "KAboutLicense", init_KAboutLicense);
    Shiboken::Module::AddTypeCreationFunction(module, "KAboutData", init_KAboutData);
    Shiboken::Module::AddTypeCreationFunction(module, "KAboutComponent", init_KAboutComponent);

    registerOpaqueContainers_KCoreAddons(module);

    Shiboken::Module::registerTypes(module, SbkKCoreAddonsTypeStructs);
    Shiboken::Module::registerTypeConverters(module, SbkKCoreAddonsTypeConverters);

    initInheritance();

    if (Shiboken::Errors::occurred() != nullptr) {
        PyErr_Print();
        Py_FatalError("shiboken: can't initialize module KCoreAddons");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

#if PYSIDE6_COMOPT_COMPRESS == 0
    FinishSignatureInitialization(module, KCoreAddons_SignatureStrings);
#else
    if (FinishSignatureInitBytes(module, KCoreAddons_SignatureBytes, KCoreAddons_SignatureByteSize) < 0)
        return -1;
#endif

    return 0;
}
} // extern "C"

static PyModuleDef_Slot KCoreAddonsModuleSlots[] = {
    {Py_mod_exec, reinterpret_cast<void *>(exec_KCoreAddons)},
#if !defined(PYPY_VERSION) && ((!defined(Py_LIMITED_API) && PY_VERSION_HEX >= 0x030C0000) || (defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030C0000))
    {Py_mod_multiple_interpreters, Py_MOD_MULTIPLE_INTERPRETERS_NOT_SUPPORTED},
#endif
#ifdef Py_GIL_DISABLED
    {Py_mod_gil, Py_MOD_GIL_USED},
#endif
    {0, nullptr}
};

static struct PyModuleDef KCoreAddonsModuleDef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "KCoreAddons",
    /* m_doc      */ nullptr,
    /* m_size     */ 0,
    /* m_methods  */ KCoreAddonsMethods,
    /* m_slots    */ KCoreAddonsModuleSlots,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

extern "C" LIBSHIBOKEN_EXPORT PyObject *PyInit_KCoreAddons()
{
    Shiboken::init();

    // Create an array of wrapper types/names for the current module.
    static Shiboken::Module::TypeInitStruct cppApi[] = {
        {nullptr, "KCoreAddons.KAboutComponent"},
        {nullptr, "KCoreAddons.KAboutData"},
        {nullptr, "KCoreAddons.KAboutLicense"},
        {nullptr, "KCoreAddons.KAboutLicense.LicenseKey"},
        {nullptr, "KCoreAddons.KAboutLicense.NameFormat"},
        {nullptr, "KCoreAddons.KAboutLicense.VersionRestriction"},
        {nullptr, "KCoreAddons.KAboutPerson"},
        {nullptr, "KCoreAddons.KAutoSaveFile"},
        {nullptr, "KCoreAddons.KBackup"},
        {nullptr, "KCoreAddons.KCharMacroExpander"},
        {nullptr, "KCoreAddons.KCompositeJob"},
        {nullptr, "KCoreAddons.KCoreAddons"},
        {nullptr, "KCoreAddons.KDirWatch"},
        {nullptr, "KCoreAddons.KDirWatch.Method"},
        {nullptr, "KCoreAddons.KDirWatch.WatchMode"},
        {nullptr, "KCoreAddons.KFileSystemType"},
        {nullptr, "KCoreAddons.KFileSystemType.Type"},
        {nullptr, "KCoreAddons.KFileUtils"},
        {nullptr, "KCoreAddons.KFormat"},
        {nullptr, "KCoreAddons.KFormat.BinarySizeUnits"},
        {nullptr, "KCoreAddons.KFormat.BinaryUnitDialect"},
        {nullptr, "KCoreAddons.KFormat.DistanceFormatOption"},
        {nullptr, "KCoreAddons.KFormat.DurationFormatOption"},
        {nullptr, "KCoreAddons.KFormat.Unit"},
        {nullptr, "KCoreAddons.KFormat.UnitPrefix"},
        {nullptr, "KCoreAddons.KFuzzyMatcher"},
        {nullptr, "KCoreAddons.KFuzzyMatcher.Range"},
        {nullptr, "KCoreAddons.KFuzzyMatcher.RangeType"},
        {nullptr, "KCoreAddons.KFuzzyMatcher.Result"},
        {nullptr, "KCoreAddons.KGroupId"},
        {nullptr, "KCoreAddons.KJob"},
        {nullptr, "KCoreAddons.KJob.Capability"},
        {nullptr, "KCoreAddons.KJob.KillVerbosity"},
        {nullptr, "KCoreAddons.KJob.Unit"},
        {nullptr, "KCoreAddons.KJobTrackerInterface"},
        {nullptr, "KCoreAddons.KJobUiDelegate"},
        {nullptr, "KCoreAddons.KJobUiDelegate.Flag"},
        {nullptr, "KCoreAddons.KJsonUtils"},
        {nullptr, "KCoreAddons.KLibexec"},
        {nullptr, "KCoreAddons.KListOpenFilesJob"},
        {nullptr, "KCoreAddons.KListOpenFilesJob.Error"},
        {nullptr, "KCoreAddons.KMacroExpander"},
        {nullptr, "KCoreAddons.KMacroExpanderBase"},
        {nullptr, "KCoreAddons.KMemoryInfo"},
        {nullptr, "KCoreAddons.KNetworkMounts"},
        {nullptr, "KCoreAddons.KNetworkMounts.KNetworkMountOption"},
        {nullptr, "KCoreAddons.KNetworkMounts.KNetworkMountsType"},
        {nullptr, "KCoreAddons.KOSRelease"},
        {nullptr, "KCoreAddons.KPluginFactory"},
        {nullptr, "KCoreAddons.KPluginFactory.ResultErrorReason"},
        {nullptr, "KCoreAddons.KPluginMetaData"},
        {nullptr, "KCoreAddons.KPluginMetaData.KPluginMetaDataOption"},
        {nullptr, "KCoreAddons.KProcess"},
        {nullptr, "KCoreAddons.KProcess.OutputChannelMode"},
        {nullptr, "KCoreAddons.KProcessList"},
        {nullptr, "KCoreAddons.KProcessList.KProcessInfo"},
        {nullptr, "KCoreAddons.KRandom"},
        {nullptr, "KCoreAddons.KRuntimePlatform"},
        {nullptr, "KCoreAddons.KSandbox"},
        {nullptr, "KCoreAddons.KSandbox.ProcessContext"},
        {nullptr, "KCoreAddons.KSharedDataCache"},
        {nullptr, "KCoreAddons.KSharedDataCache.EvictionPolicy"},
        {nullptr, "KCoreAddons.KShell"},
        {nullptr, "KCoreAddons.KShell.Errors"},
        {nullptr, "KCoreAddons.KShell.Option"},
        {nullptr, "KCoreAddons.KSignalHandler"},
        {nullptr, "KCoreAddons.KStringHandler"},
        {nullptr, "KCoreAddons.KTextToHTML"},
        {nullptr, "KCoreAddons.KTextToHTML.Option"},
        {nullptr, "KCoreAddons.KUrlMimeData"},
        {nullptr, "KCoreAddons.KUrlMimeData.DecodeOption"},
        {nullptr, "KCoreAddons.KUser"},
        {nullptr, "KCoreAddons.KUser.UIDMode"},
        {nullptr, "KCoreAddons.KUser.UserProperty"},
        {nullptr, "KCoreAddons.KUserGroup"},
        {nullptr, "KCoreAddons.KUserId"},
        {nullptr, "KCoreAddons.KWordMacroExpander"},
        {nullptr, "KCoreAddons.KDirWatch.WatchModes"},
        {nullptr, "KCoreAddons.KFormat.DistanceFormatOptions"},
        {nullptr, "KCoreAddons.KFormat.DurationFormatOptions"},
        {nullptr, "KCoreAddons.KJob.Capabilities"},
        {nullptr, "KCoreAddons.KJobUiDelegate.Flags"},
        {nullptr, "KCoreAddons.KPluginMetaData.KPluginMetaDataOptions"},
        {nullptr, "KCoreAddons.KShell.Options"},
        {nullptr, "KCoreAddons.KTextToHTML.Options"},
        {nullptr, "KCoreAddons.KUrlMimeData.DecodeOptions"},
        {nullptr, nullptr}
    };
    // The new global structure consisting of (type, name) pairs.
    SbkKCoreAddonsTypeStructs = cppApi;
    QT_WARNING_PUSH
    QT_WARNING_DISABLE_DEPRECATED
    // The backward compatible alias with upper case indexes.
    SbkKCoreAddonsTypes = reinterpret_cast<PyTypeObject **>(cppApi);
    QT_WARNING_POP

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_KCoreAddons_CONVERTERS_IDX_COUNT];
    SbkKCoreAddonsTypeConverters = sbkConverters;

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtCore"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtCoreTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    initConverters_KCoreAddons();
    initContainerConverters_KCoreAddons();

    PyObject *module = nullptr;
    if (Shiboken::isCompiled()) {
        KCoreAddonsModuleDef.m_size = -1;
        KCoreAddonsModuleDef.m_slots = nullptr;
        module = Shiboken::Module::createOnly("KCoreAddons", &KCoreAddonsModuleDef);
        if (module == nullptr)
            return nullptr;
#ifdef Py_GIL_DISABLED
        PyUnstable_Module_SetGIL(module, Py_MOD_GIL_NOT_USED);
#endif
        if (exec_KCoreAddons(module) != 0)
            return nullptr;
    } else {
        module = PyModuleDef_Init(&KCoreAddonsModuleDef);
    }
    return module;
}

