{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Provides detailed information on how a scroll operation should be performed.
-- 
-- Scrolling functions usually allow passing a @NULL@ scroll info which will
-- cause the default values to be used and just scroll the element into view.
-- 
-- /Since: 4.12/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Structs.ScrollInfo
    ( 

-- * Exported types
    ScrollInfo(..)                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [ref]("GI.Gtk.Structs.ScrollInfo#g:method:ref"), [unref]("GI.Gtk.Structs.ScrollInfo#g:method:unref").
-- 
-- ==== Getters
-- [getEnableHorizontal]("GI.Gtk.Structs.ScrollInfo#g:method:getEnableHorizontal"), [getEnableVertical]("GI.Gtk.Structs.ScrollInfo#g:method:getEnableVertical").
-- 
-- ==== Setters
-- [setEnableHorizontal]("GI.Gtk.Structs.ScrollInfo#g:method:setEnableHorizontal"), [setEnableVertical]("GI.Gtk.Structs.ScrollInfo#g:method:setEnableVertical").

#if defined(ENABLE_OVERLOADING)
    ResolveScrollInfoMethod                 ,
#endif

-- ** getEnableHorizontal #method:getEnableHorizontal#

#if defined(ENABLE_OVERLOADING)
    ScrollInfoGetEnableHorizontalMethodInfo ,
#endif
    scrollInfoGetEnableHorizontal           ,


-- ** getEnableVertical #method:getEnableVertical#

#if defined(ENABLE_OVERLOADING)
    ScrollInfoGetEnableVerticalMethodInfo   ,
#endif
    scrollInfoGetEnableVertical             ,


-- ** new #method:new#

    scrollInfoNew                           ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    ScrollInfoRefMethodInfo                 ,
#endif
    scrollInfoRef                           ,


-- ** setEnableHorizontal #method:setEnableHorizontal#

#if defined(ENABLE_OVERLOADING)
    ScrollInfoSetEnableHorizontalMethodInfo ,
#endif
    scrollInfoSetEnableHorizontal           ,


-- ** setEnableVertical #method:setEnableVertical#

#if defined(ENABLE_OVERLOADING)
    ScrollInfoSetEnableVerticalMethodInfo   ,
#endif
    scrollInfoSetEnableVertical             ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    ScrollInfoUnrefMethodInfo               ,
#endif
    scrollInfoUnref                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype ScrollInfo = ScrollInfo (SP.ManagedPtr ScrollInfo)
    deriving (Eq)

instance SP.ManagedPtrNewtype ScrollInfo where
    toManagedPtr (ScrollInfo p) = p

foreign import ccall "gtk_scroll_info_get_type" c_gtk_scroll_info_get_type :: 
    IO GType

type instance O.ParentTypes ScrollInfo = '[]
instance O.HasParentTypes ScrollInfo

instance B.Types.TypedObject ScrollInfo where
    glibType = c_gtk_scroll_info_get_type

instance B.Types.GBoxed ScrollInfo

-- | Convert t'ScrollInfo' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ScrollInfo) where
    gvalueGType_ = c_gtk_scroll_info_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr ScrollInfo)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr ScrollInfo)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed ScrollInfo ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ScrollInfo
type instance O.AttributeList ScrollInfo = ScrollInfoAttributeList
type ScrollInfoAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method ScrollInfo::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ScrollInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scroll_info_new" gtk_scroll_info_new :: 
    IO (Ptr ScrollInfo)

-- | Creates a new scroll info for scrolling an element into view.
-- 
-- /Since: 4.12/
scrollInfoNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ScrollInfo
    -- ^ __Returns:__ A new scroll info
scrollInfoNew  = liftIO $ do
    result <- gtk_scroll_info_new
    checkUnexpectedReturnNULL "scrollInfoNew" result
    result' <- (wrapBoxed ScrollInfo) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ScrollInfo::get_enable_horizontal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrollInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrollInfo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scroll_info_get_enable_horizontal" gtk_scroll_info_get_enable_horizontal :: 
    Ptr ScrollInfo ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ScrollInfo"})
    IO CInt

-- | Checks if horizontal scrolling is enabled.
-- 
-- /Since: 4.12/
scrollInfoGetEnableHorizontal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ScrollInfo
    -- ^ /@self@/: a @GtkScrollInfo@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if horizontal scrolling is enabled.
scrollInfoGetEnableHorizontal self = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    result <- gtk_scroll_info_get_enable_horizontal self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ScrollInfoGetEnableHorizontalMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod ScrollInfoGetEnableHorizontalMethodInfo ScrollInfo signature where
    overloadedMethod = scrollInfoGetEnableHorizontal

instance O.OverloadedMethodInfo ScrollInfoGetEnableHorizontalMethodInfo ScrollInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.ScrollInfo.scrollInfoGetEnableHorizontal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-ScrollInfo.html#v:scrollInfoGetEnableHorizontal"
        })


#endif

-- method ScrollInfo::get_enable_vertical
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrollInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrollInfo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scroll_info_get_enable_vertical" gtk_scroll_info_get_enable_vertical :: 
    Ptr ScrollInfo ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ScrollInfo"})
    IO CInt

-- | Checks if vertical scrolling is enabled.
-- 
-- /Since: 4.12/
scrollInfoGetEnableVertical ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ScrollInfo
    -- ^ /@self@/: a @GtkScrollInfo@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if vertical scrolling is enabled.
scrollInfoGetEnableVertical self = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    result <- gtk_scroll_info_get_enable_vertical self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ScrollInfoGetEnableVerticalMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod ScrollInfoGetEnableVerticalMethodInfo ScrollInfo signature where
    overloadedMethod = scrollInfoGetEnableVertical

instance O.OverloadedMethodInfo ScrollInfoGetEnableVerticalMethodInfo ScrollInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.ScrollInfo.scrollInfoGetEnableVertical",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-ScrollInfo.html#v:scrollInfoGetEnableVertical"
        })


#endif

-- method ScrollInfo::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrollInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrollInfo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ScrollInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scroll_info_ref" gtk_scroll_info_ref :: 
    Ptr ScrollInfo ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ScrollInfo"})
    IO (Ptr ScrollInfo)

-- | Increases the reference count of a @GtkScrollInfo@ by one.
-- 
-- /Since: 4.12/
scrollInfoRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ScrollInfo
    -- ^ /@self@/: a @GtkScrollInfo@
    -> m ScrollInfo
    -- ^ __Returns:__ the passed in @GtkScrollInfo@.
scrollInfoRef self = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    result <- gtk_scroll_info_ref self'
    checkUnexpectedReturnNULL "scrollInfoRef" result
    result' <- (wrapBoxed ScrollInfo) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ScrollInfoRefMethodInfo
instance (signature ~ (m ScrollInfo), MonadIO m) => O.OverloadedMethod ScrollInfoRefMethodInfo ScrollInfo signature where
    overloadedMethod = scrollInfoRef

instance O.OverloadedMethodInfo ScrollInfoRefMethodInfo ScrollInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.ScrollInfo.scrollInfoRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-ScrollInfo.html#v:scrollInfoRef"
        })


#endif

-- method ScrollInfo::set_enable_horizontal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrollInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrollInfo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "horizontal"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "if scrolling in the horizontal direction\n    should happen"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scroll_info_set_enable_horizontal" gtk_scroll_info_set_enable_horizontal :: 
    Ptr ScrollInfo ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ScrollInfo"})
    CInt ->                                 -- horizontal : TBasicType TBoolean
    IO ()

-- | Turns horizontal scrolling on or off.
-- 
-- /Since: 4.12/
scrollInfoSetEnableHorizontal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ScrollInfo
    -- ^ /@self@/: a @GtkScrollInfo@
    -> Bool
    -- ^ /@horizontal@/: if scrolling in the horizontal direction
    --     should happen
    -> m ()
scrollInfoSetEnableHorizontal self horizontal = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    let horizontal' = (P.fromIntegral . P.fromEnum) horizontal
    gtk_scroll_info_set_enable_horizontal self' horizontal'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrollInfoSetEnableHorizontalMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m) => O.OverloadedMethod ScrollInfoSetEnableHorizontalMethodInfo ScrollInfo signature where
    overloadedMethod = scrollInfoSetEnableHorizontal

instance O.OverloadedMethodInfo ScrollInfoSetEnableHorizontalMethodInfo ScrollInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.ScrollInfo.scrollInfoSetEnableHorizontal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-ScrollInfo.html#v:scrollInfoSetEnableHorizontal"
        })


#endif

-- method ScrollInfo::set_enable_vertical
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrollInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrollInfo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "vertical"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "if scrolling in the vertical direction\n    should happen"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scroll_info_set_enable_vertical" gtk_scroll_info_set_enable_vertical :: 
    Ptr ScrollInfo ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ScrollInfo"})
    CInt ->                                 -- vertical : TBasicType TBoolean
    IO ()

-- | Turns vertical scrolling on or off.
-- 
-- /Since: 4.12/
scrollInfoSetEnableVertical ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ScrollInfo
    -- ^ /@self@/: a @GtkScrollInfo@
    -> Bool
    -- ^ /@vertical@/: if scrolling in the vertical direction
    --     should happen
    -> m ()
scrollInfoSetEnableVertical self vertical = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    let vertical' = (P.fromIntegral . P.fromEnum) vertical
    gtk_scroll_info_set_enable_vertical self' vertical'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrollInfoSetEnableVerticalMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m) => O.OverloadedMethod ScrollInfoSetEnableVerticalMethodInfo ScrollInfo signature where
    overloadedMethod = scrollInfoSetEnableVertical

instance O.OverloadedMethodInfo ScrollInfoSetEnableVerticalMethodInfo ScrollInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.ScrollInfo.scrollInfoSetEnableVertical",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-ScrollInfo.html#v:scrollInfoSetEnableVertical"
        })


#endif

-- method ScrollInfo::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrollInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrollInfo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scroll_info_unref" gtk_scroll_info_unref :: 
    Ptr ScrollInfo ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ScrollInfo"})
    IO ()

-- | Decreases the reference count of a @GtkScrollInfo@ by one.
-- 
-- If the resulting reference count is zero, frees the self.
-- 
-- /Since: 4.12/
scrollInfoUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ScrollInfo
    -- ^ /@self@/: a @GtkScrollInfo@
    -> m ()
scrollInfoUnref self = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    gtk_scroll_info_unref self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrollInfoUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod ScrollInfoUnrefMethodInfo ScrollInfo signature where
    overloadedMethod = scrollInfoUnref

instance O.OverloadedMethodInfo ScrollInfoUnrefMethodInfo ScrollInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.ScrollInfo.scrollInfoUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-ScrollInfo.html#v:scrollInfoUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveScrollInfoMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveScrollInfoMethod "ref" o = ScrollInfoRefMethodInfo
    ResolveScrollInfoMethod "unref" o = ScrollInfoUnrefMethodInfo
    ResolveScrollInfoMethod "getEnableHorizontal" o = ScrollInfoGetEnableHorizontalMethodInfo
    ResolveScrollInfoMethod "getEnableVertical" o = ScrollInfoGetEnableVerticalMethodInfo
    ResolveScrollInfoMethod "setEnableHorizontal" o = ScrollInfoSetEnableHorizontalMethodInfo
    ResolveScrollInfoMethod "setEnableVertical" o = ScrollInfoSetEnableVerticalMethodInfo
    ResolveScrollInfoMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveScrollInfoMethod t ScrollInfo, O.OverloadedMethod info ScrollInfo p) => OL.IsLabel t (ScrollInfo -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveScrollInfoMethod t ScrollInfo, O.OverloadedMethod info ScrollInfo p, R.HasField t ScrollInfo p) => R.HasField t ScrollInfo p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveScrollInfoMethod t ScrollInfo, O.OverloadedMethodInfo info ScrollInfo) => OL.IsLabel t (O.MethodProxy info ScrollInfo) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


