{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Describe a rotation using Euler angles.
-- 
-- The contents of the t'GI.Graphene.Structs.Euler.Euler' structure are private
-- and should never be accessed directly.
-- 
-- /Since: 1.2/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Graphene.Structs.Euler
    ( 

-- * Exported types
    Euler(..)                               ,
    newZeroEuler                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [equal]("GI.Graphene.Structs.Euler#g:method:equal"), [free]("GI.Graphene.Structs.Euler#g:method:free"), [init]("GI.Graphene.Structs.Euler#g:method:init"), [initFromEuler]("GI.Graphene.Structs.Euler#g:method:initFromEuler"), [initFromMatrix]("GI.Graphene.Structs.Euler#g:method:initFromMatrix"), [initFromQuaternion]("GI.Graphene.Structs.Euler#g:method:initFromQuaternion"), [initFromRadians]("GI.Graphene.Structs.Euler#g:method:initFromRadians"), [initFromVec3]("GI.Graphene.Structs.Euler#g:method:initFromVec3"), [initWithOrder]("GI.Graphene.Structs.Euler#g:method:initWithOrder"), [reorder]("GI.Graphene.Structs.Euler#g:method:reorder"), [toMatrix]("GI.Graphene.Structs.Euler#g:method:toMatrix"), [toQuaternion]("GI.Graphene.Structs.Euler#g:method:toQuaternion"), [toVec3]("GI.Graphene.Structs.Euler#g:method:toVec3").
-- 
-- ==== Getters
-- [getAlpha]("GI.Graphene.Structs.Euler#g:method:getAlpha"), [getBeta]("GI.Graphene.Structs.Euler#g:method:getBeta"), [getGamma]("GI.Graphene.Structs.Euler#g:method:getGamma"), [getOrder]("GI.Graphene.Structs.Euler#g:method:getOrder"), [getX]("GI.Graphene.Structs.Euler#g:method:getX"), [getY]("GI.Graphene.Structs.Euler#g:method:getY"), [getZ]("GI.Graphene.Structs.Euler#g:method:getZ").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveEulerMethod                      ,
#endif

-- ** alloc #method:alloc#

    eulerAlloc                              ,


-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    EulerEqualMethodInfo                    ,
#endif
    eulerEqual                              ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    EulerFreeMethodInfo                     ,
#endif
    eulerFree                               ,


-- ** getAlpha #method:getAlpha#

#if defined(ENABLE_OVERLOADING)
    EulerGetAlphaMethodInfo                 ,
#endif
    eulerGetAlpha                           ,


-- ** getBeta #method:getBeta#

#if defined(ENABLE_OVERLOADING)
    EulerGetBetaMethodInfo                  ,
#endif
    eulerGetBeta                            ,


-- ** getGamma #method:getGamma#

#if defined(ENABLE_OVERLOADING)
    EulerGetGammaMethodInfo                 ,
#endif
    eulerGetGamma                           ,


-- ** getOrder #method:getOrder#

#if defined(ENABLE_OVERLOADING)
    EulerGetOrderMethodInfo                 ,
#endif
    eulerGetOrder                           ,


-- ** getX #method:getX#

#if defined(ENABLE_OVERLOADING)
    EulerGetXMethodInfo                     ,
#endif
    eulerGetX                               ,


-- ** getY #method:getY#

#if defined(ENABLE_OVERLOADING)
    EulerGetYMethodInfo                     ,
#endif
    eulerGetY                               ,


-- ** getZ #method:getZ#

#if defined(ENABLE_OVERLOADING)
    EulerGetZMethodInfo                     ,
#endif
    eulerGetZ                               ,


-- ** init #method:init#

#if defined(ENABLE_OVERLOADING)
    EulerInitMethodInfo                     ,
#endif
    eulerInit                               ,


-- ** initFromEuler #method:initFromEuler#

#if defined(ENABLE_OVERLOADING)
    EulerInitFromEulerMethodInfo            ,
#endif
    eulerInitFromEuler                      ,


-- ** initFromMatrix #method:initFromMatrix#

#if defined(ENABLE_OVERLOADING)
    EulerInitFromMatrixMethodInfo           ,
#endif
    eulerInitFromMatrix                     ,


-- ** initFromQuaternion #method:initFromQuaternion#

#if defined(ENABLE_OVERLOADING)
    EulerInitFromQuaternionMethodInfo       ,
#endif
    eulerInitFromQuaternion                 ,


-- ** initFromRadians #method:initFromRadians#

#if defined(ENABLE_OVERLOADING)
    EulerInitFromRadiansMethodInfo          ,
#endif
    eulerInitFromRadians                    ,


-- ** initFromVec3 #method:initFromVec3#

#if defined(ENABLE_OVERLOADING)
    EulerInitFromVec3MethodInfo             ,
#endif
    eulerInitFromVec3                       ,


-- ** initWithOrder #method:initWithOrder#

#if defined(ENABLE_OVERLOADING)
    EulerInitWithOrderMethodInfo            ,
#endif
    eulerInitWithOrder                      ,


-- ** reorder #method:reorder#

#if defined(ENABLE_OVERLOADING)
    EulerReorderMethodInfo                  ,
#endif
    eulerReorder                            ,


-- ** toMatrix #method:toMatrix#

#if defined(ENABLE_OVERLOADING)
    EulerToMatrixMethodInfo                 ,
#endif
    eulerToMatrix                           ,


-- ** toQuaternion #method:toQuaternion#

#if defined(ENABLE_OVERLOADING)
    EulerToQuaternionMethodInfo             ,
#endif
    eulerToQuaternion                       ,


-- ** toVec3 #method:toVec3#

#if defined(ENABLE_OVERLOADING)
    EulerToVec3MethodInfo                   ,
#endif
    eulerToVec3                             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Graphene.Enums as Graphene.Enums
import {-# SOURCE #-} qualified GI.Graphene.Structs.Box as Graphene.Box
import {-# SOURCE #-} qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import {-# SOURCE #-} qualified GI.Graphene.Structs.Plane as Graphene.Plane
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point as Graphene.Point
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import {-# SOURCE #-} qualified GI.Graphene.Structs.Quad as Graphene.Quad
import {-# SOURCE #-} qualified GI.Graphene.Structs.Quaternion as Graphene.Quaternion
import {-# SOURCE #-} qualified GI.Graphene.Structs.Ray as Graphene.Ray
import {-# SOURCE #-} qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Graphene.Structs.Size as Graphene.Size
import {-# SOURCE #-} qualified GI.Graphene.Structs.Sphere as Graphene.Sphere
import {-# SOURCE #-} qualified GI.Graphene.Structs.Triangle as Graphene.Triangle
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec2 as Graphene.Vec2
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4

#else
import {-# SOURCE #-} qualified GI.Graphene.Enums as Graphene.Enums
import {-# SOURCE #-} qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import {-# SOURCE #-} qualified GI.Graphene.Structs.Quaternion as Graphene.Quaternion
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3

#endif

-- | Memory-managed wrapper type.
newtype Euler = Euler (SP.ManagedPtr Euler)
    deriving (Eq)

instance SP.ManagedPtrNewtype Euler where
    toManagedPtr (Euler p) = p

foreign import ccall "graphene_euler_get_type" c_graphene_euler_get_type :: 
    IO GType

type instance O.ParentTypes Euler = '[]
instance O.HasParentTypes Euler

instance B.Types.TypedObject Euler where
    glibType = c_graphene_euler_get_type

instance B.Types.GBoxed Euler

-- | Convert t'Euler' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Euler) where
    gvalueGType_ = c_graphene_euler_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Euler)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Euler)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Euler ptr
        else return P.Nothing
        
    

-- | Construct a t'Euler' struct initialized to zero.
newZeroEuler :: MonadIO m => m Euler
newZeroEuler = liftIO $ callocBoxedBytes 20 >>= wrapBoxed Euler

instance tag ~ 'AttrSet => Constructible Euler tag where
    new _ attrs = do
        o <- newZeroEuler
        GI.Attributes.set o attrs
        return o



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Euler
type instance O.AttributeList Euler = EulerAttributeList
type EulerAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method Euler::alloc
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Euler" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_alloc" graphene_euler_alloc :: 
    IO (Ptr Euler)

-- | Allocates a new t'GI.Graphene.Structs.Euler.Euler'.
-- 
-- The contents of the returned structure are undefined.
-- 
-- /Since: 1.2/
eulerAlloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Euler
    -- ^ __Returns:__ the newly allocated t'GI.Graphene.Structs.Euler.Euler'
eulerAlloc  = liftIO $ do
    result <- graphene_euler_alloc
    checkUnexpectedReturnNULL "eulerAlloc" result
    result' <- (wrapBoxed Euler) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Euler::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_equal" graphene_euler_equal :: 
    Ptr Euler ->                            -- a : TInterface (Name {namespace = "Graphene", name = "Euler"})
    Ptr Euler ->                            -- b : TInterface (Name {namespace = "Graphene", name = "Euler"})
    IO CInt

-- | Checks if two t'GI.Graphene.Structs.Euler.Euler' are equal.
-- 
-- /Since: 1.2/
eulerEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@a@/: a t'GI.Graphene.Structs.Euler.Euler'
    -> Euler
    -- ^ /@b@/: a t'GI.Graphene.Structs.Euler.Euler'
    -> m Bool
    -- ^ __Returns:__ @true@ if the two t'GI.Graphene.Structs.Euler.Euler' are equal
eulerEqual a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    result <- graphene_euler_equal a' b'
    let result' = (/= 0) result
    touchManagedPtr a
    touchManagedPtr b
    return result'

#if defined(ENABLE_OVERLOADING)
data EulerEqualMethodInfo
instance (signature ~ (Euler -> m Bool), MonadIO m) => O.OverloadedMethod EulerEqualMethodInfo Euler signature where
    overloadedMethod = eulerEqual

instance O.OverloadedMethodInfo EulerEqualMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerEqual"
        })


#endif

-- method Euler::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_free" graphene_euler_free :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    IO ()

-- | Frees the resources allocated by 'GI.Graphene.Structs.Euler.eulerAlloc'.
-- 
-- /Since: 1.2/
eulerFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: a t'GI.Graphene.Structs.Euler.Euler'
    -> m ()
eulerFree e = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    graphene_euler_free e'
    touchManagedPtr e
    return ()

#if defined(ENABLE_OVERLOADING)
data EulerFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod EulerFreeMethodInfo Euler signature where
    overloadedMethod = eulerFree

instance O.OverloadedMethodInfo EulerFreeMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerFree"
        })


#endif

-- method Euler::get_alpha
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_get_alpha" graphene_euler_get_alpha :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    IO CFloat

-- | Retrieves the first component of the Euler angle vector,
-- depending on the order of rotation.
-- 
-- See also: 'GI.Graphene.Structs.Euler.eulerGetX'
-- 
-- /Since: 1.10/
eulerGetAlpha ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: a t'GI.Graphene.Structs.Euler.Euler'
    -> m Float
    -- ^ __Returns:__ the first component of the Euler angle vector, in radians
eulerGetAlpha e = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    result <- graphene_euler_get_alpha e'
    let result' = realToFrac result
    touchManagedPtr e
    return result'

#if defined(ENABLE_OVERLOADING)
data EulerGetAlphaMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod EulerGetAlphaMethodInfo Euler signature where
    overloadedMethod = eulerGetAlpha

instance O.OverloadedMethodInfo EulerGetAlphaMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerGetAlpha",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerGetAlpha"
        })


#endif

-- method Euler::get_beta
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_get_beta" graphene_euler_get_beta :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    IO CFloat

-- | Retrieves the second component of the Euler angle vector,
-- depending on the order of rotation.
-- 
-- See also: 'GI.Graphene.Structs.Euler.eulerGetY'
-- 
-- /Since: 1.10/
eulerGetBeta ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: a t'GI.Graphene.Structs.Euler.Euler'
    -> m Float
    -- ^ __Returns:__ the second component of the Euler angle vector, in radians
eulerGetBeta e = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    result <- graphene_euler_get_beta e'
    let result' = realToFrac result
    touchManagedPtr e
    return result'

#if defined(ENABLE_OVERLOADING)
data EulerGetBetaMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod EulerGetBetaMethodInfo Euler signature where
    overloadedMethod = eulerGetBeta

instance O.OverloadedMethodInfo EulerGetBetaMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerGetBeta",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerGetBeta"
        })


#endif

-- method Euler::get_gamma
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_get_gamma" graphene_euler_get_gamma :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    IO CFloat

-- | Retrieves the third component of the Euler angle vector,
-- depending on the order of rotation.
-- 
-- See also: 'GI.Graphene.Structs.Euler.eulerGetZ'
-- 
-- /Since: 1.10/
eulerGetGamma ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: a t'GI.Graphene.Structs.Euler.Euler'
    -> m Float
    -- ^ __Returns:__ the third component of the Euler angle vector, in radians
eulerGetGamma e = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    result <- graphene_euler_get_gamma e'
    let result' = realToFrac result
    touchManagedPtr e
    return result'

#if defined(ENABLE_OVERLOADING)
data EulerGetGammaMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod EulerGetGammaMethodInfo Euler signature where
    overloadedMethod = eulerGetGamma

instance O.OverloadedMethodInfo EulerGetGammaMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerGetGamma",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerGetGamma"
        })


#endif

-- method Euler::get_order
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Graphene" , name = "EulerOrder" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_get_order" graphene_euler_get_order :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    IO CInt

-- | Retrieves the order used to apply the rotations described in the
-- t'GI.Graphene.Structs.Euler.Euler' structure, when converting to and from other
-- structures, like t'GI.Graphene.Structs.Quaternion.Quaternion' and t'GI.Graphene.Structs.Matrix.Matrix'.
-- 
-- This function does not return the 'GI.Graphene.Enums.EulerOrderDefault'
-- enumeration value; it will return the effective order of rotation
-- instead.
-- 
-- /Since: 1.2/
eulerGetOrder ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: a t'GI.Graphene.Structs.Euler.Euler'
    -> m Graphene.Enums.EulerOrder
    -- ^ __Returns:__ the order used to apply the rotations
eulerGetOrder e = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    result <- graphene_euler_get_order e'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr e
    return result'

#if defined(ENABLE_OVERLOADING)
data EulerGetOrderMethodInfo
instance (signature ~ (m Graphene.Enums.EulerOrder), MonadIO m) => O.OverloadedMethod EulerGetOrderMethodInfo Euler signature where
    overloadedMethod = eulerGetOrder

instance O.OverloadedMethodInfo EulerGetOrderMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerGetOrder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerGetOrder"
        })


#endif

-- method Euler::get_x
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_get_x" graphene_euler_get_x :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    IO CFloat

-- | Retrieves the rotation angle on the X axis, in degrees.
-- 
-- /Since: 1.2/
eulerGetX ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: a t'GI.Graphene.Structs.Euler.Euler'
    -> m Float
    -- ^ __Returns:__ the rotation angle
eulerGetX e = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    result <- graphene_euler_get_x e'
    let result' = realToFrac result
    touchManagedPtr e
    return result'

#if defined(ENABLE_OVERLOADING)
data EulerGetXMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod EulerGetXMethodInfo Euler signature where
    overloadedMethod = eulerGetX

instance O.OverloadedMethodInfo EulerGetXMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerGetX",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerGetX"
        })


#endif

-- method Euler::get_y
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_get_y" graphene_euler_get_y :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    IO CFloat

-- | Retrieves the rotation angle on the Y axis, in degrees.
-- 
-- /Since: 1.2/
eulerGetY ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: a t'GI.Graphene.Structs.Euler.Euler'
    -> m Float
    -- ^ __Returns:__ the rotation angle
eulerGetY e = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    result <- graphene_euler_get_y e'
    let result' = realToFrac result
    touchManagedPtr e
    return result'

#if defined(ENABLE_OVERLOADING)
data EulerGetYMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod EulerGetYMethodInfo Euler signature where
    overloadedMethod = eulerGetY

instance O.OverloadedMethodInfo EulerGetYMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerGetY",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerGetY"
        })


#endif

-- method Euler::get_z
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_get_z" graphene_euler_get_z :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    IO CFloat

-- | Retrieves the rotation angle on the Z axis, in degrees.
-- 
-- /Since: 1.2/
eulerGetZ ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: a t'GI.Graphene.Structs.Euler.Euler'
    -> m Float
    -- ^ __Returns:__ the rotation angle
eulerGetZ e = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    result <- graphene_euler_get_z e'
    let result' = realToFrac result
    touchManagedPtr e
    return result'

#if defined(ENABLE_OVERLOADING)
data EulerGetZMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod EulerGetZMethodInfo Euler signature where
    overloadedMethod = eulerGetZ

instance O.OverloadedMethodInfo EulerGetZMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerGetZ",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerGetZ"
        })


#endif

-- method Euler::init
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_euler_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rotation angle on the X axis, in degrees"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rotation angle on the Y axis, in degrees"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "z"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rotation angle on the Z axis, in degrees"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Euler" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_init" graphene_euler_init :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    CFloat ->                               -- x : TBasicType TFloat
    CFloat ->                               -- y : TBasicType TFloat
    CFloat ->                               -- z : TBasicType TFloat
    IO (Ptr Euler)

-- | Initializes a t'GI.Graphene.Structs.Euler.Euler' using the given angles.
-- 
-- The order of the rotations is 'GI.Graphene.Enums.EulerOrderDefault'.
-- 
-- /Since: 1.2/
eulerInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: the t'GI.Graphene.Structs.Euler.Euler' to initialize
    -> Float
    -- ^ /@x@/: rotation angle on the X axis, in degrees
    -> Float
    -- ^ /@y@/: rotation angle on the Y axis, in degrees
    -> Float
    -- ^ /@z@/: rotation angle on the Z axis, in degrees
    -> m Euler
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Euler.Euler'
eulerInit e x y z = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    let x' = realToFrac x
    let y' = realToFrac y
    let z' = realToFrac z
    result <- graphene_euler_init e' x' y' z'
    checkUnexpectedReturnNULL "eulerInit" result
    result' <- (newBoxed Euler) result
    touchManagedPtr e
    return result'

#if defined(ENABLE_OVERLOADING)
data EulerInitMethodInfo
instance (signature ~ (Float -> Float -> Float -> m Euler), MonadIO m) => O.OverloadedMethod EulerInitMethodInfo Euler signature where
    overloadedMethod = eulerInit

instance O.OverloadedMethodInfo EulerInitMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerInit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerInit"
        })


#endif

-- method Euler::init_from_euler
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_euler_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Euler" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_init_from_euler" graphene_euler_init_from_euler :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    Ptr Euler ->                            -- src : TInterface (Name {namespace = "Graphene", name = "Euler"})
    IO (Ptr Euler)

-- | Initializes a t'GI.Graphene.Structs.Euler.Euler' using the angles and order of
-- another t'GI.Graphene.Structs.Euler.Euler'.
-- 
-- If the t'GI.Graphene.Structs.Euler.Euler' /@src@/ is 'P.Nothing', this function is equivalent
-- to calling 'GI.Graphene.Structs.Euler.eulerInit' with all angles set to 0.
-- 
-- /Since: 1.2/
eulerInitFromEuler ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: the t'GI.Graphene.Structs.Euler.Euler' to initialize
    -> Maybe (Euler)
    -- ^ /@src@/: a t'GI.Graphene.Structs.Euler.Euler'
    -> m Euler
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Euler.Euler'
eulerInitFromEuler e src = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    maybeSrc <- case src of
        Nothing -> return FP.nullPtr
        Just jSrc -> do
            jSrc' <- unsafeManagedPtrGetPtr jSrc
            return jSrc'
    result <- graphene_euler_init_from_euler e' maybeSrc
    checkUnexpectedReturnNULL "eulerInitFromEuler" result
    result' <- (newBoxed Euler) result
    touchManagedPtr e
    whenJust src touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data EulerInitFromEulerMethodInfo
instance (signature ~ (Maybe (Euler) -> m Euler), MonadIO m) => O.OverloadedMethod EulerInitFromEulerMethodInfo Euler signature where
    overloadedMethod = eulerInitFromEuler

instance O.OverloadedMethodInfo EulerInitFromEulerMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerInitFromEuler",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerInitFromEuler"
        })


#endif

-- method Euler::init_from_matrix
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_euler_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "m"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a rotation matrix" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "order"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "EulerOrder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the order used to apply the rotations"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Euler" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_init_from_matrix" graphene_euler_init_from_matrix :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    Ptr Graphene.Matrix.Matrix ->           -- m : TInterface (Name {namespace = "Graphene", name = "Matrix"})
    CInt ->                                 -- order : TInterface (Name {namespace = "Graphene", name = "EulerOrder"})
    IO (Ptr Euler)

-- | Initializes a t'GI.Graphene.Structs.Euler.Euler' using the given rotation matrix.
-- 
-- If the t'GI.Graphene.Structs.Matrix.Matrix' /@m@/ is 'P.Nothing', the t'GI.Graphene.Structs.Euler.Euler' will
-- be initialized with all angles set to 0.
-- 
-- /Since: 1.2/
eulerInitFromMatrix ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: the t'GI.Graphene.Structs.Euler.Euler' to initialize
    -> Maybe (Graphene.Matrix.Matrix)
    -- ^ /@m@/: a rotation matrix
    -> Graphene.Enums.EulerOrder
    -- ^ /@order@/: the order used to apply the rotations
    -> m Euler
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Euler.Euler'
eulerInitFromMatrix e m order = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    maybeM <- case m of
        Nothing -> return FP.nullPtr
        Just jM -> do
            jM' <- unsafeManagedPtrGetPtr jM
            return jM'
    let order' = (fromIntegral . fromEnum) order
    result <- graphene_euler_init_from_matrix e' maybeM order'
    checkUnexpectedReturnNULL "eulerInitFromMatrix" result
    result' <- (newBoxed Euler) result
    touchManagedPtr e
    whenJust m touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data EulerInitFromMatrixMethodInfo
instance (signature ~ (Maybe (Graphene.Matrix.Matrix) -> Graphene.Enums.EulerOrder -> m Euler), MonadIO m) => O.OverloadedMethod EulerInitFromMatrixMethodInfo Euler signature where
    overloadedMethod = eulerInitFromMatrix

instance O.OverloadedMethodInfo EulerInitFromMatrixMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerInitFromMatrix",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerInitFromMatrix"
        })


#endif

-- method Euler::init_from_quaternion
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "q"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Quaternion" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a normalized #graphene_quaternion_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "order"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "EulerOrder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the order used to apply the rotations"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Euler" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_init_from_quaternion" graphene_euler_init_from_quaternion :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    Ptr Graphene.Quaternion.Quaternion ->   -- q : TInterface (Name {namespace = "Graphene", name = "Quaternion"})
    CInt ->                                 -- order : TInterface (Name {namespace = "Graphene", name = "EulerOrder"})
    IO (Ptr Euler)

-- | Initializes a t'GI.Graphene.Structs.Euler.Euler' using the given normalized quaternion.
-- 
-- If the t'GI.Graphene.Structs.Quaternion.Quaternion' /@q@/ is 'P.Nothing', the t'GI.Graphene.Structs.Euler.Euler' will
-- be initialized with all angles set to 0.
-- 
-- /Since: 1.2/
eulerInitFromQuaternion ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: a t'GI.Graphene.Structs.Euler.Euler'
    -> Maybe (Graphene.Quaternion.Quaternion)
    -- ^ /@q@/: a normalized t'GI.Graphene.Structs.Quaternion.Quaternion'
    -> Graphene.Enums.EulerOrder
    -- ^ /@order@/: the order used to apply the rotations
    -> m Euler
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Euler.Euler'
eulerInitFromQuaternion e q order = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    maybeQ <- case q of
        Nothing -> return FP.nullPtr
        Just jQ -> do
            jQ' <- unsafeManagedPtrGetPtr jQ
            return jQ'
    let order' = (fromIntegral . fromEnum) order
    result <- graphene_euler_init_from_quaternion e' maybeQ order'
    checkUnexpectedReturnNULL "eulerInitFromQuaternion" result
    result' <- (newBoxed Euler) result
    touchManagedPtr e
    whenJust q touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data EulerInitFromQuaternionMethodInfo
instance (signature ~ (Maybe (Graphene.Quaternion.Quaternion) -> Graphene.Enums.EulerOrder -> m Euler), MonadIO m) => O.OverloadedMethod EulerInitFromQuaternionMethodInfo Euler signature where
    overloadedMethod = eulerInitFromQuaternion

instance O.OverloadedMethodInfo EulerInitFromQuaternionMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerInitFromQuaternion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerInitFromQuaternion"
        })


#endif

-- method Euler::init_from_radians
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_euler_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rotation angle on the X axis, in radians"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rotation angle on the Y axis, in radians"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "z"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rotation angle on the Z axis, in radians"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "order"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "EulerOrder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "order of rotations" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Euler" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_init_from_radians" graphene_euler_init_from_radians :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    CFloat ->                               -- x : TBasicType TFloat
    CFloat ->                               -- y : TBasicType TFloat
    CFloat ->                               -- z : TBasicType TFloat
    CInt ->                                 -- order : TInterface (Name {namespace = "Graphene", name = "EulerOrder"})
    IO (Ptr Euler)

-- | Initializes a t'GI.Graphene.Structs.Euler.Euler' using the given angles
-- and order of rotation.
-- 
-- /Since: 1.10/
eulerInitFromRadians ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: the t'GI.Graphene.Structs.Euler.Euler' to initialize
    -> Float
    -- ^ /@x@/: rotation angle on the X axis, in radians
    -> Float
    -- ^ /@y@/: rotation angle on the Y axis, in radians
    -> Float
    -- ^ /@z@/: rotation angle on the Z axis, in radians
    -> Graphene.Enums.EulerOrder
    -- ^ /@order@/: order of rotations
    -> m Euler
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Euler.Euler'
eulerInitFromRadians e x y z order = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    let x' = realToFrac x
    let y' = realToFrac y
    let z' = realToFrac z
    let order' = (fromIntegral . fromEnum) order
    result <- graphene_euler_init_from_radians e' x' y' z' order'
    checkUnexpectedReturnNULL "eulerInitFromRadians" result
    result' <- (newBoxed Euler) result
    touchManagedPtr e
    return result'

#if defined(ENABLE_OVERLOADING)
data EulerInitFromRadiansMethodInfo
instance (signature ~ (Float -> Float -> Float -> Graphene.Enums.EulerOrder -> m Euler), MonadIO m) => O.OverloadedMethod EulerInitFromRadiansMethodInfo Euler signature where
    overloadedMethod = eulerInitFromRadians

instance O.OverloadedMethodInfo EulerInitFromRadiansMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerInitFromRadians",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerInitFromRadians"
        })


#endif

-- method Euler::init_from_vec3
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_euler_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "v"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #graphene_vec3_t containing the rotation\n  angles in degrees"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "order"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "EulerOrder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the order used to apply the rotations"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Euler" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_init_from_vec3" graphene_euler_init_from_vec3 :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    Ptr Graphene.Vec3.Vec3 ->               -- v : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    CInt ->                                 -- order : TInterface (Name {namespace = "Graphene", name = "EulerOrder"})
    IO (Ptr Euler)

-- | Initializes a t'GI.Graphene.Structs.Euler.Euler' using the angles contained in a
-- t'GI.Graphene.Structs.Vec3.Vec3'.
-- 
-- If the t'GI.Graphene.Structs.Vec3.Vec3' /@v@/ is 'P.Nothing', the t'GI.Graphene.Structs.Euler.Euler' will be
-- initialized with all angles set to 0.
-- 
-- /Since: 1.2/
eulerInitFromVec3 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: the t'GI.Graphene.Structs.Euler.Euler' to initialize
    -> Maybe (Graphene.Vec3.Vec3)
    -- ^ /@v@/: a t'GI.Graphene.Structs.Vec3.Vec3' containing the rotation
    --   angles in degrees
    -> Graphene.Enums.EulerOrder
    -- ^ /@order@/: the order used to apply the rotations
    -> m Euler
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Euler.Euler'
eulerInitFromVec3 e v order = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    maybeV <- case v of
        Nothing -> return FP.nullPtr
        Just jV -> do
            jV' <- unsafeManagedPtrGetPtr jV
            return jV'
    let order' = (fromIntegral . fromEnum) order
    result <- graphene_euler_init_from_vec3 e' maybeV order'
    checkUnexpectedReturnNULL "eulerInitFromVec3" result
    result' <- (newBoxed Euler) result
    touchManagedPtr e
    whenJust v touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data EulerInitFromVec3MethodInfo
instance (signature ~ (Maybe (Graphene.Vec3.Vec3) -> Graphene.Enums.EulerOrder -> m Euler), MonadIO m) => O.OverloadedMethod EulerInitFromVec3MethodInfo Euler signature where
    overloadedMethod = eulerInitFromVec3

instance O.OverloadedMethodInfo EulerInitFromVec3MethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerInitFromVec3",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerInitFromVec3"
        })


#endif

-- method Euler::init_with_order
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_euler_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rotation angle on the X axis, in degrees"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rotation angle on the Y axis, in degrees"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "z"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rotation angle on the Z axis, in degrees"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "order"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "EulerOrder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the order used to apply the rotations"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Euler" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_init_with_order" graphene_euler_init_with_order :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    CFloat ->                               -- x : TBasicType TFloat
    CFloat ->                               -- y : TBasicType TFloat
    CFloat ->                               -- z : TBasicType TFloat
    CInt ->                                 -- order : TInterface (Name {namespace = "Graphene", name = "EulerOrder"})
    IO (Ptr Euler)

-- | Initializes a t'GI.Graphene.Structs.Euler.Euler' with the given angles and /@order@/.
-- 
-- /Since: 1.2/
eulerInitWithOrder ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: the t'GI.Graphene.Structs.Euler.Euler' to initialize
    -> Float
    -- ^ /@x@/: rotation angle on the X axis, in degrees
    -> Float
    -- ^ /@y@/: rotation angle on the Y axis, in degrees
    -> Float
    -- ^ /@z@/: rotation angle on the Z axis, in degrees
    -> Graphene.Enums.EulerOrder
    -- ^ /@order@/: the order used to apply the rotations
    -> m Euler
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Euler.Euler'
eulerInitWithOrder e x y z order = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    let x' = realToFrac x
    let y' = realToFrac y
    let z' = realToFrac z
    let order' = (fromIntegral . fromEnum) order
    result <- graphene_euler_init_with_order e' x' y' z' order'
    checkUnexpectedReturnNULL "eulerInitWithOrder" result
    result' <- (newBoxed Euler) result
    touchManagedPtr e
    return result'

#if defined(ENABLE_OVERLOADING)
data EulerInitWithOrderMethodInfo
instance (signature ~ (Float -> Float -> Float -> Graphene.Enums.EulerOrder -> m Euler), MonadIO m) => O.OverloadedMethod EulerInitWithOrderMethodInfo Euler signature where
    overloadedMethod = eulerInitWithOrder

instance O.OverloadedMethodInfo EulerInitWithOrderMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerInitWithOrder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerInitWithOrder"
        })


#endif

-- method Euler::reorder
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "order"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "EulerOrder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new order" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the reordered\n  #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_reorder" graphene_euler_reorder :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    CInt ->                                 -- order : TInterface (Name {namespace = "Graphene", name = "EulerOrder"})
    Ptr Euler ->                            -- res : TInterface (Name {namespace = "Graphene", name = "Euler"})
    IO ()

-- | Reorders a t'GI.Graphene.Structs.Euler.Euler' using /@order@/.
-- 
-- This function is equivalent to creating a t'GI.Graphene.Structs.Quaternion.Quaternion' from the
-- given t'GI.Graphene.Structs.Euler.Euler', and then converting the quaternion into another
-- t'GI.Graphene.Structs.Euler.Euler'.
-- 
-- /Since: 1.2/
eulerReorder ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: a t'GI.Graphene.Structs.Euler.Euler'
    -> Graphene.Enums.EulerOrder
    -- ^ /@order@/: the new order
    -> m (Euler)
eulerReorder e order = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    let order' = (fromIntegral . fromEnum) order
    res <- SP.callocBoxedBytes 20 :: IO (Ptr Euler)
    graphene_euler_reorder e' order' res
    res' <- (wrapBoxed Euler) res
    touchManagedPtr e
    return res'

#if defined(ENABLE_OVERLOADING)
data EulerReorderMethodInfo
instance (signature ~ (Graphene.Enums.EulerOrder -> m (Euler)), MonadIO m) => O.OverloadedMethod EulerReorderMethodInfo Euler signature where
    overloadedMethod = eulerReorder

instance O.OverloadedMethodInfo EulerReorderMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerReorder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerReorder"
        })


#endif

-- method Euler::to_matrix
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Matrix" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a #graphene_matrix_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_to_matrix" graphene_euler_to_matrix :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    Ptr Graphene.Matrix.Matrix ->           -- res : TInterface (Name {namespace = "Graphene", name = "Matrix"})
    IO ()

-- | Converts a t'GI.Graphene.Structs.Euler.Euler' into a transformation matrix expressing
-- the extrinsic composition of rotations described by the Euler angles.
-- 
-- The rotations are applied over the reference frame axes in the order
-- associated with the t'GI.Graphene.Structs.Euler.Euler'; for instance, if the order
-- used to initialize /@e@/ is 'GI.Graphene.Enums.EulerOrderXyz':
-- 
--  * the first rotation moves the body around the X axis with
--    an angle φ
--  * the second rotation moves the body around the Y axis with
--    an angle of ϑ
--  * the third rotation moves the body around the Z axis with
--    an angle of ψ
-- 
-- The rotation sign convention is right-handed, to preserve compatibility
-- between Euler-based, quaternion-based, and angle-axis-based rotations.
-- 
-- /Since: 1.2/
eulerToMatrix ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: a t'GI.Graphene.Structs.Euler.Euler'
    -> m (Graphene.Matrix.Matrix)
eulerToMatrix e = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    res <- SP.callocBoxedBytes 64 :: IO (Ptr Graphene.Matrix.Matrix)
    graphene_euler_to_matrix e' res
    res' <- (wrapBoxed Graphene.Matrix.Matrix) res
    touchManagedPtr e
    return res'

#if defined(ENABLE_OVERLOADING)
data EulerToMatrixMethodInfo
instance (signature ~ (m (Graphene.Matrix.Matrix)), MonadIO m) => O.OverloadedMethod EulerToMatrixMethodInfo Euler signature where
    overloadedMethod = eulerToMatrix

instance O.OverloadedMethodInfo EulerToMatrixMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerToMatrix",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerToMatrix"
        })


#endif

-- method Euler::to_quaternion
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Quaternion" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a #graphene_quaternion_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_to_quaternion" graphene_euler_to_quaternion :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    Ptr Graphene.Quaternion.Quaternion ->   -- res : TInterface (Name {namespace = "Graphene", name = "Quaternion"})
    IO ()

-- | Converts a t'GI.Graphene.Structs.Euler.Euler' into a t'GI.Graphene.Structs.Quaternion.Quaternion'.
-- 
-- /Since: 1.10/
eulerToQuaternion ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: a t'GI.Graphene.Structs.Euler.Euler'
    -> m (Graphene.Quaternion.Quaternion)
eulerToQuaternion e = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    res <- SP.callocBoxedBytes 16 :: IO (Ptr Graphene.Quaternion.Quaternion)
    graphene_euler_to_quaternion e' res
    res' <- (wrapBoxed Graphene.Quaternion.Quaternion) res
    touchManagedPtr e
    return res'

#if defined(ENABLE_OVERLOADING)
data EulerToQuaternionMethodInfo
instance (signature ~ (m (Graphene.Quaternion.Quaternion)), MonadIO m) => O.OverloadedMethod EulerToQuaternionMethodInfo Euler signature where
    overloadedMethod = eulerToQuaternion

instance O.OverloadedMethodInfo EulerToQuaternionMethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerToQuaternion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerToQuaternion"
        })


#endif

-- method Euler::to_vec3
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "e"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Euler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_euler_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a #graphene_vec3_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_euler_to_vec3" graphene_euler_to_vec3 :: 
    Ptr Euler ->                            -- e : TInterface (Name {namespace = "Graphene", name = "Euler"})
    Ptr Graphene.Vec3.Vec3 ->               -- res : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    IO ()

-- | Retrieves the angles of a t'GI.Graphene.Structs.Euler.Euler' and initializes a
-- t'GI.Graphene.Structs.Vec3.Vec3' with them.
-- 
-- /Since: 1.2/
eulerToVec3 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Euler
    -- ^ /@e@/: a t'GI.Graphene.Structs.Euler.Euler'
    -> m (Graphene.Vec3.Vec3)
eulerToVec3 e = liftIO $ do
    e' <- unsafeManagedPtrGetPtr e
    res <- SP.callocBoxedBytes 16 :: IO (Ptr Graphene.Vec3.Vec3)
    graphene_euler_to_vec3 e' res
    res' <- (wrapBoxed Graphene.Vec3.Vec3) res
    touchManagedPtr e
    return res'

#if defined(ENABLE_OVERLOADING)
data EulerToVec3MethodInfo
instance (signature ~ (m (Graphene.Vec3.Vec3)), MonadIO m) => O.OverloadedMethod EulerToVec3MethodInfo Euler signature where
    overloadedMethod = eulerToVec3

instance O.OverloadedMethodInfo EulerToVec3MethodInfo Euler where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Euler.eulerToVec3",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Euler.html#v:eulerToVec3"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEulerMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEulerMethod "equal" o = EulerEqualMethodInfo
    ResolveEulerMethod "free" o = EulerFreeMethodInfo
    ResolveEulerMethod "init" o = EulerInitMethodInfo
    ResolveEulerMethod "initFromEuler" o = EulerInitFromEulerMethodInfo
    ResolveEulerMethod "initFromMatrix" o = EulerInitFromMatrixMethodInfo
    ResolveEulerMethod "initFromQuaternion" o = EulerInitFromQuaternionMethodInfo
    ResolveEulerMethod "initFromRadians" o = EulerInitFromRadiansMethodInfo
    ResolveEulerMethod "initFromVec3" o = EulerInitFromVec3MethodInfo
    ResolveEulerMethod "initWithOrder" o = EulerInitWithOrderMethodInfo
    ResolveEulerMethod "reorder" o = EulerReorderMethodInfo
    ResolveEulerMethod "toMatrix" o = EulerToMatrixMethodInfo
    ResolveEulerMethod "toQuaternion" o = EulerToQuaternionMethodInfo
    ResolveEulerMethod "toVec3" o = EulerToVec3MethodInfo
    ResolveEulerMethod "getAlpha" o = EulerGetAlphaMethodInfo
    ResolveEulerMethod "getBeta" o = EulerGetBetaMethodInfo
    ResolveEulerMethod "getGamma" o = EulerGetGammaMethodInfo
    ResolveEulerMethod "getOrder" o = EulerGetOrderMethodInfo
    ResolveEulerMethod "getX" o = EulerGetXMethodInfo
    ResolveEulerMethod "getY" o = EulerGetYMethodInfo
    ResolveEulerMethod "getZ" o = EulerGetZMethodInfo
    ResolveEulerMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEulerMethod t Euler, O.OverloadedMethod info Euler p) => OL.IsLabel t (Euler -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEulerMethod t Euler, O.OverloadedMethod info Euler p, R.HasField t Euler p) => R.HasField t Euler p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEulerMethod t Euler, O.OverloadedMethodInfo info Euler) => OL.IsLabel t (O.MethodProxy info Euler) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


