

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Enums
    ( 

 -- * Enumerations


-- ** BusType #enum:BusType#

    BusType(..)                             ,


-- ** ConverterResult #enum:ConverterResult#

    ConverterResult(..)                     ,


-- ** CredentialsType #enum:CredentialsType#

    CredentialsType(..)                     ,


-- ** DBusError #enum:DBusError#

    DBusError(..)                           ,
    catchDBusError                          ,
    handleDBusError                         ,


-- ** DBusMessageByteOrder #enum:DBusMessageByteOrder#

    DBusMessageByteOrder(..)                ,


-- ** DBusMessageHeaderField #enum:DBusMessageHeaderField#

    DBusMessageHeaderField(..)              ,


-- ** DBusMessageType #enum:DBusMessageType#

    DBusMessageType(..)                     ,


-- ** DataStreamByteOrder #enum:DataStreamByteOrder#

    DataStreamByteOrder(..)                 ,


-- ** DataStreamNewlineType #enum:DataStreamNewlineType#

    DataStreamNewlineType(..)               ,


-- ** DriveStartStopType #enum:DriveStartStopType#

    DriveStartStopType(..)                  ,


-- ** EmblemOrigin #enum:EmblemOrigin#

    EmblemOrigin(..)                        ,


-- ** FileAttributeStatus #enum:FileAttributeStatus#

    FileAttributeStatus(..)                 ,


-- ** FileAttributeType #enum:FileAttributeType#

    FileAttributeType(..)                   ,


-- ** FileMonitorEvent #enum:FileMonitorEvent#

    FileMonitorEvent(..)                    ,


-- ** FileType #enum:FileType#

    FileType(..)                            ,


-- ** FilesystemPreviewType #enum:FilesystemPreviewType#

    FilesystemPreviewType(..)               ,


-- ** IOErrorEnum #enum:IOErrorEnum#

    IOErrorEnum(..)                         ,
    catchIOErrorEnum                        ,
    handleIOErrorEnum                       ,


-- ** IOModuleScopeFlags #enum:IOModuleScopeFlags#

    IOModuleScopeFlags(..)                  ,


-- ** MemoryMonitorWarningLevel #enum:MemoryMonitorWarningLevel#

    MemoryMonitorWarningLevel(..)           ,


-- ** MountOperationResult #enum:MountOperationResult#

    MountOperationResult(..)                ,


-- ** NetworkConnectivity #enum:NetworkConnectivity#

    NetworkConnectivity(..)                 ,


-- ** NotificationPriority #enum:NotificationPriority#

    NotificationPriority(..)                ,


-- ** PasswordSave #enum:PasswordSave#

    PasswordSave(..)                        ,


-- ** PollableReturn #enum:PollableReturn#

    PollableReturn(..)                      ,


-- ** ResolverError #enum:ResolverError#

    ResolverError(..)                       ,
    catchResolverError                      ,
    handleResolverError                     ,


-- ** ResolverRecordType #enum:ResolverRecordType#

    ResolverRecordType(..)                  ,


-- ** ResourceError #enum:ResourceError#

    ResourceError(..)                       ,
    catchResourceError                      ,
    handleResourceError                     ,


-- ** SocketClientEvent #enum:SocketClientEvent#

    SocketClientEvent(..)                   ,


-- ** SocketFamily #enum:SocketFamily#

    SocketFamily(..)                        ,


-- ** SocketListenerEvent #enum:SocketListenerEvent#

    SocketListenerEvent(..)                 ,


-- ** SocketProtocol #enum:SocketProtocol#

    SocketProtocol(..)                      ,


-- ** SocketType #enum:SocketType#

    SocketType(..)                          ,


-- ** TlsAuthenticationMode #enum:TlsAuthenticationMode#

    TlsAuthenticationMode(..)               ,


-- ** TlsCertificateRequestFlags #enum:TlsCertificateRequestFlags#

    TlsCertificateRequestFlags(..)          ,


-- ** TlsChannelBindingError #enum:TlsChannelBindingError#

    TlsChannelBindingError(..)              ,
    catchTlsChannelBindingError             ,
    handleTlsChannelBindingError            ,


-- ** TlsChannelBindingType #enum:TlsChannelBindingType#

    TlsChannelBindingType(..)               ,


-- ** TlsDatabaseLookupFlags #enum:TlsDatabaseLookupFlags#

    TlsDatabaseLookupFlags(..)              ,


-- ** TlsError #enum:TlsError#

    TlsError(..)                            ,
    catchTlsError                           ,
    handleTlsError                          ,


-- ** TlsInteractionResult #enum:TlsInteractionResult#

    TlsInteractionResult(..)                ,


-- ** TlsProtocolVersion #enum:TlsProtocolVersion#

    TlsProtocolVersion(..)                  ,


-- ** TlsRehandshakeMode #enum:TlsRehandshakeMode#

    TlsRehandshakeMode(..)                  ,


-- ** UnixSocketAddressType #enum:UnixSocketAddressType#

    UnixSocketAddressType(..)               ,


-- ** ZlibCompressorFormat #enum:ZlibCompressorFormat#

    ZlibCompressorFormat(..)                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Enum ZlibCompressorFormat
-- | Used to select the type of data format to use for t'GI.Gio.Objects.ZlibDecompressor.ZlibDecompressor'
-- and t'GI.Gio.Objects.ZlibCompressor.ZlibCompressor'.
-- 
-- /Since: 2.24/
data ZlibCompressorFormat = 
      ZlibCompressorFormatZlib
    -- ^ deflate compression with zlib header
    | ZlibCompressorFormatGzip
    -- ^ gzip file format
    | ZlibCompressorFormatRaw
    -- ^ deflate compression with no header
    | AnotherZlibCompressorFormat Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ZlibCompressorFormat where
    fromEnum ZlibCompressorFormatZlib = 0
    fromEnum ZlibCompressorFormatGzip = 1
    fromEnum ZlibCompressorFormatRaw = 2
    fromEnum (AnotherZlibCompressorFormat k) = k

    toEnum 0 = ZlibCompressorFormatZlib
    toEnum 1 = ZlibCompressorFormatGzip
    toEnum 2 = ZlibCompressorFormatRaw
    toEnum k = AnotherZlibCompressorFormat k

instance P.Ord ZlibCompressorFormat where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ZlibCompressorFormat = '[]
instance O.HasParentTypes ZlibCompressorFormat

foreign import ccall "g_zlib_compressor_format_get_type" c_g_zlib_compressor_format_get_type :: 
    IO GType

instance B.Types.TypedObject ZlibCompressorFormat where
    glibType = c_g_zlib_compressor_format_get_type

instance B.Types.BoxedEnum ZlibCompressorFormat

-- Enum UnixSocketAddressType
-- | The type of name used by a t'GI.Gio.Objects.UnixSocketAddress.UnixSocketAddress'.
-- 'GI.Gio.Enums.UnixSocketAddressTypePath' indicates a traditional unix domain
-- socket bound to a filesystem path. 'GI.Gio.Enums.UnixSocketAddressTypeAnonymous'
-- indicates a socket not bound to any name (eg, a client-side socket,
-- or a socket created with @/socketpair()/@).
-- 
-- For abstract sockets, there are two incompatible ways of naming
-- them; the man pages suggest using the entire @struct sockaddr_un@
-- as the name, padding the unused parts of the @/sun_path/@ field with
-- zeroes; this corresponds to 'GI.Gio.Enums.UnixSocketAddressTypeAbstractPadded'.
-- However, many programs instead just use a portion of @/sun_path/@, and
-- pass an appropriate smaller length to @/bind()/@ or @/connect()/@. This is
-- 'GI.Gio.Enums.UnixSocketAddressTypeAbstract'.
-- 
-- /Since: 2.26/
data UnixSocketAddressType = 
      UnixSocketAddressTypeInvalid
    -- ^ invalid
    | UnixSocketAddressTypeAnonymous
    -- ^ anonymous
    | UnixSocketAddressTypePath
    -- ^ a filesystem path
    | UnixSocketAddressTypeAbstract
    -- ^ an abstract name
    | UnixSocketAddressTypeAbstractPadded
    -- ^ an abstract name, 0-padded
    --   to the full length of a unix socket name
    | AnotherUnixSocketAddressType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum UnixSocketAddressType where
    fromEnum UnixSocketAddressTypeInvalid = 0
    fromEnum UnixSocketAddressTypeAnonymous = 1
    fromEnum UnixSocketAddressTypePath = 2
    fromEnum UnixSocketAddressTypeAbstract = 3
    fromEnum UnixSocketAddressTypeAbstractPadded = 4
    fromEnum (AnotherUnixSocketAddressType k) = k

    toEnum 0 = UnixSocketAddressTypeInvalid
    toEnum 1 = UnixSocketAddressTypeAnonymous
    toEnum 2 = UnixSocketAddressTypePath
    toEnum 3 = UnixSocketAddressTypeAbstract
    toEnum 4 = UnixSocketAddressTypeAbstractPadded
    toEnum k = AnotherUnixSocketAddressType k

instance P.Ord UnixSocketAddressType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes UnixSocketAddressType = '[]
instance O.HasParentTypes UnixSocketAddressType

foreign import ccall "g_unix_socket_address_type_get_type" c_g_unix_socket_address_type_get_type :: 
    IO GType

instance B.Types.TypedObject UnixSocketAddressType where
    glibType = c_g_unix_socket_address_type_get_type

instance B.Types.BoxedEnum UnixSocketAddressType

-- Enum TlsRehandshakeMode
{-# DEPRECATED TlsRehandshakeMode ["(Since version 2.60.)","Changing the rehandshake mode is no longer","  required for compatibility. Also, rehandshaking has been removed","  from the TLS protocol in TLS 1.3."] #-}
-- | When to allow rehandshaking. See
-- 'GI.Gio.Objects.TlsConnection.tlsConnectionSetRehandshakeMode'.
-- 
-- /Since: 2.28/
data TlsRehandshakeMode = 
      TlsRehandshakeModeNever
    -- ^ Never allow rehandshaking
    | TlsRehandshakeModeSafely
    -- ^ Allow safe rehandshaking only
    | TlsRehandshakeModeUnsafely
    -- ^ Allow unsafe rehandshaking
    | AnotherTlsRehandshakeMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TlsRehandshakeMode where
    fromEnum TlsRehandshakeModeNever = 0
    fromEnum TlsRehandshakeModeSafely = 1
    fromEnum TlsRehandshakeModeUnsafely = 2
    fromEnum (AnotherTlsRehandshakeMode k) = k

    toEnum 0 = TlsRehandshakeModeNever
    toEnum 1 = TlsRehandshakeModeSafely
    toEnum 2 = TlsRehandshakeModeUnsafely
    toEnum k = AnotherTlsRehandshakeMode k

instance P.Ord TlsRehandshakeMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TlsRehandshakeMode = '[]
instance O.HasParentTypes TlsRehandshakeMode

foreign import ccall "g_tls_rehandshake_mode_get_type" c_g_tls_rehandshake_mode_get_type :: 
    IO GType

instance B.Types.TypedObject TlsRehandshakeMode where
    glibType = c_g_tls_rehandshake_mode_get_type

instance B.Types.BoxedEnum TlsRehandshakeMode

-- Enum TlsProtocolVersion
-- | The TLS or DTLS protocol version used by a t'GI.Gio.Objects.TlsConnection.TlsConnection' or
-- t'GI.Gio.Interfaces.DtlsConnection.DtlsConnection'. The integer values of these versions are sequential
-- to ensure newer known protocol versions compare greater than older
-- known versions. Any known DTLS protocol version will compare greater
-- than any SSL or TLS protocol version. The protocol version may be
-- 'GI.Gio.Enums.TlsProtocolVersionUnknown' if the TLS backend supports a newer
-- protocol version that GLib does not yet know about. This means that
-- it\'s possible for an unknown DTLS protocol version to compare less
-- than the TLS protocol versions.
-- 
-- /Since: 2.70/
data TlsProtocolVersion = 
      TlsProtocolVersionUnknown
    -- ^ No protocol version or unknown protocol version
    | TlsProtocolVersionSsl30
    -- ^ SSL 3.0, which is insecure and should not be used
    | TlsProtocolVersionTls10
    -- ^ TLS 1.0, which is insecure and should not be used
    | TlsProtocolVersionTls11
    -- ^ TLS 1.1, which is insecure and should not be used
    | TlsProtocolVersionTls12
    -- ^ TLS 1.2, defined by <https://datatracker.ietf.org/doc/html/rfc5246 RFC 5246>
    | TlsProtocolVersionTls13
    -- ^ TLS 1.3, defined by <https://datatracker.ietf.org/doc/html/rfc8446 RFC 8446>
    | TlsProtocolVersionDtls10
    -- ^ DTLS 1.0, which is insecure and should not be used
    | TlsProtocolVersionDtls12
    -- ^ DTLS 1.2, defined by <https://datatracker.ietf.org/doc/html/rfc6347 RFC 6347>
    | AnotherTlsProtocolVersion Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TlsProtocolVersion where
    fromEnum TlsProtocolVersionUnknown = 0
    fromEnum TlsProtocolVersionSsl30 = 1
    fromEnum TlsProtocolVersionTls10 = 2
    fromEnum TlsProtocolVersionTls11 = 3
    fromEnum TlsProtocolVersionTls12 = 4
    fromEnum TlsProtocolVersionTls13 = 5
    fromEnum TlsProtocolVersionDtls10 = 201
    fromEnum TlsProtocolVersionDtls12 = 202
    fromEnum (AnotherTlsProtocolVersion k) = k

    toEnum 0 = TlsProtocolVersionUnknown
    toEnum 1 = TlsProtocolVersionSsl30
    toEnum 2 = TlsProtocolVersionTls10
    toEnum 3 = TlsProtocolVersionTls11
    toEnum 4 = TlsProtocolVersionTls12
    toEnum 5 = TlsProtocolVersionTls13
    toEnum 201 = TlsProtocolVersionDtls10
    toEnum 202 = TlsProtocolVersionDtls12
    toEnum k = AnotherTlsProtocolVersion k

instance P.Ord TlsProtocolVersion where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TlsProtocolVersion = '[]
instance O.HasParentTypes TlsProtocolVersion

foreign import ccall "g_tls_protocol_version_get_type" c_g_tls_protocol_version_get_type :: 
    IO GType

instance B.Types.TypedObject TlsProtocolVersion where
    glibType = c_g_tls_protocol_version_get_type

instance B.Types.BoxedEnum TlsProtocolVersion

-- Enum TlsInteractionResult
-- | t'GI.Gio.Enums.TlsInteractionResult' is returned by various functions in t'GI.Gio.Objects.TlsInteraction.TlsInteraction'
-- when finishing an interaction request.
-- 
-- /Since: 2.30/
data TlsInteractionResult = 
      TlsInteractionResultUnhandled
    -- ^ The interaction was unhandled (i.e. not
    --     implemented).
    | TlsInteractionResultHandled
    -- ^ The interaction completed, and resulting data
    --     is available.
    | TlsInteractionResultFailed
    -- ^ The interaction has failed, or was cancelled.
    --     and the operation should be aborted.
    | AnotherTlsInteractionResult Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TlsInteractionResult where
    fromEnum TlsInteractionResultUnhandled = 0
    fromEnum TlsInteractionResultHandled = 1
    fromEnum TlsInteractionResultFailed = 2
    fromEnum (AnotherTlsInteractionResult k) = k

    toEnum 0 = TlsInteractionResultUnhandled
    toEnum 1 = TlsInteractionResultHandled
    toEnum 2 = TlsInteractionResultFailed
    toEnum k = AnotherTlsInteractionResult k

instance P.Ord TlsInteractionResult where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TlsInteractionResult = '[]
instance O.HasParentTypes TlsInteractionResult

foreign import ccall "g_tls_interaction_result_get_type" c_g_tls_interaction_result_get_type :: 
    IO GType

instance B.Types.TypedObject TlsInteractionResult where
    glibType = c_g_tls_interaction_result_get_type

instance B.Types.BoxedEnum TlsInteractionResult

-- Enum TlsError
-- | An error code used with @/G_TLS_ERROR/@ in a t'GError' returned from a
-- TLS-related routine.
-- 
-- /Since: 2.28/
data TlsError = 
      TlsErrorUnavailable
    -- ^ No TLS provider is available
    | TlsErrorMisc
    -- ^ Miscellaneous TLS error
    | TlsErrorBadCertificate
    -- ^ The certificate presented could not
    --   be parsed or failed validation.
    | TlsErrorNotTls
    -- ^ The TLS handshake failed because the
    --   peer does not seem to be a TLS server.
    | TlsErrorHandshake
    -- ^ The TLS handshake failed because the
    --   peer\'s certificate was not acceptable.
    | TlsErrorCertificateRequired
    -- ^ The TLS handshake failed because
    --   the server requested a client-side certificate, but none was
    --   provided. See 'GI.Gio.Objects.TlsConnection.tlsConnectionSetCertificate'.
    | TlsErrorEof
    -- ^ The TLS connection was closed without proper
    --   notice, which may indicate an attack. See
    --   'GI.Gio.Objects.TlsConnection.tlsConnectionSetRequireCloseNotify'.
    | TlsErrorInappropriateFallback
    -- ^ The TLS handshake failed
    --   because the client sent the fallback SCSV, indicating a protocol
    --   downgrade attack. Since: 2.60
    | TlsErrorBadCertificatePassword
    -- ^ The certificate failed
    --   to load because a password was incorrect. Since: 2.72
    | AnotherTlsError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TlsError where
    fromEnum TlsErrorUnavailable = 0
    fromEnum TlsErrorMisc = 1
    fromEnum TlsErrorBadCertificate = 2
    fromEnum TlsErrorNotTls = 3
    fromEnum TlsErrorHandshake = 4
    fromEnum TlsErrorCertificateRequired = 5
    fromEnum TlsErrorEof = 6
    fromEnum TlsErrorInappropriateFallback = 7
    fromEnum TlsErrorBadCertificatePassword = 8
    fromEnum (AnotherTlsError k) = k

    toEnum 0 = TlsErrorUnavailable
    toEnum 1 = TlsErrorMisc
    toEnum 2 = TlsErrorBadCertificate
    toEnum 3 = TlsErrorNotTls
    toEnum 4 = TlsErrorHandshake
    toEnum 5 = TlsErrorCertificateRequired
    toEnum 6 = TlsErrorEof
    toEnum 7 = TlsErrorInappropriateFallback
    toEnum 8 = TlsErrorBadCertificatePassword
    toEnum k = AnotherTlsError k

instance P.Ord TlsError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass TlsError where
    gerrorClassDomain _ = "g-tls-error-quark"

-- | Catch exceptions of type `TlsError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchTlsError ::
    IO a ->
    (TlsError -> GErrorMessage -> IO a) ->
    IO a
catchTlsError = catchGErrorJustDomain

-- | Handle exceptions of type `TlsError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleTlsError ::
    (TlsError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleTlsError = handleGErrorJustDomain

type instance O.ParentTypes TlsError = '[]
instance O.HasParentTypes TlsError

foreign import ccall "g_tls_error_get_type" c_g_tls_error_get_type :: 
    IO GType

instance B.Types.TypedObject TlsError where
    glibType = c_g_tls_error_get_type

instance B.Types.BoxedEnum TlsError

-- Enum TlsDatabaseLookupFlags
-- | Flags for 'GI.Gio.Objects.TlsDatabase.tlsDatabaseLookupCertificateForHandle',
-- 'GI.Gio.Objects.TlsDatabase.tlsDatabaseLookupCertificateIssuer',
-- and 'GI.Gio.Objects.TlsDatabase.tlsDatabaseLookupCertificatesIssuedBy'.
-- 
-- /Since: 2.30/
data TlsDatabaseLookupFlags = 
      TlsDatabaseLookupFlagsNone
    -- ^ No lookup flags
    | TlsDatabaseLookupFlagsKeypair
    -- ^ Restrict lookup to certificates that have
    --     a private key.
    | AnotherTlsDatabaseLookupFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TlsDatabaseLookupFlags where
    fromEnum TlsDatabaseLookupFlagsNone = 0
    fromEnum TlsDatabaseLookupFlagsKeypair = 1
    fromEnum (AnotherTlsDatabaseLookupFlags k) = k

    toEnum 0 = TlsDatabaseLookupFlagsNone
    toEnum 1 = TlsDatabaseLookupFlagsKeypair
    toEnum k = AnotherTlsDatabaseLookupFlags k

instance P.Ord TlsDatabaseLookupFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TlsDatabaseLookupFlags = '[]
instance O.HasParentTypes TlsDatabaseLookupFlags

foreign import ccall "g_tls_database_lookup_flags_get_type" c_g_tls_database_lookup_flags_get_type :: 
    IO GType

instance B.Types.TypedObject TlsDatabaseLookupFlags where
    glibType = c_g_tls_database_lookup_flags_get_type

instance B.Types.BoxedEnum TlsDatabaseLookupFlags

-- Enum TlsChannelBindingType
-- | The type of TLS channel binding data to retrieve from t'GI.Gio.Objects.TlsConnection.TlsConnection'
-- or t'GI.Gio.Interfaces.DtlsConnection.DtlsConnection', as documented by RFC 5929 or RFC 9266. The
-- <https://tools.ietf.org/html/rfc5929#section-5 `tls-unique-for-telnet`>
-- binding type is not currently implemented.
-- 
-- /Since: 2.66/
data TlsChannelBindingType = 
      TlsChannelBindingTypeUnique
    -- ^ <https://tools.ietf.org/html/rfc5929#section-3 `tls-unique`> binding
    --    type
    | TlsChannelBindingTypeServerEndPoint
    -- ^ <https://tools.ietf.org/html/rfc5929#section-4 `tls-server-end-point`>
    --    binding type
    | TlsChannelBindingTypeExporter
    -- ^ <https://www.rfc-editor.org/rfc/rfc9266.html `tls-exporter`> binding
    --    type. Since: 2.74
    | AnotherTlsChannelBindingType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TlsChannelBindingType where
    fromEnum TlsChannelBindingTypeUnique = 0
    fromEnum TlsChannelBindingTypeServerEndPoint = 1
    fromEnum TlsChannelBindingTypeExporter = 2
    fromEnum (AnotherTlsChannelBindingType k) = k

    toEnum 0 = TlsChannelBindingTypeUnique
    toEnum 1 = TlsChannelBindingTypeServerEndPoint
    toEnum 2 = TlsChannelBindingTypeExporter
    toEnum k = AnotherTlsChannelBindingType k

instance P.Ord TlsChannelBindingType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TlsChannelBindingType = '[]
instance O.HasParentTypes TlsChannelBindingType

foreign import ccall "g_tls_channel_binding_type_get_type" c_g_tls_channel_binding_type_get_type :: 
    IO GType

instance B.Types.TypedObject TlsChannelBindingType where
    glibType = c_g_tls_channel_binding_type_get_type

instance B.Types.BoxedEnum TlsChannelBindingType

-- Enum TlsChannelBindingError
-- | An error code used with @/G_TLS_CHANNEL_BINDING_ERROR/@ in a t'GError' to
-- indicate a TLS channel binding retrieval error.
-- 
-- /Since: 2.66/
data TlsChannelBindingError = 
      TlsChannelBindingErrorNotImplemented
    -- ^ Either entire binding
    --    retrieval facility or specific binding type is not implemented in the
    --    TLS backend.
    | TlsChannelBindingErrorInvalidState
    -- ^ The handshake is not yet
    --    complete on the connection which is a strong requirement for any existing
    --    binding type.
    | TlsChannelBindingErrorNotAvailable
    -- ^ Handshake is complete but
    --    binding data is not available. That normally indicates the TLS
    --    implementation failed to provide the binding data. For example, some
    --    implementations do not provide a peer certificate for resumed connections.
    | TlsChannelBindingErrorNotSupported
    -- ^ Binding type is not supported
    --    on the current connection. This error could be triggered when requesting
    --    @tls-server-end-point@ binding data for a certificate which has no hash
    --    function or uses multiple hash functions.
    | TlsChannelBindingErrorGeneralError
    -- ^ Any other backend error
    --    preventing binding data retrieval.
    | AnotherTlsChannelBindingError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TlsChannelBindingError where
    fromEnum TlsChannelBindingErrorNotImplemented = 0
    fromEnum TlsChannelBindingErrorInvalidState = 1
    fromEnum TlsChannelBindingErrorNotAvailable = 2
    fromEnum TlsChannelBindingErrorNotSupported = 3
    fromEnum TlsChannelBindingErrorGeneralError = 4
    fromEnum (AnotherTlsChannelBindingError k) = k

    toEnum 0 = TlsChannelBindingErrorNotImplemented
    toEnum 1 = TlsChannelBindingErrorInvalidState
    toEnum 2 = TlsChannelBindingErrorNotAvailable
    toEnum 3 = TlsChannelBindingErrorNotSupported
    toEnum 4 = TlsChannelBindingErrorGeneralError
    toEnum k = AnotherTlsChannelBindingError k

instance P.Ord TlsChannelBindingError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass TlsChannelBindingError where
    gerrorClassDomain _ = "g-tls-channel-binding-error-quark"

-- | Catch exceptions of type `TlsChannelBindingError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchTlsChannelBindingError ::
    IO a ->
    (TlsChannelBindingError -> GErrorMessage -> IO a) ->
    IO a
catchTlsChannelBindingError = catchGErrorJustDomain

-- | Handle exceptions of type `TlsChannelBindingError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleTlsChannelBindingError ::
    (TlsChannelBindingError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleTlsChannelBindingError = handleGErrorJustDomain

type instance O.ParentTypes TlsChannelBindingError = '[]
instance O.HasParentTypes TlsChannelBindingError

foreign import ccall "g_tls_channel_binding_error_get_type" c_g_tls_channel_binding_error_get_type :: 
    IO GType

instance B.Types.TypedObject TlsChannelBindingError where
    glibType = c_g_tls_channel_binding_error_get_type

instance B.Types.BoxedEnum TlsChannelBindingError

-- Enum TlsCertificateRequestFlags
-- | Flags for 'GI.Gio.Objects.TlsInteraction.tlsInteractionRequestCertificate',
-- 'GI.Gio.Objects.TlsInteraction.tlsInteractionRequestCertificateAsync', and
-- 'GI.Gio.Objects.TlsInteraction.tlsInteractionInvokeRequestCertificate'.
-- 
-- /Since: 2.40/
data TlsCertificateRequestFlags = 
      TlsCertificateRequestFlagsNone
    -- ^ No flags
    | AnotherTlsCertificateRequestFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TlsCertificateRequestFlags where
    fromEnum TlsCertificateRequestFlagsNone = 0
    fromEnum (AnotherTlsCertificateRequestFlags k) = k

    toEnum 0 = TlsCertificateRequestFlagsNone
    toEnum k = AnotherTlsCertificateRequestFlags k

instance P.Ord TlsCertificateRequestFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TlsCertificateRequestFlags = '[]
instance O.HasParentTypes TlsCertificateRequestFlags

foreign import ccall "g_tls_certificate_request_flags_get_type" c_g_tls_certificate_request_flags_get_type :: 
    IO GType

instance B.Types.TypedObject TlsCertificateRequestFlags where
    glibType = c_g_tls_certificate_request_flags_get_type

instance B.Types.BoxedEnum TlsCertificateRequestFlags

-- Enum TlsAuthenticationMode
-- | The client authentication mode for a t'GI.Gio.Interfaces.TlsServerConnection.TlsServerConnection'.
-- 
-- /Since: 2.28/
data TlsAuthenticationMode = 
      TlsAuthenticationModeNone
    -- ^ client authentication not required
    | TlsAuthenticationModeRequested
    -- ^ client authentication is requested
    | TlsAuthenticationModeRequired
    -- ^ client authentication is required
    | AnotherTlsAuthenticationMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TlsAuthenticationMode where
    fromEnum TlsAuthenticationModeNone = 0
    fromEnum TlsAuthenticationModeRequested = 1
    fromEnum TlsAuthenticationModeRequired = 2
    fromEnum (AnotherTlsAuthenticationMode k) = k

    toEnum 0 = TlsAuthenticationModeNone
    toEnum 1 = TlsAuthenticationModeRequested
    toEnum 2 = TlsAuthenticationModeRequired
    toEnum k = AnotherTlsAuthenticationMode k

instance P.Ord TlsAuthenticationMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TlsAuthenticationMode = '[]
instance O.HasParentTypes TlsAuthenticationMode

foreign import ccall "g_tls_authentication_mode_get_type" c_g_tls_authentication_mode_get_type :: 
    IO GType

instance B.Types.TypedObject TlsAuthenticationMode where
    glibType = c_g_tls_authentication_mode_get_type

instance B.Types.BoxedEnum TlsAuthenticationMode

-- Enum SocketType
-- | Flags used when creating a t'GI.Gio.Objects.Socket.Socket'. Some protocols may not implement
-- all the socket types.
-- 
-- /Since: 2.22/
data SocketType = 
      SocketTypeInvalid
    -- ^ Type unknown or wrong
    | SocketTypeStream
    -- ^ Reliable connection-based byte streams (e.g. TCP).
    | SocketTypeDatagram
    -- ^ Connectionless, unreliable datagram passing.
    --     (e.g. UDP)
    | SocketTypeSeqpacket
    -- ^ Reliable connection-based passing of datagrams
    --     of fixed maximum length (e.g. SCTP).
    | AnotherSocketType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SocketType where
    fromEnum SocketTypeInvalid = 0
    fromEnum SocketTypeStream = 1
    fromEnum SocketTypeDatagram = 2
    fromEnum SocketTypeSeqpacket = 3
    fromEnum (AnotherSocketType k) = k

    toEnum 0 = SocketTypeInvalid
    toEnum 1 = SocketTypeStream
    toEnum 2 = SocketTypeDatagram
    toEnum 3 = SocketTypeSeqpacket
    toEnum k = AnotherSocketType k

instance P.Ord SocketType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SocketType = '[]
instance O.HasParentTypes SocketType

foreign import ccall "g_socket_type_get_type" c_g_socket_type_get_type :: 
    IO GType

instance B.Types.TypedObject SocketType where
    glibType = c_g_socket_type_get_type

instance B.Types.BoxedEnum SocketType

-- Enum SocketProtocol
-- | A protocol identifier is specified when creating a t'GI.Gio.Objects.Socket.Socket', which is a
-- family\/type specific identifier, where 0 means the default protocol for
-- the particular family\/type.
-- 
-- This enum contains a set of commonly available and used protocols. You
-- can also pass any other identifiers handled by the platform in order to
-- use protocols not listed here.
-- 
-- /Since: 2.22/
data SocketProtocol = 
      SocketProtocolUnknown
    -- ^ The protocol type is unknown
    | SocketProtocolDefault
    -- ^ The default protocol for the family\/type
    | SocketProtocolTcp
    -- ^ TCP over IP
    | SocketProtocolUdp
    -- ^ UDP over IP
    | SocketProtocolSctp
    -- ^ SCTP over IP
    | AnotherSocketProtocol Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SocketProtocol where
    fromEnum SocketProtocolUnknown = -1
    fromEnum SocketProtocolDefault = 0
    fromEnum SocketProtocolTcp = 6
    fromEnum SocketProtocolUdp = 17
    fromEnum SocketProtocolSctp = 132
    fromEnum (AnotherSocketProtocol k) = k

    toEnum -1 = SocketProtocolUnknown
    toEnum 0 = SocketProtocolDefault
    toEnum 6 = SocketProtocolTcp
    toEnum 17 = SocketProtocolUdp
    toEnum 132 = SocketProtocolSctp
    toEnum k = AnotherSocketProtocol k

instance P.Ord SocketProtocol where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SocketProtocol = '[]
instance O.HasParentTypes SocketProtocol

foreign import ccall "g_socket_protocol_get_type" c_g_socket_protocol_get_type :: 
    IO GType

instance B.Types.TypedObject SocketProtocol where
    glibType = c_g_socket_protocol_get_type

instance B.Types.BoxedEnum SocketProtocol

-- Enum SocketListenerEvent
-- | Describes an event occurring on a t'GI.Gio.Objects.SocketListener.SocketListener'. See the
-- [SocketListener::event]("GI.Gio.Objects.SocketListener#g:signal:event") signal for more details.
-- 
-- Additional values may be added to this type in the future.
-- 
-- /Since: 2.46/
data SocketListenerEvent = 
      SocketListenerEventBinding
    -- ^ The listener is about to bind a socket.
    | SocketListenerEventBound
    -- ^ The listener has bound a socket.
    | SocketListenerEventListening
    -- ^ The listener is about to start
    --    listening on this socket.
    | SocketListenerEventListened
    -- ^ The listener is now listening on
    --   this socket.
    | AnotherSocketListenerEvent Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SocketListenerEvent where
    fromEnum SocketListenerEventBinding = 0
    fromEnum SocketListenerEventBound = 1
    fromEnum SocketListenerEventListening = 2
    fromEnum SocketListenerEventListened = 3
    fromEnum (AnotherSocketListenerEvent k) = k

    toEnum 0 = SocketListenerEventBinding
    toEnum 1 = SocketListenerEventBound
    toEnum 2 = SocketListenerEventListening
    toEnum 3 = SocketListenerEventListened
    toEnum k = AnotherSocketListenerEvent k

instance P.Ord SocketListenerEvent where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SocketListenerEvent = '[]
instance O.HasParentTypes SocketListenerEvent

foreign import ccall "g_socket_listener_event_get_type" c_g_socket_listener_event_get_type :: 
    IO GType

instance B.Types.TypedObject SocketListenerEvent where
    glibType = c_g_socket_listener_event_get_type

instance B.Types.BoxedEnum SocketListenerEvent

-- Enum SocketFamily
-- | The protocol family of a t'GI.Gio.Objects.SocketAddress.SocketAddress'. (These values are
-- identical to the system defines @/AF_INET/@, @/AF_INET6/@ and @/AF_UNIX/@,
-- if available.)
-- 
-- /Since: 2.22/
data SocketFamily = 
      SocketFamilyInvalid
    -- ^ no address family
    | SocketFamilyUnix
    -- ^ the UNIX domain family
    | SocketFamilyIpv4
    -- ^ the IPv4 family
    | SocketFamilyIpv6
    -- ^ the IPv6 family
    | AnotherSocketFamily Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SocketFamily where
    fromEnum SocketFamilyInvalid = 0
    fromEnum SocketFamilyUnix = 1
    fromEnum SocketFamilyIpv4 = 2
    fromEnum SocketFamilyIpv6 = 10
    fromEnum (AnotherSocketFamily k) = k

    toEnum 0 = SocketFamilyInvalid
    toEnum 1 = SocketFamilyUnix
    toEnum 2 = SocketFamilyIpv4
    toEnum 10 = SocketFamilyIpv6
    toEnum k = AnotherSocketFamily k

instance P.Ord SocketFamily where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SocketFamily = '[]
instance O.HasParentTypes SocketFamily

foreign import ccall "g_socket_family_get_type" c_g_socket_family_get_type :: 
    IO GType

instance B.Types.TypedObject SocketFamily where
    glibType = c_g_socket_family_get_type

instance B.Types.BoxedEnum SocketFamily

-- Enum SocketClientEvent
-- | Describes an event occurring on a t'GI.Gio.Objects.SocketClient.SocketClient'. See the
-- [SocketClient::event]("GI.Gio.Objects.SocketClient#g:signal:event") signal for more details.
-- 
-- Additional values may be added to this type in the future.
-- 
-- /Since: 2.32/
data SocketClientEvent = 
      SocketClientEventResolving
    -- ^ The client is doing a DNS lookup.
    | SocketClientEventResolved
    -- ^ The client has completed a DNS lookup.
    | SocketClientEventConnecting
    -- ^ The client is connecting to a remote
    --   host (either a proxy or the destination server).
    | SocketClientEventConnected
    -- ^ The client has connected to a remote
    --   host.
    | SocketClientEventProxyNegotiating
    -- ^ The client is negotiating
    --   with a proxy to connect to the destination server.
    | SocketClientEventProxyNegotiated
    -- ^ The client has negotiated
    --   with the proxy server.
    | SocketClientEventTlsHandshaking
    -- ^ The client is performing a
    --   TLS handshake.
    | SocketClientEventTlsHandshaked
    -- ^ The client has performed a
    --   TLS handshake.
    | SocketClientEventComplete
    -- ^ The client is done with a particular
    --   t'GI.Gio.Interfaces.SocketConnectable.SocketConnectable'.
    | AnotherSocketClientEvent Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SocketClientEvent where
    fromEnum SocketClientEventResolving = 0
    fromEnum SocketClientEventResolved = 1
    fromEnum SocketClientEventConnecting = 2
    fromEnum SocketClientEventConnected = 3
    fromEnum SocketClientEventProxyNegotiating = 4
    fromEnum SocketClientEventProxyNegotiated = 5
    fromEnum SocketClientEventTlsHandshaking = 6
    fromEnum SocketClientEventTlsHandshaked = 7
    fromEnum SocketClientEventComplete = 8
    fromEnum (AnotherSocketClientEvent k) = k

    toEnum 0 = SocketClientEventResolving
    toEnum 1 = SocketClientEventResolved
    toEnum 2 = SocketClientEventConnecting
    toEnum 3 = SocketClientEventConnected
    toEnum 4 = SocketClientEventProxyNegotiating
    toEnum 5 = SocketClientEventProxyNegotiated
    toEnum 6 = SocketClientEventTlsHandshaking
    toEnum 7 = SocketClientEventTlsHandshaked
    toEnum 8 = SocketClientEventComplete
    toEnum k = AnotherSocketClientEvent k

instance P.Ord SocketClientEvent where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SocketClientEvent = '[]
instance O.HasParentTypes SocketClientEvent

foreign import ccall "g_socket_client_event_get_type" c_g_socket_client_event_get_type :: 
    IO GType

instance B.Types.TypedObject SocketClientEvent where
    glibType = c_g_socket_client_event_get_type

instance B.Types.BoxedEnum SocketClientEvent

-- Enum ResourceError
-- | An error code used with @/G_RESOURCE_ERROR/@ in a t'GError' returned
-- from a t'GI.Gio.Structs.Resource.Resource' routine.
-- 
-- /Since: 2.32/
data ResourceError = 
      ResourceErrorNotFound
    -- ^ no file was found at the requested path
    | ResourceErrorInternal
    -- ^ unknown error
    | AnotherResourceError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ResourceError where
    fromEnum ResourceErrorNotFound = 0
    fromEnum ResourceErrorInternal = 1
    fromEnum (AnotherResourceError k) = k

    toEnum 0 = ResourceErrorNotFound
    toEnum 1 = ResourceErrorInternal
    toEnum k = AnotherResourceError k

instance P.Ord ResourceError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass ResourceError where
    gerrorClassDomain _ = "g-resource-error-quark"

-- | Catch exceptions of type `ResourceError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchResourceError ::
    IO a ->
    (ResourceError -> GErrorMessage -> IO a) ->
    IO a
catchResourceError = catchGErrorJustDomain

-- | Handle exceptions of type `ResourceError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleResourceError ::
    (ResourceError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleResourceError = handleGErrorJustDomain

type instance O.ParentTypes ResourceError = '[]
instance O.HasParentTypes ResourceError

foreign import ccall "g_resource_error_get_type" c_g_resource_error_get_type :: 
    IO GType

instance B.Types.TypedObject ResourceError where
    glibType = c_g_resource_error_get_type

instance B.Types.BoxedEnum ResourceError

-- Enum ResolverRecordType
-- | The type of record that 'GI.Gio.Objects.Resolver.resolverLookupRecords' or
-- 'GI.Gio.Objects.Resolver.resolverLookupRecordsAsync' should retrieve. The records are returned
-- as lists of t'GVariant' tuples. Each record type has different values in
-- the variant tuples returned.
-- 
-- 'GI.Gio.Enums.ResolverRecordTypeSrv' records are returned as variants with the signature
-- @(qqqs)@, containing a @guint16@ with the priority, a @guint16@ with the
-- weight, a @guint16@ with the port, and a string of the hostname.
-- 
-- 'GI.Gio.Enums.ResolverRecordTypeMx' records are returned as variants with the signature
-- @(qs)@, representing a @guint16@ with the preference, and a string containing
-- the mail exchanger hostname.
-- 
-- 'GI.Gio.Enums.ResolverRecordTypeTxt' records are returned as variants with the signature
-- @(as)@, representing an array of the strings in the text record. Note: Most TXT
-- records only contain a single string, but
-- <https://tools.ietf.org/html/rfc1035#section-3.3.14 RFC 1035> does allow a
-- record to contain multiple strings. The RFC which defines the interpretation
-- of a specific TXT record will likely require concatenation of multiple
-- strings if they are present, as with
-- <https://tools.ietf.org/html/rfc7208#section-3.3 RFC 7208>.
-- 
-- 'GI.Gio.Enums.ResolverRecordTypeSoa' records are returned as variants with the signature
-- @(ssuuuuu)@, representing a string containing the primary name server, a
-- string containing the administrator, the serial as a @guint32@, the refresh
-- interval as a @guint32@, the retry interval as a @guint32@, the expire timeout
-- as a @guint32@, and the TTL as a @guint32@.
-- 
-- 'GI.Gio.Enums.ResolverRecordTypeNs' records are returned as variants with the signature
-- @(s)@, representing a string of the hostname of the name server.
-- 
-- /Since: 2.34/
data ResolverRecordType = 
      ResolverRecordTypeSrv
    -- ^ look up DNS SRV records for a domain
    | ResolverRecordTypeMx
    -- ^ look up DNS MX records for a domain
    | ResolverRecordTypeTxt
    -- ^ look up DNS TXT records for a name
    | ResolverRecordTypeSoa
    -- ^ look up DNS SOA records for a zone
    | ResolverRecordTypeNs
    -- ^ look up DNS NS records for a domain
    | AnotherResolverRecordType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ResolverRecordType where
    fromEnum ResolverRecordTypeSrv = 1
    fromEnum ResolverRecordTypeMx = 2
    fromEnum ResolverRecordTypeTxt = 3
    fromEnum ResolverRecordTypeSoa = 4
    fromEnum ResolverRecordTypeNs = 5
    fromEnum (AnotherResolverRecordType k) = k

    toEnum 1 = ResolverRecordTypeSrv
    toEnum 2 = ResolverRecordTypeMx
    toEnum 3 = ResolverRecordTypeTxt
    toEnum 4 = ResolverRecordTypeSoa
    toEnum 5 = ResolverRecordTypeNs
    toEnum k = AnotherResolverRecordType k

instance P.Ord ResolverRecordType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ResolverRecordType = '[]
instance O.HasParentTypes ResolverRecordType

foreign import ccall "g_resolver_record_type_get_type" c_g_resolver_record_type_get_type :: 
    IO GType

instance B.Types.TypedObject ResolverRecordType where
    glibType = c_g_resolver_record_type_get_type

instance B.Types.BoxedEnum ResolverRecordType

-- Enum ResolverError
-- | An error code used with @/G_RESOLVER_ERROR/@ in a t'GError' returned
-- from a t'GI.Gio.Objects.Resolver.Resolver' routine.
-- 
-- /Since: 2.22/
data ResolverError = 
      ResolverErrorNotFound
    -- ^ the requested name\/address\/service was not
    --     found
    | ResolverErrorTemporaryFailure
    -- ^ the requested information could not
    --     be looked up due to a network error or similar problem
    | ResolverErrorInternal
    -- ^ unknown error
    | AnotherResolverError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ResolverError where
    fromEnum ResolverErrorNotFound = 0
    fromEnum ResolverErrorTemporaryFailure = 1
    fromEnum ResolverErrorInternal = 2
    fromEnum (AnotherResolverError k) = k

    toEnum 0 = ResolverErrorNotFound
    toEnum 1 = ResolverErrorTemporaryFailure
    toEnum 2 = ResolverErrorInternal
    toEnum k = AnotherResolverError k

instance P.Ord ResolverError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass ResolverError where
    gerrorClassDomain _ = "g-resolver-error-quark"

-- | Catch exceptions of type `ResolverError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchResolverError ::
    IO a ->
    (ResolverError -> GErrorMessage -> IO a) ->
    IO a
catchResolverError = catchGErrorJustDomain

-- | Handle exceptions of type `ResolverError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleResolverError ::
    (ResolverError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleResolverError = handleGErrorJustDomain

type instance O.ParentTypes ResolverError = '[]
instance O.HasParentTypes ResolverError

foreign import ccall "g_resolver_error_get_type" c_g_resolver_error_get_type :: 
    IO GType

instance B.Types.TypedObject ResolverError where
    glibType = c_g_resolver_error_get_type

instance B.Types.BoxedEnum ResolverError

-- Enum PollableReturn
-- | Return value for various IO operations that signal errors via the
-- return value and not necessarily via a t'GError'.
-- 
-- This enum exists to be able to return errors to callers without having to
-- allocate a t'GError'. Allocating @/GErrors/@ can be quite expensive for
-- regularly happening errors like 'GI.Gio.Enums.IOErrorEnumWouldBlock'.
-- 
-- In case of 'GI.Gio.Enums.PollableReturnFailed' a t'GError' should be set for the
-- operation to give details about the error that happened.
-- 
-- /Since: 2.60/
data PollableReturn = 
      PollableReturnFailed
    -- ^ Generic error condition for when an operation fails.
    | PollableReturnOk
    -- ^ The operation was successfully finished.
    | PollableReturnWouldBlock
    -- ^ The operation would block.
    | AnotherPollableReturn Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PollableReturn where
    fromEnum PollableReturnFailed = 0
    fromEnum PollableReturnOk = 1
    fromEnum PollableReturnWouldBlock = -27
    fromEnum (AnotherPollableReturn k) = k

    toEnum 0 = PollableReturnFailed
    toEnum 1 = PollableReturnOk
    toEnum -27 = PollableReturnWouldBlock
    toEnum k = AnotherPollableReturn k

instance P.Ord PollableReturn where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PollableReturn = '[]
instance O.HasParentTypes PollableReturn

foreign import ccall "g_pollable_return_get_type" c_g_pollable_return_get_type :: 
    IO GType

instance B.Types.TypedObject PollableReturn where
    glibType = c_g_pollable_return_get_type

instance B.Types.BoxedEnum PollableReturn

-- Enum PasswordSave
-- | t'GI.Gio.Enums.PasswordSave' is used to indicate the lifespan of a saved password.
-- 
-- @/Gvfs/@ stores passwords in the Gnome keyring when this flag allows it
-- to, and later retrieves it again from there.
data PasswordSave = 
      PasswordSaveNever
    -- ^ never save a password.
    | PasswordSaveForSession
    -- ^ save a password for the session.
    | PasswordSavePermanently
    -- ^ save a password permanently.
    | AnotherPasswordSave Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PasswordSave where
    fromEnum PasswordSaveNever = 0
    fromEnum PasswordSaveForSession = 1
    fromEnum PasswordSavePermanently = 2
    fromEnum (AnotherPasswordSave k) = k

    toEnum 0 = PasswordSaveNever
    toEnum 1 = PasswordSaveForSession
    toEnum 2 = PasswordSavePermanently
    toEnum k = AnotherPasswordSave k

instance P.Ord PasswordSave where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PasswordSave = '[]
instance O.HasParentTypes PasswordSave

foreign import ccall "g_password_save_get_type" c_g_password_save_get_type :: 
    IO GType

instance B.Types.TypedObject PasswordSave where
    glibType = c_g_password_save_get_type

instance B.Types.BoxedEnum PasswordSave

-- Enum NotificationPriority
-- | Priority levels for @/GNotifications/@.
-- 
-- /Since: 2.42/
data NotificationPriority = 
      NotificationPriorityNormal
    -- ^ the default priority, to be used for the
    --   majority of notifications (for example email messages, software updates,
    --   completed download\/sync operations)
    | NotificationPriorityLow
    -- ^ for notifications that do not require
    --   immediate attention - typically used for contextual background
    --   information, such as contact birthdays or local weather
    | NotificationPriorityHigh
    -- ^ for events that require more attention,
    --   usually because responses are time-sensitive (for example chat and SMS
    --   messages or alarms)
    | NotificationPriorityUrgent
    -- ^ for urgent notifications, or notifications
    --   that require a response in a short space of time (for example phone calls
    --   or emergency warnings)
    | AnotherNotificationPriority Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum NotificationPriority where
    fromEnum NotificationPriorityNormal = 0
    fromEnum NotificationPriorityLow = 1
    fromEnum NotificationPriorityHigh = 2
    fromEnum NotificationPriorityUrgent = 3
    fromEnum (AnotherNotificationPriority k) = k

    toEnum 0 = NotificationPriorityNormal
    toEnum 1 = NotificationPriorityLow
    toEnum 2 = NotificationPriorityHigh
    toEnum 3 = NotificationPriorityUrgent
    toEnum k = AnotherNotificationPriority k

instance P.Ord NotificationPriority where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes NotificationPriority = '[]
instance O.HasParentTypes NotificationPriority

foreign import ccall "g_notification_priority_get_type" c_g_notification_priority_get_type :: 
    IO GType

instance B.Types.TypedObject NotificationPriority where
    glibType = c_g_notification_priority_get_type

instance B.Types.BoxedEnum NotificationPriority

-- Enum NetworkConnectivity
-- | The host\'s network connectivity state, as reported by t'GI.Gio.Interfaces.NetworkMonitor.NetworkMonitor'.
-- 
-- /Since: 2.44/
data NetworkConnectivity = 
      NetworkConnectivityLocal
    -- ^ The host is not configured with a
    --   route to the Internet; it may or may not be connected to a local
    --   network.
    | NetworkConnectivityLimited
    -- ^ The host is connected to a network, but
    --   does not appear to be able to reach the full Internet, perhaps
    --   due to upstream network problems.
    | NetworkConnectivityPortal
    -- ^ The host is behind a captive portal and
    --   cannot reach the full Internet.
    | NetworkConnectivityFull
    -- ^ The host is connected to a network, and
    --   appears to be able to reach the full Internet.
    | AnotherNetworkConnectivity Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum NetworkConnectivity where
    fromEnum NetworkConnectivityLocal = 1
    fromEnum NetworkConnectivityLimited = 2
    fromEnum NetworkConnectivityPortal = 3
    fromEnum NetworkConnectivityFull = 4
    fromEnum (AnotherNetworkConnectivity k) = k

    toEnum 1 = NetworkConnectivityLocal
    toEnum 2 = NetworkConnectivityLimited
    toEnum 3 = NetworkConnectivityPortal
    toEnum 4 = NetworkConnectivityFull
    toEnum k = AnotherNetworkConnectivity k

instance P.Ord NetworkConnectivity where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes NetworkConnectivity = '[]
instance O.HasParentTypes NetworkConnectivity

foreign import ccall "g_network_connectivity_get_type" c_g_network_connectivity_get_type :: 
    IO GType

instance B.Types.TypedObject NetworkConnectivity where
    glibType = c_g_network_connectivity_get_type

instance B.Types.BoxedEnum NetworkConnectivity

-- Enum MountOperationResult
-- | t'GI.Gio.Enums.MountOperationResult' is returned as a result when a request for
-- information is send by the mounting operation.
data MountOperationResult = 
      MountOperationResultHandled
    -- ^ The request was fulfilled and the
    --     user specified data is now available
    | MountOperationResultAborted
    -- ^ The user requested the mount operation
    --     to be aborted
    | MountOperationResultUnhandled
    -- ^ The request was unhandled (i.e. not
    --     implemented)
    | AnotherMountOperationResult Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum MountOperationResult where
    fromEnum MountOperationResultHandled = 0
    fromEnum MountOperationResultAborted = 1
    fromEnum MountOperationResultUnhandled = 2
    fromEnum (AnotherMountOperationResult k) = k

    toEnum 0 = MountOperationResultHandled
    toEnum 1 = MountOperationResultAborted
    toEnum 2 = MountOperationResultUnhandled
    toEnum k = AnotherMountOperationResult k

instance P.Ord MountOperationResult where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes MountOperationResult = '[]
instance O.HasParentTypes MountOperationResult

foreign import ccall "g_mount_operation_result_get_type" c_g_mount_operation_result_get_type :: 
    IO GType

instance B.Types.TypedObject MountOperationResult where
    glibType = c_g_mount_operation_result_get_type

instance B.Types.BoxedEnum MountOperationResult

-- Enum MemoryMonitorWarningLevel
-- | Memory availability warning levels.
-- 
-- Note that because new values might be added, it is recommended that applications check
-- t'GI.Gio.Enums.MemoryMonitorWarningLevel' as ranges, for example:
-- 
-- === /C code/
-- >
-- >if (warning_level > G_MEMORY_MONITOR_WARNING_LEVEL_LOW)
-- >  drop_caches ();
-- 
-- 
-- /Since: 2.64/
data MemoryMonitorWarningLevel = 
      MemoryMonitorWarningLevelLow
    -- ^ Memory on the device is low, processes
    --   should free up unneeded resources (for example, in-memory caches) so they can
    --   be used elsewhere.
    | MemoryMonitorWarningLevelMedium
    -- ^ Same as /@gMEMORYMONITORWARNINGLEVELLOW@/
    --   but the device has even less free memory, so processes should try harder to free
    --   up unneeded resources. If your process does not need to stay running, it is a
    --   good time for it to quit.
    | MemoryMonitorWarningLevelCritical
    -- ^ The system will soon start terminating
    --   processes to reclaim memory, including background processes.
    | AnotherMemoryMonitorWarningLevel Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum MemoryMonitorWarningLevel where
    fromEnum MemoryMonitorWarningLevelLow = 50
    fromEnum MemoryMonitorWarningLevelMedium = 100
    fromEnum MemoryMonitorWarningLevelCritical = 255
    fromEnum (AnotherMemoryMonitorWarningLevel k) = k

    toEnum 50 = MemoryMonitorWarningLevelLow
    toEnum 100 = MemoryMonitorWarningLevelMedium
    toEnum 255 = MemoryMonitorWarningLevelCritical
    toEnum k = AnotherMemoryMonitorWarningLevel k

instance P.Ord MemoryMonitorWarningLevel where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes MemoryMonitorWarningLevel = '[]
instance O.HasParentTypes MemoryMonitorWarningLevel

foreign import ccall "g_memory_monitor_warning_level_get_type" c_g_memory_monitor_warning_level_get_type :: 
    IO GType

instance B.Types.TypedObject MemoryMonitorWarningLevel where
    glibType = c_g_memory_monitor_warning_level_get_type

instance B.Types.BoxedEnum MemoryMonitorWarningLevel

-- Enum IOModuleScopeFlags
-- | Flags for use with @/g_io_module_scope_new()/@.
-- 
-- /Since: 2.30/
data IOModuleScopeFlags = 
      IOModuleScopeFlagsNone
    -- ^ No module scan flags
    | IOModuleScopeFlagsBlockDuplicates
    -- ^ When using this scope to load or
    --     scan modules, automatically block a modules which has the same base
    --     basename as previously loaded module.
    | AnotherIOModuleScopeFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum IOModuleScopeFlags where
    fromEnum IOModuleScopeFlagsNone = 0
    fromEnum IOModuleScopeFlagsBlockDuplicates = 1
    fromEnum (AnotherIOModuleScopeFlags k) = k

    toEnum 0 = IOModuleScopeFlagsNone
    toEnum 1 = IOModuleScopeFlagsBlockDuplicates
    toEnum k = AnotherIOModuleScopeFlags k

instance P.Ord IOModuleScopeFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes IOModuleScopeFlags = '[]
instance O.HasParentTypes IOModuleScopeFlags

foreign import ccall "g_io_module_scope_flags_get_type" c_g_io_module_scope_flags_get_type :: 
    IO GType

instance B.Types.TypedObject IOModuleScopeFlags where
    glibType = c_g_io_module_scope_flags_get_type

instance B.Types.BoxedEnum IOModuleScopeFlags

-- Enum IOErrorEnum
-- | Error codes returned by GIO functions.
-- 
-- Note that this domain may be extended in future GLib releases. In
-- general, new error codes either only apply to new APIs, or else
-- replace 'GI.Gio.Enums.IOErrorEnumFailed' in cases that were not explicitly
-- distinguished before. You should therefore avoid writing code like
-- 
-- === /C code/
-- >
-- >if (g_error_matches (error, G_IO_ERROR, G_IO_ERROR_FAILED))
-- >  {
-- >    // Assume that this is EPRINTERONFIRE
-- >    ...
-- >  }
-- 
-- but should instead treat all unrecognized error codes the same as
-- 'GI.Gio.Enums.IOErrorEnumFailed'.
-- 
-- See also t'GI.Gio.Enums.PollableReturn' for a cheaper way of returning
-- 'GI.Gio.Enums.IOErrorEnumWouldBlock' to callers without allocating a t'GError'.
data IOErrorEnum = 
      IOErrorEnumFailed
    -- ^ Generic error condition for when an operation fails
    --     and no more specific t'GI.Gio.Enums.IOErrorEnum' value is defined.
    | IOErrorEnumNotFound
    -- ^ File not found.
    | IOErrorEnumExists
    -- ^ File already exists.
    | IOErrorEnumIsDirectory
    -- ^ File is a directory.
    | IOErrorEnumNotDirectory
    -- ^ File is not a directory.
    | IOErrorEnumNotEmpty
    -- ^ File is a directory that isn\'t empty.
    | IOErrorEnumNotRegularFile
    -- ^ File is not a regular file.
    | IOErrorEnumNotSymbolicLink
    -- ^ File is not a symbolic link.
    | IOErrorEnumNotMountableFile
    -- ^ File cannot be mounted.
    | IOErrorEnumFilenameTooLong
    -- ^ Filename is too many characters.
    | IOErrorEnumInvalidFilename
    -- ^ Filename is invalid or contains invalid characters.
    | IOErrorEnumTooManyLinks
    -- ^ File contains too many symbolic links.
    | IOErrorEnumNoSpace
    -- ^ No space left on drive.
    | IOErrorEnumInvalidArgument
    -- ^ Invalid argument.
    | IOErrorEnumPermissionDenied
    -- ^ Permission denied.
    | IOErrorEnumNotSupported
    -- ^ Operation (or one of its parameters) not supported
    | IOErrorEnumNotMounted
    -- ^ File isn\'t mounted.
    | IOErrorEnumAlreadyMounted
    -- ^ File is already mounted.
    | IOErrorEnumClosed
    -- ^ File was closed.
    | IOErrorEnumCancelled
    -- ^ Operation was cancelled. See t'GI.Gio.Objects.Cancellable.Cancellable'.
    | IOErrorEnumPending
    -- ^ Operations are still pending.
    | IOErrorEnumReadOnly
    -- ^ File is read only.
    | IOErrorEnumCantCreateBackup
    -- ^ Backup couldn\'t be created.
    | IOErrorEnumWrongEtag
    -- ^ File\'s Entity Tag was incorrect.
    | IOErrorEnumTimedOut
    -- ^ Operation timed out.
    | IOErrorEnumWouldRecurse
    -- ^ Operation would be recursive.
    | IOErrorEnumBusy
    -- ^ File is busy.
    | IOErrorEnumWouldBlock
    -- ^ Operation would block.
    | IOErrorEnumHostNotFound
    -- ^ Host couldn\'t be found (remote operations).
    | IOErrorEnumWouldMerge
    -- ^ Operation would merge files.
    | IOErrorEnumFailedHandled
    -- ^ Operation failed and a helper program has
    --     already interacted with the user. Do not display any error dialog.
    | IOErrorEnumTooManyOpenFiles
    -- ^ The current process has too many files
    --     open and can\'t open any more. Duplicate descriptors do count toward
    --     this limit. Since 2.20
    | IOErrorEnumNotInitialized
    -- ^ The object has not been initialized. Since 2.22
    | IOErrorEnumAddressInUse
    -- ^ The requested address is already in use. Since 2.22
    | IOErrorEnumPartialInput
    -- ^ Need more input to finish operation. Since 2.24
    | IOErrorEnumInvalidData
    -- ^ The input data was invalid. Since 2.24
    | IOErrorEnumDbusError
    -- ^ A remote object generated an error that
    --     doesn\'t correspond to a locally registered t'GError' error
    --     domain. Use 'GI.Gio.Functions.dbusErrorGetRemoteError' to extract the D-Bus
    --     error name and 'GI.Gio.Functions.dbusErrorStripRemoteError' to fix up the
    --     message so it matches what was received on the wire. Since 2.26.
    | IOErrorEnumHostUnreachable
    -- ^ Host unreachable. Since 2.26
    | IOErrorEnumNetworkUnreachable
    -- ^ Network unreachable. Since 2.26
    | IOErrorEnumConnectionRefused
    -- ^ Connection refused. Since 2.26
    | IOErrorEnumProxyFailed
    -- ^ Connection to proxy server failed. Since 2.26
    | IOErrorEnumProxyAuthFailed
    -- ^ Proxy authentication failed. Since 2.26
    | IOErrorEnumProxyNeedAuth
    -- ^ Proxy server needs authentication. Since 2.26
    | IOErrorEnumProxyNotAllowed
    -- ^ Proxy connection is not allowed by ruleset.
    --     Since 2.26
    | IOErrorEnumBrokenPipe
    -- ^ Broken pipe. Since 2.36
    | IOErrorEnumConnectionClosed
    -- ^ Connection closed by peer. Note that this
    --     is the same code as 'GI.Gio.Enums.IOErrorEnumBrokenPipe'; before 2.44 some
    --     \"connection closed\" errors returned 'GI.Gio.Enums.IOErrorEnumBrokenPipe', but others
    --     returned 'GI.Gio.Enums.IOErrorEnumFailed'. Now they should all return the same
    --     value, which has this more logical name. Since 2.44.
    | IOErrorEnumNotConnected
    -- ^ Transport endpoint is not connected. Since 2.44
    | IOErrorEnumMessageTooLarge
    -- ^ Message too large. Since 2.48.
    | IOErrorEnumNoSuchDevice
    -- ^ No such device found. Since 2.74
    | IOErrorEnumDestinationUnset
    -- ^ Destination address unset. Since 2.80
    | AnotherIOErrorEnum Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum IOErrorEnum where
    fromEnum IOErrorEnumFailed = 0
    fromEnum IOErrorEnumNotFound = 1
    fromEnum IOErrorEnumExists = 2
    fromEnum IOErrorEnumIsDirectory = 3
    fromEnum IOErrorEnumNotDirectory = 4
    fromEnum IOErrorEnumNotEmpty = 5
    fromEnum IOErrorEnumNotRegularFile = 6
    fromEnum IOErrorEnumNotSymbolicLink = 7
    fromEnum IOErrorEnumNotMountableFile = 8
    fromEnum IOErrorEnumFilenameTooLong = 9
    fromEnum IOErrorEnumInvalidFilename = 10
    fromEnum IOErrorEnumTooManyLinks = 11
    fromEnum IOErrorEnumNoSpace = 12
    fromEnum IOErrorEnumInvalidArgument = 13
    fromEnum IOErrorEnumPermissionDenied = 14
    fromEnum IOErrorEnumNotSupported = 15
    fromEnum IOErrorEnumNotMounted = 16
    fromEnum IOErrorEnumAlreadyMounted = 17
    fromEnum IOErrorEnumClosed = 18
    fromEnum IOErrorEnumCancelled = 19
    fromEnum IOErrorEnumPending = 20
    fromEnum IOErrorEnumReadOnly = 21
    fromEnum IOErrorEnumCantCreateBackup = 22
    fromEnum IOErrorEnumWrongEtag = 23
    fromEnum IOErrorEnumTimedOut = 24
    fromEnum IOErrorEnumWouldRecurse = 25
    fromEnum IOErrorEnumBusy = 26
    fromEnum IOErrorEnumWouldBlock = 27
    fromEnum IOErrorEnumHostNotFound = 28
    fromEnum IOErrorEnumWouldMerge = 29
    fromEnum IOErrorEnumFailedHandled = 30
    fromEnum IOErrorEnumTooManyOpenFiles = 31
    fromEnum IOErrorEnumNotInitialized = 32
    fromEnum IOErrorEnumAddressInUse = 33
    fromEnum IOErrorEnumPartialInput = 34
    fromEnum IOErrorEnumInvalidData = 35
    fromEnum IOErrorEnumDbusError = 36
    fromEnum IOErrorEnumHostUnreachable = 37
    fromEnum IOErrorEnumNetworkUnreachable = 38
    fromEnum IOErrorEnumConnectionRefused = 39
    fromEnum IOErrorEnumProxyFailed = 40
    fromEnum IOErrorEnumProxyAuthFailed = 41
    fromEnum IOErrorEnumProxyNeedAuth = 42
    fromEnum IOErrorEnumProxyNotAllowed = 43
    fromEnum IOErrorEnumBrokenPipe = 44
    fromEnum IOErrorEnumConnectionClosed = 44
    fromEnum IOErrorEnumNotConnected = 45
    fromEnum IOErrorEnumMessageTooLarge = 46
    fromEnum IOErrorEnumNoSuchDevice = 47
    fromEnum IOErrorEnumDestinationUnset = 48
    fromEnum (AnotherIOErrorEnum k) = k

    toEnum 0 = IOErrorEnumFailed
    toEnum 1 = IOErrorEnumNotFound
    toEnum 2 = IOErrorEnumExists
    toEnum 3 = IOErrorEnumIsDirectory
    toEnum 4 = IOErrorEnumNotDirectory
    toEnum 5 = IOErrorEnumNotEmpty
    toEnum 6 = IOErrorEnumNotRegularFile
    toEnum 7 = IOErrorEnumNotSymbolicLink
    toEnum 8 = IOErrorEnumNotMountableFile
    toEnum 9 = IOErrorEnumFilenameTooLong
    toEnum 10 = IOErrorEnumInvalidFilename
    toEnum 11 = IOErrorEnumTooManyLinks
    toEnum 12 = IOErrorEnumNoSpace
    toEnum 13 = IOErrorEnumInvalidArgument
    toEnum 14 = IOErrorEnumPermissionDenied
    toEnum 15 = IOErrorEnumNotSupported
    toEnum 16 = IOErrorEnumNotMounted
    toEnum 17 = IOErrorEnumAlreadyMounted
    toEnum 18 = IOErrorEnumClosed
    toEnum 19 = IOErrorEnumCancelled
    toEnum 20 = IOErrorEnumPending
    toEnum 21 = IOErrorEnumReadOnly
    toEnum 22 = IOErrorEnumCantCreateBackup
    toEnum 23 = IOErrorEnumWrongEtag
    toEnum 24 = IOErrorEnumTimedOut
    toEnum 25 = IOErrorEnumWouldRecurse
    toEnum 26 = IOErrorEnumBusy
    toEnum 27 = IOErrorEnumWouldBlock
    toEnum 28 = IOErrorEnumHostNotFound
    toEnum 29 = IOErrorEnumWouldMerge
    toEnum 30 = IOErrorEnumFailedHandled
    toEnum 31 = IOErrorEnumTooManyOpenFiles
    toEnum 32 = IOErrorEnumNotInitialized
    toEnum 33 = IOErrorEnumAddressInUse
    toEnum 34 = IOErrorEnumPartialInput
    toEnum 35 = IOErrorEnumInvalidData
    toEnum 36 = IOErrorEnumDbusError
    toEnum 37 = IOErrorEnumHostUnreachable
    toEnum 38 = IOErrorEnumNetworkUnreachable
    toEnum 39 = IOErrorEnumConnectionRefused
    toEnum 40 = IOErrorEnumProxyFailed
    toEnum 41 = IOErrorEnumProxyAuthFailed
    toEnum 42 = IOErrorEnumProxyNeedAuth
    toEnum 43 = IOErrorEnumProxyNotAllowed
    toEnum 44 = IOErrorEnumBrokenPipe
    toEnum 45 = IOErrorEnumNotConnected
    toEnum 46 = IOErrorEnumMessageTooLarge
    toEnum 47 = IOErrorEnumNoSuchDevice
    toEnum 48 = IOErrorEnumDestinationUnset
    toEnum k = AnotherIOErrorEnum k

instance P.Ord IOErrorEnum where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass IOErrorEnum where
    gerrorClassDomain _ = "g-io-error-quark"

-- | Catch exceptions of type `IOErrorEnum`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchIOErrorEnum ::
    IO a ->
    (IOErrorEnum -> GErrorMessage -> IO a) ->
    IO a
catchIOErrorEnum = catchGErrorJustDomain

-- | Handle exceptions of type `IOErrorEnum`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleIOErrorEnum ::
    (IOErrorEnum -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleIOErrorEnum = handleGErrorJustDomain

type instance O.ParentTypes IOErrorEnum = '[]
instance O.HasParentTypes IOErrorEnum

foreign import ccall "g_io_error_enum_get_type" c_g_io_error_enum_get_type :: 
    IO GType

instance B.Types.TypedObject IOErrorEnum where
    glibType = c_g_io_error_enum_get_type

instance B.Types.BoxedEnum IOErrorEnum

-- Enum FilesystemPreviewType
-- | Indicates a hint from the file system whether files should be
-- previewed in a file manager. Returned as the value of the key
-- 'GI.Gio.Constants.FILE_ATTRIBUTE_FILESYSTEM_USE_PREVIEW'.
data FilesystemPreviewType = 
      FilesystemPreviewTypeIfAlways
    -- ^ Only preview files if user has explicitly requested it.
    | FilesystemPreviewTypeIfLocal
    -- ^ Preview files if user has requested preview of \"local\" files.
    | FilesystemPreviewTypeNever
    -- ^ Never preview files.
    | AnotherFilesystemPreviewType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FilesystemPreviewType where
    fromEnum FilesystemPreviewTypeIfAlways = 0
    fromEnum FilesystemPreviewTypeIfLocal = 1
    fromEnum FilesystemPreviewTypeNever = 2
    fromEnum (AnotherFilesystemPreviewType k) = k

    toEnum 0 = FilesystemPreviewTypeIfAlways
    toEnum 1 = FilesystemPreviewTypeIfLocal
    toEnum 2 = FilesystemPreviewTypeNever
    toEnum k = AnotherFilesystemPreviewType k

instance P.Ord FilesystemPreviewType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FilesystemPreviewType = '[]
instance O.HasParentTypes FilesystemPreviewType

foreign import ccall "g_filesystem_preview_type_get_type" c_g_filesystem_preview_type_get_type :: 
    IO GType

instance B.Types.TypedObject FilesystemPreviewType where
    glibType = c_g_filesystem_preview_type_get_type

instance B.Types.BoxedEnum FilesystemPreviewType

-- Enum FileType
-- | Indicates the file\'s on-disk type.
-- 
-- On Windows systems a file will never have 'GI.Gio.Enums.FileTypeSymbolicLink' type;
-- use t'GI.Gio.Objects.FileInfo.FileInfo' and 'GI.Gio.Constants.FILE_ATTRIBUTE_STANDARD_IS_SYMLINK' to determine
-- whether a file is a symlink or not. This is due to the fact that NTFS does
-- not have a single filesystem object type for symbolic links - it has
-- files that symlink to files, and directories that symlink to directories.
-- t'GI.Gio.Enums.FileType' enumeration cannot precisely represent this important distinction,
-- which is why all Windows symlinks will continue to be reported as
-- 'GI.Gio.Enums.FileTypeRegular' or 'GI.Gio.Enums.FileTypeDirectory'.
data FileType = 
      FileTypeUnknown
    -- ^ File\'s type is unknown.
    | FileTypeRegular
    -- ^ File handle represents a regular file.
    | FileTypeDirectory
    -- ^ File handle represents a directory.
    | FileTypeSymbolicLink
    -- ^ File handle represents a symbolic link
    --    (Unix systems).
    | FileTypeSpecial
    -- ^ File is a \"special\" file, such as a socket, fifo,
    --    block device, or character device.
    | FileTypeShortcut
    -- ^ File is a shortcut (Windows systems).
    | FileTypeMountable
    -- ^ File is a mountable location.
    | AnotherFileType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FileType where
    fromEnum FileTypeUnknown = 0
    fromEnum FileTypeRegular = 1
    fromEnum FileTypeDirectory = 2
    fromEnum FileTypeSymbolicLink = 3
    fromEnum FileTypeSpecial = 4
    fromEnum FileTypeShortcut = 5
    fromEnum FileTypeMountable = 6
    fromEnum (AnotherFileType k) = k

    toEnum 0 = FileTypeUnknown
    toEnum 1 = FileTypeRegular
    toEnum 2 = FileTypeDirectory
    toEnum 3 = FileTypeSymbolicLink
    toEnum 4 = FileTypeSpecial
    toEnum 5 = FileTypeShortcut
    toEnum 6 = FileTypeMountable
    toEnum k = AnotherFileType k

instance P.Ord FileType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FileType = '[]
instance O.HasParentTypes FileType

foreign import ccall "g_file_type_get_type" c_g_file_type_get_type :: 
    IO GType

instance B.Types.TypedObject FileType where
    glibType = c_g_file_type_get_type

instance B.Types.BoxedEnum FileType

-- Enum FileMonitorEvent
-- | Specifies what type of event a monitor event is.
data FileMonitorEvent = 
      FileMonitorEventChanged
    -- ^ a file changed.
    | FileMonitorEventChangesDoneHint
    -- ^ a hint that this was probably the last change in a set of changes.
    | FileMonitorEventDeleted
    -- ^ a file was deleted.
    | FileMonitorEventCreated
    -- ^ a file was created.
    | FileMonitorEventAttributeChanged
    -- ^ a file attribute was changed.
    | FileMonitorEventPreUnmount
    -- ^ the file location will soon be unmounted.
    | FileMonitorEventUnmounted
    -- ^ the file location was unmounted.
    | FileMonitorEventMoved
    -- ^ the file was moved -- only sent if the
    --   (deprecated) 'GI.Gio.Flags.FileMonitorFlagsSendMoved' flag is set
    | FileMonitorEventRenamed
    -- ^ the file was renamed within the
    --   current directory -- only sent if the 'GI.Gio.Flags.FileMonitorFlagsWatchMoves'
    --   flag is set.  Since: 2.46.
    | FileMonitorEventMovedIn
    -- ^ the file was moved into the
    --   monitored directory from another location -- only sent if the
    --   'GI.Gio.Flags.FileMonitorFlagsWatchMoves' flag is set.  Since: 2.46.
    | FileMonitorEventMovedOut
    -- ^ the file was moved out of the
    --   monitored directory to another location -- only sent if the
    --   'GI.Gio.Flags.FileMonitorFlagsWatchMoves' flag is set.  Since: 2.46
    | AnotherFileMonitorEvent Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FileMonitorEvent where
    fromEnum FileMonitorEventChanged = 0
    fromEnum FileMonitorEventChangesDoneHint = 1
    fromEnum FileMonitorEventDeleted = 2
    fromEnum FileMonitorEventCreated = 3
    fromEnum FileMonitorEventAttributeChanged = 4
    fromEnum FileMonitorEventPreUnmount = 5
    fromEnum FileMonitorEventUnmounted = 6
    fromEnum FileMonitorEventMoved = 7
    fromEnum FileMonitorEventRenamed = 8
    fromEnum FileMonitorEventMovedIn = 9
    fromEnum FileMonitorEventMovedOut = 10
    fromEnum (AnotherFileMonitorEvent k) = k

    toEnum 0 = FileMonitorEventChanged
    toEnum 1 = FileMonitorEventChangesDoneHint
    toEnum 2 = FileMonitorEventDeleted
    toEnum 3 = FileMonitorEventCreated
    toEnum 4 = FileMonitorEventAttributeChanged
    toEnum 5 = FileMonitorEventPreUnmount
    toEnum 6 = FileMonitorEventUnmounted
    toEnum 7 = FileMonitorEventMoved
    toEnum 8 = FileMonitorEventRenamed
    toEnum 9 = FileMonitorEventMovedIn
    toEnum 10 = FileMonitorEventMovedOut
    toEnum k = AnotherFileMonitorEvent k

instance P.Ord FileMonitorEvent where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FileMonitorEvent = '[]
instance O.HasParentTypes FileMonitorEvent

foreign import ccall "g_file_monitor_event_get_type" c_g_file_monitor_event_get_type :: 
    IO GType

instance B.Types.TypedObject FileMonitorEvent where
    glibType = c_g_file_monitor_event_get_type

instance B.Types.BoxedEnum FileMonitorEvent

-- Enum FileAttributeType
-- | The data types for file attributes.
data FileAttributeType = 
      FileAttributeTypeInvalid
    -- ^ indicates an invalid or uninitialized type.
    | FileAttributeTypeString
    -- ^ a null terminated UTF8 string.
    | FileAttributeTypeByteString
    -- ^ a zero terminated string of non-zero bytes.
    | FileAttributeTypeBoolean
    -- ^ a boolean value.
    | FileAttributeTypeUint32
    -- ^ an unsigned 4-byte\/32-bit integer.
    | FileAttributeTypeInt32
    -- ^ a signed 4-byte\/32-bit integer.
    | FileAttributeTypeUint64
    -- ^ an unsigned 8-byte\/64-bit integer.
    | FileAttributeTypeInt64
    -- ^ a signed 8-byte\/64-bit integer.
    | FileAttributeTypeObject
    -- ^ a t'GI.GObject.Objects.Object.Object'.
    | FileAttributeTypeStringv
    -- ^ a 'P.Nothing' terminated char __. Since 2.22
    | AnotherFileAttributeType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FileAttributeType where
    fromEnum FileAttributeTypeInvalid = 0
    fromEnum FileAttributeTypeString = 1
    fromEnum FileAttributeTypeByteString = 2
    fromEnum FileAttributeTypeBoolean = 3
    fromEnum FileAttributeTypeUint32 = 4
    fromEnum FileAttributeTypeInt32 = 5
    fromEnum FileAttributeTypeUint64 = 6
    fromEnum FileAttributeTypeInt64 = 7
    fromEnum FileAttributeTypeObject = 8
    fromEnum FileAttributeTypeStringv = 9
    fromEnum (AnotherFileAttributeType k) = k

    toEnum 0 = FileAttributeTypeInvalid
    toEnum 1 = FileAttributeTypeString
    toEnum 2 = FileAttributeTypeByteString
    toEnum 3 = FileAttributeTypeBoolean
    toEnum 4 = FileAttributeTypeUint32
    toEnum 5 = FileAttributeTypeInt32
    toEnum 6 = FileAttributeTypeUint64
    toEnum 7 = FileAttributeTypeInt64
    toEnum 8 = FileAttributeTypeObject
    toEnum 9 = FileAttributeTypeStringv
    toEnum k = AnotherFileAttributeType k

instance P.Ord FileAttributeType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FileAttributeType = '[]
instance O.HasParentTypes FileAttributeType

foreign import ccall "g_file_attribute_type_get_type" c_g_file_attribute_type_get_type :: 
    IO GType

instance B.Types.TypedObject FileAttributeType where
    glibType = c_g_file_attribute_type_get_type

instance B.Types.BoxedEnum FileAttributeType

-- Enum FileAttributeStatus
-- | Used by 'GI.Gio.Interfaces.File.fileSetAttributesFromInfo' when setting file attributes.
data FileAttributeStatus = 
      FileAttributeStatusUnset
    -- ^ Attribute value is unset (empty).
    | FileAttributeStatusSet
    -- ^ Attribute value is set.
    | FileAttributeStatusErrorSetting
    -- ^ Indicates an error in setting the value.
    | AnotherFileAttributeStatus Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FileAttributeStatus where
    fromEnum FileAttributeStatusUnset = 0
    fromEnum FileAttributeStatusSet = 1
    fromEnum FileAttributeStatusErrorSetting = 2
    fromEnum (AnotherFileAttributeStatus k) = k

    toEnum 0 = FileAttributeStatusUnset
    toEnum 1 = FileAttributeStatusSet
    toEnum 2 = FileAttributeStatusErrorSetting
    toEnum k = AnotherFileAttributeStatus k

instance P.Ord FileAttributeStatus where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FileAttributeStatus = '[]
instance O.HasParentTypes FileAttributeStatus

foreign import ccall "g_file_attribute_status_get_type" c_g_file_attribute_status_get_type :: 
    IO GType

instance B.Types.TypedObject FileAttributeStatus where
    glibType = c_g_file_attribute_status_get_type

instance B.Types.BoxedEnum FileAttributeStatus

-- Enum EmblemOrigin
-- | GEmblemOrigin is used to add information about the origin of the emblem
-- to t'GI.Gio.Objects.Emblem.Emblem'.
-- 
-- /Since: 2.18/
data EmblemOrigin = 
      EmblemOriginUnknown
    -- ^ Emblem of unknown origin
    | EmblemOriginDevice
    -- ^ Emblem adds device-specific information
    | EmblemOriginLivemetadata
    -- ^ Emblem depicts live metadata, such as \"readonly\"
    | EmblemOriginTag
    -- ^ Emblem comes from a user-defined tag, e.g. set by nautilus (in the future)
    | AnotherEmblemOrigin Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum EmblemOrigin where
    fromEnum EmblemOriginUnknown = 0
    fromEnum EmblemOriginDevice = 1
    fromEnum EmblemOriginLivemetadata = 2
    fromEnum EmblemOriginTag = 3
    fromEnum (AnotherEmblemOrigin k) = k

    toEnum 0 = EmblemOriginUnknown
    toEnum 1 = EmblemOriginDevice
    toEnum 2 = EmblemOriginLivemetadata
    toEnum 3 = EmblemOriginTag
    toEnum k = AnotherEmblemOrigin k

instance P.Ord EmblemOrigin where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes EmblemOrigin = '[]
instance O.HasParentTypes EmblemOrigin

foreign import ccall "g_emblem_origin_get_type" c_g_emblem_origin_get_type :: 
    IO GType

instance B.Types.TypedObject EmblemOrigin where
    glibType = c_g_emblem_origin_get_type

instance B.Types.BoxedEnum EmblemOrigin

-- Enum DriveStartStopType
-- | Enumeration describing how a drive can be started\/stopped.
-- 
-- /Since: 2.22/
data DriveStartStopType = 
      DriveStartStopTypeUnknown
    -- ^ Unknown or drive doesn\'t support
    --    start\/stop.
    | DriveStartStopTypeShutdown
    -- ^ The stop method will physically
    --    shut down the drive and e.g. power down the port the drive is
    --    attached to.
    | DriveStartStopTypeNetwork
    -- ^ The start\/stop methods are used
    --    for connecting\/disconnect to the drive over the network.
    | DriveStartStopTypeMultidisk
    -- ^ The start\/stop methods will
    --    assemble\/disassemble a virtual drive from several physical
    --    drives.
    | DriveStartStopTypePassword
    -- ^ The start\/stop methods will
    --    unlock\/lock the disk (for example using the ATA @SECURITY UNLOCK
    --    DEVICE@ command)
    | AnotherDriveStartStopType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DriveStartStopType where
    fromEnum DriveStartStopTypeUnknown = 0
    fromEnum DriveStartStopTypeShutdown = 1
    fromEnum DriveStartStopTypeNetwork = 2
    fromEnum DriveStartStopTypeMultidisk = 3
    fromEnum DriveStartStopTypePassword = 4
    fromEnum (AnotherDriveStartStopType k) = k

    toEnum 0 = DriveStartStopTypeUnknown
    toEnum 1 = DriveStartStopTypeShutdown
    toEnum 2 = DriveStartStopTypeNetwork
    toEnum 3 = DriveStartStopTypeMultidisk
    toEnum 4 = DriveStartStopTypePassword
    toEnum k = AnotherDriveStartStopType k

instance P.Ord DriveStartStopType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DriveStartStopType = '[]
instance O.HasParentTypes DriveStartStopType

foreign import ccall "g_drive_start_stop_type_get_type" c_g_drive_start_stop_type_get_type :: 
    IO GType

instance B.Types.TypedObject DriveStartStopType where
    glibType = c_g_drive_start_stop_type_get_type

instance B.Types.BoxedEnum DriveStartStopType

-- Enum DataStreamNewlineType
-- | t'GI.Gio.Enums.DataStreamNewlineType' is used when checking for or setting the line endings for a given file.
data DataStreamNewlineType = 
      DataStreamNewlineTypeLf
    -- ^ Selects \"LF\" line endings, common on most modern UNIX platforms.
    | DataStreamNewlineTypeCr
    -- ^ Selects \"CR\" line endings.
    | DataStreamNewlineTypeCrLf
    -- ^ Selects \"CR, LF\" line ending, common on Microsoft Windows.
    | DataStreamNewlineTypeAny
    -- ^ Automatically try to handle any line ending type.
    | AnotherDataStreamNewlineType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DataStreamNewlineType where
    fromEnum DataStreamNewlineTypeLf = 0
    fromEnum DataStreamNewlineTypeCr = 1
    fromEnum DataStreamNewlineTypeCrLf = 2
    fromEnum DataStreamNewlineTypeAny = 3
    fromEnum (AnotherDataStreamNewlineType k) = k

    toEnum 0 = DataStreamNewlineTypeLf
    toEnum 1 = DataStreamNewlineTypeCr
    toEnum 2 = DataStreamNewlineTypeCrLf
    toEnum 3 = DataStreamNewlineTypeAny
    toEnum k = AnotherDataStreamNewlineType k

instance P.Ord DataStreamNewlineType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DataStreamNewlineType = '[]
instance O.HasParentTypes DataStreamNewlineType

foreign import ccall "g_data_stream_newline_type_get_type" c_g_data_stream_newline_type_get_type :: 
    IO GType

instance B.Types.TypedObject DataStreamNewlineType where
    glibType = c_g_data_stream_newline_type_get_type

instance B.Types.BoxedEnum DataStreamNewlineType

-- Enum DataStreamByteOrder
-- | t'GI.Gio.Enums.DataStreamByteOrder' is used to ensure proper endianness of streaming data sources
-- across various machine architectures.
data DataStreamByteOrder = 
      DataStreamByteOrderBigEndian
    -- ^ Selects Big Endian byte order.
    | DataStreamByteOrderLittleEndian
    -- ^ Selects Little Endian byte order.
    | DataStreamByteOrderHostEndian
    -- ^ Selects endianness based on host machine\'s architecture.
    | AnotherDataStreamByteOrder Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DataStreamByteOrder where
    fromEnum DataStreamByteOrderBigEndian = 0
    fromEnum DataStreamByteOrderLittleEndian = 1
    fromEnum DataStreamByteOrderHostEndian = 2
    fromEnum (AnotherDataStreamByteOrder k) = k

    toEnum 0 = DataStreamByteOrderBigEndian
    toEnum 1 = DataStreamByteOrderLittleEndian
    toEnum 2 = DataStreamByteOrderHostEndian
    toEnum k = AnotherDataStreamByteOrder k

instance P.Ord DataStreamByteOrder where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DataStreamByteOrder = '[]
instance O.HasParentTypes DataStreamByteOrder

foreign import ccall "g_data_stream_byte_order_get_type" c_g_data_stream_byte_order_get_type :: 
    IO GType

instance B.Types.TypedObject DataStreamByteOrder where
    glibType = c_g_data_stream_byte_order_get_type

instance B.Types.BoxedEnum DataStreamByteOrder

-- Enum DBusMessageType
-- | Message types used in t'GI.Gio.Objects.DBusMessage.DBusMessage'.
-- 
-- /Since: 2.26/
data DBusMessageType = 
      DBusMessageTypeInvalid
    -- ^ Message is of invalid type.
    | DBusMessageTypeMethodCall
    -- ^ Method call.
    | DBusMessageTypeMethodReturn
    -- ^ Method reply.
    | DBusMessageTypeError
    -- ^ Error reply.
    | DBusMessageTypeSignal
    -- ^ Signal emission.
    | AnotherDBusMessageType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DBusMessageType where
    fromEnum DBusMessageTypeInvalid = 0
    fromEnum DBusMessageTypeMethodCall = 1
    fromEnum DBusMessageTypeMethodReturn = 2
    fromEnum DBusMessageTypeError = 3
    fromEnum DBusMessageTypeSignal = 4
    fromEnum (AnotherDBusMessageType k) = k

    toEnum 0 = DBusMessageTypeInvalid
    toEnum 1 = DBusMessageTypeMethodCall
    toEnum 2 = DBusMessageTypeMethodReturn
    toEnum 3 = DBusMessageTypeError
    toEnum 4 = DBusMessageTypeSignal
    toEnum k = AnotherDBusMessageType k

instance P.Ord DBusMessageType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DBusMessageType = '[]
instance O.HasParentTypes DBusMessageType

foreign import ccall "g_dbus_message_type_get_type" c_g_dbus_message_type_get_type :: 
    IO GType

instance B.Types.TypedObject DBusMessageType where
    glibType = c_g_dbus_message_type_get_type

instance B.Types.BoxedEnum DBusMessageType

-- Enum DBusMessageHeaderField
-- | Header fields used in t'GI.Gio.Objects.DBusMessage.DBusMessage'.
-- 
-- /Since: 2.26/
data DBusMessageHeaderField = 
      DBusMessageHeaderFieldInvalid
    -- ^ Not a valid header field.
    | DBusMessageHeaderFieldPath
    -- ^ The object path.
    | DBusMessageHeaderFieldInterface
    -- ^ The interface name.
    | DBusMessageHeaderFieldMember
    -- ^ The method or signal name.
    | DBusMessageHeaderFieldErrorName
    -- ^ The name of the error that occurred.
    | DBusMessageHeaderFieldReplySerial
    -- ^ The serial number the message is a reply to.
    | DBusMessageHeaderFieldDestination
    -- ^ The name the message is intended for.
    | DBusMessageHeaderFieldSender
    -- ^ Unique name of the sender of the message (filled in by the bus).
    | DBusMessageHeaderFieldSignature
    -- ^ The signature of the message body.
    | DBusMessageHeaderFieldNumUnixFds
    -- ^ The number of UNIX file descriptors that accompany the message.
    | AnotherDBusMessageHeaderField Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DBusMessageHeaderField where
    fromEnum DBusMessageHeaderFieldInvalid = 0
    fromEnum DBusMessageHeaderFieldPath = 1
    fromEnum DBusMessageHeaderFieldInterface = 2
    fromEnum DBusMessageHeaderFieldMember = 3
    fromEnum DBusMessageHeaderFieldErrorName = 4
    fromEnum DBusMessageHeaderFieldReplySerial = 5
    fromEnum DBusMessageHeaderFieldDestination = 6
    fromEnum DBusMessageHeaderFieldSender = 7
    fromEnum DBusMessageHeaderFieldSignature = 8
    fromEnum DBusMessageHeaderFieldNumUnixFds = 9
    fromEnum (AnotherDBusMessageHeaderField k) = k

    toEnum 0 = DBusMessageHeaderFieldInvalid
    toEnum 1 = DBusMessageHeaderFieldPath
    toEnum 2 = DBusMessageHeaderFieldInterface
    toEnum 3 = DBusMessageHeaderFieldMember
    toEnum 4 = DBusMessageHeaderFieldErrorName
    toEnum 5 = DBusMessageHeaderFieldReplySerial
    toEnum 6 = DBusMessageHeaderFieldDestination
    toEnum 7 = DBusMessageHeaderFieldSender
    toEnum 8 = DBusMessageHeaderFieldSignature
    toEnum 9 = DBusMessageHeaderFieldNumUnixFds
    toEnum k = AnotherDBusMessageHeaderField k

instance P.Ord DBusMessageHeaderField where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DBusMessageHeaderField = '[]
instance O.HasParentTypes DBusMessageHeaderField

foreign import ccall "g_dbus_message_header_field_get_type" c_g_dbus_message_header_field_get_type :: 
    IO GType

instance B.Types.TypedObject DBusMessageHeaderField where
    glibType = c_g_dbus_message_header_field_get_type

instance B.Types.BoxedEnum DBusMessageHeaderField

-- Enum DBusMessageByteOrder
-- | Enumeration used to describe the byte order of a D-Bus message.
-- 
-- /Since: 2.26/
data DBusMessageByteOrder = 
      DBusMessageByteOrderBigEndian
    -- ^ The byte order is big endian.
    | DBusMessageByteOrderLittleEndian
    -- ^ The byte order is little endian.
    | AnotherDBusMessageByteOrder Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DBusMessageByteOrder where
    fromEnum DBusMessageByteOrderBigEndian = 66
    fromEnum DBusMessageByteOrderLittleEndian = 108
    fromEnum (AnotherDBusMessageByteOrder k) = k

    toEnum 66 = DBusMessageByteOrderBigEndian
    toEnum 108 = DBusMessageByteOrderLittleEndian
    toEnum k = AnotherDBusMessageByteOrder k

instance P.Ord DBusMessageByteOrder where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DBusMessageByteOrder = '[]
instance O.HasParentTypes DBusMessageByteOrder

foreign import ccall "g_dbus_message_byte_order_get_type" c_g_dbus_message_byte_order_get_type :: 
    IO GType

instance B.Types.TypedObject DBusMessageByteOrder where
    glibType = c_g_dbus_message_byte_order_get_type

instance B.Types.BoxedEnum DBusMessageByteOrder

-- Enum DBusError
-- | Error codes for the @/G_DBUS_ERROR/@ error domain.
-- 
-- /Since: 2.26/
data DBusError = 
      DBusErrorFailed
    -- ^ A generic error; \"something went wrong\" - see the error message for
    -- more.
    | DBusErrorNoMemory
    -- ^ There was not enough memory to complete an operation.
    | DBusErrorServiceUnknown
    -- ^ The bus doesn\'t know how to launch a service to supply the bus name
    -- you wanted.
    | DBusErrorNameHasNoOwner
    -- ^ The bus name you referenced doesn\'t exist (i.e. no application owns
    -- it).
    | DBusErrorNoReply
    -- ^ No reply to a message expecting one, usually means a timeout occurred.
    | DBusErrorIoError
    -- ^ Something went wrong reading or writing to a socket, for example.
    | DBusErrorBadAddress
    -- ^ A D-Bus bus address was malformed.
    | DBusErrorNotSupported
    -- ^ Requested operation isn\'t supported (like ENOSYS on UNIX).
    | DBusErrorLimitsExceeded
    -- ^ Some limited resource is exhausted.
    | DBusErrorAccessDenied
    -- ^ Security restrictions don\'t allow doing what you\'re trying to do.
    | DBusErrorAuthFailed
    -- ^ Authentication didn\'t work.
    | DBusErrorNoServer
    -- ^ Unable to connect to server (probably caused by ECONNREFUSED on a
    -- socket).
    | DBusErrorTimeout
    -- ^ Certain timeout errors, possibly ETIMEDOUT on a socket.  Note that
    -- 'GI.Gio.Enums.DBusErrorNoReply' is used for message reply timeouts. Warning:
    -- this is confusingly-named given that 'GI.Gio.Enums.DBusErrorTimedOut' also
    -- exists. We can\'t fix it for compatibility reasons so just be
    -- careful.
    | DBusErrorNoNetwork
    -- ^ No network access (probably ENETUNREACH on a socket).
    | DBusErrorAddressInUse
    -- ^ Can\'t bind a socket since its address is in use (i.e. EADDRINUSE).
    | DBusErrorDisconnected
    -- ^ The connection is disconnected and you\'re trying to use it.
    | DBusErrorInvalidArgs
    -- ^ Invalid arguments passed to a method call.
    | DBusErrorFileNotFound
    -- ^ Missing file.
    | DBusErrorFileExists
    -- ^ Existing file and the operation you\'re using does not silently overwrite.
    | DBusErrorUnknownMethod
    -- ^ Method name you invoked isn\'t known by the object you invoked it on.
    | DBusErrorTimedOut
    -- ^ Certain timeout errors, e.g. while starting a service. Warning: this is
    -- confusingly-named given that 'GI.Gio.Enums.DBusErrorTimeout' also exists. We
    -- can\'t fix it for compatibility reasons so just be careful.
    | DBusErrorMatchRuleNotFound
    -- ^ Tried to remove or modify a match rule that didn\'t exist.
    | DBusErrorMatchRuleInvalid
    -- ^ The match rule isn\'t syntactically valid.
    | DBusErrorSpawnExecFailed
    -- ^ While starting a new process, the @/exec()/@ call failed.
    | DBusErrorSpawnForkFailed
    -- ^ While starting a new process, the @/fork()/@ call failed.
    | DBusErrorSpawnChildExited
    -- ^ While starting a new process, the child exited with a status code.
    | DBusErrorSpawnChildSignaled
    -- ^ While starting a new process, the child exited on a signal.
    | DBusErrorSpawnFailed
    -- ^ While starting a new process, something went wrong.
    | DBusErrorSpawnSetupFailed
    -- ^ We failed to setup the environment correctly.
    | DBusErrorSpawnConfigInvalid
    -- ^ We failed to setup the config parser correctly.
    | DBusErrorSpawnServiceInvalid
    -- ^ Bus name was not valid.
    | DBusErrorSpawnServiceNotFound
    -- ^ Service file not found in system-services directory.
    | DBusErrorSpawnPermissionsInvalid
    -- ^ Permissions are incorrect on the setuid helper.
    | DBusErrorSpawnFileInvalid
    -- ^ Service file invalid (Name, User or Exec missing).
    | DBusErrorSpawnNoMemory
    -- ^ Tried to get a UNIX process ID and it wasn\'t available.
    | DBusErrorUnixProcessIdUnknown
    -- ^ Tried to get a UNIX process ID and it wasn\'t available.
    | DBusErrorInvalidSignature
    -- ^ A type signature is not valid.
    | DBusErrorInvalidFileContent
    -- ^ A file contains invalid syntax or is otherwise broken.
    | DBusErrorSelinuxSecurityContextUnknown
    -- ^ Asked for SELinux security context and it wasn\'t available.
    | DBusErrorAdtAuditDataUnknown
    -- ^ Asked for ADT audit data and it wasn\'t available.
    | DBusErrorObjectPathInUse
    -- ^ There\'s already an object with the requested object path.
    | DBusErrorUnknownObject
    -- ^ Object you invoked a method on isn\'t known. Since 2.42
    | DBusErrorUnknownInterface
    -- ^ Interface you invoked a method on isn\'t known by the object. Since 2.42
    | DBusErrorUnknownProperty
    -- ^ Property you tried to access isn\'t known by the object. Since 2.42
    | DBusErrorPropertyReadOnly
    -- ^ Property you tried to set is read-only. Since 2.42
    | AnotherDBusError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DBusError where
    fromEnum DBusErrorFailed = 0
    fromEnum DBusErrorNoMemory = 1
    fromEnum DBusErrorServiceUnknown = 2
    fromEnum DBusErrorNameHasNoOwner = 3
    fromEnum DBusErrorNoReply = 4
    fromEnum DBusErrorIoError = 5
    fromEnum DBusErrorBadAddress = 6
    fromEnum DBusErrorNotSupported = 7
    fromEnum DBusErrorLimitsExceeded = 8
    fromEnum DBusErrorAccessDenied = 9
    fromEnum DBusErrorAuthFailed = 10
    fromEnum DBusErrorNoServer = 11
    fromEnum DBusErrorTimeout = 12
    fromEnum DBusErrorNoNetwork = 13
    fromEnum DBusErrorAddressInUse = 14
    fromEnum DBusErrorDisconnected = 15
    fromEnum DBusErrorInvalidArgs = 16
    fromEnum DBusErrorFileNotFound = 17
    fromEnum DBusErrorFileExists = 18
    fromEnum DBusErrorUnknownMethod = 19
    fromEnum DBusErrorTimedOut = 20
    fromEnum DBusErrorMatchRuleNotFound = 21
    fromEnum DBusErrorMatchRuleInvalid = 22
    fromEnum DBusErrorSpawnExecFailed = 23
    fromEnum DBusErrorSpawnForkFailed = 24
    fromEnum DBusErrorSpawnChildExited = 25
    fromEnum DBusErrorSpawnChildSignaled = 26
    fromEnum DBusErrorSpawnFailed = 27
    fromEnum DBusErrorSpawnSetupFailed = 28
    fromEnum DBusErrorSpawnConfigInvalid = 29
    fromEnum DBusErrorSpawnServiceInvalid = 30
    fromEnum DBusErrorSpawnServiceNotFound = 31
    fromEnum DBusErrorSpawnPermissionsInvalid = 32
    fromEnum DBusErrorSpawnFileInvalid = 33
    fromEnum DBusErrorSpawnNoMemory = 34
    fromEnum DBusErrorUnixProcessIdUnknown = 35
    fromEnum DBusErrorInvalidSignature = 36
    fromEnum DBusErrorInvalidFileContent = 37
    fromEnum DBusErrorSelinuxSecurityContextUnknown = 38
    fromEnum DBusErrorAdtAuditDataUnknown = 39
    fromEnum DBusErrorObjectPathInUse = 40
    fromEnum DBusErrorUnknownObject = 41
    fromEnum DBusErrorUnknownInterface = 42
    fromEnum DBusErrorUnknownProperty = 43
    fromEnum DBusErrorPropertyReadOnly = 44
    fromEnum (AnotherDBusError k) = k

    toEnum 0 = DBusErrorFailed
    toEnum 1 = DBusErrorNoMemory
    toEnum 2 = DBusErrorServiceUnknown
    toEnum 3 = DBusErrorNameHasNoOwner
    toEnum 4 = DBusErrorNoReply
    toEnum 5 = DBusErrorIoError
    toEnum 6 = DBusErrorBadAddress
    toEnum 7 = DBusErrorNotSupported
    toEnum 8 = DBusErrorLimitsExceeded
    toEnum 9 = DBusErrorAccessDenied
    toEnum 10 = DBusErrorAuthFailed
    toEnum 11 = DBusErrorNoServer
    toEnum 12 = DBusErrorTimeout
    toEnum 13 = DBusErrorNoNetwork
    toEnum 14 = DBusErrorAddressInUse
    toEnum 15 = DBusErrorDisconnected
    toEnum 16 = DBusErrorInvalidArgs
    toEnum 17 = DBusErrorFileNotFound
    toEnum 18 = DBusErrorFileExists
    toEnum 19 = DBusErrorUnknownMethod
    toEnum 20 = DBusErrorTimedOut
    toEnum 21 = DBusErrorMatchRuleNotFound
    toEnum 22 = DBusErrorMatchRuleInvalid
    toEnum 23 = DBusErrorSpawnExecFailed
    toEnum 24 = DBusErrorSpawnForkFailed
    toEnum 25 = DBusErrorSpawnChildExited
    toEnum 26 = DBusErrorSpawnChildSignaled
    toEnum 27 = DBusErrorSpawnFailed
    toEnum 28 = DBusErrorSpawnSetupFailed
    toEnum 29 = DBusErrorSpawnConfigInvalid
    toEnum 30 = DBusErrorSpawnServiceInvalid
    toEnum 31 = DBusErrorSpawnServiceNotFound
    toEnum 32 = DBusErrorSpawnPermissionsInvalid
    toEnum 33 = DBusErrorSpawnFileInvalid
    toEnum 34 = DBusErrorSpawnNoMemory
    toEnum 35 = DBusErrorUnixProcessIdUnknown
    toEnum 36 = DBusErrorInvalidSignature
    toEnum 37 = DBusErrorInvalidFileContent
    toEnum 38 = DBusErrorSelinuxSecurityContextUnknown
    toEnum 39 = DBusErrorAdtAuditDataUnknown
    toEnum 40 = DBusErrorObjectPathInUse
    toEnum 41 = DBusErrorUnknownObject
    toEnum 42 = DBusErrorUnknownInterface
    toEnum 43 = DBusErrorUnknownProperty
    toEnum 44 = DBusErrorPropertyReadOnly
    toEnum k = AnotherDBusError k

instance P.Ord DBusError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass DBusError where
    gerrorClassDomain _ = "g-dbus-error-quark"

-- | Catch exceptions of type `DBusError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchDBusError ::
    IO a ->
    (DBusError -> GErrorMessage -> IO a) ->
    IO a
catchDBusError = catchGErrorJustDomain

-- | Handle exceptions of type `DBusError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleDBusError ::
    (DBusError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleDBusError = handleGErrorJustDomain

type instance O.ParentTypes DBusError = '[]
instance O.HasParentTypes DBusError

foreign import ccall "g_dbus_error_get_type" c_g_dbus_error_get_type :: 
    IO GType

instance B.Types.TypedObject DBusError where
    glibType = c_g_dbus_error_get_type

instance B.Types.BoxedEnum DBusError

-- Enum CredentialsType
-- | Enumeration describing different kinds of native credential types.
-- 
-- /Since: 2.26/
data CredentialsType = 
      CredentialsTypeInvalid
    -- ^ Indicates an invalid native credential type.
    | CredentialsTypeLinuxUcred
    -- ^ The native credentials type is a @struct ucred@.
    | CredentialsTypeFreebsdCmsgcred
    -- ^ The native credentials type is a @struct cmsgcred@.
    | CredentialsTypeOpenbsdSockpeercred
    -- ^ The native credentials type is a @struct sockpeercred@. Added in 2.30.
    | CredentialsTypeSolarisUcred
    -- ^ The native credentials type is a @ucred_t@. Added in 2.40.
    | CredentialsTypeNetbsdUnpcbid
    -- ^ The native credentials type is a @struct unpcbid@. Added in 2.42.
    | CredentialsTypeAppleXucred
    -- ^ The native credentials type is a @struct xucred@. Added in 2.66.
    | CredentialsTypeWin32Pid
    -- ^ The native credentials type is a PID @DWORD@. Added in 2.72.
    | AnotherCredentialsType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum CredentialsType where
    fromEnum CredentialsTypeInvalid = 0
    fromEnum CredentialsTypeLinuxUcred = 1
    fromEnum CredentialsTypeFreebsdCmsgcred = 2
    fromEnum CredentialsTypeOpenbsdSockpeercred = 3
    fromEnum CredentialsTypeSolarisUcred = 4
    fromEnum CredentialsTypeNetbsdUnpcbid = 5
    fromEnum CredentialsTypeAppleXucred = 6
    fromEnum CredentialsTypeWin32Pid = 7
    fromEnum (AnotherCredentialsType k) = k

    toEnum 0 = CredentialsTypeInvalid
    toEnum 1 = CredentialsTypeLinuxUcred
    toEnum 2 = CredentialsTypeFreebsdCmsgcred
    toEnum 3 = CredentialsTypeOpenbsdSockpeercred
    toEnum 4 = CredentialsTypeSolarisUcred
    toEnum 5 = CredentialsTypeNetbsdUnpcbid
    toEnum 6 = CredentialsTypeAppleXucred
    toEnum 7 = CredentialsTypeWin32Pid
    toEnum k = AnotherCredentialsType k

instance P.Ord CredentialsType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes CredentialsType = '[]
instance O.HasParentTypes CredentialsType

foreign import ccall "g_credentials_type_get_type" c_g_credentials_type_get_type :: 
    IO GType

instance B.Types.TypedObject CredentialsType where
    glibType = c_g_credentials_type_get_type

instance B.Types.BoxedEnum CredentialsType

-- Enum ConverterResult
-- | Results returned from 'GI.Gio.Interfaces.Converter.converterConvert'.
-- 
-- /Since: 2.24/
data ConverterResult = 
      ConverterResultError
    -- ^ There was an error during conversion.
    | ConverterResultConverted
    -- ^ Some data was consumed or produced
    | ConverterResultFinished
    -- ^ The conversion is finished
    | ConverterResultFlushed
    -- ^ Flushing is finished
    | AnotherConverterResult Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ConverterResult where
    fromEnum ConverterResultError = 0
    fromEnum ConverterResultConverted = 1
    fromEnum ConverterResultFinished = 2
    fromEnum ConverterResultFlushed = 3
    fromEnum (AnotherConverterResult k) = k

    toEnum 0 = ConverterResultError
    toEnum 1 = ConverterResultConverted
    toEnum 2 = ConverterResultFinished
    toEnum 3 = ConverterResultFlushed
    toEnum k = AnotherConverterResult k

instance P.Ord ConverterResult where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ConverterResult = '[]
instance O.HasParentTypes ConverterResult

foreign import ccall "g_converter_result_get_type" c_g_converter_result_get_type :: 
    IO GType

instance B.Types.TypedObject ConverterResult where
    glibType = c_g_converter_result_get_type

instance B.Types.BoxedEnum ConverterResult

-- Enum BusType
-- | An enumeration for well-known message buses.
-- 
-- /Since: 2.26/
data BusType = 
      BusTypeStarter
    -- ^ An alias for the message bus that activated the process, if any.
    | BusTypeNone
    -- ^ Not a message bus.
    | BusTypeSystem
    -- ^ The system-wide message bus.
    | BusTypeSession
    -- ^ The login session message bus.
    | AnotherBusType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum BusType where
    fromEnum BusTypeStarter = -1
    fromEnum BusTypeNone = 0
    fromEnum BusTypeSystem = 1
    fromEnum BusTypeSession = 2
    fromEnum (AnotherBusType k) = k

    toEnum -1 = BusTypeStarter
    toEnum 0 = BusTypeNone
    toEnum 1 = BusTypeSystem
    toEnum 2 = BusTypeSession
    toEnum k = AnotherBusType k

instance P.Ord BusType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes BusType = '[]
instance O.HasParentTypes BusType

foreign import ccall "g_bus_type_get_type" c_g_bus_type_get_type :: 
    IO GType

instance B.Types.TypedObject BusType where
    glibType = c_g_bus_type_get_type

instance B.Types.BoxedEnum BusType


