{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An opaque object representing an animation.
-- 
-- The GdkPixBuf library provides a simple mechanism to load and
-- represent animations. An animation is conceptually a series of
-- frames to be displayed over time.
-- 
-- The animation may not be represented as a series of frames
-- internally; for example, it may be stored as a sprite and
-- instructions for moving the sprite around a background.
-- 
-- To display an animation you don\'t need to understand its
-- representation, however; you just ask @GdkPixbuf@ what should
-- be displayed at a given point in time.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkPixbuf.Objects.PixbufAnimation
    ( 

-- * Exported types
    PixbufAnimation(..)                     ,
    IsPixbufAnimation                       ,
    toPixbufAnimation                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isStaticImage]("GI.GdkPixbuf.Objects.PixbufAnimation#g:method:isStaticImage"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getHeight]("GI.GdkPixbuf.Objects.PixbufAnimation#g:method:getHeight"), [getIter]("GI.GdkPixbuf.Objects.PixbufAnimation#g:method:getIter"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getStaticImage]("GI.GdkPixbuf.Objects.PixbufAnimation#g:method:getStaticImage"), [getWidth]("GI.GdkPixbuf.Objects.PixbufAnimation#g:method:getWidth").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolvePixbufAnimationMethod            ,
#endif

-- ** getHeight #method:getHeight#

#if defined(ENABLE_OVERLOADING)
    PixbufAnimationGetHeightMethodInfo      ,
#endif
    pixbufAnimationGetHeight                ,


-- ** getIter #method:getIter#

#if defined(ENABLE_OVERLOADING)
    PixbufAnimationGetIterMethodInfo        ,
#endif
    pixbufAnimationGetIter                  ,


-- ** getStaticImage #method:getStaticImage#

#if defined(ENABLE_OVERLOADING)
    PixbufAnimationGetStaticImageMethodInfo ,
#endif
    pixbufAnimationGetStaticImage           ,


-- ** getWidth #method:getWidth#

#if defined(ENABLE_OVERLOADING)
    PixbufAnimationGetWidthMethodInfo       ,
#endif
    pixbufAnimationGetWidth                 ,


-- ** isStaticImage #method:isStaticImage#

#if defined(ENABLE_OVERLOADING)
    PixbufAnimationIsStaticImageMethodInfo  ,
#endif
    pixbufAnimationIsStaticImage            ,


-- ** newFromFile #method:newFromFile#

    pixbufAnimationNewFromFile              ,


-- ** newFromResource #method:newFromResource#

    pixbufAnimationNewFromResource          ,


-- ** newFromStream #method:newFromStream#

    pixbufAnimationNewFromStream            ,


-- ** newFromStreamAsync #method:newFromStreamAsync#

    pixbufAnimationNewFromStreamAsync       ,


-- ** newFromStreamFinish #method:newFromStreamFinish#

    pixbufAnimationNewFromStreamFinish      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GdkPixbuf.Callbacks as GdkPixbuf.Callbacks
import {-# SOURCE #-} qualified GI.GdkPixbuf.Enums as GdkPixbuf.Enums
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.PixbufAnimationIter as GdkPixbuf.PixbufAnimationIter
import {-# SOURCE #-} qualified GI.GdkPixbuf.Structs.PixbufFormat as GdkPixbuf.PixbufFormat
import {-# SOURCE #-} qualified GI.GdkPixbuf.Structs.PixbufModulePattern as GdkPixbuf.PixbufModulePattern
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream

#else
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.PixbufAnimationIter as GdkPixbuf.PixbufAnimationIter
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream

#endif

-- | Memory-managed wrapper type.
newtype PixbufAnimation = PixbufAnimation (SP.ManagedPtr PixbufAnimation)
    deriving (Eq)

instance SP.ManagedPtrNewtype PixbufAnimation where
    toManagedPtr (PixbufAnimation p) = p

foreign import ccall "gdk_pixbuf_animation_get_type"
    c_gdk_pixbuf_animation_get_type :: IO B.Types.GType

instance B.Types.TypedObject PixbufAnimation where
    glibType = c_gdk_pixbuf_animation_get_type

instance B.Types.GObject PixbufAnimation

-- | Type class for types which can be safely cast to t'PixbufAnimation', for instance with `toPixbufAnimation`.
class (SP.GObject o, O.IsDescendantOf PixbufAnimation o) => IsPixbufAnimation o
instance (SP.GObject o, O.IsDescendantOf PixbufAnimation o) => IsPixbufAnimation o

instance O.HasParentTypes PixbufAnimation
type instance O.ParentTypes PixbufAnimation = '[GObject.Object.Object]

-- | Cast to t'PixbufAnimation', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toPixbufAnimation :: (MIO.MonadIO m, IsPixbufAnimation o) => o -> m PixbufAnimation
toPixbufAnimation = MIO.liftIO . B.ManagedPtr.unsafeCastTo PixbufAnimation

-- | Convert t'PixbufAnimation' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PixbufAnimation) where
    gvalueGType_ = c_gdk_pixbuf_animation_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr PixbufAnimation)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr PixbufAnimation)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject PixbufAnimation ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolvePixbufAnimationMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePixbufAnimationMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePixbufAnimationMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePixbufAnimationMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePixbufAnimationMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePixbufAnimationMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePixbufAnimationMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePixbufAnimationMethod "isStaticImage" o = PixbufAnimationIsStaticImageMethodInfo
    ResolvePixbufAnimationMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePixbufAnimationMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePixbufAnimationMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePixbufAnimationMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePixbufAnimationMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePixbufAnimationMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePixbufAnimationMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePixbufAnimationMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePixbufAnimationMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePixbufAnimationMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePixbufAnimationMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePixbufAnimationMethod "getHeight" o = PixbufAnimationGetHeightMethodInfo
    ResolvePixbufAnimationMethod "getIter" o = PixbufAnimationGetIterMethodInfo
    ResolvePixbufAnimationMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePixbufAnimationMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePixbufAnimationMethod "getStaticImage" o = PixbufAnimationGetStaticImageMethodInfo
    ResolvePixbufAnimationMethod "getWidth" o = PixbufAnimationGetWidthMethodInfo
    ResolvePixbufAnimationMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePixbufAnimationMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePixbufAnimationMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePixbufAnimationMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePixbufAnimationMethod t PixbufAnimation, O.OverloadedMethod info PixbufAnimation p) => OL.IsLabel t (PixbufAnimation -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePixbufAnimationMethod t PixbufAnimation, O.OverloadedMethod info PixbufAnimation p, R.HasField t PixbufAnimation p) => R.HasField t PixbufAnimation p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePixbufAnimationMethod t PixbufAnimation, O.OverloadedMethodInfo info PixbufAnimation) => OL.IsLabel t (O.MethodProxy info PixbufAnimation) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PixbufAnimation
type instance O.AttributeList PixbufAnimation = PixbufAnimationAttributeList
type PixbufAnimationAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList PixbufAnimation = PixbufAnimationSignalList
type PixbufAnimationSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method PixbufAnimation::new_from_file
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Name of file to load, in the GLib file\n  name encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GdkPixbuf" , name = "PixbufAnimation" })
-- throws : True
-- Skip return : False

foreign import ccall "gdk_pixbuf_animation_new_from_file" gdk_pixbuf_animation_new_from_file :: 
    CString ->                              -- filename : TBasicType TFileName
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr PixbufAnimation)

{-# DEPRECATED pixbufAnimationNewFromFile ["(Since version 2.44)","Use a different image loading library for animatable assets"] #-}
-- | Creates a new animation by loading it from a file.
-- 
-- The file format is detected automatically.
-- 
-- If the file\'s format does not support multi-frame images, then an animation
-- with a single frame will be created.
-- 
-- Possible errors are in the @GDK_PIXBUF_ERROR@ and @G_FILE_ERROR@ domains.
pixbufAnimationNewFromFile ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: Name of file to load, in the GLib file
    --   name encoding
    -> m (Maybe PixbufAnimation)
    -- ^ __Returns:__ A newly-created animation /(Can throw 'Data.GI.Base.GError.GError')/
pixbufAnimationNewFromFile filename = liftIO $ do
    filename' <- stringToCString filename
    onException (do
        result <- propagateGError $ gdk_pixbuf_animation_new_from_file filename'
        maybeResult <- convertIfNonNull result $ \result' -> do
            result'' <- (wrapObject PixbufAnimation) result'
            return result''
        freeMem filename'
        return maybeResult
     ) (do
        freeMem filename'
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method PixbufAnimation::new_from_resource
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "resource_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the path of the resource file"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GdkPixbuf" , name = "PixbufAnimation" })
-- throws : True
-- Skip return : False

foreign import ccall "gdk_pixbuf_animation_new_from_resource" gdk_pixbuf_animation_new_from_resource :: 
    CString ->                              -- resource_path : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr PixbufAnimation)

{-# DEPRECATED pixbufAnimationNewFromResource ["(Since version 2.44)","Use a different image loading library for animatable assets"] #-}
-- | Creates a new pixbuf animation by loading an image from an resource.
-- 
-- The file format is detected automatically. If @NULL@ is returned, then
-- /@error@/ will be set.
-- 
-- /Since: 2.28/
pixbufAnimationNewFromResource ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@resourcePath@/: the path of the resource file
    -> m (Maybe PixbufAnimation)
    -- ^ __Returns:__ A newly-created animation /(Can throw 'Data.GI.Base.GError.GError')/
pixbufAnimationNewFromResource resourcePath = liftIO $ do
    resourcePath' <- textToCString resourcePath
    onException (do
        result <- propagateGError $ gdk_pixbuf_animation_new_from_resource resourcePath'
        maybeResult <- convertIfNonNull result $ \result' -> do
            result'' <- (wrapObject PixbufAnimation) result'
            return result''
        freeMem resourcePath'
        return maybeResult
     ) (do
        freeMem resourcePath'
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method PixbufAnimation::new_from_stream
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GInputStream` to load the pixbuf from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "optional `GCancellable` object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GdkPixbuf" , name = "PixbufAnimation" })
-- throws : True
-- Skip return : False

foreign import ccall "gdk_pixbuf_animation_new_from_stream" gdk_pixbuf_animation_new_from_stream :: 
    Ptr Gio.InputStream.InputStream ->      -- stream : TInterface (Name {namespace = "Gio", name = "InputStream"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr PixbufAnimation)

{-# DEPRECATED pixbufAnimationNewFromStream ["(Since version 2.44)","Use a different image loading library for animatable assets"] #-}
-- | Creates a new animation by loading it from an input stream.
-- 
-- The file format is detected automatically.
-- 
-- If @NULL@ is returned, then /@error@/ will be set.
-- 
-- The /@cancellable@/ can be used to abort the operation from another thread.
-- If the operation was cancelled, the error @G_IO_ERROR_CANCELLED@ will be
-- returned. Other possible errors are in the @GDK_PIXBUF_ERROR@ and
-- @G_IO_ERROR@ domains.
-- 
-- The stream is not closed.
-- 
-- /Since: 2.28/
pixbufAnimationNewFromStream ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a @GInputStream@ to load the pixbuf from
    -> Maybe (b)
    -- ^ /@cancellable@/: optional @GCancellable@ object
    -> m (Maybe PixbufAnimation)
    -- ^ __Returns:__ A newly-created animation /(Can throw 'Data.GI.Base.GError.GError')/
pixbufAnimationNewFromStream stream cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ gdk_pixbuf_animation_new_from_stream stream' maybeCancellable
        maybeResult <- convertIfNonNull result $ \result' -> do
            result'' <- (wrapObject PixbufAnimation) result'
            return result''
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        return maybeResult
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method PixbufAnimation::new_from_stream_finish
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "async_result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GdkPixbuf" , name = "PixbufAnimation" })
-- throws : True
-- Skip return : False

foreign import ccall "gdk_pixbuf_animation_new_from_stream_finish" gdk_pixbuf_animation_new_from_stream_finish :: 
    Ptr Gio.AsyncResult.AsyncResult ->      -- async_result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr PixbufAnimation)

{-# DEPRECATED pixbufAnimationNewFromStreamFinish ["(Since version 2.44)","Use a different image loading library for animatable assets"] #-}
-- | Finishes an asynchronous pixbuf animation creation operation started with
-- 'GI.GdkPixbuf.Objects.PixbufAnimation.pixbufAnimationNewFromStreamAsync'.
-- 
-- /Since: 2.28/
pixbufAnimationNewFromStreamFinish ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.AsyncResult.IsAsyncResult a) =>
    a
    -- ^ /@asyncResult@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'
    -> m (Maybe PixbufAnimation)
    -- ^ __Returns:__ the newly created animation /(Can throw 'Data.GI.Base.GError.GError')/
pixbufAnimationNewFromStreamFinish asyncResult = liftIO $ do
    asyncResult' <- unsafeManagedPtrCastPtr asyncResult
    onException (do
        result <- propagateGError $ gdk_pixbuf_animation_new_from_stream_finish asyncResult'
        maybeResult <- convertIfNonNull result $ \result' -> do
            result'' <- (wrapObject PixbufAnimation) result'
            return result''
        touchManagedPtr asyncResult
        return maybeResult
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method PixbufAnimation::get_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "animation"
--           , argType =
--               TInterface
--                 Name { namespace = "GdkPixbuf" , name = "PixbufAnimation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "An animation." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_animation_get_height" gdk_pixbuf_animation_get_height :: 
    Ptr PixbufAnimation ->                  -- animation : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufAnimation"})
    IO Int32

{-# DEPRECATED pixbufAnimationGetHeight ["(Since version 2.44)","Use a different image loading library for animatable assets"] #-}
-- | Queries the height of the bounding box of a pixbuf animation.
pixbufAnimationGetHeight ::
    (B.CallStack.HasCallStack, MonadIO m, IsPixbufAnimation a) =>
    a
    -- ^ /@animation@/: An animation.
    -> m Int32
    -- ^ __Returns:__ Height of the bounding box of the animation.
pixbufAnimationGetHeight animation = liftIO $ do
    animation' <- unsafeManagedPtrCastPtr animation
    result <- gdk_pixbuf_animation_get_height animation'
    touchManagedPtr animation
    return result

#if defined(ENABLE_OVERLOADING)
data PixbufAnimationGetHeightMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsPixbufAnimation a) => O.OverloadedMethod PixbufAnimationGetHeightMethodInfo a signature where
    overloadedMethod = pixbufAnimationGetHeight

instance O.OverloadedMethodInfo PixbufAnimationGetHeightMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Objects.PixbufAnimation.pixbufAnimationGetHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Objects-PixbufAnimation.html#v:pixbufAnimationGetHeight"
        })


#endif

-- method PixbufAnimation::get_iter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "animation"
--           , argType =
--               TInterface
--                 Name { namespace = "GdkPixbuf" , name = "PixbufAnimation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkPixbufAnimation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start_time"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TimeVal" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "time when the animation starts playing"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GdkPixbuf" , name = "PixbufAnimationIter" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_animation_get_iter" gdk_pixbuf_animation_get_iter :: 
    Ptr PixbufAnimation ->                  -- animation : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufAnimation"})
    Ptr GLib.TimeVal.TimeVal ->             -- start_time : TInterface (Name {namespace = "GLib", name = "TimeVal"})
    IO (Ptr GdkPixbuf.PixbufAnimationIter.PixbufAnimationIter)

{-# DEPRECATED pixbufAnimationGetIter ["(Since version 2.44)","Use a different image loading library for animatable assets"] #-}
-- | Get an iterator for displaying an animation.
-- 
-- The iterator provides the frames that should be displayed at a
-- given time.
-- 
-- /@startTime@/ would normally come from 'GI.GLib.Functions.getCurrentTime', and marks
-- the beginning of animation playback. After creating an iterator, you
-- should immediately display the pixbuf returned by
-- 'GI.GdkPixbuf.Objects.PixbufAnimationIter.pixbufAnimationIterGetPixbuf'. Then, you should install
-- a timeout (with @/g_timeout_add()/@) or by some other mechanism ensure
-- that you\'ll update the image after
-- 'GI.GdkPixbuf.Objects.PixbufAnimationIter.pixbufAnimationIterGetDelayTime' milliseconds. Each time
-- the image is updated, you should reinstall the timeout with the new,
-- possibly-changed delay time.
-- 
-- As a shortcut, if /@startTime@/ is @NULL@, the result of
-- 'GI.GLib.Functions.getCurrentTime' will be used automatically.
-- 
-- To update the image (i.e. possibly change the result of
-- 'GI.GdkPixbuf.Objects.PixbufAnimationIter.pixbufAnimationIterGetPixbuf' to a new frame of the animation),
-- call 'GI.GdkPixbuf.Objects.PixbufAnimationIter.pixbufAnimationIterAdvance'.
-- 
-- If you\'re using t'GI.GdkPixbuf.Objects.PixbufLoader.PixbufLoader', in addition to updating the image
-- after the delay time, you should also update it whenever you
-- receive the area_updated signal and
-- 'GI.GdkPixbuf.Objects.PixbufAnimationIter.pixbufAnimationIterOnCurrentlyLoadingFrame' returns
-- @TRUE@. In this case, the frame currently being fed into the loader
-- has received new data, so needs to be refreshed. The delay time for
-- a frame may also be modified after an area_updated signal, for
-- example if the delay time for a frame is encoded in the data after
-- the frame itself. So your timeout should be reinstalled after any
-- area_updated signal.
-- 
-- A delay time of -1 is possible, indicating \"infinite\".
pixbufAnimationGetIter ::
    (B.CallStack.HasCallStack, MonadIO m, IsPixbufAnimation a) =>
    a
    -- ^ /@animation@/: a t'GI.GdkPixbuf.Objects.PixbufAnimation.PixbufAnimation'
    -> Maybe (GLib.TimeVal.TimeVal)
    -- ^ /@startTime@/: time when the animation starts playing
    -> m GdkPixbuf.PixbufAnimationIter.PixbufAnimationIter
    -- ^ __Returns:__ an iterator to move over the animation
pixbufAnimationGetIter animation startTime = liftIO $ do
    animation' <- unsafeManagedPtrCastPtr animation
    maybeStartTime <- case startTime of
        Nothing -> return FP.nullPtr
        Just jStartTime -> do
            jStartTime' <- unsafeManagedPtrGetPtr jStartTime
            return jStartTime'
    result <- gdk_pixbuf_animation_get_iter animation' maybeStartTime
    checkUnexpectedReturnNULL "pixbufAnimationGetIter" result
    result' <- (wrapObject GdkPixbuf.PixbufAnimationIter.PixbufAnimationIter) result
    touchManagedPtr animation
    whenJust startTime touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data PixbufAnimationGetIterMethodInfo
instance (signature ~ (Maybe (GLib.TimeVal.TimeVal) -> m GdkPixbuf.PixbufAnimationIter.PixbufAnimationIter), MonadIO m, IsPixbufAnimation a) => O.OverloadedMethod PixbufAnimationGetIterMethodInfo a signature where
    overloadedMethod = pixbufAnimationGetIter

instance O.OverloadedMethodInfo PixbufAnimationGetIterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Objects.PixbufAnimation.pixbufAnimationGetIter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Objects-PixbufAnimation.html#v:pixbufAnimationGetIter"
        })


#endif

-- method PixbufAnimation::get_static_image
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "animation"
--           , argType =
--               TInterface
--                 Name { namespace = "GdkPixbuf" , name = "PixbufAnimation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkPixbufAnimation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_animation_get_static_image" gdk_pixbuf_animation_get_static_image :: 
    Ptr PixbufAnimation ->                  -- animation : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufAnimation"})
    IO (Ptr GdkPixbuf.Pixbuf.Pixbuf)

{-# DEPRECATED pixbufAnimationGetStaticImage ["(Since version 2.44)","Use a different image loading library for animatable assets"] #-}
-- | Retrieves a static image for the animation.
-- 
-- If an animation is really just a plain image (has only one frame),
-- this function returns that image.
-- 
-- If the animation is an animation, this function returns a reasonable
-- image to use as a static unanimated image, which might be the first
-- frame, or something more sophisticated depending on the file format.
-- 
-- If an animation hasn\'t loaded any frames yet, this function will
-- return @NULL@.
pixbufAnimationGetStaticImage ::
    (B.CallStack.HasCallStack, MonadIO m, IsPixbufAnimation a) =>
    a
    -- ^ /@animation@/: a t'GI.GdkPixbuf.Objects.PixbufAnimation.PixbufAnimation'
    -> m GdkPixbuf.Pixbuf.Pixbuf
    -- ^ __Returns:__ unanimated image representing the animation
pixbufAnimationGetStaticImage animation = liftIO $ do
    animation' <- unsafeManagedPtrCastPtr animation
    result <- gdk_pixbuf_animation_get_static_image animation'
    checkUnexpectedReturnNULL "pixbufAnimationGetStaticImage" result
    result' <- (newObject GdkPixbuf.Pixbuf.Pixbuf) result
    touchManagedPtr animation
    return result'

#if defined(ENABLE_OVERLOADING)
data PixbufAnimationGetStaticImageMethodInfo
instance (signature ~ (m GdkPixbuf.Pixbuf.Pixbuf), MonadIO m, IsPixbufAnimation a) => O.OverloadedMethod PixbufAnimationGetStaticImageMethodInfo a signature where
    overloadedMethod = pixbufAnimationGetStaticImage

instance O.OverloadedMethodInfo PixbufAnimationGetStaticImageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Objects.PixbufAnimation.pixbufAnimationGetStaticImage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Objects-PixbufAnimation.html#v:pixbufAnimationGetStaticImage"
        })


#endif

-- method PixbufAnimation::get_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "animation"
--           , argType =
--               TInterface
--                 Name { namespace = "GdkPixbuf" , name = "PixbufAnimation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "An animation." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_animation_get_width" gdk_pixbuf_animation_get_width :: 
    Ptr PixbufAnimation ->                  -- animation : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufAnimation"})
    IO Int32

{-# DEPRECATED pixbufAnimationGetWidth ["(Since version 2.44)","Use a different image loading library for animatable assets"] #-}
-- | Queries the width of the bounding box of a pixbuf animation.
pixbufAnimationGetWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsPixbufAnimation a) =>
    a
    -- ^ /@animation@/: An animation.
    -> m Int32
    -- ^ __Returns:__ Width of the bounding box of the animation.
pixbufAnimationGetWidth animation = liftIO $ do
    animation' <- unsafeManagedPtrCastPtr animation
    result <- gdk_pixbuf_animation_get_width animation'
    touchManagedPtr animation
    return result

#if defined(ENABLE_OVERLOADING)
data PixbufAnimationGetWidthMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsPixbufAnimation a) => O.OverloadedMethod PixbufAnimationGetWidthMethodInfo a signature where
    overloadedMethod = pixbufAnimationGetWidth

instance O.OverloadedMethodInfo PixbufAnimationGetWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Objects.PixbufAnimation.pixbufAnimationGetWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Objects-PixbufAnimation.html#v:pixbufAnimationGetWidth"
        })


#endif

-- method PixbufAnimation::is_static_image
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "animation"
--           , argType =
--               TInterface
--                 Name { namespace = "GdkPixbuf" , name = "PixbufAnimation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkPixbufAnimation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_animation_is_static_image" gdk_pixbuf_animation_is_static_image :: 
    Ptr PixbufAnimation ->                  -- animation : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufAnimation"})
    IO CInt

{-# DEPRECATED pixbufAnimationIsStaticImage ["(Since version 2.44)","Use a different image loading library for animatable assets"] #-}
-- | Checks whether the animation is a static image.
-- 
-- If you load a file with 'GI.GdkPixbuf.Objects.PixbufAnimation.pixbufAnimationNewFromFile' and it
-- turns out to be a plain, unanimated image, then this function will
-- return @TRUE@. Use 'GI.GdkPixbuf.Objects.PixbufAnimation.pixbufAnimationGetStaticImage' to retrieve
-- the image.
pixbufAnimationIsStaticImage ::
    (B.CallStack.HasCallStack, MonadIO m, IsPixbufAnimation a) =>
    a
    -- ^ /@animation@/: a t'GI.GdkPixbuf.Objects.PixbufAnimation.PixbufAnimation'
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if the \"animation\" was really just an image
pixbufAnimationIsStaticImage animation = liftIO $ do
    animation' <- unsafeManagedPtrCastPtr animation
    result <- gdk_pixbuf_animation_is_static_image animation'
    let result' = (/= 0) result
    touchManagedPtr animation
    return result'

#if defined(ENABLE_OVERLOADING)
data PixbufAnimationIsStaticImageMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPixbufAnimation a) => O.OverloadedMethod PixbufAnimationIsStaticImageMethodInfo a signature where
    overloadedMethod = pixbufAnimationIsStaticImage

instance O.OverloadedMethodInfo PixbufAnimationIsStaticImageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Objects.PixbufAnimation.pixbufAnimationIsStaticImage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Objects-PixbufAnimation.html#v:pixbufAnimationIsStaticImage"
        })


#endif

-- method PixbufAnimation::new_from_stream_async
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GInputStream from which to load the animation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "optional #GCancellable object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `GAsyncReadyCallback` to call when the pixbuf is loaded"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to the callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_animation_new_from_stream_async" gdk_pixbuf_animation_new_from_stream_async :: 
    Ptr Gio.InputStream.InputStream ->      -- stream : TInterface (Name {namespace = "Gio", name = "InputStream"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

{-# DEPRECATED pixbufAnimationNewFromStreamAsync ["(Since version 2.44)","Use a different image loading library for animatable assets"] #-}
-- | Creates a new animation by asynchronously loading an image from an input stream.
-- 
-- For more details see 'GI.GdkPixbuf.Objects.Pixbuf.pixbufNewFromStream', which is the synchronous
-- version of this function.
-- 
-- When the operation is finished, @callback@ will be called in the main thread.
-- You can then call 'GI.GdkPixbuf.Objects.PixbufAnimation.pixbufAnimationNewFromStreamFinish' to get the
-- result of the operation.
-- 
-- /Since: 2.28/
pixbufAnimationNewFromStreamAsync ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.InputStream.InputStream' from which to load the animation
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a @GAsyncReadyCallback@ to call when the pixbuf is loaded
    -> m ()
pixbufAnimationNewFromStreamAsync stream cancellable callback = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    gdk_pixbuf_animation_new_from_stream_async stream' maybeCancellable maybeCallback userData
    touchManagedPtr stream
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
#endif


