/* window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from window.vala, do not modify */

/* SPDX-License-Identifier: GPL-3.0-or-later*/

#include "graphs.h"
#include <gtk/gtk.h>
#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRAPHS_WINDOW_0_PROPERTY,
	GRAPHS_WINDOW_UNDO_BUTTON_PROPERTY,
	GRAPHS_WINDOW_REDO_BUTTON_PROPERTY,
	GRAPHS_WINDOW_VIEW_BACK_BUTTON_PROPERTY,
	GRAPHS_WINDOW_VIEW_FORWARD_BUTTON_PROPERTY,
	GRAPHS_WINDOW_PAN_BUTTON_PROPERTY,
	GRAPHS_WINDOW_SHIFT_BUTTON_PROPERTY,
	GRAPHS_WINDOW_CUT_BUTTON_PROPERTY,
	GRAPHS_WINDOW_TRANSLATE_X_ENTRY_PROPERTY,
	GRAPHS_WINDOW_TRANSLATE_Y_ENTRY_PROPERTY,
	GRAPHS_WINDOW_MULTIPLY_X_ENTRY_PROPERTY,
	GRAPHS_WINDOW_MULTIPLY_Y_ENTRY_PROPERTY,
	GRAPHS_WINDOW_TRANSLATE_X_BUTTON_PROPERTY,
	GRAPHS_WINDOW_TRANSLATE_Y_BUTTON_PROPERTY,
	GRAPHS_WINDOW_MULTIPLY_X_BUTTON_PROPERTY,
	GRAPHS_WINDOW_MULTIPLY_Y_BUTTON_PROPERTY,
	GRAPHS_WINDOW_ITEM_LIST_PROPERTY,
	GRAPHS_WINDOW_SPLIT_VIEW_PROPERTY,
	GRAPHS_WINDOW_CONTENT_TITLE_PROPERTY,
	GRAPHS_WINDOW_MODE_PROPERTY,
	GRAPHS_WINDOW_CANVAS_PROPERTY,
	GRAPHS_WINDOW_HEADERBAR_PROVIDER_PROPERTY,
	GRAPHS_WINDOW_NUM_PROPERTIES
};
static GParamSpec* graphs_window_properties[GRAPHS_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block16Data Block16Data;

struct _GraphsWindowPrivate {
	GtkButton* _undo_button;
	GtkButton* _redo_button;
	GtkButton* _view_back_button;
	GtkButton* _view_forward_button;
	GtkMenuButton* _view_menu_button;
	GtkToggleButton* _pan_button;
	GtkToggleButton* _zoom_button;
	GtkToggleButton* _select_button;
	GtkBox* _stack_switcher_box;
	GtkStack* _stack;
	GtkButton* _shift_button;
	GtkButton* _cut_button;
	GtkEntry* _translate_x_entry;
	GtkEntry* _translate_y_entry;
	GtkEntry* _multiply_x_entry;
	GtkEntry* _multiply_y_entry;
	GtkButton* _translate_x_button;
	GtkButton* _translate_y_button;
	GtkButton* _multiply_x_button;
	GtkButton* _multiply_y_button;
	GtkListBox* _item_list;
	AdwOverlaySplitView* _split_view;
	AdwToastOverlay* _toast_overlay;
	AdwHeaderBar* _content_headerbar;
	AdwWindowTitle* _content_title;
	GtkCssProvider* _headerbar_provider;
};

struct _Block16Data {
	int _ref_count_;
	GraphsWindow* self;
	GFile* file;
};

static gint GraphsWindow_private_offset;
static gpointer graphs_window_parent_class = NULL;

static GtkStack* graphs_window_get_stack (GraphsWindow* self);
static GtkBox* graphs_window_get_stack_switcher_box (GraphsWindow* self);
static void graphs_window_set_headerbar_provider (GraphsWindow* self,
                                           GtkCssProvider* value);
static AdwHeaderBar* graphs_window_get_content_headerbar (GraphsWindow* self);
static void graphs_window_perform_operation (GraphsWindow* self,
                                      GtkButton* button);
static void _graphs_window_perform_operation_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
static AdwToastOverlay* graphs_window_get_toast_overlay (GraphsWindow* self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void __lambda11_ (Block16Data* _data16_);
static void ___lambda11__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void graphs_window_on_sidebar_toggle (GraphsWindow* self);
static void _graphs_window_on_sidebar_toggle_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static GtkMenuButton* graphs_window_get_view_menu_button (GraphsWindow* self);
static GtkToggleButton* graphs_window_get_zoom_button (GraphsWindow* self);
static GtkToggleButton* graphs_window_get_select_button (GraphsWindow* self);
static void graphs_window_finalize (GObject * obj);
static GType graphs_window_get_type_once (void);
static void _vala_graphs_window_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_graphs_window_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

VALA_EXTERN const gchar* GRAPHS_DIRECTION_NAMES[4];

static inline gpointer
graphs_window_get_instance_private (GraphsWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GraphsWindow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GraphsWindow*
graphs_window_construct (GType object_type,
                         GraphsApplication* application)
{
	GraphsWindow * self = NULL;
	GraphsData* data = NULL;
	GraphsData* _tmp0_;
	GraphsData* _tmp1_;
	GraphsData* _tmp2_;
	GraphsData* _tmp3_;
	GtkButton* _tmp4_;
	GraphsData* _tmp5_;
	GtkListBox* _tmp6_;
	GraphsInlineStackSwitcher* stack_switcher = NULL;
	GraphsInlineStackSwitcher* _tmp7_;
	GraphsInlineStackSwitcher* _tmp8_;
	GtkStack* _tmp9_;
	GraphsInlineStackSwitcher* _tmp10_;
	GraphsInlineStackSwitcher* _tmp11_;
	GtkBox* _tmp12_;
	GraphsInlineStackSwitcher* _tmp13_;
	GtkCssProvider* _tmp14_;
	GtkCssProvider* _tmp15_;
	GtkStyleContext* context = NULL;
	AdwHeaderBar* _tmp16_;
	GtkStyleContext* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkCssProvider* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	g_return_val_if_fail (application != NULL, NULL);
	self = (GraphsWindow*) g_object_new (object_type, "application", application, NULL);
	_tmp0_ = graphs_application_get_data (application);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	data = _tmp2_;
	_tmp3_ = data;
	_tmp4_ = self->priv->_shift_button;
	g_object_bind_property_with_closures ((GObject*) _tmp3_, "items_selected", (GObject*) _tmp4_, "sensitive", 2, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp5_ = data;
	_tmp6_ = self->priv->_item_list;
	g_object_bind_property_with_closures ((GObject*) _tmp5_, "empty", (GObject*) _tmp6_, "visible", 4, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp7_ = graphs_inline_stack_switcher_new ();
	g_object_ref_sink (_tmp7_);
	stack_switcher = _tmp7_;
	_tmp8_ = stack_switcher;
	_tmp9_ = self->priv->_stack;
	graphs_inline_stack_switcher_set_stack (_tmp8_, _tmp9_);
	_tmp10_ = stack_switcher;
	gtk_widget_add_css_class ((GtkWidget*) _tmp10_, "compact");
	_tmp11_ = stack_switcher;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp11_, TRUE);
	_tmp12_ = self->priv->_stack_switcher_box;
	_tmp13_ = stack_switcher;
	gtk_box_prepend (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = gtk_css_provider_new ();
	_tmp15_ = _tmp14_;
	graphs_window_set_headerbar_provider (self, _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = self->priv->_content_headerbar;
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
	_tmp18_ = _g_object_ref0 (_tmp17_);
	context = _tmp18_;
	_tmp19_ = context;
	_tmp20_ = self->priv->_headerbar_provider;
	gtk_style_context_add_provider (_tmp19_, (GtkStyleProvider*) _tmp20_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp21_ = graphs_application_get_debug (application);
	_tmp22_ = _tmp21_;
	if (_tmp22_) {
		gtk_widget_add_css_class ((GtkWidget*) self, "devel");
		gtk_window_set_title ((GtkWindow*) self, _ ("Graphs (Development)"));
	}
	_g_object_unref0 (context);
	_g_object_unref0 (stack_switcher);
	_g_object_unref0 (data);
	return self;
}

GraphsWindow*
graphs_window_new (GraphsApplication* application)
{
	return graphs_window_construct (GRAPHS_TYPE_WINDOW, application);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
graphs_window_perform_operation (GraphsWindow* self,
                                 GtkButton* button)
{
	GAction* action = NULL;
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	GAction* _tmp2_;
	GAction* _tmp3_;
	gchar* name = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp1_, "app.perform_operation");
	_tmp3_ = _g_object_ref0 (_tmp2_);
	action = _tmp3_;
	_tmp4_ = gtk_buildable_get_buildable_id ((GtkBuildable*) button);
	_tmp5_ = string_slice (_tmp4_, (glong) 0, (glong) -7);
	name = _tmp5_;
	_tmp6_ = g_variant_new_string (name);
	g_variant_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	g_action_activate (action, _tmp7_);
	_g_variant_unref0 (_tmp7_);
	_g_free0 (name);
	_g_object_unref0 (action);
}

static void
_graphs_window_perform_operation_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	graphs_window_perform_operation ((GraphsWindow*) self, _sender);
}

/**
         * Add a toast to the window.
         */
void
graphs_window_add_toast (GraphsWindow* self,
                         AdwToast* toast)
{
	AdwToastOverlay* _tmp0_;
	AdwToast* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (toast != NULL);
	_tmp0_ = self->priv->_toast_overlay;
	_tmp1_ = _g_object_ref0 (toast);
	adw_toast_overlay_add_toast (_tmp0_, _tmp1_);
}

/**
         * Add a toast to the window.
         *
         * The toast is created automatically with the given title.
         */
void
graphs_window_add_toast_string (GraphsWindow* self,
                                const gchar* title)
{
	AdwToast* _tmp0_;
	AdwToast* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = adw_toast_new (title);
	_tmp1_ = _tmp0_;
	graphs_window_add_toast (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
}

/**
         * Add a toast to the window.
         *
         * The toast is created automatically with the given title.
         * An action is automatically created, to open the containing folder
         * of file.
         */
static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		GraphsWindow* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->file);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static void
__lambda11_ (Block16Data* _data16_)
{
	GraphsWindow* self;
	self = _data16_->self;
	graphs_tools_open_file_location (_data16_->file);
}

static void
___lambda11__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda11_ (self);
}

void
graphs_window_add_toast_string_with_file (GraphsWindow* self,
                                          const gchar* title,
                                          GFile* file)
{
	Block16Data* _data16_;
	GFile* _tmp0_;
	GSimpleAction* action = NULL;
	GSimpleAction* _tmp1_;
	GtkApplication* _tmp2_;
	GtkApplication* _tmp3_;
	AdwToast* toast = NULL;
	AdwToast* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (file != NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data16_->file);
	_data16_->file = _tmp0_;
	_tmp1_ = g_simple_action_new ("open-file-location", NULL);
	action = _tmp1_;
	g_signal_connect_data (action, "activate", (GCallback) ___lambda11__g_simple_action_activate, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
	_tmp2_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp3_ = _tmp2_;
	g_action_map_add_action ((GActionMap*) _tmp3_, (GAction*) action);
	_tmp4_ = adw_toast_new (title);
	toast = _tmp4_;
	adw_toast_set_button_label (toast, _ ("Open Location"));
	adw_toast_set_action_name (toast, "app.open-file-location");
	graphs_window_add_toast (self, toast);
	_g_object_unref0 (toast);
	_g_object_unref0 (action);
	block16_data_unref (_data16_);
	_data16_ = NULL;
}

static void
graphs_window_on_sidebar_toggle (GraphsWindow* self)
{
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	GAction* _tmp2_;
	AdwOverlaySplitView* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp1_, "toggle_sidebar");
	_tmp3_ = self->priv->_split_view;
	_tmp4_ = g_variant_new_boolean (adw_overlay_split_view_get_collapsed (_tmp3_));
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_action_change_state (_tmp2_, _tmp5_);
	_g_variant_unref0 (_tmp5_);
}

static void
_graphs_window_on_sidebar_toggle_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	graphs_window_on_sidebar_toggle ((GraphsWindow*) self);
}

/**
         * Repopulate the view menu
         */
static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
graphs_window_update_view_menu (GraphsWindow* self)
{
	GMenu* view_menu = NULL;
	GMenu* _tmp0_;
	GMenu* toggle_section = NULL;
	GMenu* _tmp1_;
	GMenu* _tmp2_;
	GMenuItem* _tmp3_;
	GMenuItem* _tmp4_;
	GMenu* _tmp5_;
	GMenu* _tmp6_;
	GMenu* optimize_section = NULL;
	GMenu* _tmp7_;
	GMenu* _tmp8_;
	GMenuItem* _tmp9_;
	GMenuItem* _tmp10_;
	GMenu* _tmp11_;
	GMenu* _tmp12_;
	gchar** scale_names = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gint scale_names_length1;
	gint _scale_names_size_;
	GMenu* scales_section = NULL;
	GMenu* _tmp19_;
	GraphsApplication* application = NULL;
	GtkApplication* _tmp20_;
	GtkApplication* _tmp21_;
	GraphsApplication* _tmp22_;
	gboolean* visible_axes = NULL;
	GraphsApplication* _tmp23_;
	GraphsData* _tmp24_;
	GraphsData* _tmp25_;
	gint _tmp26_ = 0;
	gboolean* _tmp27_;
	gint visible_axes_length1;
	gint _visible_axes_size_;
	gboolean _tmp28_ = FALSE;
	gboolean* _tmp29_;
	gint _tmp29__length1;
	gboolean _tmp30_;
	gboolean both_x = FALSE;
	gboolean _tmp33_ = FALSE;
	gboolean* _tmp34_;
	gint _tmp34__length1;
	gboolean _tmp35_;
	gboolean both_y = FALSE;
	GMenu* _tmp74_;
	GMenu* _tmp75_;
	GtkMenuButton* _tmp76_;
	GMenu* _tmp77_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_menu_new ();
	view_menu = _tmp0_;
	_tmp1_ = g_menu_new ();
	toggle_section = _tmp1_;
	_tmp2_ = toggle_section;
	_tmp3_ = g_menu_item_new (_ ("Toggle Sidebar"), "app.toggle_sidebar");
	_tmp4_ = _tmp3_;
	g_menu_append_item (_tmp2_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = view_menu;
	_tmp6_ = toggle_section;
	g_menu_append_section (_tmp5_, NULL, (GMenuModel*) _tmp6_);
	_tmp7_ = g_menu_new ();
	optimize_section = _tmp7_;
	_tmp8_ = optimize_section;
	_tmp9_ = g_menu_item_new (_ ("Optimize Limits"), "app.optimize_limits");
	_tmp10_ = _tmp9_;
	g_menu_append_item (_tmp8_, _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = view_menu;
	_tmp12_ = optimize_section;
	g_menu_append_section (_tmp11_, NULL, (GMenuModel*) _tmp12_);
	_tmp13_ = g_strdup (C_ ("scale", "Linear"));
	_tmp14_ = g_strdup (C_ ("scale", "Logarithmic"));
	_tmp15_ = g_strdup (C_ ("scale", "Radians"));
	_tmp16_ = g_strdup (C_ ("scale", "Square Root"));
	_tmp17_ = g_strdup (C_ ("scale", "Inverse Root"));
	_tmp18_ = g_new0 (gchar*, 5 + 1);
	_tmp18_[0] = _tmp13_;
	_tmp18_[1] = _tmp14_;
	_tmp18_[2] = _tmp15_;
	_tmp18_[3] = _tmp16_;
	_tmp18_[4] = _tmp17_;
	scale_names = _tmp18_;
	scale_names_length1 = 5;
	_scale_names_size_ = scale_names_length1;
	_tmp19_ = g_menu_new ();
	scales_section = _tmp19_;
	_tmp20_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GRAPHS_TYPE_APPLICATION, GraphsApplication));
	application = _tmp22_;
	_tmp23_ = application;
	_tmp24_ = graphs_application_get_data (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp27_ = graphs_data_get_used_positions (_tmp25_, &_tmp26_);
	visible_axes = _tmp27_;
	visible_axes_length1 = _tmp26_;
	_visible_axes_size_ = visible_axes_length1;
	_tmp29_ = visible_axes;
	_tmp29__length1 = visible_axes_length1;
	_tmp30_ = _tmp29_[0];
	if (_tmp30_) {
		gboolean* _tmp31_;
		gint _tmp31__length1;
		gboolean _tmp32_;
		_tmp31_ = visible_axes;
		_tmp31__length1 = visible_axes_length1;
		_tmp32_ = _tmp31_[1];
		_tmp28_ = _tmp32_;
	} else {
		_tmp28_ = FALSE;
	}
	both_x = _tmp28_;
	_tmp34_ = visible_axes;
	_tmp34__length1 = visible_axes_length1;
	_tmp35_ = _tmp34_[2];
	if (_tmp35_) {
		gboolean* _tmp36_;
		gint _tmp36__length1;
		gboolean _tmp37_;
		_tmp36_ = visible_axes;
		_tmp36__length1 = visible_axes_length1;
		_tmp37_ = _tmp36_[3];
		_tmp33_ = _tmp37_;
	} else {
		_tmp33_ = FALSE;
	}
	both_y = _tmp33_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp38_ = FALSE;
			_tmp38_ = TRUE;
			while (TRUE) {
				gboolean* _tmp40_;
				gint _tmp40__length1;
				gboolean _tmp41_;
				gchar* direction = NULL;
				const gchar* _tmp42_;
				gchar* _tmp43_;
				GMenu* scale_section = NULL;
				GMenu* _tmp44_;
				gchar* label = NULL;
				GMenu* _tmp71_;
				const gchar* _tmp72_;
				GMenu* _tmp73_;
				if (!_tmp38_) {
					gint _tmp39_;
					_tmp39_ = i;
					i = _tmp39_ + 1;
				}
				_tmp38_ = FALSE;
				if (!(i < G_N_ELEMENTS (GRAPHS_DIRECTION_NAMES))) {
					break;
				}
				_tmp40_ = visible_axes;
				_tmp40__length1 = visible_axes_length1;
				_tmp41_ = _tmp40_[i];
				if (!_tmp41_) {
					continue;
				}
				_tmp42_ = GRAPHS_DIRECTION_NAMES[i];
				_tmp43_ = g_strdup (_tmp42_);
				direction = _tmp43_;
				_tmp44_ = g_menu_new ();
				scale_section = _tmp44_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp45_ = FALSE;
						_tmp45_ = TRUE;
						while (TRUE) {
							gchar** _tmp47_;
							gint _tmp47__length1;
							gchar* scale = NULL;
							gchar** _tmp48_;
							gint _tmp48__length1;
							const gchar* _tmp49_;
							gchar* _tmp50_;
							GMenuItem* scale_item = NULL;
							const gchar* _tmp51_;
							const gchar* _tmp52_;
							const gchar* _tmp53_;
							gchar* _tmp54_;
							gchar* _tmp55_;
							GMenuItem* _tmp56_;
							GMenuItem* _tmp57_;
							GMenuItem* _tmp58_;
							gchar* _tmp59_;
							gchar* _tmp60_;
							GVariant* _tmp61_;
							GVariant* _tmp62_;
							GMenu* _tmp63_;
							GMenuItem* _tmp64_;
							if (!_tmp45_) {
								gint _tmp46_;
								_tmp46_ = j;
								j = _tmp46_ + 1;
							}
							_tmp45_ = FALSE;
							_tmp47_ = scale_names;
							_tmp47__length1 = scale_names_length1;
							if (!(j < _tmp47__length1)) {
								break;
							}
							_tmp48_ = scale_names;
							_tmp48__length1 = scale_names_length1;
							_tmp49_ = _tmp48_[j];
							_tmp50_ = g_strdup (_tmp49_);
							scale = _tmp50_;
							_tmp51_ = scale;
							_tmp52_ = direction;
							_tmp53_ = string_to_string (_tmp52_);
							_tmp54_ = g_strconcat ("app.change-", _tmp53_, "-scale", NULL);
							_tmp55_ = _tmp54_;
							_tmp56_ = g_menu_item_new (_tmp51_, _tmp55_);
							_tmp57_ = _tmp56_;
							_g_free0 (_tmp55_);
							scale_item = _tmp57_;
							_tmp58_ = scale_item;
							_tmp59_ = g_strdup_printf ("%i", j);
							_tmp60_ = _tmp59_;
							_tmp61_ = g_variant_new_string (_tmp60_);
							g_variant_ref_sink (_tmp61_);
							_tmp62_ = _tmp61_;
							g_menu_item_set_attribute_value (_tmp58_, "target", _tmp62_);
							_g_variant_unref0 (_tmp62_);
							_g_free0 (_tmp60_);
							_tmp63_ = scale_section;
							_tmp64_ = scale_item;
							g_menu_append_item (_tmp63_, _tmp64_);
							_g_object_unref0 (scale_item);
							_g_free0 (scale);
						}
					}
				}
				if (i < 2) {
					if (both_x) {
						if (i == 0) {
							gchar* _tmp65_;
							_tmp65_ = g_strdup (_ ("Bottom X Axis Scale"));
							_g_free0 (label);
							label = _tmp65_;
						} else {
							gchar* _tmp66_;
							_tmp66_ = g_strdup (_ ("Top X Axis Scale"));
							_g_free0 (label);
							label = _tmp66_;
						}
					} else {
						gchar* _tmp67_;
						_tmp67_ = g_strdup (_ ("X Axis Scale"));
						_g_free0 (label);
						label = _tmp67_;
					}
				} else {
					if (both_y) {
						if (i == 3) {
							gchar* _tmp68_;
							_tmp68_ = g_strdup (_ ("Right Y Axis Scale"));
							_g_free0 (label);
							label = _tmp68_;
						} else {
							gchar* _tmp69_;
							_tmp69_ = g_strdup (_ ("Left Y Axis Scale"));
							_g_free0 (label);
							label = _tmp69_;
						}
					} else {
						gchar* _tmp70_;
						_tmp70_ = g_strdup (_ ("Y Axis Scale"));
						_g_free0 (label);
						label = _tmp70_;
					}
				}
				_tmp71_ = scales_section;
				_tmp72_ = label;
				_tmp73_ = scale_section;
				g_menu_append_submenu (_tmp71_, _tmp72_, (GMenuModel*) _tmp73_);
				_g_free0 (label);
				_g_object_unref0 (scale_section);
				_g_free0 (direction);
			}
		}
	}
	_tmp74_ = view_menu;
	_tmp75_ = scales_section;
	g_menu_append_section (_tmp74_, NULL, (GMenuModel*) _tmp75_);
	_tmp76_ = self->priv->_view_menu_button;
	_tmp77_ = view_menu;
	gtk_menu_button_set_menu_model (_tmp76_, (GMenuModel*) _tmp77_);
	visible_axes = (g_free (visible_axes), NULL);
	_g_object_unref0 (application);
	_g_object_unref0 (scales_section);
	scale_names = (_vala_array_free (scale_names, scale_names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (optimize_section);
	_g_object_unref0 (toggle_section);
	_g_object_unref0 (view_menu);
}

GtkButton*
graphs_window_get_undo_button (GraphsWindow* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_undo_button;
	result = _tmp0_;
	return result;
}

GtkButton*
graphs_window_get_redo_button (GraphsWindow* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_redo_button;
	result = _tmp0_;
	return result;
}

GtkButton*
graphs_window_get_view_back_button (GraphsWindow* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view_back_button;
	result = _tmp0_;
	return result;
}

GtkButton*
graphs_window_get_view_forward_button (GraphsWindow* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view_forward_button;
	result = _tmp0_;
	return result;
}

static GtkMenuButton*
graphs_window_get_view_menu_button (GraphsWindow* self)
{
	GtkMenuButton* result;
	GtkMenuButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view_menu_button;
	result = _tmp0_;
	return result;
}

GtkToggleButton*
graphs_window_get_pan_button (GraphsWindow* self)
{
	GtkToggleButton* result;
	GtkToggleButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pan_button;
	result = _tmp0_;
	return result;
}

static GtkToggleButton*
graphs_window_get_zoom_button (GraphsWindow* self)
{
	GtkToggleButton* result;
	GtkToggleButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_zoom_button;
	result = _tmp0_;
	return result;
}

static GtkToggleButton*
graphs_window_get_select_button (GraphsWindow* self)
{
	GtkToggleButton* result;
	GtkToggleButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_select_button;
	result = _tmp0_;
	return result;
}

static GtkBox*
graphs_window_get_stack_switcher_box (GraphsWindow* self)
{
	GtkBox* result;
	GtkBox* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_stack_switcher_box;
	result = _tmp0_;
	return result;
}

static GtkStack*
graphs_window_get_stack (GraphsWindow* self)
{
	GtkStack* result;
	GtkStack* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_stack;
	result = _tmp0_;
	return result;
}

GtkButton*
graphs_window_get_shift_button (GraphsWindow* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_shift_button;
	result = _tmp0_;
	return result;
}

GtkButton*
graphs_window_get_cut_button (GraphsWindow* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cut_button;
	result = _tmp0_;
	return result;
}

GtkEntry*
graphs_window_get_translate_x_entry (GraphsWindow* self)
{
	GtkEntry* result;
	GtkEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_translate_x_entry;
	result = _tmp0_;
	return result;
}

GtkEntry*
graphs_window_get_translate_y_entry (GraphsWindow* self)
{
	GtkEntry* result;
	GtkEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_translate_y_entry;
	result = _tmp0_;
	return result;
}

GtkEntry*
graphs_window_get_multiply_x_entry (GraphsWindow* self)
{
	GtkEntry* result;
	GtkEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_multiply_x_entry;
	result = _tmp0_;
	return result;
}

GtkEntry*
graphs_window_get_multiply_y_entry (GraphsWindow* self)
{
	GtkEntry* result;
	GtkEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_multiply_y_entry;
	result = _tmp0_;
	return result;
}

GtkButton*
graphs_window_get_translate_x_button (GraphsWindow* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_translate_x_button;
	result = _tmp0_;
	return result;
}

GtkButton*
graphs_window_get_translate_y_button (GraphsWindow* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_translate_y_button;
	result = _tmp0_;
	return result;
}

GtkButton*
graphs_window_get_multiply_x_button (GraphsWindow* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_multiply_x_button;
	result = _tmp0_;
	return result;
}

GtkButton*
graphs_window_get_multiply_y_button (GraphsWindow* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_multiply_y_button;
	result = _tmp0_;
	return result;
}

GtkListBox*
graphs_window_get_item_list (GraphsWindow* self)
{
	GtkListBox* result;
	GtkListBox* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_item_list;
	result = _tmp0_;
	return result;
}

AdwOverlaySplitView*
graphs_window_get_split_view (GraphsWindow* self)
{
	AdwOverlaySplitView* result;
	AdwOverlaySplitView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_split_view;
	result = _tmp0_;
	return result;
}

static AdwToastOverlay*
graphs_window_get_toast_overlay (GraphsWindow* self)
{
	AdwToastOverlay* result;
	AdwToastOverlay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_toast_overlay;
	result = _tmp0_;
	return result;
}

static AdwHeaderBar*
graphs_window_get_content_headerbar (GraphsWindow* self)
{
	AdwHeaderBar* result;
	AdwHeaderBar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content_headerbar;
	result = _tmp0_;
	return result;
}

AdwWindowTitle*
graphs_window_get_content_title (GraphsWindow* self)
{
	AdwWindowTitle* result;
	AdwWindowTitle* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content_title;
	result = _tmp0_;
	return result;
}

void
graphs_window_set_mode (GraphsWindow* self,
                        gint value)
{
	GtkToggleButton* _tmp0_;
	GtkToggleButton* _tmp1_;
	GtkToggleButton* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_pan_button;
	gtk_toggle_button_set_active (_tmp0_, value == 0);
	_tmp1_ = self->priv->_zoom_button;
	gtk_toggle_button_set_active (_tmp1_, value == 1);
	_tmp2_ = self->priv->_select_button;
	gtk_toggle_button_set_active (_tmp2_, value == 2);
	g_object_notify_by_pspec ((GObject *) self, graphs_window_properties[GRAPHS_WINDOW_MODE_PROPERTY]);
}

GraphsCanvas*
graphs_window_get_canvas (GraphsWindow* self)
{
	GraphsCanvas* result;
	AdwToastOverlay* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_toast_overlay;
	_tmp1_ = adw_toast_overlay_get_child (_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GRAPHS_TYPE_CANVAS, GraphsCanvas);
	return result;
}

void
graphs_window_set_canvas (GraphsWindow* self,
                          GraphsCanvas* value)
{
	AdwToastOverlay* _tmp0_;
	g_return_if_fail (self != NULL);
	g_object_bind_property_with_closures ((GObject*) value, "mode", (GObject*) self, "mode", 2, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp0_ = self->priv->_toast_overlay;
	adw_toast_overlay_set_child (_tmp0_, (GtkWidget*) value);
	gtk_widget_grab_focus ((GtkWidget*) value);
	g_object_notify_by_pspec ((GObject *) self, graphs_window_properties[GRAPHS_WINDOW_CANVAS_PROPERTY]);
}

GtkCssProvider*
graphs_window_get_headerbar_provider (GraphsWindow* self)
{
	GtkCssProvider* result;
	GtkCssProvider* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_headerbar_provider;
	result = _tmp0_;
	return result;
}

static void
graphs_window_set_headerbar_provider (GraphsWindow* self,
                                      GtkCssProvider* value)
{
	GtkCssProvider* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_window_get_headerbar_provider (self);
	if (old_value != value) {
		GtkCssProvider* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_headerbar_provider);
		self->priv->_headerbar_provider = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_window_properties[GRAPHS_WINDOW_HEADERBAR_PROVIDER_PROPERTY]);
	}
}

static void
graphs_window_class_init (GraphsWindowClass * klass,
                          gpointer klass_data)
{
	graphs_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraphsWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_graphs_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_graphs_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = graphs_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_UNDO_BUTTON_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_UNDO_BUTTON_PROPERTY] = g_param_spec_object ("undo-button", "undo-button", "undo-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_REDO_BUTTON_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_REDO_BUTTON_PROPERTY] = g_param_spec_object ("redo-button", "redo-button", "redo-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_VIEW_BACK_BUTTON_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_VIEW_BACK_BUTTON_PROPERTY] = g_param_spec_object ("view-back-button", "view-back-button", "view-back-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_VIEW_FORWARD_BUTTON_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_VIEW_FORWARD_BUTTON_PROPERTY] = g_param_spec_object ("view-forward-button", "view-forward-button", "view-forward-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_PAN_BUTTON_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_PAN_BUTTON_PROPERTY] = g_param_spec_object ("pan-button", "pan-button", "pan-button", gtk_toggle_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_SHIFT_BUTTON_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_SHIFT_BUTTON_PROPERTY] = g_param_spec_object ("shift-button", "shift-button", "shift-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_CUT_BUTTON_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_CUT_BUTTON_PROPERTY] = g_param_spec_object ("cut-button", "cut-button", "cut-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_TRANSLATE_X_ENTRY_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_TRANSLATE_X_ENTRY_PROPERTY] = g_param_spec_object ("translate-x-entry", "translate-x-entry", "translate-x-entry", gtk_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_TRANSLATE_Y_ENTRY_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_TRANSLATE_Y_ENTRY_PROPERTY] = g_param_spec_object ("translate-y-entry", "translate-y-entry", "translate-y-entry", gtk_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_MULTIPLY_X_ENTRY_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_MULTIPLY_X_ENTRY_PROPERTY] = g_param_spec_object ("multiply-x-entry", "multiply-x-entry", "multiply-x-entry", gtk_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_MULTIPLY_Y_ENTRY_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_MULTIPLY_Y_ENTRY_PROPERTY] = g_param_spec_object ("multiply-y-entry", "multiply-y-entry", "multiply-y-entry", gtk_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_TRANSLATE_X_BUTTON_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_TRANSLATE_X_BUTTON_PROPERTY] = g_param_spec_object ("translate-x-button", "translate-x-button", "translate-x-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_TRANSLATE_Y_BUTTON_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_TRANSLATE_Y_BUTTON_PROPERTY] = g_param_spec_object ("translate-y-button", "translate-y-button", "translate-y-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_MULTIPLY_X_BUTTON_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_MULTIPLY_X_BUTTON_PROPERTY] = g_param_spec_object ("multiply-x-button", "multiply-x-button", "multiply-x-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_MULTIPLY_Y_BUTTON_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_MULTIPLY_Y_BUTTON_PROPERTY] = g_param_spec_object ("multiply-y-button", "multiply-y-button", "multiply-y-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_ITEM_LIST_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_ITEM_LIST_PROPERTY] = g_param_spec_object ("item-list", "item-list", "item-list", gtk_list_box_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_SPLIT_VIEW_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_SPLIT_VIEW_PROPERTY] = g_param_spec_object ("split-view", "split-view", "split-view", adw_overlay_split_view_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_CONTENT_TITLE_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_CONTENT_TITLE_PROPERTY] = g_param_spec_object ("content-title", "content-title", "content-title", adw_window_title_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_MODE_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_MODE_PROPERTY] = g_param_spec_int ("mode", "mode", "mode", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_CANVAS_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_CANVAS_PROPERTY] = g_param_spec_object ("canvas", "canvas", "canvas", GRAPHS_TYPE_CANVAS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_WINDOW_HEADERBAR_PROVIDER_PROPERTY, graphs_window_properties[GRAPHS_WINDOW_HEADERBAR_PROVIDER_PROPERTY] = g_param_spec_object ("headerbar-provider", "headerbar-provider", "headerbar-provider", gtk_css_provider_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/se/sjoerd/Graphs/ui/window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "undo_button", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _undo_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "redo_button", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _redo_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "view_back_button", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _view_back_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "view_forward_button", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _view_forward_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "view_menu_button", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _view_menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pan_button", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _pan_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "zoom_button", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _zoom_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "select_button", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _select_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack_switcher_box", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _stack_switcher_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "shift_button", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _shift_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cut_button", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _cut_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "translate_x_entry", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _translate_x_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "translate_y_entry", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _translate_y_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "multiply_x_entry", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _multiply_x_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "multiply_y_entry", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _multiply_y_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "translate_x_button", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _translate_x_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "translate_y_button", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _translate_y_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "multiply_x_button", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _multiply_x_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "multiply_y_button", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _multiply_y_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "item_list", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _item_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "split_view", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _split_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "toast_overlay", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _toast_overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_headerbar", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _content_headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_title", FALSE, GraphsWindow_private_offset + G_STRUCT_OFFSET (GraphsWindowPrivate, _content_title));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "perform_operation", G_CALLBACK(_graphs_window_perform_operation_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_sidebar_toggle", G_CALLBACK(_graphs_window_on_sidebar_toggle_g_object_notify));
}

static void
graphs_window_instance_init (GraphsWindow * self,
                             gpointer klass)
{
	self->priv = graphs_window_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
graphs_window_finalize (GObject * obj)
{
	GraphsWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAPHS_TYPE_WINDOW, GraphsWindow);
	_g_object_unref0 (self->priv->_headerbar_provider);
	G_OBJECT_CLASS (graphs_window_parent_class)->finalize (obj);
}

/**
     * Main window
     */
static GType
graphs_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraphsWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graphs_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraphsWindow), 0, (GInstanceInitFunc) graphs_window_instance_init, NULL };
	GType graphs_window_type_id;
	graphs_window_type_id = g_type_register_static (adw_application_window_get_type (), "GraphsWindow", &g_define_type_info, 0);
	GraphsWindow_private_offset = g_type_add_instance_private (graphs_window_type_id, sizeof (GraphsWindowPrivate));
	return graphs_window_type_id;
}

GType
graphs_window_get_type (void)
{
	static volatile gsize graphs_window_type_id__once = 0;
	if (g_once_init_enter (&graphs_window_type_id__once)) {
		GType graphs_window_type_id;
		graphs_window_type_id = graphs_window_get_type_once ();
		g_once_init_leave (&graphs_window_type_id__once, graphs_window_type_id);
	}
	return graphs_window_type_id__once;
}

static void
_vala_graphs_window_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	GraphsWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRAPHS_TYPE_WINDOW, GraphsWindow);
	switch (property_id) {
		case GRAPHS_WINDOW_UNDO_BUTTON_PROPERTY:
		g_value_set_object (value, graphs_window_get_undo_button (self));
		break;
		case GRAPHS_WINDOW_REDO_BUTTON_PROPERTY:
		g_value_set_object (value, graphs_window_get_redo_button (self));
		break;
		case GRAPHS_WINDOW_VIEW_BACK_BUTTON_PROPERTY:
		g_value_set_object (value, graphs_window_get_view_back_button (self));
		break;
		case GRAPHS_WINDOW_VIEW_FORWARD_BUTTON_PROPERTY:
		g_value_set_object (value, graphs_window_get_view_forward_button (self));
		break;
		case GRAPHS_WINDOW_PAN_BUTTON_PROPERTY:
		g_value_set_object (value, graphs_window_get_pan_button (self));
		break;
		case GRAPHS_WINDOW_SHIFT_BUTTON_PROPERTY:
		g_value_set_object (value, graphs_window_get_shift_button (self));
		break;
		case GRAPHS_WINDOW_CUT_BUTTON_PROPERTY:
		g_value_set_object (value, graphs_window_get_cut_button (self));
		break;
		case GRAPHS_WINDOW_TRANSLATE_X_ENTRY_PROPERTY:
		g_value_set_object (value, graphs_window_get_translate_x_entry (self));
		break;
		case GRAPHS_WINDOW_TRANSLATE_Y_ENTRY_PROPERTY:
		g_value_set_object (value, graphs_window_get_translate_y_entry (self));
		break;
		case GRAPHS_WINDOW_MULTIPLY_X_ENTRY_PROPERTY:
		g_value_set_object (value, graphs_window_get_multiply_x_entry (self));
		break;
		case GRAPHS_WINDOW_MULTIPLY_Y_ENTRY_PROPERTY:
		g_value_set_object (value, graphs_window_get_multiply_y_entry (self));
		break;
		case GRAPHS_WINDOW_TRANSLATE_X_BUTTON_PROPERTY:
		g_value_set_object (value, graphs_window_get_translate_x_button (self));
		break;
		case GRAPHS_WINDOW_TRANSLATE_Y_BUTTON_PROPERTY:
		g_value_set_object (value, graphs_window_get_translate_y_button (self));
		break;
		case GRAPHS_WINDOW_MULTIPLY_X_BUTTON_PROPERTY:
		g_value_set_object (value, graphs_window_get_multiply_x_button (self));
		break;
		case GRAPHS_WINDOW_MULTIPLY_Y_BUTTON_PROPERTY:
		g_value_set_object (value, graphs_window_get_multiply_y_button (self));
		break;
		case GRAPHS_WINDOW_ITEM_LIST_PROPERTY:
		g_value_set_object (value, graphs_window_get_item_list (self));
		break;
		case GRAPHS_WINDOW_SPLIT_VIEW_PROPERTY:
		g_value_set_object (value, graphs_window_get_split_view (self));
		break;
		case GRAPHS_WINDOW_CONTENT_TITLE_PROPERTY:
		g_value_set_object (value, graphs_window_get_content_title (self));
		break;
		case GRAPHS_WINDOW_CANVAS_PROPERTY:
		g_value_set_object (value, graphs_window_get_canvas (self));
		break;
		case GRAPHS_WINDOW_HEADERBAR_PROVIDER_PROPERTY:
		g_value_set_object (value, graphs_window_get_headerbar_provider (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_graphs_window_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	GraphsWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRAPHS_TYPE_WINDOW, GraphsWindow);
	switch (property_id) {
		case GRAPHS_WINDOW_MODE_PROPERTY:
		graphs_window_set_mode (self, g_value_get_int (value));
		break;
		case GRAPHS_WINDOW_CANVAS_PROPERTY:
		graphs_window_set_canvas (self, g_value_get_object (value));
		break;
		case GRAPHS_WINDOW_HEADERBAR_PROVIDER_PROPERTY:
		graphs_window_set_headerbar_provider (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

