/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_stream_demux = R"doc(Stream demuxing block to demultiplex one stream into N output streams.

Demuxes a stream producing N outputs streams that contains n_0 items in the first stream, n_1 items in the second, etc. and repeats. Number of items of each output stream is specified using the 'lengths' parameter like so [n_0, n_1, ..., n_N-1].


Example: lengths = [2, 3, 4] input stream: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, ...] output_streams: [0, 1, 9, 10, ...] [2, 3, 4, 11, ...] [5, 6, 7, 8, ...]

Constructor Specific Documentation:

Stream demuxing block to demultiplex one stream into N output streams.

Args:
    itemsize : the item size of the stream
    lengths : a vector (list/tuple) specifying the number of items to copy to each output stream.)doc";


static const char* __doc_gr_blocks_stream_demux_stream_demux = R"doc()doc";


static const char* __doc_gr_blocks_stream_demux_make = R"doc(Stream demuxing block to demultiplex one stream into N output streams.

Demuxes a stream producing N outputs streams that contains n_0 items in the first stream, n_1 items in the second, etc. and repeats. Number of items of each output stream is specified using the 'lengths' parameter like so [n_0, n_1, ..., n_N-1].


Example: lengths = [2, 3, 4] input stream: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, ...] output_streams: [0, 1, 9, 10, ...] [2, 3, 4, 11, ...] [5, 6, 7, 8, ...]

Constructor Specific Documentation:

Stream demuxing block to demultiplex one stream into N output streams.

Args:
    itemsize : the item size of the stream
    lengths : a vector (list/tuple) specifying the number of items to copy to each output stream.)doc";
