/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, iio, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */

static const char* __doc_gr_iio_attr_sink = R"doc(Generic writer for attributes of IIO devices.

This block allow for updating of any IIO attribute that is writable. This includes channel, device, device buffer, device debug, and direct register attributes. All messages must be a pmt dictionary where the key is the attribute to update and the value is the value to be written. Messages can be an array of dictionaries or a single dictionary.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of iio::attr_sink.

Args:
    uri : String of context uri
    device : String of device name
    channel : String of device name
    type : Integer determining attribute type: 0: Channel attribute 1: Device attribute 2: Device buffer attribute 3: Device debug attribute 4: Direct register access
    output : Boolean when True if channel attribute is an output)doc";

static const char* __doc_gr_iio_attr_sink_make = R"doc(Generic writer for attributes of IIO devices.

This block allow for updating of any IIO attribute that is writable. This includes channel, device, device buffer, device debug, and direct register attributes. All messages must be a pmt dictionary where the key is the attribute to update and the value is the value to be written. Messages can be an array of dictionaries or a single dictionary.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of iio::attr_sink.

Args:
    uri : String of context uri
    device : String of device name
    channel : String of device name
    type : Integer determining attribute type: 0: Channel attribute 1: Device attribute 2: Device buffer attribute 3: Device debug attribute 4: Direct register access
    output : Boolean when True if channel attribute is an output)doc";
