// Copyright 2018-2025 the Deno authors. MIT license.

/// Don't modify this file manually.
///
/// This file is auto-generated by the build script, modify `data.rs` instead.
use crate::structs::UnstableFeatureDefinition;
use crate::structs::UnstableFeatureKind;

pub static UNSTABLE_FEATURES: &[UnstableFeatureDefinition] = &[
  UnstableFeatureDefinition {
    name: "bare-node-builtins",
    flag_name: "unstable-bare-node-builtins",
    help_text: "Enable unstable bare node builtins feature",
    show_in_help: true,
    id: 0,
    kind: UnstableFeatureKind::Cli,
    config_file_option: "bare-node-builtins",
  },
  UnstableFeatureDefinition {
    name: "broadcast-channel",
    flag_name: "unstable-broadcast-channel",
    help_text: "Enable unstable `BroadcastChannel` API",
    show_in_help: true,
    id: 1,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "broadcast-channel",
  },
  UnstableFeatureDefinition {
    name: "bundle",
    flag_name: "unstable-bundle",
    help_text: "Enable unstable bundle runtime API",
    show_in_help: true,
    id: 2,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "bundle",
  },
  UnstableFeatureDefinition {
    name: "byonm",
    flag_name: "unstable-byonm",
    help_text: "",
    show_in_help: false,
    id: 3,
    kind: UnstableFeatureKind::Cli,
    config_file_option: "byonm",
  },
  UnstableFeatureDefinition {
    name: "cron",
    flag_name: "unstable-cron",
    help_text: "Enable unstable `Deno.cron` API",
    show_in_help: true,
    id: 4,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "cron",
  },
  UnstableFeatureDefinition {
    name: "detect-cjs",
    flag_name: "unstable-detect-cjs",
    help_text: "Treats ambiguous .js, .jsx, .ts, .tsx files as CommonJS modules in more cases",
    show_in_help: true,
    id: 5,
    kind: UnstableFeatureKind::Cli,
    config_file_option: "detect-cjs",
  },
  UnstableFeatureDefinition {
    name: "ffi",
    flag_name: "unstable-ffi",
    help_text: "Enable unstable FFI APIs",
    show_in_help: false,
    id: 6,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "ffi",
  },
  UnstableFeatureDefinition {
    name: "fs",
    flag_name: "unstable-fs",
    help_text: "Enable unstable file system APIs",
    show_in_help: false,
    id: 7,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "fs",
  },
  UnstableFeatureDefinition {
    name: "http",
    flag_name: "unstable-http",
    help_text: "Enable unstable HTTP APIs",
    show_in_help: false,
    id: 8,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "http",
  },
  UnstableFeatureDefinition {
    name: "kv",
    flag_name: "unstable-kv",
    help_text: "Enable unstable KV APIs",
    show_in_help: true,
    id: 9,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "kv",
  },
  UnstableFeatureDefinition {
    name: "lazy-dynamic-imports",
    flag_name: "unstable-lazy-dynamic-imports",
    help_text: "Lazily loads statically analyzable dynamic imports when not running with type checking. Warning: This may change the order of semver specifier resolution.",
    show_in_help: true,
    id: 10,
    kind: UnstableFeatureKind::Cli,
    config_file_option: "lazy-dynamic-imports",
  },
  UnstableFeatureDefinition {
    name: "lockfile-v5",
    flag_name: "unstable-lockfile-v5",
    help_text: "Enable unstable lockfile v5",
    show_in_help: true,
    id: 11,
    kind: UnstableFeatureKind::Cli,
    config_file_option: "lockfile-v5",
  },
  UnstableFeatureDefinition {
    name: "net",
    flag_name: "unstable-net",
    help_text: "enable unstable net APIs",
    show_in_help: true,
    id: 12,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "net",
  },
  UnstableFeatureDefinition {
    name: "no-legacy-abort",
    flag_name: "unstable-no-legacy-abort",
    help_text: "Enable abort signal in Deno.serve without legacy behavior. This will not abort the server when the request is handled successfully.",
    show_in_help: true,
    id: 13,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "no-legacy-abort",
  },
  UnstableFeatureDefinition {
    name: "node-globals",
    flag_name: "unstable-node-globals",
    help_text: "Prefer Node.js globals over Deno globals - currently this refers to `setTimeout` and `setInterval` APIs.",
    show_in_help: true,
    id: 14,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "node-globals",
  },
  UnstableFeatureDefinition {
    name: "npm-lazy-caching",
    flag_name: "unstable-npm-lazy-caching",
    help_text: "Enable unstable lazy caching of npm dependencies, downloading them only as needed (disabled: all npm packages in package.json are installed on startup; enabled: only npm packages that are actually referenced in an import are installed",
    show_in_help: true,
    id: 15,
    kind: UnstableFeatureKind::Cli,
    config_file_option: "npm-lazy-caching",
  },
  UnstableFeatureDefinition {
    name: "otel",
    flag_name: "unstable-otel",
    help_text: "Enable unstable OpenTelemetry features",
    show_in_help: false,
    id: 16,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "otel",
  },
  UnstableFeatureDefinition {
    name: "process",
    flag_name: "unstable-process",
    help_text: "Enable unstable process APIs",
    show_in_help: false,
    id: 17,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "process",
  },
  UnstableFeatureDefinition {
    name: "raw-imports",
    flag_name: "unstable-raw-imports",
    help_text: "Enable unstable 'bytes' and 'text' imports.",
    show_in_help: true,
    id: 18,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "raw-imports",
  },
  UnstableFeatureDefinition {
    name: "sloppy-imports",
    flag_name: "unstable-sloppy-imports",
    help_text: "Enable unstable resolving of specifiers by extension probing, .js to .ts, and directory probing",
    show_in_help: true,
    id: 19,
    kind: UnstableFeatureKind::Cli,
    config_file_option: "sloppy-imports",
  },
  UnstableFeatureDefinition {
    name: "subdomain-wildcards",
    flag_name: "unstable-subdomain-wildcards",
    help_text: "Enable subdomain wildcards support for the `--allow-net` flag",
    show_in_help: false,
    id: 20,
    kind: UnstableFeatureKind::Cli,
    config_file_option: "subdomain-wildcards",
  },
  UnstableFeatureDefinition {
    name: "temporal",
    flag_name: "unstable-temporal",
    help_text: "Enable unstable Temporal API",
    show_in_help: true,
    id: 21,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "temporal",
  },
  UnstableFeatureDefinition {
    name: "unsafe-proto",
    flag_name: "unstable-unsafe-proto",
    help_text: "Enable unsafe __proto__ support. This is a security risk.",
    show_in_help: true,
    id: 22,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "unsafe-proto",
  },
  UnstableFeatureDefinition {
    name: "vsock",
    flag_name: "unstable-vsock",
    help_text: "Enable unstable VSOCK APIs",
    show_in_help: false,
    id: 23,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "vsock",
  },
  UnstableFeatureDefinition {
    name: "webgpu",
    flag_name: "unstable-webgpu",
    help_text: "Enable unstable WebGPU APIs",
    show_in_help: true,
    id: 24,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "webgpu",
  },
  UnstableFeatureDefinition {
    name: "worker-options",
    flag_name: "unstable-worker-options",
    help_text: "Enable unstable Web Worker APIs",
    show_in_help: true,
    id: 25,
    kind: UnstableFeatureKind::Runtime,
    config_file_option: "worker-options",
  },
];
pub struct UnstableEnvVarNames {
  pub bare_node_builtins: &'static str,
  pub lazy_dynamic_imports: &'static str,
  pub lockfile_v5: &'static str,
  pub npm_lazy_caching: &'static str,
  pub raw_imports: &'static str,
  pub sloppy_imports: &'static str,
  pub subdomain_wildcards: &'static str,
}
pub static UNSTABLE_ENV_VAR_NAMES: UnstableEnvVarNames = UnstableEnvVarNames {
  bare_node_builtins: "DENO_UNSTABLE_BARE_NODE_BUILTINS",
  lazy_dynamic_imports: "DENO_UNSTABLE_LAZY_DYNAMIC_IMPORTS",
  lockfile_v5: "DENO_UNSTABLE_LOCKFILE_V5",
  npm_lazy_caching: "DENO_UNSTABLE_NPM_LAZY_CACHING",
  raw_imports: "DENO_UNSTABLE_RAW_IMPORTS",
  sloppy_imports: "DENO_UNSTABLE_SLOPPY_IMPORTS",
  subdomain_wildcards: "DENO_UNSTABLE_SUBDOMAIN_WILDCARDS",
};
