/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// NetworkDeviceDataApplyConfiguration represents a declarative configuration of the NetworkDeviceData type for use
// with apply.
//
// NetworkDeviceData provides network-related details for the allocated device.
// This information may be filled by drivers or other components to configure
// or identify the device within a network context.
type NetworkDeviceDataApplyConfiguration struct {
	// InterfaceName specifies the name of the network interface associated with
	// the allocated device. This might be the name of a physical or virtual
	// network interface being configured in the pod.
	//
	// Must not be longer than 256 characters.
	InterfaceName *string `json:"interfaceName,omitempty"`
	// IPs lists the network addresses assigned to the device's network interface.
	// This can include both IPv4 and IPv6 addresses.
	// The IPs are in the CIDR notation, which includes both the address and the
	// associated subnet mask.
	// e.g.: "192.0.2.5/24" for IPv4 and "2001:db8::5/64" for IPv6.
	IPs []string `json:"ips,omitempty"`
	// HardwareAddress represents the hardware address (e.g. MAC Address) of the device's network interface.
	//
	// Must not be longer than 128 characters.
	HardwareAddress *string `json:"hardwareAddress,omitempty"`
}

// NetworkDeviceDataApplyConfiguration constructs a declarative configuration of the NetworkDeviceData type for use with
// apply.
func NetworkDeviceData() *NetworkDeviceDataApplyConfiguration {
	return &NetworkDeviceDataApplyConfiguration{}
}

// WithInterfaceName sets the InterfaceName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the InterfaceName field is set to the value of the last call.
func (b *NetworkDeviceDataApplyConfiguration) WithInterfaceName(value string) *NetworkDeviceDataApplyConfiguration {
	b.InterfaceName = &value
	return b
}

// WithIPs adds the given value to the IPs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the IPs field.
func (b *NetworkDeviceDataApplyConfiguration) WithIPs(values ...string) *NetworkDeviceDataApplyConfiguration {
	for i := range values {
		b.IPs = append(b.IPs, values[i])
	}
	return b
}

// WithHardwareAddress sets the HardwareAddress field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HardwareAddress field is set to the value of the last call.
func (b *NetworkDeviceDataApplyConfiguration) WithHardwareAddress(value string) *NetworkDeviceDataApplyConfiguration {
	b.HardwareAddress = &value
	return b
}
