/* Generated automatically by the program `genrecog' from the target
   machine description file.  */

#define IN_TARGET_CODE 1

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "backend.h"
#include "predict.h"
#include "rtl.h"
#include "memmodel.h"
#include "tm_p.h"
#include "emit-rtl.h"
#include "insn-config.h"
#include "recog.h"
#include "output.h"
#include "flags.h"
#include "df.h"
#include "resource.h"
#include "diagnostic-core.h"
#include "reload.h"
#include "regs.h"
#include "tm-constrs.h"
#include "insn-recog.h"


/* `recog' contains a decision tree that recognizes whether the rtx
   X0 is a valid instruction.

   recog returns -1 if the rtx is not valid.  If the rtx is valid, recog
   returns a nonnegative number which is the insn code number for the
   pattern that matched.  This is the same as the order in the machine
   description of the entry that matched.  This number can be used as an
   index into `insn_data' and other tables.
   The third parameter to recog is an optional pointer to an int.  If
   present, recog will accept a pattern if it matches except for missing
   CLOBBER expressions at the end.  In that case, the value pointed to by
   the optional pointer will be set to the number of CLOBBERs that need
   to be added (it should be initialized to zero by the caller).  If it   is set nonzero, the caller should allocate a PARALLEL of the
   appropriate size, copy the initial entries, and call add_clobbers
   (found in insn-emit.cc) to fill in the CLOBBERs.

   The function split_insns returns 0 if the rtl could not
   be split or the split rtl as an INSN list if it can be.

   The function peephole2_insns returns 0 if the rtl could not
   be matched. If there was a match, the new rtl is returned in an INSN list,
   and LAST_INSN will point to the last recognized insn in the old sequence.
*/




int
pattern4 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  switch (GET_CODE (x4))
    {
    case AND:
      if (pnum_clobbers == NULL
          || GET_MODE (x4) != E_QImode)
        return -1;
      x5 = XEXP (x1, 0);
      operands[0] = x5;
      x6 = XEXP (x4, 0);
      operands[2] = x6;
      if (!register_operand (operands[2], E_QImode))
        return -1;
      return pattern3 (x2); /* [-1, 1] */

    case PLUS:
      if (pnum_clobbers == NULL
          || GET_MODE (x4) != E_QImode)
        return -1;
      x5 = XEXP (x1, 0);
      operands[0] = x5;
      x6 = XEXP (x4, 0);
      operands[2] = x6;
      if (!nonimmediate_operand (operands[2], E_QImode))
        return -1;
      res = pattern3 (x2);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    case MINUS:
      if (pnum_clobbers == NULL
          || GET_MODE (x4) != E_QImode)
        return -1;
      x5 = XEXP (x1, 0);
      operands[0] = x5;
      x6 = XEXP (x4, 0);
      operands[3] = x6;
      if (!const_int_operand (operands[3], E_QImode))
        return -1;
      x7 = XEXP (x4, 1);
      operands[2] = x7;
      if (!nonimmediate_operand (operands[2], E_QImode))
        return -1;
      res = pattern2 (x2);
      if (res >= 0)
        return res + 4; /* [4, 5] */
      return -1;

    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      return 6;

    default:
      return -1;
    }
}

int
pattern33 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V32QImode:
      return pattern5 (x3, 
E_V32QImode); /* [-1, 0] */

    case E_V16HImode:
      if (pattern5 (x3, 
E_V16HImode) != 0)
        return -1;
      return 1;

    case E_V8SImode:
      if (pattern5 (x3, 
E_V8SImode) != 0)
        return -1;
      return 2;

    case E_V16SImode:
      if (pattern5 (x3, 
E_V16SImode) != 0)
        return -1;
      return 3;

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode)
        return -1;
      return 4;

    case E_V8DImode:
      if (pattern5 (x3, 
E_V8DImode) != 0)
        return -1;
      return 5;

    case E_V4DImode:
      if (pattern5 (x3, 
E_V4DImode) != 0)
        return -1;
      return 6;

    case E_V2DImode:
      if (pattern5 (x3, 
E_V2DImode) != 0)
        return -1;
      return 7;

    case E_V64QImode:
      if (pattern5 (x3, 
E_V64QImode) != 0)
        return -1;
      return 8;

    case E_V16QImode:
      if (!register_operand (operands[0], E_V16QImode)
          || GET_MODE (x3) != E_V16QImode)
        return -1;
      return 9;

    case E_V32HImode:
      if (pattern5 (x3, 
E_V32HImode) != 0)
        return -1;
      return 10;

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || GET_MODE (x3) != E_V8HImode)
        return -1;
      return 11;

    default:
      return -1;
    }
}

int
pattern42 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_TImode)
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  return pattern41 (x2, 
E_DImode, 
E_TImode); /* [-1, 0] */
}

int
pattern46 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  if (!flags_reg_operand (operands[0], E_VOIDmode))
    return -1;
  operands[1] = x2;
  if (!compare_operator (operands[1], E_VOIDmode))
    return -1;
  x5 = XEXP (x2, 0);
  x6 = XEXP (x5, 0);
  operands[2] = x6;
  if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
    return -1;
  x7 = XEXP (x5, 1);
  operands[3] = x7;
  if (!const_int_operand (operands[3], E_QImode))
    return -1;
  x8 = XEXP (x5, 2);
  operands[4] = x8;
  if (!const_int_operand (operands[4], E_QImode))
    return -1;
  switch (GET_MODE (x5))
    {
    case E_HImode:
      return 0;

    case E_SImode:
      return 1;

    case E_DImode:
      return 2;

    default:
      return -1;
    }
}

int
pattern56 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern57 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XVECEXP (x2, 0, 0);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x4 = XEXP (x1, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17
      || GET_MODE (x4) != i1)
    return -1;
  return 0;
}

int
pattern62 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_HFmode:
      return pattern61 (x3, 
E_HFmode); /* [-1, 0] */

    case E_SFmode:
      if (pattern61 (x3, 
E_SFmode) != 0)
        return -1;
      return 1;

    case E_DFmode:
      if (pattern61 (x3, 
E_DFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern70 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[3] = x4;
  return pattern69 (x1); /* [-1, 2] */
}

int
pattern76 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  x4 = XEXP (x1, 0);
  switch (GET_CODE (x4))
    {
    case STRICT_LOW_PART:
      return pattern72 (x1, pnum_clobbers); /* [-1, 1] */

    case REG:
    case SUBREG:
    case MEM:
      operands[0] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_TImode:
          if (pattern73 (x2, pnum_clobbers) != 0)
            return -1;
          return 2;

        case E_HImode:
          if (pattern74 (x2, 
E_HImode) != 0)
            return -1;
          return 3;

        case E_V2SFmode:
          if (pattern7 (x2, 
E_V2SFmode) != 0)
            return -1;
          return 4;

        case E_V2BFmode:
          if (pattern7 (x2, 
E_V2BFmode) != 0)
            return -1;
          return 5;

        case E_V4BFmode:
          if (pattern7 (x2, 
E_V4BFmode) != 0)
            return -1;
          return 6;

        case E_V2HFmode:
          if (pattern7 (x2, 
E_V2HFmode) != 0)
            return -1;
          return 7;

        case E_V4HFmode:
          if (pattern7 (x2, 
E_V4HFmode) != 0)
            return -1;
          return 8;

        case E_V8QImode:
          if (pattern8 (x2, 
E_V8QImode) != 0)
            return -1;
          return 9;

        case E_V4HImode:
          if (pattern8 (x2, 
E_V4HImode) != 0)
            return -1;
          return 10;

        case E_V2SImode:
          if (pattern8 (x2, 
E_V2SImode) != 0)
            return -1;
          return 11;

        case E_V4QImode:
          if (pattern75 (x2, pnum_clobbers, 
E_V4QImode) != 0)
            return -1;
          return 12;

        case E_V2QImode:
          if (pattern75 (x2, pnum_clobbers, 
E_V2QImode) != 0)
            return -1;
          return 13;

        case E_V2HImode:
          if (pattern75 (x2, pnum_clobbers, 
E_V2HImode) != 0)
            return -1;
          return 14;

        case E_BFmode:
          if (pattern7 (x2, 
E_BFmode) != 0)
            return -1;
          return 15;

        case E_HFmode:
          if (pattern7 (x2, 
E_HFmode) != 0)
            return -1;
          return 16;

        case E_SFmode:
          if (pattern7 (x2, 
E_SFmode) != 0)
            return -1;
          return 17;

        case E_DFmode:
          if (pattern7 (x2, 
E_DFmode) != 0)
            return -1;
          return 18;

        case E_TFmode:
          if (pattern25 (x2, 
E_TFmode) != 0)
            return -1;
          return 19;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern109 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode)
        return -1;
      switch (GET_MODE (x2))
        {
        case E_SImode:
          if (!nonimmediate_operand (operands[1], E_SImode))
            return -1;
          return 0;

        case E_QImode:
          if (!nonimmediate_operand (operands[1], E_QImode)
              || !nonmemory_operand (operands[2], E_QImode))
            return -1;
          return 1;

        case E_HImode:
          if (!nonimmediate_operand (operands[1], E_HImode)
              || !nonmemory_operand (operands[2], E_QImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode
          || !nonmemory_operand (operands[2], E_QImode))
        return -1;
      switch (GET_MODE (x2))
        {
        case E_QImode:
          if (!nonimmediate_operand (operands[1], E_QImode))
            return -1;
          return 3;

        case E_HImode:
          if (!nonimmediate_operand (operands[1], E_HImode))
            return -1;
          return 4;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern128 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern140 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 2);
  operands[3] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V16QImode:
      if (!nonimmediate_operand (operands[0], E_V16QImode)
          || GET_MODE (x1) != E_V16QImode
          || GET_MODE (x2) != E_V16QImode
          || !nonimm_or_0_operand (operands[2], E_V16QImode)
          || !register_operand (operands[3], E_HImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V16SImode:
          if (!register_operand (operands[1], E_V16SImode))
            return -1;
          return 0;

        case E_V16HImode:
          if (!register_operand (operands[1], E_V16HImode))
            return -1;
          return 1;

        default:
          return -1;
        }

    case E_V16HImode:
      if (pattern139 (x1, 
E_V16HImode, 
E_HImode, 
E_V16SImode) != 0)
        return -1;
      return 2;

    case E_V8SImode:
      if (pattern139 (x1, 
E_V8SImode, 
E_QImode, 
E_V8DImode) != 0)
        return -1;
      return 3;

    case E_V8HImode:
      if (!nonimmediate_operand (operands[0], E_V8HImode)
          || GET_MODE (x1) != E_V8HImode
          || GET_MODE (x2) != E_V8HImode
          || !nonimm_or_0_operand (operands[2], E_V8HImode)
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8DImode:
          if (!register_operand (operands[1], E_V8DImode))
            return -1;
          return 4;

        case E_V8SImode:
          if (!register_operand (operands[1], E_V8SImode))
            return -1;
          return 5;

        default:
          return -1;
        }

    case E_V32QImode:
      if (pattern139 (x1, 
E_V32QImode, 
E_SImode, 
E_V32HImode) != 0)
        return -1;
      return 6;

    case E_V4SImode:
      if (pattern139 (x1, 
E_V4SImode, 
E_QImode, 
E_V4DImode) != 0)
        return -1;
      return 7;

    default:
      return -1;
    }
}

int
pattern158 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!register_operand (operands[0], i2))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], i2))
    return -1;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  if (!register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern163 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i2))
    return -1;
  return 0;
}

int
pattern166 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V32QImode:
      return pattern165 (x3, 
E_V32HFmode, 
E_V64QImode, 
E_V32QImode); /* [-1, 0] */

    case E_V16QImode:
      if (pattern165 (x3, 
E_V16HFmode, 
E_V32QImode, 
E_V16QImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern176 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HImode:
      return pattern172 (x3, 
E_V32HImode); /* [-1, 0] */

    case E_V16SImode:
      if (pattern172 (x3, 
E_V16SImode) != 0)
        return -1;
      return 1;

    case E_V8DImode:
      if (pattern172 (x3, 
E_V8DImode) != 0)
        return -1;
      return 2;

    case E_V16HImode:
      if (pattern172 (x3, 
E_V16HImode) != 0)
        return -1;
      return 3;

    case E_V8SImode:
      if (pattern172 (x3, 
E_V8SImode) != 0)
        return -1;
      return 4;

    case E_V4DImode:
      if (pattern172 (x3, 
E_V4DImode) != 0)
        return -1;
      return 5;

    case E_V8HImode:
      if (pattern172 (x3, 
E_V8HImode) != 0)
        return -1;
      return 6;

    case E_V4SImode:
      if (pattern172 (x3, 
E_V4SImode) != 0)
        return -1;
      return 7;

    case E_V2DImode:
      if (pattern172 (x3, 
E_V2DImode) != 0)
        return -1;
      return 8;

    default:
      return -1;
    }
}

int
pattern190 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_CONCAT)
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_CODE (x4) != PARALLEL)
    return -1;
  x5 = XEXP (x1, 1);
  if (GET_CODE (x5) != VEC_SELECT)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != VEC_CONCAT)
    return -1;
  x7 = XEXP (x5, 1);
  if (GET_CODE (x7) != PARALLEL)
    return -1;
  x8 = XEXP (x3, 0);
  operands[1] = x8;
  x9 = XEXP (x3, 1);
  operands[2] = x9;
  x10 = XEXP (x6, 0);
  if (!rtx_equal_p (x10, operands[1]))
    return -1;
  x11 = XEXP (x6, 1);
  if (!rtx_equal_p (x11, operands[2]))
    return -1;
  switch (XVECLEN (x4, 0))
    {
    case 16:
      return pattern188 (x1); /* [-1, 0] */

    case 8:
      x12 = XVECEXP (x4, 0, 0);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x13 = XVECEXP (x4, 0, 1);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x14 = XVECEXP (x4, 0, 2);
      if (GET_CODE (x14) != CONST_INT)
        return -1;
      x15 = XVECEXP (x4, 0, 3);
      if (GET_CODE (x15) != CONST_INT)
        return -1;
      x16 = XVECEXP (x4, 0, 4);
      if (GET_CODE (x16) != CONST_INT)
        return -1;
      x17 = XVECEXP (x4, 0, 5);
      if (GET_CODE (x17) != CONST_INT)
        return -1;
      x18 = XVECEXP (x4, 0, 6);
      if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 12])
        return -1;
      x19 = XVECEXP (x4, 0, 7);
      if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 14]
          || XVECLEN (x7, 0) != 8)
        return -1;
      x20 = XVECEXP (x7, 0, 0);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x21 = XVECEXP (x7, 0, 1);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x22 = XVECEXP (x7, 0, 2);
      if (GET_CODE (x22) != CONST_INT)
        return -1;
      x23 = XVECEXP (x7, 0, 3);
      if (GET_CODE (x23) != CONST_INT)
        return -1;
      x24 = XVECEXP (x7, 0, 4);
      if (GET_CODE (x24) != CONST_INT)
        return -1;
      x25 = XVECEXP (x7, 0, 5);
      if (GET_CODE (x25) != CONST_INT)
        return -1;
      x26 = XVECEXP (x7, 0, 6);
      if (x26 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
        return -1;
      x27 = XVECEXP (x7, 0, 7);
      if (x27 != const_int_rtx[MAX_SAVED_CONST_INT + 15])
        return -1;
      switch (XWINT (x14, 0))
        {
        case 4L:
          if (XWINT (x15, 0) != 6L
              || XWINT (x16, 0) != 8L
              || XWINT (x17, 0) != 10L
              || XWINT (x22, 0) != 5L
              || XWINT (x23, 0) != 7L
              || XWINT (x24, 0) != 9L
              || XWINT (x25, 0) != 11L
              || pattern189 (x1, 
E_V16HImode, 
E_V8HImode) != 0)
            return -1;
          return 1;

        case 8L:
          if (XWINT (x15, 0) != 10L
              || XWINT (x16, 0) != 4L
              || XWINT (x17, 0) != 6L
              || XWINT (x22, 0) != 9L
              || XWINT (x23, 0) != 11L
              || XWINT (x24, 0) != 5L
              || XWINT (x25, 0) != 7L
              || pattern187 (x1, 
E_V16SImode, 
E_V8SImode) != 0)
            return -1;
          return 2;

        default:
          return -1;
        }

    case 4:
      x12 = XVECEXP (x4, 0, 0);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x13 = XVECEXP (x4, 0, 1);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x14 = XVECEXP (x4, 0, 2);
      if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x15 = XVECEXP (x4, 0, 3);
      if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 6]
          || XVECLEN (x7, 0) != 4)
        return -1;
      x20 = XVECEXP (x7, 0, 0);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x21 = XVECEXP (x7, 0, 1);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x22 = XVECEXP (x7, 0, 2);
      if (x22 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x23 = XVECEXP (x7, 0, 3);
      if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
          || pattern189 (x1, 
E_V8SImode, 
E_V4SImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern220 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != UMOD)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  x6 = XEXP (x4, 1);
  x7 = XEXP (x6, 0);
  operands[2] = x7;
  x8 = XEXP (x6, 1);
  operands[3] = x8;
  x9 = XEXP (x2, 0);
  operands[1] = x9;
  x10 = XEXP (x3, 0);
  if (!rtx_equal_p (x10, operands[2]))
    return -1;
  x11 = XEXP (x3, 1);
  if (!rtx_equal_p (x11, operands[3]))
    return -1;
  switch (GET_CODE (operands[3]))
    {
    case REG:
    case SUBREG:
    case MEM:
      return 0;

    case CONST_INT:
      return 1;

    default:
      return -1;
    }
}

int
pattern230 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != MEM)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != PLUS)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  return 0;
}

int
pattern238 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[1] = x2;
  x3 = XEXP (x1, 1);
  operands[2] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return pattern237 (x1, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern237 (x1, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_SImode:
      if (pattern237 (x1, 
E_SImode) != 0)
        return -1;
      return 2;

    case E_DImode:
      if (pattern237 (x1, 
E_DImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern249 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != VEC_SELECT)
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_CODE (x2) != PARALLEL
      || XVECLEN (x2, 0) != 1)
    return -1;
  x3 = XVECEXP (x2, 0, 0);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern253 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != SUBREG
      || maybe_ne (SUBREG_BYTE (x4), 0)
      || GET_MODE (x4) != E_QImode)
    return -1;
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[2] = x5;
      x6 = XEXP (x5, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x7 = XEXP (x5, 2);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x8 = XEXP (x1, 0);
      if (GET_CODE (x8) != ZERO_EXTRACT)
        return -1;
      x9 = XEXP (x8, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x10 = XEXP (x8, 2);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x11 = XEXP (x8, 0);
      operands[0] = x11;
      if (!int248_register_operand (operands[0], E_VOIDmode))
        return -1;
      x12 = XEXP (x5, 0);
      operands[1] = x12;
      if (!int248_register_operand (operands[1], E_VOIDmode))
        return -1;
      switch (GET_MODE (x8))
        {
        case E_HImode:
          if (GET_MODE (x2) != E_HImode
              || !extract_operator (operands[2], E_HImode))
            return -1;
          return 0;

        case E_SImode:
          if (GET_MODE (x2) != E_SImode
              || !extract_operator (operands[2], E_SImode))
            return -1;
          return 1;

        case E_DImode:
          if (GET_MODE (x2) != E_DImode
              || !extract_operator (operands[2], E_DImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern283 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern282 (x1); /* [-1, 1] */

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode)
        return -1;
      x2 = XEXP (x1, 0);
      switch (GET_MODE (x2))
        {
        case E_QImode:
          if (!nonimmediate_operand (operands[1], E_QImode))
            return -1;
          return 2;

        case E_HImode:
          if (!nonimmediate_operand (operands[1], E_HImode))
            return -1;
          return 3;

        case E_SImode:
          if (pnum_clobbers == NULL
              || !nonimmediate_operand (operands[1], E_SImode))
            return -1;
          return 4;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern296 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!memory_operand (operands[0], E_DImode)
      || GET_MODE (x1) != E_DImode)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_MODE (x2))
    {
    case E_V8QImode:
      return pattern99 (); /* [-1, 2] */

    case E_V4HImode:
      switch (GET_MODE (operands[1]))
        {
        case E_V4SImode:
          if (!register_operand (operands[1], E_V4SImode))
            return -1;
          return 3;

        case E_V4DImode:
          if (!register_operand (operands[1], E_V4DImode))
            return -1;
          return 4;

        default:
          return -1;
        }

    case E_V2SImode:
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern308 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1
      || !register_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern316 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_all_ones_operand (operands[1], i1)
      || !const0_operand (operands[2], i1))
    return -1;
  x2 = XEXP (x1, 2);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1)
      || !const_0_to_7_operand (operands[5], E_SImode))
    return -1;
  return 0;
}

int
pattern322 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || GET_MODE (x1) != E_V16SFmode
          || !nonimmediate_operand (operands[1], E_V16SFmode))
        return -1;
      return 0;

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || GET_MODE (x1) != E_V8SFmode
          || !nonimmediate_operand (operands[1], E_V8SFmode))
        return -1;
      return 1;

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x1) != E_V4SFmode
          || !nonimmediate_operand (operands[1], E_V4SFmode))
        return -1;
      return 2;

    case E_V8DFmode:
      if (!register_operand (operands[0], E_V8DFmode)
          || GET_MODE (x1) != E_V8DFmode
          || !nonimmediate_operand (operands[1], E_V8DFmode))
        return -1;
      return 3;

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || GET_MODE (x1) != E_V4DFmode
          || !nonimmediate_operand (operands[1], E_V4DFmode))
        return -1;
      return 4;

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || GET_MODE (x1) != E_V2DFmode
          || !nonimmediate_operand (operands[1], E_V2DFmode))
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern333 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x1, 1);
  if (GET_MODE (x4) != i2)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern336 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !bcst_vector_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1
      || !bcst_vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern340 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  return 0;
}

int
pattern342 (rtx x1, int *pnum_clobbers, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != SET)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != i1
      || GET_MODE (x6) != E_SImode)
    return -1;
  x7 = XEXP (x2, 0);
  operands[0] = x7;
  if (!register_operand (operands[0], E_DImode)
      || GET_MODE (x3) != E_DImode)
    return -1;
  return 0;
}

int
pattern346 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  x6 = XEXP (x4, 1);
  return pattern345 (x6); /* [-1, 5] */
}

int
pattern350 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonmemory_operand (operands[2], E_QImode))
    return -1;
  return pattern349 (x1); /* [-1, 5] */
}

int
pattern354 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1
      || !nonimmediate_operand (operands[2], i2))
    return -1;
  x5 = XEXP (x2, 1);
  if (GET_MODE (x5) != i1
      || !nonimmediate_operand (operands[4], i2)
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern358 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  operands[2] = x4;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17)
    return -1;
  x6 = XEXP (x4, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x7) != CLOBBER)
    return -1;
  x8 = XEXP (x7, 0);
  if (GET_CODE (x8) != REG
      || REGNO (x8) != 17
      || GET_MODE (x8) != E_CCmode)
    return -1;
  x9 = XEXP (x2, 0);
  operands[0] = x9;
  x10 = XEXP (x3, 1);
  operands[1] = x10;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return 0;

    case E_HImode:
      return 1;

    case E_SImode:
      return 2;

    case E_DImode:
      return 3;

    default:
      return -1;
    }
}

int
pattern367 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x2, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17)
    return -1;
  x6 = XEXP (x3, 0);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  x8 = XEXP (x6, 1);
  operands[2] = x8;
  x9 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x9))
    {
    case SET:
      x10 = XEXP (x9, 0);
      operands[0] = x10;
      return 0;

    case CLOBBER:
      x10 = XEXP (x9, 0);
      operands[0] = x10;
      switch (GET_MODE (x6))
        {
        case E_QImode:
          if (!nonimmediate_operand (operands[1], E_QImode)
              || !const_1_to_31_operand (operands[2], E_QImode)
              || !scratch_operand (operands[0], E_QImode))
            return -1;
          return 1;

        case E_HImode:
          if (!nonimmediate_operand (operands[1], E_HImode)
              || !const_1_to_31_operand (operands[2], E_QImode)
              || !scratch_operand (operands[0], E_HImode))
            return -1;
          return 2;

        case E_SImode:
          if (!nonimmediate_operand (operands[1], E_SImode)
              || !const_1_to_31_operand (operands[2], E_QImode)
              || !scratch_operand (operands[0], E_SImode))
            return -1;
          return 3;

        case E_DImode:
          if (!nonimmediate_operand (operands[1], E_DImode)
              || !const_1_to_63_operand (operands[2], E_QImode)
              || !scratch_operand (operands[0], E_DImode))
            return -1;
          return 4;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern392 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1)
      || !register_operand (operands[1], i1))
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  x5 = XEXP (x4, 1);
  if (GET_MODE (x5) != i1
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern400 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i2))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern407 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode
          || !nonimmediate_operand (operands[1], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode
          || !nonimmediate_operand (operands[1], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern414 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != UNSPEC
      || XVECLEN (x3, 0) != 1
      || XINT (x3, 1) != 147)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x1, 1);
  if (GET_CODE (x5) != UNSPEC
      || XVECLEN (x5, 0) != 1
      || XINT (x5, 1) != 147)
    return -1;
  x6 = XVECEXP (x5, 0, 0);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern419 (rtx x1, rtx_code i1, int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != PARALLEL
      || XVECLEN (x1, 0) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern424 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XVECEXP (x1, 0, 1);
  operands[3] = x5;
  x6 = XVECEXP (x1, 0, 2);
  operands[4] = x6;
  if (!const_0_to_7_operand (operands[4], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_HImode:
      return pattern422 (x1); /* [-1, 1] */

    case E_QImode:
      if (pattern423 (x1, 
E_V8HImode, 
E_QImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern433 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_no_SP_operand (operands[1], i1)
      || !register_operand (operands[3], i1)
      || !immediate_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern443 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (maybe_ne (SUBREG_BYTE (x2), 0))
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != ZERO_EXTEND)
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (GET_MODE (x1) != E_DImode)
        return -1;
      x5 = XEXP (x1, 0);
      if (GET_MODE (x5) != E_DImode)
        return -1;
      x6 = XEXP (x5, 1);
      if (!const_0_to_63_operand (x6, E_QImode))
        return -1;
      return 0;

    case E_SImode:
      if (GET_MODE (x1) != E_SImode)
        return -1;
      x5 = XEXP (x1, 0);
      if (GET_MODE (x5) != E_SImode)
        return -1;
      x6 = XEXP (x5, 1);
      if (!const_0_to_31_operand (x6, E_QImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern456 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_SELECT)
    return -1;
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 1)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x3, 0);
  operands[1] = x6;
  x7 = XVECEXP (x1, 0, 1);
  operands[2] = x7;
  if (!const48_operand (operands[2], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern455 (x1, 
E_SImode); /* [-1, 2] */

    case E_DImode:
      res = pattern455 (x1, 
E_DImode);
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern466 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_V32HImode
      || !register_operand (operands[0], E_V32HImode)
      || GET_MODE (x1) != E_V32HImode)
    return -1;
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  if (!nonimmediate_operand (operands[1], E_V32HImode))
    return -1;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  if (!const_0_to_255_operand (operands[2], E_SImode))
    return -1;
  x5 = XEXP (x1, 1);
  operands[3] = x5;
  if (!nonimm_or_0_operand (operands[3], E_V32HImode))
    return -1;
  x6 = XEXP (x1, 2);
  operands[4] = x6;
  if (!register_operand (operands[4], E_SImode))
    return -1;
  return 0;
}

int
pattern478 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  x5 = XVECEXP (x2, 0, 2);
  operands[3] = x5;
  if (!const_0_to_255_operand (operands[3], i1))
    return -1;
  x6 = XEXP (x1, 1);
  operands[4] = x6;
  x7 = XEXP (x1, 2);
  operands[5] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_V64QImode:
      return pattern477 (x1, 
E_V64QImode, 
E_DImode); /* [-1, 0] */

    case E_V32QImode:
      if (pattern477 (x1, 
E_V32QImode, 
E_SImode) != 0)
        return -1;
      return 1;

    case E_V16QImode:
      if (pattern477 (x1, 
E_V16QImode, 
E_HImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern488 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  x5 = XVECEXP (x2, 0, 2);
  operands[3] = x5;
  x6 = XEXP (x1, 1);
  switch (GET_CODE (x6))
    {
    case REG:
    case SUBREG:
      if (!rtx_equal_p (x6, operands[1]))
        return -1;
      x7 = XEXP (x1, 2);
      operands[4] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          return pattern484 (x1, 
E_V16SImode, 
E_HImode); /* [-1, 0] */

        case E_V8SImode:
          if (pattern484 (x1, 
E_V8SImode, 
E_QImode) != 0)
            return -1;
          return 1;

        case E_V4SImode:
          if (pattern484 (x1, 
E_V4SImode, 
E_QImode) != 0)
            return -1;
          return 2;

        default:
          return -1;
        }

    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      operands[4] = x6;
      x7 = XEXP (x1, 2);
      operands[5] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern486 (x1, 
E_V16SImode, 
E_HImode) != 0)
            return -1;
          return 3;

        case E_V8SImode:
          if (pattern486 (x1, 
E_V8SImode, 
E_QImode) != 0)
            return -1;
          return 4;

        case E_V4SImode:
          if (pattern486 (x1, 
E_V4SImode, 
E_QImode) != 0)
            return -1;
          return 5;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern503 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != E_V2HFmode
      || !vector_operand (operands[1], i1)
      || !const0_operand (operands[3], E_V2HFmode)
      || !const0_operand (operands[4], E_V6HFmode))
    return -1;
  return 0;
}

int
pattern506 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_V2SImode)
    return -1;
  switch (GET_CODE (x2))
    {
    case VEC_SELECT:
      x3 = XEXP (x2, 1);
      if (GET_CODE (x3) != PARALLEL
          || XVECLEN (x3, 0) != 2)
        return -1;
      x4 = XVECEXP (x3, 0, 0);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x5 = XVECEXP (x3, 0, 1);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x6 = XEXP (x2, 0);
      operands[2] = x6;
      if (!nonimm_or_0_operand (operands[2], E_V4SImode))
        return -1;
      x7 = XEXP (x1, 2);
      operands[3] = x7;
      return 0;

    case CONST_VECTOR:
      if (XVECLEN (x2, 0) != 2)
        return -1;
      x8 = XVECEXP (x2, 0, 0);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x9 = XVECEXP (x2, 0, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x7 = XEXP (x1, 2);
      operands[2] = x7;
      return 1;

    default:
      return -1;
    }
}

int
pattern514 (rtx x1, machine_mode i1, int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (XVECLEN (x1, 0) != i2
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern519 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V8HFmode)
      || GET_MODE (x1) != E_V8HFmode)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HImode:
      if (!vector_operand (operands[1], E_V8HImode))
        return -1;
      return 0;

    case E_V8SImode:
      if (!vector_operand (operands[1], E_V8SImode))
        return -1;
      return 1;

    case E_V8DImode:
      if (!vector_operand (operands[1], E_V8DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern525 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (XVECLEN (x2, 0) < 1)
    return -1;
  operands[4] = x2;
  if (!pmovzx_parallel (operands[4], E_VOIDmode))
    return -1;
  x3 = XEXP (x1, 0);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XEXP (x4, 1);
  operands[2] = x6;
  x7 = XEXP (x3, 1);
  operands[3] = x7;
  x8 = XVECEXP (x2, 0, 0);
  operands[5] = x8;
  if (!const_int_operand (operands[5], E_VOIDmode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      return pattern524 (x1, 
E_V16SImode, 
E_V8SImode, 
E_V32SImode); /* [-1, 0] */

    case E_V8SImode:
      if (pattern524 (x1, 
E_V8SImode, 
E_V4SImode, 
E_V16SImode) != 0)
        return -1;
      return 1;

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x1) != E_V4SImode
          || GET_MODE (x3) != E_V8SImode
          || GET_MODE (x4) != E_V4SImode
          || !vector_operand (operands[1], E_V2SImode)
          || !const0_operand (operands[2], E_V2SImode)
          || !const0_operand (operands[3], E_V4SImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern539 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || GET_MODE (x1) != E_V8HImode)
        return -1;
      return 0;

    case E_V8SImode:
      if (!register_operand (operands[0], E_V8SImode)
          || GET_MODE (x1) != E_V8SImode)
        return -1;
      return 1;

    case E_V8DImode:
      if (!register_operand (operands[0], E_V8DImode)
          || GET_MODE (x1) != E_V8DImode)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern540 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_MODE (x2))
    {
    case E_V4QImode:
      if (!register_operand (operands[1], E_V16QImode))
        return -1;
      return 0;

    case E_V4HImode:
      if (!register_operand (operands[1], E_V8HImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern542 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_DImode)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != UNSPEC
      || XVECLEN (x5, 0) != 1
      || XINT (x5, 1) != 107
      || GET_MODE (x5) != E_DImode)
    return -1;
  x6 = XVECEXP (x5, 0, 0);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern548 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_HImode:
      if (!nonimmediate_operand (operands[0], E_HImode)
          || GET_MODE (x1) != E_HImode)
        return -1;
      return 0;

    case E_SImode:
      if (!nonimmediate_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode)
        return -1;
      return 1;

    case E_DImode:
      if (!nonimmediate_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern553 (rtx x1, int i1, int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != UNSPEC
      || XVECLEN (x3, 0) != i2
      || XINT (x3, 1) != i1
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XEXP (x2, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17
      || GET_MODE (x4) != E_CCmode)
    return -1;
  x5 = XVECEXP (x1, 0, 0);
  x6 = XEXP (x5, 0);
  operands[0] = x6;
  return 0;
}

int
pattern560 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (!bt_comparison_operator (operands[1], E_QImode))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + -1])
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != CLOBBER)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != REG
      || REGNO (x6) != 17
      || GET_MODE (x6) != E_CCmode)
    return -1;
  x7 = XEXP (x2, 0);
  operands[0] = x7;
  if (!nonimmediate_operand (operands[0], E_QImode))
    return -1;
  x8 = XEXP (x3, 0);
  operands[2] = x8;
  switch (GET_MODE (operands[2]))
    {
    case E_QImode:
      if (!register_operand (operands[2], E_QImode))
        return -1;
      return 0;

    case E_HImode:
      if (!register_operand (operands[2], E_HImode))
        return -1;
      return 1;

    case E_SImode:
      if (!register_operand (operands[2], E_SImode))
        return -1;
      return 2;

    case E_DImode:
      if (!register_operand (operands[2], E_DImode))
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern578 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      if (!register_operand (operands[0], E_QImode)
          || GET_MODE (x1) != E_QImode
          || !const_int_operand (operands[1], E_QImode))
        return -1;
      return 0;

    case E_HImode:
      if (!register_operand (operands[0], E_HImode)
          || GET_MODE (x1) != E_HImode
          || !const_int_operand (operands[1], E_HImode))
        return -1;
      return 1;

    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode
          || !const_int_operand (operands[1], E_SImode))
        return -1;
      return 2;

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode
          || !const_int_operand (operands[1], E_DImode))
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern589 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  operands[2] = x4;
  x5 = XEXP (x3, 1);
  operands[3] = x5;
  x6 = XVECEXP (x1, 0, 1);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  x8 = XEXP (x6, 1);
  x9 = XEXP (x8, 0);
  if (!rtx_equal_p (x9, operands[2]))
    return -1;
  x10 = XEXP (x8, 1);
  if (!rtx_equal_p (x10, operands[3]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern390 (x1, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern390 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern595 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern601 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PARALLEL
      || XVECLEN (x3, 0) != 1)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x1, 1);
  if (GET_CODE (x5) != VEC_SELECT)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != PARALLEL
      || XVECLEN (x6, 0) != 1)
    return -1;
  x7 = XVECEXP (x6, 0, 0);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern608 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x6 = XVECEXP (x3, 0, 2);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x7 = XVECEXP (x3, 0, 3);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 3]
      || pattern607 (x1, 
E_V8QImode, 
E_V4QImode, 
E_V4HImode) != 0)
    return -1;
  return 0;
}

int
pattern617 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[1], i2))
    return -1;
  return 0;
}

int
pattern624 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!memory_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern631 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 2);
  operands[3] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V16QImode:
      return pattern630 (x1, 
E_V16QImode, 
E_HImode, 
E_V16HFmode); /* [-1, 0] */

    case E_V32QImode:
      if (pattern630 (x1, 
E_V32QImode, 
E_SImode, 
E_V32HFmode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern637 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      operands[4] = x2;
      x3 = XEXP (x1, 2);
      switch (GET_CODE (x3))
        {
        case REG:
        case SUBREG:
          operands[5] = x3;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              return 0;

            case E_V16HFmode:
              return 1;

            case E_V8HFmode:
              return 2;

            case E_V16SFmode:
              return 3;

            case E_V8SFmode:
              return 4;

            case E_V4SFmode:
              return 5;

            case E_V8DFmode:
              return 6;

            case E_V4DFmode:
              return 7;

            case E_V2DFmode:
              return 8;

            case E_V32BFmode:
              return 9;

            case E_V16BFmode:
              return 10;

            case E_V8BFmode:
              return 11;

            default:
              return -1;
            }

        case CONST_INT:
          if (XWINT (x3, 0) != 1L)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              return 12;

            case E_V2DFmode:
              return 13;

            default:
              return -1;
            }

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      res = pattern636 (x1);
      if (res >= 0)
        return res + 14; /* [14, 28] */
      return -1;

    default:
      return -1;
    }
}

int
pattern654 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !vector_operand (operands[2], i2))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[3], i1)
      || !const0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern660 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[3], i1)
      || !vector_all_ones_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern664 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1)
      || !vector_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern666 (rtx x1, int i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != VEC_SELECT
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_CODE (x2) != PARALLEL
      || XVECLEN (x2, 0) != i1)
    return -1;
  return 0;
}

int
pattern670 (rtx x1, int i1, int i2, int i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  return 0;
}

int
pattern678 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  if (!memory_operand (operands[1], E_SImode))
    return -1;
  x7 = XEXP (x2, 1);
  switch (XVECLEN (x7, 0))
    {
    case 4:
      return pattern675 (x1, 
E_V16QImode, 
E_V4QImode); /* [-1, 1] */

    case 2:
      if (pattern676 (x1, 
E_V2HImode, 
E_V8HImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern685 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x6 = XEXP (x3, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x7) != CLOBBER)
    return -1;
  x8 = XEXP (x7, 0);
  if (GET_CODE (x8) != REG
      || REGNO (x8) != 17
      || GET_MODE (x8) != E_CCmode)
    return -1;
  x9 = XEXP (x2, 0);
  operands[0] = x9;
  if (!register_operand (operands[0], E_QImode)
      || GET_MODE (x3) != E_QImode)
    return -1;
  x10 = XEXP (x4, 0);
  operands[1] = x10;
  x11 = XEXP (x4, 2);
  operands[2] = x11;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  switch (GET_MODE (x4))
    {
    case E_SImode:
      if (!register_operand (operands[1], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!register_operand (operands[1], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern697 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_TFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      return pattern694 (x5, 
E_TFmode); /* [-1, 0] */

    case E_HFmode:
      if (pnum_clobbers == NULL)
        return -1;
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern221 (x5, 
E_V8HFmode, 
E_HFmode) != 0)
        return -1;
      return 1;

    case E_SFmode:
      if (pnum_clobbers == NULL)
        return -1;
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern221 (x5, 
E_V4SFmode, 
E_SFmode) != 0)
        return -1;
      return 2;

    case E_DFmode:
      if (pnum_clobbers == NULL)
        return -1;
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern221 (x5, 
E_V2DFmode, 
E_DFmode) != 0)
        return -1;
      return 3;

    case E_V2SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern695 (x5) != 0)
        return -1;
      return 4;

    case E_V2BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern696 (x5, 
E_V2BFmode) != 0)
        return -1;
      return 5;

    case E_V4BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern696 (x5, 
E_V4BFmode) != 0)
        return -1;
      return 6;

    case E_V2HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern696 (x5, 
E_V2HFmode) != 0)
        return -1;
      return 7;

    case E_V4HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern696 (x5, 
E_V4HFmode) != 0)
        return -1;
      return 8;

    case E_V32BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern694 (x5, 
E_V32BFmode) != 0)
        return -1;
      return 9;

    case E_V16BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern694 (x5, 
E_V16BFmode) != 0)
        return -1;
      return 10;

    case E_V8BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern694 (x5, 
E_V8BFmode) != 0)
        return -1;
      return 11;

    case E_V32HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern694 (x5, 
E_V32HFmode) != 0)
        return -1;
      return 12;

    case E_V16HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern694 (x5, 
E_V16HFmode) != 0)
        return -1;
      return 13;

    case E_V8HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern694 (x5, 
E_V8HFmode) != 0)
        return -1;
      return 14;

    case E_V16SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern694 (x5, 
E_V16SFmode) != 0)
        return -1;
      return 15;

    case E_V8SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern694 (x5, 
E_V8SFmode) != 0)
        return -1;
      return 16;

    case E_V4SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern694 (x5, 
E_V4SFmode) != 0)
        return -1;
      return 17;

    case E_V8DFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern694 (x5, 
E_V8DFmode) != 0)
        return -1;
      return 18;

    case E_V4DFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern694 (x5, 
E_V4DFmode) != 0)
        return -1;
      return 19;

    case E_V2DFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern694 (x5, 
E_V2DFmode) != 0)
        return -1;
      return 20;

    default:
      return -1;
    }
}

int
pattern745 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || !ix86_comparison_uns_operator (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern752 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern751 (x1, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern751 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern758 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !nonimmediate_operand (operands[1], i2))
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern766 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_HFmode:
      if (!nonimmediate_operand (operands[1], E_HFmode))
        return -1;
      return 0;

    case E_SFmode:
      if (!nonimmediate_operand (operands[1], E_SFmode))
        return -1;
      return 1;

    case E_DFmode:
      if (!nonimmediate_operand (operands[1], E_DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern774 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      if (!vector_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_V4SFmode:
      if (!nonimmediate_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    case E_V4DFmode:
      if (!nonimmediate_operand (operands[1], E_V4DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern782 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern790 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i3)
      || GET_MODE (x1) != i3)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern800 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !const0_operand (operands[2], i1)
      || !pmovzx_parallel (operands[3], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern811 (rtx x1, machine_mode i1, int i2, int i3, rtx_code i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != i4
      || XVECLEN (x1, 0) != i3
      || XINT (x1, 1) != i2
      || GET_MODE (x1) != i1)
    return -1;
  return 0;
}

int
pattern814 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (maybe_ne (SUBREG_BYTE (x5), 0)
      || GET_MODE (x5) != E_QImode)
    return -1;
  x6 = XEXP (x5, 0);
  switch (GET_CODE (x6))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[3] = x6;
      x7 = XEXP (x6, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x8 = XEXP (x6, 2);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x9 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x9) != SET)
        return -1;
      x10 = XEXP (x9, 1);
      if (GET_CODE (x10) != SUBREG
          || maybe_ne (SUBREG_BYTE (x10), 0))
        return -1;
      x11 = XEXP (x10, 0);
      if (GET_CODE (x11) != AND
          || GET_MODE (x11) != E_QImode)
        return -1;
      x12 = XEXP (x11, 0);
      if (GET_CODE (x12) != SUBREG
          || maybe_ne (SUBREG_BYTE (x12), 0)
          || GET_MODE (x12) != E_QImode)
        return -1;
      x13 = XEXP (x12, 0);
      switch (GET_CODE (x13))
        {
        case SIGN_EXTRACT:
        case ZERO_EXTRACT:
          if (!rtx_equal_p (x13, operands[3]))
            return -1;
          x14 = XEXP (x9, 0);
          if (GET_CODE (x14) != ZERO_EXTRACT)
            return -1;
          x15 = XEXP (x14, 1);
          if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x16 = XEXP (x14, 2);
          if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x17 = XEXP (x2, 0);
          operands[4] = x17;
          if (!flags_reg_operand (operands[4], E_VOIDmode))
            return -1;
          operands[5] = x3;
          if (!compare_operator (operands[5], E_VOIDmode)
              || GET_MODE (x4) != E_QImode)
            return -1;
          return pattern584 (x1); /* [-1, 2] */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern837 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 3
      || XVECLEN (x1, 0) != 1
      || XINT (x1, 1) != 1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern841 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (!nonimmediate_operand (operands[0], E_DImode)
          || !general_operand (operands[1], E_DImode))
        return -1;
      return 0;

    case E_TImode:
      if (!nonimmediate_operand (operands[0], E_TImode)
          || !general_operand (operands[1], E_TImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern847 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || !ix86_comparison_int_operator (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern850 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i2)
      || !register_mmxmem_operand (operands[2], i2))
    return -1;
  x4 = XEXP (x1, 1);
  if (GET_MODE (x4) != i2)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern856 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  operands[1] = x3;
  x4 = XEXP (x2, 0);
  if (!rtx_equal_p (x4, operands[0]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return pattern855 (x1, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern855 (x1, 
E_HImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern864 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 2);
  if (GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern870 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      return pattern869 (x1, 
E_DImode, 
E_V64QImode); /* [-1, 0] */

    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode)
        return -1;
      x2 = XEXP (x1, 0);
      if (GET_MODE (x2) != E_SImode
          || !register_operand (operands[3], E_SImode))
        return -1;
      res = pattern866 ();
      if (res >= 0)
        return res + 1; /* [1, 2] */
      return -1;

    default:
      return -1;
    }
}

int
pattern878 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  operands[1] = x3;
  x4 = XEXP (x2, 0);
  if (!rtx_equal_p (x4, operands[0]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern855 (x1, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern855 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern887 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  operands[2] = x2;
  if (!register_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 1);
  operands[1] = x3;
  if (!reg_or_0_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern897 (rtx x1, int i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != VEC_SELECT
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_CODE (x2) != PARALLEL
      || XVECLEN (x2, 0) != i1)
    return -1;
  x3 = XVECEXP (x2, 0, 0);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern904 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !nonimm_or_0_operand (operands[2], i2)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern908 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern912 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !const0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern914 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x2 = XEXP (x1, 2);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern918 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x2) != CONST_INT)
    return -1;
  x3 = XVECEXP (x1, 0, 3);
  if (GET_CODE (x3) != CONST_INT)
    return -1;
  x4 = XVECEXP (x1, 0, 4);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  x5 = XVECEXP (x1, 0, 5);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x1, 0, 6);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  x7 = XVECEXP (x1, 0, 7);
  if (GET_CODE (x7) != CONST_INT)
    return -1;
  return 0;
}

int
pattern928 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[2], i2)
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern935 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern934 (x1, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern934 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern943 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i2))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern949 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[2] = x2;
  if (!general_reg_operand (operands[2], i2))
    return -1;
  x3 = XEXP (x1, 1);
  operands[3] = x3;
  if (!general_reg_operand (operands[3], i2))
    return -1;
  x4 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x4) != PARALLEL)
    return -1;
  switch (XVECLEN (x4, 0))
    {
    case 2:
      x5 = XVECEXP (x4, 0, 0);
      if (GET_CODE (x5) != SET)
        return -1;
      x6 = XEXP (x5, 1);
      if (GET_CODE (x6) != MULT)
        return -1;
      x7 = XEXP (x5, 0);
      operands[4] = x7;
      x8 = XEXP (x6, 0);
      switch (GET_CODE (x8))
        {
        case ZERO_EXTEND:
          if (GET_MODE (x8) != i1)
            return -1;
          x9 = XEXP (x6, 1);
          if (GET_CODE (x9) != ZERO_EXTEND
              || GET_MODE (x9) != i1)
            return -1;
          x10 = XVECEXP (x4, 0, 1);
          if (GET_CODE (x10) != CLOBBER)
            return -1;
          x11 = XEXP (x10, 0);
          if (GET_CODE (x11) != REG
              || REGNO (x11) != 17
              || GET_MODE (x11) != E_CCmode
              || !general_reg_operand (operands[4], i1)
              || GET_MODE (x6) != i1)
            return -1;
          x12 = XEXP (x8, 0);
          if (!rtx_equal_p (x12, operands[2]))
            return -1;
          x13 = XEXP (x9, 0);
          if (!rtx_equal_p (x13, operands[0]))
            return -1;
          return 0;

        case REG:
          if (!rtx_equal_p (x8, operands[2]))
            return -1;
          x10 = XVECEXP (x4, 0, 1);
          if (GET_CODE (x10) != SET)
            return -1;
          x14 = XEXP (x10, 1);
          if (GET_CODE (x14) != UMUL_HIGHPART
              || GET_MODE (x14) != i2
              || !general_reg_operand (operands[4], i2)
              || GET_MODE (x6) != i2)
            return -1;
          x11 = XEXP (x10, 0);
          operands[5] = x11;
          if (!general_reg_operand (operands[5], i2))
            return -1;
          x9 = XEXP (x6, 1);
          if (!rtx_equal_p (x9, operands[0]))
            return -1;
          x15 = XEXP (x14, 0);
          if (!rtx_equal_p (x15, operands[2]))
            return -1;
          x16 = XEXP (x14, 1);
          if (!rtx_equal_p (x16, operands[0]))
            return -1;
          return 1;

        default:
          return -1;
        }

    case 3:
      x5 = XVECEXP (x4, 0, 0);
      if (GET_CODE (x5) != SET)
        return -1;
      x10 = XVECEXP (x4, 0, 1);
      if (GET_CODE (x10) != CLOBBER)
        return -1;
      x17 = XVECEXP (x4, 0, 2);
      if (GET_CODE (x17) != CLOBBER)
        return -1;
      x18 = XEXP (x17, 0);
      if (GET_CODE (x18) != REG
          || REGNO (x18) != 17
          || GET_MODE (x18) != E_CCmode)
        return -1;
      x7 = XEXP (x5, 0);
      operands[4] = x7;
      return 2;

    default:
      return -1;
    }
}

int
pattern974 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_MODE (x2))
    {
    case E_HImode:
      switch (GET_MODE (operands[1]))
        {
        case E_V4HImode:
          if (!register_operand (operands[1], E_V4HImode)
              || !const_0_to_3_operand (operands[2], E_SImode))
            return -1;
          return 0;

        case E_V2HImode:
          if (!register_operand (operands[1], E_V2HImode)
              || !const_0_to_1_operand (operands[2], E_SImode))
            return -1;
          return 1;

        case E_V8HImode:
          if (!register_operand (operands[1], E_V8HImode)
              || !const_0_to_7_operand (operands[2], E_SImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    case E_QImode:
      res = pattern973 ();
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern984 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V8DImode)
      || GET_MODE (x1) != E_V8DImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_V8DImode
      || !nonimm_or_0_operand (operands[2], E_V8DImode)
      || !register_operand (operands[3], E_QImode))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      if (!vector_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_V8DFmode:
      if (!vector_operand (operands[1], E_V8DFmode))
        return -1;
      return 1;

    case E_V8SFmode:
      if (!vector_operand (operands[1], E_V8SFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern996 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[2], i2)
      || !const0_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1004 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern1015 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V8HFmode)
      || GET_MODE (x1) != E_V8HFmode)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != E_V8HFmode)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HImode:
      if (!register_operand (operands[1], E_V8HImode))
        return -1;
      return 0;

    case E_V8SImode:
      if (!register_operand (operands[1], E_V8SImode))
        return -1;
      return 1;

    case E_V8DImode:
      if (!register_operand (operands[1], E_V8DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1027 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != SUBREG
      || maybe_ne (SUBREG_BYTE (x4), 0)
      || GET_MODE (x4) != E_QImode)
    return -1;
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[3] = x5;
      x6 = XEXP (x5, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x7 = XEXP (x5, 2);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x8 = XEXP (x1, 0);
      if (GET_CODE (x8) != ZERO_EXTRACT)
        return -1;
      x9 = XEXP (x8, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x10 = XEXP (x8, 2);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x11 = XEXP (x8, 0);
      operands[0] = x11;
      if (!int248_register_operand (operands[0], E_VOIDmode))
        return -1;
      x12 = XEXP (x5, 0);
      operands[1] = x12;
      if (!int248_register_operand (operands[1], E_VOIDmode))
        return -1;
      return 0;

    default:
      return -1;
    }
}

int
pattern1039 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2)
    return -1;
  x6 = XEXP (x5, 0);
  if (!register_operand (x6, i1))
    return -1;
  return 0;
}

int
pattern1044 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i2)
      || !vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1048 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !const_int_operand (operands[2], i1))
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern1053 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode
      || !register_operand (operands[1], E_XFmode))
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  return pattern548 (x5); /* [-1, 2] */
}

int
pattern1058 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != E_DImode)
    return -1;
  x2 = XEXP (x1, 1);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!nonimmediate_operand (operands[0], E_DImode))
    return -1;
  x4 = XEXP (x1, 2);
  operands[1] = x4;
  if (!const_0_to_63_operand (operands[1], E_QImode))
    return -1;
  return 0;
}

int
pattern1064 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i2)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1073 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  return pattern1072 (x2); /* [-1, 11] */
}

int
pattern1079 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  return pattern1078 (x2); /* [-1, 11] */
}

int
pattern1084 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1
      || !vector_all_ones_operand (operands[3], i1)
      || !const0_operand (operands[4], i1)
      || !register_operand (operands[1], i1)
      || !const0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1089 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], E_QImode))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      if (!vector_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_V8SFmode:
      if (!nonimmediate_operand (operands[1], E_V8SFmode))
        return -1;
      return 1;

    case E_V8DFmode:
      if (!nonimmediate_operand (operands[1], E_V8DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1093 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i3)
      || !vector_operand (operands[2], i3)
      || !nonimm_or_0_operand (operands[3], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1098 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (!rtx_equal_p (x2, operands[1]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V4SFmode:
      return pattern461 (x1, 
E_V4SFmode); /* [-1, 0] */

    case E_V2DFmode:
      if (pattern461 (x1, 
E_V2DFmode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1106 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_operand (operands[2], i1)
      || !register_operand (operands[1], i1)
      || !const_0_to_15_operand (operands[3], E_SImode))
    return -1;
  return 0;
}

int
pattern1113 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3, machine_mode i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i4
      || !register_operand (operands[1], i3)
      || !nonimm_or_0_operand (operands[3], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1118 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != E_V8HFmode)
    return -1;
  x5 = XEXP (x3, 2);
  if (GET_CODE (x5) != UNSPEC
      || XVECLEN (x5, 0) != 1
      || XINT (x5, 1) != 223
      || GET_MODE (x5) != E_QImode)
    return -1;
  x6 = XEXP (x2, 2);
  if (XWINT (x6, 0) != 3L
      || !register_operand (operands[0], E_V8HFmode)
      || GET_MODE (x1) != E_V8HFmode
      || GET_MODE (x2) != E_V8HFmode
      || GET_MODE (x3) != E_V8HFmode)
    return -1;
  x7 = XVECEXP (x4, 0, 0);
  operands[1] = x7;
  if (!nonimmediate_operand (operands[1], E_V8HFmode))
    return -1;
  x8 = XVECEXP (x4, 0, 1);
  operands[2] = x8;
  if (!register_operand (operands[2], E_V8HFmode))
    return -1;
  x9 = XEXP (x3, 1);
  operands[3] = x9;
  if (!nonimm_or_0_operand (operands[3], E_V8HFmode))
    return -1;
  x10 = XVECEXP (x5, 0, 0);
  operands[4] = x10;
  if (!register_operand (operands[4], E_QImode))
    return -1;
  x11 = XVECEXP (x1, 0, 1);
  operands[5] = x11;
  if (!const_4_or_8_to_11_operand (operands[5], E_SImode))
    return -1;
  x12 = XEXP (x2, 1);
  if (!rtx_equal_p (x12, operands[1]))
    return -1;
  return 0;
}

int
pattern1139 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_HImode:
      if (!register_operand (operands[0], E_HImode)
          || GET_MODE (x1) != E_HImode)
        return -1;
      x2 = XEXP (x1, 0);
      if (GET_MODE (x2) != E_QImode)
        return -1;
      return 0;

    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode)
        return -1;
      x2 = XEXP (x1, 0);
      switch (GET_MODE (x2))
        {
        case E_QImode:
          return 1;

        case E_HImode:
          return 2;

        default:
          return -1;
        }

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode)
        return -1;
      x2 = XEXP (x1, 0);
      switch (GET_MODE (x2))
        {
        case E_QImode:
          return 3;

        case E_HImode:
          return 4;

        case E_SImode:
          return 5;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1154 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (maybe_ne (SUBREG_BYTE (x3), 0)
      || GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  return pattern1153 (x2, 
i1); /* [-1, 2] */
}

int
pattern1161 (rtx x1, machine_mode i1, int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x5) != SET)
    return -1;
  x6 = XEXP (x5, 1);
  return pattern1160 (x6, 
i1, 
i2); /* [-1, 0] */
}

int
pattern1167 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  x4 = XEXP (x1, 0);
  switch (GET_CODE (x4))
    {
    case STRICT_LOW_PART:
      return pattern556 (x1); /* [-1, 1] */

    case REG:
    case SUBREG:
    case MEM:
      operands[0] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (GET_MODE (x2) != E_DImode)
            return -1;
          return 2;

        case E_TImode:
          if (pattern564 (x2, 
E_TImode) != 0)
            return -1;
          return 3;

        case E_HImode:
          if (GET_MODE (x2) != E_HImode
              || !const_int_operand (operands[2], E_HImode))
            return -1;
          return 4;

        case E_SImode:
          if (GET_MODE (x2) != E_SImode
              || !const_int_operand (operands[2], E_SImode))
            return -1;
          return 5;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1184 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != PARALLEL
      || XVECLEN (x1, 0) != 2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PLUS
      || GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != PLUS
      || GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != LTU
      || GET_MODE (x5) != i1)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != REG
      || REGNO (x6) != 17
      || GET_MODE (x6) != E_CCmode)
    return -1;
  x7 = XEXP (x5, 1);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x8 = XEXP (x3, 1);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x9 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x9) != CLOBBER)
    return -1;
  x10 = XEXP (x9, 0);
  if (GET_CODE (x10) != REG
      || REGNO (x10) != 17
      || GET_MODE (x10) != E_CCmode)
    return -1;
  x11 = XEXP (x4, 1);
  if (!rtx_equal_p (x11, operands[0]))
    return -1;
  x12 = XEXP (x2, 0);
  if (!rtx_equal_p (x12, operands[0]))
    return -1;
  x13 = PATTERN (peep2_next_insn (3));
  if (GET_CODE (x13) != PARALLEL
      || XVECLEN (x13, 0) != 2)
    return -1;
  x14 = XVECEXP (x13, 0, 0);
  if (GET_CODE (x14) != SET)
    return -1;
  x15 = XEXP (x14, 1);
  if (GET_CODE (x15) != NEG
      || GET_MODE (x15) != i1)
    return -1;
  x16 = XVECEXP (x13, 0, 1);
  if (GET_CODE (x16) != CLOBBER)
    return -1;
  x17 = XEXP (x16, 0);
  if (GET_CODE (x17) != REG
      || REGNO (x17) != 17
      || GET_MODE (x17) != E_CCmode)
    return -1;
  x18 = XEXP (x15, 0);
  if (!rtx_equal_p (x18, operands[0]))
    return -1;
  x19 = XEXP (x14, 0);
  if (!rtx_equal_p (x19, operands[0]))
    return -1;
  return 0;
}

int
pattern1209 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1214 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[2], i2))
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1218 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!memory_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !memory_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_SImode:
      if (!register_operand (operands[1], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!register_operand (operands[1], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1223 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_DImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != i1
      || GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XVECEXP (x1, 0, 0);
  x6 = XEXP (x5, 1);
  x7 = XEXP (x6, 0);
  if (GET_MODE (x7) != E_SImode
      || !nonimmediate_operand (operands[1], E_SImode)
      || !register_operand (operands[0], E_DImode))
    return -1;
  x8 = XEXP (x4, 0);
  if (!rtx_equal_p (x8, operands[1]))
    return -1;
  return 0;
}

int
pattern1229 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1236 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  switch (GET_CODE (x2))
    {
    case REG:
    case SUBREG:
      operands[0] = x2;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (!register_operand (operands[0], E_DImode))
            return -1;
          x3 = XEXP (x1, 1);
          if (GET_MODE (x3) != E_DImode)
            return -1;
          return 0;

        case E_TImode:
          x3 = XEXP (x1, 1);
          if (pattern1234 (x3, 
E_TImode) != 0)
            return -1;
          return 1;

        default:
          return -1;
        }

    case STRICT_LOW_PART:
      res = pattern1235 (x1);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1248 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[1], i1)
      || GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_HImode:
      if (!nonimmediate_operand (operands[2], E_HImode))
        return -1;
      return 0;

    case E_SImode:
      if (!nonimmediate_operand (operands[2], E_SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1256 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != SIGN_EXTEND
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != VEC_SELECT
      || GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PARALLEL)
    return -1;
  return 0;
}

int
pattern1262 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  x3 = XVECEXP (x2, 0, 2);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern1271 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_V8HFmode
      || !register_operand (operands[0], E_V8HFmode)
      || GET_MODE (x1) != E_V8HFmode
      || GET_MODE (x2) != E_V8HFmode
      || !nonimmediate_operand (operands[1], E_V8HFmode)
      || !nonimm_or_0_operand (operands[3], E_V8HFmode)
      || !register_operand (operands[2], E_V8HFmode))
    return -1;
  return 0;
}

int
pattern1281 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[1], i2))
    return -1;
  x3 = XEXP (x2, 2);
  return pattern1280 (x3, 
i1, 
i2); /* [-1, 0] */
}

int
pattern1289 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i3)
      || !nonimm_or_0_operand (operands[2], i2)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1297 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V16HFmode)
      || GET_MODE (x1) != E_V16HFmode)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != E_V16HFmode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_V16HFmode
      || !nonimm_or_0_operand (operands[2], E_V16HFmode)
      || !register_operand (operands[3], E_HImode))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V16HImode:
      if (!register_operand (operands[1], E_V16HImode))
        return -1;
      return 0;

    case E_V16SImode:
      if (!register_operand (operands[1], E_V16SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1306 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1))
    return -1;
  x2 = XEXP (x1, 2);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1311 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_DImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != i1
      || GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XVECEXP (x1, 0, 0);
  x6 = XEXP (x5, 1);
  x7 = XEXP (x6, 0);
  if (GET_MODE (x7) != E_SImode
      || !nonimmediate_operand (operands[1], E_SImode)
      || !const_1_to_31_operand (operands[2], E_QImode)
      || !register_operand (operands[0], E_DImode))
    return -1;
  x8 = XEXP (x4, 0);
  if (!rtx_equal_p (x8, operands[1]))
    return -1;
  x9 = XEXP (x4, 1);
  if (!rtx_equal_p (x9, operands[2]))
    return -1;
  return 0;
}

int
pattern1325 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != LABEL_REF)
    return -1;
  x4 = XEXP (x2, 2);
  if (GET_CODE (x4) != PC)
    return -1;
  x5 = XEXP (x1, 0);
  if (GET_CODE (x5) != PC)
    return -1;
  x6 = XEXP (x2, 0);
  operands[0] = x6;
  x7 = XEXP (x6, 0);
  x8 = XEXP (x7, 0);
  operands[1] = x8;
  x9 = XEXP (x7, 2);
  switch (GET_CODE (x9))
    {
    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      return 0;

    case AND:
      if (GET_MODE (x9) != E_QImode)
        return -1;
      x10 = XEXP (x9, 0);
      operands[2] = x10;
      if (!register_operand (operands[2], E_QImode))
        return -1;
      x11 = XEXP (x9, 1);
      operands[3] = x11;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return -1;
      x12 = XEXP (x3, 0);
      operands[4] = x12;
      switch (GET_MODE (x7))
        {
        case E_SImode:
          if (!register_operand (operands[1], E_SImode))
            return -1;
          return 1;

        case E_DImode:
          if (!register_operand (operands[1], E_DImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1352 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[4]))
    {
    case E_QImode:
      if (!register_operand (operands[4], E_QImode))
        return -1;
      return 0;

    case E_HImode:
      if (!register_operand (operands[4], E_HImode))
        return -1;
      return 1;

    case E_SImode:
      if (!register_operand (operands[4], E_SImode))
        return -1;
      return 2;

    case E_DImode:
      if (!register_operand (operands[4], E_DImode))
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern1357 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i2)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1368 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[2], i2)
      || GET_MODE (x1) != i2
      || !nonimmediate_operand (operands[3], i2)
      || !const0_operand (operands[4], i2)
      || !register_operand (operands[5], i1))
    return -1;
  return 0;
}

int
pattern1376 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1384 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  operands[4] = x4;
  x5 = XEXP (x3, 2);
  operands[5] = x5;
  if (!register_operand (operands[5], E_QImode))
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  operands[6] = x6;
  if (!const48_operand (operands[6], E_SImode))
    return -1;
  x7 = XEXP (x2, 1);
  if (!rtx_equal_p (x7, operands[1]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      return pattern1383 (x1, 
E_V8HFmode); /* [-1, 0] */

    case E_V4SFmode:
      if (pattern1383 (x1, 
E_V4SFmode) != 0)
        return -1;
      return 1;

    case E_V2DFmode:
      if (pattern1383 (x1, 
E_V2DFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1398 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x2, 2);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1406 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  if (!int248_register_operand (operands[0], E_VOIDmode))
    return -1;
  x4 = XEXP (x1, 1);
  operands[3] = x4;
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case AND:
      return pattern1405 (x1); /* [-1, 2] */

    case IOR:
      res = pattern1405 (x1);
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    case XOR:
      res = pattern1405 (x1);
      if (res >= 0)
        return res + 6; /* [6, 8] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1420 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1426 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  operands[1] = x3;
  x4 = XEXP (x2, 0);
  if (!rtx_equal_p (x4, operands[0]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return pattern1425 (x1, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern1425 (x1, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_SImode:
      if (pattern1425 (x1, 
E_SImode) != 0)
        return -1;
      return 2;

    case E_DImode:
      if (pattern1425 (x1, 
E_DImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern1438 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_QImode)
      || GET_MODE (x1) != E_QImode)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != E_QImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_QImode
      || !const_0_to_31_operand (operands[3], E_SImode))
    return -1;
  return 0;
}

int
pattern1445 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1455 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 2);
  x3 = XVECEXP (x2, 0, 0);
  if (maybe_ne (SUBREG_BYTE (x3), 0))
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != NOT)
    return -1;
  x5 = XEXP (x4, 0);
  operands[3] = x5;
  if (!const_0_to_7_operand (operands[5], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V4SImode:
      return pattern1453 (x1, 
E_V4SImode, 
E_V16QImode); /* [-1, 0] */

    case E_V2DImode:
      if (pattern1453 (x1, 
E_V2DImode, 
E_V16QImode) != 0)
        return -1;
      return 1;

    case E_V8SImode:
      if (pattern1453 (x1, 
E_V8SImode, 
E_V32QImode) != 0)
        return -1;
      return 2;

    case E_V4DImode:
      if (pattern1453 (x1, 
E_V4DImode, 
E_V32QImode) != 0)
        return -1;
      return 3;

    case E_V32QImode:
      if (pattern1454 (x1, 
E_V32QImode, 
E_SImode) != 0)
        return -1;
      return 4;

    case E_V16QImode:
      if (pattern1454 (x1, 
E_V16QImode, 
E_HImode) != 0)
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern1471 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[1], i1)
      || !const_0_to_15_operand (operands[2], E_VOIDmode)
      || !const_0_to_15_operand (operands[3], E_VOIDmode)
      || !const_0_to_15_operand (operands[4], E_VOIDmode)
      || !const_0_to_15_operand (operands[5], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1480 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[2], i1)
      || !const_int_operand (operands[3], i1)
      || !register_operand (operands[1], i1))
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  x5 = XEXP (x4, 1);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern1490 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (maybe_ne (SUBREG_BYTE (x1), 0)
      || GET_MODE (x1) != E_QImode
      || !nonimmediate_operand (operands[0], E_SImode))
    return -1;
  x2 = XEXP (x1, 0);
  return pattern1152 (x2); /* [-1, 2] */
}

int
pattern1494 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      if (!register_operand (operands[1], E_V8HFmode)
          || !nonimmediate_operand (operands[2], E_V8HFmode))
        return -1;
      return 0;

    case E_V4SFmode:
      if (!register_operand (operands[1], E_V4SFmode)
          || !nonimmediate_operand (operands[2], E_V4SFmode))
        return -1;
      return 1;

    case E_V2DFmode:
      if (!register_operand (operands[1], E_V2DFmode)
          || !nonimmediate_operand (operands[2], E_V2DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1508 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !ix86_carry_flag_operator (operands[2], i1)
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1516 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case COMPARE:
      x4 = XEXP (x2, 0);
      if (GET_CODE (x4) != REG
          || REGNO (x4) != 17)
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x5) != SET)
        return -1;
      x6 = XEXP (x5, 1);
      if (GET_MODE (x6) != i1)
        return -1;
      x7 = XEXP (x5, 0);
      if (!rtx_equal_p (x7, operands[0]))
        return -1;
      x8 = PATTERN (peep2_next_insn (2));
      x9 = XEXP (x8, 0);
      if (!rtx_equal_p (x9, operands[1]))
        return -1;
      x10 = XEXP (x3, 0);
      switch (GET_CODE (x10))
        {
        case REG:
          return pattern1178 (x1, 
i1); /* [-1, 0] */

        case PLUS:
          if (pattern1179 (x1, 
i1) != 0)
            return -1;
          return 1;

        default:
          return -1;
        }

    case PLUS:
      res = pattern1181 (x1, 
i1);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    case MINUS:
      res = pattern1182 (x1, 
i1);
      if (res >= 0)
        return res + 4; /* [4, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1534 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern1543 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x6 = XEXP (x4, 1);
  if (GET_MODE (x6) != i2
      || !sext_operand (operands[2], i1)
      || pattern718 (x1, 
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1553 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  switch (GET_CODE (x1))
    {
    case UNSPEC:
      if (pnum_clobbers == NULL
          || XVECLEN (x1, 0) != 1
          || XINT (x1, 1) != 32)
        return -1;
      x2 = XVECEXP (x1, 0, 0);
      if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      return 0;

    case CLOBBER:
      x3 = XEXP (x1, 0);
      if (GET_CODE (x3) != REG
          || REGNO (x3) != 17
          || GET_MODE (x3) != E_CCmode)
        return -1;
      return 1;

    case USE:
      if (pnum_clobbers == NULL)
        return -1;
      x3 = XEXP (x1, 0);
      operands[4] = x3;
      if (!register_operand (operands[4], E_SImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1564 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1572 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i2)
      || pattern1571 (
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1581 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x5 = XEXP (x3, 2);
  if (GET_MODE (x5) != i1
      || !nonimmediate_operand (operands[3], i1)
      || !const0_operand (operands[4], i1)
      || !register_operand (operands[5], E_QImode))
    return -1;
  return 0;
}

int
pattern1594 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V8SImode:
      if (!register_operand (operands[2], E_V8SImode))
        return -1;
      return 0;

    case E_V8DImode:
      if (!register_operand (operands[2], E_V8DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1601 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[6], E_QImode)
      || !vsib_mem_operator (operands[5], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1600 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1600 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1612 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern1618 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XVECEXP (x2, 0, 2);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x1, 1);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern1627 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (!rtx_equal_p (x3, operands[1]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      return pattern1626 (x1, 
E_V8HFmode); /* [-1, 0] */

    case E_V4SFmode:
      if (pattern1626 (x1, 
E_V4SFmode) != 0)
        return -1;
      return 1;

    case E_V2DFmode:
      if (pattern1626 (x1, 
E_V2DFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1636 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !register_operand (operands[7], E_QImode)
      || !vsib_mem_operator (operands[6], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1635 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1635 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1650 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  if (XWINT (x2, 0) != 2L)
    return -1;
  x3 = XVECEXP (x1, 0, 3);
  if (XWINT (x3, 0) != 2L)
    return -1;
  x4 = XVECEXP (x1, 0, 4);
  if (XWINT (x4, 0) != 4L)
    return -1;
  x5 = XVECEXP (x1, 0, 5);
  if (XWINT (x5, 0) != 4L)
    return -1;
  x6 = XVECEXP (x1, 0, 6);
  if (XWINT (x6, 0) != 6L)
    return -1;
  x7 = XVECEXP (x1, 0, 7);
  if (XWINT (x7, 0) != 6L)
    return -1;
  return 0;
}

int
pattern1661 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], E_DImode))
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_DImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_TImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != E_TImode)
    return -1;
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  if (!register_operand (operands[1], E_DImode))
    return -1;
  x6 = XEXP (x3, 1);
  operands[3] = x6;
  if (!const_0_to_255_operand (operands[3], E_QImode))
    return -1;
  x7 = XEXP (x1, 0);
  x8 = XEXP (x7, 0);
  if (!rtx_equal_p (x8, operands[0]))
    return -1;
  return 0;
}

int
pattern1673 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!bt_comparison_operator (operands[3], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_MODE (x2))
    {
    case E_V16QImode:
      return pattern1672 (x1, 
E_V16QImode); /* [-1, 0] */

    case E_V8HImode:
      if (pattern1672 (x1, 
E_V8HImode) != 0)
        return -1;
      return 1;

    case E_V4SImode:
      if (pattern1672 (x1, 
E_V4SImode) != 0)
        return -1;
      return 2;

    case E_V2DImode:
      if (pattern1672 (x1, 
E_V2DImode) != 0)
        return -1;
      return 3;

    case E_V1TImode:
      if (pattern1672 (x1, 
E_V1TImode) != 0)
        return -1;
      return 4;

    case E_V4SFmode:
      if (pattern1672 (x1, 
E_V4SFmode) != 0)
        return -1;
      return 5;

    case E_V2DFmode:
      if (pattern1672 (x1, 
E_V2DFmode) != 0)
        return -1;
      return 6;

    case E_V32QImode:
      if (pattern1672 (x1, 
E_V32QImode) != 0)
        return -1;
      return 7;

    case E_V16HImode:
      if (pattern1672 (x1, 
E_V16HImode) != 0)
        return -1;
      return 8;

    case E_V8SImode:
      if (pattern1672 (x1, 
E_V8SImode) != 0)
        return -1;
      return 9;

    case E_V4DImode:
      if (pattern1672 (x1, 
E_V4DImode) != 0)
        return -1;
      return 10;

    case E_V2TImode:
      if (pattern1672 (x1, 
E_V2TImode) != 0)
        return -1;
      return 11;

    case E_V8SFmode:
      if (pattern1672 (x1, 
E_V8SFmode) != 0)
        return -1;
      return 12;

    case E_V4DFmode:
      if (pattern1672 (x1, 
E_V4DFmode) != 0)
        return -1;
      return 13;

    default:
      return -1;
    }
}

int
pattern1700 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!vsib_mem_operator (operands[5], i1)
      || !register_operand (operands[6], E_QImode))
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[3], i1)
      || !scratch_operand (operands[1], E_QImode))
    return -1;
  x3 = XEXP (x1, 0);
  x4 = XEXP (x3, 0);
  switch (GET_MODE (x4))
    {
    case E_SImode:
      return pattern1699 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1699 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1713 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XVECEXP (x4, 0, 1);
  if (GET_MODE (x5) != i1
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1720 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[3], i1)
      || !const0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1728 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[4], i1))
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V8SImode:
      if (!register_operand (operands[3], E_V8SImode))
        return -1;
      return 0;

    case E_V8DImode:
      if (!register_operand (operands[3], E_V8DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1736 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !ix86_carry_flag_operator (operands[3], i1)
      || !x86_64_general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1743 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[1], i1)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !x86_64_dwzext_immediate_operand (operands[2], i2)
      || !scratch_operand (operands[0], i1))
    return -1;
  return 0;
}

int
pattern1749 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1759 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[2], i1))
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V4SImode:
      if (!register_operand (operands[3], E_V4SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[3], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1766 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != E_SImode
      || !general_reg_operand (operands[4], E_SImode))
    return -1;
  x2 = XEXP (x1, 0);
  if (!rtx_equal_p (x2, operands[2]))
    return -1;
  x3 = XEXP (x1, 1);
  if (!rtx_equal_p (x3, operands[0]))
    return -1;
  return 0;
}

int
pattern1774 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (operands[4]))
    {
    case E_V4SImode:
      if (!register_operand (operands[4], E_V4SImode))
        return -1;
      return 0;

    case E_V2DImode:
      if (!register_operand (operands[4], E_V2DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1782 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !const_int_operand (operands[3], i2))
    return -1;
  x6 = XEXP (x3, 1);
  if (GET_MODE (x6) != i2)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_MODE (x7) != i1
      || !x86_64_immediate_operand (operands[2], i1)
      || !register_operand (operands[0], i1))
    return -1;
  x8 = XVECEXP (x1, 0, 1);
  x9 = XEXP (x8, 1);
  if (GET_MODE (x9) != i1)
    return -1;
  return 0;
}

int
pattern1791 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x4 = XEXP (x1, 1);
  operands[2] = x4;
  if (!nonimm_or_0_operand (operands[2], i1))
    return -1;
  x5 = XEXP (x1, 2);
  operands[3] = x5;
  x6 = XEXP (x3, 1);
  if (!rtx_equal_p (x6, operands[1]))
    return -1;
  return 0;
}

int
pattern1802 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i3)
      || GET_MODE (x1) != i3)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i3)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i1))
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_MODE (x4) != i2
      || !vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1809 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!memory_operand (operands[0], i1))
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonmemory_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  return 0;
}

int
pattern1815 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_15_operand (operands[2], E_VOIDmode)
      || !const_0_to_15_operand (operands[3], E_VOIDmode)
      || !const_0_to_15_operand (operands[4], E_VOIDmode)
      || !const_0_to_15_operand (operands[5], E_VOIDmode)
      || !const_0_to_15_operand (operands[6], E_VOIDmode)
      || !const_0_to_15_operand (operands[7], E_VOIDmode)
      || !const_0_to_15_operand (operands[8], E_VOIDmode)
      || !const_0_to_15_operand (operands[9], E_VOIDmode)
      || !const_0_to_15_operand (operands[10], E_VOIDmode)
      || !const_0_to_15_operand (operands[11], E_VOIDmode)
      || !const_0_to_15_operand (operands[12], E_VOIDmode)
      || !const_0_to_15_operand (operands[13], E_VOIDmode)
      || !const_0_to_15_operand (operands[14], E_VOIDmode)
      || !const_0_to_15_operand (operands[15], E_VOIDmode)
      || !const_0_to_15_operand (operands[16], E_VOIDmode)
      || !const_0_to_15_operand (operands[17], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1828 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != SIGN_EXTEND
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != VEC_SELECT
      || GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PARALLEL)
    return -1;
  return 0;
}

int
pattern1832 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[6], i1)
      || !register_operand (operands[4], i1)
      || !register_operand (operands[5], i1)
      || !register_operand (operands[0], i1)
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1838 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_15_operand (operands[4], E_VOIDmode)
      || !const_0_to_15_operand (operands[5], E_VOIDmode)
      || !const_0_to_15_operand (operands[6], E_VOIDmode)
      || !const_0_to_15_operand (operands[7], E_VOIDmode)
      || !const_0_to_15_operand (operands[8], E_VOIDmode)
      || !const_0_to_15_operand (operands[9], E_VOIDmode)
      || !const_0_to_15_operand (operands[10], E_VOIDmode)
      || !const_16_to_31_operand (operands[11], E_VOIDmode)
      || !const_16_to_31_operand (operands[12], E_VOIDmode)
      || !const_16_to_31_operand (operands[13], E_VOIDmode)
      || !const_16_to_31_operand (operands[14], E_VOIDmode)
      || !const_16_to_31_operand (operands[15], E_VOIDmode)
      || !const_16_to_31_operand (operands[16], E_VOIDmode)
      || !const_16_to_31_operand (operands[17], E_VOIDmode)
      || !const_16_to_31_operand (operands[18], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1848 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  if (XVECLEN (x1, 0) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
    return -1;
  x6 = XVECEXP (x1, 0, 4);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
    return -1;
  x7 = XVECEXP (x1, 0, 5);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 11])
    return -1;
  x8 = XVECEXP (x1, 0, 6);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
    return -1;
  x9 = XVECEXP (x1, 0, 7);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 15])
    return -1;
  return 0;
}

int
pattern1858 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!x86_64_immediate_operand (operands[2], i1)
      || !nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern1862 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !ix86_carry_flag_operator (operands[4], i2))
    return -1;
  x7 = XEXP (x4, 1);
  if (GET_MODE (x7) != i2
      || !x86_64_sext_operand (operands[2], i1)
      || pattern1860 (x1, 
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1870 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 24);
  if (XWINT (x2, 0) != 24L)
    return -1;
  x3 = XVECEXP (x1, 0, 25);
  if (XWINT (x3, 0) != 25L)
    return -1;
  x4 = XVECEXP (x1, 0, 26);
  if (XWINT (x4, 0) != 26L)
    return -1;
  x5 = XVECEXP (x1, 0, 27);
  if (XWINT (x5, 0) != 27L)
    return -1;
  return 0;
}

int
pattern1872 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i3
      || !register_operand (operands[1], i2))
    return -1;
  x5 = XEXP (x3, 1);
  if (GET_MODE (x5) != i3
      || !vector_operand (operands[2], i2)
      || !nonimm_or_0_operand (operands[3], i1))
    return -1;
  return 0;
}

 int
recog_6 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  if (pattern56 (x1, 
E_CCFPmode) != 0)
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  if (GET_MODE (x3) != E_CCFPmode)
    return -1;
  switch (GET_CODE (x3))
    {
    case COMPARE:
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
          operands[0] = x4;
          x5 = XEXP (x3, 1);
          operands[1] = x5;
          switch (GET_MODE (operands[0]))
            {
            case E_XFmode:
              if (!register_operand (operands[0], E_XFmode)
                  || !register_operand (operands[1], E_XFmode)
                  || !
#line 2029 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && TARGET_CMOVE))
                return -1;
              return 49; /* *cmpiuxf_i387 */

            case E_SFmode:
              if (!register_operand (operands[0], E_SFmode)
                  || !register_ssemem_operand (operands[1], E_SFmode)
                  || !
#line 2069 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH)
   || (TARGET_80387 && TARGET_CMOVE)))
                return -1;
              return 57; /* *cmpiusf */

            case E_DFmode:
              if (!register_operand (operands[0], E_DFmode)
                  || !register_ssemem_operand (operands[1], E_DFmode)
                  || !
#line 2069 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH)
   || (TARGET_80387 && TARGET_CMOVE)))
                return -1;
              return 59; /* *cmpiudf */

            case E_HFmode:
              if (!register_operand (operands[0], E_HFmode)
                  || !nonimmediate_operand (operands[1], E_HFmode)
                  || !
#line 2106 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
                return -1;
              return 61; /* *cmpiuhf */

            default:
              return -1;
            }

        case VEC_SELECT:
          if (pattern601 (x3) != 0)
            return -1;
          x6 = XEXP (x4, 0);
          operands[0] = x6;
          x5 = XEXP (x3, 1);
          x7 = XEXP (x5, 0);
          operands[1] = x7;
          switch (GET_MODE (x4))
            {
            case E_HFmode:
              if (!register_operand (operands[0], E_V8HFmode)
                  || GET_MODE (x5) != E_HFmode
                  || !nonimmediate_operand (operands[1], E_V8HFmode)
                  || !(
#line 4872 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(SSE_FLOAT_MODE_P (HFmode) || HFmode == E_HFmode) && 
#line 1355 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16)))
                return -1;
              return 3644; /* avx512fp16_ucomi */

            case E_SFmode:
              if (!register_operand (operands[0], E_V4SFmode)
                  || GET_MODE (x5) != E_SFmode
                  || !nonimmediate_operand (operands[1], E_V4SFmode)
                  || !
#line 4872 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(SSE_FLOAT_MODE_P (SFmode) || SFmode == E_HFmode))
                return -1;
              return 3648; /* sse_ucomi */

            case E_DFmode:
              if (!register_operand (operands[0], E_V2DFmode)
                  || GET_MODE (x5) != E_DFmode
                  || !nonimmediate_operand (operands[1], E_V2DFmode)
                  || !
#line 4872 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(SSE_FLOAT_MODE_P (DFmode) || DFmode == E_HFmode))
                return -1;
              return 3652; /* sse2_ucomi */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSPEC:
      switch (XVECLEN (x3, 0))
        {
        case 1:
          if (XINT (x3, 1) != 44)
            return -1;
          x8 = XVECEXP (x3, 0, 0);
          if (GET_CODE (x8) != COMPARE
              || GET_MODE (x8) != E_CCFPmode)
            return -1;
          x9 = XEXP (x8, 0);
          operands[0] = x9;
          x10 = XEXP (x8, 1);
          operands[1] = x10;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (!register_operand (operands[0], E_SFmode)
                  || !nonimmediate_operand (operands[1], E_SFmode)
                  || !
#line 2045 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX10_2))
                return -1;
              return 51; /* *cmpxusf */

            case E_DFmode:
              if (!register_operand (operands[0], E_DFmode)
                  || !nonimmediate_operand (operands[1], E_DFmode)
                  || !
#line 2045 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX10_2))
                return -1;
              return 53; /* *cmpxudf */

            case E_HFmode:
              if (!register_operand (operands[0], E_HFmode)
                  || !nonimmediate_operand (operands[1], E_HFmode)
                  || !
#line 2058 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX10_2))
                return -1;
              return 55; /* *cmpxuhf */

            default:
              return -1;
            }

        case 2:
          if (XINT (x3, 1) != 61
              || pattern843 (x3) != 0)
            return -1;
          x8 = XVECEXP (x3, 0, 0);
          x9 = XEXP (x8, 0);
          operands[0] = x9;
          x11 = XVECEXP (x3, 0, 1);
          x12 = XEXP (x11, 0);
          operands[1] = x12;
          switch (GET_MODE (x8))
            {
            case E_HFmode:
              if (!register_operand (operands[0], E_V8HFmode)
                  || GET_MODE (x11) != E_HFmode
                  || !nonimmediate_operand (operands[1], E_V8HFmode)
                  || !(
#line 4857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 1355 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16)))
                return -1;
              return 3632; /* avx10_2_ucomxhf */

            case E_SFmode:
              if (!register_operand (operands[0], E_V4SFmode)
                  || GET_MODE (x11) != E_SFmode
                  || !nonimmediate_operand (operands[1], E_V4SFmode)
                  || !
#line 4857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 3636; /* avx10_2_ucomxsf */

            case E_DFmode:
              if (!register_operand (operands[0], E_V2DFmode)
                  || GET_MODE (x11) != E_DFmode
                  || !nonimmediate_operand (operands[1], E_V2DFmode)
                  || !
#line 4857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 3640; /* avx10_2_ucomxdf */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_16 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x1, 1);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      if (!register_operand (operands[0], E_QImode))
        return -1;
      if (general_operand (operands[1], E_QImode)
          && 
#line 3453 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return 111; /* *movstrictqi_1 */
      if (pnum_clobbers == NULL
          || !const0_operand (operands[1], E_QImode)
          || !
#line 3462 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
        return -1;
      *pnum_clobbers = 1;
      return 113; /* *movstrictqi_xor */

    case E_HImode:
      if (!register_operand (operands[0], E_HImode))
        return -1;
      if (general_operand (operands[1], E_HImode)
          && 
#line 3453 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return 112; /* *movstricthi_1 */
      if (pnum_clobbers == NULL
          || !const0_operand (operands[1], E_HImode)
          || !
#line 3462 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
        return -1;
      *pnum_clobbers = 1;
      return 114; /* *movstricthi_xor */

    default:
      return -1;
    }
}

 int
recog_19 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  switch (GET_CODE (x2))
    {
    case SIGN_EXTRACT:
      x4 = XEXP (x2, 1);
      switch (XWINT (x4, 0))
        {
        case 8L:
          x5 = XEXP (x2, 2);
          if (XWINT (x5, 0) != 8L
              || !int248_register_operand (operands[1], E_VOIDmode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_HImode:
              if (!register_operand (operands[0], E_HImode)
                  || GET_MODE (x2) != E_HImode)
                return -1;
              return 118; /* *extvhi */

            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || GET_MODE (x2) != E_SImode)
                return -1;
              return 119; /* *extvsi */

            default:
              return -1;
            }

        case 1L:
          if (pnum_clobbers == NULL)
            return -1;
          x5 = XEXP (x2, 2);
          if (XWINT (x5, 0) != 0L)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || GET_MODE (x2) != E_SImode
                  || !register_operand (operands[1], E_SImode))
                return -1;
              *pnum_clobbers = 1;
              return 120; /* *extvsi_1_0 */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || GET_MODE (x2) != E_DImode
                  || !register_operand (operands[1], E_DImode)
                  || !
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              *pnum_clobbers = 1;
              return 121; /* *extvdi_1_0 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case ZERO_EXTRACT:
      x4 = XEXP (x2, 1);
      if (XWINT (x4, 0) != 8L)
        return -1;
      x5 = XEXP (x2, 2);
      if (XWINT (x5, 0) != 8L
          || !int248_register_operand (operands[1], E_VOIDmode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          if (!register_operand (operands[0], E_HImode)
              || GET_MODE (x2) != E_HImode)
            return -1;
          return 122; /* *extzvhi */

        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x2) != E_SImode)
            return -1;
          return 123; /* *extzvsi */

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 124; /* *extzvdi */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_20 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != CONST_INT)
    return -1;
  x4 = XEXP (x2, 2);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  res = recog_19 (x1, insn, pnum_clobbers);
  if (res >= 0)
    return res;
  if (XWINT (x4, 0) != 8L
      || XWINT (x3, 0) != 8L
      || pattern425 (x5) != 0)
    return -1;
  x6 = XEXP (x2, 0);
  switch (GET_CODE (x6))
    {
    case REG:
    case SUBREG:
      operands[1] = x6;
      if (!int248_register_operand (operands[1], E_VOIDmode))
        return -1;
      operands[2] = x2;
      switch (GET_MODE (x5))
        {
        case E_HImode:
          if (!extract_operator (operands[2], E_HImode))
            return -1;
          return 134; /* *insvqi_2 */

        case E_SImode:
          if (!extract_operator (operands[2], E_SImode))
            return -1;
          return 135; /* *insvqi_2 */

        case E_DImode:
          if (!extract_operator (operands[2], E_DImode)
              || !
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 136; /* *insvqi_2 */

        default:
          return -1;
        }

    case AND:
      switch (pattern1188 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
            return -1;
          *pnum_clobbers = 1;
          return 800; /* *andqi_exthi_3 */

        case 1:
          if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
            return -1;
          *pnum_clobbers = 1;
          return 803; /* *andqi_extsi_3 */

        case 2:
          if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 806; /* *andqi_extdi_3 */

        default:
          return -1;
        }

    case IOR:
      switch (pattern1188 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
            return -1;
          *pnum_clobbers = 1;
          return 801; /* *iorqi_exthi_3 */

        case 1:
          if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
            return -1;
          *pnum_clobbers = 1;
          return 804; /* *iorqi_extsi_3 */

        case 2:
          if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 807; /* *iorqi_extdi_3 */

        default:
          return -1;
        }

    case XOR:
      switch (pattern1188 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
            return -1;
          *pnum_clobbers = 1;
          return 802; /* *xorqi_exthi_3 */

        case 1:
          if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
            return -1;
          *pnum_clobbers = 1;
          return 805; /* *xorqi_extsi_3 */

        case 2:
          if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 808; /* *xorqi_extdi_3 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_21 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  switch (pattern1 (x1, pnum_clobbers))
    {
    case 0:
      if (!(
#line 16657 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (8 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 8 * BITS_PER_UNIT - 1))
	 == (2 * 8 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1128; /* *lshrti3_doubleword_mask_1 */

    case 1:
      x2 = XEXP (x1, 1);
      x3 = XEXP (x2, 1);
      switch (GET_CODE (x3))
        {
        case CONST_INT:
          switch (pattern257 (x1))
            {
            case 0:
              return 137; /* *insvqi_3 */

            case 1:
              return 139; /* *insvqi_3 */

            case 2:
              if (
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return 141; /* *insvqi_3 */
              break;

            default:
              break;
            }
          break;

        case SUBREG:
          if (pnum_clobbers != NULL
              && pattern427 (x1, 
E_TImode) == 0
              && (
#line 16596 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (8 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 8 * BITS_PER_UNIT - 1))
	 == (2 * 8 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1124; /* *lshrti3_doubleword_mask */
            }
          break;

        default:
          break;
        }
      operands[2] = x3;
      switch (pattern258 (x1, pnum_clobbers))
        {
        case 0:
          switch (GET_MODE (operands[0]))
            {
            case E_TImode:
              if (pnum_clobbers == NULL
                  || pattern738 (x2, 
E_TImode, 
E_QImode) != 0
                  || !
#line 1196 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              *pnum_clobbers = 1;
              return 1132; /* lshrti3_doubleword */

            case E_QImode:
              if (pattern623 (x2, 
E_QImode) != 0)
                return -1;
              if (
#line 17575 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, QImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
                return 1212; /* *lshrqi3_1_nf */
              if (pnum_clobbers == NULL
                  || !
#line 17575 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, QImode, operands, TARGET_APX_NDD)
   && true))
                return -1;
              *pnum_clobbers = 1;
              return 1213; /* *lshrqi3_1 */

            case E_HImode:
              if (pattern623 (x2, 
E_HImode) != 0)
                return -1;
              if (
#line 17613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, HImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
                return 1214; /* *lshrhi3_1_nf */
              if (pnum_clobbers == NULL
                  || !
#line 17613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, HImode, operands, TARGET_APX_NDD)
   && true))
                return -1;
              *pnum_clobbers = 1;
              return 1215; /* *lshrhi3_1 */

            case E_V4HImode:
              if (pattern738 (x2, 
E_V4HImode, 
E_DImode) != 0
                  || !
#line 3896 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                return -1;
              return 2203; /* mmx_lshrv4hi3 */

            case E_V2SImode:
              if (pattern738 (x2, 
E_V2SImode, 
E_DImode) != 0
                  || !
#line 3896 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                return -1;
              return 2205; /* mmx_lshrv2si3 */

            case E_V1DImode:
              if (pattern738 (x2, 
E_V1DImode, 
E_DImode) != 0
                  || !
#line 3896 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                return -1;
              return 2207; /* mmx_lshrv1di3 */

            case E_V1SImode:
              if (pattern738 (x2, 
E_V1SImode, 
E_DImode) != 0
                  || !
#line 3933 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                return -1;
              return 2209; /* mmx_lshrv1si3 */

            case E_V2HImode:
              if (pattern738 (x2, 
E_V2HImode, 
E_DImode) != 0
                  || !
#line 3950 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                return -1;
              return 2211; /* lshrv2hi3 */

            case E_V2QImode:
              if (pnum_clobbers == NULL
                  || pattern738 (x2, 
E_V2QImode, 
E_QImode) != 0
                  || !
#line 4012 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_PARTIAL_REG_STALL || optimize_size))
                return -1;
              *pnum_clobbers = 1;
              return 2215; /* lshrv2qi3 */

            default:
              return -1;
            }

        case 1:
          if (!
#line 17652 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          *pnum_clobbers = 1;
          return 1216; /* *lshrqi3_1_slp */

        case 2:
          if (!
#line 17652 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          *pnum_clobbers = 1;
          return 1218; /* *lshrhi3_1_slp */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_24 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case AND:
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      x5 = XEXP (x3, 1);
      operands[3] = x5;
      x6 = XEXP (x3, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
        case MEM:
          operands[1] = x6;
          switch (pattern69 (x2))
            {
            case 0:
              if (!
#line 3716 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && CONST_WIDE_INT_P (operands[3])
   && CONST_WIDE_INT_NUNITS (operands[3]) == 2
   && CONST_WIDE_INT_ELT (operands[3], 0) == -1
   && CONST_WIDE_INT_ELT (operands[3], 1) == 0))
                return -1;
              return 145; /* *insvti_highpart_1 */

            case 1:
              if (!
#line 3738 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && CONST_WIDE_INT_P (operands[3])
   && CONST_WIDE_INT_NUNITS (operands[3]) == 2
   && CONST_WIDE_INT_ELT (operands[3], 0) == 0
   && CONST_WIDE_INT_ELT (operands[3], 1) == -1))
                return -1;
              return 148; /* *insvti_lowpart_1 */

            case 2:
              if (!
#line 3760 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT
   && CONST_INT_P (operands[3])
   && UINTVAL (operands[3]) == 0xffffffff00000000ll))
                return -1;
              return 151; /* *insvdi_lowpart_1 */

            default:
              return -1;
            }

        case XOR:
          if (pnum_clobbers == NULL
              || GET_MODE (x6) != E_HImode
              || !register_operand (operands[0], E_HImode)
              || GET_MODE (x2) != E_HImode
              || GET_MODE (x3) != E_HImode)
            return -1;
          x7 = XEXP (x6, 0);
          operands[1] = x7;
          if (!nonimmediate_operand (operands[1], E_HImode))
            return -1;
          x8 = XEXP (x6, 1);
          operands[2] = x8;
          if (!nonimmediate_operand (operands[2], E_HImode)
              || !nonimmediate_operand (operands[3], E_HImode))
            return -1;
          x9 = XEXP (x2, 1);
          if (!rtx_equal_p (x9, operands[1])
              || !
#line 13698 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 840; /* *xor2andn */

        default:
          return -1;
        }

    case ASHIFT:
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      x6 = XEXP (x3, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
          operands[1] = x6;
          switch (pattern606 (x2))
            {
            case 0:
              if (!
#line 8027 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
   && ((unsigned HOST_WIDE_INT) INTVAL (operands[3])
       < (HOST_WIDE_INT_1U << INTVAL (operands[2])))))
                return -1;
              return 373; /* *leaqi_general_4 */

            case 1:
              if (!
#line 8027 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
   && ((unsigned HOST_WIDE_INT) INTVAL (operands[3])
       < (HOST_WIDE_INT_1U << INTVAL (operands[2])))))
                return -1;
              return 375; /* *leahi_general_4 */

            case 2:
              if (!(
#line 14151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 16 * BITS_PER_UNIT / 2
   && (TImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1196 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 933; /* *concatditi3_5 */

            case 3:
              if (!(
#line 14074 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 897; /* *concatditi3_1 */

            default:
              return -1;
            }

        case SIGN_EXTEND:
          switch (pattern428 (x2))
            {
            case 0:
              if (!(
#line 14110 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 912; /* *concatditi3_3 */

            case 1:
              if (!(
#line 14183 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT
   && (TImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 942; /* *concatditi3_6 */

            default:
              return -1;
            }

        case ZERO_EXTEND:
          switch (pattern428 (x2))
            {
            case 0:
              if (!(
#line 14110 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 915; /* *concatditi3_3 */

            case 1:
              if (!(
#line 14183 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT
   && (TImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 945; /* *concatditi3_6 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x3;
      switch (pattern76 (x1, pnum_clobbers))
        {
        case 0:
          if (
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            {
              *pnum_clobbers = 1;
              return 727; /* *xorqi_1_slp */
            }
          break;

        case 1:
          if (
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            {
              *pnum_clobbers = 1;
              return 730; /* *xorhi_1_slp */
            }
          break;

        case 2:
          if ((
#line 13541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 822; /* *xorti3_doubleword */
            }
          break;

        case 3:
          if (
#line 13599 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, HImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
            return 825; /* *xorhi_1_nf */
          if (pnum_clobbers != NULL
              && 
#line 13599 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, HImode, operands, TARGET_APX_NDD)
   && true))
            {
              *pnum_clobbers = 1;
              return 826; /* *xorhi_1 */
            }
          break;

        case 4:
          if (
#line 1357 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE))
            return 2079; /* xorv2sf3 */
          break;

        case 5:
          if (
#line 2583 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE))
            return 2113; /* xorv2bf3 */
          break;

        case 6:
          if ((
#line 2583 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2225 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)))
            return 2116; /* xorv4bf3 */
          break;

        case 7:
          if (
#line 2583 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE))
            return 2119; /* xorv2hf3 */
          break;

        case 8:
          if ((
#line 2583 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2226 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)))
            return 2122; /* xorv4hf3 */
          break;

        case 9:
          if (
#line 4692 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (XOR, V8QImode, operands)))
            return 2276; /* *mmx_xorv8qi3 */
          break;

        case 10:
          if (
#line 4692 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (XOR, V4HImode, operands)))
            return 2279; /* *mmx_xorv4hi3 */
          break;

        case 11:
          if (
#line 4692 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (XOR, V2SImode, operands)))
            return 2282; /* *mmx_xorv2si3 */
          break;

        case 12:
          if (
#line 4718 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (XOR, V4QImode, operands)))
            {
              *pnum_clobbers = 1;
              return 2285; /* *xorv4qi3 */
            }
          break;

        case 13:
          if (
#line 4718 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (XOR, V2QImode, operands)))
            {
              *pnum_clobbers = 1;
              return 2288; /* *xorv2qi3 */
            }
          break;

        case 14:
          if (
#line 4718 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (XOR, V2HImode, operands)))
            {
              *pnum_clobbers = 1;
              return 2291; /* *xorv2hi3 */
            }
          break;

        case 15:
          if (
#line 5666 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return 3747; /* xorbf3 */
          break;

        case 16:
          if (
#line 5666 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return 3750; /* xorhf3 */
          break;

        case 17:
          if (
#line 5666 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return 3753; /* xorsf3 */
          break;

        case 18:
          if ((
#line 5666 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 1352 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE2)))
            return 3756; /* xordf3 */
          break;

        case 19:
          if (
#line 5740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 3759; /* *xortf3 */
          break;

        default:
          break;
        }
      if (pnum_clobbers != NULL
          && pattern77 (x2) == 0)
        {
          x6 = XEXP (x3, 0);
          x7 = XEXP (x6, 0);
          operands[2] = x7;
          switch (pattern1250 (x1))
            {
            case 0:
              if (
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                {
                  *pnum_clobbers = 1;
                  return 733; /* *xorqi_exthi_1_slp */
                }
              break;

            case 1:
              if (
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                {
                  *pnum_clobbers = 1;
                  return 736; /* *xorqi_extsi_1_slp */
                }
              break;

            case 2:
              if ((
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                {
                  *pnum_clobbers = 1;
                  return 739; /* *xorqi_extdi_1_slp */
                }
              break;

            case 3:
              *pnum_clobbers = 1;
              return 757; /* *xorqi_exthi_0 */

            case 4:
              *pnum_clobbers = 1;
              return 760; /* *xorqi_extsi_0 */

            case 5:
              if (
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                {
                  *pnum_clobbers = 1;
                  return 763; /* *xorqi_extdi_0 */
                }
              break;

            default:
              break;
            }
          x9 = XEXP (x2, 1);
          if (GET_CODE (x9) == SUBREG)
            {
              switch (pattern1253 (x1))
                {
                case 0:
                  if (
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    {
                      *pnum_clobbers = 1;
                      return 742; /* *xorqi_exthi_2_slp */
                    }
                  break;

                case 1:
                  if (
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    {
                      *pnum_clobbers = 1;
                      return 745; /* *xorqi_extsi_2_slp */
                    }
                  break;

                case 2:
                  if ((
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pnum_clobbers = 1;
                      return 748; /* *xorqi_extdi_2_slp */
                    }
                  break;

                case 3:
                  *pnum_clobbers = 1;
                  return 766; /* *xorqi_ext2hi_0 */

                case 4:
                  *pnum_clobbers = 1;
                  return 769; /* *xorqi_ext2si_0 */

                case 5:
                  if (
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    {
                      *pnum_clobbers = 1;
                      return 772; /* *xorqi_ext2di_0 */
                    }
                  break;

                default:
                  break;
                }
            }
        }
      operands[1] = x3;
      if (pattern78 (x1) != 0)
        return -1;
      if (
#line 13789 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, QImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
        return 869; /* *xorqi_1_nf */
      if (pnum_clobbers == NULL
          || !
#line 13789 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, QImode, operands, TARGET_APX_NDD)
   && true))
        return -1;
      *pnum_clobbers = 1;
      return 870; /* *xorqi_1 */

    case ZERO_EXTEND:
      switch (pattern38 (x1))
        {
        case 0:
          if (!(
#line 14091 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 903; /* *concatditi3_2 */

        case 1:
          if (!(
#line 14135 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 924; /* *concatditi3_4 */

        case 2:
          if (!(
#line 14135 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 927; /* *concatditi3_4 */

        case 3:
          if (!(
#line 14212 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TImode == DImode
   ? CONST_INT_P (operands[2])
     && (UINTVAL (operands[2]) & GET_MODE_MASK (SImode)) == 0
     && !ix86_endbr_immediate_operand (operands[2], VOIDmode)
   : CONST_WIDE_INT_P (operands[2])
     && CONST_WIDE_INT_NUNITS (operands[2]) == 2
     && CONST_WIDE_INT_ELT (operands[2], 0) == 0
     && !ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[2],
								    1)),
				       VOIDmode)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 951; /* *concatditi3_7 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_42 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  switch (pattern4 (x1, pnum_clobbers))
    {
    case 0:
      if (!
#line 18204 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (QImode)-1))
      == GET_MODE_BITSIZE (QImode)-1
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1292; /* *rotlqi3_mask_1 */

    case 1:
      if (!
#line 18204 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (HImode)-1))
      == GET_MODE_BITSIZE (HImode)-1
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1294; /* *rotlhi3_mask_1 */

    case 2:
      if (!
#line 18285 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (1 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1308; /* *rotlqi3_add_1 */

    case 3:
      if (!
#line 18285 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (2 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1310; /* *rotlhi3_add_1 */

    case 4:
      if (!
#line 18354 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (1 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1324; /* *rotlqi3_sub_1 */

    case 5:
      if (!
#line 18354 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (2 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1326; /* *rotlhi3_sub_1 */

    case 6:
      x2 = XEXP (x1, 0);
      operands[0] = x2;
      x3 = XEXP (x1, 1);
      switch (pattern269 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 18156 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (QImode)-1))
      == GET_MODE_BITSIZE (QImode)-1
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1284; /* *rotlqi3_mask */
            }
          break;

        case 1:
          if (
#line 18156 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (HImode)-1))
      == GET_MODE_BITSIZE (HImode)-1
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1286; /* *rotlhi3_mask */
            }
          break;

        case 2:
          if (
#line 18249 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (1 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1300; /* *rotlqi3_add */
            }
          break;

        case 3:
          if (
#line 18249 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (2 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1302; /* *rotlhi3_add */
            }
          break;

        case 4:
          if (
#line 18318 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (1 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1316; /* *rotlqi3_sub */
            }
          break;

        case 5:
          if (
#line 18318 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (2 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1318; /* *rotlhi3_sub */
            }
          break;

        case 6:
          if (pnum_clobbers != NULL
              && pattern615 (x3) == 0
              && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            {
              *pnum_clobbers = 2;
              return 1333; /* ix86_rotlti3_doubleword */
            }
          x4 = XEXP (x3, 1);
          if (XWINT (x4, 0) == 64L
              && register_operand (operands[0], E_TImode)
              && GET_MODE (x3) == E_TImode
              && register_operand (operands[1], E_TImode)
              && 
#line 18477 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 1338; /* rotl64ti2_doubleword */
          break;

        default:
          break;
        }
      x4 = XEXP (x3, 1);
      operands[2] = x4;
      switch (pattern270 (x1, pnum_clobbers))
        {
        case 0:
          if (
#line 18691 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
            return 1373; /* *rotlqi3_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 18691 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          *pnum_clobbers = 1;
          return 1374; /* *rotlqi3_1 */

        case 1:
          if (
#line 18691 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
            return 1377; /* *rotlhi3_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 18691 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          *pnum_clobbers = 1;
          return 1378; /* *rotlhi3_1 */

        case 2:
          if (!
#line 18722 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          *pnum_clobbers = 1;
          return 1381; /* *rotlqi3_1_slp */

        case 3:
          if (!
#line 18722 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          *pnum_clobbers = 1;
          return 1383; /* *rotlhi3_1_slp */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_52 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case AND:
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      switch (pattern70 (x2))
        {
        case 0:
          if (!
#line 3716 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && CONST_WIDE_INT_P (operands[3])
   && CONST_WIDE_INT_NUNITS (operands[3]) == 2
   && CONST_WIDE_INT_ELT (operands[3], 0) == -1
   && CONST_WIDE_INT_ELT (operands[3], 1) == 0))
            return -1;
          return 143; /* *insvti_highpart_1 */

        case 1:
          if (!
#line 3738 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && CONST_WIDE_INT_P (operands[3])
   && CONST_WIDE_INT_NUNITS (operands[3]) == 2
   && CONST_WIDE_INT_ELT (operands[3], 0) == 0
   && CONST_WIDE_INT_ELT (operands[3], 1) == -1))
            return -1;
          return 146; /* *insvti_lowpart_1 */

        case 2:
          if (!
#line 3760 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT
   && CONST_INT_P (operands[3])
   && UINTVAL (operands[3]) == 0xffffffff00000000ll))
            return -1;
          return 149; /* *insvdi_lowpart_1 */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x3;
      res = recog_51 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      if (pnum_clobbers == NULL
          || pattern77 (x2) != 0)
        return -1;
      x5 = XEXP (x3, 0);
      x6 = XEXP (x5, 0);
      operands[2] = x6;
      switch (pattern1250 (x1))
        {
        case 0:
          if (
#line 7007 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            {
              *pnum_clobbers = 1;
              return 303; /* *addqi_exthi_1_slp */
            }
          break;

        case 1:
          if (
#line 7007 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            {
              *pnum_clobbers = 1;
              return 304; /* *addqi_extsi_1_slp */
            }
          break;

        case 2:
          if ((
#line 7007 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 305; /* *addqi_extdi_1_slp */
            }
          break;

        case 3:
          *pnum_clobbers = 1;
          return 327; /* *addqi_exthi_0 */

        case 4:
          *pnum_clobbers = 1;
          return 328; /* *addqi_extsi_0 */

        case 5:
          if (
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            {
              *pnum_clobbers = 1;
              return 329; /* *addqi_extdi_0 */
            }
          break;

        default:
          break;
        }
      x7 = XEXP (x2, 1);
      if (GET_CODE (x7) != SUBREG)
        return -1;
      switch (pattern1253 (x1))
        {
        case 0:
          if (!
#line 7040 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          *pnum_clobbers = 1;
          return 306; /* *addqi_exthi_2_slp */

        case 1:
          if (!
#line 7040 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          *pnum_clobbers = 1;
          return 307; /* *addqi_extsi_2_slp */

        case 2:
          if (!(
#line 7040 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 308; /* *addqi_extdi_2_slp */

        case 3:
          *pnum_clobbers = 1;
          return 330; /* *addqi_ext2hi_0 */

        case 4:
          *pnum_clobbers = 1;
          return 331; /* *addqi_ext2si_0 */

        case 5:
          if (!
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 332; /* *addqi_ext2di_0 */

        default:
          return -1;
        }

    case ZERO_EXTEND:
      if (GET_MODE (x3) != E_TImode)
        return -1;
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      switch (pattern279 (x2, pnum_clobbers, 
E_TImode, 
E_DImode))
        {
        case 0:
          if (!(
#line 6523 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (UNKNOWN, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 269; /* *addti3_doubleword_zext */

        case 1:
          if (!(
#line 14091 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 901; /* *concatditi3_2 */

        case 2:
          if (!(
#line 14135 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 922; /* *concatditi3_4 */

        case 3:
          if (!(
#line 14135 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 925; /* *concatditi3_4 */

        case 4:
          if (!(
#line 14212 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TImode == DImode
   ? CONST_INT_P (operands[2])
     && (UINTVAL (operands[2]) & GET_MODE_MASK (SImode)) == 0
     && !ix86_endbr_immediate_operand (operands[2], VOIDmode)
   : CONST_WIDE_INT_P (operands[2])
     && CONST_WIDE_INT_NUNITS (operands[2]) == 2
     && CONST_WIDE_INT_ELT (operands[2], 0) == 0
     && !ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[2],
								    1)),
				       VOIDmode)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 949; /* *concatditi3_7 */

        default:
          return -1;
        }

    case PLUS:
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      x5 = XEXP (x3, 0);
      switch (GET_CODE (x5))
        {
        case ASHIFT:
          x6 = XEXP (x5, 0);
          switch (GET_CODE (x6))
            {
            case ZERO_EXTEND:
              if (pnum_clobbers == NULL
                  || GET_MODE (x6) != E_TImode)
                return -1;
              x8 = XEXP (x3, 1);
              if (GET_CODE (x8) != ZERO_EXTEND
                  || GET_MODE (x8) != E_TImode
                  || pattern991 (x2, 
E_TImode) != 0)
                return -1;
              switch (pattern84 (x2, 
E_TImode, 
E_DImode))
                {
                case 0:
                  if (!(
#line 6554 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 273; /* *addti3_doubleword_concat */

                case 1:
                  if (!(
#line 6585 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 279; /* *addti3_doubleword_concat_zext */

                default:
                  return -1;
                }

            case REG:
            case SUBREG:
              switch (pattern577 (x2))
                {
                case 0:
                  if (!
#line 8002 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    return -1;
                  return 370; /* *leaqi_general_3b */

                case 1:
                  if (!
#line 8002 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    return -1;
                  return 371; /* *leahi_general_3b */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case REG:
        case SUBREG:
          switch (pattern432 (x2))
            {
            case 0:
              if (!
#line 7910 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              return 362; /* *leaqi_general_1 */

            case 1:
              if (!
#line 7910 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              return 363; /* *leahi_general_1 */

            default:
              return -1;
            }

        case MULT:
          switch (pattern435 (x2))
            {
            case 0:
              if (!
#line 7976 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              return 368; /* *leaqi_general_3 */

            case 1:
              if (!
#line 7976 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              return 369; /* *leahi_general_3 */

            default:
              return -1;
            }

        case LTU:
        case UNLT:
          if (pnum_clobbers == NULL)
            return -1;
          operands[4] = x5;
          x9 = XEXP (x5, 1);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x6 = XEXP (x5, 0);
          operands[3] = x6;
          if (!flags_reg_operand (operands[3], E_VOIDmode))
            return -1;
          x8 = XEXP (x3, 1);
          operands[1] = x8;
          x7 = XEXP (x2, 1);
          operands[2] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_QImode:
              if (pattern1345 (x2, 
E_QImode) != 0
                  || !
#line 8805 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)))
                return -1;
              *pnum_clobbers = 1;
              return 453; /* addqi3_carry */

            case E_HImode:
              if (pattern1345 (x2, 
E_HImode) != 0
                  || !
#line 8805 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)))
                return -1;
              *pnum_clobbers = 1;
              return 454; /* addhi3_carry */

            default:
              return -1;
            }

        case EQ:
          switch (pattern436 (x2, pnum_clobbers))
            {
            case 0:
              if (pattern1254 (x2, 
E_QImode) != 0
                  || !
#line 10148 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 554; /* *addqi3_eq */

            case 1:
              if (pattern1254 (x2, 
E_HImode) != 0
                  || !
#line 10148 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 555; /* *addhi3_eq */

            default:
              return -1;
            }

        case NE:
          switch (pattern436 (x2, pnum_clobbers))
            {
            case 0:
              if (pattern1255 (x2, 
E_QImode) != 0
                  || !
#line 10169 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (QImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 558; /* *addqi3_ne */

            case 1:
              if (pattern1255 (x2, 
E_HImode) != 0
                  || !
#line 10169 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (HImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 559; /* *addhi3_ne */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case IOR:
      switch (pattern86 (x1, pnum_clobbers))
        {
        case 0:
          if (!(
#line 6554 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 274; /* *addti3_doubleword_concat */

        case 1:
          if (!(
#line 6585 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 280; /* *addti3_doubleword_concat_zext */

        default:
          return -1;
        }

    case XOR:
      switch (pattern86 (x1, pnum_clobbers))
        {
        case 0:
          if (!(
#line 6554 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 275; /* *addti3_doubleword_concat */

        case 1:
          if (!(
#line 6585 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 281; /* *addti3_doubleword_concat_zext */

        default:
          return -1;
        }

    case MULT:
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      x5 = XEXP (x3, 0);
      switch (GET_CODE (x5))
        {
        case REG:
        case SUBREG:
          switch (pattern399 (x2))
            {
            case 0:
              if (!
#line 7932 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              return 364; /* *leaqi_general_2 */

            case 1:
              if (!
#line 7932 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              return 365; /* *leahi_general_2 */

            default:
              return -1;
            }

        case SIGN_EXTEND:
          if (pattern307 (x5, 
2, 
E_V2HImode, 
E_V2SImode) != 0)
            return -1;
          x8 = XEXP (x3, 1);
          if (pattern1256 (x8, 
E_V2HImode, 
E_V2SImode) != 0)
            return -1;
          x10 = XEXP (x8, 0);
          x11 = XEXP (x10, 1);
          if (XVECLEN (x11, 0) != 2)
            return -1;
          x12 = XVECEXP (x11, 0, 0);
          if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x13 = XVECEXP (x11, 0, 1);
          if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
            return -1;
          x7 = XEXP (x2, 1);
          if (GET_CODE (x7) != MULT
              || GET_MODE (x7) != E_V2SImode)
            return -1;
          x14 = XEXP (x7, 0);
          if (pattern1189 (x14, 
E_V2HImode, 
VEC_SELECT, 
E_V2SImode, 
SIGN_EXTEND) != 0)
            return -1;
          x15 = XEXP (x14, 0);
          x16 = XEXP (x15, 1);
          if (GET_CODE (x16) != PARALLEL
              || XVECLEN (x16, 0) != 2)
            return -1;
          x17 = XVECEXP (x16, 0, 0);
          if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x18 = XVECEXP (x16, 0, 1);
          if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
            return -1;
          x19 = XEXP (x7, 1);
          if (pattern1828 (x19, 
E_V2HImode, 
E_V2SImode) != 0)
            return -1;
          x20 = XEXP (x19, 0);
          x21 = XEXP (x20, 1);
          if (XVECLEN (x21, 0) != 2)
            return -1;
          x22 = XVECEXP (x21, 0, 0);
          if (x22 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x23 = XVECEXP (x21, 0, 1);
          if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 3]
              || !register_operand (operands[0], E_V2SImode)
              || GET_MODE (x2) != E_V2SImode
              || GET_MODE (x3) != E_V2SImode)
            return -1;
          x6 = XEXP (x5, 0);
          x24 = XEXP (x6, 0);
          operands[1] = x24;
          if (!register_mmxmem_operand (operands[1], E_V4HImode))
            return -1;
          x25 = XEXP (x10, 0);
          operands[2] = x25;
          if (!register_mmxmem_operand (operands[2], E_V4HImode))
            return -1;
          x26 = XEXP (x15, 0);
          if (!rtx_equal_p (x26, operands[1]))
            return -1;
          x27 = XEXP (x20, 0);
          if (!rtx_equal_p (x27, operands[2])
              || !
#line 3570 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (MULT, V4HImode, operands)))
            return -1;
          return 2165; /* *mmx_pmaddwd */

        default:
          return -1;
        }

    case ASHIFT:
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      x8 = XEXP (x3, 1);
      operands[2] = x8;
      x5 = XEXP (x3, 0);
      switch (GET_CODE (x5))
        {
        case REG:
        case SUBREG:
          operands[1] = x5;
          x7 = XEXP (x2, 1);
          switch (GET_CODE (x7))
            {
            case CONST_INT:
            case CONST_WIDE_INT:
            case CONST_POLY_INT:
            case CONST_FIXED:
            case CONST_DOUBLE:
            case CONST_VECTOR:
            case CONST:
            case REG:
            case SUBREG:
            case LABEL_REF:
            case SYMBOL_REF:
            case HIGH:
              operands[3] = x7;
              switch (GET_MODE (operands[0]))
                {
                case E_QImode:
                  if (pattern1067 (x2, 
E_QImode) != 0
                      || !
#line 7953 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    return -1;
                  return 366; /* *leaqi_general_2b */

                case E_HImode:
                  if (pattern1067 (x2, 
E_HImode) != 0
                      || !
#line 7953 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    return -1;
                  return 367; /* *leahi_general_2b */

                case E_TImode:
                  if (pattern604 (x2, 
E_TImode) != 0
                      || !(
#line 14151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 16 * BITS_PER_UNIT / 2
   && (TImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1196 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 931; /* *concatditi3_5 */

                default:
                  return -1;
                }

            case ZERO_EXTEND:
              if (pattern605 (x2, 
E_DImode, 
E_TImode) != 0
                  || !(
#line 14074 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 895; /* *concatditi3_1 */

            default:
              return -1;
            }

        case SIGN_EXTEND:
          switch (pattern428 (x2))
            {
            case 0:
              if (!(
#line 14110 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 910; /* *concatditi3_3 */

            case 1:
              if (!(
#line 14183 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT
   && (TImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 940; /* *concatditi3_6 */

            default:
              return -1;
            }

        case ZERO_EXTEND:
          switch (pattern428 (x2))
            {
            case 0:
              if (!(
#line 14110 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 913; /* *concatditi3_3 */

            case 1:
              if (!(
#line 14183 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT
   && (TImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 943; /* *concatditi3_6 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case LTU:
    case UNLT:
      switch (pattern87 (x1, pnum_clobbers))
        {
        case 0:
          if (pattern1070 (x2, 
E_QImode) != 0
              || !
#line 8877 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          *pnum_clobbers = 1;
          return 457; /* *addqi3_carry_0 */

        case 1:
          if (pattern1070 (x2, 
E_HImode) != 0
              || !
#line 8877 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          *pnum_clobbers = 1;
          return 458; /* *addhi3_carry_0 */

        default:
          return -1;
        }

    case GE:
    case GEU:
      switch (pattern87 (x1, pnum_clobbers))
        {
        case 0:
          if (pattern1071 (x2, 
E_QImode) != 0
              || !
#line 8891 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          *pnum_clobbers = 1;
          return 461; /* *addqi3_carry_0r */

        case 1:
          if (pattern1071 (x2, 
E_HImode) != 0
              || !
#line 8891 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          *pnum_clobbers = 1;
          return 462; /* *addhi3_carry_0r */

        default:
          return -1;
        }

    case EQ:
      switch (pattern89 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 10195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, QImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 562; /* *addqi3_eq_0 */

        case 1:
          if (!
#line 10195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, HImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 563; /* *addhi3_eq_0 */

        default:
          return -1;
        }

    case NE:
      switch (pattern89 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 10216 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, QImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 566; /* *addqi3_ne_0 */

        case 1:
          if (!
#line 10216 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, HImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 567; /* *addhi3_ne_0 */

        default:
          return -1;
        }

    case MINUS:
      if (pnum_clobbers == NULL)
        return -1;
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      x5 = XEXP (x3, 0);
      operands[1] = x5;
      x7 = XEXP (x2, 1);
      operands[2] = x7;
      x8 = XEXP (x3, 1);
      switch (GET_CODE (x8))
        {
        case NE:
          switch (pattern849 (x2))
            {
            case 0:
              if (!
#line 10264 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (QImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 574; /* *subqi3_ne */

            case 1:
              if (!
#line 10264 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (HImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 575; /* *subhi3_ne */

            default:
              return -1;
            }

        case EQ:
          switch (pattern849 (x2))
            {
            case 0:
              if (!
#line 10293 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (QImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 578; /* *subqi3_eq_1 */

            case 1:
              if (!
#line 10293 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (HImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 579; /* *subhi3_eq_1 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_SELECT:
      switch (pattern90 (x1))
        {
        case 0:
          x5 = XEXP (x3, 0);
          operands[1] = x5;
          x8 = XEXP (x3, 1);
          if (XVECLEN (x8, 0) != 1)
            return -1;
          x7 = XEXP (x2, 1);
          x19 = XEXP (x7, 1);
          if (XVECLEN (x19, 0) != 1)
            return -1;
          x28 = XVECEXP (x8, 0, 0);
          operands[2] = x28;
          if (!const_0_to_1_operand (operands[2], E_SImode))
            return -1;
          x29 = XVECEXP (x19, 0, 0);
          operands[3] = x29;
          if (!const_0_to_1_operand (operands[3], E_SImode))
            return -1;
          x14 = XEXP (x7, 0);
          if (!rtx_equal_p (x14, operands[1]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (!register_operand (operands[0], E_SFmode)
                  || GET_MODE (x2) != E_SFmode
                  || GET_MODE (x3) != E_SFmode
                  || !nonimmediate_operand (operands[1], E_V2SFmode)
                  || GET_MODE (x7) != E_SFmode
                  || !
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE3 && TARGET_MMX_WITH_SSE && ix86_partial_vec_fp_math
   && INTVAL (operands[2]) != INTVAL (operands[3])
   && ix86_pre_reload_split ()))
                return -1;
              return 2065; /* *mmx_haddv2sf3_low */

            case E_DFmode:
              if (pattern1495 (x2, 
E_DFmode, 
E_V2DFmode) != 0
                  || !
#line 3753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3 && TARGET_V2DF_REDUCTION_PREFER_HADDPD
   && INTVAL (operands[2]) != INTVAL (operands[3])))
                return -1;
              return 3153; /* *sse3_haddv2df3_low */

            default:
              return -1;
            }

        case 1:
          switch (pattern851 (x2))
            {
            case 0:
              if (!
#line 22618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
                return -1;
              return 8522; /* ssse3_phaddwv4hi3 */

            case 1:
              if (!
#line 22705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
                return -1;
              return 8530; /* ssse3_phadddv2si3 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_83 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case MEM:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      operands[1] = x4;
      res = recog_82 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      if (pnum_clobbers == NULL
          || GET_CODE (x4) != CONST_INT)
        return -1;
      x5 = XEXP (x3, 1);
      if (GET_CODE (x5) != CLZ)
        return -1;
      x6 = XEXP (x5, 0);
      operands[1] = x6;
      switch (XWINT (x4, 0))
        {
        case 63L:
          if (pattern868 (x3, 
E_DImode) != 0
              || !
#line 21267 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT && TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1525; /* bsr_rex64_1 */

        case 31L:
          if (pattern868 (x3, 
E_SImode) != 0
              || !
#line 21308 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT))
            return -1;
          *pnum_clobbers = 1;
          return 1528; /* bsr_1 */

        default:
          return -1;
        }

    case MINUS:
      if (pnum_clobbers == NULL)
        return -1;
      switch (pattern291 (x3))
        {
        case 0:
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (pattern1259 (x3, 
E_SImode) != 0
                  || !
#line 9289 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)))
                return -1;
              *pnum_clobbers = 1;
              return 489; /* subsi3_carry */

            case E_DImode:
              if (pattern1259 (x3, 
E_DImode) != 0
                  || !(
#line 9289 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 490; /* subdi3_carry */

            default:
              return -1;
            }

        case 1:
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (pattern1195 (x3, 
E_SImode) != 0
                  || !
#line 10242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 572; /* *subsi3_eq */

            case E_DImode:
              if (pattern1195 (x3, 
E_DImode) != 0
                  || !(
#line 10242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 573; /* *subdi3_eq */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_84 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 2);
  operands[3] = x3;
  x4 = XEXP (x2, 0);
  x5 = XEXP (x4, 1);
  switch (XWINT (x5, 0))
    {
    case 0L:
      x6 = XEXP (x2, 1);
      if (GET_CODE (x6) != PLUS)
        return -1;
      x7 = XEXP (x6, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + -1])
        return -1;
      x8 = XEXP (x4, 0);
      operands[2] = x8;
      x9 = XEXP (x6, 0);
      if (!rtx_equal_p (x9, operands[2]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (pattern1498 (x2, 
E_SImode) != 0
              || !
#line 8762 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE))
            return -1;
          *pnum_clobbers = 1;
          return 450; /* *dec_cmovsi */

        case E_DImode:
          if (pattern1498 (x2, 
E_DImode) != 0
              || !(
#line 8762 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 451; /* *dec_cmovdi */

        default:
          return -1;
        }

    case -1L:
      x8 = XEXP (x4, 0);
      operands[4] = x8;
      x6 = XEXP (x2, 1);
      operands[2] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          switch (pattern1353 (x2, 
E_SImode))
            {
            case 0:
              if (!(
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && 
#line 1555 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512DQ)))
                return -1;
              *pnum_clobbers = 1;
              return 2639; /* *kortest_cmpqi_movsicc */

            case 1:
              if (!
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))))
                return -1;
              *pnum_clobbers = 1;
              return 2642; /* *kortest_cmphi_movsicc */

            case 2:
              if (!(
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && 
#line 1556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512BW)))
                return -1;
              *pnum_clobbers = 1;
              return 2645; /* *kortest_cmpsi_movsicc */

            case 3:
              if (!(
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && 
#line 1556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512BW && TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 2648; /* *kortest_cmpdi_movsicc */

            default:
              return -1;
            }

        case E_DImode:
          switch (pattern1353 (x2, 
E_DImode))
            {
            case 0:
              if (!(
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && ((((
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 1555 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512DQ)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))))
                return -1;
              *pnum_clobbers = 1;
              return 2640; /* *kortest_cmpqi_movdicc */

            case 1:
              if (!(
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 2643; /* *kortest_cmphi_movdicc */

            case 2:
              if (!(
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && ((((
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 1556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512BW)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))))
                return -1;
              *pnum_clobbers = 1;
              return 2646; /* *kortest_cmpsi_movdicc */

            case 3:
              if (!(
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && ((((
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 1556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512BW && TARGET_64BIT)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))))
                return -1;
              *pnum_clobbers = 1;
              return 2649; /* *kortest_cmpdi_movdicc */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_88 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != LSHIFTRT)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != MULT)
    return -1;
  x5 = XEXP (x3, 1);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XEXP (x1, 0);
  operands[0] = x6;
  x7 = XEXP (x4, 0);
  switch (GET_CODE (x7))
    {
    case SIGN_EXTEND:
      switch (pattern760 (x2, 
SIGN_EXTEND))
        {
        case 0:
          if (!
#line 11186 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 2;
          return 633; /* *smuldi3_highpart_1 */

        case 1:
          if (!
#line 11235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 2;
          return 637; /* *smulsi3_highpart_1 */

        default:
          return -1;
        }

    case ZERO_EXTEND:
      switch (pattern760 (x2, 
ZERO_EXTEND))
        {
        case 0:
          if (!
#line 11186 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 2;
          return 634; /* *umuldi3_highpart_1 */

        case 1:
          if (!
#line 11235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 2;
          return 638; /* *umulsi3_highpart_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_90 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      res = recog_89 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      if (pnum_clobbers == NULL
          || GET_CODE (x4) != SUBREG
          || maybe_ne (SUBREG_BYTE (x4), 0)
          || GET_MODE (x4) != E_DImode)
        return -1;
      x5 = XEXP (x3, 1);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 63]
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      x6 = XEXP (x4, 0);
      if (GET_MODE (x6) != E_SImode)
        return -1;
      switch (GET_CODE (x6))
        {
        case CTZ:
          x7 = XEXP (x6, 0);
          operands[1] = x7;
          if (!nonimmediate_operand (operands[1], E_SImode)
              || !
#line 21150 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1518; /* *ctzsi2_zext */

        case CLZ:
          x7 = XEXP (x6, 0);
          operands[1] = x7;
          if (!nonimmediate_operand (operands[1], E_SImode)
              || !
#line 21589 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT && TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1540; /* *clzsi2_lzcnt_zext */

        case POPCOUNT:
          x7 = XEXP (x6, 0);
          operands[1] = x7;
          if (!nonimmediate_operand (operands[1], E_SImode)
              || !
#line 22414 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT && TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1632; /* *popcountsi2_zext */

        default:
          return -1;
        }

    case NOT:
      if (pnum_clobbers == NULL)
        return -1;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
          operands[1] = x6;
          x5 = XEXP (x3, 1);
          operands[2] = x5;
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              if (pattern739 (x3, 
E_DImode) != 0)
                return -1;
              if ((
#line 13326 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                {
                  *pnum_clobbers = 1;
                  return 809; /* *andndi3_doubleword_bmi */
                }
              if ((
#line 13344 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_BMI
   && ix86_pre_reload_split ()) && 
#line 1195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                {
                  *pnum_clobbers = 1;
                  return 811; /* *andndi3_doubleword */
                }
              if (!(
#line 13360 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI || TARGET_AVX512BW) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 814; /* *andndi_1 */

            case E_SImode:
              if (pattern739 (x3, 
E_SImode) != 0
                  || !
#line 13360 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI || TARGET_AVX512BW))
                return -1;
              *pnum_clobbers = 1;
              return 813; /* *andnsi_1 */

            default:
              return -1;
            }

        case LSHIFTRT:
          x5 = XEXP (x3, 1);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x7 = XEXP (x6, 0);
          operands[1] = x7;
          x8 = XEXP (x6, 1);
          operands[2] = x8;
          if (!register_operand (operands[2], E_QImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (pattern1081 (x3, 
E_SImode) != 0
                  || !
#line 19394 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 1438; /* *btsi_setncsi */

            case E_DImode:
              if (pattern1081 (x3, 
E_DImode) != 0
                  || !(
#line 19394 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 1439; /* *btdi_setncdi */

            default:
              return -1;
            }

        case ASHIFT:
          x7 = XEXP (x6, 0);
          if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + -1])
            return -1;
          switch (pattern620 (x3))
            {
            case 0:
              if (!
#line 22116 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2))
                return -1;
              *pnum_clobbers = 1;
              return 1596; /* *bmi2_bzhi_si3_3 */

            case 1:
              if (!(
#line 22116 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 1597; /* *bmi2_bzhi_di3_3 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case ROTATE:
      if (pnum_clobbers == NULL)
        return -1;
      x6 = XEXP (x4, 0);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + -2])
        return -1;
      switch (pattern287 (x3))
        {
        case 0:
          x9 = XEXP (x4, 1);
          operands[2] = x9;
          if (register_operand (operands[2], E_QImode))
            {
              switch (pattern752 (x3))
                {
                case 0:
                  if (
#line 18905 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT))
                    {
                      *pnum_clobbers = 1;
                      return 1403; /* *btrsi */
                    }
                  break;

                case 1:
                  if ((
#line 18905 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pnum_clobbers = 1;
                      return 1404; /* *btrdi */
                    }
                  break;

                default:
                  break;
                }
            }
          if (GET_CODE (x9) != SUBREG)
            return -1;
          switch (pattern761 (x3))
            {
            case 0:
              if (!
#line 18924 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 1405; /* *btrsi_mask */

            case 1:
              if (!(
#line 18924 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 1406; /* *btrdi_mask */

            default:
              return -1;
            }

        case 1:
          if (!
#line 18952 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1407; /* *btrsi_mask_1 */

        case 2:
          if (!(
#line 18952 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1408; /* *btrdi_mask_1 */

        default:
          return -1;
        }

    case NEG:
      if (pnum_clobbers == NULL)
        return -1;
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      x5 = XEXP (x3, 1);
      if (!rtx_equal_p (x5, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (pattern755 (x3, 
E_SImode) != 0
              || !
#line 21793 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
            return -1;
          *pnum_clobbers = 1;
          return 1570; /* *bmi_blsi_si */

        case E_DImode:
          if (pattern755 (x3, 
E_DImode) != 0
              || !(
#line 21793 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1571; /* *bmi_blsi_di */

        default:
          return -1;
        }

    case PLUS:
      if (pnum_clobbers == NULL)
        return -1;
      x9 = XEXP (x4, 1);
      if (GET_CODE (x9) != CONST_INT)
        return -1;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
        case MEM:
          operands[1] = x6;
          switch (XWINT (x9, 0))
            {
            case -1L:
              switch (pattern757 (x3))
                {
                case 0:
                  if (!
#line 21938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1582; /* *bmi_blsr_si */

                case 1:
                  if (!(
#line 21938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1583; /* *bmi_blsr_di */

                case 2:
                  if (!
#line 22309 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1622; /* *tbm_tzmsk_si */

                case 3:
                  if (!(
#line 22309 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1623; /* *tbm_tzmsk_di */

                default:
                  return -1;
                }

            case 1L:
              switch (pattern757 (x3))
                {
                case 0:
                  if (!
#line 22200 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1606; /* *tbm_blcfill_si */

                case 1:
                  if (!(
#line 22200 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1607; /* *tbm_blcfill_di */

                case 2:
                  if (!
#line 22228 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1610; /* *tbm_blcic_si */

                case 3:
                  if (!(
#line 22228 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1611; /* *tbm_blcic_di */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case ASHIFT:
          x7 = XEXP (x6, 0);
          if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
              || XWINT (x9, 0) != -1L)
            return -1;
          switch (pattern620 (x3))
            {
            case 0:
              if (!
#line 22102 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2))
                return -1;
              *pnum_clobbers = 1;
              return 1594; /* *bmi2_bzhi_si3_2 */

            case 1:
              if (!(
#line 22102 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 1595; /* *bmi2_bzhi_di3_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case ZERO_EXTEND:
      if (pnum_clobbers == NULL
          || GET_MODE (x4) != E_DImode)
        return -1;
      x6 = XEXP (x4, 0);
      if (GET_CODE (x6) != PLUS
          || pattern442 (x6) != 0)
        return -1;
      x8 = XEXP (x6, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + -1]
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      x7 = XEXP (x6, 0);
      x10 = XEXP (x7, 1);
      operands[2] = x10;
      if (!register_operand (operands[2], E_QImode))
        return -1;
      x5 = XEXP (x3, 1);
      operands[1] = x5;
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !
#line 22148 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2))
        return -1;
      *pnum_clobbers = 1;
      return 1599; /* *bmi2_bzhi_zero_extendsidi_5 */

    case UNSPEC:
      switch (XVECLEN (x4, 0))
        {
        case 3:
          x11 = XVECEXP (x4, 0, 2);
          if (GET_CODE (x11) != CONST_INT)
            return -1;
          x12 = XVECEXP (x4, 0, 0);
          operands[1] = x12;
          x13 = XVECEXP (x4, 0, 1);
          operands[2] = x13;
          switch (XINT (x4, 1))
            {
            case 59:
              operands[3] = x11;
              x5 = XEXP (x3, 1);
              operands[4] = x5;
              switch (GET_MODE (operands[0]))
                {
                case E_SImode:
                  if (pattern1062 (x3, 
E_SImode) == 0)
                    {
                      switch (GET_MODE (operands[1]))
                        {
                        case E_V32HFmode:
                          if (register_operand (operands[1], E_V32HFmode)
                              && nonimmediate_operand (operands[2], E_V32HFmode)
                              && const_0_to_31_operand (operands[3], E_SImode)
                              && (
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
                            return 3269; /* avx512bw_cmpv32hf3_mask */
                          break;

                        case E_V32QImode:
                          if (register_operand (operands[1], E_V32QImode)
                              && nonimmediate_operand (operands[2], E_V32QImode)
                              && const_0_to_7_operand (operands[3], E_SImode)
                              && (
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4490 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                            return 3401; /* avx512vl_cmpv32qi3_mask */
                          break;

                        case E_V32HImode:
                          if (register_operand (operands[1], E_V32HImode)
                              && nonimmediate_operand (operands[2], E_V32HImode)
                              && const_0_to_7_operand (operands[3], E_SImode)
                              && (
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4490 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                            return 3403; /* avx512bw_cmpv32hi3_mask */
                          break;

                        case E_V32BFmode:
                          if (register_operand (operands[1], E_V32BFmode)
                              && nonimmediate_operand (operands[2], E_V32BFmode)
                              && const_0_to_31_operand (operands[3], E_VOIDmode)
                              && (
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                            return 10653; /* avx10_2_cmpbf16_v32bf_mask */
                          break;

                        default:
                          break;
                        }
                    }
                  break;

                case E_DImode:
                  if (pattern978 (x3) == 0
                      && register_operand (operands[4], E_DImode)
                      && (
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4490 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return 3397; /* avx512bw_cmpv64qi3_mask */
                  break;

                default:
                  break;
                }
              if (XWINT (x11, 0) != 0L)
                return -1;
              switch (pattern976 (x3))
                {
                case 0:
                  if (!(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4585 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 3457; /* *avx512bw_eqv64qi3_mask_1 */

                case 1:
                  if (!(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4585 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 3465; /* *avx512vl_eqv32qi3_mask_1 */

                case 2:
                  if (!(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4585 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 3469; /* *avx512bw_eqv32hi3_mask_1 */

                default:
                  return -1;
                }

            case 157:
              if (XWINT (x11, 0) == 0L)
                {
                  switch (pattern976 (x3))
                    {
                    case 0:
                      if ((
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4585 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                        return 3459; /* *avx512bw_eqv64qi3_mask_1 */
                      break;

                    case 1:
                      if ((
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4585 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                        return 3467; /* *avx512vl_eqv32qi3_mask_1 */
                      break;

                    case 2:
                      if ((
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4585 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                        return 3471; /* *avx512bw_eqv32hi3_mask_1 */
                      break;

                    default:
                      break;
                    }
                }
              operands[3] = x11;
              if (!const_0_to_7_operand (operands[3], E_SImode))
                return -1;
              x5 = XEXP (x3, 1);
              operands[4] = x5;
              switch (GET_MODE (operands[0]))
                {
                case E_DImode:
                  if (pattern1082 (x3, 
E_V64QImode, 
E_DImode) != 0
                      || !register_operand (operands[4], E_DImode)
                      || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4600 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 3481; /* avx512bw_ucmpv64qi3_mask */

                case E_SImode:
                  if (pattern1062 (x3, 
E_SImode) != 0)
                    return -1;
                  switch (pattern866 ())
                    {
                    case 0:
                      if (!(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4600 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                        return -1;
                      return 3485; /* avx512vl_ucmpv32qi3_mask */

                    case 1:
                      if (!(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4600 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                        return -1;
                      return 3487; /* avx512bw_ucmpv32hi3_mask */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 2:
          x12 = XVECEXP (x4, 0, 0);
          operands[1] = x12;
          x13 = XVECEXP (x4, 0, 1);
          operands[2] = x13;
          x5 = XEXP (x3, 1);
          operands[3] = x5;
          switch (XINT (x4, 1))
            {
            case 158:
              switch (pattern870 (x3))
                {
                case 0:
                  if (!(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 19038 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
                    return -1;
                  return 8037; /* avx512bw_testmv64qi3_mask */

                case 1:
                  if (!(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 19038 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8039; /* avx512vl_testmv32qi3_mask */

                case 2:
                  if (!(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 19038 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 507 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
                    return -1;
                  return 8043; /* avx512bw_testmv32hi3_mask */

                default:
                  return -1;
                }

            case 159:
              switch (pattern870 (x3))
                {
                case 0:
                  if (!(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 19049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
                    return -1;
                  return 8061; /* avx512bw_testnmv64qi3_mask */

                case 1:
                  if (!(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 19049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8063; /* avx512vl_testnmv32qi3_mask */

                case 2:
                  if (!(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 19049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 507 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
                    return -1;
                  return 8067; /* avx512bw_testnmv32hi3_mask */

                default:
                  return -1;
                }

            case 193:
              if (GET_MODE (x4) != E_SImode
                  || !register_operand (operands[0], E_SImode)
                  || GET_MODE (x3) != E_SImode
                  || !vector_operand (operands[1], E_V32HFmode)
                  || !const_0_to_255_operand (operands[2], E_VOIDmode)
                  || !register_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30096 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V32HFmode)) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
                return -1;
              return 9911; /* avx512dq_fpclassv32hf_mask */

            case 214:
              switch (GET_MODE (operands[0]))
                {
                case E_DImode:
                  if (pattern869 (x3, 
E_DImode, 
E_V64QImode) != 0
                      || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 31179 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BITALG) && 
#line 327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 10253; /* avx512vl_vpshufbitqmbv64qi_mask */

                case E_SImode:
                  if (pattern869 (x3, 
E_SImode, 
E_V32QImode) != 0
                      || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 31179 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BITALG) && 
#line 327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 10257; /* avx512vl_vpshufbitqmbv32qi_mask */

                default:
                  return -1;
                }

            case 262:
              if (GET_MODE (x4) != E_SImode
                  || !register_operand (operands[0], E_SImode)
                  || GET_MODE (x3) != E_SImode
                  || !nonimmediate_operand (operands[1], E_V32BFmode)
                  || !const_0_to_255_operand (operands[2], E_VOIDmode)
                  || !register_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32695 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10647; /* avx10_2_fpclassbf16_v32bf_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_124 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern629 (x2))
    {
    case 0:
      if (pattern632 (x2, 
E_V32HImode, 
E_SImode, 
E_V32HFmode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 4338; /* avx512fp16_vcvtph2uw_v32hi_mask */

    case 1:
      if (pattern136 (x2, 
E_V16SImode, 
E_HImode) != 0)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V16HFmode:
          if (!vector_operand (operands[1], E_V16HFmode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 4346; /* avx512fp16_vcvtph2udq_v16si_mask */

        case E_V16SFmode:
          if (!nonimmediate_operand (operands[1], E_V16SFmode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 4774; /* avx512f_fixuns_notruncv16sfv16si_mask */

        default:
          return -1;
        }

    case 2:
      switch (pattern1089 (x2, 
E_V8DImode))
        {
        case 0:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 4354; /* avx512fp16_vcvtph2uqq_v8di_mask */

        case 1:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 4794; /* avx512dq_cvtps2uqqv8di_mask */

        case 2:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 5020; /* fixuns_notruncv8dfv8di2_mask */

        default:
          return -1;
        }

    case 3:
      if (pattern632 (x2, 
E_V16HImode, 
E_HImode, 
E_V16HFmode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 4362; /* avx512fp16_vcvtph2uw_v16hi_mask */

    case 4:
      switch (pattern1089 (x2, 
E_V8SImode))
        {
        case 0:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 4370; /* avx512fp16_vcvtph2udq_v8si_mask */

        case 1:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 4778; /* avx512vl_fixuns_notruncv8sfv8si_mask */

        case 2:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 4940; /* fixuns_notruncv8dfv8si2_mask */

        default:
          return -1;
        }

    case 5:
      switch (pattern1090 (x2, 
E_V4DImode))
        {
        case 0:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 4378; /* avx512fp16_vcvtph2uqq_v4di_mask */

        case 1:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 4797; /* avx512dq_cvtps2uqqv4di_mask */

        case 2:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 5023; /* fixuns_notruncv4dfv4di2_mask */

        default:
          return -1;
        }

    case 6:
      if (pattern632 (x2, 
E_V8HImode, 
E_QImode, 
E_V8HFmode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 4386; /* avx512fp16_vcvtph2uw_v8hi_mask */

    case 7:
      switch (pattern1090 (x2, 
E_V4SImode))
        {
        case 0:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 4394; /* avx512fp16_vcvtph2udq_v4si_mask */

        case 1:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 4782; /* avx512vl_fixuns_notruncv4sfv4si_mask */

        case 2:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 4944; /* fixuns_notruncv4dfv4si2_mask */

        default:
          return -1;
        }

    case 8:
      switch (pattern1091 (x2))
        {
        case 0:
          if (!vector_operand (operands[1], E_V8HFmode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 4402; /* avx512fp16_vcvtph2uqq_v2di_mask */

        case 1:
          if (!nonimmediate_operand (operands[1], E_V2DFmode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 5025; /* fixuns_notruncv2dfv2di2_mask */

        default:
          return -1;
        }

    case 9:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8743 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL)))
        return -1;
      return 4799; /* avx512dq_cvtps2uqqv2di_mask */

    default:
      return -1;
    }
}

 int
recog_134 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern487 (x2))
    {
    case 0:
      if (!(
#line 30732 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10183; /* vpshldv_v32hi_mask */

    case 1:
      if (!(
#line 30732 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10184; /* vpshldv_v16si_mask */

    case 2:
      if (!(
#line 30732 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10185; /* vpshldv_v8di_mask */

    case 3:
      if (!(
#line 30732 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10186; /* vpshldv_v16hi_mask */

    case 4:
      if (!(
#line 30732 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10187; /* vpshldv_v8si_mask */

    case 5:
      if (!(
#line 30732 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10188; /* vpshldv_v4di_mask */

    case 6:
      if (!(
#line 30732 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10189; /* vpshldv_v8hi_mask */

    case 7:
      if (!(
#line 30732 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10190; /* vpshldv_v4si_mask */

    case 8:
      if (!(
#line 30732 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10191; /* vpshldv_v2di_mask */

    case 9:
      if (!(
#line 30762 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10192; /* vpshldv_v32hi_maskz_1 */

    case 10:
      if (!(
#line 30762 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10193; /* vpshldv_v16si_maskz_1 */

    case 11:
      if (!(
#line 30762 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10194; /* vpshldv_v8di_maskz_1 */

    case 12:
      if (!(
#line 30762 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10195; /* vpshldv_v16hi_maskz_1 */

    case 13:
      if (!(
#line 30762 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10196; /* vpshldv_v8si_maskz_1 */

    case 14:
      if (!(
#line 30762 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10197; /* vpshldv_v4di_maskz_1 */

    case 15:
      if (!(
#line 30762 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10198; /* vpshldv_v8hi_maskz_1 */

    case 16:
      if (!(
#line 30762 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10199; /* vpshldv_v4si_maskz_1 */

    case 17:
      if (!(
#line 30762 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10200; /* vpshldv_v2di_maskz_1 */

    default:
      return -1;
    }
}

 int
recog_140 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern483 (x2))
    {
    case 0:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 10112; /* vpshrd_v32hi_mask */

    case 1:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 10114; /* vpshrd_v16si_mask */

    case 2:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 10116; /* vpshrd_v8di_mask */

    case 3:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10118; /* vpshrd_v16hi_mask */

    case 4:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10120; /* vpshrd_v8si_mask */

    case 5:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10122; /* vpshrd_v4di_mask */

    case 6:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10124; /* vpshrd_v8hi_mask */

    case 7:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10126; /* vpshrd_v4si_mask */

    case 8:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10128; /* vpshrd_v2di_mask */

    default:
      return -1;
    }
}

 int
recog_147 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 2);
  switch (GET_CODE (x3))
    {
    case CONST_INT:
      x4 = XEXP (x2, 0);
      x5 = XEXP (x4, 0);
      operands[2] = x5;
      x6 = XEXP (x2, 1);
      operands[1] = x6;
      switch (XWINT (x3, 0))
        {
        case 3L:
          switch (GET_MODE (operands[0]))
            {
            case E_V8HFmode:
              if (pattern994 (x2, 
E_V8HFmode, 
E_V2HFmode) == 0
                  && 
#line 11847 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                return 5198; /* *vec_concatv8hf_movss */
              break;

            case E_V8BFmode:
              if (pattern994 (x2, 
E_V8BFmode, 
E_V2BFmode) == 0
                  && 
#line 11847 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                return 5199; /* *vec_concatv8bf_movss */
              break;

            case E_V8HImode:
              if (pattern994 (x2, 
E_V8HImode, 
E_V2HImode) == 0
                  && 
#line 11847 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                return 5200; /* *vec_concatv8hi_movss */
              break;

            default:
              break;
            }
          break;

        case 1L:
          switch (GET_MODE (operands[0]))
            {
            case E_V4SImode:
              if (pattern995 (x2, 
E_V4SImode, 
E_SImode) == 0
                  && 
#line 11869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                return 5201; /* vec_setv4si_0 */
              break;

            case E_V4SFmode:
              if (pattern995 (x2, 
E_V4SFmode, 
E_SFmode) == 0
                  && 
#line 11869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                return 5202; /* vec_setv4sf_0 */
              break;

            case E_V8HImode:
              if (pattern994 (x2, 
E_V8HImode, 
E_HImode) == 0
                  && 
#line 11950 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                return 5203; /* vec_setv8hi_0 */
              break;

            case E_V8HFmode:
              if (pattern994 (x2, 
E_V8HFmode, 
E_HFmode) == 0
                  && 
#line 11950 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                return 5204; /* vec_setv8hf_0 */
              break;

            case E_V8BFmode:
              if (pattern994 (x2, 
E_V8BFmode, 
E_BFmode) == 0
                  && 
#line 11950 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                return 5205; /* vec_setv8bf_0 */
              break;

            case E_V16HImode:
              if (pattern996 (x2, 
E_V16HImode, 
E_HImode) == 0
                  && 
#line 12045 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return 5209; /* vec_setv16hi_0 */
              break;

            case E_V32HImode:
              if (pattern996 (x2, 
E_V32HImode, 
E_HImode) == 0
                  && (
#line 12045 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 984 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 5210; /* vec_setv32hi_0 */
              break;

            case E_V16HFmode:
              if (pattern996 (x2, 
E_V16HFmode, 
E_HFmode) == 0
                  && 
#line 12045 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return 5211; /* vec_setv16hf_0 */
              break;

            case E_V32HFmode:
              if (pattern996 (x2, 
E_V32HFmode, 
E_HFmode) == 0
                  && (
#line 12045 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 985 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 5212; /* vec_setv32hf_0 */
              break;

            case E_V16BFmode:
              if (pattern996 (x2, 
E_V16BFmode, 
E_BFmode) == 0
                  && 
#line 12045 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return 5213; /* vec_setv16bf_0 */
              break;

            case E_V32BFmode:
              if (pattern996 (x2, 
E_V32BFmode, 
E_BFmode) == 0
                  && (
#line 12045 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 986 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 5214; /* vec_setv32bf_0 */
              break;

            case E_V8SImode:
              if (pattern996 (x2, 
E_V8SImode, 
E_SImode) == 0
                  && 
#line 12152 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
                return 5226; /* vec_setv8si_0 */
              break;

            case E_V8SFmode:
              if (pattern996 (x2, 
E_V8SFmode, 
E_SFmode) == 0
                  && 
#line 12152 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
                return 5227; /* vec_setv8sf_0 */
              break;

            case E_V16SImode:
              if (pattern996 (x2, 
E_V16SImode, 
E_SImode) == 0
                  && (
#line 12152 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX) && 
#line 993 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return 5228; /* vec_setv16si_0 */
              break;

            case E_V16SFmode:
              if (pattern996 (x2, 
E_V16SFmode, 
E_SFmode) == 0
                  && (
#line 12152 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX) && 
#line 994 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return 5229; /* vec_setv16sf_0 */
              break;

            case E_V2DFmode:
              if (pattern860 (x2, 
E_V2DFmode, 
E_DFmode) == 0
                  && 
#line 12266 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                return 5236; /* vec_setv2df_0 */
              break;

            case E_V8DFmode:
              if (pattern996 (x2, 
E_V8DFmode, 
E_DFmode) == 0
                  && (
#line 14944 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX) && 
#line 467 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return 7148; /* vec_setv8df_0 */
              break;

            case E_V4DFmode:
              if (pattern996 (x2, 
E_V4DFmode, 
E_DFmode) == 0
                  && 
#line 14944 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
                return 7149; /* vec_setv4df_0 */
              break;

            case E_V8DImode:
              if (pattern996 (x2, 
E_V8DImode, 
E_DImode) == 0
                  && (
#line 21747 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX) && 
#line 710 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return 8418; /* vec_setv8di_0 */
              break;

            case E_V4DImode:
              if (pattern996 (x2, 
E_V4DImode, 
E_DImode) == 0
                  && 
#line 21747 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
                return 8419; /* vec_setv4di_0 */
              break;

            default:
              break;
            }
          break;

        default:
          break;
        }
      operands[3] = x3;
      if (const_int_operand (operands[3], E_SImode))
        {
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern883 (x2, 
E_V4SFmode, 
E_SFmode) == 0
                  && 
#line 12119 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V4SFmode))))
                return 5225; /* *vec_setv4sf_sse4_1 */
              break;

            case E_V16QImode:
              if (pattern883 (x2, 
E_V16QImode, 
E_QImode) == 0
                  && (
#line 19867 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V16QImode))) && 
#line 19847 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1)))
                return 8306; /* sse4_1_pinsrb */
              break;

            case E_V8HImode:
              if (pattern883 (x2, 
E_V8HImode, 
E_HImode) == 0
                  && 
#line 19867 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V8HImode))))
                return 8307; /* sse2_pinsrw */
              break;

            case E_V8HFmode:
              if (pattern883 (x2, 
E_V8HFmode, 
E_HFmode) == 0
                  && 
#line 19867 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V8HFmode))))
                return 8308; /* sse2_pinsrph */
              break;

            case E_V8BFmode:
              if (pattern883 (x2, 
E_V8BFmode, 
E_BFmode) == 0
                  && 
#line 19867 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V8BFmode))))
                return 8309; /* sse2_pinsrbf */
              break;

            case E_V4SImode:
              if (pattern883 (x2, 
E_V4SImode, 
E_SImode) == 0
                  && (
#line 19867 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V4SImode))) && 
#line 19848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1)))
                return 8310; /* sse4_1_pinsrd */
              break;

            case E_V2DImode:
              if (pattern883 (x2, 
E_V2DImode, 
E_DImode) == 0
                  && (
#line 19867 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V2DImode))) && 
#line 19849 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_64BIT)))
                return 8311; /* sse4_1_pinsrq */
              break;

            case E_V8DFmode:
              if (pattern884 (x2, 
E_V8DFmode, 
E_V2DFmode) == 0
                  && (
#line 19971 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[3])
       == (GET_MODE_UNIT_SIZE (V8DFmode) == 4 ? 0xF : 0x3))) && 
#line 12379 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_EVEX512)))
                return 8312; /* *avx512dq_vinsertf64x2_0 */
              break;

            case E_V8DImode:
              if (pattern884 (x2, 
E_V8DImode, 
E_V2DImode) == 0
                  && (
#line 19971 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[3])
       == (GET_MODE_UNIT_SIZE (V8DImode) == 4 ? 0xF : 0x3))) && 
#line 12380 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_EVEX512)))
                return 8313; /* *avx512dq_vinserti64x2_0 */
              break;

            case E_V16SFmode:
              if (pattern884 (x2, 
E_V16SFmode, 
E_V4SFmode) == 0
                  && (
#line 19971 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[3])
       == (GET_MODE_UNIT_SIZE (V16SFmode) == 4 ? 0xF : 0x3))) && 
#line 12381 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 8314; /* *avx512f_vinsertf32x4_0 */
              break;

            case E_V16SImode:
              if (pattern884 (x2, 
E_V16SImode, 
E_V4SImode) == 0
                  && (
#line 19971 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[3])
       == (GET_MODE_UNIT_SIZE (V16SImode) == 4 ? 0xF : 0x3))) && 
#line 12381 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 8315; /* *avx512f_vinserti32x4_0 */
              break;

            default:
              break;
            }
        }
      if (XWINT (x3, 0) != 1L
          || !register_operand (operands[0], E_V4SImode)
          || GET_MODE (x2) != E_V4SImode
          || GET_MODE (x4) != E_V4SImode)
        return -1;
      operands[2] = x5;
      if (!nonimmediate_operand (operands[2], E_SImode))
        return -1;
      operands[1] = x6;
      if (!reg_or_0_operand (operands[1], E_V4SImode)
          || !
#line 21026 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
        return -1;
      return 8382; /* sse2_loadld */

    case REG:
    case SUBREG:
      operands[3] = x3;
      x4 = XEXP (x2, 0);
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x6 = XEXP (x2, 1);
      operands[2] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V2DFmode:
          if (pattern149 (x2, 
E_V2DFmode, 
E_DFmode, 
E_QImode) != 0)
            return -1;
          if ((
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 14872 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return 7146; /* vec_dupv2df_mask */
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 9217; /* avx512vl_vec_dup_gprv2df_mask */

        case E_V16SFmode:
          if (pattern136 (x2, 
E_V16SFmode, 
E_HImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4SFmode:
              if (!nonimmediate_operand (operands[1], E_V4SFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 27984 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 9163; /* avx512f_broadcastv16sf_mask */

            case E_SFmode:
              if (!nonimmediate_operand (operands[1], E_SFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 9207; /* avx512f_vec_dup_gprv16sf_mask */

            case E_V8SFmode:
              if (!nonimmediate_operand (operands[1], E_V8SFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28305 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 9263; /* avx512dq_broadcastv16sf_mask_1 */

            default:
              return -1;
            }

        case E_V16SImode:
          if (pattern136 (x2, 
E_V16SImode, 
E_HImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4SImode:
              if (!nonimmediate_operand (operands[1], E_V4SImode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 27984 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 9165; /* avx512f_broadcastv16si_mask */

            case E_SImode:
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 9195; /* avx512f_vec_dup_gprv16si_mask */

            case E_V8SImode:
              if (!nonimmediate_operand (operands[1], E_V8SImode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28305 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 9265; /* avx512dq_broadcastv16si_mask_1 */

            default:
              return -1;
            }

        case E_V8DFmode:
          if (pattern136 (x2, 
E_V8DFmode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4DFmode:
              if (!nonimmediate_operand (operands[1], E_V4DFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 27996 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 9167; /* avx512f_broadcastv8df_mask */

            case E_DFmode:
              if (!nonimmediate_operand (operands[1], E_DFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 9213; /* avx512f_vec_dup_gprv8df_mask */

            case E_V2DFmode:
              if (!nonimmediate_operand (operands[1], E_V2DFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 28316 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 9269; /* avx512dq_broadcastv8df_mask_1 */

            default:
              return -1;
            }

        case E_V8DImode:
          if (pattern136 (x2, 
E_V8DImode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4DImode:
              if (!nonimmediate_operand (operands[1], E_V4DImode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 27996 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 9169; /* avx512f_broadcastv8di_mask */

            case E_DImode:
              if (!nonimmediate_operand (operands[1], E_DImode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 9201; /* avx512f_vec_dup_gprv8di_mask */

            case E_V2DImode:
              if (!nonimmediate_operand (operands[1], E_V2DImode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 28316 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 9267; /* avx512dq_broadcastv8di_mask_1 */

            default:
              return -1;
            }

        case E_V64QImode:
          if (pattern149 (x2, 
E_V64QImode, 
E_QImode, 
E_DImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28008 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 9171; /* avx512bw_vec_dup_gprv64qi_mask */

        case E_V16QImode:
          if (pattern149 (x2, 
E_V16QImode, 
E_QImode, 
E_HImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28008 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 9173; /* avx512vl_vec_dup_gprv16qi_mask */

        case E_V32QImode:
          if (pattern149 (x2, 
E_V32QImode, 
E_QImode, 
E_SImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28008 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 9175; /* avx512vl_vec_dup_gprv32qi_mask */

        case E_V32HImode:
          if (pattern149 (x2, 
E_V32HImode, 
E_HImode, 
E_SImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28008 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 9177; /* avx512bw_vec_dup_gprv32hi_mask */

        case E_V16HImode:
          if (pattern147 (x2, 
E_HImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28008 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 9179; /* avx512vl_vec_dup_gprv16hi_mask */

        case E_V8HImode:
          if (pattern149 (x2, 
E_V8HImode, 
E_HImode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28008 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 9181; /* avx512vl_vec_dup_gprv8hi_mask */

        case E_V32HFmode:
          if (pattern149 (x2, 
E_V32HFmode, 
E_HFmode, 
E_SImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28008 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 9183; /* avx512bw_vec_dup_gprv32hf_mask */

        case E_V16HFmode:
          if (pattern149 (x2, 
E_V16HFmode, 
E_HFmode, 
E_HImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28008 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 9185; /* avx512vl_vec_dup_gprv16hf_mask */

        case E_V8HFmode:
          if (pattern149 (x2, 
E_V8HFmode, 
E_HFmode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28008 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 9187; /* avx512fp16_vec_dup_gprv8hf_mask */

        case E_V32BFmode:
          if (pattern149 (x2, 
E_V32BFmode, 
E_BFmode, 
E_SImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28008 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 9189; /* avx512bw_vec_dup_gprv32bf_mask */

        case E_V16BFmode:
          if (pattern149 (x2, 
E_V16BFmode, 
E_BFmode, 
E_HImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28008 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 9191; /* avx512vl_vec_dup_gprv16bf_mask */

        case E_V8BFmode:
          if (pattern149 (x2, 
E_V8BFmode, 
E_BFmode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28008 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 9193; /* avx512vl_vec_dup_gprv8bf_mask */

        case E_V8SImode:
          if (pattern136 (x2, 
E_V8SImode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_SImode:
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 9197; /* avx512vl_vec_dup_gprv8si_mask */

            case E_V4SImode:
              if (!nonimmediate_operand (operands[1], E_V4SImode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28292 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9259; /* avx512vl_broadcastv8si_mask_1 */

            default:
              return -1;
            }

        case E_V4SImode:
          if (pattern149 (x2, 
E_V4SImode, 
E_SImode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 9199; /* avx512vl_vec_dup_gprv4si_mask */

        case E_V4DImode:
          if (pattern136 (x2, 
E_V4DImode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_DImode:
              if (!nonimmediate_operand (operands[1], E_DImode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 9203; /* avx512vl_vec_dup_gprv4di_mask */

            case E_V2DImode:
              if (!nonimmediate_operand (operands[1], E_V2DImode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 28317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 9271; /* avx512dq_broadcastv4di_mask_1 */

            default:
              return -1;
            }

        case E_V2DImode:
          if (pattern149 (x2, 
E_V2DImode, 
E_DImode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 9205; /* avx512vl_vec_dup_gprv2di_mask */

        case E_V8SFmode:
          if (pattern136 (x2, 
E_V8SFmode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_SFmode:
              if (!nonimmediate_operand (operands[1], E_SFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 9209; /* avx512vl_vec_dup_gprv8sf_mask */

            case E_V4SFmode:
              if (!nonimmediate_operand (operands[1], E_V4SFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28292 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9261; /* avx512vl_broadcastv8sf_mask_1 */

            default:
              return -1;
            }

        case E_V4SFmode:
          if (pattern149 (x2, 
E_V4SFmode, 
E_SFmode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 9211; /* avx512vl_vec_dup_gprv4sf_mask */

        case E_V4DFmode:
          if (pattern136 (x2, 
E_V4DFmode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_DFmode:
              if (!nonimmediate_operand (operands[1], E_DFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 9215; /* avx512vl_vec_dup_gprv4df_mask */

            case E_V2DFmode:
              if (!nonimmediate_operand (operands[1], E_V2DFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 28317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 9273; /* avx512dq_broadcastv4df_mask_1 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_160 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 2);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x4, 0, 3);
  if (GET_CODE (x6) != CONST_INT
      || pattern1286 (x4) != 0)
    return -1;
  x7 = XVECEXP (x4, 0, 12);
  if (GET_CODE (x7) != CONST_INT)
    return -1;
  x8 = XVECEXP (x4, 0, 13);
  if (GET_CODE (x8) != CONST_INT)
    return -1;
  x9 = XVECEXP (x4, 0, 14);
  if (GET_CODE (x9) != CONST_INT)
    return -1;
  x10 = XVECEXP (x4, 0, 15);
  if (GET_CODE (x10) != CONST_INT)
    return -1;
  x11 = XEXP (x2, 2);
  if (!register_operand (x11, E_HImode))
    return -1;
  x12 = XVECEXP (x4, 0, 0);
  switch (XWINT (x12, 0))
    {
    case 2L:
      x13 = XVECEXP (x4, 0, 1);
      if (XWINT (x13, 0) != 18L
          || XWINT (x5, 0) != 3L
          || XWINT (x6, 0) != 19L
          || pattern1821 (x4) != 0)
        return -1;
      x14 = XVECEXP (x4, 0, 8);
      if (XWINT (x14, 0) != 10L)
        return -1;
      x15 = XVECEXP (x4, 0, 9);
      if (XWINT (x15, 0) != 26L)
        return -1;
      x16 = XVECEXP (x4, 0, 10);
      if (XWINT (x16, 0) != 11L)
        return -1;
      x17 = XVECEXP (x4, 0, 11);
      if (XWINT (x17, 0) != 27L
          || pattern1853 (x2) != 0)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SFmode:
          if (pattern1564 (x2, 
E_V16SFmode, 
E_V32SFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 11138 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5151; /* avx512f_unpckhps512_mask */

        case E_V16SImode:
          if (pattern1564 (x2, 
E_V16SImode, 
E_V32SImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 8297; /* avx512f_interleave_highv16si_mask */

        default:
          return -1;
        }

    case 0L:
      x13 = XVECEXP (x4, 0, 1);
      switch (XWINT (x13, 0))
        {
        case 16L:
          if (XWINT (x5, 0) != 1L
              || XWINT (x6, 0) != 17L)
            return -1;
          x18 = XEXP (x3, 0);
          x19 = XEXP (x18, 1);
          operands[2] = x19;
          x20 = XEXP (x2, 1);
          operands[3] = x20;
          operands[4] = x11;
          x21 = XVECEXP (x4, 0, 4);
          switch (XWINT (x21, 0))
            {
            case 4L:
              x22 = XVECEXP (x4, 0, 5);
              if (XWINT (x22, 0) != 20L)
                return -1;
              x23 = XVECEXP (x4, 0, 6);
              if (XWINT (x23, 0) != 5L)
                return -1;
              x24 = XVECEXP (x4, 0, 7);
              if (XWINT (x24, 0) != 21L)
                return -1;
              x14 = XVECEXP (x4, 0, 8);
              if (XWINT (x14, 0) != 8L)
                return -1;
              x15 = XVECEXP (x4, 0, 9);
              if (XWINT (x15, 0) != 24L)
                return -1;
              x16 = XVECEXP (x4, 0, 10);
              if (XWINT (x16, 0) != 9L)
                return -1;
              x17 = XVECEXP (x4, 0, 11);
              if (XWINT (x17, 0) != 25L
                  || XWINT (x7, 0) != 12L
                  || XWINT (x8, 0) != 28L
                  || XWINT (x9, 0) != 13L
                  || XWINT (x10, 0) != 29L)
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V16SFmode:
                  if (pattern1564 (x2, 
E_V16SFmode, 
E_V32SFmode) != 0
                      || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 11226 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                    return -1;
                  return 5157; /* avx512f_unpcklps512_mask */

                case E_V16SImode:
                  if (pattern1564 (x2, 
E_V16SImode, 
E_V32SImode) != 0
                      || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19785 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                    return -1;
                  return 8303; /* avx512f_interleave_lowv16si_mask */

                default:
                  return -1;
                }

            case 2L:
              x22 = XVECEXP (x4, 0, 5);
              if (XWINT (x22, 0) != 18L)
                return -1;
              x23 = XVECEXP (x4, 0, 6);
              if (XWINT (x23, 0) != 3L)
                return -1;
              x24 = XVECEXP (x4, 0, 7);
              if (XWINT (x24, 0) != 19L)
                return -1;
              x14 = XVECEXP (x4, 0, 8);
              switch (XWINT (x14, 0))
                {
                case 4L:
                  x15 = XVECEXP (x4, 0, 9);
                  if (XWINT (x15, 0) != 20L)
                    return -1;
                  x16 = XVECEXP (x4, 0, 10);
                  if (XWINT (x16, 0) != 5L)
                    return -1;
                  x17 = XVECEXP (x4, 0, 11);
                  if (XWINT (x17, 0) != 21L
                      || XWINT (x7, 0) != 6L
                      || XWINT (x8, 0) != 22L
                      || XWINT (x9, 0) != 7L
                      || XWINT (x10, 0) != 23L
                      || pattern1565 (x2, 
E_V16QImode, 
E_V32QImode) != 0
                      || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL && TARGET_AVX512BW)))
                    return -1;
                  return 8257; /* vec_interleave_lowv16qi_mask */

                case 8L:
                  x15 = XVECEXP (x4, 0, 9);
                  if (XWINT (x15, 0) != 24L)
                    return -1;
                  x16 = XVECEXP (x4, 0, 10);
                  if (XWINT (x16, 0) != 9L)
                    return -1;
                  x17 = XVECEXP (x4, 0, 11);
                  if (XWINT (x17, 0) != 25L
                      || XWINT (x7, 0) != 10L
                      || XWINT (x8, 0) != 26L
                      || XWINT (x9, 0) != 11L
                      || XWINT (x10, 0) != 27L)
                    return -1;
                  switch (GET_MODE (operands[0]))
                    {
                    case E_V16HImode:
                      if (pattern1564 (x2, 
E_V16HImode, 
E_V32HImode) != 0
                          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL && TARGET_AVX512BW)))
                        return -1;
                      return 8283; /* avx2_interleave_lowv16hi_mask */

                    case E_V16HFmode:
                      if (pattern1564 (x2, 
E_V16HFmode, 
E_V32HFmode) != 0
                          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL && TARGET_AVX512BW)))
                        return -1;
                      return 8285; /* avx2_interleave_lowv16hf_mask */

                    case E_V16BFmode:
                      if (pattern1564 (x2, 
E_V16BFmode, 
E_V32BFmode) != 0
                          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL && TARGET_AVX512BW)))
                        return -1;
                      return 8287; /* avx2_interleave_lowv16bf_mask */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 0L:
          if (pattern1650 (x4) != 0)
            return -1;
          x14 = XVECEXP (x4, 0, 8);
          if (XWINT (x14, 0) != 8L)
            return -1;
          x15 = XVECEXP (x4, 0, 9);
          if (XWINT (x15, 0) != 8L)
            return -1;
          x16 = XVECEXP (x4, 0, 10);
          if (XWINT (x16, 0) != 10L)
            return -1;
          x17 = XVECEXP (x4, 0, 11);
          if (XWINT (x17, 0) != 10L
              || XWINT (x7, 0) != 12L
              || XWINT (x8, 0) != 12L
              || XWINT (x9, 0) != 14L
              || XWINT (x10, 0) != 14L
              || pattern1791 (x2, 
E_V16SFmode, 
E_V32SFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 11419 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5173; /* avx512f_movsldup512_mask */

        default:
          return -1;
        }

    case 1L:
      x13 = XVECEXP (x4, 0, 1);
      if (XWINT (x13, 0) != 1L
          || XWINT (x5, 0) != 3L
          || XWINT (x6, 0) != 3L)
        return -1;
      x21 = XVECEXP (x4, 0, 4);
      if (XWINT (x21, 0) != 5L)
        return -1;
      x22 = XVECEXP (x4, 0, 5);
      if (XWINT (x22, 0) != 5L)
        return -1;
      x23 = XVECEXP (x4, 0, 6);
      if (XWINT (x23, 0) != 7L)
        return -1;
      x24 = XVECEXP (x4, 0, 7);
      if (XWINT (x24, 0) != 7L)
        return -1;
      x14 = XVECEXP (x4, 0, 8);
      if (XWINT (x14, 0) != 9L)
        return -1;
      x15 = XVECEXP (x4, 0, 9);
      if (XWINT (x15, 0) != 9L)
        return -1;
      x16 = XVECEXP (x4, 0, 10);
      if (XWINT (x16, 0) != 11L)
        return -1;
      x17 = XVECEXP (x4, 0, 11);
      if (XWINT (x17, 0) != 11L
          || XWINT (x7, 0) != 13L
          || XWINT (x8, 0) != 13L
          || XWINT (x9, 0) != 15L
          || XWINT (x10, 0) != 15L
          || pattern1791 (x2, 
E_V16SFmode, 
E_V32SFmode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 11366 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 5167; /* avx512f_movshdup512_mask */

    case 8L:
      x13 = XVECEXP (x4, 0, 1);
      if (XWINT (x13, 0) != 24L
          || XWINT (x5, 0) != 9L
          || XWINT (x6, 0) != 25L)
        return -1;
      x21 = XVECEXP (x4, 0, 4);
      if (XWINT (x21, 0) != 10L)
        return -1;
      x22 = XVECEXP (x4, 0, 5);
      if (XWINT (x22, 0) != 26L)
        return -1;
      x23 = XVECEXP (x4, 0, 6);
      if (XWINT (x23, 0) != 11L)
        return -1;
      x24 = XVECEXP (x4, 0, 7);
      if (XWINT (x24, 0) != 27L
          || pattern1836 (x4) != 0
          || XWINT (x7, 0) != 14L
          || XWINT (x8, 0) != 30L
          || XWINT (x9, 0) != 15L
          || XWINT (x10, 0) != 31L
          || pattern772 (x2, 
E_V32QImode, 
E_V16QImode) != 0
          || !register_operand (operands[1], E_V16QImode))
        return -1;
      x18 = XEXP (x3, 0);
      x19 = XEXP (x18, 1);
      operands[2] = x19;
      if (!vector_operand (operands[2], E_V16QImode))
        return -1;
      x20 = XEXP (x2, 1);
      operands[3] = x20;
      if (!nonimm_or_0_operand (operands[3], E_V16QImode))
        return -1;
      operands[4] = x11;
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19458 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL && TARGET_AVX512BW)))
        return -1;
      return 8251; /* vec_interleave_highv16qi_mask */

    case 4L:
      x13 = XVECEXP (x4, 0, 1);
      if (XWINT (x13, 0) != 20L
          || XWINT (x5, 0) != 5L
          || XWINT (x6, 0) != 21L
          || pattern1821 (x4) != 0
          || pattern1836 (x4) != 0
          || pattern1853 (x2) != 0)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V16HImode:
          if (pattern1564 (x2, 
E_V16HImode, 
E_V32HImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19606 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8265; /* avx2_interleave_highv16hi_mask */

        case E_V16HFmode:
          if (pattern1564 (x2, 
E_V16HFmode, 
E_V32HFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19606 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8267; /* avx2_interleave_highv16hf_mask */

        case E_V16BFmode:
          if (pattern1564 (x2, 
E_V16BFmode, 
E_V32BFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19606 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8269; /* avx2_interleave_highv16bf_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_178 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case PLUS:
      switch (pattern309 (x2))
        {
        case 0:
          if (!(
#line 2687 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 2755; /* *avx512fp16_vmaddv8hf3 */

        case 1:
          if (!
#line 2687 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 2757; /* *sse_vmaddv4sf3 */

        case 2:
          if (!(
#line 2687 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 2759; /* *sse2_vmaddv2df3 */

        default:
          return -1;
        }

    case MINUS:
      switch (pattern309 (x2))
        {
        case 0:
          if (!(
#line 2687 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 2756; /* *avx512fp16_vmsubv8hf3 */

        case 1:
          if (!
#line 2687 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 2758; /* *sse_vmsubv4sf3 */

        case 2:
          if (!(
#line 2687 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 2760; /* *sse2_vmsubv2df3 */

        default:
          return -1;
        }

    case MULT:
      switch (pattern309 (x2))
        {
        case 0:
          if (!(
#line 2777 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 2821; /* *avx512fp16_vmmulv8hf3 */

        case 1:
          if (!
#line 2777 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 2823; /* *sse_vmmulv4sf3 */

        case 2:
          if (!(
#line 2777 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 2825; /* *sse2_vmmulv2df3 */

        default:
          return -1;
        }

    case DIV:
      switch (pattern309 (x2))
        {
        case 0:
          if (!(
#line 2777 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 2822; /* *avx512fp16_vmdivv8hf3 */

        case 1:
          if (!
#line 2777 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 2824; /* *sse_vmdivv4sf3 */

        case 2:
          if (!(
#line 2777 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 2826; /* *sse2_vmdivv2df3 */

        default:
          return -1;
        }

    case UNSPEC:
      x5 = XEXP (x2, 2);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      switch (XVECLEN (x4, 0))
        {
        case 1:
          x6 = XVECEXP (x4, 0, 0);
          operands[1] = x6;
          x7 = XEXP (x2, 1);
          operands[2] = x7;
          switch (XINT (x4, 1))
            {
            case 54:
              switch (GET_MODE (operands[0]))
                {
                case E_V4SFmode:
                  if (pattern1104 (x2, 
E_V4SFmode, 
E_SFmode) != 0
                      || !
#line 2952 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                    return -1;
                  return 2878; /* *sse_vmrcpv4sf2 */

                case E_V8HFmode:
                  if (pattern1104 (x2, 
E_V8HFmode, 
E_HFmode) != 0
                      || !
#line 2996 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                    return -1;
                  return 2887; /* *avx512fp16_vmrcpv8hf2 */

                default:
                  return -1;
                }

            case 55:
              switch (GET_MODE (operands[0]))
                {
                case E_V4SFmode:
                  if (pattern1104 (x2, 
E_V4SFmode, 
E_SFmode) != 0
                      || !
#line 3223 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                    return -1;
                  return 2977; /* *sse_vmrsqrtv4sf2 */

                case E_V8HFmode:
                  if (pattern1104 (x2, 
E_V8HFmode, 
E_HFmode) != 0
                      || !
#line 3254 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                    return -1;
                  return 2980; /* *avx512fp16_vmrsqrtv8hf2 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 2:
          switch (XINT (x4, 1))
            {
            case 63:
              switch (pattern771 (x2))
                {
                case 0:
                  if (!(
#line 3423 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                    return -1;
                  return 3091; /* *ieee_maxv8hf3 */

                case 1:
                  if (!
#line 3423 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                    return -1;
                  return 3093; /* *ieee_maxv4sf3 */

                case 2:
                  if (!(
#line 3423 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                    return -1;
                  return 3095; /* *ieee_maxv2df3 */

                default:
                  return -1;
                }

            case 62:
              switch (pattern771 (x2))
                {
                case 0:
                  if (!(
#line 3423 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                    return -1;
                  return 3092; /* *ieee_minv8hf3 */

                case 1:
                  if (!
#line 3423 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                    return -1;
                  return 3094; /* *ieee_minv4sf3 */

                case 2:
                  if (!(
#line 3423 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                    return -1;
                  return 3096; /* *ieee_minv2df3 */

                default:
                  return -1;
                }

            case 94:
              x6 = XVECEXP (x4, 0, 0);
              operands[2] = x6;
              x8 = XVECEXP (x4, 0, 1);
              operands[3] = x8;
              x7 = XEXP (x2, 1);
              operands[1] = x7;
              switch (GET_MODE (operands[0]))
                {
                case E_V8HFmode:
                  if (pattern1202 (x2, 
E_V8HFmode, 
E_HFmode) != 0)
                    return -1;
                  if (vector_operand (operands[2], E_HFmode)
                      && const_0_to_255_operand (operands[3], E_SImode)
                      && (
#line 14241 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                    return 7110; /* *avx512f_rndscalev8hf */
                  if (!nonimmediate_operand (operands[2], E_HFmode)
                      || !const_0_to_15_operand (operands[3], E_SImode)
                      || !(
#line 25851 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                    return -1;
                  return 8903; /* *sse4_1_roundsh */

                case E_V4SFmode:
                  if (pattern1202 (x2, 
E_V4SFmode, 
E_SFmode) != 0)
                    return -1;
                  if (vector_operand (operands[2], E_SFmode)
                      && const_0_to_255_operand (operands[3], E_SImode)
                      && 
#line 14241 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                    return 7112; /* *avx512f_rndscalev4sf */
                  if (!nonimmediate_operand (operands[2], E_SFmode)
                      || !const_0_to_15_operand (operands[3], E_SImode)
                      || !
#line 25851 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                    return -1;
                  return 8904; /* *sse4_1_roundss */

                case E_V2DFmode:
                  if (pattern1202 (x2, 
E_V2DFmode, 
E_DFmode) != 0)
                    return -1;
                  if (vector_operand (operands[2], E_DFmode)
                      && const_0_to_255_operand (operands[3], E_SImode)
                      && (
#line 14241 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                    return 7114; /* *avx512f_rndscalev2df */
                  if (!nonimmediate_operand (operands[2], E_DFmode)
                      || !const_0_to_15_operand (operands[3], E_SImode)
                      || !(
#line 25851 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                    return -1;
                  return 8905; /* *sse4_1_roundsd */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case SQRT:
      x5 = XEXP (x2, 2);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x9 = XEXP (x4, 0);
      operands[1] = x9;
      x7 = XEXP (x2, 1);
      operands[2] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          if (pattern881 (x2, 
E_V8HFmode, 
E_HFmode) != 0
              || !(
#line 3105 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 2940; /* *avx512fp16_vmsqrtv8hf2 */

        case E_V4SFmode:
          if (pattern881 (x2, 
E_V4SFmode, 
E_SFmode) != 0
              || !
#line 3105 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 2944; /* *sse_vmsqrtv4sf2 */

        case E_V2DFmode:
          if (pattern881 (x2, 
E_V2DFmode, 
E_DFmode) != 0
              || !(
#line 3105 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 2948; /* *sse2_vmsqrtv2df2 */

        default:
          return -1;
        }

    case FLOAT:
      x5 = XEXP (x2, 2);
      if (GET_CODE (x5) != CONST_INT)
        return -1;
      x9 = XEXP (x4, 0);
      operands[2] = x9;
      x7 = XEXP (x2, 1);
      operands[1] = x7;
      switch (XWINT (x5, 0))
        {
        case 1L:
          switch (GET_MODE (operands[0]))
            {
            case E_V8HFmode:
              switch (pattern882 (x2, 
E_V8HFmode, 
E_HFmode))
                {
                case 0:
                  if (!
#line 7842 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                    return -1;
                  return 4486; /* avx512fp16_vcvtsi2sh */

                case 1:
                  if (!(
#line 7842 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4490; /* avx512fp16_vcvtsi2shq */

                default:
                  return -1;
                }

            case E_V4SFmode:
              switch (pattern882 (x2, 
E_V4SFmode, 
E_SFmode))
                {
                case 0:
                  if (!
#line 8508 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                    return -1;
                  return 4719; /* sse_cvtsi2ss */

                case 1:
                  if (!(
#line 8508 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4721; /* sse_cvtsi2ssq */

                default:
                  return -1;
                }

            case E_V2DFmode:
              switch (pattern882 (x2, 
E_V2DFmode, 
E_DFmode))
                {
                case 0:
                  if (!
#line 8969 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                    return -1;
                  return 4831; /* sse2_cvtsi2sd */

                case 1:
                  if (!
#line 8991 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_64BIT))
                    return -1;
                  return 4832; /* sse2_cvtsi2sdq */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 3L:
          if (pnum_clobbers == NULL
              || pattern772 (x2, 
E_V2SFmode, 
E_V4SFmode) != 0
              || !register_mmxmem_operand (operands[2], E_V2SImode)
              || !register_operand (operands[1], E_V4SFmode)
              || !
#line 8353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSE))
            return -1;
          *pnum_clobbers = 1;
          return 4715; /* sse_cvtpi2ps */

        default:
          return -1;
        }

    case UNSIGNED_FLOAT:
      x5 = XEXP (x2, 2);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x9 = XEXP (x4, 0);
      operands[2] = x9;
      x7 = XEXP (x2, 1);
      operands[1] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          switch (pattern882 (x2, 
E_V8HFmode, 
E_HFmode))
            {
            case 0:
              if (!
#line 7842 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 4488; /* avx512fp16_vcvtusi2sh */

            case 1:
              if (!(
#line 7842 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 4492; /* avx512fp16_vcvtusi2shq */

            default:
              return -1;
            }

        case E_V4SFmode:
          switch (pattern882 (x2, 
E_V4SFmode, 
E_SFmode))
            {
            case 0:
              if (!
#line 8604 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1))
                return -1;
              return 4737; /* cvtusi2ss32 */

            case 1:
              if (!
#line 8618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_64BIT))
                return -1;
              return 4740; /* cvtusi2ss64 */

            default:
              return -1;
            }

        case E_V2DFmode:
          switch (pattern882 (x2, 
E_V2DFmode, 
E_DFmode))
            {
            case 0:
              if (!(
#line 8604 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 4739; /* cvtusi2sd32 */

            case 1:
              if (!(
#line 8618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_64BIT) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 4742; /* cvtusi2sd64 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case FLOAT_EXTEND:
      x5 = XEXP (x2, 2);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x9 = XEXP (x4, 0);
      switch (GET_CODE (x9))
        {
        case VEC_SELECT:
          if (GET_MODE (x9) != E_HFmode)
            return -1;
          x10 = XEXP (x9, 1);
          if (GET_CODE (x10) != PARALLEL
              || XVECLEN (x10, 0) != 1)
            return -1;
          x11 = XVECEXP (x10, 0, 0);
          if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x12 = XEXP (x9, 0);
          operands[1] = x12;
          if (!register_operand (operands[1], E_V8HFmode))
            return -1;
          x7 = XEXP (x2, 1);
          operands[2] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_V2DFmode:
              if (pattern1448 (x2, 
E_V2DFmode, 
E_DFmode) != 0
                  || !
#line 8289 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 4691; /* avx512fp16_vcvtsh2sd */

            case E_V4SFmode:
              if (pattern1448 (x2, 
E_V4SFmode, 
E_SFmode) != 0
                  || !
#line 8289 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 4695; /* avx512fp16_vcvtsh2ss */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          switch (GET_MODE (operands[0]))
            {
            case E_V2DFmode:
              if (pattern772 (x2, 
E_DFmode, 
E_V2DFmode) != 0)
                return -1;
              x7 = XEXP (x2, 1);
              if (!register_operand (x7, E_V2DFmode))
                return -1;
              switch (GET_MODE (x9))
                {
                case E_HFmode:
                  operands[1] = x9;
                  if (!memory_operand (operands[1], E_HFmode))
                    return -1;
                  operands[2] = x7;
                  if (!
#line 8303 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                    return -1;
                  return 4699; /* avx512fp16_vcvtsh2sd_mem */

                case E_SFmode:
                  operands[2] = x9;
                  if (!nonimmediate_operand (operands[2], E_SFmode))
                    return -1;
                  operands[1] = x7;
                  if (!
#line 10055 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                    return -1;
                  return 5080; /* *sse2_vd_cvtss2sd */

                default:
                  return -1;
                }

            case E_V4SFmode:
              if (pattern772 (x2, 
E_SFmode, 
E_V4SFmode) != 0)
                return -1;
              operands[1] = x9;
              if (!memory_operand (operands[1], E_HFmode))
                return -1;
              x7 = XEXP (x2, 1);
              operands[2] = x7;
              if (!register_operand (operands[2], E_V4SFmode)
                  || !
#line 8303 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 4701; /* avx512fp16_vcvtsh2ss_mem */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case FLOAT_TRUNCATE:
      x5 = XEXP (x2, 2);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x9 = XEXP (x4, 0);
      switch (GET_CODE (x9))
        {
        case VEC_SELECT:
          x10 = XEXP (x9, 1);
          if (GET_CODE (x10) != PARALLEL
              || XVECLEN (x10, 0) != 1)
            return -1;
          x11 = XVECEXP (x10, 0, 0);
          if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || pattern772 (x2, 
E_HFmode, 
E_V8HFmode) != 0)
            return -1;
          x12 = XEXP (x9, 0);
          operands[1] = x12;
          x7 = XEXP (x2, 1);
          operands[2] = x7;
          if (!register_operand (operands[2], E_V8HFmode))
            return -1;
          switch (GET_MODE (x9))
            {
            case E_DFmode:
              if (!register_operand (operands[1], E_V2DFmode)
                  || !
#line 8319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 4703; /* avx512fp16_vcvtsd2sh */

            case E_SFmode:
              if (!register_operand (operands[1], E_V4SFmode)
                  || !
#line 8319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 4707; /* avx512fp16_vcvtss2sh */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          switch (GET_MODE (operands[0]))
            {
            case E_V8HFmode:
              if (!register_operand (operands[0], E_V8HFmode)
                  || GET_MODE (x2) != E_V8HFmode
                  || GET_MODE (x3) != E_V8HFmode
                  || GET_MODE (x4) != E_HFmode)
                return -1;
              operands[1] = x9;
              x7 = XEXP (x2, 1);
              operands[2] = x7;
              if (!register_operand (operands[2], E_V8HFmode))
                return -1;
              switch (GET_MODE (operands[1]))
                {
                case E_SFmode:
                  if (!memory_operand (operands[1], E_SFmode)
                      || !
#line 8333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                    return -1;
                  return 4711; /* avx512fp16_vcvtss2sh_mem */

                case E_DFmode:
                  if (!memory_operand (operands[1], E_DFmode)
                      || !
#line 8333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                    return -1;
                  return 4713; /* avx512fp16_vcvtsd2sh_mem */

                default:
                  return -1;
                }

            case E_V4SFmode:
              if (!register_operand (operands[0], E_V4SFmode)
                  || GET_MODE (x2) != E_V4SFmode
                  || GET_MODE (x3) != E_V4SFmode)
                return -1;
              operands[2] = x9;
              x7 = XEXP (x2, 1);
              operands[1] = x7;
              if (!register_operand (operands[1], E_V4SFmode))
                return -1;
              switch (GET_MODE (x4))
                {
                case E_V2SFmode:
                  if (!nonimmediate_operand (operands[2], E_V2DFmode)
                      || !
#line 9990 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                    return -1;
                  return 5071; /* sse2_cvtsd2ss */

                case E_SFmode:
                  if (!nonimmediate_operand (operands[2], E_DFmode)
                      || !
#line 10011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                    return -1;
                  return 5075; /* *sse2_vd_cvtsd2ss */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case MEM:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      return recog_147 (x1, insn, pnum_clobbers);

    case VEC_SELECT:
      return recog_148 (x1, insn, pnum_clobbers);

    case ZERO_EXTEND:
      switch (pattern312 (x2))
        {
        case 0:
          if (!(
#line 12063 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 803 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5215; /* *vec_setv16si_0_zero_extendhi */

        case 1:
          if (!
#line 12063 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()))
            return -1;
          return 5216; /* *vec_setv8si_0_zero_extendhi */

        case 2:
          if (!
#line 12063 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()))
            return -1;
          return 5217; /* *vec_setv4si_0_zero_extendhi */

        case 3:
          if (!(
#line 12063 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5218; /* *vec_setv8di_0_zero_extendhi */

        case 4:
          if (!(
#line 12177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 614 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5230; /* *vec_setv8di_0_zero_extendsi */

        case 5:
          if (!
#line 12063 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()))
            return -1;
          return 5219; /* *vec_setv4di_0_zero_extendhi */

        case 6:
          if (!(
#line 12177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 614 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5231; /* *vec_setv4di_0_zero_extendsi */

        case 7:
          if (!
#line 12063 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()))
            return -1;
          return 5220; /* *vec_setv2di_0_zero_extendhi */

        case 8:
          if (!
#line 12177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
            return -1;
          return 5232; /* *vec_setv2di_0_zero_extendsi */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_197 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x2, 1);
  operands[2] = x5;
  x6 = XEXP (x2, 2);
  switch (GET_CODE (x6))
    {
    case REG:
    case SUBREG:
      operands[3] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          if (pattern885 (x2, 
E_V32HFmode, 
E_SImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
            return -1;
          return 2906; /* avx512fp16_sqrtv32hf2_mask */

        case E_V16HFmode:
          if (pattern885 (x2, 
E_V16HFmode, 
E_HImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 390 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
            return -1;
          return 2909; /* avx512fp16_sqrtv16hf2_mask */

        case E_V8HFmode:
          if (pattern885 (x2, 
E_V8HFmode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 391 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
            return -1;
          return 2911; /* avx512fp16_sqrtv8hf2_mask */

        case E_V16SFmode:
          if (pattern885 (x2, 
E_V16SFmode, 
E_HImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 2914; /* avx512f_sqrtv16sf2_mask */

        case E_V8SFmode:
          if (pattern885 (x2, 
E_V8SFmode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 2917; /* avx_sqrtv8sf2_mask */

        case E_V4SFmode:
          if (pattern885 (x2, 
E_V4SFmode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (16 == 64 || TARGET_AVX512VL) && 1)))
            return -1;
          return 2919; /* sse_sqrtv4sf2_mask */

        case E_V8DFmode:
          if (pattern885 (x2, 
E_V8DFmode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 2922; /* avx512f_sqrtv8df2_mask */

        case E_V4DFmode:
          if (pattern885 (x2, 
E_V4DFmode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 2925; /* avx_sqrtv4df2_mask */

        case E_V2DFmode:
          if (pattern885 (x2, 
E_V2DFmode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 394 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 2927; /* sse2_sqrtv2df2_mask */

        case E_V32BFmode:
          if (pattern146 (x2, 
E_V32BFmode, 
E_SImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32647 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10611; /* avx10_2_sqrtbf16_v32bf_mask */

        case E_V16BFmode:
          if (pattern146 (x2, 
E_V16BFmode, 
E_HImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32647 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10613; /* avx10_2_sqrtbf16_v16bf_mask */

        case E_V8BFmode:
          if (pattern146 (x2, 
E_V8BFmode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32647 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10615; /* avx10_2_sqrtbf16_v8bf_mask */

        default:
          return -1;
        }

    case CONST_INT:
      if (XWINT (x6, 0) != 1L)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          if (pattern886 (x2, 
E_V8HFmode) != 0
              || !(
#line 3086 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 2928; /* avx512fp16_vmsqrtv8hf2 */

        case E_V4SFmode:
          if (pattern886 (x2, 
E_V4SFmode) != 0
              || !
#line 3086 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 2932; /* sse_vmsqrtv4sf2 */

        case E_V2DFmode:
          if (pattern886 (x2, 
E_V2DFmode) != 0
              || !(
#line 3086 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 2936; /* sse2_vmsqrtv2df2 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_203 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (pattern492 (x2))
    {
    case 0:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V32HFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
        return -1;
      return 2685; /* *addv32hf3_mask */

    case 1:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V16HFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 390 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
        return -1;
      return 2693; /* *addv16hf3_mask */

    case 2:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V8HFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 391 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
        return -1;
      return 2701; /* *addv8hf3_mask */

    case 3:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V16SFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 2709; /* *addv16sf3_mask */

    case 4:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V8SFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
        return -1;
      return 2717; /* *addv8sf3_mask */

    case 5:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V4SFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && 1)))
        return -1;
      return 2725; /* *addv4sf3_mask */

    case 6:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V8DFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 2733; /* *addv8df3_mask */

    case 7:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V4DFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
        return -1;
      return 2741; /* *addv4df3_mask */

    case 8:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V2DFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 394 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
        return -1;
      return 2749; /* *addv2df3_mask */

    case 9:
      if (!(
#line 16271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (PLUS, V16SImode, operands)) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7413; /* *addv16si3_mask */

    case 10:
      if (!(
#line 16271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (PLUS, V8SImode, operands)) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7415; /* *addv8si3_mask */

    case 11:
      if (!(
#line 16271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (PLUS, V4SImode, operands)) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7417; /* *addv4si3_mask */

    case 12:
      if (!(
#line 16271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (PLUS, V8DImode, operands)) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7419; /* *addv8di3_mask */

    case 13:
      if (!(
#line 16271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (PLUS, V4DImode, operands)) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7421; /* *addv4di3_mask */

    case 14:
      if (!(
#line 16271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (PLUS, V2DImode, operands)) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7423; /* *addv2di3_mask */

    case 15:
      if (!(
#line 16285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (PLUS, V64QImode, operands)) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7425; /* *addv64qi3_mask */

    case 16:
      if (!(
#line 16285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (PLUS, V16QImode, operands)) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7427; /* *addv16qi3_mask */

    case 17:
      if (!(
#line 16285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (PLUS, V32QImode, operands)) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7429; /* *addv32qi3_mask */

    case 18:
      if (!(
#line 16285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (PLUS, V32HImode, operands)) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7431; /* *addv32hi3_mask */

    case 19:
      if (!(
#line 16285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (PLUS, V16HImode, operands)) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7433; /* *addv16hi3_mask */

    case 20:
      if (!(
#line 16285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (PLUS, V8HImode, operands)) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7435; /* *addv8hi3_mask */

    case 21:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32370 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
        return -1;
      return 10533; /* avx10_2_addbf16_v32bf_mask */

    case 22:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32370 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
        return -1;
      return 10541; /* avx10_2_addbf16_v16bf_mask */

    case 23:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32370 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
        return -1;
      return 10549; /* avx10_2_addbf16_v8bf_mask */

    case 24:
      if (!(
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
        return -1;
      return 2761; /* avx512fp16_vmaddv8hf3 */

    case 25:
      if (!
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
        return -1;
      return 2769; /* sse_vmaddv4sf3 */

    case 26:
      if (!(
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 2777; /* sse2_vmaddv2df3 */

    default:
      return -1;
    }
}

 int
recog_217 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 1);
  if (!const_4_or_8_to_11_operand (x3, E_SImode))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  x5 = XEXP (x4, 0);
  x6 = XVECEXP (x5, 0, 2);
  switch (GET_CODE (x6))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[3] = x6;
      x7 = XEXP (x4, 1);
      switch (GET_CODE (x7))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          operands[4] = x7;
          x8 = XEXP (x4, 2);
          operands[5] = x8;
          operands[6] = x3;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1628 (x2, 
E_SImode, 
E_V32HFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
                return -1;
              return 4027; /* fma_fmaddsub_v32hf_maskz_1_round */

            case E_V16SFmode:
              if (pattern1628 (x2, 
E_HImode, 
E_V16SFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && (V16SFmode == V16SFmode
							      || V16SFmode == V8DFmode
							      || V16SFmode == V8DImode
							      || V16SFmode == V16SImode
							      || V16SFmode == V32HFmode)) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4035; /* fma_fmaddsub_v16sf_maskz_1_round */

            case E_V8DFmode:
              if (pattern1628 (x2, 
E_QImode, 
E_V8DFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && (V8DFmode == V16SFmode
							      || V8DFmode == V8DFmode
							      || V8DFmode == V8DImode
							      || V8DFmode == V16SImode
							      || V8DFmode == V32HFmode)) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4043; /* fma_fmaddsub_v8df_maskz_1_round */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          x8 = XEXP (x4, 2);
          operands[4] = x8;
          operands[5] = x3;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1569 (x2, 
E_V32HFmode, 
E_SImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V32HFmode)
                  && register_operand (operands[3], E_V32HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
                return 4049; /* avx512bw_fmaddsub_v32hf_mask_round */
              if (!nonimmediate_operand (operands[1], E_V32HFmode)
                  || !nonimmediate_operand (operands[3], E_V32HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
                return -1;
              return 4067; /* avx512bw_fmaddsub_v32hf_mask3_round */

            case E_V16HFmode:
              if (pattern1569 (x2, 
E_V16HFmode, 
E_HImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V16HFmode)
                  && register_operand (operands[3], E_V16HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return 4051; /* avx512vl_fmaddsub_v16hf_mask_round */
              if (!nonimmediate_operand (operands[1], E_V16HFmode)
                  || !nonimmediate_operand (operands[3], E_V16HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return -1;
              return 4069; /* avx512vl_fmaddsub_v16hf_mask3_round */

            case E_V8HFmode:
              if (pattern1569 (x2, 
E_V8HFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V8HFmode)
                  && register_operand (operands[3], E_V8HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return 4053; /* avx512fp16_fmaddsub_v8hf_mask_round */
              if (!nonimmediate_operand (operands[1], E_V8HFmode)
                  || !nonimmediate_operand (operands[3], E_V8HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return -1;
              return 4071; /* avx512fp16_fmaddsub_v8hf_mask3_round */

            case E_V16SFmode:
              if (pattern1569 (x2, 
E_V16SFmode, 
E_HImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V16SFmode)
                  && register_operand (operands[3], E_V16SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return 4055; /* avx512f_fmaddsub_v16sf_mask_round */
              if (!nonimmediate_operand (operands[1], E_V16SFmode)
                  || !nonimmediate_operand (operands[3], E_V16SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4073; /* avx512f_fmaddsub_v16sf_mask3_round */

            case E_V8SFmode:
              if (pattern1569 (x2, 
E_V8SFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V8SFmode)
                  && register_operand (operands[3], E_V8SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return 4057; /* avx512vl_fmaddsub_v8sf_mask_round */
              if (!nonimmediate_operand (operands[1], E_V8SFmode)
                  || !nonimmediate_operand (operands[3], E_V8SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 4075; /* avx512vl_fmaddsub_v8sf_mask3_round */

            case E_V4SFmode:
              if (pattern1569 (x2, 
E_V4SFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V4SFmode)
                  && register_operand (operands[3], E_V4SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return 4059; /* avx512vl_fmaddsub_v4sf_mask_round */
              if (!nonimmediate_operand (operands[1], E_V4SFmode)
                  || !nonimmediate_operand (operands[3], E_V4SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 4077; /* avx512vl_fmaddsub_v4sf_mask3_round */

            case E_V8DFmode:
              if (pattern1569 (x2, 
E_V8DFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V8DFmode)
                  && register_operand (operands[3], E_V8DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return 4061; /* avx512f_fmaddsub_v8df_mask_round */
              if (!nonimmediate_operand (operands[1], E_V8DFmode)
                  || !nonimmediate_operand (operands[3], E_V8DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4079; /* avx512f_fmaddsub_v8df_mask3_round */

            case E_V4DFmode:
              if (pattern1569 (x2, 
E_V4DFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V4DFmode)
                  && register_operand (operands[3], E_V4DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return 4063; /* avx512vl_fmaddsub_v4df_mask_round */
              if (!nonimmediate_operand (operands[1], E_V4DFmode)
                  || !nonimmediate_operand (operands[3], E_V4DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 4081; /* avx512vl_fmaddsub_v4df_mask3_round */

            case E_V2DFmode:
              if (pattern1569 (x2, 
E_V2DFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V2DFmode)
                  && register_operand (operands[3], E_V2DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return 4065; /* avx512vl_fmaddsub_v2df_mask_round */
              if (!nonimmediate_operand (operands[1], E_V2DFmode)
                  || !nonimmediate_operand (operands[3], E_V2DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 4083; /* avx512vl_fmaddsub_v2df_mask3_round */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case NEG:
      x9 = XEXP (x6, 0);
      operands[3] = x9;
      x7 = XEXP (x4, 1);
      switch (GET_CODE (x7))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          operands[4] = x7;
          x8 = XEXP (x4, 2);
          operands[5] = x8;
          operands[6] = x3;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1629 (x2, 
E_SImode, 
E_V32HFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6495 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
                return -1;
              return 4091; /* fma_fmsubadd_v32hf_maskz_1_round */

            case E_V16SFmode:
              if (pattern1629 (x2, 
E_HImode, 
E_V16SFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6495 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && (V16SFmode == V16SFmode
							      || V16SFmode == V8DFmode
							      || V16SFmode == V8DImode
							      || V16SFmode == V16SImode
							      || V16SFmode == V32HFmode)) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4099; /* fma_fmsubadd_v16sf_maskz_1_round */

            case E_V8DFmode:
              if (pattern1629 (x2, 
E_QImode, 
E_V8DFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6495 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && (V8DFmode == V16SFmode
							      || V8DFmode == V8DFmode
							      || V8DFmode == V8DImode
							      || V8DFmode == V16SImode
							      || V8DFmode == V32HFmode)) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4107; /* fma_fmsubadd_v8df_maskz_1_round */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          x8 = XEXP (x4, 2);
          operands[4] = x8;
          operands[5] = x3;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1570 (x2, 
E_V32HFmode, 
E_SImode) != 0)
                return -1;
              if (register_operand (operands[3], E_V32HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
                return 4113; /* avx512bw_fmsubadd_v32hf_mask_round */
              if (!nonimmediate_operand (operands[3], E_V32HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
                return -1;
              return 4131; /* avx512bw_fmsubadd_v32hf_mask3_round */

            case E_V16HFmode:
              if (pattern1570 (x2, 
E_V16HFmode, 
E_HImode) != 0)
                return -1;
              if (register_operand (operands[3], E_V16HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return 4115; /* avx512vl_fmsubadd_v16hf_mask_round */
              if (!nonimmediate_operand (operands[3], E_V16HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return -1;
              return 4133; /* avx512vl_fmsubadd_v16hf_mask3_round */

            case E_V8HFmode:
              if (pattern1570 (x2, 
E_V8HFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[3], E_V8HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return 4117; /* avx512fp16_fmsubadd_v8hf_mask_round */
              if (!nonimmediate_operand (operands[3], E_V8HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return -1;
              return 4135; /* avx512fp16_fmsubadd_v8hf_mask3_round */

            case E_V16SFmode:
              if (pattern1570 (x2, 
E_V16SFmode, 
E_HImode) != 0)
                return -1;
              if (register_operand (operands[3], E_V16SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return 4119; /* avx512f_fmsubadd_v16sf_mask_round */
              if (!nonimmediate_operand (operands[3], E_V16SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4137; /* avx512f_fmsubadd_v16sf_mask3_round */

            case E_V8SFmode:
              if (pattern1570 (x2, 
E_V8SFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[3], E_V8SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return 4121; /* avx512vl_fmsubadd_v8sf_mask_round */
              if (!nonimmediate_operand (operands[3], E_V8SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 4139; /* avx512vl_fmsubadd_v8sf_mask3_round */

            case E_V4SFmode:
              if (pattern1570 (x2, 
E_V4SFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[3], E_V4SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return 4123; /* avx512vl_fmsubadd_v4sf_mask_round */
              if (!nonimmediate_operand (operands[3], E_V4SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 4141; /* avx512vl_fmsubadd_v4sf_mask3_round */

            case E_V8DFmode:
              if (pattern1570 (x2, 
E_V8DFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[3], E_V8DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return 4125; /* avx512f_fmsubadd_v8df_mask_round */
              if (!nonimmediate_operand (operands[3], E_V8DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4143; /* avx512f_fmsubadd_v8df_mask3_round */

            case E_V4DFmode:
              if (pattern1570 (x2, 
E_V4DFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[3], E_V4DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return 4127; /* avx512vl_fmsubadd_v4df_mask_round */
              if (!nonimmediate_operand (operands[3], E_V4DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 4145; /* avx512vl_fmsubadd_v4df_mask3_round */

            case E_V2DFmode:
              if (pattern1570 (x2, 
E_V2DFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[3], E_V2DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return 4129; /* avx512vl_fmsubadd_v2df_mask_round */
              if (!nonimmediate_operand (operands[3], E_V2DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 4147; /* avx512vl_fmsubadd_v2df_mask3_round */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_230 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != MEM)
    return -1;
  operands[5] = x2;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != UNSPEC
      || XVECLEN (x3, 0) != 4
      || XINT (x3, 1) != 154)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  operands[0] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[4] = x6;
  if (!const1248_operand (operands[4], E_SImode))
    return -1;
  x7 = XVECEXP (x3, 0, 3);
  operands[6] = x7;
  x8 = XEXP (x1, 1);
  x9 = XVECEXP (x8, 0, 1);
  operands[3] = x9;
  x10 = XVECEXP (x8, 0, 0);
  if (!rtx_equal_p (x10, operands[6]))
    return -1;
  switch (GET_MODE (operands[5]))
    {
    case E_V16SImode:
      if (!vsib_mem_operator (operands[5], E_V16SImode)
          || GET_MODE (x8) != E_V16SImode)
        return -1;
      switch (GET_MODE (x3))
        {
        case E_SImode:
          switch (pattern1684 (
E_SImode))
            {
            case 0:
              if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              *pnum_clobbers = 1;
              return 9766; /* *avx512f_scattersiv16si */

            case 1:
              if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              *pnum_clobbers = 1;
              return 9790; /* *avx512f_scatterdiv16si */

            default:
              return -1;
            }

        case E_DImode:
          switch (pattern1684 (
E_DImode))
            {
            case 0:
              if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              *pnum_clobbers = 1;
              return 9778; /* *avx512f_scattersiv16si */

            case 1:
              if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              *pnum_clobbers = 1;
              return 9802; /* *avx512f_scatterdiv16si */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case E_V16SFmode:
      if (!vsib_mem_operator (operands[5], E_V16SFmode)
          || GET_MODE (x8) != E_V16SFmode)
        return -1;
      switch (GET_MODE (x3))
        {
        case E_SImode:
          switch (pattern1685 (
E_SImode))
            {
            case 0:
              if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              *pnum_clobbers = 1;
              return 9767; /* *avx512f_scattersiv16sf */

            case 1:
              if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              *pnum_clobbers = 1;
              return 9791; /* *avx512f_scatterdiv16sf */

            default:
              return -1;
            }

        case E_DImode:
          switch (pattern1685 (
E_DImode))
            {
            case 0:
              if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              *pnum_clobbers = 1;
              return 9779; /* *avx512f_scattersiv16sf */

            case 1:
              if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              *pnum_clobbers = 1;
              return 9803; /* *avx512f_scatterdiv16sf */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case E_V8DImode:
      switch (pattern1586 (x1, 
E_V8DImode))
        {
        case 0:
          if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          *pnum_clobbers = 1;
          return 9768; /* *avx512f_scattersiv8di */

        case 1:
          if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          *pnum_clobbers = 1;
          return 9792; /* *avx512f_scatterdiv8di */

        case 2:
          if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          *pnum_clobbers = 1;
          return 9780; /* *avx512f_scattersiv8di */

        case 3:
          if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          *pnum_clobbers = 1;
          return 9804; /* *avx512f_scatterdiv8di */

        default:
          return -1;
        }

    case E_V8DFmode:
      switch (pattern1586 (x1, 
E_V8DFmode))
        {
        case 0:
          if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          *pnum_clobbers = 1;
          return 9769; /* *avx512f_scattersiv8df */

        case 1:
          if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          *pnum_clobbers = 1;
          return 9793; /* *avx512f_scatterdiv8df */

        case 2:
          if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          *pnum_clobbers = 1;
          return 9781; /* *avx512f_scattersiv8df */

        case 3:
          if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          *pnum_clobbers = 1;
          return 9805; /* *avx512f_scatterdiv8df */

        default:
          return -1;
        }

    case E_V8SImode:
      switch (pattern1587 (x1, 
E_V8SImode))
        {
        case 0:
          switch (pattern1722 (
E_SImode))
            {
            case 0:
              if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              *pnum_clobbers = 1;
              return 9770; /* *avx512f_scattersiv8si */

            case 1:
              if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              *pnum_clobbers = 1;
              return 9794; /* *avx512f_scatterdiv8si */

            default:
              return -1;
            }

        case 1:
          switch (pattern1722 (
E_DImode))
            {
            case 0:
              if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              *pnum_clobbers = 1;
              return 9782; /* *avx512f_scattersiv8si */

            case 1:
              if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              *pnum_clobbers = 1;
              return 9806; /* *avx512f_scatterdiv8si */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case E_V8SFmode:
      switch (pattern1587 (x1, 
E_V8SFmode))
        {
        case 0:
          switch (pattern1723 (
E_SImode))
            {
            case 0:
              if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              *pnum_clobbers = 1;
              return 9771; /* *avx512f_scattersiv8sf */

            case 1:
              if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              *pnum_clobbers = 1;
              return 9795; /* *avx512f_scatterdiv8sf */

            default:
              return -1;
            }

        case 1:
          switch (pattern1723 (
E_DImode))
            {
            case 0:
              if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              *pnum_clobbers = 1;
              return 9783; /* *avx512f_scattersiv8sf */

            case 1:
              if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              *pnum_clobbers = 1;
              return 9807; /* *avx512f_scatterdiv8sf */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case E_V4DImode:
      switch (pattern1589 (x1, 
E_V4DImode))
        {
        case 0:
          if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9772; /* *avx512f_scattersiv4di */

        case 1:
          if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9796; /* *avx512f_scatterdiv4di */

        case 2:
          if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9784; /* *avx512f_scattersiv4di */

        case 3:
          if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9808; /* *avx512f_scatterdiv4di */

        default:
          return -1;
        }

    case E_V4DFmode:
      switch (pattern1589 (x1, 
E_V4DFmode))
        {
        case 0:
          if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9773; /* *avx512f_scattersiv4df */

        case 1:
          if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9797; /* *avx512f_scatterdiv4df */

        case 2:
          if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9785; /* *avx512f_scattersiv4df */

        case 3:
          if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9809; /* *avx512f_scatterdiv4df */

        default:
          return -1;
        }

    case E_V4SImode:
      switch (pattern1591 (x1, 
E_V4SImode))
        {
        case 0:
          if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9774; /* *avx512f_scattersiv4si */

        case 1:
          if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9798; /* *avx512f_scatterdiv4si */

        case 2:
          if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9786; /* *avx512f_scattersiv4si */

        case 3:
          if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9810; /* *avx512f_scatterdiv4si */

        default:
          return -1;
        }

    case E_V4SFmode:
      switch (pattern1591 (x1, 
E_V4SFmode))
        {
        case 0:
          if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9775; /* *avx512f_scattersiv4sf */

        case 1:
          if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9799; /* *avx512f_scatterdiv4sf */

        case 2:
          if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9787; /* *avx512f_scattersiv4sf */

        case 3:
          if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9811; /* *avx512f_scatterdiv4sf */

        default:
          return -1;
        }

    case E_V2DImode:
      switch (pattern1591 (x1, 
E_V2DImode))
        {
        case 0:
          if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9776; /* *avx512f_scattersiv2di */

        case 1:
          if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9800; /* *avx512f_scatterdiv2di */

        case 2:
          if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9788; /* *avx512f_scattersiv2di */

        case 3:
          if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9812; /* *avx512f_scatterdiv2di */

        default:
          return -1;
        }

    case E_V2DFmode:
      switch (pattern1591 (x1, 
E_V2DFmode))
        {
        case 0:
          if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9777; /* *avx512f_scattersiv2df */

        case 1:
          if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9801; /* *avx512f_scatterdiv2df */

        case 2:
          if (!(
#line 29841 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9789; /* *avx512f_scattersiv2df */

        case 3:
          if (!(
#line 29881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && (((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          *pnum_clobbers = 1;
          return 9813; /* *avx512f_scatterdiv2df */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_252 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  if (!const_0_to_255_operand (operands[3], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      if (pattern61 (x3, 
E_V16SImode) != 0
          || !(
#line 14042 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 6994; /* *avx512f_alignv16si */

    case E_V8SImode:
      if (pattern61 (x3, 
E_V8SImode) != 0
          || !(
#line 14042 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 6996; /* *avx512vl_alignv8si */

    case E_V4SImode:
      if (pattern61 (x3, 
E_V4SImode) != 0
          || !(
#line 14042 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 6998; /* *avx512vl_alignv4si */

    case E_V8DImode:
      if (pattern61 (x3, 
E_V8DImode) != 0
          || !(
#line 14042 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7000; /* *avx512f_alignv8di */

    case E_V4DImode:
      if (pattern61 (x3, 
E_V4DImode) != 0
          || !(
#line 14042 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7002; /* *avx512vl_alignv4di */

    case E_V2DImode:
      if (pattern61 (x3, 
E_V2DImode) != 0
          || !(
#line 14042 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7004; /* *avx512vl_alignv2di */

    default:
      return -1;
    }
}

 int
recog_257 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  if (!const_int_operand (operands[3], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V16QImode:
      if (pattern61 (x3, 
E_V16QImode) != 0
          || !
#line 27310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
        return -1;
      return 9002; /* xop_pcom_tfv16qi3 */

    case E_V8HImode:
      if (pattern61 (x3, 
E_V8HImode) != 0
          || !
#line 27310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
        return -1;
      return 9003; /* xop_pcom_tfv8hi3 */

    case E_V4SImode:
      if (pattern61 (x3, 
E_V4SImode) != 0
          || !
#line 27310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
        return -1;
      return 9004; /* xop_pcom_tfv4si3 */

    case E_V2DImode:
      if (pattern61 (x3, 
E_V2DImode) != 0
          || !
#line 27310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
        return -1;
      return 9005; /* xop_pcom_tfv2di3 */

    default:
      return -1;
    }
}

 int
recog_261 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  switch (XINT (x3, 1))
    {
    case 164:
      x4 = XVECEXP (x3, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x3, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x3, 0, 2);
      operands[3] = x6;
      x7 = XVECEXP (x3, 0, 3);
      operands[4] = x7;
      if (!const_0_to_255_operand (operands[4], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern1124 (x3, 
E_V16SImode) != 0)
            return -1;
          if ((
#line 13637 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return 5368; /* avx512f_vternlogv16si */
          if (!(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V16SImode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5386; /* *avx512f_vternlogv16si_all */

        case E_V8SImode:
          if (pattern1124 (x3, 
E_V8SImode) != 0)
            return -1;
          if ((
#line 13637 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 5370; /* avx512vl_vternlogv8si */
          if (!(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V8SImode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5387; /* *avx512vl_vternlogv8si_all */

        case E_V4SImode:
          if (pattern1124 (x3, 
E_V4SImode) != 0)
            return -1;
          if ((
#line 13637 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 5372; /* avx512vl_vternlogv4si */
          if (!
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V4SImode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)))
            return -1;
          return 5388; /* *avx512vl_vternlogv4si_all */

        case E_V8DImode:
          if (pattern1124 (x3, 
E_V8DImode) != 0)
            return -1;
          if ((
#line 13637 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return 5374; /* avx512f_vternlogv8di */
          if (!(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V8DImode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5389; /* *avx512f_vternlogv8di_all */

        case E_V4DImode:
          if (pattern1124 (x3, 
E_V4DImode) != 0)
            return -1;
          if ((
#line 13637 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 5376; /* avx512vl_vternlogv4di */
          if (!(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V4DImode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5390; /* *avx512vl_vternlogv4di_all */

        case E_V2DImode:
          if (pattern1124 (x3, 
E_V2DImode) != 0)
            return -1;
          if ((
#line 13637 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 5378; /* avx512vl_vternlogv2di */
          if (!
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V2DImode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)))
            return -1;
          return 5391; /* *avx512vl_vternlogv2di_all */

        case E_V64QImode:
          if (pattern1124 (x3, 
E_V64QImode) != 0
              || !(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V64QImode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5380; /* *avx512bw_vternlogv64qi_all */

        case E_V32QImode:
          if (pattern1124 (x3, 
E_V32QImode) != 0
              || !(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V32QImode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5381; /* *avx512vl_vternlogv32qi_all */

        case E_V16QImode:
          if (pattern1124 (x3, 
E_V16QImode) != 0
              || !
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V16QImode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)))
            return -1;
          return 5382; /* *avx512vl_vternlogv16qi_all */

        case E_V32HImode:
          if (pattern1124 (x3, 
E_V32HImode) != 0
              || !(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V32HImode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5383; /* *avx512bw_vternlogv32hi_all */

        case E_V16HImode:
          if (pattern1124 (x3, 
E_V16HImode) != 0
              || !(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V16HImode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5384; /* *avx512vl_vternlogv16hi_all */

        case E_V8HImode:
          if (pattern1124 (x3, 
E_V8HImode) != 0
              || !
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V8HImode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)))
            return -1;
          return 5385; /* *avx512vl_vternlogv8hi_all */

        case E_V32HFmode:
          if (pattern1124 (x3, 
E_V32HFmode) != 0
              || !(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V32HFmode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5392; /* *avx512bw_vternlogv32hf_all */

        case E_V16HFmode:
          if (pattern1124 (x3, 
E_V16HFmode) != 0
              || !(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V16HFmode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5393; /* *avx512vl_vternlogv16hf_all */

        case E_V8HFmode:
          if (pattern1124 (x3, 
E_V8HFmode) != 0
              || !
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V8HFmode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)))
            return -1;
          return 5394; /* *avx512fp16_vternlogv8hf_all */

        case E_V32BFmode:
          if (pattern1124 (x3, 
E_V32BFmode) != 0
              || !(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V32BFmode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5395; /* *avx512bw_vternlogv32bf_all */

        case E_V16BFmode:
          if (pattern1124 (x3, 
E_V16BFmode) != 0
              || !(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V16BFmode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5396; /* *avx512vl_vternlogv16bf_all */

        case E_V8BFmode:
          if (pattern1124 (x3, 
E_V8BFmode) != 0
              || !
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V8BFmode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)))
            return -1;
          return 5397; /* *avx512vl_vternlogv8bf_all */

        case E_V16SFmode:
          if (pattern1124 (x3, 
E_V16SFmode) != 0
              || !(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V16SFmode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5398; /* *avx512f_vternlogv16sf_all */

        case E_V8SFmode:
          if (pattern1124 (x3, 
E_V8SFmode) != 0
              || !(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V8SFmode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5399; /* *avx512vl_vternlogv8sf_all */

        case E_V4SFmode:
          if (pattern1124 (x3, 
E_V4SFmode) != 0
              || !
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V4SFmode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)))
            return -1;
          return 5400; /* *avx512vl_vternlogv4sf_all */

        case E_V8DFmode:
          if (pattern1124 (x3, 
E_V8DFmode) != 0
              || !(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V8DFmode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5401; /* *avx512f_vternlogv8df_all */

        case E_V4DFmode:
          if (pattern1124 (x3, 
E_V4DFmode) != 0
              || !(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V4DFmode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5402; /* *avx512vl_vternlogv4df_all */

        case E_V2DFmode:
          if (pattern1124 (x3, 
E_V2DFmode) != 0
              || !(
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
/* Disallow embeded broadcast for vector HFmode since
   it's not real AVX512FP16 instruction.  */
  && (GET_MODE_SIZE (GET_MODE_INNER (V2DFmode)) >= 4
     || GET_CODE (operands[3]) != VEC_DUPLICATE)) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 5403; /* *avx512vl_vternlogv2df_all */

        default:
          return -1;
        }

    case 163:
      x4 = XVECEXP (x3, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x3, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x3, 0, 2);
      operands[3] = x6;
      x7 = XVECEXP (x3, 0, 3);
      operands[4] = x7;
      if (!const_0_to_255_operand (operands[4], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SFmode:
          if (pattern1125 (x3, 
E_V16SImode, 
E_V16SFmode) != 0
              || !(
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 7014; /* avx512f_fixupimmv16sf */

        case E_V8SFmode:
          if (pattern1125 (x3, 
E_V8SImode, 
E_V8SFmode) != 0
              || !(
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7018; /* avx512vl_fixupimmv8sf */

        case E_V4SFmode:
          if (pattern1125 (x3, 
E_V4SImode, 
E_V4SFmode) != 0
              || !(
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7022; /* avx512vl_fixupimmv4sf */

        case E_V8DFmode:
          if (pattern1125 (x3, 
E_V8DImode, 
E_V8DFmode) != 0
              || !(
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 7026; /* avx512f_fixupimmv8df */

        case E_V4DFmode:
          if (pattern1125 (x3, 
E_V4DImode, 
E_V4DFmode) != 0
              || !(
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7030; /* avx512vl_fixupimmv4df */

        case E_V2DFmode:
          if (pattern1125 (x3, 
E_V2DImode, 
E_V2DFmode) != 0
              || !(
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7034; /* avx512vl_fixupimmv2df */

        default:
          return -1;
        }

    case 124:
      if (GET_MODE (x3) != E_V2DImode
          || !register_operand (operands[0], E_V2DImode))
        return -1;
      x4 = XVECEXP (x3, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      x5 = XVECEXP (x3, 0, 1);
      operands[2] = x5;
      if (!register_operand (operands[2], E_V2DImode))
        return -1;
      x6 = XVECEXP (x3, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_VOIDmode))
        return -1;
      x7 = XVECEXP (x3, 0, 3);
      operands[4] = x7;
      if (!const_0_to_255_operand (operands[4], E_VOIDmode)
          || !
#line 23463 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4A))
        return -1;
      return 8604; /* sse4a_insertqi */

    case 145:
      x4 = XVECEXP (x3, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x3, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x3, 0, 2);
      operands[3] = x6;
      x7 = XVECEXP (x3, 0, 3);
      operands[4] = x7;
      if (!const_0_to_3_operand (operands[4], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (pattern1126 (x3, 
E_V8SImode, 
E_V8SFmode) != 0
              || !(
#line 27327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 9006; /* xop_vpermil2v8sf3 */

        case E_V4SFmode:
          if (pattern1126 (x3, 
E_V4SImode, 
E_V4SFmode) != 0
              || !
#line 27327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 9007; /* xop_vpermil2v4sf3 */

        case E_V4DFmode:
          if (pattern1126 (x3, 
E_V4DImode, 
E_V4DFmode) != 0
              || !(
#line 27327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 9008; /* xop_vpermil2v4df3 */

        case E_V2DFmode:
          if (pattern1126 (x3, 
E_V2DImode, 
E_V2DFmode) != 0
              || !(
#line 27327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 9009; /* xop_vpermil2v2df3 */

        default:
          return -1;
        }

    case 153:
      if (pnum_clobbers == NULL)
        return -1;
      x5 = XVECEXP (x3, 0, 1);
      if (GET_CODE (x5) != MEM)
        return -1;
      x8 = XEXP (x5, 0);
      if (GET_CODE (x8) != UNSPEC
          || XVECLEN (x8, 0) != 3
          || XINT (x8, 1) != 154)
        return -1;
      x6 = XVECEXP (x3, 0, 2);
      if (GET_CODE (x6) != MEM
          || GET_MODE (x6) != E_BLKmode)
        return -1;
      x9 = XEXP (x6, 0);
      if (GET_CODE (x9) != SCRATCH)
        return -1;
      x10 = XVECEXP (x8, 0, 2);
      if (!const1248_operand (x10, E_SImode))
        return -1;
      x4 = XVECEXP (x3, 0, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
          operands[2] = x4;
          operands[7] = x5;
          x11 = XVECEXP (x8, 0, 0);
          operands[3] = x11;
          x12 = XVECEXP (x8, 0, 1);
          operands[4] = x12;
          operands[6] = x10;
          x7 = XVECEXP (x3, 0, 3);
          operands[5] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_V2DImode:
              switch (pattern1725 (x3, 
E_V2DImode, 
E_DImode))
                {
                case 0:
                  if (!(
#line 29534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9598; /* *avx2_gathersiv2di */

                case 1:
                  if (!(
#line 29597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9630; /* *avx2_gatherdiv2di */

                case 2:
                  if (!(
#line 29534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9606; /* *avx2_gathersiv2di */

                case 3:
                  if (!(
#line 29597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9638; /* *avx2_gatherdiv2di */

                default:
                  return -1;
                }

            case E_V2DFmode:
              switch (pattern1725 (x3, 
E_V2DFmode, 
E_DFmode))
                {
                case 0:
                  if (!(
#line 29534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9599; /* *avx2_gathersiv2df */

                case 1:
                  if (!(
#line 29597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9631; /* *avx2_gatherdiv2df */

                case 2:
                  if (!(
#line 29534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9607; /* *avx2_gathersiv2df */

                case 3:
                  if (!(
#line 29597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9639; /* *avx2_gatherdiv2df */

                default:
                  return -1;
                }

            case E_V4DImode:
              switch (pattern1727 (x3, 
E_V4DImode, 
E_DImode))
                {
                case 0:
                  if (!(
#line 29534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9600; /* *avx2_gathersiv4di */

                case 1:
                  if (!(
#line 29597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9632; /* *avx2_gatherdiv4di */

                case 2:
                  if (!(
#line 29534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9608; /* *avx2_gathersiv4di */

                case 3:
                  if (!(
#line 29597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9640; /* *avx2_gatherdiv4di */

                default:
                  return -1;
                }

            case E_V4DFmode:
              switch (pattern1727 (x3, 
E_V4DFmode, 
E_DFmode))
                {
                case 0:
                  if (!(
#line 29534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9601; /* *avx2_gathersiv4df */

                case 1:
                  if (!(
#line 29597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9633; /* *avx2_gatherdiv4df */

                case 2:
                  if (!(
#line 29534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9609; /* *avx2_gathersiv4df */

                case 3:
                  if (!(
#line 29597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9641; /* *avx2_gatherdiv4df */

                default:
                  return -1;
                }

            case E_V4SImode:
              switch (pattern1725 (x3, 
E_V4SImode, 
E_SImode))
                {
                case 0:
                  if (!(
#line 29534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9602; /* *avx2_gathersiv4si */

                case 1:
                  if (!(
#line 29597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9634; /* *avx2_gatherdiv4si */

                case 2:
                  if (!(
#line 29534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9610; /* *avx2_gathersiv4si */

                case 3:
                  if (!(
#line 29597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9642; /* *avx2_gatherdiv4si */

                default:
                  return -1;
                }

            case E_V4SFmode:
              switch (pattern1725 (x3, 
E_V4SFmode, 
E_SFmode))
                {
                case 0:
                  if (!(
#line 29534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9603; /* *avx2_gathersiv4sf */

                case 1:
                  if (!(
#line 29597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9635; /* *avx2_gatherdiv4sf */

                case 2:
                  if (!(
#line 29534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9611; /* *avx2_gathersiv4sf */

                case 3:
                  if (!(
#line 29597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9643; /* *avx2_gatherdiv4sf */

                default:
                  return -1;
                }

            case E_V8SImode:
              if (!register_operand (operands[0], E_V8SImode)
                  || GET_MODE (x3) != E_V8SImode
                  || !vsib_mem_operator (operands[7], E_SImode))
                return -1;
              switch (GET_MODE (operands[2]))
                {
                case E_V8SImode:
                  if (!register_operand (operands[2], E_V8SImode)
                      || !register_operand (operands[4], E_V8SImode))
                    return -1;
                  switch (pattern1798 (x8, 
E_V8SImode))
                    {
                    case 0:
                      if (!(
#line 29534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9604; /* *avx2_gathersiv8si */

                    case 1:
                      if (!(
#line 29534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9612; /* *avx2_gathersiv8si */

                    default:
                      return -1;
                    }

                case E_V4SImode:
                  switch (pattern1799 (x8, 
E_V4SImode, 
E_V4DImode))
                    {
                    case 0:
                      if (!(
#line 29597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9636; /* *avx2_gatherdiv8si */

                    case 1:
                      if (!(
#line 29597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9644; /* *avx2_gatherdiv8si */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            case E_V8SFmode:
              if (!register_operand (operands[0], E_V8SFmode)
                  || GET_MODE (x3) != E_V8SFmode
                  || !vsib_mem_operator (operands[7], E_SFmode))
                return -1;
              switch (GET_MODE (operands[2]))
                {
                case E_V8SFmode:
                  switch (pattern1799 (x8, 
E_V8SFmode, 
E_V8SImode))
                    {
                    case 0:
                      if (!(
#line 29534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9605; /* *avx2_gathersiv8sf */

                    case 1:
                      if (!(
#line 29534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9613; /* *avx2_gathersiv8sf */

                    default:
                      return -1;
                    }

                case E_V4SFmode:
                  switch (pattern1799 (x8, 
E_V4SFmode, 
E_V4DImode))
                    {
                    case 0:
                      if (!(
#line 29597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9637; /* *avx2_gatherdiv8sf */

                    case 1:
                      if (!(
#line 29597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9645; /* *avx2_gatherdiv8sf */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case PC:
          operands[6] = x5;
          x11 = XVECEXP (x8, 0, 0);
          operands[2] = x11;
          x12 = XVECEXP (x8, 0, 1);
          operands[3] = x12;
          operands[5] = x10;
          x7 = XVECEXP (x3, 0, 3);
          operands[4] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_V2DImode:
              switch (pattern1687 (x3, 
E_V2DImode, 
E_DImode))
                {
                case 0:
                  if (!(
#line 29555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9614; /* *avx2_gathersiv2di_2 */

                case 1:
                  if (!(
#line 29618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9646; /* *avx2_gatherdiv2di_2 */

                case 2:
                  if (!(
#line 29555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9622; /* *avx2_gathersiv2di_2 */

                case 3:
                  if (!(
#line 29618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9654; /* *avx2_gatherdiv2di_2 */

                default:
                  return -1;
                }

            case E_V2DFmode:
              switch (pattern1687 (x3, 
E_V2DFmode, 
E_DFmode))
                {
                case 0:
                  if (!(
#line 29555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9615; /* *avx2_gathersiv2df_2 */

                case 1:
                  if (!(
#line 29618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9647; /* *avx2_gatherdiv2df_2 */

                case 2:
                  if (!(
#line 29555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9623; /* *avx2_gathersiv2df_2 */

                case 3:
                  if (!(
#line 29618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9655; /* *avx2_gatherdiv2df_2 */

                default:
                  return -1;
                }

            case E_V4DImode:
              switch (pattern1689 (x3, 
E_V4DImode, 
E_DImode))
                {
                case 0:
                  if (!(
#line 29555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9616; /* *avx2_gathersiv4di_2 */

                case 1:
                  if (!(
#line 29618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9648; /* *avx2_gatherdiv4di_2 */

                case 2:
                  if (!(
#line 29555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9624; /* *avx2_gathersiv4di_2 */

                case 3:
                  if (!(
#line 29618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9656; /* *avx2_gatherdiv4di_2 */

                default:
                  return -1;
                }

            case E_V4DFmode:
              switch (pattern1689 (x3, 
E_V4DFmode, 
E_DFmode))
                {
                case 0:
                  if (!(
#line 29555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9617; /* *avx2_gathersiv4df_2 */

                case 1:
                  if (!(
#line 29618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9649; /* *avx2_gatherdiv4df_2 */

                case 2:
                  if (!(
#line 29555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9625; /* *avx2_gathersiv4df_2 */

                case 3:
                  if (!(
#line 29618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9657; /* *avx2_gatherdiv4df_2 */

                default:
                  return -1;
                }

            case E_V4SImode:
              switch (pattern1687 (x3, 
E_V4SImode, 
E_SImode))
                {
                case 0:
                  if (!(
#line 29555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9618; /* *avx2_gathersiv4si_2 */

                case 1:
                  if (!(
#line 29618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9650; /* *avx2_gatherdiv4si_2 */

                case 2:
                  if (!(
#line 29555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9626; /* *avx2_gathersiv4si_2 */

                case 3:
                  if (!(
#line 29618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9658; /* *avx2_gatherdiv4si_2 */

                default:
                  return -1;
                }

            case E_V4SFmode:
              switch (pattern1687 (x3, 
E_V4SFmode, 
E_SFmode))
                {
                case 0:
                  if (!(
#line 29555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9619; /* *avx2_gathersiv4sf_2 */

                case 1:
                  if (!(
#line 29618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9651; /* *avx2_gatherdiv4sf_2 */

                case 2:
                  if (!(
#line 29555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9627; /* *avx2_gathersiv4sf_2 */

                case 3:
                  if (!(
#line 29618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9659; /* *avx2_gatherdiv4sf_2 */

                default:
                  return -1;
                }

            case E_V8SImode:
              switch (pattern1690 (x3, 
E_SImode, 
E_V8SImode))
                {
                case 0:
                  switch (pattern1771 (
E_SImode))
                    {
                    case 0:
                      if (!(
#line 29555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9620; /* *avx2_gathersiv8si_2 */

                    case 1:
                      if (!(
#line 29618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9652; /* *avx2_gatherdiv8si_2 */

                    default:
                      return -1;
                    }

                case 1:
                  switch (pattern1771 (
E_DImode))
                    {
                    case 0:
                      if (!(
#line 29555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9628; /* *avx2_gathersiv8si_2 */

                    case 1:
                      if (!(
#line 29618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9660; /* *avx2_gatherdiv8si_2 */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            case E_V8SFmode:
              switch (pattern1690 (x3, 
E_SFmode, 
E_V8SFmode))
                {
                case 0:
                  switch (pattern1772 (
E_SImode))
                    {
                    case 0:
                      if (!(
#line 29555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9621; /* *avx2_gathersiv8sf_2 */

                    case 1:
                      if (!(
#line 29618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9653; /* *avx2_gatherdiv8sf_2 */

                    default:
                      return -1;
                    }

                case 1:
                  switch (pattern1772 (
E_DImode))
                    {
                    case 0:
                      if (!(
#line 29555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9629; /* *avx2_gathersiv8sf_2 */

                    case 1:
                      if (!(
#line 29618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9661; /* *avx2_gatherdiv8sf_2 */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 226:
      if (GET_MODE (x3) != E_V4SImode
          || pattern170 (x3) != 0)
        return -1;
      x7 = XVECEXP (x3, 0, 3);
      operands[4] = x7;
      if (!const_0_to_255_operand (operands[4], E_SImode)
          || !
#line 30307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SM3))
        return -1;
      return 10021; /* vsm3rnds2 */

    default:
      return -1;
    }
}

 int
recog_305 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case REG:
    case SUBREG:
    case MEM:
    case VEC_DUPLICATE:
      operands[1] = x3;
      x4 = XEXP (x2, 1);
      operands[2] = x4;
      switch (GET_CODE (operands[2]))
        {
        case REG:
        case SUBREG:
        case MEM:
        case VEC_DUPLICATE:
          switch (GET_MODE (operands[0]))
            {
            case E_V16BFmode:
              if (pattern25 (x2, 
E_V16BFmode) != 0
                  || !(
#line 5366 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 16 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 426 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 3675; /* *xorv16bf3 */

            case E_V8BFmode:
              if (pattern25 (x2, 
E_V8BFmode) != 0
                  || !(
#line 5366 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 16 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 426 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 3678; /* *xorv8bf3 */

            case E_V16HFmode:
              if (pattern25 (x2, 
E_V16HFmode) != 0
                  || !(
#line 5366 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 16 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 427 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 3681; /* *xorv16hf3 */

            case E_V8HFmode:
              if (pattern25 (x2, 
E_V8HFmode) != 0
                  || !(
#line 5366 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 16 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 427 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 3684; /* *xorv8hf3 */

            case E_V8SFmode:
              if (pattern25 (x2, 
E_V8SFmode) != 0
                  || !(
#line 5366 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 32 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 428 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 3689; /* *xorv8sf3 */

            case E_V4SFmode:
              if (pattern25 (x2, 
E_V4SFmode) != 0
                  || !
#line 5366 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 32 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 3695; /* *xorv4sf3 */

            case E_V4DFmode:
              if (pattern25 (x2, 
E_V4DFmode) != 0
                  || !(
#line 5366 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 64 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 429 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 3701; /* *xorv4df3 */

            case E_V2DFmode:
              if (pattern25 (x2, 
E_V2DFmode) != 0
                  || !(
#line 5366 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 64 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 429 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 3707; /* *xorv2df3 */

            case E_V32BFmode:
              if (pattern5 (x2, 
E_V32BFmode) != 0
                  || !(
#line 5436 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (!false || 16 != 16)) && 
#line 491 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3711; /* *xorv32bf3 */

            case E_V32HFmode:
              if (pattern5 (x2, 
E_V32HFmode) != 0
                  || !(
#line 5436 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (!false || 16 != 16)) && 
#line 492 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3714; /* *xorv32hf3 */

            case E_V16SFmode:
              if (pattern5 (x2, 
E_V16SFmode) != 0
                  || !(
#line 5436 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (!false || 32 != 16)) && 
#line 493 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3719; /* *xorv16sf3 */

            case E_V8DFmode:
              if (pattern5 (x2, 
E_V8DFmode) != 0
                  || !(
#line 5436 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (!false || 64 != 16)) && 
#line 494 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3725; /* *xorv8df3 */

            case E_V16SImode:
              if (pattern182 (x2, 
E_V16SImode) != 0
                  || !(
#line 18717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (XOR, V16SImode, operands)) && 
#line 807 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 7935; /* *xorv16si3 */

            case E_V8SImode:
              if (pattern182 (x2, 
E_V8SImode) != 0
                  || !(
#line 18717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (XOR, V8SImode, operands)) && 
#line 807 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 7941; /* *xorv8si3 */

            case E_V4SImode:
              if (pattern182 (x2, 
E_V4SImode) != 0
                  || !
#line 18717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (XOR, V4SImode, operands)))
                return -1;
              return 7947; /* *xorv4si3 */

            case E_V8DImode:
              if (pattern182 (x2, 
E_V8DImode) != 0
                  || !(
#line 18717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (XOR, V8DImode, operands)) && 
#line 808 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 7953; /* *xorv8di3 */

            case E_V4DImode:
              if (pattern182 (x2, 
E_V4DImode) != 0
                  || !(
#line 18717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (XOR, V4DImode, operands)) && 
#line 808 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 7959; /* *xorv4di3 */

            case E_V2DImode:
              if (pattern182 (x2, 
E_V2DImode) != 0
                  || !
#line 18717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (XOR, V2DImode, operands)))
                return -1;
              return 7965; /* *xorv2di3 */

            case E_V64QImode:
              if (pattern25 (x2, 
E_V64QImode) != 0
                  || !(
#line 18819 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 811 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 7969; /* *xorv64qi3 */

            case E_V32QImode:
              if (pattern25 (x2, 
E_V32QImode) != 0
                  || !(
#line 18819 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 811 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 7972; /* *xorv32qi3 */

            case E_V16QImode:
              if (pattern25 (x2, 
E_V16QImode) != 0
                  || !
#line 18819 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 7975; /* *xorv16qi3 */

            case E_V32HImode:
              if (pattern25 (x2, 
E_V32HImode) != 0
                  || !(
#line 18819 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 812 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 7978; /* *xorv32hi3 */

            case E_V16HImode:
              if (pattern25 (x2, 
E_V16HImode) != 0
                  || !(
#line 18819 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 812 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 7981; /* *xorv16hi3 */

            case E_V8HImode:
              if (pattern25 (x2, 
E_V8HImode) != 0
                  || !
#line 18819 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 7984; /* *xorv8hi3 */

            case E_V1TImode:
              if (pattern668 (x2, 
E_V1TImode) != 0
                  || !
#line 18916 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                return -1;
              return 7987; /* xorv1ti3 */

            default:
              return -1;
            }

        case CONST_VECTOR:
          switch (GET_MODE (operands[0]))
            {
            case E_V16SImode:
              if (pattern924 (x2, 
E_V16SImode) != 0
                  || !(
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (64 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || SImode == SImode
       || SImode == DImode)) && 
#line 568 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 7883; /* *one_cmplv16si2 */

            case E_V8DImode:
              if (pattern924 (x2, 
E_V8DImode) != 0
                  || !(
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (64 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || DImode == SImode
       || DImode == DImode)) && 
#line 569 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 7885; /* *one_cmplv8di2 */

            case E_V64QImode:
              if (pattern924 (x2, 
E_V64QImode) != 0
                  || !(
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (64 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || QImode == SImode
       || QImode == DImode)) && 
#line 570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return -1;
              return 7887; /* *one_cmplv64qi2 */

            case E_V32QImode:
              if (pattern924 (x2, 
E_V32QImode) != 0
                  || !(
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (32 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || QImode == SImode
       || QImode == DImode)) && 
#line 570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 7888; /* *one_cmplv32qi2 */

            case E_V16QImode:
              if (pattern924 (x2, 
E_V16QImode) != 0
                  || !
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (16 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || QImode == SImode
       || QImode == DImode)))
                return -1;
              return 7889; /* *one_cmplv16qi2 */

            case E_V32HImode:
              if (pattern924 (x2, 
E_V32HImode) != 0
                  || !(
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (64 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || HImode == SImode
       || HImode == DImode)) && 
#line 571 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return -1;
              return 7890; /* *one_cmplv32hi2 */

            case E_V16HImode:
              if (pattern924 (x2, 
E_V16HImode) != 0
                  || !(
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (32 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || HImode == SImode
       || HImode == DImode)) && 
#line 571 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 7891; /* *one_cmplv16hi2 */

            case E_V8HImode:
              if (pattern924 (x2, 
E_V8HImode) != 0
                  || !
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (16 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || HImode == SImode
       || HImode == DImode)))
                return -1;
              return 7892; /* *one_cmplv8hi2 */

            case E_V8SImode:
              if (pattern924 (x2, 
E_V8SImode) != 0
                  || !(
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (32 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || SImode == SImode
       || SImode == DImode)) && 
#line 572 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 7893; /* *one_cmplv8si2 */

            case E_V4SImode:
              if (pattern924 (x2, 
E_V4SImode) != 0
                  || !
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (16 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || SImode == SImode
       || SImode == DImode)))
                return -1;
              return 7895; /* *one_cmplv4si2 */

            case E_V4DImode:
              if (pattern924 (x2, 
E_V4DImode) != 0
                  || !(
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (32 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || DImode == SImode
       || DImode == DImode)) && 
#line 573 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 7897; /* *one_cmplv4di2 */

            case E_V2DImode:
              if (pattern924 (x2, 
E_V2DImode) != 0
                  || !
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (16 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || DImode == SImode
       || DImode == DImode)))
                return -1;
              return 7899; /* *one_cmplv2di2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case AND:
      x5 = XEXP (x3, 0);
      switch (GET_CODE (x5))
        {
        case REG:
        case SUBREG:
        case MEM:
        case NOT:
          switch (pattern533 (x2))
            {
            case 0:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5430; /* *avx512bw_vpternlogv64qi_1 */

            case 1:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5457; /* *avx512vl_vpternlogv32qi_1 */

            case 2:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5484; /* *avx512vl_vpternlogv16qi_1 */

            case 3:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5511; /* *avx512bw_vpternlogv32hi_1 */

            case 4:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5538; /* *avx512vl_vpternlogv16hi_1 */

            case 5:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5565; /* *avx512vl_vpternlogv8hi_1 */

            case 6:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5592; /* *avx512f_vpternlogv16si_1 */

            case 7:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5619; /* *avx512vl_vpternlogv8si_1 */

            case 8:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5646; /* *avx512vl_vpternlogv4si_1 */

            case 9:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5673; /* *avx512f_vpternlogv8di_1 */

            case 10:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5700; /* *avx512vl_vpternlogv4di_1 */

            case 11:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5727; /* *avx512vl_vpternlogv2di_1 */

            case 12:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5433; /* *avx512bw_vpternlogv64qi_1 */

            case 13:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5460; /* *avx512vl_vpternlogv32qi_1 */

            case 14:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5487; /* *avx512vl_vpternlogv16qi_1 */

            case 15:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5514; /* *avx512bw_vpternlogv32hi_1 */

            case 16:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5541; /* *avx512vl_vpternlogv16hi_1 */

            case 17:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5568; /* *avx512vl_vpternlogv8hi_1 */

            case 18:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5595; /* *avx512f_vpternlogv16si_1 */

            case 19:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5622; /* *avx512vl_vpternlogv8si_1 */

            case 20:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5649; /* *avx512vl_vpternlogv4si_1 */

            case 21:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5676; /* *avx512f_vpternlogv8di_1 */

            case 22:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5703; /* *avx512vl_vpternlogv4di_1 */

            case 23:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5730; /* *avx512vl_vpternlogv2di_1 */

            case 24:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5436; /* *avx512bw_vpternlogv64qi_1 */

            case 25:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5463; /* *avx512vl_vpternlogv32qi_1 */

            case 26:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5490; /* *avx512vl_vpternlogv16qi_1 */

            case 27:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5517; /* *avx512bw_vpternlogv32hi_1 */

            case 28:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5544; /* *avx512vl_vpternlogv16hi_1 */

            case 29:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5571; /* *avx512vl_vpternlogv8hi_1 */

            case 30:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5598; /* *avx512f_vpternlogv16si_1 */

            case 31:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5625; /* *avx512vl_vpternlogv8si_1 */

            case 32:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5652; /* *avx512vl_vpternlogv4si_1 */

            case 33:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5679; /* *avx512f_vpternlogv8di_1 */

            case 34:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5706; /* *avx512vl_vpternlogv4di_1 */

            case 35:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5733; /* *avx512vl_vpternlogv2di_1 */

            case 36:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6726; /* *avx512bw_vpternlogv64qi_3 */

            case 37:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6735; /* *avx512vl_vpternlogv32qi_3 */

            case 38:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6744; /* *avx512vl_vpternlogv16qi_3 */

            case 39:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6753; /* *avx512bw_vpternlogv32hi_3 */

            case 40:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6762; /* *avx512vl_vpternlogv16hi_3 */

            case 41:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6771; /* *avx512vl_vpternlogv8hi_3 */

            case 42:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6780; /* *avx512f_vpternlogv16si_3 */

            case 43:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6789; /* *avx512vl_vpternlogv8si_3 */

            case 44:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6798; /* *avx512vl_vpternlogv4si_3 */

            case 45:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6807; /* *avx512f_vpternlogv8di_3 */

            case 46:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6816; /* *avx512vl_vpternlogv4di_3 */

            case 47:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6825; /* *avx512vl_vpternlogv2di_3 */

            default:
              return -1;
            }

        case AND:
          switch (pattern535 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6078; /* *avx512bw_vpternlogv64qi_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6105; /* *avx512vl_vpternlogv32qi_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6132; /* *avx512vl_vpternlogv16qi_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6159; /* *avx512bw_vpternlogv32hi_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6186; /* *avx512vl_vpternlogv16hi_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6213; /* *avx512vl_vpternlogv8hi_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6240; /* *avx512f_vpternlogv16si_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6267; /* *avx512vl_vpternlogv8si_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6294; /* *avx512vl_vpternlogv4si_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6321; /* *avx512f_vpternlogv8di_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6348; /* *avx512vl_vpternlogv4di_2 */

            case 11:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6375; /* *avx512vl_vpternlogv2di_2 */

            default:
              return -1;
            }

        case IOR:
          switch (pattern535 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6081; /* *avx512bw_vpternlogv64qi_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6108; /* *avx512vl_vpternlogv32qi_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6135; /* *avx512vl_vpternlogv16qi_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6162; /* *avx512bw_vpternlogv32hi_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6189; /* *avx512vl_vpternlogv16hi_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6216; /* *avx512vl_vpternlogv8hi_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6243; /* *avx512f_vpternlogv16si_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6270; /* *avx512vl_vpternlogv8si_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6297; /* *avx512vl_vpternlogv4si_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6324; /* *avx512f_vpternlogv8di_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6351; /* *avx512vl_vpternlogv4di_2 */

            case 11:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6378; /* *avx512vl_vpternlogv2di_2 */

            default:
              return -1;
            }

        case XOR:
          switch (pattern535 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6084; /* *avx512bw_vpternlogv64qi_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6111; /* *avx512vl_vpternlogv32qi_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6138; /* *avx512vl_vpternlogv16qi_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6165; /* *avx512bw_vpternlogv32hi_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6192; /* *avx512vl_vpternlogv16hi_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6219; /* *avx512vl_vpternlogv8hi_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6246; /* *avx512f_vpternlogv16si_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6273; /* *avx512vl_vpternlogv8si_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6300; /* *avx512vl_vpternlogv4si_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6327; /* *avx512f_vpternlogv8di_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6354; /* *avx512vl_vpternlogv4di_2 */

            case 11:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6381; /* *avx512vl_vpternlogv2di_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case IOR:
      return recog_304 (x1, insn, pnum_clobbers);

    case XOR:
      return recog_303 (x1, insn, pnum_clobbers);

    default:
      return -1;
    }
}

 int
recog_318 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case UNSPEC:
      return recog_183 (x1, insn, pnum_clobbers);

    case VEC_MERGE:
      return recog_180 (x1, insn, pnum_clobbers);

    case PLUS:
      return recog_203 (x1, insn, pnum_clobbers);

    case MINUS:
      return recog_193 (x1, insn, pnum_clobbers);

    case VEC_DUPLICATE:
      return recog_178 (x1, insn, pnum_clobbers);

    case MULT:
      return recog_185 (x1, insn, pnum_clobbers);

    case DIV:
      return recog_202 (x1, insn, pnum_clobbers);

    case SQRT:
      return recog_197 (x1, insn, pnum_clobbers);

    case SMAX:
      return recog_195 (x1, insn, pnum_clobbers);

    case SMIN:
      return recog_196 (x1, insn, pnum_clobbers);

    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case REG:
    case SUBREG:
    case MEM:
      return recog_177 (x1, insn, pnum_clobbers);

    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
    case LTGT:
    case UNORDERED:
    case ORDERED:
    case UNEQ:
    case UNGE:
    case UNGT:
    case UNLE:
    case UNLT:
      operands[3] = x4;
      x5 = XEXP (x3, 2);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      x7 = XEXP (x4, 1);
      operands[2] = x7;
      x8 = XEXP (x3, 1);
      if (!rtx_equal_p (x8, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V4SFmode:
          if (pattern1002 (x3, 
E_V4SFmode) != 0
              || !
#line 4369 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 3249; /* sse_vmmaskcmpv4sf3 */

        case E_V2DFmode:
          if (pattern1002 (x3, 
E_V2DFmode) != 0
              || !(
#line 4369 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 3250; /* sse2_vmmaskcmpv2df3 */

        default:
          return -1;
        }

    case AND:
      return recog_190 (x1, insn, pnum_clobbers);

    case IOR:
      return recog_204 (x1, insn, pnum_clobbers);

    case XOR:
      return recog_194 (x1, insn, pnum_clobbers);

    case FMA:
      return recog_181 (x1, insn, pnum_clobbers);

    case FLOAT:
      return recog_199 (x1, insn, pnum_clobbers);

    case UNSIGNED_FLOAT:
      return recog_198 (x1, insn, pnum_clobbers);

    case FIX:
      return recog_201 (x1, insn, pnum_clobbers);

    case UNSIGNED_FIX:
      return recog_200 (x1, insn, pnum_clobbers);

    case FLOAT_EXTEND:
      return recog_188 (x1, insn, pnum_clobbers);

    case FLOAT_TRUNCATE:
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      x8 = XEXP (x3, 1);
      operands[2] = x8;
      x5 = XEXP (x3, 2);
      operands[3] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          if (pattern136 (x3, 
E_V8HFmode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8DFmode:
              if (!vector_operand (operands[1], E_V8DFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8116 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4672; /* avx512fp16_vcvtpd2ph_v8df_mask */

            case E_V8SFmode:
              if (!vector_operand (operands[1], E_V8SFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8116 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 4680; /* avx512fp16_vcvtps2ph_v8sf_mask */

            default:
              return -1;
            }

        case E_V16HFmode:
          if (pattern135 (x3, 
E_V16HFmode, 
E_HImode, 
E_V16SFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8116 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 4676; /* avx512fp16_vcvtps2ph_v16sf_mask */

        case E_V8SFmode:
          if (pattern135 (x3, 
E_V8SFmode, 
E_QImode, 
E_V8DFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 10073 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5083; /* avx512f_cvtpd2ps512_mask */

        case E_V4SFmode:
          if (pattern149 (x3, 
E_V4SFmode, 
E_V4DFmode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 10083 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512VL)))
            return -1;
          return 5086; /* avx_cvtpd2ps256_mask */

        case E_V16BFmode:
          if (pattern149 (x3, 
E_V16BFmode, 
E_V16SFmode, 
E_HImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 31425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 31353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 10276; /* avx512f_cvtneps2bf16_v16sf_mask */

        case E_V8BFmode:
          if (pattern149 (x3, 
E_V8BFmode, 
E_V8SFmode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 31425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 31353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10278; /* avx512f_cvtneps2bf16_v8sf_mask */

        default:
          return -1;
        }

    case VEC_SELECT:
      return recog_179 (x1, insn, pnum_clobbers);

    case SS_TRUNCATE:
      switch (pattern140 (x3))
        {
        case 0:
          if (!
#line 15121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7167; /* avx512f_ss_truncatev16siv16qi2_mask */

        case 1:
          if (!(
#line 15293 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 7203; /* avx512vl_ss_truncatev16hiv16qi2_mask */

        case 2:
          if (!
#line 15121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7170; /* avx512f_ss_truncatev16siv16hi2_mask */

        case 3:
          if (!
#line 15121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7173; /* avx512f_ss_truncatev8div8si2_mask */

        case 4:
          if (!
#line 15121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7176; /* avx512f_ss_truncatev8div8hi2_mask */

        case 5:
          if (!
#line 15293 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7200; /* avx512vl_ss_truncatev8siv8hi2_mask */

        case 6:
          if (!
#line 15193 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))
            return -1;
          return 7183; /* avx512bw_ss_truncatev32hiv32qi2_mask */

        case 7:
          if (!
#line 15293 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7197; /* avx512vl_ss_truncatev4div4si2_mask */

        default:
          return -1;
        }

    case TRUNCATE:
      return recog_189 (x1, insn, pnum_clobbers);

    case US_TRUNCATE:
      switch (pattern140 (x3))
        {
        case 0:
          if (!
#line 15121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7169; /* avx512f_us_truncatev16siv16qi2_mask */

        case 1:
          if (!(
#line 15293 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 7205; /* avx512vl_us_truncatev16hiv16qi2_mask */

        case 2:
          if (!
#line 15121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7172; /* avx512f_us_truncatev16siv16hi2_mask */

        case 3:
          if (!
#line 15121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7175; /* avx512f_us_truncatev8div8si2_mask */

        case 4:
          if (!
#line 15121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7178; /* avx512f_us_truncatev8div8hi2_mask */

        case 5:
          if (!
#line 15293 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7202; /* avx512vl_us_truncatev8siv8hi2_mask */

        case 6:
          if (!
#line 15193 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))
            return -1;
          return 7185; /* avx512bw_us_truncatev32hiv32qi2_mask */

        case 7:
          if (!
#line 15293 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7199; /* avx512vl_us_truncatev4div4si2_mask */

        default:
          return -1;
        }

    case SS_PLUS:
      switch (pattern141 (x3))
        {
        case 0:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (64 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (SS_PLUS, V64QImode, operands)) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
            return -1;
          return 7438; /* *avx512bw_ssaddv64qi3_mask */

        case 1:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (32 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (SS_PLUS, V32QImode, operands)) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))))
            return -1;
          return 7446; /* *avx2_ssaddv32qi3_mask */

        case 2:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (16 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (SS_PLUS, V16QImode, operands))))
            return -1;
          return 7454; /* *sse2_ssaddv16qi3_mask */

        case 3:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (64 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (SS_PLUS, V32HImode, operands)) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
            return -1;
          return 7462; /* *avx512bw_ssaddv32hi3_mask */

        case 4:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (32 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (SS_PLUS, V16HImode, operands)) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))))
            return -1;
          return 7470; /* *avx2_ssaddv16hi3_mask */

        case 5:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (16 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (SS_PLUS, V8HImode, operands))))
            return -1;
          return 7478; /* *sse2_ssaddv8hi3_mask */

        default:
          return -1;
        }

    case US_PLUS:
      switch (pattern141 (x3))
        {
        case 0:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (64 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (US_PLUS, V64QImode, operands)) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
            return -1;
          return 7440; /* *avx512bw_usaddv64qi3_mask */

        case 1:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (32 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (US_PLUS, V32QImode, operands)) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))))
            return -1;
          return 7448; /* *avx2_usaddv32qi3_mask */

        case 2:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (16 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (US_PLUS, V16QImode, operands))))
            return -1;
          return 7456; /* *sse2_usaddv16qi3_mask */

        case 3:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (64 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (US_PLUS, V32HImode, operands)) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
            return -1;
          return 7464; /* *avx512bw_usaddv32hi3_mask */

        case 4:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (32 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (US_PLUS, V16HImode, operands)) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))))
            return -1;
          return 7472; /* *avx2_usaddv16hi3_mask */

        case 5:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (16 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (US_PLUS, V8HImode, operands))))
            return -1;
          return 7480; /* *sse2_usaddv8hi3_mask */

        default:
          return -1;
        }

    case SS_MINUS:
      switch (pattern141 (x3))
        {
        case 0:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (64 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (SS_MINUS, V64QImode, operands)) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
            return -1;
          return 7442; /* *avx512bw_sssubv64qi3_mask */

        case 1:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (32 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (SS_MINUS, V32QImode, operands)) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))))
            return -1;
          return 7450; /* *avx2_sssubv32qi3_mask */

        case 2:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (16 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (SS_MINUS, V16QImode, operands))))
            return -1;
          return 7458; /* *sse2_sssubv16qi3_mask */

        case 3:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (64 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (SS_MINUS, V32HImode, operands)) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
            return -1;
          return 7466; /* *avx512bw_sssubv32hi3_mask */

        case 4:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (32 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (SS_MINUS, V16HImode, operands)) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))))
            return -1;
          return 7474; /* *avx2_sssubv16hi3_mask */

        case 5:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (16 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (SS_MINUS, V8HImode, operands))))
            return -1;
          return 7482; /* *sse2_sssubv8hi3_mask */

        default:
          return -1;
        }

    case US_MINUS:
      switch (pattern141 (x3))
        {
        case 0:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (64 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (US_MINUS, V64QImode, operands)) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
            return -1;
          return 7444; /* *avx512bw_ussubv64qi3_mask */

        case 1:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (32 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (US_MINUS, V32QImode, operands)) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))))
            return -1;
          return 7452; /* *avx2_ussubv32qi3_mask */

        case 2:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (16 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (US_MINUS, V16QImode, operands))))
            return -1;
          return 7460; /* *sse2_ussubv16qi3_mask */

        case 3:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (64 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (US_MINUS, V32HImode, operands)) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
            return -1;
          return 7468; /* *avx512bw_ussubv32hi3_mask */

        case 4:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (32 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (US_MINUS, V16HImode, operands)) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))))
            return -1;
          return 7476; /* *avx2_ussubv16hi3_mask */

        case 5:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (16 == 64 || TARGET_AVX512VL) && TARGET_AVX512BW
   && ix86_binary_operator_ok (US_MINUS, V8HImode, operands))))
            return -1;
          return 7484; /* *sse2_ussubv8hi3_mask */

        default:
          return -1;
        }

    case ASHIFTRT:
      return recog_184 (x1, insn, pnum_clobbers);

    case ASHIFT:
      return recog_187 (x1, insn, pnum_clobbers);

    case LSHIFTRT:
      return recog_186 (x1, insn, pnum_clobbers);

    case ROTATE:
      switch (pattern144 (x3))
        {
        case 0:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7638; /* avx512f_rolvv16si_mask */

        case 1:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7642; /* avx512vl_rolvv8si_mask */

        case 2:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7646; /* avx512vl_rolvv4si_mask */

        case 3:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7650; /* avx512f_rolvv8di_mask */

        case 4:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7654; /* avx512vl_rolvv4di_mask */

        case 5:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7658; /* avx512vl_rolvv2di_mask */

        case 6:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7662; /* avx512f_rolv16si_mask */

        case 7:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7666; /* avx512vl_rolv8si_mask */

        case 8:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7670; /* avx512vl_rolv4si_mask */

        case 9:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7674; /* avx512f_rolv8di_mask */

        case 10:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7678; /* avx512vl_rolv4di_mask */

        case 11:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7682; /* avx512vl_rolv2di_mask */

        default:
          return -1;
        }

    case ROTATERT:
      switch (pattern144 (x3))
        {
        case 0:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7640; /* avx512f_rorvv16si_mask */

        case 1:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7644; /* avx512vl_rorvv8si_mask */

        case 2:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7648; /* avx512vl_rorvv4si_mask */

        case 3:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7652; /* avx512f_rorvv8di_mask */

        case 4:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7656; /* avx512vl_rorvv4di_mask */

        case 5:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7660; /* avx512vl_rorvv2di_mask */

        case 6:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7664; /* avx512f_rorv16si_mask */

        case 7:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7668; /* avx512vl_rorv8si_mask */

        case 8:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7672; /* avx512vl_rorv4si_mask */

        case 9:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7676; /* avx512f_rorv8di_mask */

        case 10:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7680; /* avx512vl_rorv4di_mask */

        case 11:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7684; /* avx512vl_rorv2di_mask */

        default:
          return -1;
        }

    case UMAX:
      switch (pattern145 (x3))
        {
        case 0:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7702; /* *avx512f_umaxv16si3_mask */

        case 1:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7710; /* *avx512f_umaxv8si3_mask */

        case 2:
          if (nonimmediate_operand (operands[1], E_V4SImode)
              && nonimmediate_operand (operands[2], E_V4SImode)
              && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return 7718; /* *avx512f_umaxv4si3_mask */
          if (!vector_operand (operands[1], E_V4SImode)
              || !vector_operand (operands[2], E_V4SImode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && (16 == 64 || TARGET_AVX512VL)
   && !(MEM_P (operands[1]) && MEM_P (operands[2])))))
            return -1;
          return 7808; /* *sse4_1_umaxv4si3_mask */

        case 3:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7726; /* *avx512f_umaxv8di3_mask */

        case 4:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7734; /* *avx512f_umaxv4di3_mask */

        case 5:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7742; /* *avx512f_umaxv2di3_mask */

        case 6:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7750; /* *avx512bw_umaxv64qi3_mask */

        case 7:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7758; /* *avx512bw_umaxv16qi3_mask */

        case 8:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7766; /* *avx512bw_umaxv32qi3_mask */

        case 9:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7774; /* *avx512bw_umaxv32hi3_mask */

        case 10:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7782; /* *avx512bw_umaxv16hi3_mask */

        case 11:
          if (nonimmediate_operand (operands[1], E_V8HImode)
              && nonimmediate_operand (operands[2], E_V8HImode)
              && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return 7790; /* *avx512bw_umaxv8hi3_mask */
          if (!vector_operand (operands[1], E_V8HImode)
              || !vector_operand (operands[2], E_V8HImode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && (16 == 64 || TARGET_AVX512VL)
   && !(MEM_P (operands[1]) && MEM_P (operands[2])))))
            return -1;
          return 7804; /* *sse4_1_umaxv8hi3_mask */

        default:
          return -1;
        }

    case UMIN:
      switch (pattern145 (x3))
        {
        case 0:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7704; /* *avx512f_uminv16si3_mask */

        case 1:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7712; /* *avx512f_uminv8si3_mask */

        case 2:
          if (nonimmediate_operand (operands[1], E_V4SImode)
              && nonimmediate_operand (operands[2], E_V4SImode)
              && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return 7720; /* *avx512f_uminv4si3_mask */
          if (!vector_operand (operands[1], E_V4SImode)
              || !vector_operand (operands[2], E_V4SImode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && (16 == 64 || TARGET_AVX512VL)
   && !(MEM_P (operands[1]) && MEM_P (operands[2])))))
            return -1;
          return 7810; /* *sse4_1_uminv4si3_mask */

        case 3:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7728; /* *avx512f_uminv8di3_mask */

        case 4:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7736; /* *avx512f_uminv4di3_mask */

        case 5:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7744; /* *avx512f_uminv2di3_mask */

        case 6:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7752; /* *avx512bw_uminv64qi3_mask */

        case 7:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7760; /* *avx512bw_uminv16qi3_mask */

        case 8:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7768; /* *avx512bw_uminv32qi3_mask */

        case 9:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7776; /* *avx512bw_uminv32hi3_mask */

        case 10:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7784; /* *avx512bw_uminv16hi3_mask */

        case 11:
          if (nonimmediate_operand (operands[1], E_V8HImode)
              && nonimmediate_operand (operands[2], E_V8HImode)
              && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return 7792; /* *avx512bw_uminv8hi3_mask */
          if (!vector_operand (operands[1], E_V8HImode)
              || !vector_operand (operands[2], E_V8HImode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && (16 == 64 || TARGET_AVX512VL)
   && !(MEM_P (operands[1]) && MEM_P (operands[2])))))
            return -1;
          return 7806; /* *sse4_1_uminv8hi3_mask */

        default:
          return -1;
        }

    case VEC_CONCAT:
      return recog_182 (x1, insn, pnum_clobbers);

    case ABS:
      switch (pattern148 (x3))
        {
        case 0:
          if (!(
#line 23370 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8586; /* absv16si2_mask */

        case 1:
          if (!(
#line 23370 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8587; /* absv8si2_mask */

        case 2:
          if (!(
#line 23370 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8588; /* absv4si2_mask */

        case 3:
          if (!(
#line 23370 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8589; /* absv8di2_mask */

        case 4:
          if (!(
#line 23370 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8590; /* absv4di2_mask */

        case 5:
          if (!(
#line 23370 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8591; /* absv2di2_mask */

        case 6:
          if (!(
#line 23383 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8592; /* absv64qi2_mask */

        case 7:
          if (!(
#line 23383 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8593; /* absv16qi2_mask */

        case 8:
          if (!(
#line 23383 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8594; /* absv32qi2_mask */

        case 9:
          if (!(
#line 23383 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8595; /* absv32hi2_mask */

        case 10:
          if (!(
#line 23383 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8596; /* absv16hi2_mask */

        case 11:
          if (!(
#line 23383 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8597; /* absv8hi2_mask */

        default:
          return -1;
        }

    case SIGN_EXTEND:
      return recog_192 (x1, insn, pnum_clobbers);

    case ZERO_EXTEND:
      return recog_191 (x1, insn, pnum_clobbers);

    case CLZ:
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      x8 = XEXP (x3, 1);
      operands[2] = x8;
      x5 = XEXP (x3, 2);
      operands[3] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern146 (x3, 
E_V16SImode, 
E_HImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 9989; /* clzv16si2_mask */

        case E_V8SImode:
          if (pattern146 (x3, 
E_V8SImode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 9991; /* clzv8si2_mask */

        case E_V4SImode:
          if (pattern146 (x3, 
E_V4SImode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 9993; /* clzv4si2_mask */

        case E_V8DImode:
          if (pattern146 (x3, 
E_V8DImode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 9995; /* clzv8di2_mask */

        case E_V4DImode:
          if (pattern146 (x3, 
E_V4DImode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 9997; /* clzv4di2_mask */

        case E_V2DImode:
          if (pattern146 (x3, 
E_V2DImode, 
E_QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 9999; /* clzv2di2_mask */

        default:
          return -1;
        }

    case POPCOUNT:
      switch (pattern148 (x3))
        {
        case 0:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VPOPCNTDQ) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 10062; /* vpopcountv16si_mask */

        case 1:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VPOPCNTDQ) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10064; /* vpopcountv8si_mask */

        case 2:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VPOPCNTDQ) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10066; /* vpopcountv4si_mask */

        case 3:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VPOPCNTDQ) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 10068; /* vpopcountv8di_mask */

        case 4:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VPOPCNTDQ) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10070; /* vpopcountv4di_mask */

        case 5:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VPOPCNTDQ) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10072; /* vpopcountv2di_mask */

        case 6:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30578 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BITALG) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 10082; /* vpopcountv64qi_mask */

        case 7:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30578 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BITALG) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10084; /* vpopcountv16qi_mask */

        case 8:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30578 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BITALG) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10086; /* vpopcountv32qi_mask */

        case 9:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30578 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BITALG) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 10088; /* vpopcountv32hi_mask */

        case 10:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30578 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BITALG) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10090; /* vpopcountv16hi_mask */

        case 11:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30578 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BITALG) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10092; /* vpopcountv8hi_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_335 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
      switch (pattern50 (x3))
        {
        case 0:
          if (!
#line 14974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7151; /* *avx512f_truncatev16siv16qi2 */

        case 1:
          if (!(
#line 15236 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 7193; /* *avx512vl_truncatev16hiv16qi2 */

        case 2:
          if (!
#line 14974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7154; /* *avx512f_truncatev16siv16hi2 */

        case 3:
          if (!
#line 14974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7157; /* *avx512f_truncatev8div8si2 */

        case 4:
          if (!
#line 14974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7160; /* *avx512f_truncatev8div8hi2 */

        case 5:
          if (!
#line 15236 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7190; /* *avx512vl_truncatev8siv8hi2 */

        case 6:
          if (!
#line 15147 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))
            return -1;
          return 7180; /* avx512bw_truncatev32hiv32qi2 */

        case 7:
          if (!
#line 15236 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7187; /* *avx512vl_truncatev4div4si2 */

        default:
          return -1;
        }

    case LSHIFTRT:
      x5 = XEXP (x4, 1);
      if (GET_CODE (x5) != CONST_INT)
        return -1;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case MULT:
          if (XWINT (x5, 0) != 16L)
            return -1;
          x7 = XEXP (x6, 0);
          switch (GET_CODE (x7))
            {
            case SIGN_EXTEND:
              switch (pattern809 (x3, 
SIGN_EXTEND))
                {
                case 0:
                  if (!(
#line 16406 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1 && 1) && 
#line 652 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                    return -1;
                  return 7491; /* *smulv32hi3_highpart */

                case 1:
                  if (!(
#line 16406 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1 && 1) && 
#line 652 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                    return -1;
                  return 7495; /* *smulv16hi3_highpart */

                case 2:
                  if (!
#line 16406 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1 && 1))
                    return -1;
                  return 7499; /* *smulv8hi3_highpart */

                default:
                  return -1;
                }

            case ZERO_EXTEND:
              switch (pattern809 (x3, 
ZERO_EXTEND))
                {
                case 0:
                  if (!(
#line 16406 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1 && 1) && 
#line 652 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                    return -1;
                  return 7493; /* *umulv32hi3_highpart */

                case 1:
                  if (!(
#line 16406 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1 && 1) && 
#line 652 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                    return -1;
                  return 7497; /* *umulv16hi3_highpart */

                case 2:
                  if (!
#line 16406 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1 && 1))
                    return -1;
                  return 7501; /* *umulv8hi3_highpart */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case PLUS:
          if (XWINT (x5, 0) != 1L)
            return -1;
          x7 = XEXP (x6, 0);
          switch (GET_CODE (x7))
            {
            case PLUS:
              x8 = XEXP (x7, 0);
              if (GET_CODE (x8) != ZERO_EXTEND)
                return -1;
              x9 = XEXP (x7, 1);
              if (GET_CODE (x9) != ZERO_EXTEND)
                return -1;
              x10 = XEXP (x8, 0);
              operands[1] = x10;
              x11 = XEXP (x9, 0);
              operands[2] = x11;
              x12 = XEXP (x6, 1);
              operands[3] = x12;
              switch (GET_MODE (operands[0]))
                {
                case E_V64QImode:
                  if (pattern1404 (x3, 
E_V64HImode, 
E_V64QImode) != 0
                      || !(
#line 21889 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                    return -1;
                  return 8420; /* *avx512bw_uavgv64qi3 */

                case E_V32QImode:
                  if (pattern1404 (x3, 
E_V32HImode, 
E_V32QImode) != 0
                      || !(
#line 21889 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                    return -1;
                  return 8422; /* *avx2_uavgv32qi3 */

                case E_V16QImode:
                  if (pattern1404 (x3, 
E_V16HImode, 
E_V16QImode) != 0
                      || !
#line 21889 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8424; /* *sse2_uavgv16qi3 */

                case E_V32HImode:
                  if (pattern1404 (x3, 
E_V32SImode, 
E_V32HImode) != 0
                      || !(
#line 21889 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                    return -1;
                  return 8426; /* *avx512bw_uavgv32hi3 */

                case E_V16HImode:
                  if (pattern1404 (x3, 
E_V16SImode, 
E_V16HImode) != 0
                      || !(
#line 21889 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                    return -1;
                  return 8428; /* *avx2_uavgv16hi3 */

                case E_V8HImode:
                  if (pattern1404 (x3, 
E_V8SImode, 
E_V8HImode) != 0
                      || !
#line 21889 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8430; /* *sse2_uavgv8hi3 */

                default:
                  return -1;
                }

            case LSHIFTRT:
              if (pattern616 (x7) != 0)
                return -1;
              x8 = XEXP (x7, 0);
              x10 = XEXP (x8, 0);
              x13 = XEXP (x10, 0);
              operands[1] = x13;
              if (nonimmediate_operand (operands[1], E_V32HImode))
                {
                  res = recog_313 (x1, insn, pnum_clobbers);
                  if (res >= 0)
                    return res;
                }
              x14 = XEXP (x8, 1);
              x15 = XEXP (x14, 0);
              operands[2] = x15;
              x12 = XEXP (x6, 1);
              operands[3] = x12;
              switch (GET_MODE (operands[0]))
                {
                case E_V32HImode:
                  if (pattern1507 (x3, 
E_V32HImode, 
E_V32SImode) != 0
                      || !(
#line 22995 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3 && 1 && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 652 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                    return -1;
                  return 8543; /* *avx512bw_pmulhrswv32hi3 */

                case E_V16HImode:
                  if (pattern1507 (x3, 
E_V16HImode, 
E_V16SImode) != 0
                      || !(
#line 22995 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3 && 1 && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 652 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                    return -1;
                  return 8545; /* *avx2_pmulhrswv16hi3 */

                case E_V8HImode:
                  if (pattern1507 (x3, 
E_V8HImode, 
E_V8SImode) != 0
                      || !
#line 22995 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3 && 1 && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8547; /* *ssse3_pmulhrswv8hi3 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_345 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || GET_MODE (x3) != E_V8HFmode)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8DFmode:
          if (!vector_operand (operands[1], E_V8DFmode)
              || !(
#line 8116 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4670; /* avx512fp16_vcvtpd2ph_v8df */

        case E_V8SFmode:
          if (!vector_operand (operands[1], E_V8SFmode)
              || !(
#line 8116 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4678; /* avx512fp16_vcvtps2ph_v8sf */

        default:
          return -1;
        }

    case E_V16HFmode:
      if (!register_operand (operands[0], E_V16HFmode)
          || GET_MODE (x3) != E_V16HFmode
          || !vector_operand (operands[1], E_V16SFmode)
          || !(
#line 8116 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4674; /* avx512fp16_vcvtps2ph_v16sf */

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || GET_MODE (x3) != E_V8SFmode
          || !vector_operand (operands[1], E_V8DFmode)
          || !
#line 10073 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 5081; /* *avx512f_cvtpd2ps512 */

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x3) != E_V4SFmode
          || !nonimmediate_operand (operands[1], E_V4DFmode)
          || !
#line 10083 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1))
        return -1;
      return 5085; /* avx_cvtpd2ps256 */

    case E_V8BFmode:
      if (!register_operand (operands[0], E_V8BFmode)
          || GET_MODE (x3) != E_V8BFmode
          || !nonimmediate_operand (operands[1], E_V8SFmode))
        return -1;
      if (
#line 31387 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXNECONVERT || (TARGET_AVX512BF16 && TARGET_AVX512VL)))
        return 10274; /* vcvtneps2bf16_v8sf */
      if (!(
#line 31425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 31353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10277; /* avx512f_cvtneps2bf16_v8sf */

    case E_V16BFmode:
      if (!register_operand (operands[0], E_V16BFmode)
          || GET_MODE (x3) != E_V16BFmode
          || !nonimmediate_operand (operands[1], E_V16SFmode)
          || !(
#line 31425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 31353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10275; /* avx512f_cvtneps2bf16_v16sf */

    default:
      return -1;
    }
}

 int
recog_350 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  res = recog_269 (x1, insn, pnum_clobbers);
  if (res >= 0)
    return res;
  operands[1] = x3;
  operands[2] = x4;
  x5 = XEXP (x3, 1);
  operands[3] = x5;
  switch (GET_CODE (operands[1]))
    {
    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
      switch (GET_MODE (operands[0]))
        {
        case E_V16QImode:
          if (pattern798 (
E_V16QImode) == 0
              && 
#line 27271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return 8990; /* xop_maskcmpv16qi3 */
          break;

        case E_V8HImode:
          if (pattern798 (
E_V8HImode) == 0
              && 
#line 27271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return 8991; /* xop_maskcmpv8hi3 */
          break;

        case E_V4SImode:
          if (pattern798 (
E_V4SImode) == 0
              && 
#line 27271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return 8992; /* xop_maskcmpv4si3 */
          break;

        case E_V2DImode:
          if (pattern798 (
E_V2DImode) == 0
              && 
#line 27271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return 8993; /* xop_maskcmpv2di3 */
          break;

        default:
          break;
        }
      break;

    default:
      break;
    }
  switch (GET_CODE (operands[1]))
    {
    case NE:
    case EQ:
    case GEU:
    case GTU:
    case LEU:
    case LTU:
      switch (GET_MODE (operands[0]))
        {
        case E_V16QImode:
          if (pattern799 (
E_V16QImode) != 0
              || !
#line 27281 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8994; /* xop_maskcmp_unsv16qi3 */

        case E_V8HImode:
          if (pattern799 (
E_V8HImode) != 0
              || !
#line 27281 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8995; /* xop_maskcmp_unsv8hi3 */

        case E_V4SImode:
          if (pattern799 (
E_V4SImode) != 0
              || !
#line 27281 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8996; /* xop_maskcmp_unsv4si3 */

        case E_V2DImode:
          if (pattern799 (
E_V2DImode) != 0
              || !
#line 27281 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8997; /* xop_maskcmp_unsv2di3 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_357 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (pattern231 (x5, 
E_CCmode, 
17) != 0)
    return -1;
  x6 = XEXP (x3, 0);
  operands[1] = x6;
  res = recog_356 (x1, insn, pnum_clobbers);
  if (res >= 0)
    return res;
  if (XWINT (x4, 0) != 8L
      || pattern717 (x2) != 0)
    return -1;
  switch (pattern1406 (x2))
    {
    case 0:
      if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
        return -1;
      return 800; /* *andqi_exthi_3 */

    case 1:
      if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
        return -1;
      return 803; /* *andqi_extsi_3 */

    case 2:
      if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 806; /* *andqi_extdi_3 */

    case 3:
      if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
        return -1;
      return 801; /* *iorqi_exthi_3 */

    case 4:
      if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
        return -1;
      return 804; /* *iorqi_extsi_3 */

    case 5:
      if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 807; /* *iorqi_extdi_3 */

    case 6:
      if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
        return -1;
      return 802; /* *xorqi_exthi_3 */

    case 7:
      if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
        return -1;
      return 805; /* *xorqi_extsi_3 */

    case 8:
      if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 808; /* *xorqi_extdi_3 */

    default:
      return -1;
    }
}

 int
recog_362 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  switch (XINT (x3, 1))
    {
    case 106:
      if (pattern542 (x1) != 0)
        return -1;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      if (!register_operand (operands[0], E_DImode))
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      if (!pop_operand (operands[1], E_TImode))
        return -1;
      x6 = XVECEXP (x1, 0, 1);
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      if (!register_operand (operands[2], E_DImode)
          || !
#line 3913 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_PUSH2POP2))
        return -1;
      return 160; /* pop2_di */

    case 14:
      if (GET_MODE (x3) != E_SImode)
        return -1;
      x6 = XVECEXP (x1, 0, 1);
      if (pattern353 (x6) != 0)
        return -1;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      if (!register_operand (operands[0], E_SImode))
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      switch (GET_CODE (x5))
        {
        case CONST_INT:
          if (XWINT (x5, 0) != 0L
              || !
#line 20785 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return -1;
          return 1498; /* *set_got */

        case LABEL_REF:
          x8 = XEXP (x5, 0);
          operands[1] = x8;
          if (!
#line 20807 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return -1;
          return 1499; /* *set_got_labelled */

        default:
          return -1;
        }

    case 97:
      switch (pattern545 (x1))
        {
        case 0:
          if (!
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
            return -1;
          return 1550; /* tzcnt_si */

        case 1:
          if (!(((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)))
            return -1;
          return 1552; /* tzcnt_di */

        case 2:
          if (!(
#line 21750 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(true) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)))
            return -1;
          return 1563; /* tzcnt_hi */

        case 3:
          if ((
#line 21724 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)))
            return 1554; /* *tzcnt_si_falsedep_nf */
          if (pnum_clobbers == NULL
              || !
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
            return -1;
          *pnum_clobbers = 1;
          return 1558; /* *tzcnt_si_falsedep */

        case 4:
          if ((
#line 21724 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && ((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))))
            return 1556; /* *tzcnt_di_falsedep_nf */
          if (pnum_clobbers == NULL
              || !((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1560; /* *tzcnt_di_falsedep */

        default:
          return -1;
        }

    case 96:
      switch (pattern545 (x1))
        {
        case 0:
          if (!
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))
            return -1;
          return 1551; /* lzcnt_si */

        case 1:
          if (!(((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)))
            return -1;
          return 1553; /* lzcnt_di */

        case 2:
          if (!(
#line 21750 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(true) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)))
            return -1;
          return 1565; /* lzcnt_hi */

        case 3:
          if ((
#line 21724 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)))
            return 1555; /* *lzcnt_si_falsedep_nf */
          if (pnum_clobbers == NULL
              || !
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))
            return -1;
          *pnum_clobbers = 1;
          return 1559; /* *lzcnt_si_falsedep */

        case 4:
          if ((
#line 21724 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && ((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))))
            return 1557; /* *lzcnt_di_falsedep_nf */
          if (pnum_clobbers == NULL
              || !((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1561; /* *lzcnt_di_falsedep */

        default:
          return -1;
        }

    case 27:
      if (GET_MODE (x3) != E_CCmode
          || pattern680 (x1, 
CLOBBER, 
E_CCmode) != 0)
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      operands[0] = x5;
      if (!register_operand (operands[0], E_HImode))
        return -1;
      x6 = XVECEXP (x1, 0, 1);
      x7 = XEXP (x6, 0);
      if (!rtx_equal_p (x7, operands[0]))
        return -1;
      return 1647; /* parityhi2_cmp */

    case 80:
      if (pattern546 (x1, 
81) != 0
          || !
#line 24090 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
        return -1;
      return 1719; /* sincosxf3 */

    case 82:
      if (pattern546 (x1, 
83) != 0
          || !
#line 24605 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
        return -1;
      return 1724; /* fxtractxf3_i387 */

    case 70:
      if (GET_MODE (x3) != E_DImode)
        return -1;
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != CLOBBER)
        return -1;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      if (!nonimmediate_operand (operands[0], E_DImode))
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      if (!register_operand (operands[1], E_XFmode))
        return -1;
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      if (!scratch_operand (operands[2], E_XFmode)
          || !
#line 25151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387))
        return -1;
      return 1733; /* lrintxfdi2 */

    case 74:
      if (pattern547 (x1) != 0
          || !
#line 25250 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)
   && ix86_pre_reload_split ()))
        return -1;
      return 1736; /* frndintxf2_roundeven */

    case 75:
      if (pattern547 (x1) != 0
          || !
#line 25250 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)
   && ix86_pre_reload_split ()))
        return -1;
      return 1737; /* frndintxf2_floor */

    case 76:
      if (pattern547 (x1) != 0
          || !
#line 25250 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)
   && ix86_pre_reload_split ()))
        return -1;
      return 1738; /* frndintxf2_ceil */

    case 77:
      if (pattern547 (x1) != 0
          || !
#line 25250 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)
   && ix86_pre_reload_split ()))
        return -1;
      return 1739; /* frndintxf2_trunc */

    case 78:
      switch (pattern549 (x1))
        {
        case 0:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          return 1744; /* *fisthi2_floor_1 */

        case 1:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          return 1746; /* *fistsi2_floor_1 */

        case 2:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          return 1748; /* *fistdi2_floor_1 */

        default:
          return -1;
        }

    case 79:
      switch (pattern549 (x1))
        {
        case 0:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          return 1745; /* *fisthi2_ceil_1 */

        case 1:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          return 1747; /* *fistsi2_ceil_1 */

        case 2:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          return 1749; /* *fistdi2_ceil_1 */

        default:
          return -1;
        }

    case 18:
      if (pattern550 (x1) != 0)
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!memory_operand (operands[0], E_SImode)
              || GET_MODE (x3) != E_SImode
              || !const0_operand (operands[1], E_SImode)
              || !
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode))
            return -1;
          return 1861; /* probe_stack_1_si */

        case E_DImode:
          if (!memory_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode
              || !const0_operand (operands[1], E_DImode)
              || !
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode))
            return -1;
          return 1862; /* probe_stack_1_di */

        default:
          return -1;
        }

    case 92:
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != SET)
        return -1;
      if (pnum_clobbers != NULL)
        {
          res = recog_358 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
        }
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      x5 = XVECEXP (x3, 0, 0);
      operands[3] = x5;
      x7 = XEXP (x6, 0);
      operands[1] = x7;
      x9 = XEXP (x6, 1);
      operands[2] = x9;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          switch (pattern1218 (x3, 
E_SImode))
            {
            case 0:
              if (general_operand (operands[2], E_SImode)
                  && (
#line 27493 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode)))
                return 1871; /* *stack_protect_set_2_si_si */
              if (address_no_seg_operand (operands[2], E_SImode)
                  && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode))
                return 1875; /* *stack_protect_set_3_si_si */
              break;

            case 1:
              if (general_operand (operands[2], E_DImode)
                  && (
#line 27512 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && reload_completed) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode)))
                return 1873; /* *stack_protect_set_2_si_di */
              if (address_no_seg_operand (operands[2], E_DImode)
                  && ((
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1876; /* *stack_protect_set_3_si_di */
              break;

            default:
              break;
            }
          break;

        case E_DImode:
          switch (pattern1218 (x3, 
E_DImode))
            {
            case 0:
              if (general_operand (operands[2], E_SImode)
                  && (
#line 27493 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode)))
                return 1872; /* *stack_protect_set_2_di_si */
              if (address_no_seg_operand (operands[2], E_SImode)
                  && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode))
                return 1877; /* *stack_protect_set_3_di_si */
              break;

            case 1:
              if (general_operand (operands[2], E_DImode)
                  && (
#line 27512 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && reload_completed) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode)))
                return 1874; /* *stack_protect_set_2_di_di */
              if (address_no_seg_operand (operands[2], E_DImode)
                  && ((
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1878; /* *stack_protect_set_3_di_di */
              break;

            default:
              break;
            }
          break;

        default:
          break;
        }
      if (!register_operand (operands[1], E_DImode)
          || GET_MODE (x9) != E_DImode)
        return -1;
      switch (GET_CODE (x9))
        {
        case ZERO_EXTEND:
          switch (pattern1308 (x1))
            {
            case 0:
              if (!(
#line 27606 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && reload_completed) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode)))
                return -1;
              return 1879; /* *stack_protect_set_4z_si_di */

            case 1:
              if (!(
#line 27606 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && reload_completed) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode)))
                return -1;
              return 1880; /* *stack_protect_set_4z_di_di */

            default:
              return -1;
            }

        case SIGN_EXTEND:
          switch (pattern1308 (x1))
            {
            case 0:
              if (!(
#line 27624 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && reload_completed) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode)))
                return -1;
              return 1881; /* *stack_protect_set_4s_si_di */

            case 1:
              if (!(
#line 27624 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && reload_completed) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode)))
                return -1;
              return 1882; /* *stack_protect_set_4s_di_di */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 118:
      if (GET_MODE (x3) != E_V4SImode)
        return -1;
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != CLOBBER)
        return -1;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      if (!register_operand (operands[0], E_V4SImode))
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      if (!nonimmediate_operand (operands[1], E_DImode))
        return -1;
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      if (!scratch_operand (operands[2], E_V4SImode)
          || !
#line 1881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!TARGET_64BIT && TARGET_SSE2 && TARGET_INTER_UNIT_MOVES_TO_VEC))
        return -1;
      return 2558; /* movdi_to_sse */

    case 282:
      if (GET_MODE (x3) != E_BLKmode
          || pattern340 (x1) != 0)
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      if (!rtx_equal_p (x5, operands[0]))
        return -1;
      return 10907; /* mfence_nosse */

    case 287:
      if (pnum_clobbers == NULL
          || GET_MODE (x3) != E_DImode)
        return -1;
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != CLOBBER)
        return -1;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      if (!nonimmediate_operand (operands[0], E_DImode))
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      if (!memory_operand (operands[1], E_DImode))
        return -1;
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      if (!memory_operand (operands[2], E_DImode)
          || !
#line 196 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(!TARGET_64BIT && (TARGET_80387 || TARGET_SSE)))
        return -1;
      *pnum_clobbers = 1;
      return 10908; /* atomic_loaddi_fpu */

    case 288:
      if (pnum_clobbers == NULL
          || GET_MODE (x3) != E_DImode)
        return -1;
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != CLOBBER)
        return -1;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      if (!memory_operand (operands[0], E_DImode))
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      if (!nonimmediate_operand (operands[1], E_DImode))
        return -1;
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      if (!memory_operand (operands[2], E_DImode)
          || !
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(!TARGET_64BIT && (TARGET_80387 || TARGET_SSE)))
        return -1;
      *pnum_clobbers = 1;
      return 10913; /* atomic_storedi_fpu */

    default:
      return -1;
    }
}

 int
recog_372 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  switch (pattern558 (x1))
    {
    case 0:
      x2 = XVECEXP (x1, 0, 1);
      x3 = XEXP (x2, 0);
      if (GET_CODE (x3) != REG
          || REGNO (x3) != 17
          || GET_MODE (x3) != E_CCmode)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (!nonimmediate_operand (operands[0], E_DImode))
            return -1;
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (GET_MODE (x5) != E_DImode
              || !nonimmediate_operand (operands[1], E_DImode))
            return -1;
          if (x86_64_hilo_general_operand (operands[2], E_DImode)
              && (
#line 6477 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return 266; /* *adddi3_doubleword */
          if (!x86_64_general_operand (operands[2], E_DImode)
              || !(
#line 6627 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)
  && true) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 285; /* *adddi_1 */

        case E_TImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern564 (x5, 
E_TImode) != 0
              || !(
#line 6477 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 267; /* *addti3_doubleword */

        case E_SImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern566 (x5) != 0
              || !
#line 6627 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)
  && true))
            return -1;
          return 283; /* *addsi_1 */

        case E_HImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern565 (x5, 
E_HImode) != 0
              || !
#line 6825 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
  && true))
            return -1;
          return 298; /* *addhi_1 */

        case E_QImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern565 (x5, 
E_QImode) != 0
              || !
#line 6882 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
  && true))
            return -1;
          return 300; /* *addqi_1 */

        case E_V2QImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern568 (x5, 
E_V2QImode) != 0
              || !
#line 3246 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_PARTIAL_REG_STALL || optimize_size || TARGET_SSE2))
            return -1;
          return 2136; /* addv2qi3 */

        default:
          return -1;
        }

    case 1:
      x2 = XVECEXP (x1, 0, 1);
      if (XVECLEN (x2, 0) != 1)
        return -1;
      x6 = XVECEXP (x2, 0, 0);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      switch (XINT (x2, 1))
        {
        case 110:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern212 (x5, 
E_V2SFmode) != 0
              || !
#line 746 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW && ix86_binary_operator_ok (PLUS, V2SFmode, operands)))
            return -1;
          return 2052; /* *mmx_addv2sf3 */

        case 174:
          switch (GET_MODE (operands[0]))
            {
            case E_QImode:
              x4 = XVECEXP (x1, 0, 0);
              x5 = XEXP (x4, 1);
              if (pattern568 (x5, 
E_QImode) != 0
                  || !(
#line 2256 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2082 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
                return -1;
              return 2597; /* kaddqi */

            case E_HImode:
              x4 = XVECEXP (x1, 0, 0);
              x5 = XEXP (x4, 1);
              if (pattern568 (x5, 
E_HImode) != 0
                  || !(
#line 2256 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2082 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
                return -1;
              return 2598; /* kaddhi */

            case E_SImode:
              x4 = XVECEXP (x1, 0, 0);
              x5 = XEXP (x4, 1);
              if (pattern568 (x5, 
E_SImode) != 0
                  || !(
#line 2256 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2083 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                return -1;
              return 2599; /* kaddsi */

            case E_DImode:
              x4 = XVECEXP (x1, 0, 0);
              x5 = XEXP (x4, 1);
              if (pattern568 (x5, 
E_DImode) != 0
                  || !(
#line 2256 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2083 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                return -1;
              return 2600; /* kadddi */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 2:
      if (!
#line 6958 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      return 301; /* *addqi_1_slp */

    case 3:
      if (!
#line 6958 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      return 302; /* *addhi_1_slp */

    default:
      return -1;
    }
}

 int
recog_379 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  if (pattern582 (x1, 
PLUS, 
E_CCZmode) != 0)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_CCZmode)
    return -1;
  x4 = XEXP (x3, 0);
  x5 = XVECEXP (x4, 0, 0);
  operands[0] = x5;
  x6 = XVECEXP (x4, 0, 1);
  operands[3] = x6;
  if (!const_int_operand (operands[3], E_SImode))
    return -1;
  x7 = XVECEXP (x1, 0, 1);
  x8 = XEXP (x7, 1);
  x9 = XEXP (x8, 1);
  operands[1] = x9;
  x10 = XEXP (x8, 0);
  if (!rtx_equal_p (x10, operands[0]))
    return -1;
  x11 = XEXP (x7, 0);
  if (!rtx_equal_p (x11, operands[0]))
    return -1;
  switch (GET_MODE (x4))
    {
    case E_QImode:
      if (pattern1737 (x8, 
E_QImode) != 0
          || !
#line 778 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
((unsigned HOST_WIDE_INT) INTVAL (operands[1])
   == -(unsigned HOST_WIDE_INT) INTVAL (operands[2])))
        return -1;
      return 10928; /* *atomic_fetch_add_cmpqi */

    case E_HImode:
      if (pattern1737 (x8, 
E_HImode) != 0
          || !
#line 778 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
((unsigned HOST_WIDE_INT) INTVAL (operands[1])
   == -(unsigned HOST_WIDE_INT) INTVAL (operands[2])))
        return -1;
      return 10929; /* *atomic_fetch_add_cmphi */

    case E_SImode:
      if (pattern1737 (x8, 
E_SImode) != 0
          || !
#line 778 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
((unsigned HOST_WIDE_INT) INTVAL (operands[1])
   == -(unsigned HOST_WIDE_INT) INTVAL (operands[2])))
        return -1;
      return 10930; /* *atomic_fetch_add_cmpsi */

    case E_DImode:
      if (pattern1737 (x8, 
E_DImode) != 0
          || !(
#line 778 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
((unsigned HOST_WIDE_INT) INTVAL (operands[1])
   == -(unsigned HOST_WIDE_INT) INTVAL (operands[2])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 10931; /* *atomic_fetch_add_cmpdi */

    default:
      return -1;
    }
}

 int
recog_382 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x3, 0);
  x6 = XEXP (x5, 0);
  switch (GET_CODE (x6))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x6;
      res = recog_378 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      if (GET_CODE (x6) != SUBREG)
        return -1;
      switch (pattern814 (x1))
        {
        case 0:
          if (!
#line 13151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)))
            return -1;
          return 782; /* *andqi_exthi_1_cc */

        case 1:
          if (!
#line 13151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)))
            return -1;
          return 785; /* *andqi_extsi_1_cc */

        case 2:
          if (!(
#line 13151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 788; /* *andqi_extdi_1_cc */

        default:
          return -1;
        }

    case NOT:
      x7 = XEXP (x2, 0);
      if (GET_CODE (x7) != REG
          || REGNO (x7) != 17)
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x8) != CLOBBER)
        return -1;
      x9 = XEXP (x6, 0);
      operands[1] = x9;
      x10 = XEXP (x5, 1);
      operands[2] = x10;
      x11 = XEXP (x8, 0);
      operands[0] = x11;
      switch (GET_MODE (x5))
        {
        case E_SImode:
          if (pattern1415 (x6, 
E_SImode) != 0
              || !
#line 13400 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_match_ccmode (insn, CCNOmode)))
            return -1;
          return 817; /* *andn_si_ccno */

        case E_DImode:
          if (pattern1415 (x6, 
E_DImode) != 0
              || !(
#line 13400 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_match_ccmode (insn, CCNOmode)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 818; /* *andn_di_ccno */

        default:
          return -1;
        }

    case NEG:
      x7 = XEXP (x2, 0);
      if (GET_CODE (x7) != REG
          || REGNO (x7) != 17)
        return -1;
      x9 = XEXP (x6, 0);
      operands[1] = x9;
      x10 = XEXP (x5, 1);
      if (!rtx_equal_p (x10, operands[1]))
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x8))
        {
        case SET:
          x12 = XEXP (x8, 1);
          if (GET_CODE (x12) != AND)
            return -1;
          x13 = XEXP (x12, 0);
          if (GET_CODE (x13) != NEG)
            return -1;
          x11 = XEXP (x8, 0);
          operands[0] = x11;
          switch (pattern1478 (x1))
            {
            case 0:
              if (!
#line 21822 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_match_ccmode (insn, CCNOmode)))
                return -1;
              return 1572; /* *bmi_blsi_si_cmp */

            case 1:
              if (!(
#line 21822 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_match_ccmode (insn, CCNOmode)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1573; /* *bmi_blsi_di_cmp */

            default:
              return -1;
            }

        case CLOBBER:
          switch (pattern1221 (x1))
            {
            case 0:
              if (!
#line 21881 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_match_ccmode (insn, CCNOmode)))
                return -1;
              return 1576; /* *bmi_blsi_si_ccno */

            case 1:
              if (!(
#line 21881 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_match_ccmode (insn, CCNOmode)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1577; /* *bmi_blsi_di_ccno */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case PLUS:
      x14 = XEXP (x6, 1);
      if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + -1]
          || pattern813 (x2, 
E_CCZmode) != 0)
        return -1;
      x9 = XEXP (x6, 0);
      operands[1] = x9;
      x10 = XEXP (x5, 1);
      if (!rtx_equal_p (x10, operands[1]))
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x8))
        {
        case SET:
          x12 = XEXP (x8, 1);
          if (GET_CODE (x12) != AND)
            return -1;
          x13 = XEXP (x12, 0);
          if (GET_CODE (x13) != PLUS)
            return -1;
          x15 = XEXP (x13, 1);
          if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + -1])
            return -1;
          x11 = XEXP (x8, 0);
          operands[0] = x11;
          switch (pattern1478 (x1))
            {
            case 0:
              if (!
#line 21974 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
                return -1;
              return 1584; /* *bmi_blsr_si_cmp */

            case 1:
              if (!(
#line 21974 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1585; /* *bmi_blsr_di_cmp */

            default:
              return -1;
            }

        case CLOBBER:
          switch (pattern1221 (x1))
            {
            case 0:
              if (!
#line 22031 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
                return -1;
              return 1588; /* *bmi_blsr_si_ccz */

            case 1:
              if (!(
#line 22031 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1589; /* *bmi_blsr_di_ccz */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSPEC_VOLATILE:
      switch (pattern365 (x1, 
AND))
        {
        case 0:
          return 10981; /* atomic_and_fetch_cmp_0qi_1 */

        case 1:
          return 10984; /* atomic_and_fetch_cmp_0hi_1 */

        case 2:
          return 10987; /* atomic_and_fetch_cmp_0si_1 */

        case 3:
          if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 10990; /* atomic_and_fetch_cmp_0di_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_387 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  switch (GET_CODE (x4))
    {
    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case MEM:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      operands[2] = x4;
      res = recog_386 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      if (GET_CODE (x4) != SUBREG
          || pattern815 (x4) != 0)
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (pattern231 (x5, 
E_CCmode, 
17) != 0
          || GET_MODE (x3) != E_QImode
          || !nonimmediate_operand (operands[1], E_QImode))
        return -1;
      x6 = XEXP (x4, 0);
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return -1;
      x8 = XEXP (x2, 0);
      switch (GET_CODE (x8))
        {
        case STRICT_LOW_PART:
          x9 = XEXP (x8, 0);
          operands[0] = x9;
          if (!register_operand (operands[0], E_QImode))
            return -1;
          switch (pattern1783 ())
            {
            case 0:
              if (!
#line 8227 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              return 405; /* *subqi_exthi_1_slp */

            case 1:
              if (!
#line 8227 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              return 406; /* *subqi_extsi_1_slp */

            case 2:
              if (!(
#line 8227 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 407; /* *subqi_extdi_1_slp */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          operands[0] = x8;
          if (!nonimmediate_operand (operands[0], E_QImode))
            return -1;
          switch (pattern1783 ())
            {
            case 0:
              return 416; /* *subqi_exthi_0 */

            case 1:
              return 417; /* *subqi_extsi_0 */

            case 2:
              if (!
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 418; /* *subqi_extdi_0 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case ZERO_EXTEND:
      x5 = XVECEXP (x1, 0, 1);
      if (pattern374 (x5) != 0)
        return -1;
      switch (pattern1150 (x2))
        {
        case 0:
          if (!(
#line 8115 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (UNKNOWN, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 382; /* *subdi3_doubleword_zext */

        case 1:
          if (!(
#line 8115 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (UNKNOWN, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 383; /* *subti3_doubleword_zext */

        default:
          return -1;
        }

    case LTU:
    case UNLT:
      switch (pattern686 (x1))
        {
        case 0:
          if (pattern1546 (x3, 
E_QImode) != 0
              || !
#line 9361 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 491; /* *subqi3_carry_0 */

        case 1:
          if (pattern1546 (x3, 
E_HImode) != 0
              || !
#line 9361 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 492; /* *subhi3_carry_0 */

        case 2:
          if (pattern1546 (x3, 
E_SImode) != 0
              || !
#line 9361 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 493; /* *subsi3_carry_0 */

        case 3:
          if (pattern1546 (x3, 
E_DImode) != 0
              || !(
#line 9361 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 494; /* *subdi3_carry_0 */

        default:
          return -1;
        }

    case GE:
    case GEU:
      switch (pattern686 (x1))
        {
        case 0:
          if (pattern1547 (x3, 
E_QImode) != 0
              || !
#line 9375 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 495; /* *subqi3_carry_0r */

        case 1:
          if (pattern1547 (x3, 
E_HImode) != 0
              || !
#line 9375 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 496; /* *subhi3_carry_0r */

        case 2:
          if (pattern1547 (x3, 
E_SImode) != 0
              || !
#line 9375 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 497; /* *subsi3_carry_0r */

        case 3:
          if (pattern1547 (x3, 
E_DImode) != 0
              || !(
#line 9375 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 498; /* *subdi3_carry_0r */

        default:
          return -1;
        }

    case EQ:
      switch (pattern690 (x1))
        {
        case 0:
          if (!
#line 10319 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, QImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 582; /* *subqi3_eq_0 */

        case 1:
          if (!
#line 10319 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, HImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 583; /* *subhi3_eq_0 */

        case 2:
          if (!
#line 10319 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, SImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 584; /* *subsi3_eq_0 */

        case 3:
          if (!(
#line 10319 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, DImode, operands)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 585; /* *subdi3_eq_0 */

        default:
          return -1;
        }

    case NE:
      switch (pattern690 (x1))
        {
        case 0:
          if (!
#line 10340 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, QImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 586; /* *subqi3_ne_0 */

        case 1:
          if (!
#line 10340 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, HImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 587; /* *subhi3_ne_0 */

        case 2:
          if (!
#line 10340 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, SImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 588; /* *subsi3_ne_0 */

        case 3:
          if (!(
#line 10340 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, DImode, operands)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 589; /* *subdi3_ne_0 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_393 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case ASHIFT:
      return recog_392 (x1, insn, pnum_clobbers);

    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      switch (pattern570 (x1))
        {
        case 0:
          if (
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return 726; /* *iorqi_1_slp */
          break;

        case 1:
          if (
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return 729; /* *iorhi_1_slp */
          break;

        case 2:
          if (x86_64_hilo_general_operand (operands[2], E_DImode)
              && (
#line 13541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (IOR, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return 819; /* *iordi3_doubleword */
          if (x86_64_general_operand (operands[2], E_DImode)
              && (
#line 13599 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (IOR, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 832; /* *iordi_1 */
          if (const_int_operand (operands[2], E_DImode)
              && 
#line 13647 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_USE_BT
   && ix86_binary_operator_ok (IOR, DImode, operands)
   && IN_RANGE (exact_log2 (INTVAL (operands[2])), 31, 63)))
            return 838; /* *iordi_1_bts */
          break;

        case 3:
          if ((
#line 13541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (IOR, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 821; /* *iorti3_doubleword */
          break;

        case 4:
          if (
#line 13599 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (IOR, HImode, operands, TARGET_APX_NDD)
   && true))
            return 824; /* *iorhi_1 */
          break;

        case 5:
          if (
#line 13599 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (IOR, SImode, operands, TARGET_APX_NDD)
   && true))
            return 828; /* *iorsi_1 */
          break;

        case 6:
          if (
#line 4718 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (IOR, V4QImode, operands)))
            return 2284; /* *iorv4qi3 */
          break;

        case 7:
          if (
#line 4718 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (IOR, V2QImode, operands)))
            return 2287; /* *iorv2qi3 */
          break;

        case 8:
          if (
#line 4718 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (IOR, V2HImode, operands)))
            return 2290; /* *iorv2hi3 */
          break;

        case 9:
          if (
#line 2097 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return 2573; /* kiorqi */
          break;

        case 10:
          if (
#line 2097 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return 2576; /* kiorhi */
          break;

        case 11:
          if ((
#line 2097 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return 2579; /* kiorsi */
          break;

        case 12:
          if ((
#line 2097 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return 2582; /* kiordi */
          break;

        default:
          break;
        }
      x5 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x5) != CLOBBER
          || pattern571 (x1) != 0)
        return -1;
      if (GET_CODE (x4) == SUBREG
          && pattern559 (x4) == 0)
        {
          x6 = XEXP (x4, 0);
          x7 = XEXP (x6, 0);
          operands[2] = x7;
          switch (pattern1607 (x2))
            {
            case 0:
              if (
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return 732; /* *iorqi_exthi_1_slp */
              break;

            case 1:
              if (
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return 735; /* *iorqi_extsi_1_slp */
              break;

            case 2:
              if ((
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 738; /* *iorqi_extdi_1_slp */
              break;

            case 3:
              return 756; /* *iorqi_exthi_0 */

            case 4:
              return 759; /* *iorqi_extsi_0 */

            case 5:
              if (
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return 762; /* *iorqi_extdi_0 */
              break;

            default:
              break;
            }
          x8 = XEXP (x3, 1);
          if (GET_CODE (x8) == SUBREG)
            {
              switch (pattern1608 (x2))
                {
                case 0:
                  if (
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    return 741; /* *iorqi_exthi_2_slp */
                  break;

                case 1:
                  if (
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    return 744; /* *iorqi_extsi_2_slp */
                  break;

                case 2:
                  if ((
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 747; /* *iorqi_extdi_2_slp */
                  break;

                case 3:
                  return 765; /* *iorqi_ext2hi_0 */

                case 4:
                  return 768; /* *iorqi_ext2si_0 */

                case 5:
                  if (
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return 771; /* *iorqi_ext2di_0 */
                  break;

                default:
                  break;
                }
            }
        }
      x9 = XEXP (x2, 0);
      operands[0] = x9;
      if (!nonimmediate_operand (operands[0], E_QImode))
        return -1;
      operands[1] = x4;
      if (!nonimmediate_operand (operands[1], E_QImode))
        return -1;
      x8 = XEXP (x3, 1);
      operands[2] = x8;
      if (!general_operand (operands[2], E_QImode)
          || !
#line 13789 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (IOR, QImode, operands, TARGET_APX_NDD)
   && true))
        return -1;
      return 868; /* *iorqi_1 */

    case ZERO_EXTEND:
      if (pattern370 (x1) != 0
          || !
#line 13776 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (IOR, SImode, operands, TARGET_APX_NDD)))
        return -1;
      return 865; /* *iorsi_1_zext_imm */

    case LSHIFTRT:
      if (pattern340 (x1) != 0)
        return -1;
      switch (pattern1040 (x3, 
ASHIFT))
        {
        case 0:
          x8 = XEXP (x3, 1);
          x10 = XEXP (x8, 0);
          x11 = XEXP (x10, 0);
          x12 = XEXP (x11, 0);
          operands[1] = x12;
          if (nonimmediate_operand (operands[0], E_DImode))
            {
              x13 = XEXP (x4, 1);
              x14 = XEXP (x13, 0);
              operands[2] = x14;
              x6 = XEXP (x4, 0);
              if (rtx_equal_p (x6, operands[0]))
                {
                  x15 = XEXP (x10, 1);
                  x16 = XEXP (x15, 1);
                  x17 = XEXP (x16, 0);
                  if (rtx_equal_p (x17, operands[2])
                      && 
#line 16800 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && true))
                    return 1143; /* x86_64_shrd */
                }
            }
          operands[2] = x12;
          if (!register_operand (operands[0], E_DImode))
            return -1;
          x6 = XEXP (x4, 0);
          operands[1] = x6;
          if (!nonimmediate_operand (operands[1], E_DImode))
            return -1;
          x13 = XEXP (x4, 1);
          x14 = XEXP (x13, 0);
          operands[3] = x14;
          x15 = XEXP (x10, 1);
          x16 = XEXP (x15, 1);
          x17 = XEXP (x16, 0);
          if (!rtx_equal_p (x17, operands[3])
              || !
#line 16821 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1145; /* x86_64_shrd_ndd */

        case 1:
          if (pattern1039 (x3, 
E_SImode, 
E_DImode) != 0)
            return -1;
          x8 = XEXP (x3, 1);
          x10 = XEXP (x8, 0);
          x11 = XEXP (x10, 0);
          x12 = XEXP (x11, 0);
          operands[1] = x12;
          if (nonimmediate_operand (operands[0], E_SImode))
            {
              x13 = XEXP (x4, 1);
              x14 = XEXP (x13, 0);
              operands[2] = x14;
              x6 = XEXP (x4, 0);
              if (rtx_equal_p (x6, operands[0]))
                {
                  x15 = XEXP (x10, 1);
                  x16 = XEXP (x15, 1);
                  x17 = XEXP (x16, 0);
                  if (rtx_equal_p (x17, operands[2]))
                    return 1155; /* x86_shrd */
                }
            }
          operands[2] = x12;
          if (!register_operand (operands[0], E_SImode))
            return -1;
          x6 = XEXP (x4, 0);
          operands[1] = x6;
          if (!nonimmediate_operand (operands[1], E_SImode))
            return -1;
          x13 = XEXP (x4, 1);
          x14 = XEXP (x13, 0);
          operands[3] = x14;
          x15 = XEXP (x10, 1);
          x16 = XEXP (x15, 1);
          x17 = XEXP (x16, 0);
          if (!rtx_equal_p (x17, operands[3])
              || !
#line 17052 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1157; /* x86_shrd_ndd */

        case 2:
          x8 = XEXP (x3, 1);
          switch (GET_CODE (x8))
            {
            case SUBREG:
              switch (pattern1224 (x3, 
ASHIFT))
                {
                case 0:
                  x13 = XEXP (x4, 1);
                  operands[2] = x13;
                  if (pattern1661 (x3) == 0
                      && 
#line 16836 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && true))
                    return 1147; /* x86_64_shrd_1 */
                  operands[3] = x13;
                  if (pattern1662 (x3) != 0
                      || !
#line 16858 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && INTVAL (operands[4]) == 64 - INTVAL (operands[3])
   && true))
                    return -1;
                  return 1149; /* x86_64_shrd_ndd_1 */

                case 1:
                  x13 = XEXP (x4, 1);
                  operands[2] = x13;
                  if (pattern1663 (x3) == 0
                      && 
#line 17067 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
   && true))
                    return 1159; /* x86_shrd_1 */
                  operands[3] = x13;
                  if (pattern1664 (x3) != 0
                      || !
#line 17089 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && (INTVAL (operands[4]) == 32 - INTVAL (operands[3]))
   && true))
                    return -1;
                  return 1161; /* x86_shrd_ndd_1 */

                default:
                  return -1;
                }

            case ASHIFT:
              switch (pattern1226 (x3))
                {
                case 0:
                  if (!
#line 16930 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return -1;
                  return 1151; /* *x86_64_shrd_shld_1_nozext */

                case 1:
                  if (!
#line 17161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return -1;
                  return 1163; /* *x86_shrd_shld_1_nozext */

                case 2:
                  x10 = XEXP (x8, 0);
                  operands[1] = x10;
                  if (nonimmediate_operand (operands[0], E_DImode))
                    {
                      x13 = XEXP (x4, 1);
                      operands[2] = x13;
                      x6 = XEXP (x4, 0);
                      if (rtx_equal_p (x6, operands[0]))
                        {
                          x18 = XEXP (x8, 1);
                          x19 = XEXP (x18, 1);
                          if (rtx_equal_p (x19, operands[2])
                              && 
#line 16983 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()))
                            return 1152; /* *x86_64_shrd_2 */
                        }
                    }
                  operands[2] = x10;
                  if (!register_operand (operands[0], E_DImode))
                    return -1;
                  x6 = XEXP (x4, 0);
                  operands[1] = x6;
                  if (!nonimmediate_operand (operands[1], E_DImode))
                    return -1;
                  x13 = XEXP (x4, 1);
                  operands[3] = x13;
                  x18 = XEXP (x8, 1);
                  x19 = XEXP (x18, 1);
                  if (!rtx_equal_p (x19, operands[2])
                      || !
#line 17004 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
  && ix86_pre_reload_split ()))
                    return -1;
                  return 1153; /* *x86_64_shrd_ndd_2 */

                case 3:
                  x10 = XEXP (x8, 0);
                  operands[1] = x10;
                  if (nonimmediate_operand (operands[0], E_SImode))
                    {
                      x13 = XEXP (x4, 1);
                      operands[2] = x13;
                      x6 = XEXP (x4, 0);
                      if (rtx_equal_p (x6, operands[0]))
                        {
                          x18 = XEXP (x8, 1);
                          x19 = XEXP (x18, 1);
                          if (rtx_equal_p (x19, operands[2])
                              && 
#line 17213 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()))
                            return 1164; /* *x86_shrd_2 */
                        }
                    }
                  operands[2] = x10;
                  if (!register_operand (operands[0], E_SImode))
                    return -1;
                  x6 = XEXP (x4, 0);
                  operands[1] = x6;
                  if (!nonimmediate_operand (operands[1], E_SImode))
                    return -1;
                  x13 = XEXP (x4, 1);
                  operands[3] = x13;
                  x18 = XEXP (x8, 1);
                  x19 = XEXP (x18, 1);
                  if (!rtx_equal_p (x19, operands[3])
                      || !
#line 17234 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && ix86_pre_reload_split ()))
                    return -1;
                  return 1165; /* *x86_shrd_ndd_2 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case NOT:
      x6 = XEXP (x4, 0);
      if (GET_CODE (x6) != PLUS)
        return -1;
      x20 = XEXP (x6, 1);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
          || pattern340 (x1) != 0)
        return -1;
      x7 = XEXP (x6, 0);
      operands[1] = x7;
      x8 = XEXP (x3, 1);
      if (!rtx_equal_p (x8, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x3) != E_SImode
              || GET_MODE (x4) != E_SImode
              || GET_MODE (x6) != E_SImode
              || !nonimmediate_operand (operands[1], E_SImode)
              || !
#line 22214 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
            return -1;
          return 1608; /* *tbm_blci_si */

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode
              || GET_MODE (x4) != E_DImode
              || GET_MODE (x6) != E_DImode
              || !nonimmediate_operand (operands[1], E_DImode)
              || !(
#line 22214 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1609; /* *tbm_blci_di */

        default:
          return -1;
        }

    case PLUS:
      x13 = XEXP (x4, 1);
      if (GET_CODE (x13) != CONST_INT
          || pattern347 (x1) != 0)
        return -1;
      switch (XWINT (x13, 0))
        {
        case 1L:
          switch (pattern1316 (x3))
            {
            case 0:
              if (!
#line 22254 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
                return -1;
              return 1614; /* *tbm_blcs_si */

            case 1:
              if (!(
#line 22254 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1615; /* *tbm_blcs_di */

            case 2:
              if (!
#line 22295 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
                return -1;
              return 1620; /* *tbm_t1mskc_si */

            case 3:
              if (!(
#line 22295 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1621; /* *tbm_t1mskc_di */

            default:
              return -1;
            }

        case -1L:
          switch (pattern1316 (x3))
            {
            case 0:
              if (!
#line 22267 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
                return -1;
              return 1616; /* *tbm_blsfill_si */

            case 1:
              if (!(
#line 22267 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1617; /* *tbm_blsfill_di */

            case 2:
              if (!
#line 22281 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
                return -1;
              return 1618; /* *tbm_blsic_si */

            case 3:
              if (!(
#line 22281 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1619; /* *tbm_blsic_di */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_409 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x5;
      x6 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x6))
        {
        case CLOBBER:
          x7 = XEXP (x6, 0);
          if (GET_CODE (x7) != REG
              || REGNO (x7) != 17
              || GET_MODE (x7) != E_CCmode)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || GET_MODE (x4) != E_SImode
                  || !nonimmediate_operand (operands[1], E_SImode)
                  || !
#line 22343 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT))
                return -1;
              return 1626; /* popcountsi2 */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || GET_MODE (x4) != E_DImode
                  || !nonimmediate_operand (operands[1], E_DImode)
                  || !(
#line 22343 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1627; /* popcountdi2 */

            case E_HImode:
              if (!register_operand (operands[0], E_HImode)
                  || GET_MODE (x4) != E_HImode
                  || !nonimmediate_operand (operands[1], E_HImode)
                  || !
#line 22548 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT && true))
                return -1;
              return 1639; /* popcounthi2 */

            default:
              return -1;
            }

        case UNSPEC:
          switch (pattern703 (x1))
            {
            case 0:
              if (
#line 22374 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && TARGET_POPCNT))
                return 1628; /* *popcountsi2_falsedep_nf */
              if (pnum_clobbers == NULL
                  || !
#line 22393 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT))
                return -1;
              *pnum_clobbers = 1;
              return 1630; /* *popcountsi2_falsedep */

            case 1:
              if ((
#line 22374 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && TARGET_POPCNT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1629; /* *popcountdi2_falsedep_nf */
              if (pnum_clobbers == NULL
                  || !(
#line 22393 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 1631; /* *popcountdi2_falsedep */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case ZERO_EXTEND:
      if (GET_MODE (x5) != E_SImode)
        return -1;
      x6 = XVECEXP (x1, 0, 1);
      if (pattern231 (x6, 
E_CCmode, 
17) != 0
          || !register_operand (operands[0], E_SImode)
          || GET_MODE (x4) != E_SImode)
        return -1;
      x8 = XEXP (x5, 0);
      operands[1] = x8;
      if (!nonimmediate_operand (operands[1], E_HImode)
          || !
#line 22513 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT
   && ix86_pre_reload_split ()))
        return -1;
      return 1636; /* *popcounthi2_1 */

    default:
      return -1;
    }
}

 int
recog_416 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  switch (XVECLEN (x3, 0))
    {
    case 1:
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      switch (XINT (x3, 1))
        {
        case 106:
          if (pattern542 (x1) != 0)
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          if (GET_CODE (x6) != UNSPEC
              || XVECLEN (x6, 0) != 1
              || XINT (x6, 1) != 108
              || GET_MODE (x6) != E_DImode)
            return -1;
          x7 = XVECEXP (x6, 0, 0);
          if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !register_operand (operands[0], E_DImode)
              || !pop_operand (operands[1], E_TImode))
            return -1;
          x8 = XVECEXP (x1, 0, 1);
          x9 = XEXP (x8, 0);
          operands[2] = x9;
          if (!register_operand (operands[2], E_DImode)
              || !
#line 3953 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_PUSH2POP2 && TARGET_APX_PPX))
            return -1;
          return 164; /* pop2p_di */

        case 97:
          switch (pattern819 (x1))
            {
            case 0:
              if (!
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
                return -1;
              return 1558; /* *tzcnt_si_falsedep */

            case 1:
              if (!((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1560; /* *tzcnt_di_falsedep */

            default:
              return -1;
            }

        case 96:
          switch (pattern819 (x1))
            {
            case 0:
              if (!
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))
                return -1;
              return 1559; /* *lzcnt_si_falsedep */

            case 1:
              if (!((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1561; /* *lzcnt_di_falsedep */

            default:
              return -1;
            }

        case 74:
          if (pattern820 (x1) != 0
              || !
#line 25276 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)))
            return -1;
          return 1740; /* frndintxf2_roundeven_i387 */

        case 75:
          if (pattern820 (x1) != 0
              || !
#line 25276 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)))
            return -1;
          return 1741; /* frndintxf2_floor_i387 */

        case 76:
          if (pattern820 (x1) != 0
              || !
#line 25276 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)))
            return -1;
          return 1742; /* frndintxf2_ceil_i387 */

        case 77:
          if (pattern820 (x1) != 0
              || !
#line 25276 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)))
            return -1;
          return 1743; /* frndintxf2_trunc_i387 */

        case 78:
          switch (pattern822 (x1, pnum_clobbers))
            {
            case 0:
              if (!
#line 25394 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
                return -1;
              *pnum_clobbers = 1;
              return 1750; /* fistdi2_floor */

            case 1:
              if (!
#line 25407 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
                return -1;
              return 1752; /* fisthi2_floor */

            case 2:
              if (!
#line 25407 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
                return -1;
              return 1754; /* fistsi2_floor */

            default:
              return -1;
            }

        case 79:
          switch (pattern822 (x1, pnum_clobbers))
            {
            case 0:
              if (!
#line 25394 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
                return -1;
              *pnum_clobbers = 1;
              return 1751; /* fistdi2_ceil */

            case 1:
              if (!
#line 25407 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
                return -1;
              return 1753; /* fisthi2_ceil */

            case 2:
              if (!
#line 25407 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
                return -1;
              return 1755; /* fistsi2_ceil */

            default:
              return -1;
            }

        case 92:
          x8 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x8) != SET)
            return -1;
          x10 = XEXP (x8, 1);
          if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          if (pattern942 (x6, 
E_CCmode, 
17) != 0)
            return -1;
          switch (pattern1135 (x1))
            {
            case 0:
              if (!(
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode)))
                return -1;
              return 1867; /* stack_protect_set_1_si_si */

            case 1:
              if (!(
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode)))
                return -1;
              return 1869; /* stack_protect_set_1_si_di */

            case 2:
              if (!(
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode)))
                return -1;
              return 1868; /* stack_protect_set_1_di_si */

            case 3:
              if (!(
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode)))
                return -1;
              return 1870; /* stack_protect_set_1_di_di */

            default:
              return -1;
            }

        case 287:
          if (GET_MODE (x3) != E_DImode)
            return -1;
          x8 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x8) != CLOBBER)
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          if (GET_CODE (x6) != CLOBBER
              || !nonimmediate_operand (operands[0], E_DImode)
              || !memory_operand (operands[1], E_DImode))
            return -1;
          x9 = XEXP (x8, 0);
          operands[2] = x9;
          if (!memory_operand (operands[2], E_DImode))
            return -1;
          x11 = XEXP (x6, 0);
          operands[3] = x11;
          if (!scratch_operand (operands[3], E_DFmode)
              || !
#line 196 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(!TARGET_64BIT && (TARGET_80387 || TARGET_SSE)))
            return -1;
          return 10908; /* atomic_loaddi_fpu */

        case 288:
          if (GET_MODE (x3) != E_DImode)
            return -1;
          x8 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x8) != CLOBBER)
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          if (GET_CODE (x6) != CLOBBER
              || !memory_operand (operands[0], E_DImode)
              || !nonimmediate_operand (operands[1], E_DImode))
            return -1;
          x9 = XEXP (x8, 0);
          operands[2] = x9;
          if (!memory_operand (operands[2], E_DImode))
            return -1;
          x11 = XEXP (x6, 0);
          operands[3] = x11;
          if (!scratch_operand (operands[3], E_DFmode)
              || !
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(!TARGET_64BIT && (TARGET_80387 || TARGET_SSE)))
            return -1;
          return 10913; /* atomic_storedi_fpu */

        default:
          return -1;
        }

    case 2:
      x8 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x8) != SET)
        return -1;
      x10 = XEXP (x8, 1);
      if (GET_CODE (x10) != UNSPEC
          || XVECLEN (x10, 0) != 2
          || GET_MODE (x10) != E_XFmode)
        return -1;
      x6 = XVECEXP (x1, 0, 2);
      if (GET_CODE (x6) != SET)
        return -1;
      x12 = XEXP (x6, 1);
      if (GET_CODE (x12) != UNSPEC
          || XVECLEN (x12, 0) != 2
          || XINT (x12, 1) != 90
          || GET_MODE (x12) != E_CCFPmode)
        return -1;
      x11 = XEXP (x6, 0);
      if (GET_CODE (x11) != REG
          || REGNO (x11) != 18
          || GET_MODE (x11) != E_CCFPmode)
        return -1;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      if (!register_operand (operands[0], E_XFmode)
          || GET_MODE (x3) != E_XFmode
          || pattern1408 (x1) != 0)
        return -1;
      x13 = XVECEXP (x12, 0, 0);
      if (!rtx_equal_p (x13, operands[2]))
        return -1;
      x14 = XVECEXP (x12, 0, 1);
      if (!rtx_equal_p (x14, operands[3]))
        return -1;
      switch (XINT (x3, 1))
        {
        case 86:
          if (XINT (x10, 1) != 87
              || !
#line 23913 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387))
            return -1;
          return 1715; /* fpremxf4_i387 */

        case 88:
          if (XINT (x10, 1) != 89
              || !
#line 23985 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387))
            return -1;
          return 1716; /* fprem1xf4_i387 */

        default:
          return -1;
        }

    case 4:
      if (XINT (x3, 1) != 23)
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      if (GET_CODE (x5) != MEM
          || GET_MODE (x5) != E_BLKmode)
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x8) != CLOBBER
          || pattern825 (x1) != 0)
        return -1;
      switch (pattern1137 (x1))
        {
        case 0:
          if (!(
#line 26153 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(fixed_regs[AX_REG] || fixed_regs[CX_REG] || fixed_regs[DI_REG])
   && ix86_check_no_addr_space (insn)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
            return -1;
          return 1793; /* *strlenqi_1 */

        case 1:
          if (!(
#line 26153 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(fixed_regs[AX_REG] || fixed_regs[CX_REG] || fixed_regs[DI_REG])
   && ix86_check_no_addr_space (insn)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
            return -1;
          return 1794; /* *strlenqi_1 */

        default:
          return -1;
        }

    case 5:
      if (XINT (x3, 1) != 131)
        return -1;
      if (GET_MODE (x3) == E_SImode
          && pattern709 (x1, 
131, 
5) == 0
          && pattern1711 (x1) == 0
          && 
#line 26084 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2
   && ix86_pre_reload_split ()))
        return 8906; /* sse4_2_pcmpestr */
      if (GET_MODE (x3) != E_CCmode
          || pattern710 (x1) != 0
          || !register_operand (operands[3], E_SImode))
        return -1;
      x15 = XVECEXP (x3, 0, 2);
      operands[4] = x15;
      if (!nonimmediate_operand (operands[4], E_V16QImode))
        return -1;
      x16 = XVECEXP (x3, 0, 3);
      operands[5] = x16;
      if (!register_operand (operands[5], E_SImode))
        return -1;
      x17 = XVECEXP (x3, 0, 4);
      operands[6] = x17;
      if (!const_0_to_255_operand (operands[6], E_SImode))
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      x9 = XEXP (x8, 0);
      operands[0] = x9;
      if (!scratch_operand (operands[0], E_V16QImode))
        return -1;
      x6 = XVECEXP (x1, 0, 2);
      x11 = XEXP (x6, 0);
      operands[1] = x11;
      if (!scratch_operand (operands[1], E_SImode)
          || !
#line 26187 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2))
        return -1;
      return 8909; /* sse4_2_pcmpestr_cconly */

    case 3:
      if (XINT (x3, 1) != 132)
        return -1;
      if (GET_MODE (x3) == E_SImode
          && pattern709 (x1, 
132, 
3) == 0
          && pattern1712 (x1) == 0
          && 
#line 26221 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2
   && ix86_pre_reload_split ()))
        return 8910; /* sse4_2_pcmpistr */
      if (GET_MODE (x3) != E_CCmode
          || pattern710 (x1) != 0
          || !nonimmediate_operand (operands[3], E_V16QImode))
        return -1;
      x15 = XVECEXP (x3, 0, 2);
      operands[4] = x15;
      if (!const_0_to_255_operand (operands[4], E_SImode))
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      x9 = XEXP (x8, 0);
      operands[0] = x9;
      if (!scratch_operand (operands[0], E_V16QImode))
        return -1;
      x6 = XVECEXP (x1, 0, 2);
      x11 = XEXP (x6, 0);
      operands[1] = x11;
      if (!scratch_operand (operands[1], E_SImode)
          || !
#line 26312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2))
        return -1;
      return 8913; /* sse4_2_pcmpistr_cconly */

    default:
      return -1;
    }
}

 rtx_insn *
split_1 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  switch (GET_CODE (operands[0]))
    {
    case MEM:
      switch (GET_MODE (operands[0]))
        {
        case E_V1TImode:
          if (push_operand (operands[0], E_V1TImode)
              && register_operand (operands[1], E_V1TImode))
            {
              if (((
#line 2175 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_STV) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 2177 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return gen_split_3 (insn, operands);
              if (((
#line 2175 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_STV) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 2177 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return gen_split_4 (insn, operands);
            }
          break;

        case E_DImode:
          if (push_operand (operands[0], E_DImode))
            {
              if (general_gr_operand (operands[1], E_DImode)
                  && (
#line 2199 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return gen_split_5 (insn, operands);
              if (immediate_operand (operands[1], E_DImode)
                  && 
#line 2232 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && epilogue_completed
   && !symbolic_operand (operands[1], DImode)
   && !x86_64_immediate_operand (operands[1], DImode)))
                return gen_split_7 (insn, operands);
              if (sse_reg_operand (operands[1], E_DImode))
                {
                  if ((
#line 2269 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE && reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return gen_split_9 (insn, operands);
                  if ((
#line 2269 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE && reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return gen_split_12 (insn, operands);
                }
            }
          break;

        case E_TImode:
          if (push_operand (operands[0], E_TImode))
            {
              if (general_gr_operand (operands[1], E_TImode)
                  && (
#line 2199 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1196 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return gen_split_6 (insn, operands);
              if (sse_reg_operand (operands[1], E_TImode))
                {
                  if ((
#line 2269 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE && reload_completed) && (((
#line 1202 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return gen_split_10 (insn, operands);
                  if ((
#line 2269 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE && reload_completed) && (((
#line 1202 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return gen_split_13 (insn, operands);
                }
            }
          break;

        case E_SImode:
          if (push_operand (operands[0], E_SImode)
              && sse_reg_operand (operands[1], E_SImode))
            {
              if ((
#line 2269 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE && reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return gen_split_8 (insn, operands);
              if ((
#line 2269 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE && reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return gen_split_11 (insn, operands);
            }
          break;

        case E_TFmode:
          if (push_operand (operands[0], E_TFmode)
              && sse_reg_operand (operands[1], E_TFmode))
            {
              if ((
#line 3791 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE && reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return gen_split_37 (insn, operands);
              if ((
#line 3791 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE && reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return gen_split_38 (insn, operands);
            }
          break;

        case E_XFmode:
          if (push_operand (operands[0], E_XFmode)
              && fp_register_operand (operands[1], E_XFmode))
            {
              if ((
#line 3826 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return gen_split_39 (insn, operands);
              if ((
#line 3826 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return gen_split_40 (insn, operands);
            }
          break;

        case E_DFmode:
          if (push_operand (operands[0], E_DFmode)
              && any_fp_register_operand (operands[1], E_DFmode))
            {
              if ((
#line 3860 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return gen_split_41 (insn, operands);
              if ((
#line 3860 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return gen_split_42 (insn, operands);
            }
          break;

        case E_SFmode:
          if (push_operand (operands[0], E_SFmode))
            {
              if (any_fp_register_operand (operands[1], E_SFmode))
                {
                  if ((
#line 3991 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return gen_split_43 (insn, operands);
                  if ((
#line 3991 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return gen_split_46 (insn, operands);
                }
              if (memory_operand (operands[1], E_SFmode)
                  && 
#line 4014 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && find_constant_src (insn)))
                return gen_split_49 (insn, operands);
            }
          break;

        case E_HFmode:
          if (push_operand (operands[0], E_HFmode)
              && any_fp_register_operand (operands[1], E_HFmode))
            {
              if ((
#line 3991 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return gen_split_44 (insn, operands);
              if ((
#line 3991 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return gen_split_47 (insn, operands);
            }
          break;

        case E_BFmode:
          if (push_operand (operands[0], E_BFmode)
              && any_fp_register_operand (operands[1], E_BFmode))
            {
              if ((
#line 3991 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return gen_split_45 (insn, operands);
              if ((
#line 3991 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return gen_split_48 (insn, operands);
            }
          break;

        default:
          break;
        }
      break;

    case REG:
      switch (GET_MODE (operands[0]))
        {
        case E_TImode:
          if (sse_reg_operand (operands[0], E_TImode)
              && general_reg_operand (operands[1], E_TImode)
              && 
#line 2574 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_SSE4_1
   && reload_completed))
            return gen_split_20 (insn, operands);
          if (general_reg_operand (operands[0], E_TImode)
              && sse_reg_operand (operands[1], E_TImode)
              && (
#line 2765 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE4_1
   && reload_completed) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return gen_split_22 (insn, operands);
          break;

        case E_DImode:
          if (general_reg_operand (operands[0], E_DImode)
              && sse_reg_operand (operands[1], E_DImode)
              && (
#line 2765 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE4_1
   && reload_completed) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return gen_split_21 (insn, operands);
          break;

        default:
          break;
        }
      break;

    default:
      break;
    }
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (nonimmediate_gr_operand (operands[0], E_DImode)
          && general_gr_operand (operands[1], E_DImode)
          && (
#line 2782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
        return gen_split_23 (insn, operands);
      if (sse_reg_operand (operands[0], E_DImode)
          && general_reg_operand (operands[1], E_DImode)
          && 
#line 2789 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_SSE4_1
   && reload_completed))
        return gen_split_25 (insn, operands);
      break;

    case E_TImode:
      if (nonimmediate_gr_operand (operands[0], E_TImode)
          && general_gr_operand (operands[1], E_TImode)
          && (
#line 2782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1196 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return gen_split_24 (insn, operands);
      break;

    default:
      break;
    }
  if (push_operand (operands[0], E_VOIDmode)
      && general_gr_operand (operands[1], E_VOIDmode)
      && 
#line 4022 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && (GET_MODE (operands[0]) == TFmode
       || GET_MODE (operands[0]) == XFmode
       || GET_MODE (operands[0]) == DFmode)))
    return gen_split_50 (insn, operands);
  switch (GET_MODE (operands[0]))
    {
    case E_TFmode:
      if (nonimmediate_gr_operand (operands[0], E_TFmode)
          && general_gr_operand (operands[1], E_TFmode)
          && 
#line 4095 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
        return gen_split_51 (insn, operands);
      break;

    case E_XFmode:
      if (nonimmediate_gr_operand (operands[0], E_XFmode)
          && general_gr_operand (operands[1], E_XFmode)
          && 
#line 4168 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
        return gen_split_52 (insn, operands);
      break;

    case E_DFmode:
      if (nonimmediate_gr_operand (operands[0], E_DFmode)
          && general_gr_operand (operands[1], E_DFmode)
          && 
#line 4346 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && reload_completed))
        return gen_split_53 (insn, operands);
      break;

    default:
      break;
    }
  if (any_fp_register_operand (operands[0], E_VOIDmode)
      && memory_operand (operands[1], E_VOIDmode)
      && 
#line 4614 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && (GET_MODE (operands[0]) == TFmode
       || GET_MODE (operands[0]) == XFmode
       || GET_MODE (operands[0]) == DFmode
       || GET_MODE (operands[0]) == SFmode)
   && ix86_standard_x87sse_constant_load_p (insn, operands[0])))
    return gen_split_54 (insn, operands);
  if (fp_register_operand (operands[0], E_SFmode)
      && immediate_operand (operands[1], E_SFmode)
      && 
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && (standard_80387_constant_p (operands[1]) == 8
       || standard_80387_constant_p (operands[1]) == 9)))
    return gen_split_56 (insn, operands);
  if (fp_register_operand (operands[0], E_DFmode)
      && immediate_operand (operands[1], E_DFmode)
      && 
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && (standard_80387_constant_p (operands[1]) == 8
       || standard_80387_constant_p (operands[1]) == 9)))
    return gen_split_57 (insn, operands);
  if (!fp_register_operand (operands[0], E_XFmode)
      || !immediate_operand (operands[1], E_XFmode)
      || !
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && (standard_80387_constant_p (operands[1]) == 8
       || standard_80387_constant_p (operands[1]) == 9)))
    return NULL;
  return gen_split_58 (insn, operands);
}

 rtx_insn *
split_10 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[2] = x4;
  x5 = XEXP (x3, 1);
  switch (GET_CODE (x5))
    {
    case XOR:
      x6 = XEXP (x5, 1);
      if (GET_CODE (x6) != CONST_INT)
        return NULL;
      x7 = XEXP (x5, 0);
      switch (GET_CODE (x7))
        {
        case MINUS:
          if (GET_MODE (x7) != E_SImode)
            return NULL;
          x8 = XEXP (x7, 0);
          if (GET_CODE (x8) != CONST_INT
              || pattern1048 (x3, 
E_SImode) != 0)
            return NULL;
          x9 = XEXP (x7, 1);
          if (GET_MODE (x9) != E_SImode)
            return NULL;
          switch (XWINT (x8, 0))
            {
            case 63L:
              if (GET_CODE (x9) != SUBREG
                  || maybe_ne (SUBREG_BYTE (x9), 0))
                return NULL;
              x10 = XEXP (x9, 0);
              if (GET_CODE (x10) != CLZ
                  || GET_MODE (x10) != E_DImode
                  || XWINT (x6, 0) != 63L)
                return NULL;
              x11 = XEXP (x10, 0);
              operands[1] = x11;
              if (!nonimmediate_operand (operands[1], E_DImode)
                  || !
#line 21390 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT && TARGET_64BIT && ix86_pre_reload_split ()))
                return NULL;
              return gen_split_886 (insn, operands);

            case 31L:
              if (GET_CODE (x9) != CLZ
                  || XWINT (x6, 0) != 31L)
                return NULL;
              x10 = XEXP (x9, 0);
              operands[1] = x10;
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !
#line 21415 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT && ix86_pre_reload_split ()))
                return NULL;
              return gen_split_887 (insn, operands);

            default:
              return NULL;
            }

        case SIGN_EXTEND:
          if (pattern829 (x7, 
SUBREG, 
63, 
E_DImode) != 0)
            return NULL;
          x8 = XEXP (x7, 0);
          x12 = XEXP (x8, 1);
          if (maybe_ne (SUBREG_BYTE (x12), 0)
              || GET_MODE (x12) != E_SImode)
            return NULL;
          x13 = XEXP (x12, 0);
          if (GET_CODE (x13) != CLZ
              || GET_MODE (x13) != E_DImode
              || XWINT (x6, 0) != 63L
              || pattern1048 (x3, 
E_DImode) != 0)
            return NULL;
          x14 = XEXP (x13, 0);
          operands[1] = x14;
          if (!nonimmediate_operand (operands[1], E_DImode)
              || !
#line 21441 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT
   && TARGET_64BIT
   && ix86_pre_reload_split ()
   && ((unsigned HOST_WIDE_INT)
       trunc_int_for_mode (UINTVAL (operands[2]) - 63, SImode)
       == UINTVAL (operands[2]) - 63)))
            return NULL;
          return gen_split_888 (insn, operands);

        default:
          return NULL;
        }

    case SIGN_EXTEND:
      if (GET_MODE (x5) != E_DImode)
        return NULL;
      x7 = XEXP (x5, 0);
      if (GET_CODE (x7) != XOR
          || pattern829 (x7, 
CLZ, 
31, 
E_SImode) != 0)
        return NULL;
      x8 = XEXP (x7, 0);
      x12 = XEXP (x8, 1);
      if (GET_MODE (x12) != E_SImode)
        return NULL;
      x9 = XEXP (x7, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 31]
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode
          || !const_int_operand (operands[2], E_DImode))
        return NULL;
      x13 = XEXP (x12, 0);
      operands[1] = x13;
      if (!nonimmediate_operand (operands[1], E_SImode)
          || !
#line 21470 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT
   && TARGET_64BIT
   && ix86_pre_reload_split ()
   && ((unsigned HOST_WIDE_INT)
       trunc_int_for_mode (UINTVAL (operands[2]) - 31, SImode)
       == UINTVAL (operands[2]) - 31)))
        return NULL;
      return gen_split_889 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_12 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case NE:
    case EQ:
      operands[5] = x3;
      if (bt_comparison_operator (operands[5], E_VOIDmode))
        {
          res = split_3 (x1, insn);
          if (res != NULL_RTX)
            return res;
        }
      x4 = XEXP (x3, 0);
      if (!ix86_comparison_operator (x4, E_VOIDmode))
        return NULL;
      operands[0] = x4;
      x5 = XEXP (x4, 0);
      if (GET_CODE (x5) != REG
          || REGNO (x5) != 17)
        return NULL;
      x6 = XEXP (x4, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x7 = XEXP (x3, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x8 = XEXP (x2, 1);
      if (GET_CODE (x8) != LABEL_REF)
        return NULL;
      x9 = XEXP (x2, 2);
      if (GET_CODE (x9) != PC)
        return NULL;
      x10 = XEXP (x1, 0);
      if (GET_CODE (x10) != PC)
        return NULL;
      x11 = XEXP (x8, 0);
      operands[1] = x11;
      switch (GET_CODE (x3))
        {
        case NE:
          return gen_split_872 (insn, operands);

        case EQ:
          return gen_split_873 (insn, operands);

        default:
          return NULL;
        }

    case GEU:
    case LTU:
      operands[1] = x3;
      if (!add_comparison_operator (operands[1], E_VOIDmode))
        return NULL;
      x4 = XEXP (x3, 0);
      if (GET_CODE (x4) != NOT)
        return NULL;
      x8 = XEXP (x2, 1);
      if (GET_CODE (x8) != LABEL_REF)
        return NULL;
      x9 = XEXP (x2, 2);
      if (GET_CODE (x9) != PC)
        return NULL;
      x10 = XEXP (x1, 0);
      if (GET_CODE (x10) != PC)
        return NULL;
      x5 = XEXP (x4, 0);
      operands[2] = x5;
      x7 = XEXP (x3, 1);
      operands[3] = x7;
      x11 = XEXP (x8, 0);
      operands[0] = x11;
      switch (GET_MODE (x4))
        {
        case E_QImode:
          if (!register_operand (operands[2], E_QImode)
              || !nonimmediate_operand (operands[3], E_QImode))
            return NULL;
          return gen_split_867 (insn, operands);

        case E_HImode:
          if (!register_operand (operands[2], E_HImode)
              || !nonimmediate_operand (operands[3], E_HImode))
            return NULL;
          return gen_split_868 (insn, operands);

        case E_SImode:
          if (!register_operand (operands[2], E_SImode)
              || !nonimmediate_operand (operands[3], E_SImode))
            return NULL;
          return gen_split_869 (insn, operands);

        case E_DImode:
          if (!register_operand (operands[2], E_DImode)
              || !nonimmediate_operand (operands[3], E_DImode)
              || !
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return NULL;
          return gen_split_870 (insn, operands);

        default:
          return NULL;
        }

    case GTU:
    case LEU:
      operands[1] = x3;
      if (!shr_comparison_operator (operands[1], E_VOIDmode))
        return NULL;
      x8 = XEXP (x2, 1);
      if (GET_CODE (x8) != LABEL_REF)
        return NULL;
      x9 = XEXP (x2, 2);
      if (GET_CODE (x9) != PC)
        return NULL;
      x10 = XEXP (x1, 0);
      if (GET_CODE (x10) != PC)
        return NULL;
      x4 = XEXP (x3, 0);
      operands[2] = x4;
      if (!register_operand (operands[2], E_DImode))
        return NULL;
      x7 = XEXP (x3, 1);
      operands[3] = x7;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return NULL;
      x11 = XEXP (x8, 0);
      operands[0] = x11;
      if (!
#line 19761 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && IN_RANGE (exact_log2 (UINTVAL (operands[3]) + 1), 32, 63)))
        return NULL;
      return gen_split_871 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_15 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  switch (pattern1165 (x2))
    {
    case 0:
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          x3 = XEXP (x2, 1);
          if (GET_MODE (x3) != E_DImode)
            return NULL;
          if (nonimmediate_operand (operands[0], E_DImode)
              && nonimmediate_operand (operands[1], E_DImode)
              && x86_64_hilo_general_operand (operands[2], E_DImode)
              && ((
#line 6477 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 6479 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return gen_split_104 (insn, operands);
          if (!register_operand (operands[0], E_DImode)
              || !register_operand (operands[1], E_DImode)
              || !x86_64_nonmemory_operand (operands[2], E_DImode))
            return NULL;
          if ((
#line 7065 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed && ix86_avoid_lea_for_add (insn, operands)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return gen_split_129 (insn, operands);
          if (!(
#line 7091 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed && ix86_lea_for_add_ok (insn, operands)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          return gen_split_134 (insn, operands);

        case E_TImode:
          x3 = XEXP (x2, 1);
          if (pattern564 (x3, 
E_TImode) != 0
              || !((
#line 6477 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 6479 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_105 (insn, operands);

        case E_SImode:
          x3 = XEXP (x2, 1);
          if (pattern1488 (x3, 
E_SImode) != 0)
            return NULL;
          if (
#line 7065 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed && ix86_avoid_lea_for_add (insn, operands)))
            return gen_split_128 (insn, operands);
          if (!
#line 7091 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed && ix86_lea_for_add_ok (insn, operands)))
            return NULL;
          return gen_split_133 (insn, operands);

        case E_QImode:
          x3 = XEXP (x2, 1);
          if (pattern1234 (x3, 
E_QImode) != 0
              || !
#line 7091 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed && ix86_lea_for_add_ok (insn, operands)))
            return NULL;
          return gen_split_131 (insn, operands);

        case E_HImode:
          if (!register_operand (operands[0], E_HImode))
            return NULL;
          x3 = XEXP (x2, 1);
          if (GET_MODE (x3) != E_HImode
              || !register_operand (operands[1], E_HImode)
              || !nonmemory_operand (operands[2], E_HImode)
              || !
#line 7091 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed && ix86_lea_for_add_ok (insn, operands)))
            return NULL;
          return gen_split_132 (insn, operands);

        default:
          return NULL;
        }

    case 1:
      if (!(
#line 6958 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 6981 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
        return NULL;
      return gen_split_120 (insn, operands);

    case 2:
      if (!(
#line 6958 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 6981 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
        return NULL;
      return gen_split_121 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_22 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (pattern231 (x2, 
E_CCmode, 
17) != 0)
    return NULL;
  x3 = XVECEXP (x1, 0, 0);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case MEM:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      operands[1] = x5;
      switch (pattern1167 (x3))
        {
        case 0:
          if ((
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12759 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
            return gen_split_294 (insn, operands);
          break;

        case 1:
          if ((
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12759 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
            return gen_split_297 (insn, operands);
          break;

        case 2:
          if (nonimmediate_operand (operands[0], E_DImode)
              && nonimmediate_operand (operands[1], E_DImode))
            {
              if (x86_64_hilo_general_operand (operands[2], E_DImode)
                  && ((
#line 13541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (IOR, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 13543 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return gen_split_393 (insn, operands);
              if (const_int_operand (operands[2], E_DImode)
                  && (
#line 13647 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_USE_BT
   && ix86_binary_operator_ok (IOR, DImode, operands)
   && IN_RANGE (exact_log2 (INTVAL (operands[2])), 31, 63)) && 
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return gen_split_400 (insn, operands);
            }
          if (const_int_operand (operands[2], E_DImode))
            {
              if (QIreg_operand (operands[0], E_DImode)
                  && register_operand (operands[1], E_DImode)
                  && (
#line 13966 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~(255 << 8))
    && !(TARGET_APX_NDD && REGNO (operands[0]) != REGNO (operands[1]))) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return gen_split_428 (insn, operands);
              if (any_QIreg_operand (operands[0], E_DImode)
                  && general_operand (operands[1], E_DImode)
                  && (
#line 14004 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~255)
    && (INTVAL (operands[2]) & 128)
    && !(TARGET_APX_NDD
	 && !rtx_equal_p (operands[0], operands[1]))) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return gen_split_434 (insn, operands);
            }
          break;

        case 3:
          if (((
#line 13541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (IOR, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13543 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return gen_split_395 (insn, operands);
          break;

        case 4:
          if (QIreg_operand (operands[0], E_HImode)
              && register_operand (operands[1], E_HImode)
              && 
#line 13966 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~(255 << 8))
    && !(TARGET_APX_NDD && REGNO (operands[0]) != REGNO (operands[1]))))
            return gen_split_424 (insn, operands);
          if (any_QIreg_operand (operands[0], E_HImode)
              && general_operand (operands[1], E_HImode)
              && 
#line 14004 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~255)
    && (INTVAL (operands[2]) & 128)
    && !(TARGET_APX_NDD
	 && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_430 (insn, operands);
          break;

        case 5:
          if (QIreg_operand (operands[0], E_SImode)
              && register_operand (operands[1], E_SImode)
              && 
#line 13966 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~(255 << 8))
    && !(TARGET_APX_NDD && REGNO (operands[0]) != REGNO (operands[1]))))
            return gen_split_426 (insn, operands);
          if (any_QIreg_operand (operands[0], E_SImode)
              && general_operand (operands[1], E_SImode)
              && 
#line 14004 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~255)
    && (INTVAL (operands[2]) & 128)
    && !(TARGET_APX_NDD
	 && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_432 (insn, operands);
          break;

        default:
          break;
        }
      if (GET_CODE (x5) != SUBREG
          || pattern1166 (x4) != 0)
        return NULL;
      x6 = XEXP (x5, 0);
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      switch (pattern1667 (x3))
        {
        case 0:
          if ((
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12786 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_300 (insn, operands);
          break;

        case 1:
          if ((
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12786 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_303 (insn, operands);
          break;

        case 2:
          if (((
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 12786 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_306 (insn, operands);
          break;

        default:
          break;
        }
      operands[1] = x7;
      switch (pattern1668 (x3))
        {
        case 0:
          if (!(
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12817 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_309 (insn, operands);

        case 1:
          if (!(
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12817 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_312 (insn, operands);

        case 2:
          if (!((
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 12817 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_315 (insn, operands);

        case 3:
          if (!
#line 13058 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed))
            return NULL;
          return gen_split_329 (insn, operands);

        case 4:
          if (!
#line 13058 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed))
            return NULL;
          return gen_split_332 (insn, operands);

        case 5:
          if (!(
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 13058 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_335 (insn, operands);

        default:
          return NULL;
        }

    case ASHIFT:
      x8 = XEXP (x3, 0);
      operands[0] = x8;
      x6 = XEXP (x5, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
        case MEM:
          x9 = XEXP (x4, 1);
          if (GET_CODE (x9) != LSHIFTRT)
            return NULL;
          switch (pattern1226 (x4))
            {
            case 0:
              if (!(
#line 15545 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && ix86_pre_reload_split ()) && 
#line 15549 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_569 (insn, operands);

            case 1:
              if (!(
#line 15777 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
   && ix86_pre_reload_split ()) && 
#line 15780 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_573 (insn, operands);

            case 2:
              x10 = XEXP (x9, 0);
              operands[1] = x10;
              if (nonimmediate_operand (operands[0], E_DImode))
                {
                  x11 = XEXP (x5, 1);
                  operands[2] = x11;
                  if (rtx_equal_p (x6, operands[0]))
                    {
                      x12 = XEXP (x9, 1);
                      x13 = XEXP (x12, 1);
                      if (rtx_equal_p (x13, operands[2])
                          && (
#line 15598 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()) && 
#line 15600 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_570 (insn, operands);
                    }
                }
              operands[2] = x10;
              if (!register_operand (operands[0], E_DImode))
                return NULL;
              operands[1] = x6;
              if (!nonimmediate_operand (operands[1], E_DImode))
                return NULL;
              x11 = XEXP (x5, 1);
              operands[3] = x11;
              x12 = XEXP (x9, 1);
              x13 = XEXP (x12, 1);
              if (!rtx_equal_p (x13, operands[3])
                  || !(
#line 15619 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && ix86_pre_reload_split ()) && 
#line 15622 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_571 (insn, operands);

            case 3:
              x10 = XEXP (x9, 0);
              operands[1] = x10;
              if (nonimmediate_operand (operands[0], E_SImode))
                {
                  x11 = XEXP (x5, 1);
                  operands[2] = x11;
                  if (rtx_equal_p (x6, operands[0]))
                    {
                      x12 = XEXP (x9, 1);
                      x13 = XEXP (x12, 1);
                      if (rtx_equal_p (x13, operands[2])
                          && (
#line 15829 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()) && 
#line 15831 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_574 (insn, operands);
                    }
                }
              operands[2] = x10;
              if (!register_operand (operands[0], E_SImode))
                return NULL;
              operands[1] = x6;
              if (!nonimmediate_operand (operands[1], E_SImode))
                return NULL;
              x11 = XEXP (x5, 1);
              operands[3] = x11;
              x12 = XEXP (x9, 1);
              x13 = XEXP (x12, 1);
              if (!rtx_equal_p (x13, operands[3])
                  || !(
#line 15850 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && ix86_pre_reload_split ()) && 
#line 15853 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_575 (insn, operands);

            default:
              return NULL;
            }

        case CONST_INT:
          if (XWINT (x6, 0) != 1L)
            return NULL;
          switch (pattern1050 (x4))
            {
            case 0:
              if (!(
#line 18856 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 18861 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_802 (insn, operands);

            case 1:
              if (!((
#line 18856 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 18861 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_804 (insn, operands);

            case 2:
              if (!(
#line 18884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 18889 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_806 (insn, operands);

            case 3:
              if (!((
#line 18884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 18889 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_808 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case LSHIFTRT:
      x9 = XEXP (x4, 1);
      if (GET_CODE (x9) != ASHIFT)
        return NULL;
      x8 = XEXP (x3, 0);
      operands[0] = x8;
      switch (pattern1226 (x4))
        {
        case 0:
          if (!(
#line 16930 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && ix86_pre_reload_split ()) && 
#line 16934 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_616 (insn, operands);

        case 1:
          if (!(
#line 17161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
   && ix86_pre_reload_split ()) && 
#line 17164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_620 (insn, operands);

        case 2:
          x10 = XEXP (x9, 0);
          operands[1] = x10;
          if (nonimmediate_operand (operands[0], E_DImode))
            {
              x11 = XEXP (x5, 1);
              operands[2] = x11;
              x6 = XEXP (x5, 0);
              if (rtx_equal_p (x6, operands[0]))
                {
                  x12 = XEXP (x9, 1);
                  x13 = XEXP (x12, 1);
                  if (rtx_equal_p (x13, operands[2])
                      && (
#line 16983 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()) && 
#line 16985 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return gen_split_617 (insn, operands);
                }
            }
          operands[2] = x10;
          if (!register_operand (operands[0], E_DImode))
            return NULL;
          x6 = XEXP (x5, 0);
          operands[1] = x6;
          if (!nonimmediate_operand (operands[1], E_DImode))
            return NULL;
          x11 = XEXP (x5, 1);
          operands[3] = x11;
          x12 = XEXP (x9, 1);
          x13 = XEXP (x12, 1);
          if (!rtx_equal_p (x13, operands[2])
              || !(
#line 17004 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
  && ix86_pre_reload_split ()) && 
#line 17007 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_618 (insn, operands);

        case 3:
          x10 = XEXP (x9, 0);
          operands[1] = x10;
          if (nonimmediate_operand (operands[0], E_SImode))
            {
              x11 = XEXP (x5, 1);
              operands[2] = x11;
              x6 = XEXP (x5, 0);
              if (rtx_equal_p (x6, operands[0]))
                {
                  x12 = XEXP (x9, 1);
                  x13 = XEXP (x12, 1);
                  if (rtx_equal_p (x13, operands[2])
                      && (
#line 17213 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()) && 
#line 17215 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return gen_split_621 (insn, operands);
                }
            }
          operands[2] = x10;
          if (!register_operand (operands[0], E_SImode))
            return NULL;
          x6 = XEXP (x5, 0);
          operands[1] = x6;
          if (!nonimmediate_operand (operands[1], E_SImode))
            return NULL;
          x11 = XEXP (x5, 1);
          operands[3] = x11;
          x12 = XEXP (x9, 1);
          x13 = XEXP (x12, 1);
          if (!rtx_equal_p (x13, operands[3])
              || !(
#line 17234 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && ix86_pre_reload_split ()) && 
#line 17237 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_622 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_34 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_CODE (x2))
    {
    case SET:
      x3 = XEXP (x2, 1);
      switch (GET_CODE (x3))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          operands[1] = x3;
          if (pattern340 (x1) == 0)
            {
              switch (GET_MODE (operands[0]))
                {
                case E_HImode:
                  if (memory_operand (operands[0], E_HImode)
                      && const0_operand (operands[1], E_HImode)
                      && (
#line 2436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 2438 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( !(optimize_insn_for_size_p () && optimize_size > 1))))
                    return gen_split_14 (insn, operands);
                  if (nonimmediate_operand (operands[0], E_HImode)
                      && constm1_operand (operands[1], E_HImode)
                      && (
#line 2451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 2453 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( !(optimize_insn_for_size_p () && optimize_size > 1))))
                    return gen_split_17 (insn, operands);
                  break;

                case E_SImode:
                  if (memory_operand (operands[0], E_SImode)
                      && const0_operand (operands[1], E_SImode)
                      && (
#line 2436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 2438 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( !(optimize_insn_for_size_p () && optimize_size > 1))))
                    return gen_split_15 (insn, operands);
                  if (nonimmediate_operand (operands[0], E_SImode)
                      && constm1_operand (operands[1], E_SImode)
                      && (
#line 2451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 2453 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( !(optimize_insn_for_size_p () && optimize_size > 1))))
                    return gen_split_18 (insn, operands);
                  break;

                case E_DImode:
                  if (memory_operand (operands[0], E_DImode)
                      && const0_operand (operands[1], E_DImode)
                      && ((
#line 2436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 2438 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( !(optimize_insn_for_size_p () && optimize_size > 1))))
                    return gen_split_16 (insn, operands);
                  if (nonimmediate_operand (operands[0], E_DImode)
                      && constm1_operand (operands[1], E_DImode)
                      && ((
#line 2451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 2453 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( !(optimize_insn_for_size_p () && optimize_size > 1))))
                    return gen_split_19 (insn, operands);
                  break;

                default:
                  break;
                }
            }
          if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return NULL;
          x4 = XEXP (x2, 0);
          if (GET_CODE (x4) != ZERO_EXTRACT
              || GET_MODE (x4) != E_HImode)
            return NULL;
          x5 = XEXP (x4, 1);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return NULL;
          x6 = XVECEXP (x1, 0, 1);
          if (pattern231 (x6, 
E_CCmode, 
17) != 0)
            return NULL;
          x7 = XEXP (x4, 0);
          operands[0] = x7;
          x8 = XEXP (x4, 2);
          operands[1] = x8;
          if (!register_operand (operands[1], E_QImode))
            return NULL;
          switch (GET_MODE (operands[0]))
            {
            case E_QImode:
              if (nonimmediate_operand (operands[0], E_QImode)
                  && (
#line 18995 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 18997 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( MEM_P (operands[0]))))
                return gen_split_816 (insn, operands);
              if (!register_operand (operands[0], E_QImode)
                  || !
#line 19019 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()))
                return NULL;
              return gen_split_818 (insn, operands);

            case E_HImode:
              if (nonimmediate_operand (operands[0], E_HImode)
                  && (
#line 18995 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 18997 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( MEM_P (operands[0]))))
                return gen_split_817 (insn, operands);
              if (!register_operand (operands[0], E_HImode)
                  || !
#line 19019 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()))
                return NULL;
              return gen_split_819 (insn, operands);

            default:
              return NULL;
            }

        case SIGN_EXTRACT:
        case ZERO_EXTRACT:
          x9 = XEXP (x3, 1);
          if (GET_CODE (x9) != CONST_INT)
            return NULL;
          if (XWINT (x9, 0) == 1L)
            {
              res = split_14 (x1, insn);
              if (res != NULL_RTX)
                return res;
            }
          if (XWINT (x9, 0) != 8L
              || pattern717 (x2) != 0)
            return NULL;
          x6 = XVECEXP (x1, 0, 1);
          if (pattern231 (x6, 
E_CCmode, 
17) != 0)
            return NULL;
          switch (pattern1406 (x2))
            {
            case 0:
              if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_364 (insn, operands);

            case 1:
              if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_367 (insn, operands);

            case 2:
              if (!((
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_370 (insn, operands);

            case 3:
              if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_365 (insn, operands);

            case 4:
              if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_368 (insn, operands);

            case 5:
              if (!((
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_371 (insn, operands);

            case 6:
              if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_366 (insn, operands);

            case 7:
              if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_369 (insn, operands);

            case 8:
              if (!((
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_372 (insn, operands);

            default:
              return NULL;
            }

        case ZERO_EXTEND:
          return split_30 (x1, insn);

        case FIX:
          x6 = XVECEXP (x1, 0, 1);
          if (pattern353 (x6) != 0)
            return NULL;
          x4 = XEXP (x2, 0);
          operands[0] = x4;
          x10 = XEXP (x3, 0);
          operands[1] = x10;
          if (!register_operand (operands[1], E_VOIDmode))
            return NULL;
          switch (pattern548 (x3))
            {
            case 0:
              if (!(
#line 6005 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || HImode != DImode))
   && ix86_pre_reload_split ()) && 
#line 6011 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_82 (insn, operands);

            case 1:
              if (!(
#line 6005 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || SImode != DImode))
   && ix86_pre_reload_split ()) && 
#line 6011 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_83 (insn, operands);

            case 2:
              if (!(
#line 6005 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || DImode != DImode))
   && ix86_pre_reload_split ()) && 
#line 6011 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_84 (insn, operands);

            default:
              return NULL;
            }

        case MULT:
          if (pattern340 (x1) != 0)
            return NULL;
          x10 = XEXP (x3, 0);
          switch (GET_CODE (x10))
            {
            case REG:
              if (!rtx_equal_p (x10, operands[0]))
                return NULL;
              x9 = XEXP (x3, 1);
              operands[1] = x9;
              switch (GET_MODE (operands[0]))
                {
                case E_SImode:
                  if (!general_reg_operand (operands[0], E_SImode)
                      || GET_MODE (x3) != E_SImode
                      || !const1248_operand (operands[1], E_SImode)
                      || !
#line 6432 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                    return NULL;
                  return gen_split_100 (insn, operands);

                case E_DImode:
                  if (!general_reg_operand (operands[0], E_DImode)
                      || GET_MODE (x3) != E_DImode
                      || !const1248_operand (operands[1], E_DImode)
                      || !(
#line 6432 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return NULL;
                  return gen_split_101 (insn, operands);

                default:
                  return NULL;
                }

            case ZERO_EXTEND:
              x9 = XEXP (x3, 1);
              if (GET_CODE (x9) != ZERO_EXTEND)
                return NULL;
              x11 = XEXP (x10, 0);
              operands[1] = x11;
              x12 = XEXP (x9, 0);
              operands[2] = x12;
              switch (GET_MODE (operands[0]))
                {
                case E_DImode:
                  if (pattern562 (x3, 
E_SImode, 
E_DImode) != 0
                      || !(
#line 11033 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2 && reload_completed
  && REGNO (operands[1]) == DX_REG) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                    return NULL;
                  return gen_split_244 (insn, operands);

                case E_TImode:
                  if (pattern562 (x3, 
E_DImode, 
E_TImode) != 0
                      || !(
#line 11033 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2 && reload_completed
  && REGNO (operands[1]) == DX_REG) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return NULL;
                  return gen_split_245 (insn, operands);

                default:
                  return NULL;
                }

            default:
              return NULL;
            }

        case PLUS:
          return split_25 (x1, insn);

        case SUBREG:
          return split_24 (x1, insn);

        case NE:
        case EQ:
        case GE:
        case GT:
        case LE:
        case LT:
        case LTGT:
        case GEU:
        case GTU:
        case LEU:
        case LTU:
        case UNORDERED:
        case ORDERED:
        case UNEQ:
        case UNGE:
        case UNGT:
        case UNLE:
        case UNLT:
          if (GET_CODE (x3) == EQ)
            {
              x10 = XEXP (x3, 0);
              switch (GET_CODE (x10))
                {
                case PLUS:
                  switch (pattern721 (x1, 
PLUS))
                    {
                    case 0:
                      if (((
#line 7725 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 7727 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                        return gen_split_152 (insn, operands);
                      break;

                    case 1:
                      if (((
#line 7725 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 7727 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                        return gen_split_153 (insn, operands);
                      break;

                    case 2:
                      if (((
#line 7771 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)
   && CONST_SCALAR_INT_P (operands[2])
   && rtx_equal_p (operands[2], operands[3])) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 7775 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                        return gen_split_154 (insn, operands);
                      break;

                    case 3:
                      if (((
#line 7771 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, TImode, operands, TARGET_APX_NDD)
   && CONST_SCALAR_INT_P (operands[2])
   && rtx_equal_p (operands[2], operands[3])) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 7775 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                        return gen_split_155 (insn, operands);
                      break;

                    default:
                      break;
                    }
                  break;

                case MINUS:
                  switch (pattern721 (x1, 
MINUS))
                    {
                    case 0:
                      if (((
#line 8497 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 8499 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                        return gen_split_192 (insn, operands);
                      break;

                    case 1:
                      if (((
#line 8497 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 8499 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                        return gen_split_193 (insn, operands);
                      break;

                    case 2:
                      if (((
#line 8541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)
   && CONST_SCALAR_INT_P (operands[2])
   && rtx_equal_p (operands[2], operands[3])) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 8545 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                        return gen_split_194 (insn, operands);
                      break;

                    case 3:
                      if (((
#line 8541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)
   && CONST_SCALAR_INT_P (operands[2])
   && rtx_equal_p (operands[2], operands[3])) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 8545 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                        return gen_split_195 (insn, operands);
                      break;

                    default:
                      break;
                    }
                  break;

                case ZERO_EXTRACT:
                  switch (pattern685 (x1))
                    {
                    case 0:
                      if ((
#line 19416 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 19418 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_848 (insn, operands);
                      break;

                    case 1:
                      if (((
#line 19416 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19418 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_849 (insn, operands);
                      break;

                    default:
                      break;
                    }
                  break;

                default:
                  break;
                }
            }
          operands[1] = x3;
          switch (pattern369 (x1))
            {
            case 0:
              if (!(
#line 19529 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL
   && TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)) && 
#line 19532 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_858 (insn, operands);

            case 1:
              if (!(
#line 19529 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL
   && TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)) && 
#line 19532 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_859 (insn, operands);

            default:
              return NULL;
            }

        case MINUS:
          x6 = XVECEXP (x1, 0, 1);
          if (pattern231 (x6, 
E_CCmode, 
17) != 0)
            return NULL;
          x10 = XEXP (x3, 0);
          switch (GET_CODE (x10))
            {
            case CONST_INT:
            case CONST_WIDE_INT:
            case CONST_POLY_INT:
            case CONST_FIXED:
            case CONST_DOUBLE:
            case CONST_VECTOR:
            case CONST:
            case REG:
            case SUBREG:
            case MEM:
            case LABEL_REF:
            case SYMBOL_REF:
            case HIGH:
              operands[1] = x10;
              res = split_16 (x1, insn);
              if (res != NULL_RTX)
                return res;
              if (GET_CODE (x10) != SUBREG)
                return NULL;
              switch (pattern1038 (x2))
                {
                case 0:
                  if (!(
#line 8260 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 8262 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_183 (insn, operands);

                case 1:
                  if (!(
#line 8260 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 8262 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_184 (insn, operands);

                case 2:
                  if (!((
#line 8260 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 8262 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_185 (insn, operands);

                case 3:
                  if (!
#line 8351 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed))
                    return NULL;
                  return gen_split_186 (insn, operands);

                case 4:
                  if (!
#line 8351 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed))
                    return NULL;
                  return gen_split_187 (insn, operands);

                case 5:
                  if (!(
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 8351 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_188 (insn, operands);

                default:
                  return NULL;
                }

            case MINUS:
              x13 = XEXP (x10, 1);
              if (GET_CODE (x13) != EQ)
                return NULL;
              x14 = XEXP (x13, 1);
              if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
                return NULL;
              x4 = XEXP (x2, 0);
              operands[0] = x4;
              x11 = XEXP (x10, 0);
              operands[1] = x11;
              x15 = XEXP (x13, 0);
              operands[3] = x15;
              if (!int_nonimmediate_operand (operands[3], E_VOIDmode))
                return NULL;
              x9 = XEXP (x3, 1);
              operands[2] = x9;
              switch (GET_MODE (operands[0]))
                {
                case E_QImode:
                  if (pattern1548 (x3, 
E_QImode) != 0
                      || !(
#line 10242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10245 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return NULL;
                  return gen_split_224 (insn, operands);

                case E_HImode:
                  if (pattern1548 (x3, 
E_HImode) != 0
                      || !(
#line 10242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10245 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return NULL;
                  return gen_split_225 (insn, operands);

                case E_SImode:
                  if (pattern1549 (x3, 
E_SImode) != 0
                      || !(
#line 10242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10245 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return NULL;
                  return gen_split_226 (insn, operands);

                case E_DImode:
                  if (pattern1549 (x3, 
E_DImode) != 0
                      || !((
#line 10242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 10245 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return NULL;
                  return gen_split_227 (insn, operands);

                default:
                  return NULL;
                }

            default:
              return NULL;
            }

        case IF_THEN_ELSE:
          x10 = XEXP (x3, 0);
          if (!bt_comparison_operator (x10, E_VOIDmode))
            return NULL;
          x13 = XEXP (x10, 1);
          if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return NULL;
          switch (pattern691 (x1))
            {
            case 0:
              x11 = XEXP (x10, 0);
              operands[2] = x11;
              x9 = XEXP (x3, 1);
              if (GET_CODE (x9) != PLUS)
                return NULL;
              x16 = XEXP (x9, 1);
              if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + -1])
                return NULL;
              x4 = XEXP (x2, 0);
              operands[0] = x4;
              operands[1] = x10;
              switch (pattern1559 (x3))
                {
                case 0:
                  if (!(
#line 8762 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE) && 
#line 8764 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_196 (insn, operands);

                case 1:
                  if (!(
#line 8762 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE) && 
#line 8764 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_197 (insn, operands);

                case 2:
                  if (!((
#line 8762 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 8764 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_198 (insn, operands);

                default:
                  return NULL;
                }

            case 1:
              x11 = XEXP (x10, 0);
              x17 = XEXP (x11, 1);
              if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                return NULL;
              switch (pattern1325 (x2))
                {
                case 0:
                  x18 = XEXP (x11, 2);
                  operands[2] = x18;
                  switch (pattern1669 (x3))
                    {
                    case 0:
                      if ((
#line 19221 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (CONST_INT_P (operands[2])
       ? (INTVAL (operands[2]) < GET_MODE_BITSIZE (SImode)
	  && INTVAL (operands[2])
	       >= (optimize_function_for_size_p (cfun) ? 8 : 32))
       : !memory_operand (operands[1], SImode))
   && ix86_pre_reload_split ()) && 
#line 19229 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_826 (insn, operands);
                      break;

                    case 1:
                      if (((
#line 19221 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (CONST_INT_P (operands[2])
       ? (INTVAL (operands[2]) < GET_MODE_BITSIZE (DImode)
	  && INTVAL (operands[2])
	       >= (optimize_function_for_size_p (cfun) ? 8 : 32))
       : !memory_operand (operands[1], DImode))
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19229 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_827 (insn, operands);
                      break;

                    default:
                      break;
                    }
                  if (GET_CODE (x18) != SUBREG)
                    return NULL;
                  switch (pattern1671 (x3))
                    {
                    case 0:
                      if (!(
#line 19297 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 19302 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_830 (insn, operands);

                    case 1:
                      if (!(
#line 19297 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 19302 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_832 (insn, operands);

                    case 2:
                      if (!((
#line 19297 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19302 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_834 (insn, operands);

                    case 3:
                      if (!((
#line 19297 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19302 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_831 (insn, operands);

                    case 4:
                      if (!((
#line 19297 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19302 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_833 (insn, operands);

                    case 5:
                      if (!((
#line 19297 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19302 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_835 (insn, operands);

                    default:
                      return NULL;
                    }

                case 1:
                  if (!(
#line 19260 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 19265 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return NULL;
                  return gen_split_828 (insn, operands);

                case 2:
                  if (!((
#line 19260 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19265 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return NULL;
                  return gen_split_829 (insn, operands);

                default:
                  return NULL;
                }

            default:
              return NULL;
            }

        case COMPARE:
          return split_23 (x1, insn);

        case AND:
          return split_21 (x1, insn);

        case IOR:
          return split_22 (x1, insn);

        case XOR:
          return split_20 (x1, insn);

        case NOT:
          x10 = XEXP (x3, 0);
          if (GET_CODE (x10) != XOR
              || pattern341 (x1) != 0)
            return NULL;
          switch (GET_MODE (operands[0]))
            {
            case E_HImode:
              if (pattern1318 (x3, 
E_HImode) != 0
                  || !(
#line 13621 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, HImode, operands, TARGET_APX_NDD)) && 
#line 13623 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_397 (insn, operands);

            case E_SImode:
              if (pattern1319 (x3, 
E_SImode) != 0
                  || !(
#line 13621 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, SImode, operands, TARGET_APX_NDD)) && 
#line 13623 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_398 (insn, operands);

            case E_DImode:
              if (pattern1319 (x3, 
E_DImode) != 0
                  || !((
#line 13621 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, DImode, operands, TARGET_APX_NDD)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13623 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_399 (insn, operands);

            case E_QImode:
              if (pattern1318 (x3, 
E_QImode) != 0
                  || !(
#line 13821 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, QImode, operands, TARGET_APX_NDD)) && 
#line 13823 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_405 (insn, operands);

            default:
              return NULL;
            }

        case NEG:
          return split_27 (x1, insn);

        case ABS:
          return split_29 (x1, insn);

        case ASHIFT:
          return split_26 (x1, insn);

        case LSHIFTRT:
          return split_28 (x1, insn);

        case ASHIFTRT:
          return split_31 (x1, insn);

        case ROTATE:
          return split_33 (x1, insn);

        case ROTATERT:
          return split_32 (x1, insn);

        case CTZ:
          switch (pattern408 (x1))
            {
            case 0:
              if (!
#line 21095 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_BMI || TARGET_CPU_P (GENERIC))
   && (TARGET_AVOID_FALSE_DEP_FOR_BMI || TARGET_AVOID_FALSE_DEP_FOR_TZCNT)
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1])))
                return NULL;
              return gen_split_879 (insn, operands);

            case 1:
              if (!(
#line 21095 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_BMI || TARGET_CPU_P (GENERIC))
   && (TARGET_AVOID_FALSE_DEP_FOR_BMI || TARGET_AVOID_FALSE_DEP_FOR_TZCNT)
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1])) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              return gen_split_880 (insn, operands);

            default:
              return NULL;
            }

        case SIGN_EXTEND:
          if (GET_MODE (x3) != E_DImode)
            return NULL;
          x6 = XVECEXP (x1, 0, 1);
          if (pattern353 (x6) != 0)
            return NULL;
          x4 = XEXP (x2, 0);
          operands[0] = x4;
          if (!register_operand (operands[0], E_DImode))
            return NULL;
          x10 = XEXP (x3, 0);
          if (GET_MODE (x10) != E_SImode)
            return NULL;
          switch (GET_CODE (x10))
            {
            case CTZ:
              x11 = XEXP (x10, 0);
              operands[1] = x11;
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !
#line 21203 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_BMI || TARGET_CPU_P (GENERIC))
   && (TARGET_AVOID_FALSE_DEP_FOR_BMI || TARGET_AVOID_FALSE_DEP_FOR_TZCNT)
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1])))
                return NULL;
              return gen_split_882 (insn, operands);

            case XOR:
              x11 = XEXP (x10, 0);
              if (GET_CODE (x11) != MINUS
                  || GET_MODE (x11) != E_SImode)
                return NULL;
              x19 = XEXP (x11, 0);
              if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 31])
                return NULL;
              x17 = XEXP (x11, 1);
              if (GET_CODE (x17) != CLZ
                  || GET_MODE (x17) != E_SImode)
                return NULL;
              x13 = XEXP (x10, 1);
              if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 31])
                return NULL;
              x20 = XEXP (x17, 0);
              operands[1] = x20;
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !(
#line 21365 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT && TARGET_64BIT && ix86_pre_reload_split ()) && 
#line 21367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_885 (insn, operands);

            default:
              return NULL;
            }

        case CLZ:
          switch (pattern408 (x1))
            {
            case 0:
              if (!(
#line 21536 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT) && 
#line 21538 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                return NULL;
              return gen_split_892 (insn, operands);

            case 1:
              if (!((
#line 21536 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21538 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                return NULL;
              return gen_split_893 (insn, operands);

            default:
              return NULL;
            }

        case UNSPEC:
          if (XVECLEN (x3, 0) != 1)
            return NULL;
          x6 = XVECEXP (x1, 0, 1);
          if (pattern231 (x6, 
E_CCmode, 
17) != 0)
            return NULL;
          x4 = XEXP (x2, 0);
          operands[0] = x4;
          x21 = XVECEXP (x3, 0, 0);
          operands[1] = x21;
          switch (XINT (x3, 1))
            {
            case 97:
              switch (pattern1327 (x3))
                {
                case 0:
                  if (!(
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 21700 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                    return NULL;
                  return gen_split_900 (insn, operands);

                case 1:
                  if (!((((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 21700 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                    return NULL;
                  return gen_split_902 (insn, operands);

                default:
                  return NULL;
                }

            case 96:
              switch (pattern1327 (x3))
                {
                case 0:
                  if (!(
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT) && 
#line 21700 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                    return NULL;
                  return gen_split_901 (insn, operands);

                case 1:
                  if (!((((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 21700 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                    return NULL;
                  return gen_split_903 (insn, operands);

                default:
                  return NULL;
                }

            default:
              return NULL;
            }

        case POPCOUNT:
          x6 = XVECEXP (x1, 0, 1);
          if (pattern353 (x6) != 0)
            return NULL;
          x4 = XEXP (x2, 0);
          operands[0] = x4;
          x10 = XEXP (x3, 0);
          switch (GET_CODE (x10))
            {
            case REG:
            case SUBREG:
            case MEM:
              operands[1] = x10;
              switch (pattern407 (x3))
                {
                case 0:
                  if (!(
#line 22343 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT) && 
#line 22351 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                    return NULL;
                  return gen_split_916 (insn, operands);

                case 1:
                  if (!((
#line 22343 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 22351 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                    return NULL;
                  return gen_split_917 (insn, operands);

                default:
                  return NULL;
                }

            case ZERO_EXTEND:
              if (pattern1164 (x3, 
E_HImode, 
E_SImode) != 0
                  || !(
#line 22513 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT
   && ix86_pre_reload_split ()) && 
#line 22516 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_920 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case SIMPLE_RETURN:
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != USE)
        return NULL;
      x22 = XEXP (x6, 0);
      operands[0] = x22;
      if (!const_int_operand (operands[0], E_SImode)
          || !(
#line 20689 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 20691 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( cfun->machine->function_return_type != indirect_branch_keep)))
        return NULL;
      return gen_split_874 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_68 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      switch (pattern533 (x2))
        {
        case 0:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1684 (insn, operands);

        case 1:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1711 (insn, operands);

        case 2:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1738 (insn, operands);

        case 3:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1765 (insn, operands);

        case 4:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1792 (insn, operands);

        case 5:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1819 (insn, operands);

        case 6:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1846 (insn, operands);

        case 7:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1873 (insn, operands);

        case 8:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1900 (insn, operands);

        case 9:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1927 (insn, operands);

        case 10:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1954 (insn, operands);

        case 11:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1981 (insn, operands);

        case 12:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1687 (insn, operands);

        case 13:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1714 (insn, operands);

        case 14:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1741 (insn, operands);

        case 15:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1768 (insn, operands);

        case 16:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1795 (insn, operands);

        case 17:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1822 (insn, operands);

        case 18:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1849 (insn, operands);

        case 19:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1876 (insn, operands);

        case 20:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1903 (insn, operands);

        case 21:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1930 (insn, operands);

        case 22:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1957 (insn, operands);

        case 23:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1984 (insn, operands);

        case 24:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1690 (insn, operands);

        case 25:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1717 (insn, operands);

        case 26:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1744 (insn, operands);

        case 27:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1771 (insn, operands);

        case 28:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1798 (insn, operands);

        case 29:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1825 (insn, operands);

        case 30:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1852 (insn, operands);

        case 31:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1879 (insn, operands);

        case 32:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1906 (insn, operands);

        case 33:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1933 (insn, operands);

        case 34:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1960 (insn, operands);

        case 35:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1987 (insn, operands);

        case 36:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2968 (insn, operands);

        case 37:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2977 (insn, operands);

        case 38:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2986 (insn, operands);

        case 39:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2995 (insn, operands);

        case 40:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3004 (insn, operands);

        case 41:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3013 (insn, operands);

        case 42:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3022 (insn, operands);

        case 43:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3031 (insn, operands);

        case 44:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3040 (insn, operands);

        case 45:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3049 (insn, operands);

        case 46:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3058 (insn, operands);

        case 47:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3067 (insn, operands);

        default:
          return NULL;
        }

    case AND:
      switch (pattern535 (x2))
        {
        case 0:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2332 (insn, operands);

        case 1:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2359 (insn, operands);

        case 2:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2386 (insn, operands);

        case 3:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2413 (insn, operands);

        case 4:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2440 (insn, operands);

        case 5:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2467 (insn, operands);

        case 6:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2494 (insn, operands);

        case 7:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2521 (insn, operands);

        case 8:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2548 (insn, operands);

        case 9:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2575 (insn, operands);

        case 10:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2602 (insn, operands);

        case 11:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2629 (insn, operands);

        default:
          return NULL;
        }

    case IOR:
      switch (pattern535 (x2))
        {
        case 0:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2335 (insn, operands);

        case 1:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2362 (insn, operands);

        case 2:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2389 (insn, operands);

        case 3:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2416 (insn, operands);

        case 4:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2443 (insn, operands);

        case 5:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2470 (insn, operands);

        case 6:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2497 (insn, operands);

        case 7:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2524 (insn, operands);

        case 8:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2551 (insn, operands);

        case 9:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2578 (insn, operands);

        case 10:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2605 (insn, operands);

        case 11:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2632 (insn, operands);

        default:
          return NULL;
        }

    case XOR:
      switch (pattern535 (x2))
        {
        case 0:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2338 (insn, operands);

        case 1:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2365 (insn, operands);

        case 2:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2392 (insn, operands);

        case 3:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2419 (insn, operands);

        case 4:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2446 (insn, operands);

        case 5:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2473 (insn, operands);

        case 6:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2500 (insn, operands);

        case 7:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2527 (insn, operands);

        case 8:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2554 (insn, operands);

        case 9:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2581 (insn, operands);

        case 10:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2608 (insn, operands);

        case 11:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2635 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_77 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case AND:
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
        case MEM:
        case NOT:
          switch (pattern537 (x2))
            {
            case 0:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1989 (insn, operands);

            case 1:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2016 (insn, operands);

            case 2:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2043 (insn, operands);

            case 3:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2070 (insn, operands);

            case 4:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2097 (insn, operands);

            case 5:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2124 (insn, operands);

            case 6:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2151 (insn, operands);

            case 7:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2178 (insn, operands);

            case 8:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2205 (insn, operands);

            case 9:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2232 (insn, operands);

            case 10:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2259 (insn, operands);

            case 11:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2286 (insn, operands);

            case 12:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1992 (insn, operands);

            case 13:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2019 (insn, operands);

            case 14:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2046 (insn, operands);

            case 15:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2073 (insn, operands);

            case 16:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2100 (insn, operands);

            case 17:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2127 (insn, operands);

            case 18:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2154 (insn, operands);

            case 19:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2181 (insn, operands);

            case 20:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2208 (insn, operands);

            case 21:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2235 (insn, operands);

            case 22:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2262 (insn, operands);

            case 23:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2289 (insn, operands);

            case 24:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1995 (insn, operands);

            case 25:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2022 (insn, operands);

            case 26:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2049 (insn, operands);

            case 27:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2076 (insn, operands);

            case 28:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2103 (insn, operands);

            case 29:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2130 (insn, operands);

            case 30:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2157 (insn, operands);

            case 31:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2184 (insn, operands);

            case 32:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2211 (insn, operands);

            case 33:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2238 (insn, operands);

            case 34:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2265 (insn, operands);

            case 35:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2292 (insn, operands);

            case 36:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3069 (insn, operands);

            case 37:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3078 (insn, operands);

            case 38:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3087 (insn, operands);

            case 39:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3096 (insn, operands);

            case 40:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3105 (insn, operands);

            case 41:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3114 (insn, operands);

            case 42:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3123 (insn, operands);

            case 43:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3132 (insn, operands);

            case 44:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3141 (insn, operands);

            case 45:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3150 (insn, operands);

            case 46:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3159 (insn, operands);

            case 47:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3168 (insn, operands);

            default:
              return NULL;
            }

        case AND:
          switch (pattern538 (x2))
            {
            case 0:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2637 (insn, operands);

            case 1:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2664 (insn, operands);

            case 2:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2691 (insn, operands);

            case 3:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2718 (insn, operands);

            case 4:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2745 (insn, operands);

            case 5:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2772 (insn, operands);

            case 6:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2799 (insn, operands);

            case 7:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2826 (insn, operands);

            case 8:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2853 (insn, operands);

            case 9:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2880 (insn, operands);

            case 10:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2907 (insn, operands);

            case 11:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2934 (insn, operands);

            default:
              return NULL;
            }

        case IOR:
          switch (pattern538 (x2))
            {
            case 0:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2640 (insn, operands);

            case 1:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2667 (insn, operands);

            case 2:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2694 (insn, operands);

            case 3:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2721 (insn, operands);

            case 4:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2748 (insn, operands);

            case 5:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2775 (insn, operands);

            case 6:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2802 (insn, operands);

            case 7:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2829 (insn, operands);

            case 8:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2856 (insn, operands);

            case 9:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2883 (insn, operands);

            case 10:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2910 (insn, operands);

            case 11:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2937 (insn, operands);

            default:
              return NULL;
            }

        case XOR:
          switch (pattern538 (x2))
            {
            case 0:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2643 (insn, operands);

            case 1:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2670 (insn, operands);

            case 2:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2697 (insn, operands);

            case 3:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2724 (insn, operands);

            case 4:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2751 (insn, operands);

            case 5:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2778 (insn, operands);

            case 6:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2805 (insn, operands);

            case 7:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2832 (insn, operands);

            case 8:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2859 (insn, operands);

            case 9:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2886 (insn, operands);

            case 10:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2913 (insn, operands);

            case 11:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2940 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case IOR:
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
        case MEM:
        case NOT:
          switch (pattern537 (x2))
            {
            case 0:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1998 (insn, operands);

            case 1:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2025 (insn, operands);

            case 2:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2052 (insn, operands);

            case 3:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2079 (insn, operands);

            case 4:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2106 (insn, operands);

            case 5:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2133 (insn, operands);

            case 6:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2160 (insn, operands);

            case 7:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2187 (insn, operands);

            case 8:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2214 (insn, operands);

            case 9:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2241 (insn, operands);

            case 10:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2268 (insn, operands);

            case 11:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2295 (insn, operands);

            case 12:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2001 (insn, operands);

            case 13:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2028 (insn, operands);

            case 14:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2055 (insn, operands);

            case 15:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2082 (insn, operands);

            case 16:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2109 (insn, operands);

            case 17:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2136 (insn, operands);

            case 18:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2163 (insn, operands);

            case 19:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2190 (insn, operands);

            case 20:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2217 (insn, operands);

            case 21:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2244 (insn, operands);

            case 22:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2271 (insn, operands);

            case 23:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2298 (insn, operands);

            case 24:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2004 (insn, operands);

            case 25:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2031 (insn, operands);

            case 26:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2058 (insn, operands);

            case 27:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2085 (insn, operands);

            case 28:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2112 (insn, operands);

            case 29:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2139 (insn, operands);

            case 30:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2166 (insn, operands);

            case 31:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2193 (insn, operands);

            case 32:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2220 (insn, operands);

            case 33:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2247 (insn, operands);

            case 34:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2274 (insn, operands);

            case 35:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2301 (insn, operands);

            case 36:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3072 (insn, operands);

            case 37:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3081 (insn, operands);

            case 38:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3090 (insn, operands);

            case 39:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3099 (insn, operands);

            case 40:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3108 (insn, operands);

            case 41:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3117 (insn, operands);

            case 42:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3126 (insn, operands);

            case 43:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3135 (insn, operands);

            case 44:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3144 (insn, operands);

            case 45:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3153 (insn, operands);

            case 46:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3162 (insn, operands);

            case 47:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3171 (insn, operands);

            default:
              return NULL;
            }

        case AND:
          switch (pattern538 (x2))
            {
            case 0:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2646 (insn, operands);

            case 1:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2673 (insn, operands);

            case 2:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2700 (insn, operands);

            case 3:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2727 (insn, operands);

            case 4:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2754 (insn, operands);

            case 5:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2781 (insn, operands);

            case 6:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2808 (insn, operands);

            case 7:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2835 (insn, operands);

            case 8:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2862 (insn, operands);

            case 9:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2889 (insn, operands);

            case 10:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2916 (insn, operands);

            case 11:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2943 (insn, operands);

            default:
              return NULL;
            }

        case IOR:
          switch (pattern538 (x2))
            {
            case 0:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2649 (insn, operands);

            case 1:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2676 (insn, operands);

            case 2:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2703 (insn, operands);

            case 3:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2730 (insn, operands);

            case 4:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2757 (insn, operands);

            case 5:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2784 (insn, operands);

            case 6:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2811 (insn, operands);

            case 7:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2838 (insn, operands);

            case 8:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2865 (insn, operands);

            case 9:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2892 (insn, operands);

            case 10:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2919 (insn, operands);

            case 11:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2946 (insn, operands);

            default:
              return NULL;
            }

        case XOR:
          switch (pattern538 (x2))
            {
            case 0:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2652 (insn, operands);

            case 1:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2679 (insn, operands);

            case 2:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2706 (insn, operands);

            case 3:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2733 (insn, operands);

            case 4:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2760 (insn, operands);

            case 5:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2787 (insn, operands);

            case 6:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2814 (insn, operands);

            case 7:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2841 (insn, operands);

            case 8:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2868 (insn, operands);

            case 9:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2895 (insn, operands);

            case 10:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2922 (insn, operands);

            case 11:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2949 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case XOR:
      return split_71 (x1, insn);

    default:
      return NULL;
    }
}
