/* do not edit automatically generated by mc from P3SymBuild.  */
/* P3SymBuild.mod pass 3 symbol creation.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#define _P3SymBuild_C

#include "GP3SymBuild.h"
#   include "GNameKey.h"
#   include "GStrIO.h"
#   include "GNumberIO.h"
#   include "GM2Debug.h"
#   include "GM2Error.h"
#   include "GM2LexBuf.h"
#   include "GSymbolTable.h"
#   include "GM2Batch.h"
#   include "GM2Quads.h"
#   include "GM2Comp.h"
#   include "GFifoQueue.h"
#   include "GM2Reserved.h"

extern "C" void P3SymBuild_P3StartBuildDefModule (void);
extern "C" void P3SymBuild_P3EndBuildDefModule (void);
extern "C" void P3SymBuild_P3StartBuildImpModule (void);
extern "C" void P3SymBuild_P3EndBuildImpModule (void);
extern "C" void P3SymBuild_P3StartBuildProgModule (void);
extern "C" void P3SymBuild_P3EndBuildProgModule (void);

/*
   CheckCanBeImported - checks to see that it is legal to import, Sym, from, ModSym.
*/

extern "C" void P3SymBuild_CheckCanBeImported (unsigned int ModSym, unsigned int Sym);

/*
   StartBuildInnerModule - Creates an Inner module and starts
                           a new scope.

                           The Stack is expected:

                           Entry                 Exit

                    Ptr ->                                     <- Ptr
                           +------------+        +-----------+
                           | NameStart  |        | NameStart |
                           |------------|        |-----------|

*/

extern "C" void P3SymBuild_StartBuildInnerModule (void);

/*
   EndBuildInnerModule - Destroys the Inner module scope and
                         checks for correct name.

                         The Stack is expected:

                         Entry                 Exit

                  Ptr ->
                         +------------+        +-----------+
                         | NameEnd    |        |           |
                         |------------|        |-----------|
                         | NameStart  |        |           | <- Ptr
                         |------------|        |-----------|
*/

extern "C" void P3SymBuild_EndBuildInnerModule (void);

/*
   CheckImportListOuterModule - checks to see that all identifiers are
                                exported from the definition module.

                                The Stack is expected:

                                Entry           OR    Entry

                         Ptr ->                Ptr ->
                                +------------+        +-----------+
                                | #          |        | #         |
                                |------------|        |-----------|
                                | Id1        |        | Id1       |
                                |------------|        |-----------|
                                .            .        .           .
                                .            .        .           .
                                .            .        .           .
                                |------------|        |-----------|
                                | Id#        |        | Id#       |
                                |------------|        |-----------|
                                | ImportTok  |        | Ident     |
                                |------------|        |-----------|

                                IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;


                                                      Error Condition
                                Exit

                                All above stack discarded
*/

extern "C" void P3SymBuild_CheckImportListOuterModule (void);

/*
   BuildProcedureHeading - Builds a procedure heading for the definition
                           module procedures.

                           Operation only performed if compiling a
                           definition module.

                           The Stack:

                           Entry                       Exit

                    Ptr ->
                           +------------+
                           | ProcSym    |
                           |------------|
                           | NameStart  |
                           |------------|
                                                       Empty

*/

extern "C" void P3SymBuild_BuildProcedureHeading (void);

/*
   StartBuildProcedure - Builds a Procedure.

                         The Stack:

                         Entry                 Exit

                                                              <- Ptr
                                               +------------+
                  Ptr ->                       | ProcSym    |
                         +------------+        |------------|
                         | Name       |        | Name       |
                         |------------|        |------------|
*/

extern "C" void P3SymBuild_StartBuildProcedure (void);

/*
   EndBuildProcedure - Ends building a Procedure.
                       It checks the start procedure name matches the end
                       procedure name.

                       The Stack:

                       (Procedure Not Defined in definition module)

                       Entry                 Exit

                Ptr ->
                       +------------+
                       | NameEnd    |
                       |------------|
                       | ProcSym    |
                       |------------|
                       | NameStart  |
                       |------------|
                                             Empty
*/

extern "C" void P3SymBuild_EndBuildProcedure (void);

/*
   EndBuildForward -
*/

extern "C" void P3SymBuild_EndBuildForward (void);

/*
   BuildSubrange - Builds a Subrange type Symbol.


                      Stack

                      Entry                 Exit

               Ptr ->
                      +------------+
                      | High       |
                      |------------|
                      | Low        |                       <- Ptr
                      |------------|
*/

extern "C" void P3SymBuild_BuildSubrange (void);

/*
   BuildNulName - Pushes a NulKey onto the top of the stack.
                  The Stack:


                  Entry                    Exit

                                                          <- Ptr
                  Empty                    +------------+
                                           | NulKey     |
                                           |------------|
*/

extern "C" void P3SymBuild_BuildNulName (void);

/*
   BuildConst - builds a constant.
                Stack

                Entry                 Exit

         Ptr ->                                      <- Ptr
                +------------+        +------------+
                | Name       |        | Sym        |
                |------------+        |------------|
*/

extern "C" void P3SymBuild_BuildConst (void);

/*
   BuildVarAtAddress - updates the symbol table entry of, variable sym, to be declared
                       at address, address.

                       Stack

                       Entry                 Exit

                Ptr ->
                       +--------------+
                       | Expr | EType |                         <- Ptr
                       |--------------+        +--------------+
                       | name | SType |        | name | SType |
                       |--------------+        |--------------|
*/

extern "C" void P3SymBuild_BuildVarAtAddress (void);

/*
   BuildOptArgInitializer - assigns the constant value symbol, const, to be the
                            initial value of the optional parameter should it be
                            absent.

                            Ptr ->
                                   +------------+
                                   | const      |
                                   |------------|                      <- Ptr
*/

extern "C" void P3SymBuild_BuildOptArgInitializer (void);

extern "C" void P3SymBuild_P3StartBuildDefModule (void)
{
  unsigned int tok;
  NameKey_Name name;
  unsigned int ModuleSym;

  /* 
   StartBuildDefinitionModule - Creates a definition module and starts
                                a new scope.

                                The Stack is expected:

                                Entry                 Exit

                         Ptr ->                                     <- Ptr
                                +------------+        +-----------+
                                | NameStart  |        | NameStart |
                                |------------|        |-----------|

  */
  M2Quads_PopTtok (&name, &tok);
  ModuleSym = M2Batch_MakeDefinitionSource (tok, name);
  SymbolTable_SetCurrentModule (ModuleSym);
  SymbolTable_SetFileModule (ModuleSym);
  SymbolTable_StartScope (ModuleSym);
  M2Debug_Assert (SymbolTable_IsDefImp (ModuleSym));
  M2Debug_Assert (M2Comp_CompilingDefinitionModule ());
  M2Quads_PushT (name);
  M2Error_EnterDefinitionScope (name);
}

extern "C" void P3SymBuild_P3EndBuildDefModule (void)
{
  unsigned int NameStart;
  unsigned int NameEnd;

  /* 
   EndBuildDefinitionModule - Destroys the definition module scope and
                              checks for correct name.

                              The Stack is expected:

                              Entry                 Exit

                       Ptr ->
                              +------------+        +-----------+
                              | NameEnd    |        |           |
                              |------------|        |-----------|
                              | NameStart  |        |           | <- Ptr
                              |------------|        |-----------|
  */
  M2Debug_Assert (M2Comp_CompilingDefinitionModule ());
  SymbolTable_CheckForUnknownInModule ();
  SymbolTable_EndScope ();
  M2Quads_PopT (&NameEnd);
  M2Quads_PopT (&NameStart);
  if (NameStart != NameEnd)
    {
      M2Error_WriteFormat2 ((const char *) "inconsistent definition module was named (%a) and concluded as (%a)", 67, (const unsigned char *) &NameStart, (sizeof (NameStart)-1), (const unsigned char *) &NameEnd, (sizeof (NameEnd)-1));
    }
  M2Error_LeaveErrorScope ();
}

extern "C" void P3SymBuild_P3StartBuildImpModule (void)
{
  unsigned int tok;
  NameKey_Name name;
  unsigned int ModuleSym;

  /* 
   StartBuildImplementationModule - Creates an implementation module and starts
                                    a new scope.

                                    The Stack is expected:

                                    Entry                 Exit

                             Ptr ->                                     <- Ptr
                                    +------------+        +-----------+
                                    | NameStart  |        | NameStart |
                                    |------------|        |-----------|

  */
  M2Quads_PopTtok (&name, &tok);
  ModuleSym = M2Batch_MakeImplementationSource (tok, name);
  SymbolTable_SetCurrentModule (ModuleSym);
  SymbolTable_SetFileModule (ModuleSym);
  SymbolTable_StartScope (ModuleSym);
  M2Debug_Assert (SymbolTable_IsDefImp (ModuleSym));
  M2Debug_Assert (M2Comp_CompilingImplementationModule ());
  M2Quads_PushT (name);
  M2Error_EnterImplementationScope (name);
}

extern "C" void P3SymBuild_P3EndBuildImpModule (void)
{
  NameKey_Name NameStart;
  NameKey_Name NameEnd;

  /* 
   EndBuildImplementationModule - Destroys the implementation module scope and
                                  checks for correct name.

                                  The Stack is expected:

                                  Entry                 Exit

                           Ptr ->
                                  +------------+        +-----------+
                                  | NameEnd    |        |           |
                                  |------------|        |-----------|
                                  | NameStart  |        |           | <- Ptr
                                  |------------|        |-----------|
  */
  M2Debug_Assert (M2Comp_CompilingImplementationModule ());
  SymbolTable_CheckForUnknownInModule ();
  SymbolTable_EndScope ();
  M2Quads_PopT (&NameEnd);
  M2Quads_PopT (&NameStart);
  if (NameStart != NameEnd)
    {
      /* we dont issue an error based around incorrect module names as this is done in P1 and P2.
         If we get here then something has gone wrong with our error recovery in P3, so we bail out.
  */
      M2Error_WriteFormat0 ((const char *) "too many errors in pass 3", 25);
      M2Error_FlushErrors ();
    }
  M2Error_LeaveErrorScope ();
}

extern "C" void P3SymBuild_P3StartBuildProgModule (void)
{
  unsigned int tok;
  NameKey_Name name;
  unsigned int ModuleSym;

  /* WriteString('StartBuildProgramModule') ; WriteLn ;  */
  M2Quads_PopTtok (&name, &tok);
  ModuleSym = M2Batch_MakeProgramSource (tok, name);
  SymbolTable_SetCurrentModule (ModuleSym);
  SymbolTable_SetFileModule (ModuleSym);
  /* WriteString('MODULE - ') ; WriteKey(GetSymName(ModuleSym)) ; WriteLn ;  */
  SymbolTable_StartScope (ModuleSym);
  M2Debug_Assert (M2Comp_CompilingProgramModule ());
  M2Debug_Assert (! (SymbolTable_IsDefImp (ModuleSym)));
  M2Quads_PushT (name);
  M2Error_EnterProgramScope (name);
}

extern "C" void P3SymBuild_P3EndBuildProgModule (void)
{
  NameKey_Name NameStart;
  NameKey_Name NameEnd;

  /* 
   EndBuildProgramModule - Destroys the program module scope and
                           checks for correct name.

                           The Stack is expected:

                           Entry                 Exit

                    Ptr ->
                           +------------+        +-----------+
                           | NameEnd    |        |           |
                           |------------|        |-----------|
                           | NameStart  |        |           | <- Ptr
                           |------------|        |-----------|
  */
  M2Debug_Assert (M2Comp_CompilingProgramModule ());
  SymbolTable_CheckForUnknownInModule ();
  SymbolTable_EndScope ();
  M2Quads_PopT (&NameEnd);
  M2Quads_PopT (&NameStart);
  if (NameStart != NameEnd)
    {
      /* we dont issue an error based around incorrect module names this would be done in P1 and P2.
         If we get here then something has gone wrong with our error recovery in P3, so we bail out.
  */
      M2Error_WriteFormat0 ((const char *) "too many errors in pass 3", 25);
      M2Error_FlushErrors ();
    }
  M2Error_LeaveErrorScope ();
}


/*
   CheckCanBeImported - checks to see that it is legal to import, Sym, from, ModSym.
*/

extern "C" void P3SymBuild_CheckCanBeImported (unsigned int ModSym, unsigned int Sym)
{
  NameKey_Name n1;
  NameKey_Name n2;

  if (SymbolTable_IsDefImp (ModSym))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (SymbolTable_IsExported (ModSym, Sym))
        {
          /* great all done  */
          return;
        }
      else
        {
          if (SymbolTable_IsImplicityExported (ModSym, Sym))
            {
              /* this is also legal  */
              return;
            }
          else if ((SymbolTable_IsDefImp (Sym)) && (SymbolTable_IsIncludedByDefinition (ModSym, Sym)))
            {
              /* avoid dangling else.  */
              /* this is also legal (for a definition module)  */
              return;
            }
          n1 = SymbolTable_GetSymName (ModSym);
          n2 = SymbolTable_GetSymName (Sym);
          M2Error_WriteFormat2 ((const char *) "symbol %a is not exported from definition module %a", 51, (const unsigned char *) &n2, (sizeof (n2)-1), (const unsigned char *) &n1, (sizeof (n1)-1));
        }
    }
}


/*
   StartBuildInnerModule - Creates an Inner module and starts
                           a new scope.

                           The Stack is expected:

                           Entry                 Exit

                    Ptr ->                                     <- Ptr
                           +------------+        +-----------+
                           | NameStart  |        | NameStart |
                           |------------|        |-----------|

*/

extern "C" void P3SymBuild_StartBuildInnerModule (void)
{
  NameKey_Name name;
  unsigned int tok;
  unsigned int ModuleSym;

  M2Quads_PopTtok (&name, &tok);
  ModuleSym = SymbolTable_RequestSym (tok, name);
  M2Debug_Assert (SymbolTable_IsModule (ModuleSym));
  SymbolTable_StartScope (ModuleSym);
  M2Debug_Assert (! (SymbolTable_IsDefImp (ModuleSym)));
  SymbolTable_SetCurrentModule (ModuleSym);
  M2Quads_PushT (name);
  M2Error_EnterModuleScope (name);
}


/*
   EndBuildInnerModule - Destroys the Inner module scope and
                         checks for correct name.

                         The Stack is expected:

                         Entry                 Exit

                  Ptr ->
                         +------------+        +-----------+
                         | NameEnd    |        |           |
                         |------------|        |-----------|
                         | NameStart  |        |           | <- Ptr
                         |------------|        |-----------|
*/

extern "C" void P3SymBuild_EndBuildInnerModule (void)
{
  NameKey_Name NameStart;
  NameKey_Name NameEnd;

  SymbolTable_CheckForUnknownInModule ();
  SymbolTable_EndScope ();
  M2Quads_PopT (&NameEnd);
  M2Quads_PopT (&NameStart);
  if (NameStart != NameEnd)
    {
      /* we dont issue an error based around incorrect module names this would be done in P1 and P2.
         If we get here then something has gone wrong with our error recovery in P3, so we bail out.
  */
      M2Error_WriteFormat0 ((const char *) "too many errors in pass 3", 25);
      M2Error_FlushErrors ();
    }
  SymbolTable_SetCurrentModule (SymbolTable_GetModuleScope (SymbolTable_GetCurrentModule ()));
  M2Error_LeaveErrorScope ();
}


/*
   CheckImportListOuterModule - checks to see that all identifiers are
                                exported from the definition module.

                                The Stack is expected:

                                Entry           OR    Entry

                         Ptr ->                Ptr ->
                                +------------+        +-----------+
                                | #          |        | #         |
                                |------------|        |-----------|
                                | Id1        |        | Id1       |
                                |------------|        |-----------|
                                .            .        .           .
                                .            .        .           .
                                .            .        .           .
                                |------------|        |-----------|
                                | Id#        |        | Id#       |
                                |------------|        |-----------|
                                | ImportTok  |        | Ident     |
                                |------------|        |-----------|

                                IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;


                                                      Error Condition
                                Exit

                                All above stack discarded
*/

extern "C" void P3SymBuild_CheckImportListOuterModule (void)
{
  NameKey_Name n1;
  NameKey_Name n2;
  unsigned int tok;
  unsigned int ModSym;
  unsigned int i;
  unsigned int n;

  M2Quads_PopT (&n);  /* n   = # of the Ident List  */
  if ((M2Quads_OperandT (n+1)) != M2Reserved_ImportTok)
    {
      /* Ident List contains list of objects  */
      ModSym = M2Batch_LookupOuterModule (M2Quads_OperandTok (n+1), M2Quads_OperandT (n+1));
      i = 1;
      while (i <= n)
        {
          tok = static_cast<unsigned int> (M2Quads_OperandTok (i));
          if ((! (SymbolTable_IsExported (ModSym, SymbolTable_RequestSym (tok, M2Quads_OperandT (i))))) && (! (SymbolTable_IsImplicityExported (ModSym, SymbolTable_RequestSym (tok, M2Quads_OperandT (i))))))
            {
              n1 = static_cast<NameKey_Name> (M2Quads_OperandT (n+1));
              n2 = static_cast<NameKey_Name> (M2Quads_OperandT (i));
              M2Error_WriteFormat2 ((const char *) "symbol %a is not exported from definition or inner module %a", 60, (const unsigned char *) &n2, (sizeof (n2)-1), (const unsigned char *) &n1, (sizeof (n1)-1));
            }
          i += 1;
        }
    }
  M2Quads_PopN (n+1);  /* clear stack  */
}


/*
   BuildProcedureHeading - Builds a procedure heading for the definition
                           module procedures.

                           Operation only performed if compiling a
                           definition module.

                           The Stack:

                           Entry                       Exit

                    Ptr ->
                           +------------+
                           | ProcSym    |
                           |------------|
                           | NameStart  |
                           |------------|
                                                       Empty

*/

extern "C" void P3SymBuild_BuildProcedureHeading (void)
{
  unsigned int ProcSym;
  NameKey_Name NameStart;

  if (M2Comp_CompilingDefinitionModule ())
    {
      M2Quads_PopT (&ProcSym);
      M2Quads_PopT (&NameStart);
      SymbolTable_EndScope ();
    }
}


/*
   StartBuildProcedure - Builds a Procedure.

                         The Stack:

                         Entry                 Exit

                                                              <- Ptr
                                               +------------+
                  Ptr ->                       | ProcSym    |
                         +------------+        |------------|
                         | Name       |        | Name       |
                         |------------|        |------------|
*/

extern "C" void P3SymBuild_StartBuildProcedure (void)
{
  unsigned int tok;
  NameKey_Name name;
  unsigned int ProcSym;

  M2Quads_PopTtok (&name, &tok);
  M2Quads_PushTtok (name, tok);  /* Name saved for the EndBuildProcedure name check  */
  ProcSym = SymbolTable_RequestSym (tok, name);  /* Name saved for the EndBuildProcedure name check  */
  M2Debug_Assert (SymbolTable_IsProcedure (ProcSym));
  M2Quads_PushTtok (ProcSym, tok);
  SymbolTable_StartScope (ProcSym);
  M2Error_EnterProcedureScope (name);
}


/*
   EndBuildProcedure - Ends building a Procedure.
                       It checks the start procedure name matches the end
                       procedure name.

                       The Stack:

                       (Procedure Not Defined in definition module)

                       Entry                 Exit

                Ptr ->
                       +------------+
                       | NameEnd    |
                       |------------|
                       | ProcSym    |
                       |------------|
                       | NameStart  |
                       |------------|
                                             Empty
*/

extern "C" void P3SymBuild_EndBuildProcedure (void)
{
  unsigned int ProcSym;
  NameKey_Name NameEnd;
  NameKey_Name NameStart;

  M2Quads_PopT (&NameEnd);
  M2Quads_PopT (&ProcSym);
  M2Quads_PopT (&NameStart);
  if (NameEnd != NameStart)
    {
      /* we dont issue an error based around incorrect module names this would be done in P1 and P2.
         If we get here then something has gone wrong with our error recovery in P3, so we bail out.
  */
      M2Error_WriteFormat0 ((const char *) "too many errors in pass 3", 25);
      M2Error_FlushErrors ();
    }
  SymbolTable_EndScope ();
  M2Error_LeaveErrorScope ();
}


/*
   EndBuildForward -
*/

extern "C" void P3SymBuild_EndBuildForward (void)
{
  M2Quads_PopN (2);
  SymbolTable_EndScope ();
  M2Error_LeaveErrorScope ();
}


/*
   BuildSubrange - Builds a Subrange type Symbol.


                      Stack

                      Entry                 Exit

               Ptr ->
                      +------------+
                      | High       |
                      |------------|
                      | Low        |                       <- Ptr
                      |------------|
*/

extern "C" void P3SymBuild_BuildSubrange (void)
{
  unsigned int Base;
  unsigned int Type;
  unsigned int Low;
  unsigned int High;

  M2Quads_PopT (&High);
  M2Quads_PopT (&Low);
  FifoQueue_GetSubrangeFromFifoQueue (&Type);  /* Collect subrange type from pass 2 and fill in  */
  /* bounds.  */
  FifoQueue_GetSubrangeFromFifoQueue (&Base);  /* Get base of subrange (maybe NulSym)  */
  /* worked out later in M2GCCDeclare  */
  SymbolTable_PutSubrange (Type, Low, High, Base);
}


/*
   BuildNulName - Pushes a NulKey onto the top of the stack.
                  The Stack:


                  Entry                    Exit

                                                          <- Ptr
                  Empty                    +------------+
                                           | NulKey     |
                                           |------------|
*/

extern "C" void P3SymBuild_BuildNulName (void)
{
  M2Quads_PushT (static_cast<unsigned int> (NameKey_NulName));
}


/*
   BuildConst - builds a constant.
                Stack

                Entry                 Exit

         Ptr ->                                      <- Ptr
                +------------+        +------------+
                | Name       |        | Sym        |
                |------------+        |------------|
*/

extern "C" void P3SymBuild_BuildConst (void)
{
  NameKey_Name name;
  unsigned int tok;
  unsigned int Sym;

  M2Quads_PopTtok (&name, &tok);
  Sym = SymbolTable_RequestSym (tok, name);
  M2Quads_PushTtok (Sym, tok);
}


/*
   BuildVarAtAddress - updates the symbol table entry of, variable sym, to be declared
                       at address, address.

                       Stack

                       Entry                 Exit

                Ptr ->
                       +--------------+
                       | Expr | EType |                         <- Ptr
                       |--------------+        +--------------+
                       | name | SType |        | name | SType |
                       |--------------+        |--------------|
*/

extern "C" void P3SymBuild_BuildVarAtAddress (void)
{
  unsigned int nametok;
  NameKey_Name name;
  unsigned int Sym;
  unsigned int SType;
  unsigned int Exp;
  unsigned int EType;

  M2Quads_PopTF (&Exp, &EType);
  M2Quads_PopTFtok (&name, &SType, &nametok);
  M2Quads_PushTF (name, SType);
  Sym = SymbolTable_RequestSym (nametok, name);
  if ((SymbolTable_GetMode (Sym)) == SymbolTable_LeftValue)
    {
      SymbolTable_PutVariableAtAddress (Sym, Exp);
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting lvalue for this variable which is declared at an explicit address", 75);
    }
}


/*
   BuildOptArgInitializer - assigns the constant value symbol, const, to be the
                            initial value of the optional parameter should it be
                            absent.

                            Ptr ->
                                   +------------+
                                   | const      |
                                   |------------|                      <- Ptr
*/

extern "C" void P3SymBuild_BuildOptArgInitializer (void)
{
  unsigned int tok;
  unsigned int const_;
  unsigned int ProcSym;

  M2Quads_PopT (&const_);
  M2Quads_PopTtok (&ProcSym, &tok);
  M2Debug_Assert (SymbolTable_IsProcedure (ProcSym));
  M2Quads_PushTtok (ProcSym, tok);
  SymbolTable_PutOptArgInit (SymbolTable_GetCurrentScope (), const_);
}

extern "C" void _M2_P3SymBuild_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_P3SymBuild_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
