/* do not edit automatically generated by mc from P0SymBuild.  */
/* P0SymBuild.mod pass 0 symbol creation.

Copyright (C) 2011-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _P0SymBuild_C

#include "GP0SymBuild.h"
#   include "GStorage.h"
#   include "GM2Printf.h"
#   include "GLists.h"
#   include "GIndexing.h"
#   include "GM2Batch.h"
#   include "GSymbolTable.h"
#   include "GNameKey.h"
#   include "GM2Quads.h"
#   include "GM2Reserved.h"
#   include "GM2Debug.h"
#   include "GM2MetaError.h"
#   include "GM2LexBuf.h"
#   include "GM2Error.h"
#   include "GM2RTS.h"

#   define Debugging false
typedef struct P0SymBuild__T1_r P0SymBuild__T1;

typedef P0SymBuild__T1 *P0SymBuild_BlockInfoPtr;

typedef struct P0SymBuild__T2_r P0SymBuild__T2;

typedef P0SymBuild__T2 *P0SymBuild_ModuleDesc;

typedef enum {P0SymBuild_module, P0SymBuild_program, P0SymBuild_defimp, P0SymBuild_inner, P0SymBuild_procedure, P0SymBuild_universe, P0SymBuild_unknown} P0SymBuild_Kind;

struct P0SymBuild__T1_r {
                          NameKey_Name name;
                          P0SymBuild_Kind kind;
                          unsigned int sym;
                          int level;
                          unsigned int token;
                          Lists_List LocalModules;
                          Indexing_Index ImportedModules;
                          P0SymBuild_BlockInfoPtr toPC;
                          P0SymBuild_BlockInfoPtr toReturn;
                          P0SymBuild_BlockInfoPtr toNext;
                          P0SymBuild_BlockInfoPtr toUp;
                          P0SymBuild_BlockInfoPtr toDown;
                        };

struct P0SymBuild__T2_r {
                          NameKey_Name name;
                          unsigned int tok;
                        };

static P0SymBuild_BlockInfoPtr headBP;
static P0SymBuild_BlockInfoPtr curBP;
static int Level;

/*
   EndModule -
*/

extern "C" void P0SymBuild_EndModule (void);

/*
   RegisterImports -
*/

extern "C" void P0SymBuild_RegisterImports (void);

/*
   RegisterProgramModule - register the top of stack as a program module.
*/

extern "C" void P0SymBuild_RegisterProgramModule (void);

/*
   RegisterImplementationModule - register the top of stack as an implementation module.
*/

extern "C" void P0SymBuild_RegisterImplementationModule (void);

/*
   RegisterDefinitionModule - register the top of stack as a definition module.
*/

extern "C" void P0SymBuild_RegisterDefinitionModule (bool forC);

/*
   RegisterInnerModule - register the top of stack as an inner module, this module name
                         will be removed from the list of outstanding imports in the
                         current module block.
*/

extern "C" void P0SymBuild_RegisterInnerModule (void);

/*
   RegisterInnerImports -
*/

extern "C" void P0SymBuild_RegisterInnerImports (void);

/*
   RegisterProcedure - register the top of stack as a procedure.
*/

extern "C" void P0SymBuild_RegisterProcedure (void);
extern "C" void P0SymBuild_EndProcedure (void);

/*
   EndForward - ends building a forward procedure.
*/

extern "C" void P0SymBuild_EndForward (void);

/*
   P0Init -
*/

extern "C" void P0SymBuild_P0Init (void);

/*
   P1Init -
*/

extern "C" void P0SymBuild_P1Init (void);

/*
   EnterBlock -
*/

extern "C" void P0SymBuild_EnterBlock (NameKey_Name n);

/*
   LeaveBlock -
*/

extern "C" void P0SymBuild_LeaveBlock (void);

/*
   nSpaces -
*/

static void nSpaces (unsigned int n);

/*
   DisplayB -
*/

static void DisplayB (P0SymBuild_BlockInfoPtr b);

/*
   DisplayBlock -
*/

static void DisplayBlock (P0SymBuild_BlockInfoPtr b, unsigned int l);

/*
   Display -
*/

static void Display (void);

/*
   addDown - adds, b, to the down link of, a.
*/

static void addDown (P0SymBuild_BlockInfoPtr a, P0SymBuild_BlockInfoPtr b);

/*
   GraftBlock - add a new block, b, into the tree in the correct order.
*/

static void GraftBlock (P0SymBuild_BlockInfoPtr b);

/*
   BeginBlock - denotes the start of the next block.  We remember all imports and
                local modules and procedures created in this block.
*/

static void BeginBlock (NameKey_Name n, P0SymBuild_Kind k, unsigned int s, unsigned int tok);

/*
   InitUniverse -
*/

static void InitUniverse (void);

/*
   FlushImports -
*/

static void FlushImports (P0SymBuild_BlockInfoPtr b);

/*
   EndBlock - shutdown the module and create definition symbols for all imported
              modules.
*/

static void EndBlock (void);

/*
   RegisterLocalModule - register, n, as a local module.
*/

static void RegisterLocalModule (NameKey_Name modname);

/*
   RegisterImport - register, n, as a module imported from either a local scope or definition module.
*/

static void RegisterImport (unsigned int tok, NameKey_Name modname);

/*
   DeclareModules - declare all inner modules seen at the current block level.
*/

static void DeclareModules (void);

/*
   Move -
*/

static void Move (void);


/*
   nSpaces -
*/

static void nSpaces (unsigned int n)
{
  while (n > 0)
    {
      M2Printf_printf0 ((const char *) " ", 1);
      n -= 1;
    }
}


/*
   DisplayB -
*/

static void DisplayB (P0SymBuild_BlockInfoPtr b)
{
  switch (b->kind)
    {
      case P0SymBuild_program:
        M2Printf_printf1 ((const char *) "MODULE %a ;\\n", 13, (const unsigned char *) &b->name, (sizeof (b->name)-1));
        break;

      case P0SymBuild_defimp:
        M2Printf_printf1 ((const char *) "DEFIMP %a ;\\n", 13, (const unsigned char *) &b->name, (sizeof (b->name)-1));
        break;

      case P0SymBuild_inner:
        M2Printf_printf1 ((const char *) "INNER MODULE %a ;\\n", 19, (const unsigned char *) &b->name, (sizeof (b->name)-1));
        break;

      case P0SymBuild_procedure:
        M2Printf_printf1 ((const char *) "PROCEDURE %a ;\\n", 16, (const unsigned char *) &b->name, (sizeof (b->name)-1));
        break;


      default:
        M2RTS_HALT (-1);
        __builtin_unreachable ();
        break;
    }
}


/*
   DisplayBlock -
*/

static void DisplayBlock (P0SymBuild_BlockInfoPtr b, unsigned int l)
{
  P0SymBuild_BlockInfoPtr a;

  nSpaces (l);
  DisplayB (b);
  a = b->toDown;
  l += 3;
  while (a != NULL)
    {
      DisplayBlock (a, l);
      a = a->toNext;
    }
  l -= 3;
  nSpaces (l);
  M2Printf_printf1 ((const char *) "END %a\\n", 8, (const unsigned char *) &b->name, (sizeof (b->name)-1));
}


/*
   Display -
*/

static void Display (void)
{
  P0SymBuild_BlockInfoPtr b;

  M2Printf_printf0 ((const char *) "Universe of Modula-2 modules\\n", 30);
  if (headBP != NULL)
    {
      b = headBP->toDown;
      while (b != NULL)
        {
          DisplayBlock (b, 0);
          b = b->toNext;
        }
    }
}


/*
   addDown - adds, b, to the down link of, a.
*/

static void addDown (P0SymBuild_BlockInfoPtr a, P0SymBuild_BlockInfoPtr b)
{
  if (a->toDown == NULL)
    {
      a->toDown = b;
    }
  else
    {
      a = a->toDown;
      while (a->toNext != NULL)
        {
          a = a->toNext;
        }
      a->toNext = b;
    }
}


/*
   GraftBlock - add a new block, b, into the tree in the correct order.
*/

static void GraftBlock (P0SymBuild_BlockInfoPtr b)
{
  M2Debug_Assert (curBP != NULL);
  M2Debug_Assert (abs (Level-curBP->level) <= 1);
  switch (Level-curBP->level)
    {
      case -1:
        curBP = curBP->toUp;  /* returning up to the outer scope  */
        M2Debug_Assert (curBP->toNext == NULL);
        curBP->toNext = b;
        break;

      case 0:
        M2Debug_Assert (curBP->toNext == NULL);  /* add toNext  */
        curBP->toNext = b;
        b->toUp = curBP->toUp;
        break;

      case 1:
        b->toUp = curBP;  /* save return value  */
        addDown (curBP, b);  /* save return value  */
        break;


      default:
        M2RTS_HALT (-1);
        __builtin_unreachable ();
        break;
    }
  curBP = b;
}


/*
   BeginBlock - denotes the start of the next block.  We remember all imports and
                local modules and procedures created in this block.
*/

static void BeginBlock (NameKey_Name n, P0SymBuild_Kind k, unsigned int s, unsigned int tok)
{
  P0SymBuild_BlockInfoPtr b;

  Storage_ALLOCATE ((void **) &b, sizeof (P0SymBuild__T1));
  b->name = n;
  b->kind = k;
  b->sym = s;
  Lists_InitList (&b->LocalModules);
  b->ImportedModules = Indexing_InitIndex (1);
  b->toPC = NULL;
  b->toReturn = NULL;
  b->toNext = NULL;
  b->toDown = NULL;
  b->toUp = NULL;
  b->level = Level;
  b->token = tok;
  GraftBlock (b);
}


/*
   InitUniverse -
*/

static void InitUniverse (void)
{
  Storage_ALLOCATE ((void **) &curBP, sizeof (P0SymBuild__T1));
  curBP->name = NameKey_NulName;
  curBP->kind = P0SymBuild_universe;
  curBP->sym = SymbolTable_NulSym;
  Lists_InitList (&curBP->LocalModules);
  curBP->ImportedModules = Indexing_InitIndex (1);
  curBP->toNext = NULL;
  curBP->toDown = NULL;
  curBP->toUp = curBP;
  curBP->level = Level;
  headBP = curBP;
}


/*
   FlushImports -
*/

static void FlushImports (P0SymBuild_BlockInfoPtr b)
{
  unsigned int i;
  unsigned int n;
  P0SymBuild_ModuleDesc desc;

  i = Indexing_LowIndice (b->ImportedModules);
  n = Indexing_HighIndice (b->ImportedModules);
  while (i <= n)
    {
      desc = static_cast<P0SymBuild_ModuleDesc> (Indexing_GetIndice (b->ImportedModules, i));
      b->sym = M2Batch_MakeDefinitionSource (desc->tok, desc->name);
      M2Debug_Assert (b->sym != SymbolTable_NulSym);
      i += 1;
    }
}


/*
   EndBlock - shutdown the module and create definition symbols for all imported
              modules.
*/

static void EndBlock (void)
{
  FlushImports (curBP);
  curBP = curBP->toUp;
  Level -= 1;
  if (Level == 0)
    {
      FlushImports (curBP);
    }
}


/*
   RegisterLocalModule - register, n, as a local module.
*/

static void RegisterLocalModule (NameKey_Name modname)
{
  unsigned int i;
  unsigned int n;
  P0SymBuild_ModuleDesc desc;

  /* printf1('seen local module %a
  ', n) ;  */
  Lists_IncludeItemIntoList (curBP->LocalModules, modname);
  i = Indexing_LowIndice (curBP->ImportedModules);
  n = Indexing_HighIndice (curBP->ImportedModules);
  while (i <= n)
    {
      desc = static_cast<P0SymBuild_ModuleDesc> (Indexing_GetIndice (curBP->ImportedModules, i));
      if (desc->name == modname)
        {
          Indexing_RemoveIndiceFromIndex (curBP->ImportedModules, reinterpret_cast <void *> (desc));
          Storage_DEALLOCATE ((void **) &desc, sizeof (P0SymBuild__T2));
          /* Continue checking in case a user imported the same module again.  */
          n -= 1;
        }
      else
        {
          i += 1;
        }
    }
}


/*
   RegisterImport - register, n, as a module imported from either a local scope or definition module.
*/

static void RegisterImport (unsigned int tok, NameKey_Name modname)
{
  P0SymBuild_BlockInfoPtr bp;
  P0SymBuild_ModuleDesc desc;

  /* printf1('register import from module %a
  ', n) ;  */
  M2Debug_Assert (curBP != NULL);
  M2Debug_Assert (curBP->toUp != NULL);
  bp = curBP->toUp;  /* skip over current module  */
  if (! (Lists_IsItemInList (bp->LocalModules, modname)))  /* skip over current module  */
    {
      Storage_ALLOCATE ((void **) &desc, sizeof (P0SymBuild__T2));
      desc->name = modname;
      desc->tok = tok;
      Indexing_IncludeIndiceIntoIndex (bp->ImportedModules, reinterpret_cast <void *> (desc));
    }
}


/*
   DeclareModules - declare all inner modules seen at the current block level.
*/

static void DeclareModules (void)
{
  P0SymBuild_BlockInfoPtr b;
  unsigned int s;

  b = curBP->toDown;
  while (b != NULL)
    {
      if (b->kind == P0SymBuild_inner)
        {
          if (Debugging)
            {
              M2Printf_printf1 ((const char *) "***  declaring inner module %a\\n", 32, (const unsigned char *) &b->name, (sizeof (b->name)-1));
            }
          s = SymbolTable_MakeInnerModule (curBP->token, b->name);
          M2Debug_Assert (s != SymbolTable_NulSym);
        }
      b = b->toNext;
    }
}


/*
   Move -
*/

static void Move (void)
{
  P0SymBuild_BlockInfoPtr b;

  if (Level == curBP->level)
    {
      b = curBP->toReturn;
      /* moving to next  */
      curBP = curBP->toNext;
      /* remember our return  */
      curBP->toReturn = b;
    }
  else
    {
      while (Level != curBP->level)
        {
          if (Level < curBP->level)
            {
              /* move up to the outer scope  */
              b = curBP;
              curBP = curBP->toReturn;
              curBP->toPC = b->toNext;
            }
          else
            {
              /* remember where we came from  */
              b = curBP;
              if (curBP->toPC == NULL)
                {
                  M2Debug_Assert (curBP->toDown != NULL);
                  curBP->toPC = curBP->toDown;
                }
              M2Debug_Assert (curBP->toPC != NULL);
              curBP = curBP->toPC;
              curBP->toReturn = b;
            }
        }
    }
}


/*
   EndModule -
*/

extern "C" void P0SymBuild_EndModule (void)
{
  NameKey_Name NameEnd;
  NameKey_Name NameStart;
  unsigned int end;
  unsigned int start;

  M2Quads_PopTtok (&NameEnd, &end);
  M2Quads_PopTtok (&NameStart, &start);
  M2Debug_Assert (start != M2LexBuf_UnknownTokenNo);
  M2Debug_Assert (end != M2LexBuf_UnknownTokenNo);
  if (NameEnd != NameStart)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (NameEnd == NameKey_NulName)
        {
          M2MetaError_MetaErrorT1 (start, (const char *) "module name at beginning {%1Ea} does not match the name at end", 62, SymbolTable_MakeError (start, NameStart));
          M2MetaError_MetaError1 ((const char *) "module name at end does not match the name at beginning {%1Ea}", 62, SymbolTable_MakeError (start, NameStart));
        }
      else
        {
          M2MetaError_MetaErrorT2 (start, (const char *) "module name at beginning {%1Ea} does not match the name at end {%2a}", 68, SymbolTable_MakeError (start, curBP->name), SymbolTable_MakeError (end, NameEnd));
          M2MetaError_MetaErrorT2 (end, (const char *) "module name at end {%1Ea} does not match the name at beginning {%2Ea}", 69, SymbolTable_MakeError (end, NameEnd), SymbolTable_MakeError (start, curBP->name));
        }
    }
  EndBlock ();
  M2Error_LeaveErrorScope ();
}


/*
   RegisterImports -
*/

extern "C" void P0SymBuild_RegisterImports (void)
{
  unsigned int index;
  unsigned int i;
  unsigned int n;

  M2Quads_PopT (&n);  /* n   = # of the Ident List  */
  if ((M2Quads_OperandT (n+1)) == M2Reserved_ImportTok)
    {
      /* Ident list contains Module Names  */
      i = 1;
      while (i <= n)
        {
          index = (n+1)-i;
          RegisterImport (M2Quads_OperandTok (index), M2Quads_OperandT (index));
          i += 1;
        }
    }
  else
    {
      /* Ident List contains list of objects  */
      RegisterImport (M2Quads_OperandTok (n+1), M2Quads_OperandT (n+1));
    }
  M2Quads_PopN (n+1);  /* clear stack  */
}


/*
   RegisterProgramModule - register the top of stack as a program module.
*/

extern "C" void P0SymBuild_RegisterProgramModule (void)
{
  NameKey_Name n;
  unsigned int sym;
  unsigned int tok;

  M2Debug_Assert (Level == 0);
  Level += 1;
  M2Quads_PopTtok (&n, &tok);
  M2Quads_PushTtok (n, tok);
  sym = M2Batch_MakeProgramSource (tok, n);
  SymbolTable_SetCurrentModule (sym);
  SymbolTable_SetFileModule (sym);
  BeginBlock (n, P0SymBuild_program, sym, tok);
  M2Error_EnterProgramScope (n);
}


/*
   RegisterImplementationModule - register the top of stack as an implementation module.
*/

extern "C" void P0SymBuild_RegisterImplementationModule (void)
{
  NameKey_Name n;
  unsigned int sym;
  unsigned int tok;

  M2Debug_Assert (Level == 0);
  Level += 1;
  M2Quads_PopTtok (&n, &tok);
  M2Quads_PushTtok (n, tok);
  sym = M2Batch_MakeImplementationSource (tok, n);
  SymbolTable_SetCurrentModule (sym);
  SymbolTable_SetFileModule (sym);
  BeginBlock (n, P0SymBuild_defimp, sym, tok);
  M2Error_EnterImplementationScope (n);
}


/*
   RegisterDefinitionModule - register the top of stack as a definition module.
*/

extern "C" void P0SymBuild_RegisterDefinitionModule (bool forC)
{
  NameKey_Name n;
  unsigned int sym;
  unsigned int tok;

  M2Debug_Assert (Level == 0);
  Level += 1;
  M2Quads_PopTtok (&n, &tok);
  M2Quads_PushTtok (n, tok);
  sym = M2Batch_MakeDefinitionSource (tok, n);
  SymbolTable_SetCurrentModule (sym);
  SymbolTable_SetFileModule (sym);
  if (forC)
    {
      SymbolTable_PutDefinitionForC (sym);
    }
  BeginBlock (n, P0SymBuild_defimp, sym, tok);
  M2Error_EnterDefinitionScope (n);
}


/*
   RegisterInnerModule - register the top of stack as an inner module, this module name
                         will be removed from the list of outstanding imports in the
                         current module block.
*/

extern "C" void P0SymBuild_RegisterInnerModule (void)
{
  NameKey_Name n;
  unsigned int tok;

  Level += 1;
  M2Quads_PopTtok (&n, &tok);
  M2Quads_PushTtok (n, tok);
  RegisterLocalModule (n);
  BeginBlock (n, P0SymBuild_inner, SymbolTable_NulSym, tok);
  M2Error_EnterModuleScope (n);
}


/*
   RegisterInnerImports -
*/

extern "C" void P0SymBuild_RegisterInnerImports (void)
{
  unsigned int n;

  M2Quads_PopT (&n);  /* n   = # of the Ident List  */
  if ((M2Quads_OperandT (n+1)) == M2Reserved_ImportTok)
    {}  /* empty.  */
  else
    {
      /* Ident List contains list of objects, but we are importing directly from a module OperandT(n+1)  */
      RegisterImport (M2Quads_OperandTok (n+1), M2Quads_OperandT (n+1));
    }
  M2Quads_PopN (n+1);  /* clear stack  */
}


/*
   RegisterProcedure - register the top of stack as a procedure.
*/

extern "C" void P0SymBuild_RegisterProcedure (void)
{
  NameKey_Name n;
  unsigned int tok;

  Level += 1;
  M2Quads_PopTtok (&n, &tok);
  M2Quads_PushTtok (n, tok);
  BeginBlock (n, P0SymBuild_procedure, SymbolTable_NulSym, tok);
  M2Error_EnterProcedureScope (n);
}

extern "C" void P0SymBuild_EndProcedure (void)
{
  NameKey_Name NameEnd;
  NameKey_Name NameStart;
  unsigned int end;
  unsigned int start;

  /* 
   EndBuildProcedure - ends building a Procedure.
  */
  M2Quads_PopTtok (&NameEnd, &end);
  M2Quads_PopTtok (&NameStart, &start);
  M2Debug_Assert (start != M2LexBuf_UnknownTokenNo);
  M2Debug_Assert (end != M2LexBuf_UnknownTokenNo);
  if (NameEnd != NameStart)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (NameEnd == NameKey_NulName)
        {
          M2MetaError_MetaErrorT1 (start, (const char *) "procedure name at beginning {%1Ea} does not match the name at end", 65, SymbolTable_MakeError (start, NameStart));
          M2MetaError_MetaError1 ((const char *) "procedure name at end does not match the name at beginning {%1Ea}", 65, SymbolTable_MakeError (start, NameStart));
        }
      else
        {
          M2MetaError_MetaErrorT2 (start, (const char *) "procedure name at beginning {%1Ea} does not match the name at end {%2a}", 71, SymbolTable_MakeError (start, curBP->name), SymbolTable_MakeError (end, NameEnd));
          M2MetaError_MetaErrorT2 (end, (const char *) "procedure name at end {%1Ea} does not match the name at beginning {%2Ea}", 72, SymbolTable_MakeError (end, NameEnd), SymbolTable_MakeError (start, curBP->name));
        }
    }
  EndBlock ();
  M2Error_LeaveErrorScope ();
}


/*
   EndForward - ends building a forward procedure.
*/

extern "C" void P0SymBuild_EndForward (void)
{
  M2Quads_PopN (1);
  EndBlock ();
  M2Error_LeaveErrorScope ();
}


/*
   P0Init -
*/

extern "C" void P0SymBuild_P0Init (void)
{
  headBP = NULL;
  curBP = NULL;
  Level = 0;
  InitUniverse ();
}


/*
   P1Init -
*/

extern "C" void P0SymBuild_P1Init (void)
{
  if (Debugging)
    {
      Display ();
    }
  /* curBP := headBP^.toDown ;  */
  curBP = headBP;
  M2Debug_Assert (curBP != NULL);
  curBP->toPC = curBP->toDown;
  curBP->toReturn = curBP;
  Level = 0;
}


/*
   EnterBlock -
*/

extern "C" void P0SymBuild_EnterBlock (NameKey_Name n)
{
  M2Debug_Assert (curBP != NULL);
  Level += 1;
  Move ();
  if (Debugging)
    {
      nSpaces (static_cast<unsigned int> (Level*3));
      if (n == curBP->name)
        {
          M2Printf_printf1 ((const char *) "block %a\\n", 10, (const unsigned char *) &n, (sizeof (n)-1));
        }
      else
        {
          M2Printf_printf2 ((const char *) "seen block %a but tree has recorded %a\\n", 40, (const unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) &curBP->name, (sizeof (curBP->name)-1));
        }
    }
  M2Debug_Assert ((n == curBP->name) || (curBP->name == NameKey_NulName));
  DeclareModules ();
}


/*
   LeaveBlock -
*/

extern "C" void P0SymBuild_LeaveBlock (void)
{
  if (Debugging)
    {
      M2Printf_printf1 ((const char *) "leaving block %a ", 17, (const unsigned char *) &curBP->name, (sizeof (curBP->name)-1));
    }
  Level -= 1;
  Move ();
}

extern "C" void _M2_P0SymBuild_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_P0SymBuild_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
