/* do not edit automatically generated by mc from M2MetaError.  */
/* M2MetaError.mod provides a set of high level error routines.

Copyright (C) 2008-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#   include "Gmcrts.h"
#include <safe-ctype.h>
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2MetaError_C

#include "GM2MetaError.h"
#   include "GM2Base.h"
#   include "GNameKey.h"
#   include "GStrLib.h"
#   include "GM2LexBuf.h"
#   include "GM2Error.h"
#   include "GFIO.h"
#   include "GSFIO.h"
#   include "GStringConvert.h"
#   include "GM2Printf.h"
#   include "GM2Options.h"
#   include "GStrCase.h"
#   include "Glibc.h"
#   include "GSYSTEM.h"
#   include "GM2Debug.h"
#   include "GStorage.h"
#   include "GIndexing.h"
#   include "GDynamicStrings.h"
#   include "GSymbolTable.h"
#   include "GM2ColorString.h"
#   include "GM2RTS.h"

#   define MaxStack 10
#   define Debugging false
#   define ColorDebug false
typedef struct M2MetaError_GetTokProcedure_p M2MetaError_GetTokProcedure;

typedef struct M2MetaError_errorBlock_r M2MetaError_errorBlock;

typedef struct M2MetaError__T1_a M2MetaError__T1;

typedef struct M2MetaError__T2_r M2MetaError__T2;

typedef M2MetaError__T2 *M2MetaError_dictionaryEntry;

typedef enum {M2MetaError_none, M2MetaError_error, M2MetaError_warning, M2MetaError_note, M2MetaError_chained, M2MetaError_aborta} M2MetaError_errorType;

typedef enum {M2MetaError_unsetColor, M2MetaError_noColor, M2MetaError_quoteColor, M2MetaError_filenameColor, M2MetaError_errorColor, M2MetaError_warningColor, M2MetaError_noteColor, M2MetaError_keywordColor, M2MetaError_locusColor, M2MetaError_insertColor, M2MetaError_deleteColor, M2MetaError_typeColor, M2MetaError_range1Color, M2MetaError_range2Color} M2MetaError_colorType;

typedef unsigned int (*M2MetaError_GetTokProcedure_t) (unsigned int);
struct M2MetaError_GetTokProcedure_p { M2MetaError_GetTokProcedure_t proc; };

struct M2MetaError__T1_a { M2MetaError_colorType array[MaxStack+1]; };
struct M2MetaError__T2_r {
                           DynamicStrings_String key;
                           DynamicStrings_String value;
                           M2MetaError_dictionaryEntry next;
                         };

struct M2MetaError_errorBlock_r {
                                  bool useError;
                                  M2Error_Error e;
                                  M2MetaError_errorType type;
                                  DynamicStrings_String out;
                                  DynamicStrings_String in;
                                  unsigned int highplus1;
                                  int len;
                                  int ini;
                                  bool glyph;
                                  bool chain;
                                  bool root;
                                  bool quotes;
                                  bool positive;
                                  M2MetaError_colorType currentCol;
                                  M2MetaError_colorType beginCol;
                                  M2MetaError_colorType endCol;
                                  M2MetaError__T1 colorStack;
                                  unsigned int stackPtr;
                                };

static M2Error_Error lastRoot;
static M2MetaError_colorType lastColor;
static bool seenAbort;
static Indexing_Index dictionary;
static Indexing_Index outputStack;
static M2MetaError_dictionaryEntry freeEntry;
extern "C" void M2MetaError_MetaError0 (const char *m_, unsigned int _m_high);
extern "C" void M2MetaError_MetaError1 (const char *m_, unsigned int _m_high, unsigned int s);
extern "C" void M2MetaError_MetaError2 (const char *m_, unsigned int _m_high, unsigned int s1, unsigned int s2);
extern "C" void M2MetaError_MetaError3 (const char *m_, unsigned int _m_high, unsigned int s1, unsigned int s2, unsigned int s3);
extern "C" void M2MetaError_MetaError4 (const char *m_, unsigned int _m_high, unsigned int s1, unsigned int s2, unsigned int s3, unsigned int s4);

/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrors1 (const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, unsigned int s);

/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrors2 (const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, unsigned int s1, unsigned int s2);

/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrors3 (const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, unsigned int s1, unsigned int s2, unsigned int s3);

/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrors4 (const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, unsigned int s1, unsigned int s2, unsigned int s3, unsigned int s4);
extern "C" void M2MetaError_MetaErrorT0 (unsigned int tok, const char *m_, unsigned int _m_high);
extern "C" void M2MetaError_MetaErrorT1 (unsigned int tok, const char *m_, unsigned int _m_high, unsigned int s);
extern "C" void M2MetaError_MetaErrorT2 (unsigned int tok, const char *m_, unsigned int _m_high, unsigned int s1, unsigned int s2);
extern "C" void M2MetaError_MetaErrorT3 (unsigned int tok, const char *m_, unsigned int _m_high, unsigned int s1, unsigned int s2, unsigned int s3);
extern "C" void M2MetaError_MetaErrorT4 (unsigned int tok, const char *m_, unsigned int _m_high, unsigned int s1, unsigned int s2, unsigned int s3, unsigned int s4);

/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorsT1 (unsigned int tok, const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, unsigned int s);

/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorsT2 (unsigned int tok, const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, unsigned int s1, unsigned int s2);

/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorsT3 (unsigned int tok, const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, unsigned int s1, unsigned int s2, unsigned int s3);

/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorsT4 (unsigned int tok, const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, unsigned int s1, unsigned int s2, unsigned int s3, unsigned int s4);

/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorString0 (DynamicStrings_String m);

/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorString1 (DynamicStrings_String m, unsigned int s);

/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorString2 (DynamicStrings_String m, unsigned int s1, unsigned int s2);

/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorString3 (DynamicStrings_String m, unsigned int s1, unsigned int s2, unsigned int s3);

/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorString4 (DynamicStrings_String m, unsigned int s1, unsigned int s2, unsigned int s3, unsigned int s4);
extern "C" void M2MetaError_MetaErrorStringT0 (unsigned int tok, DynamicStrings_String m);
extern "C" void M2MetaError_MetaErrorStringT1 (unsigned int tok, DynamicStrings_String m, unsigned int s);
extern "C" void M2MetaError_MetaErrorStringT2 (unsigned int tok, DynamicStrings_String m, unsigned int s1, unsigned int s2);
extern "C" void M2MetaError_MetaErrorStringT3 (unsigned int tok, DynamicStrings_String m, unsigned int s1, unsigned int s2, unsigned int s3);
extern "C" void M2MetaError_MetaErrorStringT4 (unsigned int tok, DynamicStrings_String m, unsigned int s1, unsigned int s2, unsigned int s3, unsigned int s4);

/*
   MetaErrorN1 -
*/

extern "C" void M2MetaError_MetaErrorN1 (const char *m_, unsigned int _m_high, NameKey_Name n);

/*
   MetaErrorN2 -
*/

extern "C" void M2MetaError_MetaErrorN2 (const char *m_, unsigned int _m_high, NameKey_Name n1, NameKey_Name n2);

/*
   MetaErrorNT0 - generate an error message at tok using format.
*/

extern "C" void M2MetaError_MetaErrorNT0 (unsigned int tok, const char *format_, unsigned int _format_high);

/*
   MetaErrorNT1 - generate an error message at tok using format and name.
                  The format should contain %a for name substitution.
*/

extern "C" void M2MetaError_MetaErrorNT1 (unsigned int tok, const char *format_, unsigned int _format_high, NameKey_Name name);
extern "C" void M2MetaError_MetaErrorNT2 (unsigned int tok, const char *format_, unsigned int _format_high, NameKey_Name name1, NameKey_Name name2);

/*
   wrapString - return a string which has been formatted with the specifier codes.
                Color is disabled.  The result string is returned.
*/

extern "C" DynamicStrings_String M2MetaError_MetaString0 (DynamicStrings_String m);

/*
   wrapString - return a string which has been formatted with the specifier codes.
                Color is disabled.  The result string is returned.
*/

extern "C" DynamicStrings_String M2MetaError_MetaString1 (DynamicStrings_String m, unsigned int s);

/*
   wrapString - return a string which has been formatted with the specifier codes.
                Color is disabled.  The result string is returned.
*/

extern "C" DynamicStrings_String M2MetaError_MetaString2 (DynamicStrings_String m, unsigned int s1, unsigned int s2);

/*
   wrapString - return a string which has been formatted with the specifier codes.
                Color is disabled.  The result string is returned.
*/

extern "C" DynamicStrings_String M2MetaError_MetaString3 (DynamicStrings_String m, unsigned int s1, unsigned int s2, unsigned int s3);

/*
   wrapString - return a string which has been formatted with the specifier codes.
                Color is disabled.  The result string is returned.
*/

extern "C" DynamicStrings_String M2MetaError_MetaString4 (DynamicStrings_String m, unsigned int s1, unsigned int s2, unsigned int s3, unsigned int s4);

/*
   MetaErrorDecl - if sym is a variable or parameter then generate a
                   declaration error or warning message.  If error is
                   FALSE then a warning is issued.
*/

extern "C" void M2MetaError_MetaErrorDecl (unsigned int sym, bool error);

/*
   pushOutput -
*/

static void pushOutput (M2MetaError_errorBlock *eb);

/*
   readWord - reads and returns a word delimited by '}' it uses '%' as
              the escape character.
*/

static DynamicStrings_String readWord (M2MetaError_errorBlock *eb);

/*
   addEntry -
*/

static void addEntry (DynamicStrings_String key, DynamicStrings_String value);

/*
   popOutput -
*/

static void popOutput (M2MetaError_errorBlock *eb);

/*
   newEntry -
*/

static M2MetaError_dictionaryEntry newEntry (void);

/*
   killEntry - dispose e and delete any strings.
*/

static void killEntry (M2MetaError_dictionaryEntry e);

/*
   resetDictionary - remove all entries in the dictionary.
*/

static void resetDictionary (void);

/*
   lookupString - lookup and return a duplicate of the string value for key s.
                  NIL is returned if the key s is unknown.
*/

static DynamicStrings_String lookupString (DynamicStrings_String s);

/*
   lookupDefine - looks up the word in the input string (ending with '}').
                  It uses this word as a key into the dictionary and returns
                  the entry.
*/

static DynamicStrings_String lookupDefine (M2MetaError_errorBlock *eb);

/*
   processDefine - place contents of dictionary entry name onto the output string.
*/

static void processDefine (M2MetaError_errorBlock *eb);

/*
   lookupColor - looks up the color enum from the string.
*/

static M2MetaError_colorType lookupColor (DynamicStrings_String s);

/*
   readColor -
*/

static M2MetaError_colorType readColor (M2MetaError_errorBlock *eb);

/*
   keyword - copy characters until the '}' in the input string and convert them to
             the keyword color/font.
*/

static void keyword (M2MetaError_errorBlock *eb);

/*
   filename - copy characters until the '}' in the input string and convert them to
              the filename color/font.
*/

static void filename (M2MetaError_errorBlock *eb);

/*
   pushColor -
*/

static void pushColor (M2MetaError_errorBlock *eb);

/*
   popColor -
*/

static void popColor (M2MetaError_errorBlock *eb);

/*
   initErrorBlock - initialise an error block with the, input, string.
*/

static void initErrorBlock (M2MetaError_errorBlock *eb, DynamicStrings_String input, const unsigned int *sym_, unsigned int _sym_high);

/*
   push - performs a push from the oldblock to the newblock.
          It copies all fields except the output string.
*/

static void push (M2MetaError_errorBlock *newblock, M2MetaError_errorBlock oldblock);

/*
   pop - copies contents of oldblock into newblock.  It only copies the error
         handle if the toblock.e is NIL.
*/

static void pop (M2MetaError_errorBlock *toblock, M2MetaError_errorBlock *fromblock);

/*
   OutOpenQuote -
*/

static void OutOpenQuote (M2MetaError_errorBlock *eb);

/*
   OutCloseQuote -
*/

static void OutCloseQuote (M2MetaError_errorBlock *eb);

/*
   findColorType - return the color of the string.  This is determined by the first
                   occurrance of an error, warning or note marker.  An error message
                   is assumed to either be: a keyword category, error category, note
                   category, warning category or to be chained from a previous error.
*/

static M2MetaError_colorType findColorType (DynamicStrings_String s);

/*
   killErrorBlock - deallocates the dynamic strings associated with the error block.
*/

static void killErrorBlock (M2MetaError_errorBlock *eb);

/*
   InternalFormat - produces an informative internal error.
*/

static void InternalFormat (M2MetaError_errorBlock eb, const char *m_, unsigned int _m_high, unsigned int line);

/*
   x - checks to see that a=b.
*/

static DynamicStrings_String x (DynamicStrings_String a, DynamicStrings_String b);

/*
   IsWhite - returns TRUE if, ch, is a space.
*/

static bool IsWhite (char ch);

/*
   skip - skips over this level input until the next '}'.
*/

static void skip (M2MetaError_errorBlock *sb);

/*
   ifNonNulThen := [ ':' ebnf ] =:
*/

static void ifNonNulThen (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high);

/*
   doNumber -
*/

static void doNumber (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol);

/*
   doCount -
*/

static void doCount (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol);

/*
   doCount -
*/

static void doAscii (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol);

/*
   unquotedKeyword -
*/

static void unquotedKeyword (M2MetaError_errorBlock *eb);

/*
   OutArray -
*/

static void OutArray (M2MetaError_errorBlock *eb, const char *a_, unsigned int _a_high);

/*
   OutGlyphS - outputs a string of glyphs.
*/

static void OutGlyphS (M2MetaError_errorBlock *eb, DynamicStrings_String s);

/*
   empty - returns TRUE if the output string is empty.
           It ignores color changes.
*/

static bool empty (M2MetaError_errorBlock *eb);

/*
   clear - remove the output string.
*/

static void clear (M2MetaError_errorBlock *eb);

/*
   clear - remove the output string.
*/

static void doName (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol);

/*
   clear - remove the output string.
*/

static void doQualified (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol);

/*
   doType - returns a string containing the type name of
            sym.
*/

static void doType (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol);

/*
   doSkipType - will skip all pseudonym types.  It also
                returns the type symbol found and name.
*/

static void doSkipType (M2MetaError_errorBlock eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol);

/*
   doGetType - attempts to get the type of sym[bol].
*/

static void doGetType (M2MetaError_errorBlock *eb, unsigned int *sym, unsigned int _sym_high, unsigned int bol);

/*
   doGetSkipType - will skip all pseudonym types.  It also
                   returns the type symbol found and name.
*/

static void doGetSkipType (M2MetaError_errorBlock *eb, unsigned int *sym, unsigned int _sym_high, unsigned int bol);

/*
   doChain -
*/

static void doChain (M2MetaError_errorBlock *eb, unsigned int tok);

/*
   doError - creates and returns an error note.
*/

static void doError (M2MetaError_errorBlock *eb, unsigned int tok);

/*
   defaultError - adds the default error location to, tok, if one has not already been
                  assigned.
*/

static void defaultError (M2MetaError_errorBlock *eb, unsigned int tok);

/*
   chooseError - choose the error kind dependant upon type.
                 Either an error, warning or note will be generated.
*/

static void chooseError (M2MetaError_errorBlock *eb, unsigned int tok);

/*
   doErrorScopeModule -
*/

static void doErrorScopeModule (M2MetaError_errorBlock *eb, unsigned int sym);

/*
   doErrorScopeForward -
*/

static void doErrorScopeForward (M2MetaError_errorBlock *eb, unsigned int sym);

/*
   doErrorScopeMod - potentially create an error referring to the definition
                     module, fall back to the implementation or program module if
                     there is no declaration in the definition module.
*/

static void doErrorScopeMod (M2MetaError_errorBlock *eb, unsigned int sym);

/*
   doErrorScopeFor - potentially create an error referring to the
                     forward declaration, definition module, fall back
                     to the implementation or program module if
                     there is no declaration in the definition module.
*/

static void doErrorScopeFor (M2MetaError_errorBlock *eb, unsigned int sym);
static void declaredMod (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol);

/*
   doErrorScopeDefinition - use the declaration in the definitio module if one is available.
*/

static void doErrorScopeDefinition (M2MetaError_errorBlock *eb, unsigned int sym);

/*
   doErrorScopeDef - potentially create an error referring to the definition
                     module, fall back to the implementation or program module if
                     there is no declaration in the definition module.
*/

static void doErrorScopeDef (M2MetaError_errorBlock *eb, unsigned int sym);
static void declaredDef (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol);
static void declaredFor (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol);

/*
   doErrorScopeProc - determine the location for the error or warning from
                      the default declaration.  For example parameters can be
                      declared in definition, forward or in modules (proper procedure).
                      Use GetVarParamTok to obtain a variable or parameter location.
*/

static void doErrorScopeProc (M2MetaError_errorBlock *eb, unsigned int sym, M2MetaError_GetTokProcedure GetVarParamTok);
static void declaredVar (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol);
static void declaredType (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol);
static void declaredFull (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol);

/*
   used - creates an error note where sym[bol] was first used.
*/

static void used (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol);

/*
   symDesc -
*/

static DynamicStrings_String symDesc (unsigned int sym);

/*
   doDesc -
*/

static void doDesc (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol);

/*
   op := {'!'|'a'|'c'|'d'|'k'|'n'|'p'|'q'|'s'|'t'|'u'|
          'A'|'B'|'C'|'D'|'E'|'F'|'G'|'H'|'K'|'M'|'N'|
          'O'|'P'|'Q'|'R'|'S'|'T'|'U'|'V'|'W'|'X'|'Y'|'Z'} then =:
*/

static void op (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol);

/*
   percenttoken := '%' (
                         '1'        % doOperand(1) %
                             op
                       | '2'        % doOperand(2) %
                             op
                       | '3'        % doOperand(3) %
                             op
                       | '4'        % doOperand(4) %
                             op
                       )
                       } =:
*/

static void percenttoken (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high);

/*
   changeColor - changes to color, c.
*/

static void changeColor (M2MetaError_errorBlock *eb, M2MetaError_colorType c);

/*
   shutdownColor - shutdown existing color if it exists.
*/

static void shutdownColor (M2MetaError_errorBlock *eb);

/*
   flushColor - flushes any outstanding color change.
*/

static void flushColor (M2MetaError_errorBlock *eb);

/*
   emitColorGCC -
*/

static void emitColorGCC (M2MetaError_errorBlock *eb, M2MetaError_colorType c);

/*
   emitColorTag -
*/

static void emitColorTag (M2MetaError_errorBlock *eb, M2MetaError_colorType c);

/*
   emitColor - adds the appropriate color string to the output string.
*/

static void emitColor (M2MetaError_errorBlock *eb, M2MetaError_colorType c);

/*
   openQuote -
*/

static DynamicStrings_String openQuote (DynamicStrings_String s);

/*
   closeQuote -
*/

static DynamicStrings_String closeQuote (DynamicStrings_String s);

/*
   colorEnd -
*/

static DynamicStrings_String colorEnd (DynamicStrings_String s);

/*
   copyChar - copies a character from in string to out string.
*/

static void copyChar (M2MetaError_errorBlock *eb);

/*
   copyKeywordChar - copies a character from in string to out string
                     it will convert the character to lower case if the
                     -fm2-lower-case option was specified.
*/

static void copyKeywordChar (M2MetaError_errorBlock *eb);

/*
   percent := '%' anych           % copy anych %
            =:
*/

static void percent (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high);

/*
   lbra := '{' [ '!' ] percenttoken '}' =:
*/

static void lbra (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high);

/*
   lbra := '{' [ '!' ] percenttoken '}' =:
*/

static void stop (void);

/*
   lbra := '{' [ '!' ] percenttoken '}' =:
*/

static void checkMe (void);

/*
   dumpErrorType -
*/

static void dumpErrorType (M2MetaError_errorType e);

/*
   dumpColorType -
*/

static void dumpColorType (M2MetaError_colorType c);

/*
   dump -

*/

static void dump (M2MetaError_errorBlock eb);

/*
   ebnf := { percent
             | lbra
             | any                    % copy ch %
           }
         =:
*/

static void ebnf (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high);

/*
   wrapErrors -
*/

static void wrapErrors (unsigned int tok, const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, const unsigned int *sym_, unsigned int _sym_high);

/*
   checkAbort - checks to see if the boolean flag seenAbort has been set,
                if so it flushes all existing errors and terminates.
*/

static void checkAbort (void);

/*
   translate -
*/

static DynamicStrings_String translate (DynamicStrings_String m, DynamicStrings_String s, int *i, NameKey_Name name);

/*
   wrapString - return a string which has been formatted with the specifier codes.
                Color is disabled.  The result string is returned.
*/

static DynamicStrings_String wrapString (DynamicStrings_String m, const unsigned int *sym_, unsigned int _sym_high);


/*
   pushOutput -
*/

static void pushOutput (M2MetaError_errorBlock *eb)
{
  Indexing_PutIndice (outputStack, (Indexing_HighIndice (outputStack))+1, reinterpret_cast <void *> ((*eb).out));
  (*eb).out = DynamicStrings_InitString ((const char *) "", 0);
  (*eb).glyph = false;
}


/*
   readWord - reads and returns a word delimited by '}' it uses '%' as
              the escape character.
*/

static DynamicStrings_String readWord (M2MetaError_errorBlock *eb)
{
  DynamicStrings_String word;

  word = DynamicStrings_InitString ((const char *) "", 0);
  while (((*eb).ini < (*eb).len) && ((DynamicStrings_char ((*eb).in, (*eb).ini)) != '}'))
    {
      if ((DynamicStrings_char ((*eb).in, (*eb).ini)) == '%')
        {
          (*eb).ini += 1;
        }
      word = DynamicStrings_ConCatChar (word, DynamicStrings_char ((*eb).in, (*eb).ini));
      (*eb).ini += 1;
    }
  return word;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   addEntry -
*/

static void addEntry (DynamicStrings_String key, DynamicStrings_String value)
{
  M2MetaError_dictionaryEntry e;
  DynamicStrings_String s;
  unsigned int i;

  s = lookupString (key);
  if (s == NULL)
    {
      e = newEntry ();
      e->key = key;
      e->value = value;
      Indexing_PutIndice (dictionary, (Indexing_HighIndice (dictionary))+1, reinterpret_cast <void *> (e));
    }
  else
    {
      i = 1;
      while (i <= (Indexing_HighIndice (dictionary)))
        {
          e = static_cast<M2MetaError_dictionaryEntry> (Indexing_GetIndice (dictionary, i));
          if (DynamicStrings_Equal (e->key, key))
            {
              e->value = DynamicStrings_KillString (e->value);
              e->value = value;
              return;
            }
          i += 1;
        }
    }
}


/*
   popOutput -
*/

static void popOutput (M2MetaError_errorBlock *eb)
{
  DynamicStrings_String key;
  DynamicStrings_String previous;

  if ((Indexing_HighIndice (outputStack)) >= 1)
    {
      previous = static_cast<DynamicStrings_String> (Indexing_GetIndice (outputStack, Indexing_HighIndice (outputStack)));
      Indexing_DeleteIndice (outputStack, Indexing_HighIndice (outputStack));
      key = readWord (eb);
      addEntry (key, (*eb).out);
      (*eb).out = previous;
    }
}


/*
   newEntry -
*/

static M2MetaError_dictionaryEntry newEntry (void)
{
  M2MetaError_dictionaryEntry e;

  if (freeEntry == NULL)
    {
      Storage_ALLOCATE ((void **) &e, sizeof (M2MetaError__T2));
    }
  else
    {
      e = freeEntry;
      freeEntry = freeEntry->next;
    }
  e->key = static_cast<DynamicStrings_String> (NULL);
  e->value = static_cast<DynamicStrings_String> (NULL);
  e->next = NULL;
  return e;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   killEntry - dispose e and delete any strings.
*/

static void killEntry (M2MetaError_dictionaryEntry e)
{
  e->next = freeEntry;
  freeEntry = e;
  if (e->key != NULL)
    {
      e->key = DynamicStrings_KillString (e->key);
    }
  if (e->value != NULL)
    {
      e->value = DynamicStrings_KillString (e->value);
    }
}


/*
   resetDictionary - remove all entries in the dictionary.
*/

static void resetDictionary (void)
{
  unsigned int i;
  M2MetaError_dictionaryEntry e;

  i = 1;
  while (i <= (Indexing_HighIndice (dictionary)))
    {
      e = static_cast<M2MetaError_dictionaryEntry> (Indexing_GetIndice (dictionary, i));
      killEntry (e);
      i += 1;
    }
  dictionary = Indexing_KillIndex (dictionary);
  dictionary = Indexing_InitIndex (1);
}


/*
   lookupString - lookup and return a duplicate of the string value for key s.
                  NIL is returned if the key s is unknown.
*/

static DynamicStrings_String lookupString (DynamicStrings_String s)
{
  unsigned int i;
  M2MetaError_dictionaryEntry e;

  i = 1;
  while (i <= (Indexing_HighIndice (dictionary)))
    {
      e = static_cast<M2MetaError_dictionaryEntry> (Indexing_GetIndice (dictionary, i));
      if (DynamicStrings_Equal (e->key, s))
        {
          return DynamicStrings_Dup (e->value);
        }
      i += 1;
    }
  return static_cast<DynamicStrings_String> (NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   lookupDefine - looks up the word in the input string (ending with '}').
                  It uses this word as a key into the dictionary and returns
                  the entry.
*/

static DynamicStrings_String lookupDefine (M2MetaError_errorBlock *eb)
{
  DynamicStrings_String s;

  s = DynamicStrings_InitString ((const char *) "", 0);
  while (((*eb).ini < (*eb).len) && ((DynamicStrings_char ((*eb).in, (*eb).ini)) != '}'))
    {
      if ((DynamicStrings_char ((*eb).in, (*eb).ini)) == '%')
        {
          (*eb).ini += 1;
        }
      s = DynamicStrings_ConCatChar (s, DynamicStrings_char ((*eb).in, (*eb).ini));
      (*eb).ini += 1;
    }
  s = lookupString (s);
  if (s == NULL)
    {
      s = DynamicStrings_InitString ((const char *) "", 0);
    }
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   processDefine - place contents of dictionary entry name onto the output string.
*/

static void processDefine (M2MetaError_errorBlock *eb)
{
  (*eb).out = DynamicStrings_ConCat ((*eb).out, lookupDefine (eb));
}


/*
   lookupColor - looks up the color enum from the string.
*/

static M2MetaError_colorType lookupColor (DynamicStrings_String s)
{
  if (DynamicStrings_EqualArray (s, (const char *) "filename", 8))
    {
      return M2MetaError_filenameColor;
    }
  else if (DynamicStrings_EqualArray (s, (const char *) "quote", 5))
    {
      /* avoid dangling else.  */
      return M2MetaError_quoteColor;
    }
  else if (DynamicStrings_EqualArray (s, (const char *) "error", 5))
    {
      /* avoid dangling else.  */
      return M2MetaError_errorColor;
    }
  else if (DynamicStrings_EqualArray (s, (const char *) "warning", 7))
    {
      /* avoid dangling else.  */
      return M2MetaError_warningColor;
    }
  else if (DynamicStrings_EqualArray (s, (const char *) "note", 4))
    {
      /* avoid dangling else.  */
      return M2MetaError_warningColor;
    }
  else if (DynamicStrings_EqualArray (s, (const char *) "locus", 5))
    {
      /* avoid dangling else.  */
      return M2MetaError_locusColor;
    }
  else if (DynamicStrings_EqualArray (s, (const char *) "insert", 6))
    {
      /* avoid dangling else.  */
      return M2MetaError_insertColor;
    }
  else if (DynamicStrings_EqualArray (s, (const char *) "delete", 6))
    {
      /* avoid dangling else.  */
      return M2MetaError_deleteColor;
    }
  else if (DynamicStrings_EqualArray (s, (const char *) "type", 4))
    {
      /* avoid dangling else.  */
      return M2MetaError_typeColor;
    }
  else if (DynamicStrings_EqualArray (s, (const char *) "range1", 6))
    {
      /* avoid dangling else.  */
      return M2MetaError_range1Color;
    }
  else if (DynamicStrings_EqualArray (s, (const char *) "range2", 6))
    {
      /* avoid dangling else.  */
      return M2MetaError_range2Color;
    }
  return M2MetaError_noColor;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   readColor -
*/

static M2MetaError_colorType readColor (M2MetaError_errorBlock *eb)
{
  DynamicStrings_String s;
  M2MetaError_colorType c;

  s = DynamicStrings_InitString ((const char *) "", 0);
  while (((*eb).ini < (*eb).len) && ((DynamicStrings_char ((*eb).in, (*eb).ini)) != '}'))
    {
      if ((DynamicStrings_char ((*eb).in, (*eb).ini)) == '%')
        {
          (*eb).ini += 1;
        }
      s = DynamicStrings_ConCatChar (s, DynamicStrings_char ((*eb).in, (*eb).ini));
      (*eb).ini += 1;
    }
  c = lookupColor (s);
  s = DynamicStrings_KillString (s);
  return c;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   keyword - copy characters until the '}' in the input string and convert them to
             the keyword color/font.
*/

static void keyword (M2MetaError_errorBlock *eb)
{
  if (TOUPPER (DynamicStrings_char ((*eb).in, (*eb).ini)) == 'K')
    {
      (*eb).ini += 1;
      pushColor (eb);
      changeColor (eb, M2MetaError_keywordColor);
      while (((*eb).ini < (*eb).len) && ((DynamicStrings_char ((*eb).in, (*eb).ini)) != '}'))
        {
          if (Debugging)
            {
              dump ((*eb));
            }
          if ((DynamicStrings_char ((*eb).in, (*eb).ini)) == '%')
            {
              (*eb).ini += 1;
            }
          copyKeywordChar (eb);
          (*eb).ini += 1;
        }
      popColor (eb);
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting index to be on the K for keyword", 42);
    }
}


/*
   filename - copy characters until the '}' in the input string and convert them to
              the filename color/font.
*/

static void filename (M2MetaError_errorBlock *eb)
{
  if (TOUPPER (DynamicStrings_char ((*eb).in, (*eb).ini)) == 'F')
    {
      (*eb).ini += 1;
      pushColor (eb);
      changeColor (eb, M2MetaError_filenameColor);
      while (((*eb).ini < (*eb).len) && ((DynamicStrings_char ((*eb).in, (*eb).ini)) != '}'))
        {
          if (Debugging)
            {
              dump ((*eb));
            }
          if ((DynamicStrings_char ((*eb).in, (*eb).ini)) == '%')
            {
              (*eb).ini += 1;
            }
          copyChar (eb);
          (*eb).ini += 1;
        }
      popColor (eb);
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting index to be on the F for filename", 43);
    }
}


/*
   pushColor -
*/

static void pushColor (M2MetaError_errorBlock *eb)
{
  if ((*eb).stackPtr > MaxStack)
    {
      M2RTS_HALT (-1);
      __builtin_unreachable ();
    }
  else
    {
      (*eb).colorStack.array[(*eb).stackPtr] = (*eb).currentCol;
      (*eb).stackPtr += 1;
    }
}


/*
   popColor -
*/

static void popColor (M2MetaError_errorBlock *eb)
{
  if ((*eb).stackPtr > 0)
    {
      (*eb).stackPtr -= 1;
    }
  else
    {
      M2RTS_HALT (-1);
      __builtin_unreachable ();
    }
  (*eb).currentCol = (*eb).colorStack.array[(*eb).stackPtr];
  if ((*eb).currentCol == M2MetaError_unsetColor)
    {
      (*eb).currentCol = M2MetaError_noColor;
    }
}


/*
   initErrorBlock - initialise an error block with the, input, string.
*/

static void initErrorBlock (M2MetaError_errorBlock *eb, DynamicStrings_String input, const unsigned int *sym_, unsigned int _sym_high)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  (*eb).useError = true;
  (*eb).e = static_cast<M2Error_Error> (NULL);
  (*eb).type = M2MetaError_error;  /* default to the error color.  */
  (*eb).out = DynamicStrings_InitString ((const char *) "", 0);  /* default to the error color.  */
  (*eb).in = input;
  (*eb).highplus1 = _sym_high+1;
  (*eb).len = DynamicStrings_Length (input);
  (*eb).ini = 0;
  (*eb).glyph = false;  /* nothing to output yet.  */
  (*eb).quotes = true;  /* nothing to output yet.  */
  (*eb).positive = true;
  (*eb).root = false;
  (*eb).chain = false;
  (*eb).currentCol = findColorType (input);
  (*eb).beginCol = M2MetaError_unsetColor;
  (*eb).endCol = M2MetaError_unsetColor;
  (*eb).stackPtr = 0;
}


/*
   push - performs a push from the oldblock to the newblock.
          It copies all fields except the output string.
*/

static void push (M2MetaError_errorBlock *newblock, M2MetaError_errorBlock oldblock)
{
  pushColor (&oldblock);  /* save the current color.  */
  (*newblock) = oldblock;  /* copy all the fields.  */
  (*newblock).out = static_cast<DynamicStrings_String> (NULL);  /* must do this before a clear as we have copied the address.  */
  clear (newblock);  /* must do this before a clear as we have copied the address.  */
  (*newblock).quotes = true;
}


/*
   pop - copies contents of oldblock into newblock.  It only copies the error
         handle if the toblock.e is NIL.
*/

static void pop (M2MetaError_errorBlock *toblock, M2MetaError_errorBlock *fromblock)
{
  M2MetaError_colorType c;

  if (empty (fromblock))
    {
      (*toblock).stackPtr = (*fromblock).stackPtr;
      (*toblock).colorStack = (*fromblock).colorStack;
      popColor (toblock);  /* and restore the color from the push start.  */
    }
  else
    {
      if ((*fromblock).quotes)
        {
          /* string needs to be quoted.  */
          if ((*toblock).currentCol == M2MetaError_unsetColor)
            {
              /* caller has not yet assigned a color, so use the callee color at the end.  */
              OutOpenQuote (toblock);
              OutGlyphS (toblock, (*fromblock).out);
              OutCloseQuote (toblock);
              changeColor (toblock, (*fromblock).currentCol);
            }
          else
            {
              shutdownColor (fromblock);
              /* caller has assigned a color, so use it after the new string.  */
              c = (*toblock).currentCol;
              OutOpenQuote (toblock);
              OutGlyphS (toblock, (*fromblock).out);
              OutCloseQuote (toblock);
              (*toblock).currentCol = c;
            }
        }
      else
        {
          if ((*toblock).currentCol == M2MetaError_unsetColor)
            {
              OutGlyphS (toblock, (*fromblock).out);
              (*toblock).endCol = (*fromblock).endCol;
              changeColor (toblock, (*fromblock).endCol);
            }
          else
            {
              pushColor (toblock);
              OutGlyphS (toblock, (*fromblock).out);
              (*toblock).endCol = (*fromblock).endCol;
              popColor (toblock);
            }
        }
    }
  if ((*toblock).e == NULL)
    {
      (*toblock).e = (*fromblock).e;
    }
  (*toblock).chain = (*fromblock).chain;
  (*toblock).root = (*fromblock).root;
  (*toblock).ini = (*fromblock).ini;
  (*toblock).type = (*fromblock).type;  /* might have been changed by the callee.  */
}


/*
   OutOpenQuote -
*/

static void OutOpenQuote (M2MetaError_errorBlock *eb)
{
  (*eb).currentCol = M2MetaError_noColor;
  flushColor (eb);
  (*eb).out = DynamicStrings_ConCat ((*eb).out, openQuote (DynamicStrings_InitString ((const char *) "", 0)));
}


/*
   OutCloseQuote -
*/

static void OutCloseQuote (M2MetaError_errorBlock *eb)
{
  (*eb).out = DynamicStrings_ConCat ((*eb).out, closeQuote (DynamicStrings_InitString ((const char *) "", 0)));
  (*eb).currentCol = M2MetaError_noColor;
  (*eb).endCol = M2MetaError_noColor;
}


/*
   findColorType - return the color of the string.  This is determined by the first
                   occurrance of an error, warning or note marker.  An error message
                   is assumed to either be: a keyword category, error category, note
                   category, warning category or to be chained from a previous error.
*/

static M2MetaError_colorType findColorType (DynamicStrings_String s)
{
  unsigned int i;

  i = 0;
  while (i < (DynamicStrings_Length (s)))
    {
      if ((DynamicStrings_char (s, static_cast<int> (i))) == '{')
        {
          i += 1;
          if ((DynamicStrings_char (s, static_cast<int> (i))) == '%')
            {
              i += 1;
              while ((i < (DynamicStrings_Length (s))) && ((DynamicStrings_char (s, static_cast<int> (i))) != '}'))
                {
                  if ((DynamicStrings_char (s, static_cast<int> (i))) == '%')
                    {
                      i += 1;
                    }
                  switch (DynamicStrings_char (s, static_cast<int> (i)))
                    {
                      case 'K':
                        return M2MetaError_errorColor;  /* keyword errors start with the fatal error color.  */
                        break;

                      case 'E':
                        return M2MetaError_errorColor;  /* keyword errors start with the fatal error color.  */
                        break;

                      case 'A':
                        return M2MetaError_errorColor;
                        break;

                      case 'O':
                        return M2MetaError_noteColor;
                        break;

                      case 'W':
                        return M2MetaError_warningColor;
                        break;

                      case 'C':
                        return lastColor;
                        break;


                      default:
                        break;
                    }
                  i += 1;
                }
            }
        }
      i += 1;
    }
  return M2MetaError_errorColor;  /* default to the error color.  */
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   killErrorBlock - deallocates the dynamic strings associated with the error block.
*/

static void killErrorBlock (M2MetaError_errorBlock *eb)
{
  (*eb).out = DynamicStrings_KillString ((*eb).out);
  (*eb).in = DynamicStrings_KillString ((*eb).in);
}


/*
   InternalFormat - produces an informative internal error.
*/

static void InternalFormat (M2MetaError_errorBlock eb, const char *m_, unsigned int _m_high, unsigned int line)
{
  char m[_m_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m, m_, _m_high+1);

  M2Printf_printf1 ((const char *) "M2MetaError.mod:%d:internalformat error detected\\n", 50, (const unsigned char *) &line, (sizeof (line)-1));
  dump (eb);
  M2Error_InternalError ((const char *) m, _m_high);
}


/*
   x - checks to see that a=b.
*/

static DynamicStrings_String x (DynamicStrings_String a, DynamicStrings_String b)
{
  if (a != b)
    {
      M2Error_InternalError ((const char *) "different string returned", 25);
    }
  return a;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsWhite - returns TRUE if, ch, is a space.
*/

static bool IsWhite (char ch)
{
  return ch == ' ';
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   skip - skips over this level input until the next '}'.
*/

static void skip (M2MetaError_errorBlock *sb)
{
  int level;

  level = 0;
  while ((*sb).ini < (*sb).len)
    {
      if ((level == 0) && ((DynamicStrings_char ((*sb).in, (*sb).ini)) == '}'))
        {
          return;
        }
      if ((DynamicStrings_char ((*sb).in, (*sb).ini)) == '}')
        {
          level -= 1;
        }
      else if ((DynamicStrings_char ((*sb).in, (*sb).ini)) == '{')
        {
          /* avoid dangling else.  */
          level += 1;
        }
      (*sb).ini += 1;
    }
}


/*
   ifNonNulThen := [ ':' ebnf ] =:
*/

static void ifNonNulThen (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  if ((DynamicStrings_char ((*eb).in, (*eb).ini)) == ':')
    {
      (*eb).ini += 1;
      if ((*eb).positive)
        {
          /* avoid dangling else.  */
          if ((empty (eb)) && ((DynamicStrings_Length ((*eb).out)) != 0))
            {
              M2Printf_printf0 ((const char *) "inconsistency found\\n", 21);
              dump ((*eb));
            }
          if (empty (eb))
            {
              if (Debugging)
                {
                  M2Printf_printf0 ((const char *) "empty expression, skip\\n", 24);
                }
              clear (eb);
              /* skip over this level of input text.  */
              skip (eb);
            }
          else
            {
              if (Debugging)
                {
                  dump ((*eb));
                  M2Printf_printf0 ((const char *) "non empty expression, clear and continue\\n", 42);
                }
              clear (eb);
              if (Debugging)
                {
                  dump ((*eb));
                  M2Printf_printf0 ((const char *) "cleared, continue\\n", 19);
                  dump ((*eb));
                }
              /* carry on processing input text.  */
              ebnf (eb, (const unsigned int *) sym, _sym_high);
              if (Debugging)
                {
                  M2Printf_printf0 ((const char *) "evaluated\\n", 11);
                  dump ((*eb));
                }
            }
        }
      else
        {
          if (empty (eb))
            {
              clear (eb);
              /* carry on processing input text.  */
              ebnf (eb, (const unsigned int *) sym, _sym_high);
            }
          else
            {
              clear (eb);
              /* skip over this level of input text.  */
              skip (eb);
            }
        }
      if (((*eb).ini < (*eb).len) && ((DynamicStrings_char ((*eb).in, (*eb).ini)) != '}'))
        {
          InternalFormat ((*eb), (const char *) "expecting to see }", 18, 852);
        }
    }
}


/*
   doNumber -
*/

static void doNumber (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  if (empty (eb))
    {
      (*eb).quotes = false;
      OutGlyphS (eb, StringConvert_ctos (sym[bol], 0, ' '));
    }
}


/*
   doCount -
*/

static void doCount (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  if (empty (eb))
    {
      (*eb).quotes = false;
      OutGlyphS (eb, StringConvert_ctos (sym[bol], 0, ' '));
      if (((sym[bol] % 100) >= 11) && ((sym[bol] % 100) <= 13))
        {
          OutGlyphS (eb, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "th", 2)));
        }

      else {
        switch (sym[bol] % 10)
          {
            case 1:
              OutGlyphS (eb, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "st", 2)));
              break;

            case 2:
              OutGlyphS (eb, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "nd", 2)));
              break;

            case 3:
              OutGlyphS (eb, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "rd", 2)));
              break;


            default:
              OutGlyphS (eb, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "th", 2)));
              break;
          }
      }
    }
}


/*
   doCount -
*/

static void doAscii (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  if ((((sym[bol] == SymbolTable_NulSym) || (! (empty (eb)))) || (SymbolTable_IsTemporary (sym[bol]))) || (SymbolTable_IsNameAnonymous (sym[bol])))
    {
      return;
    }
  else
    {
      OutGlyphS (eb, DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (sym[bol]))));
    }
}


/*
   unquotedKeyword -
*/

static void unquotedKeyword (M2MetaError_errorBlock *eb)
{
  (*eb).quotes = false;
  keyword (eb);
}


/*
   OutArray -
*/

static void OutArray (M2MetaError_errorBlock *eb, const char *a_, unsigned int _a_high)
{
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  OutGlyphS (eb, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)));
}


/*
   OutGlyphS - outputs a string of glyphs.
*/

static void OutGlyphS (M2MetaError_errorBlock *eb, DynamicStrings_String s)
{
  if ((DynamicStrings_Length (s)) > 0)
    {
      flushColor (eb);
      checkMe ();
      (*eb).glyph = true;
      (*eb).out = DynamicStrings_ConCat ((*eb).out, s);
    }
}


/*
   empty - returns TRUE if the output string is empty.
           It ignores color changes.
*/

static bool empty (M2MetaError_errorBlock *eb)
{
  return ! (*eb).glyph;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   clear - remove the output string.
*/

static void clear (M2MetaError_errorBlock *eb)
{
  (*eb).out = DynamicStrings_KillString ((*eb).out);
  (*eb).out = DynamicStrings_InitString ((const char *) "", 0);
  (*eb).glyph = false;
  (*eb).beginCol = M2MetaError_unsetColor;
  (*eb).quotes = false;
}


/*
   clear - remove the output string.
*/

static void doName (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  if ((((! (empty (eb))) || (sym[bol] == SymbolTable_NulSym)) || (SymbolTable_IsTemporary (sym[bol]))) || (SymbolTable_IsNameAnonymous (sym[bol])))
    {
      return;
    }
  else
    {
      if (sym[bol] == M2Base_ZType)
        {
          (*eb).quotes = false;
          OutArray (eb, (const char *) "the ZType", 9);
        }
      else if (sym[bol] == M2Base_RType)
        {
          /* avoid dangling else.  */
          (*eb).quotes = false;
          OutArray (eb, (const char *) "the RType", 9);
        }
      else
        {
          /* avoid dangling else.  */
          doAscii (eb, (const unsigned int *) sym, _sym_high, bol);
        }
    }
}


/*
   clear - remove the output string.
*/

static void doQualified (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol)
{
  typedef struct doQualified__T3_a doQualified__T3;

  struct doQualified__T3_a { unsigned int array[1+1]; };
  doQualified__T3 mod;
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  if ((((! (empty (eb))) || (sym[bol] == SymbolTable_NulSym)) || (SymbolTable_IsTemporary (sym[bol]))) || (SymbolTable_IsNameAnonymous (sym[bol])))
    {
      return;
    }
  else
    {
      mod.array[0] = SymbolTable_GetScope (sym[bol]);
      if ((SymbolTable_IsDefImp (mod.array[0])) && (SymbolTable_IsExported (mod.array[0], sym[bol])))
        {
          doAscii (eb, (const unsigned int *) &mod.array[0], 1, 0);
          OutArray (eb, (const char *) ".", 1);
          OutGlyphS (eb, DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (sym[bol])))));
        }
      else
        {
          doAscii (eb, (const unsigned int *) sym, _sym_high, bol);
        }
    }
}


/*
   doType - returns a string containing the type name of
            sym.
*/

static void doType (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  if ((! (empty (eb))) || (sym[bol] == SymbolTable_NulSym))
    {
      return;
    }
  else
    {
      const_cast<unsigned int *>(sym)[bol] = SymbolTable_GetType (sym[bol]);
      doAscii (eb, (const unsigned int *) sym, _sym_high, bol);
    }
}


/*
   doSkipType - will skip all pseudonym types.  It also
                returns the type symbol found and name.
*/

static void doSkipType (M2MetaError_errorBlock eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  if ((! (empty (&eb))) || (sym[bol] == SymbolTable_NulSym))
    {
      return;
    }
  else
    {
      const_cast<unsigned int *>(sym)[bol] = SymbolTable_SkipType (sym[bol]);
      while ((SymbolTable_IsType (sym[bol])) && (((SymbolTable_GetSymName (sym[bol])) == NameKey_NulName) || (SymbolTable_IsNameAnonymous (sym[bol]))))
        {
          const_cast<unsigned int *>(sym)[bol] = SymbolTable_GetType (sym[bol]);
        }
      doAscii (&eb, (const unsigned int *) sym, _sym_high, bol);
    }
}


/*
   doGetType - attempts to get the type of sym[bol].
*/

static void doGetType (M2MetaError_errorBlock *eb, unsigned int *sym, unsigned int _sym_high, unsigned int bol)
{
  if (((bol > _sym_high) || (! (empty (eb)))) || (sym[bol] == SymbolTable_NulSym))
    {
      return;
    }
  else
    {
      const_cast<unsigned int *>(sym)[bol] = SymbolTable_GetType (sym[bol]);
    }
}


/*
   doGetSkipType - will skip all pseudonym types.  It also
                   returns the type symbol found and name.
*/

static void doGetSkipType (M2MetaError_errorBlock *eb, unsigned int *sym, unsigned int _sym_high, unsigned int bol)
{
  unsigned int prev;

  if (((bol > _sym_high) || (! (empty (eb)))) || (sym[bol] == SymbolTable_NulSym))
    {
      return;
    }
  else
    {
      do {
        prev = sym[bol];
        const_cast<unsigned int *>(sym)[bol] = SymbolTable_SkipType (sym[bol]);
        if (((SymbolTable_IsType (sym[bol])) && (((SymbolTable_GetSymName (sym[bol])) == NameKey_NulName) || (SymbolTable_IsNameAnonymous (sym[bol])))) && ((SymbolTable_GetType (sym[bol])) != SymbolTable_NulSym))
          {
            const_cast<unsigned int *>(sym)[bol] = SymbolTable_GetType (sym[bol]);
          }
      } while (! (sym[bol] == prev));
    }
}


/*
   doChain -
*/

static void doChain (M2MetaError_errorBlock *eb, unsigned int tok)
{
  if (lastRoot == NULL)
    {
      M2Error_InternalError ((const char *) "should not be chaining an error onto an empty error note", 56);
    }
  else
    {
      (*eb).e = M2Error_ChainError (tok, lastRoot);
    }
}


/*
   doError - creates and returns an error note.
*/

static void doError (M2MetaError_errorBlock *eb, unsigned int tok)
{
  if ((*eb).useError)
    {
      chooseError (eb, tok);
    }
}


/*
   defaultError - adds the default error location to, tok, if one has not already been
                  assigned.
*/

static void defaultError (M2MetaError_errorBlock *eb, unsigned int tok)
{
  if ((*eb).e == NULL)
    {
      doError (eb, tok);
    }
}


/*
   chooseError - choose the error kind dependant upon type.
                 Either an error, warning or note will be generated.
*/

static void chooseError (M2MetaError_errorBlock *eb, unsigned int tok)
{
  if ((*eb).chain)
    {
      doChain (eb, tok);
    }
  else
    {
      switch ((*eb).type)
        {
          case M2MetaError_chained:
            doChain (eb, tok);
            break;

          case M2MetaError_none:
          case M2MetaError_aborta:
          case M2MetaError_error:
            if ((*eb).e == NULL)
              {
                (*eb).e = M2Error_NewError (tok);
              }
            else
              {
                (*eb).e = M2Error_MoveError ((*eb).e, tok);
              }
            break;

          case M2MetaError_warning:
            if ((*eb).e == NULL)
              {
                (*eb).e = M2Error_NewWarning (tok);
              }
            else
              {
                (*eb).e = M2Error_MoveError ((*eb).e, tok);
              }
            break;

          case M2MetaError_note:
            if ((*eb).e == NULL)
              {
                (*eb).e = M2Error_NewNote (tok);
              }
            else
              {
                (*eb).e = M2Error_MoveError ((*eb).e, tok);
              }
            break;


          default:
            M2Error_InternalError ((const char *) "unexpected enumeration value", 28);
            break;
        }
    }
  if ((*eb).root)
    {
      lastRoot = (*eb).e;
      lastColor = findColorType ((*eb).in);
    }
  (*eb).e = M2Error_SetColor ((*eb).e);
}


/*
   doErrorScopeModule -
*/

static void doErrorScopeModule (M2MetaError_errorBlock *eb, unsigned int sym)
{
  unsigned int scope;

  scope = SymbolTable_GetScope (sym);
  if (SymbolTable_IsModule (scope))
    {
      if (SymbolTable_IsInnerModule (scope))
        {
          doError (eb, SymbolTable_GetDeclaredMod (sym));
        }
      else
        {
          doError (eb, SymbolTable_GetDeclaredMod (sym));
        }
    }
  else
    {
      M2Debug_Assert (SymbolTable_IsDefImp (scope));
      /* if this fails then we need to skip to the outer scope.
         REPEAT
            OuterModule := GetScope(OuterModule)
         UNTIL GetScope(OuterModule)=NulSym.  */
      if ((SymbolTable_GetDeclaredModule (sym)) == M2LexBuf_UnknownTokenNo)
        {
          doError (eb, SymbolTable_GetDeclaredDef (sym));
        }
      else
        {
          doError (eb, SymbolTable_GetDeclaredMod (sym));
        }
    }
}


/*
   doErrorScopeForward -
*/

static void doErrorScopeForward (M2MetaError_errorBlock *eb, unsigned int sym)
{
  unsigned int scope;

  scope = SymbolTable_GetScope (sym);
  if (SymbolTable_IsModule (scope))
    {
      if (SymbolTable_IsInnerModule (scope))
        {
          doError (eb, SymbolTable_GetDeclaredFor (sym));
        }
      else
        {
          doError (eb, SymbolTable_GetDeclaredFor (sym));
        }
    }
  else
    {
      M2Debug_Assert (SymbolTable_IsDefImp (scope));
      /* if this fails then we need to skip to the outer scope.
         REPEAT
            OuterModule := GetScope(OuterModule)
         UNTIL GetScope(OuterModule)=NulSym.  */
      if ((SymbolTable_GetDeclaredModule (sym)) == M2LexBuf_UnknownTokenNo)
        {
          doError (eb, SymbolTable_GetDeclaredDef (sym));
        }
      else
        {
          doError (eb, SymbolTable_GetDeclaredFor (sym));
        }
    }
}


/*
   doErrorScopeMod - potentially create an error referring to the definition
                     module, fall back to the implementation or program module if
                     there is no declaration in the definition module.
*/

static void doErrorScopeMod (M2MetaError_errorBlock *eb, unsigned int sym)
{
  unsigned int scope;

  scope = SymbolTable_GetScope (sym);
  if (scope == SymbolTable_NulSym)
    {
      M2Error_EnterErrorScope (static_cast<M2Error_ErrorScope> (NULL));
      doError (eb, SymbolTable_GetDeclaredMod (sym));
    }
  else
    {
      M2Error_EnterErrorScope (SymbolTable_GetErrorScope (scope));
      if (SymbolTable_IsProcedure (scope))
        {
          doError (eb, SymbolTable_GetDeclaredMod (sym));
        }
      else
        {
          doErrorScopeModule (eb, sym);
        }
    }
  M2Error_LeaveErrorScope ();
}


/*
   doErrorScopeFor - potentially create an error referring to the
                     forward declaration, definition module, fall back
                     to the implementation or program module if
                     there is no declaration in the definition module.
*/

static void doErrorScopeFor (M2MetaError_errorBlock *eb, unsigned int sym)
{
  unsigned int scope;

  scope = SymbolTable_GetScope (sym);
  if (scope == SymbolTable_NulSym)
    {
      M2Error_EnterErrorScope (static_cast<M2Error_ErrorScope> (NULL));
      doError (eb, SymbolTable_GetDeclaredFor (sym));
    }
  else
    {
      M2Error_EnterErrorScope (SymbolTable_GetErrorScope (scope));
      if (SymbolTable_IsProcedure (scope))
        {
          doError (eb, SymbolTable_GetDeclaredFor (sym));
        }
      else
        {
          doErrorScopeForward (eb, sym);
        }
    }
  M2Error_LeaveErrorScope ();
}

static void declaredMod (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  /* 
   doDeclaredMod - creates an error note where sym[bol] was declared.
  */
  if (bol <= _sym_high)
    {
      doErrorScopeMod (eb, sym[bol]);
    }
}


/*
   doErrorScopeDefinition - use the declaration in the definitio module if one is available.
*/

static void doErrorScopeDefinition (M2MetaError_errorBlock *eb, unsigned int sym)
{
  unsigned int scope;

  scope = SymbolTable_GetScope (sym);
  if (SymbolTable_IsModule (scope))
    {
      /* No definition module for a program module.  */
      doError (eb, SymbolTable_GetDeclaredMod (sym));
    }
  else
    {
      M2Debug_Assert (SymbolTable_IsDefImp (scope));
      if ((SymbolTable_GetDeclaredDefinition (sym)) == M2LexBuf_UnknownTokenNo)
        {
          /* Fall back to the implementation module if no declaration exists
            in the definition module.  */
          doError (eb, SymbolTable_GetDeclaredMod (sym));
        }
      else
        {
          doError (eb, SymbolTable_GetDeclaredDef (sym));
        }
    }
}


/*
   doErrorScopeDef - potentially create an error referring to the definition
                     module, fall back to the implementation or program module if
                     there is no declaration in the definition module.
*/

static void doErrorScopeDef (M2MetaError_errorBlock *eb, unsigned int sym)
{
  unsigned int scope;

  scope = SymbolTable_GetScope (sym);
  if (scope == SymbolTable_NulSym)
    {
      M2Error_EnterErrorScope (static_cast<M2Error_ErrorScope> (NULL));
      doError (eb, SymbolTable_GetDeclaredFor (sym));
    }
  else
    {
      M2Error_EnterErrorScope (SymbolTable_GetErrorScope (scope));
      if (SymbolTable_IsProcedure (scope))
        {
          doError (eb, SymbolTable_GetDeclaredDef (sym));
        }
      else
        {
          doErrorScopeDefinition (eb, sym);
        }
    }
  M2Error_LeaveErrorScope ();
}

static void declaredDef (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  /* 
   doDeclaredDef - creates an error note where sym[bol] was declared.
  */
  if (bol <= _sym_high)
    {
      doErrorScopeDef (eb, sym[bol]);
    }
}

static void declaredFor (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  /* 
   doDeclaredFor - creates an error note where sym[bol] was declared.
  */
  if (bol <= _sym_high)
    {
      doErrorScopeFor (eb, sym[bol]);
    }
}


/*
   doErrorScopeProc - determine the location for the error or warning from
                      the default declaration.  For example parameters can be
                      declared in definition, forward or in modules (proper procedure).
                      Use GetVarParamTok to obtain a variable or parameter location.
*/

static void doErrorScopeProc (M2MetaError_errorBlock *eb, unsigned int sym, M2MetaError_GetTokProcedure GetVarParamTok)
{
  unsigned int scope;

  scope = SymbolTable_GetScope (sym);
  if (scope == SymbolTable_NulSym)
    {
      M2Error_EnterErrorScope (static_cast<M2Error_ErrorScope> (NULL));
      doError (eb, SymbolTable_GetDeclaredDef (sym));
    }
  else
    {
      M2Error_EnterErrorScope (SymbolTable_GetErrorScope (scope));
      if ((SymbolTable_IsVar (sym)) || (SymbolTable_IsParameter (sym)))
        {
          doError (eb, (unsigned int ) ((*GetVarParamTok.proc) (sym)));
        }
      else if (SymbolTable_IsProcedure (scope))
        {
          /* avoid dangling else.  */
          doError (eb, SymbolTable_GetDeclaredDef (sym));
        }
      else if (SymbolTable_IsModule (scope))
        {
          /* avoid dangling else.  */
          doError (eb, SymbolTable_GetDeclaredMod (sym));
        }
      else
        {
          /* avoid dangling else.  */
          M2Debug_Assert (SymbolTable_IsDefImp (scope));
          if ((SymbolTable_GetDeclaredDefinition (sym)) == M2LexBuf_UnknownTokenNo)
            {
              doError (eb, SymbolTable_GetDeclaredMod (sym));
            }
          else
            {
              doError (eb, SymbolTable_GetDeclaredDef (sym));
            }
        }
    }
  M2Error_LeaveErrorScope ();
}

static void declaredVar (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  /* 
   doDeclaredVar - creates an error note where sym[bol] was declared.
  */
  if (bol <= _sym_high)
    {
      doErrorScopeProc (eb, sym[bol], (M2MetaError_GetTokProcedure) {(M2MetaError_GetTokProcedure_t) SymbolTable_GetVarDeclTok});
    }
}

static void declaredType (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  /* 
   doDeclaredType - creates an error note where sym[bol] was declared.
  */
  if (bol <= _sym_high)
    {
      doErrorScopeProc (eb, sym[bol], (M2MetaError_GetTokProcedure) {(M2MetaError_GetTokProcedure_t) SymbolTable_GetVarDeclTypeTok});
    }
}

static void declaredFull (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  /* 
   doDeclaredFull - creates an error note where sym[bol] was declared.
  */
  if (bol <= _sym_high)
    {
      doErrorScopeProc (eb, sym[bol], (M2MetaError_GetTokProcedure) {(M2MetaError_GetTokProcedure_t) SymbolTable_GetVarDeclFullTok});
    }
}


/*
   used - creates an error note where sym[bol] was first used.
*/

static void used (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  if (bol <= _sym_high)
    {
      doError (eb, SymbolTable_GetFirstUsed (sym[bol]));
    }
}


/*
   symDesc -
*/

static DynamicStrings_String symDesc (unsigned int sym)
{
  if (SymbolTable_IsConstLit (sym))
    {
      return DynamicStrings_InitString ((const char *) "constant literal", 16);
    }
  else if (SymbolTable_IsConstSet (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "constant set", 12);
    }
  else if (SymbolTable_IsConstructor (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "constructor", 11);
    }
  else if (SymbolTable_IsConst (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "constant", 8);
    }
  else if (SymbolTable_IsArray (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "array", 5);
    }
  else if (SymbolTable_IsVar (sym))
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsTemporary (sym))
        {
          return DynamicStrings_InitString ((const char *) "expression", 10);
        }
      else
        {
          return DynamicStrings_InitString ((const char *) "variable", 8);
        }
    }
  else if (SymbolTable_IsEnumeration (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "enumeration type", 16);
    }
  else if (SymbolTable_IsFieldEnumeration (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "enumeration field", 17);
    }
  else if (SymbolTable_IsUnbounded (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "unbounded parameter", 19);
    }
  else if (SymbolTable_IsProcType (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "procedure type", 14);
    }
  else if (M2Base_IsPseudoBaseFunction (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "standard function procedure", 27);
    }
  else if (M2Base_IsPseudoBaseProcedure (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "standard procedure", 18);
    }
  else if (SymbolTable_IsProcedure (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "procedure", 9);
    }
  else if (SymbolTable_IsPointer (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "pointer", 7);
    }
  else if (SymbolTable_IsParameter (sym))
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsParameterVar (sym))
        {
          return DynamicStrings_InitString ((const char *) "var parameter", 13);
        }
      else
        {
          return DynamicStrings_InitString ((const char *) "parameter", 9);
        }
    }
  else if (SymbolTable_IsType (sym))
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsHiddenType (sym))
        {
          return DynamicStrings_InitString ((const char *) "opaque type", 11);
        }
      else
        {
          return DynamicStrings_InitString ((const char *) "type", 4);
        }
    }
  else if (SymbolTable_IsRecord (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "record", 6);
    }
  else if (SymbolTable_IsRecordField (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "record field", 12);
    }
  else if (SymbolTable_IsVarient (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "varient record", 14);
    }
  else if (SymbolTable_IsModule (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "module", 6);
    }
  else if (SymbolTable_IsDefImp (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "definition or implementation module", 35);
    }
  else if (SymbolTable_IsSet (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "set", 3);
    }
  else if (SymbolTable_IsUnknown (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "an unknown", 10);
    }
  else if (SymbolTable_IsSubrange (sym))
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "subrange", 8);
    }
  else
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "", 0);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doDesc -
*/

static void doDesc (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  if (empty (eb))
    {
      OutGlyphS (eb, symDesc (sym[bol]));
      if (! (empty (eb)))
        {
          (*eb).quotes = false;
        }
    }
}


/*
   op := {'!'|'a'|'c'|'d'|'k'|'n'|'p'|'q'|'s'|'t'|'u'|
          'A'|'B'|'C'|'D'|'E'|'F'|'G'|'H'|'K'|'M'|'N'|
          'O'|'P'|'Q'|'R'|'S'|'T'|'U'|'V'|'W'|'X'|'Y'|'Z'} then =:
*/

static void op (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high, unsigned int bol)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  while (((*eb).ini < (*eb).len) && ((DynamicStrings_char ((*eb).in, (*eb).ini)) != '}'))
    {
      if (Debugging)
        {
          M2Printf_printf0 ((const char *) "while loop in op\\n", 18);
          dump ((*eb));
        }
      switch (DynamicStrings_char ((*eb).in, (*eb).ini))
        {
          case '!':
            (*eb).positive = ! (*eb).positive;
            break;

          case 'a':
            doName (eb, (const unsigned int *) sym, _sym_high, bol);
            break;

          case 'c':
            (*eb).currentCol = readColor (eb);
            (*eb).ini -= 1;
            break;

          case 'd':
            doDesc (eb, (const unsigned int *) sym, _sym_high, bol);
            break;

          case 'k':
            unquotedKeyword (eb);
            (*eb).ini -= 1;
            break;

          case 'n':
            doNumber (eb, (const unsigned int *) sym, _sym_high, bol);
            break;

          case 'p':
            popColor (eb);
            break;

          case 'q':
            doQualified (eb, (const unsigned int *) sym, _sym_high, bol);
            break;

          case 's':
            doSkipType ((*eb), (const unsigned int *) sym, _sym_high, bol);
            break;

          case 't':
            doType (eb, (const unsigned int *) sym, _sym_high, bol);
            break;

          case 'u':
            (*eb).quotes = false;
            break;

          case 'A':
            (*eb).type = M2MetaError_aborta;
            seenAbort = true;
            break;

          case 'B':
            declaredType (eb, (const unsigned int *) sym, _sym_high, bol);
            break;

          case 'C':
            (*eb).chain = true;
            break;

          case 'D':
            declaredDef (eb, (const unsigned int *) sym, _sym_high, bol);
            break;

          case 'E':
            (*eb).type = M2MetaError_error;
            break;

          case 'F':
            filename (eb);
            (*eb).ini -= 1;
            break;

          case 'G':
            declaredFor (eb, (const unsigned int *) sym, _sym_high, bol);
            break;

          case 'H':
            declaredFull (eb, (const unsigned int *) sym, _sym_high, bol);
            break;

          case 'K':
            keyword (eb);
            (*eb).ini -= 1;
            break;

          case 'M':
            declaredMod (eb, (const unsigned int *) sym, _sym_high, bol);
            break;

          case 'N':
            doCount (eb, (const unsigned int *) sym, _sym_high, bol);
            break;

          case 'O':
            (*eb).type = M2MetaError_note;
            break;

          case 'P':
            pushColor (eb);
            break;

          case 'Q':
            resetDictionary ();
            break;

          case 'R':
            (*eb).root = true;
            break;

          case 'S':
            doGetSkipType (eb, (unsigned int *) sym, _sym_high, bol);
            break;

          case 'T':
            doGetType (eb, (unsigned int *) sym, _sym_high, bol);
            break;

          case 'U':
            used (eb, (const unsigned int *) sym, _sym_high, bol);
            break;

          case 'V':
            declaredVar (eb, (const unsigned int *) sym, _sym_high, bol);
            break;

          case 'W':
            (*eb).type = M2MetaError_warning;
            break;

          case 'X':
            pushOutput (eb);
            break;

          case 'Y':
            processDefine (eb);
            break;

          case 'Z':
            popOutput (eb);
            break;

          case ':':
            ifNonNulThen (eb, (const unsigned int *) sym, _sym_high);
            (*eb).ini -= 1;
            break;

          case '1':
            M2Error_InternalError ((const char *) "incorrect format spec, expecting %1 rather than % spec 1", 56);
            break;

          case '2':
            M2Error_InternalError ((const char *) "incorrect format spec, expecting %2 rather than % spec 2", 56);
            break;

          case '3':
            M2Error_InternalError ((const char *) "incorrect format spec, expecting %3 rather than % spec 3", 56);
            break;

          case '4':
            M2Error_InternalError ((const char *) "incorrect format spec, expecting %4 rather than % spec 4", 56);
            break;


          default:
            InternalFormat ((*eb), (const char *) "expecting one of [akqtdnpsuCDEFGKNOPQRSTUWXYZ:<>%]", 50, 1742);
            break;
        }
      (*eb).ini += 1;
    }
  if (Debugging)
    {
      M2Printf_printf0 ((const char *) "finishing op\\n", 14);
      dump ((*eb));
    }
}


/*
   percenttoken := '%' (
                         '1'        % doOperand(1) %
                             op
                       | '2'        % doOperand(2) %
                             op
                       | '3'        % doOperand(3) %
                             op
                       | '4'        % doOperand(4) %
                             op
                       )
                       } =:
*/

static void percenttoken (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  if ((DynamicStrings_char ((*eb).in, (*eb).ini)) == '%')
    {
      (*eb).ini += 1;
      switch (DynamicStrings_char ((*eb).in, (*eb).ini))
        {
          case '1':
            (*eb).ini += 1;
            op (eb, (const unsigned int *) sym, _sym_high, 0);
            break;

          case '2':
            (*eb).ini += 1;
            op (eb, (const unsigned int *) sym, _sym_high, 1);
            break;

          case '3':
            (*eb).ini += 1;
            op (eb, (const unsigned int *) sym, _sym_high, 2);
            break;

          case '4':
            (*eb).ini += 1;
            op (eb, (const unsigned int *) sym, _sym_high, 3);
            break;


          default:
            op (eb, (const unsigned int *) sym, _sym_high, 0);
            break;
        }
      if (((*eb).ini < (*eb).len) && ((DynamicStrings_char ((*eb).in, (*eb).ini)) != '}'))
        {
          InternalFormat ((*eb), (const char *) "expecting to see }", 18, 1789);
        }
    }
}


/*
   changeColor - changes to color, c.
*/

static void changeColor (M2MetaError_errorBlock *eb, M2MetaError_colorType c)
{
  (*eb).currentCol = c;
}


/*
   shutdownColor - shutdown existing color if it exists.
*/

static void shutdownColor (M2MetaError_errorBlock *eb)
{
  if (((*eb).endCol != M2MetaError_unsetColor) && ((*eb).endCol != M2MetaError_noColor))
    {
      (*eb).out = colorEnd ((*eb).out);
      (*eb).endCol = M2MetaError_noColor;
    }
}


/*
   flushColor - flushes any outstanding color change.
*/

static void flushColor (M2MetaError_errorBlock *eb)
{
  if ((*eb).endCol != (*eb).currentCol)
    {
      shutdownColor (eb);
      if ((*eb).endCol != (*eb).currentCol)
        {
          emitColor (eb, (*eb).currentCol);
          (*eb).endCol = (*eb).currentCol;
        }
      if ((*eb).beginCol == M2MetaError_unsetColor)
        {
          (*eb).beginCol = (*eb).currentCol;
        }
    }
}


/*
   emitColorGCC -
*/

static void emitColorGCC (M2MetaError_errorBlock *eb, M2MetaError_colorType c)
{
  switch (c)
    {
      case M2MetaError_unsetColor:
        break;

      case M2MetaError_noColor:
        (*eb).out = M2ColorString_endColor ((*eb).out);
        break;

      case M2MetaError_quoteColor:
        (*eb).out = M2ColorString_quoteColor ((*eb).out);
        break;

      case M2MetaError_filenameColor:
        (*eb).out = M2ColorString_filenameColor ((*eb).out);
        break;

      case M2MetaError_errorColor:
        (*eb).out = M2ColorString_errorColor ((*eb).out);
        break;

      case M2MetaError_warningColor:
        (*eb).out = M2ColorString_warningColor ((*eb).out);
        break;

      case M2MetaError_noteColor:
        (*eb).out = M2ColorString_noteColor ((*eb).out);
        break;

      case M2MetaError_keywordColor:
        (*eb).out = M2ColorString_locusColor ((*eb).out);
        break;

      case M2MetaError_locusColor:
        (*eb).out = M2ColorString_locusColor ((*eb).out);
        break;

      case M2MetaError_insertColor:
        (*eb).out = M2ColorString_insertColor ((*eb).out);
        break;

      case M2MetaError_deleteColor:
        (*eb).out = M2ColorString_deleteColor ((*eb).out);
        break;

      case M2MetaError_typeColor:
        (*eb).out = M2ColorString_typeColor ((*eb).out);
        break;

      case M2MetaError_range1Color:
        (*eb).out = M2ColorString_range1Color ((*eb).out);
        break;

      case M2MetaError_range2Color:
        (*eb).out = M2ColorString_range2Color ((*eb).out);
        break;


      default:
        CaseException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2MetaError.def", 20, 1);
        __builtin_unreachable ();
    }
}


/*
   emitColorTag -
*/

static void emitColorTag (M2MetaError_errorBlock *eb, M2MetaError_colorType c)
{
  DynamicStrings_String s;

  switch (c)
    {
      case M2MetaError_unsetColor:
        s = DynamicStrings_InitString ((const char *) "<unset>", 7);
        break;

      case M2MetaError_noColor:
        s = DynamicStrings_InitString ((const char *) "<nocol>", 7);
        stop ();
        break;

      case M2MetaError_quoteColor:
        s = DynamicStrings_InitString ((const char *) "<quote>", 7);
        break;

      case M2MetaError_filenameColor:
        s = DynamicStrings_InitString ((const char *) "<filename>", 10);
        break;

      case M2MetaError_errorColor:
        s = DynamicStrings_InitString ((const char *) "<error>", 7);
        break;

      case M2MetaError_warningColor:
        s = DynamicStrings_InitString ((const char *) "<warn>", 6);
        break;

      case M2MetaError_noteColor:
        s = DynamicStrings_InitString ((const char *) "<note>", 6);
        break;

      case M2MetaError_keywordColor:
        s = DynamicStrings_InitString ((const char *) "<key>", 5);
        break;

      case M2MetaError_locusColor:
        s = DynamicStrings_InitString ((const char *) "<locus>", 7);
        break;

      case M2MetaError_insertColor:
        s = DynamicStrings_InitString ((const char *) "<insert>", 8);
        break;

      case M2MetaError_deleteColor:
        s = DynamicStrings_InitString ((const char *) "<delete>", 8);
        break;

      case M2MetaError_typeColor:
        s = DynamicStrings_InitString ((const char *) "<type>", 6);
        break;

      case M2MetaError_range1Color:
        s = DynamicStrings_InitString ((const char *) "<range1>", 8);
        break;

      case M2MetaError_range2Color:
        s = DynamicStrings_InitString ((const char *) "<range2>", 8);
        break;


      default:
        CaseException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2MetaError.def", 20, 1);
        __builtin_unreachable ();
    }
  (*eb).out = DynamicStrings_ConCat ((*eb).out, DynamicStrings_Mark (s));
}


/*
   emitColor - adds the appropriate color string to the output string.
*/

static void emitColor (M2MetaError_errorBlock *eb, M2MetaError_colorType c)
{
  if (ColorDebug)
    {
      emitColorTag (eb, c);
    }
  else
    {
      emitColorGCC (eb, c);
    }
}


/*
   openQuote -
*/

static DynamicStrings_String openQuote (DynamicStrings_String s)
{
  if (ColorDebug)
    {
      return DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "<openquote>", 11)));
    }
  else
    {
      return M2ColorString_quoteOpen (s);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   closeQuote -
*/

static DynamicStrings_String closeQuote (DynamicStrings_String s)
{
  if (ColorDebug)
    {
      return DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "<closequote>", 12)));
    }
  else
    {
      return M2ColorString_quoteClose (s);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   colorEnd -
*/

static DynamicStrings_String colorEnd (DynamicStrings_String s)
{
  stop ();
  if (ColorDebug)
    {
      return DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "<nocol>", 7)));
    }
  else
    {
      return M2ColorString_endColor (s);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   copyChar - copies a character from in string to out string.
*/

static void copyChar (M2MetaError_errorBlock *eb)
{
  if ((*eb).ini < (*eb).len)
    {
      flushColor (eb);
      checkMe ();
      (*eb).glyph = true;
      (*eb).out = x ((*eb).out, DynamicStrings_ConCatChar ((*eb).out, DynamicStrings_char ((*eb).in, (*eb).ini)));
    }
}


/*
   copyKeywordChar - copies a character from in string to out string
                     it will convert the character to lower case if the
                     -fm2-lower-case option was specified.
*/

static void copyKeywordChar (M2MetaError_errorBlock *eb)
{
  char ch;

  if ((*eb).ini < (*eb).len)
    {
      flushColor (eb);
      ch = DynamicStrings_char ((*eb).in, (*eb).ini);
      if (M2Options_LowerCaseKeywords)
        {
          ch = StrCase_Lower (ch);
        }
      (*eb).glyph = true;
      (*eb).out = x ((*eb).out, DynamicStrings_ConCatChar ((*eb).out, ch));
    }
}


/*
   percent := '%' anych           % copy anych %
            =:
*/

static void percent (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  if ((DynamicStrings_char ((*eb).in, (*eb).ini)) == '%')
    {
      (*eb).ini += 1;
      if ((*eb).ini < (*eb).len)
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if ((DynamicStrings_char ((*eb).in, (*eb).ini)) == '<')
            {
              /* %< is a quotation symbol.  */
              pushColor (eb);
              (*eb).currentCol = M2MetaError_noColor;
              flushColor (eb);
              changeColor (eb, M2MetaError_quoteColor);
              (*eb).endCol = M2MetaError_quoteColor;  /* the openQuote will change the color.  */
              /* OutGlyphS performs a flush and we are emitting the open quote glyph.  */
              OutGlyphS (eb, openQuote (DynamicStrings_InitString ((const char *) "", 0)));
            }
          else if ((DynamicStrings_char ((*eb).in, (*eb).ini)) == '>')
            {
              /* avoid dangling else.  */
              OutGlyphS (eb, closeQuote (DynamicStrings_InitString ((const char *) "", 0)));
              (*eb).endCol = M2MetaError_noColor;  /* closeQuote also turns off color.  */
              popColor (eb);  /* closeQuote also turns off color.  */
            }
          else
            {
              /* avoid dangling else.  */
              copyChar (eb);
            }
        }
    }
}


/*
   lbra := '{' [ '!' ] percenttoken '}' =:
*/

static void lbra (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high)
{
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  if ((DynamicStrings_char ((*eb).in, (*eb).ini)) == '{')
    {
      (*eb).positive = true;
      (*eb).ini += 1;
      if ((DynamicStrings_char ((*eb).in, (*eb).ini)) == '!')
        {
          (*eb).positive = false;
          (*eb).ini += 1;
        }
      if ((DynamicStrings_char ((*eb).in, (*eb).ini)) != '%')
        {
          InternalFormat ((*eb), (const char *) "expecting to see %", 18, 2051);
        }
      percenttoken (eb, (const unsigned int *) sym, _sym_high);
      if (((*eb).ini < (*eb).len) && ((DynamicStrings_char ((*eb).in, (*eb).ini)) != '}'))
        {
          InternalFormat ((*eb), (const char *) "expecting to see }", 18, 2056);
        }
    }
}


/*
   lbra := '{' [ '!' ] percenttoken '}' =:
*/

static void stop (void)
{
}


/*
   lbra := '{' [ '!' ] percenttoken '}' =:
*/

static void checkMe (void)
{
}


/*
   dumpErrorType -
*/

static void dumpErrorType (M2MetaError_errorType e)
{
  switch (e)
    {
      case M2MetaError_none:
        M2Printf_printf0 ((const char *) "none", 4);
        break;

      case M2MetaError_error:
        M2Printf_printf0 ((const char *) "error", 5);
        break;

      case M2MetaError_warning:
        M2Printf_printf0 ((const char *) "warning", 7);
        break;

      case M2MetaError_note:
        M2Printf_printf0 ((const char *) "note", 4);
        break;

      case M2MetaError_chained:
        M2Printf_printf0 ((const char *) "chained", 7);
        break;

      case M2MetaError_aborta:
        M2Printf_printf0 ((const char *) "abort", 5);
        break;


      default:
        CaseException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2MetaError.def", 20, 1);
        __builtin_unreachable ();
    }
}


/*
   dumpColorType -
*/

static void dumpColorType (M2MetaError_colorType c)
{
  switch (c)
    {
      case M2MetaError_unsetColor:
        M2Printf_printf0 ((const char *) "unsetColor", 10);
        break;

      case M2MetaError_noColor:
        M2Printf_printf0 ((const char *) "noColor", 7);
        break;

      case M2MetaError_quoteColor:
        M2Printf_printf0 ((const char *) "quoteColor", 10);
        break;

      case M2MetaError_filenameColor:
        M2Printf_printf0 ((const char *) "filenameColor", 13);
        break;

      case M2MetaError_errorColor:
        M2Printf_printf0 ((const char *) "errorColor", 10);
        break;

      case M2MetaError_warningColor:
        M2Printf_printf0 ((const char *) "warningColor", 12);
        break;

      case M2MetaError_noteColor:
        M2Printf_printf0 ((const char *) "noteColor", 9);
        break;

      case M2MetaError_keywordColor:
        M2Printf_printf0 ((const char *) "keywordColor", 12);
        break;

      case M2MetaError_locusColor:
        M2Printf_printf0 ((const char *) "locusColor", 10);
        break;

      case M2MetaError_insertColor:
        M2Printf_printf0 ((const char *) "insertColor", 11);
        break;

      case M2MetaError_deleteColor:
        M2Printf_printf0 ((const char *) "deleteColor", 11);
        break;

      case M2MetaError_typeColor:
        M2Printf_printf0 ((const char *) "typeColor", 9);
        break;

      case M2MetaError_range1Color:
        M2Printf_printf0 ((const char *) "range1Color", 11);
        break;

      case M2MetaError_range2Color:
        M2Printf_printf0 ((const char *) "range2Color", 11);
        break;


      default:
        CaseException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2MetaError.def", 20, 1);
        __builtin_unreachable ();
    }
}


/*
   dump -

*/

static void dump (M2MetaError_errorBlock eb)
{
  char ch;
  unsigned int l;
  int i;

  l = DynamicStrings_Length (eb.out);
  M2Printf_printf0 ((const char *) "\\n\\nerrorBlock\\n", 16);
  M2Printf_printf0 ((const char *) "\\ntype      = ", 14);
  dumpErrorType (eb.type);
  M2Printf_printf1 ((const char *) "\\nout       = |%s|", 18, (const unsigned char *) &eb.out, (sizeof (eb.out)-1));
  M2Printf_printf1 ((const char *) "\\nin        = |%s|", 18, (const unsigned char *) &eb.in, (sizeof (eb.in)-1));
  M2Printf_printf1 ((const char *) "\\nLength (out) = %d", 19, (const unsigned char *) &l, (sizeof (l)-1));
  M2Printf_printf1 ((const char *) "\\nlen       = %d", 16, (const unsigned char *) &eb.len, (sizeof (eb.len)-1));
  M2Printf_printf1 ((const char *) "\\nhighplus1 = %d", 16, (const unsigned char *) &eb.highplus1, (sizeof (eb.highplus1)-1));
  M2Printf_printf1 ((const char *) "\\nglyph     = %d", 16, (const unsigned char *) &eb.glyph, (sizeof (eb.glyph)-1));
  M2Printf_printf1 ((const char *) "\\nquotes    = %d", 16, (const unsigned char *) &eb.quotes, (sizeof (eb.quotes)-1));
  M2Printf_printf1 ((const char *) "\\npositive  = %d", 16, (const unsigned char *) &eb.positive, (sizeof (eb.positive)-1));
  M2Printf_printf0 ((const char *) "\\nbeginCol  = ", 14);
  dumpColorType (eb.beginCol);
  M2Printf_printf0 ((const char *) "\\nendCol    = ", 14);
  dumpColorType (eb.endCol);
  M2Printf_printf0 ((const char *) "\\ncurrentCol = ", 15);
  dumpColorType (eb.currentCol);
  M2Printf_printf1 ((const char *) "\\nini        = %d", 17, (const unsigned char *) &eb.ini, (sizeof (eb.ini)-1));
  if (eb.ini < eb.len)
    {
      ch = DynamicStrings_char (eb.in, eb.ini);
      M2Printf_printf1 ((const char *) "\\ncurrent char = %c", 19, (const unsigned char *) &ch, (sizeof (ch)-1));
      M2Printf_printf1 ((const char *) "\\n%s\\n", 6, (const unsigned char *) &eb.in, (sizeof (eb.in)-1));
      i = 0;
      while (i < eb.ini)
        {
          M2Printf_printf0 ((const char *) " ", 1);
          i += 1;
        }
      M2Printf_printf0 ((const char *) "^\\n", 3);
    }
  M2Printf_printf0 ((const char *) "\\n", 2);
}


/*
   ebnf := { percent
             | lbra
             | any                    % copy ch %
           }
         =:
*/

static void ebnf (M2MetaError_errorBlock *eb, const unsigned int *sym_, unsigned int _sym_high)
{
  M2MetaError_errorBlock nb;
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  if (Debugging)
    {
      M2Printf_printf0 ((const char *) "top of ebnf\\n", 13);
      dump ((*eb));
    }
  while ((*eb).ini < (*eb).len)
    {
      if (Debugging)
        {
          M2Printf_printf0 ((const char *) "while loop ebnf\\n", 17);
          dump ((*eb));
        }
      switch (DynamicStrings_char ((*eb).in, (*eb).ini))
        {
          case '!':
            (*eb).positive = ! (*eb).positive;
            break;

          case '%':
            percent (eb, (const unsigned int *) sym, _sym_high);
            break;

          case '{':
            push (&nb, (*eb));
            lbra (&nb, (const unsigned int *) sym, _sym_high);
            pop (eb, &nb);
            if (((*eb).ini < (*eb).len) && ((DynamicStrings_char ((*eb).in, (*eb).ini)) != '}'))
              {
                InternalFormat ((*eb), (const char *) "expecting to see }", 18, 2187);
              }
            break;

          case '}':
            return;
            break;


          default:
            if (((((IsWhite (DynamicStrings_char ((*eb).in, (*eb).ini))) && ((DynamicStrings_Length ((*eb).out)) > 0)) && (! (IsWhite (DynamicStrings_char ((*eb).out, -1))))) || (! (IsWhite (DynamicStrings_char ((*eb).in, (*eb).ini))))) && ((*eb).highplus1 > 0))
              {
                (*eb).quotes = false;  /* copying a normal character, don't quote the result.  */
                copyChar (eb);  /* copying a normal character, don't quote the result.  */
              }
            break;
        }
      (*eb).ini += 1;
    }
  (*eb).currentCol = M2MetaError_noColor;
  flushColor (eb);
  if (Debugging)
    {
      M2Printf_printf0 ((const char *) "finishing ebnf\\n", 16);
      dump ((*eb));
    }
}


/*
   wrapErrors -
*/

static void wrapErrors (unsigned int tok, const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, const unsigned int *sym_, unsigned int _sym_high)
{
  M2MetaError_errorBlock eb;
  char m1[_m1_high+1];
  char m2[_m2_high+1];
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m1, m1_, _m1_high+1);
  memcpy (m2, m2_, _m2_high+1);
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  initErrorBlock (&eb, DynamicStrings_InitString ((const char *) m1, _m1_high), (const unsigned int *) sym, _sym_high);
  ebnf (&eb, (const unsigned int *) sym, _sym_high);
  flushColor (&eb);
  defaultError (&eb, tok);
  lastRoot = eb.e;
  M2Error_ErrorString (eb.e, DynamicStrings_Dup (eb.out));
  killErrorBlock (&eb);
  initErrorBlock (&eb, DynamicStrings_InitString ((const char *) m2, _m2_high), (const unsigned int *) sym, _sym_high);
  eb.type = M2MetaError_chained;
  ebnf (&eb, (const unsigned int *) sym, _sym_high);
  flushColor (&eb);
  defaultError (&eb, tok);
  M2Error_ErrorString (eb.e, DynamicStrings_Dup (eb.out));
  killErrorBlock (&eb);
}


/*
   checkAbort - checks to see if the boolean flag seenAbort has been set,
                if so it flushes all existing errors and terminates.
*/

static void checkAbort (void)
{
  if (seenAbort)
    {
      M2Error_FlushWarnings ();
      M2Error_FlushErrors ();
    }
}


/*
   translate -
*/

static DynamicStrings_String translate (DynamicStrings_String m, DynamicStrings_String s, int *i, NameKey_Name name)
{
  int l;
  char ch;

  l = DynamicStrings_Length (m);
  while (((*i) >= 0) && ((*i) < l))
    {
      ch = DynamicStrings_char (m, (*i));
      if ((ch == '%') && ((*i) < l))
        {
          (*i) += 1;
          ch = DynamicStrings_char (m, (*i));
          (*i) += 1;
          if (ch == 'a')
            {
              s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "%<", 2)));
              s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (name))));
              s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "%>", 2)));
              return s;
            }
          s = DynamicStrings_ConCatChar (s, '%');
        }
      s = DynamicStrings_ConCatChar (s, ch);
      (*i) += 1;
    }
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   wrapString - return a string which has been formatted with the specifier codes.
                Color is disabled.  The result string is returned.
*/

static DynamicStrings_String wrapString (DynamicStrings_String m, const unsigned int *sym_, unsigned int _sym_high)
{
  M2MetaError_errorBlock eb;
  DynamicStrings_String s;
  bool old;
  unsigned int sym[_sym_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (sym, sym_, (_sym_high+1) * sizeof (unsigned int));

  old = M2ColorString_SetEnableColor (false);
  initErrorBlock (&eb, DynamicStrings_Dup (m), (const unsigned int *) sym, _sym_high);
  eb.useError = false;
  ebnf (&eb, (const unsigned int *) sym, _sym_high);
  flushColor (&eb);
  s = DynamicStrings_Dup (eb.out);
  killErrorBlock (&eb);
  old = M2ColorString_SetEnableColor (old);
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void M2MetaError_MetaError0 (const char *m_, unsigned int _m_high)
{
  char m[_m_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m, m_, _m_high+1);

  M2MetaError_MetaErrorT0 (M2LexBuf_GetTokenNo (), (const char *) m, _m_high);
}

extern "C" void M2MetaError_MetaError1 (const char *m_, unsigned int _m_high, unsigned int s)
{
  char m[_m_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m, m_, _m_high+1);

  M2MetaError_MetaErrorT1 (M2LexBuf_GetTokenNo (), (const char *) m, _m_high, s);
}

extern "C" void M2MetaError_MetaError2 (const char *m_, unsigned int _m_high, unsigned int s1, unsigned int s2)
{
  char m[_m_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m, m_, _m_high+1);

  M2MetaError_MetaErrorT2 (M2LexBuf_GetTokenNo (), (const char *) m, _m_high, s1, s2);
}

extern "C" void M2MetaError_MetaError3 (const char *m_, unsigned int _m_high, unsigned int s1, unsigned int s2, unsigned int s3)
{
  char m[_m_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m, m_, _m_high+1);

  M2MetaError_MetaErrorT3 (M2LexBuf_GetTokenNo (), (const char *) m, _m_high, s1, s2, s3);
}

extern "C" void M2MetaError_MetaError4 (const char *m_, unsigned int _m_high, unsigned int s1, unsigned int s2, unsigned int s3, unsigned int s4)
{
  char m[_m_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m, m_, _m_high+1);

  M2MetaError_MetaErrorT4 (M2LexBuf_GetTokenNo (), (const char *) m, _m_high, s1, s2, s3, s4);
}


/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrors1 (const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, unsigned int s)
{
  char m1[_m1_high+1];
  char m2[_m2_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m1, m1_, _m1_high+1);
  memcpy (m2, m2_, _m2_high+1);

  M2MetaError_MetaErrorsT1 (M2LexBuf_GetTokenNo (), (const char *) m1, _m1_high, (const char *) m2, _m2_high, s);
}


/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrors2 (const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, unsigned int s1, unsigned int s2)
{
  char m1[_m1_high+1];
  char m2[_m2_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m1, m1_, _m1_high+1);
  memcpy (m2, m2_, _m2_high+1);

  M2MetaError_MetaErrorsT2 (M2LexBuf_GetTokenNo (), (const char *) m1, _m1_high, (const char *) m2, _m2_high, s1, s2);
}


/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrors3 (const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, unsigned int s1, unsigned int s2, unsigned int s3)
{
  char m1[_m1_high+1];
  char m2[_m2_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m1, m1_, _m1_high+1);
  memcpy (m2, m2_, _m2_high+1);

  M2MetaError_MetaErrorsT3 (M2LexBuf_GetTokenNo (), (const char *) m1, _m1_high, (const char *) m2, _m2_high, s1, s2, s3);
}


/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrors4 (const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, unsigned int s1, unsigned int s2, unsigned int s3, unsigned int s4)
{
  char m1[_m1_high+1];
  char m2[_m2_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m1, m1_, _m1_high+1);
  memcpy (m2, m2_, _m2_high+1);

  M2MetaError_MetaErrorsT4 (M2LexBuf_GetTokenNo (), (const char *) m1, _m1_high, (const char *) m2, _m2_high, s1, s2, s3, s4);
}

extern "C" void M2MetaError_MetaErrorT0 (unsigned int tok, const char *m_, unsigned int _m_high)
{
  char m[_m_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m, m_, _m_high+1);

  M2MetaError_MetaErrorStringT0 (tok, DynamicStrings_InitString ((const char *) m, _m_high));
}

extern "C" void M2MetaError_MetaErrorT1 (unsigned int tok, const char *m_, unsigned int _m_high, unsigned int s)
{
  char m[_m_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m, m_, _m_high+1);

  M2MetaError_MetaErrorStringT1 (tok, DynamicStrings_InitString ((const char *) m, _m_high), s);
}

extern "C" void M2MetaError_MetaErrorT2 (unsigned int tok, const char *m_, unsigned int _m_high, unsigned int s1, unsigned int s2)
{
  char m[_m_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m, m_, _m_high+1);

  M2MetaError_MetaErrorStringT2 (tok, DynamicStrings_InitString ((const char *) m, _m_high), s1, s2);
}

extern "C" void M2MetaError_MetaErrorT3 (unsigned int tok, const char *m_, unsigned int _m_high, unsigned int s1, unsigned int s2, unsigned int s3)
{
  char m[_m_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m, m_, _m_high+1);

  M2MetaError_MetaErrorStringT3 (tok, DynamicStrings_InitString ((const char *) m, _m_high), s1, s2, s3);
}

extern "C" void M2MetaError_MetaErrorT4 (unsigned int tok, const char *m_, unsigned int _m_high, unsigned int s1, unsigned int s2, unsigned int s3, unsigned int s4)
{
  char m[_m_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m, m_, _m_high+1);

  M2MetaError_MetaErrorStringT4 (tok, DynamicStrings_InitString ((const char *) m, _m_high), s1, s2, s3, s4);
}


/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorsT1 (unsigned int tok, const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, unsigned int s)
{
  typedef struct MetaErrorsT1__T4_a MetaErrorsT1__T4;

  struct MetaErrorsT1__T4_a { unsigned int array[0+1]; };
  MetaErrorsT1__T4 sym;
  char m1[_m1_high+1];
  char m2[_m2_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m1, m1_, _m1_high+1);
  memcpy (m2, m2_, _m2_high+1);

  sym.array[0] = s;
  wrapErrors (tok, (const char *) m1, _m1_high, (const char *) m2, _m2_high, (const unsigned int *) &sym.array[0], 0);
}


/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorsT2 (unsigned int tok, const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, unsigned int s1, unsigned int s2)
{
  typedef struct MetaErrorsT2__T5_a MetaErrorsT2__T5;

  struct MetaErrorsT2__T5_a { unsigned int array[1+1]; };
  MetaErrorsT2__T5 sym;
  char m1[_m1_high+1];
  char m2[_m2_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m1, m1_, _m1_high+1);
  memcpy (m2, m2_, _m2_high+1);

  sym.array[0] = s1;
  sym.array[1] = s2;
  wrapErrors (tok, (const char *) m1, _m1_high, (const char *) m2, _m2_high, (const unsigned int *) &sym.array[0], 1);
}


/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorsT3 (unsigned int tok, const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, unsigned int s1, unsigned int s2, unsigned int s3)
{
  typedef struct MetaErrorsT3__T6_a MetaErrorsT3__T6;

  struct MetaErrorsT3__T6_a { unsigned int array[2+1]; };
  MetaErrorsT3__T6 sym;
  char m1[_m1_high+1];
  char m2[_m2_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m1, m1_, _m1_high+1);
  memcpy (m2, m2_, _m2_high+1);

  sym.array[0] = s1;
  sym.array[1] = s2;
  sym.array[2] = s3;
  wrapErrors (tok, (const char *) m1, _m1_high, (const char *) m2, _m2_high, (const unsigned int *) &sym.array[0], 2);
}


/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorsT4 (unsigned int tok, const char *m1_, unsigned int _m1_high, const char *m2_, unsigned int _m2_high, unsigned int s1, unsigned int s2, unsigned int s3, unsigned int s4)
{
  typedef struct MetaErrorsT4__T7_a MetaErrorsT4__T7;

  struct MetaErrorsT4__T7_a { unsigned int array[3+1]; };
  MetaErrorsT4__T7 sym;
  char m1[_m1_high+1];
  char m2[_m2_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m1, m1_, _m1_high+1);
  memcpy (m2, m2_, _m2_high+1);

  sym.array[0] = s1;
  sym.array[1] = s2;
  sym.array[2] = s3;
  sym.array[3] = s4;
  wrapErrors (tok, (const char *) m1, _m1_high, (const char *) m2, _m2_high, (const unsigned int *) &sym.array[0], 3);
}


/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorString0 (DynamicStrings_String m)
{
  M2MetaError_MetaErrorStringT0 (M2LexBuf_GetTokenNo (), m);
}


/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorString1 (DynamicStrings_String m, unsigned int s)
{
  M2MetaError_MetaErrorStringT1 (M2LexBuf_GetTokenNo (), m, s);
}


/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorString2 (DynamicStrings_String m, unsigned int s1, unsigned int s2)
{
  M2MetaError_MetaErrorStringT2 (M2LexBuf_GetTokenNo (), m, s1, s2);
}


/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorString3 (DynamicStrings_String m, unsigned int s1, unsigned int s2, unsigned int s3)
{
  M2MetaError_MetaErrorStringT3 (M2LexBuf_GetTokenNo (), m, s1, s2, s3);
}


/*
   wrapErrors -
*/

extern "C" void M2MetaError_MetaErrorString4 (DynamicStrings_String m, unsigned int s1, unsigned int s2, unsigned int s3, unsigned int s4)
{
  M2MetaError_MetaErrorStringT4 (M2LexBuf_GetTokenNo (), m, s1, s2, s3, s4);
}

extern "C" void M2MetaError_MetaErrorStringT0 (unsigned int tok, DynamicStrings_String m)
{
  typedef struct MetaErrorStringT0__T8_a MetaErrorStringT0__T8;

  struct MetaErrorStringT0__T8_a { unsigned int array[0+1]; };
  M2MetaError_errorBlock eb;
  MetaErrorStringT0__T8 sym;

  sym.array[0] = SymbolTable_NulSym;
  initErrorBlock (&eb, m, (const unsigned int *) &sym.array[0], 0);
  ebnf (&eb, (const unsigned int *) &sym.array[0], 0);
  flushColor (&eb);
  defaultError (&eb, tok);
  M2Error_ErrorString (eb.e, DynamicStrings_Dup (eb.out));
  killErrorBlock (&eb);
  checkAbort ();
}

extern "C" void M2MetaError_MetaErrorStringT1 (unsigned int tok, DynamicStrings_String m, unsigned int s)
{
  typedef struct MetaErrorStringT1__T9_a MetaErrorStringT1__T9;

  struct MetaErrorStringT1__T9_a { unsigned int array[0+1]; };
  M2MetaError_errorBlock eb;
  MetaErrorStringT1__T9 sym;

  sym.array[0] = s;
  initErrorBlock (&eb, m, (const unsigned int *) &sym.array[0], 0);
  ebnf (&eb, (const unsigned int *) &sym.array[0], 0);
  flushColor (&eb);
  defaultError (&eb, tok);
  M2Error_ErrorString (eb.e, DynamicStrings_Dup (eb.out));
  killErrorBlock (&eb);
  checkAbort ();
}

extern "C" void M2MetaError_MetaErrorStringT2 (unsigned int tok, DynamicStrings_String m, unsigned int s1, unsigned int s2)
{
  typedef struct MetaErrorStringT2__T10_a MetaErrorStringT2__T10;

  struct MetaErrorStringT2__T10_a { unsigned int array[1+1]; };
  M2MetaError_errorBlock eb;
  MetaErrorStringT2__T10 sym;

  sym.array[0] = s1;
  sym.array[1] = s2;
  initErrorBlock (&eb, m, (const unsigned int *) &sym.array[0], 1);
  ebnf (&eb, (const unsigned int *) &sym.array[0], 1);
  flushColor (&eb);
  defaultError (&eb, tok);
  M2Error_ErrorString (eb.e, DynamicStrings_Dup (eb.out));
  killErrorBlock (&eb);
  checkAbort ();
}

extern "C" void M2MetaError_MetaErrorStringT3 (unsigned int tok, DynamicStrings_String m, unsigned int s1, unsigned int s2, unsigned int s3)
{
  typedef struct MetaErrorStringT3__T11_a MetaErrorStringT3__T11;

  struct MetaErrorStringT3__T11_a { unsigned int array[2+1]; };
  M2MetaError_errorBlock eb;
  MetaErrorStringT3__T11 sym;

  sym.array[0] = s1;
  sym.array[1] = s2;
  sym.array[2] = s3;
  initErrorBlock (&eb, m, (const unsigned int *) &sym.array[0], 2);
  eb.highplus1 = 2+1;
  ebnf (&eb, (const unsigned int *) &sym.array[0], 2);
  flushColor (&eb);
  defaultError (&eb, tok);
  M2Error_ErrorString (eb.e, DynamicStrings_Dup (eb.out));
  killErrorBlock (&eb);
  checkAbort ();
}

extern "C" void M2MetaError_MetaErrorStringT4 (unsigned int tok, DynamicStrings_String m, unsigned int s1, unsigned int s2, unsigned int s3, unsigned int s4)
{
  typedef struct MetaErrorStringT4__T12_a MetaErrorStringT4__T12;

  struct MetaErrorStringT4__T12_a { unsigned int array[3+1]; };
  M2MetaError_errorBlock eb;
  MetaErrorStringT4__T12 sym;

  sym.array[0] = s1;
  sym.array[1] = s2;
  sym.array[2] = s3;
  sym.array[3] = s4;
  initErrorBlock (&eb, m, (const unsigned int *) &sym.array[0], 3);
  ebnf (&eb, (const unsigned int *) &sym.array[0], 3);
  flushColor (&eb);
  defaultError (&eb, tok);
  M2Error_ErrorString (eb.e, DynamicStrings_Dup (eb.out));
  killErrorBlock (&eb);
  checkAbort ();
}


/*
   MetaErrorN1 -
*/

extern "C" void M2MetaError_MetaErrorN1 (const char *m_, unsigned int _m_high, NameKey_Name n)
{
  char m[_m_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m, m_, _m_high+1);

  M2MetaError_MetaErrorNT1 (M2LexBuf_GetTokenNo (), (const char *) m, _m_high, n);
}


/*
   MetaErrorN2 -
*/

extern "C" void M2MetaError_MetaErrorN2 (const char *m_, unsigned int _m_high, NameKey_Name n1, NameKey_Name n2)
{
  char m[_m_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (m, m_, _m_high+1);

  M2MetaError_MetaErrorNT2 (M2LexBuf_GetTokenNo (), (const char *) m, _m_high, n1, n2);
}


/*
   MetaErrorNT0 - generate an error message at tok using format.
*/

extern "C" void M2MetaError_MetaErrorNT0 (unsigned int tok, const char *format_, unsigned int _format_high)
{
  char format[_format_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (format, format_, _format_high+1);

  M2MetaError_MetaErrorStringT0 (tok, DynamicStrings_InitString ((const char *) format, _format_high));
}


/*
   MetaErrorNT1 - generate an error message at tok using format and name.
                  The format should contain %a for name substitution.
*/

extern "C" void M2MetaError_MetaErrorNT1 (unsigned int tok, const char *format_, unsigned int _format_high, NameKey_Name name)
{
  int i;
  DynamicStrings_String s;
  DynamicStrings_String fmt;
  char format[_format_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (format, format_, _format_high+1);

  i = 0;
  fmt = DynamicStrings_InitString ((const char *) format, _format_high);
  s = DynamicStrings_InitString ((const char *) "", 0);
  s = translate (fmt, s, &i, name);
  M2MetaError_MetaErrorStringT0 (tok, s);
  fmt = DynamicStrings_KillString (fmt);
}

extern "C" void M2MetaError_MetaErrorNT2 (unsigned int tok, const char *format_, unsigned int _format_high, NameKey_Name name1, NameKey_Name name2)
{
  int i;
  DynamicStrings_String s;
  DynamicStrings_String fmt;
  char format[_format_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (format, format_, _format_high+1);

  /* 
   MetaErrorNT1 - generate an error message at tok using format, name1
                  and name2.  The format should contain two occurances of %a
                  for name substitution.
  */
  i = 0;
  fmt = DynamicStrings_InitString ((const char *) format, _format_high);
  s = DynamicStrings_InitString ((const char *) "", 0);
  s = translate (fmt, s, &i, name1);
  s = translate (fmt, s, &i, name2);
  M2MetaError_MetaErrorStringT0 (tok, s);
  fmt = DynamicStrings_KillString (fmt);
}


/*
   wrapString - return a string which has been formatted with the specifier codes.
                Color is disabled.  The result string is returned.
*/

extern "C" DynamicStrings_String M2MetaError_MetaString0 (DynamicStrings_String m)
{
  typedef struct MetaString0__T13_a MetaString0__T13;

  struct MetaString0__T13_a { unsigned int array[0+1]; };
  MetaString0__T13 sym;

  sym.array[0] = SymbolTable_NulSym;
  return wrapString (m, (const unsigned int *) &sym.array[0], 0);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   wrapString - return a string which has been formatted with the specifier codes.
                Color is disabled.  The result string is returned.
*/

extern "C" DynamicStrings_String M2MetaError_MetaString1 (DynamicStrings_String m, unsigned int s)
{
  typedef struct MetaString1__T14_a MetaString1__T14;

  struct MetaString1__T14_a { unsigned int array[0+1]; };
  MetaString1__T14 sym;

  sym.array[0] = s;
  return wrapString (m, (const unsigned int *) &sym.array[0], 0);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   wrapString - return a string which has been formatted with the specifier codes.
                Color is disabled.  The result string is returned.
*/

extern "C" DynamicStrings_String M2MetaError_MetaString2 (DynamicStrings_String m, unsigned int s1, unsigned int s2)
{
  typedef struct MetaString2__T15_a MetaString2__T15;

  struct MetaString2__T15_a { unsigned int array[1+1]; };
  MetaString2__T15 sym;

  sym.array[0] = s1;
  sym.array[1] = s2;
  return wrapString (m, (const unsigned int *) &sym.array[0], 1);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   wrapString - return a string which has been formatted with the specifier codes.
                Color is disabled.  The result string is returned.
*/

extern "C" DynamicStrings_String M2MetaError_MetaString3 (DynamicStrings_String m, unsigned int s1, unsigned int s2, unsigned int s3)
{
  typedef struct MetaString3__T16_a MetaString3__T16;

  struct MetaString3__T16_a { unsigned int array[2+1]; };
  MetaString3__T16 sym;

  sym.array[0] = s1;
  sym.array[1] = s2;
  sym.array[2] = s3;
  return wrapString (m, (const unsigned int *) &sym.array[0], 2);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   wrapString - return a string which has been formatted with the specifier codes.
                Color is disabled.  The result string is returned.
*/

extern "C" DynamicStrings_String M2MetaError_MetaString4 (DynamicStrings_String m, unsigned int s1, unsigned int s2, unsigned int s3, unsigned int s4)
{
  typedef struct MetaString4__T17_a MetaString4__T17;

  struct MetaString4__T17_a { unsigned int array[3+1]; };
  MetaString4__T17 sym;

  sym.array[0] = s1;
  sym.array[1] = s2;
  sym.array[2] = s3;
  sym.array[3] = s4;
  return wrapString (m, (const unsigned int *) &sym.array[0], 3);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MetaErrorDecl - if sym is a variable or parameter then generate a
                   declaration error or warning message.  If error is
                   FALSE then a warning is issued.
*/

extern "C" void M2MetaError_MetaErrorDecl (unsigned int sym, bool error)
{
  if ((sym != SymbolTable_NulSym) && (SymbolTable_IsVar (sym)))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (error)
        {
          if (SymbolTable_IsVarAParam (sym))
            {
              M2MetaError_MetaErrorT1 (SymbolTable_GetVarDeclFullTok (sym), (const char *) "parameter declaration for {%1ad}", 32, sym);
            }
          else
            {
              M2MetaError_MetaErrorT1 (SymbolTable_GetVarDeclFullTok (sym), (const char *) "variable declaration for {%1ad}", 31, sym);
            }
        }
      else
        {
          if (SymbolTable_IsVarAParam (sym))
            {
              M2MetaError_MetaErrorT1 (SymbolTable_GetVarDeclFullTok (sym), (const char *) "parameter declaration for {%1Wad}", 33, sym);
            }
          else
            {
              M2MetaError_MetaErrorT1 (SymbolTable_GetVarDeclFullTok (sym), (const char *) "variable declaration for {%1Wad}", 32, sym);
            }
        }
    }
}

extern "C" void _M2_M2MetaError_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  lastRoot = static_cast<M2Error_Error> (NULL);
  lastColor = M2MetaError_noColor;
  seenAbort = false;
  outputStack = Indexing_InitIndex (1);
  dictionary = Indexing_InitIndex (1);
  freeEntry = NULL;
}

extern "C" void _M2_M2MetaError_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
