/* do not edit automatically generated by mc from M2Emit.  */
/* M2Emit.mod issue errors to the GCC error reporting substructure.

Copyright (C) 2019-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#define _M2Emit_C

#include "GM2Emit.h"
#   include "Gm2linemap.h"
#   include "GM2LexBuf.h"
#   include "GDynamicStrings.h"
#   include "GSYSTEM.h"


/*
   EmitError - pass the error to GCC.
*/

extern "C" void M2Emit_EmitError (bool error, bool note, unsigned int token, DynamicStrings_String message);

/*
   InternalError - issue an internal error, message.
*/

extern "C" void M2Emit_InternalError (const char *message_, unsigned int _message_high);

/*
   UnknownLocation - return the unknown location (using GCC linemap for cc1gm2)
                     and constants for gm2l and gm2m.
*/

extern "C" location_t M2Emit_UnknownLocation (void);

/*
   BuiltinsLocation - return the builtins location (using GCC linemap for cc1gm2)
                      and constants for gm2l and gm2m.
*/

extern "C" location_t M2Emit_BuiltinsLocation (void);


/*
   EmitError - pass the error to GCC.
*/

extern "C" void M2Emit_EmitError (bool error, bool note, unsigned int token, DynamicStrings_String message)
{
  if (error)
    {
      m2linemap_ErrorAtf (M2LexBuf_TokenToLocation (token), DynamicStrings_string (message));
    }
  else if (note)
    {
      /* avoid dangling else.  */
      m2linemap_NoteAtf (M2LexBuf_TokenToLocation (token), DynamicStrings_string (message));
    }
  else
    {
      /* avoid dangling else.  */
      m2linemap_WarningAtf (M2LexBuf_TokenToLocation (token), DynamicStrings_string (message));
    }
}


/*
   InternalError - issue an internal error, message.
*/

extern "C" void M2Emit_InternalError (const char *message_, unsigned int _message_high)
{
  char message[_message_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (message, message_, _message_high+1);

  m2linemap_internal_error (const_cast<void*> (static_cast<const void*>(message)));
}


/*
   UnknownLocation - return the unknown location (using GCC linemap for cc1gm2)
                     and constants for gm2l and gm2m.
*/

extern "C" location_t M2Emit_UnknownLocation (void)
{
  return m2linemap_UnknownLocation ();
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuiltinsLocation - return the builtins location (using GCC linemap for cc1gm2)
                      and constants for gm2l and gm2m.
*/

extern "C" location_t M2Emit_BuiltinsLocation (void)
{
  return m2linemap_BuiltinsLocation ();
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2Emit_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_M2Emit_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
