/* do not edit automatically generated by mc from Sets.  */
/* Sets.def provides a dynamic set module.

Copyright (C) 2009-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_Sets_H)
#   define _Sets_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GSymbolKey.h"

#   if defined (_Sets_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#if !defined (Sets_Set_D)
#  define Sets_Set_D
   typedef void *Sets_Set;
#endif


/*
   InitSet - initializes and returns a set.  The set will
             never contain an element less than, low.
*/

EXTERN Sets_Set Sets_InitSet (unsigned int low);

/*
   KillSet - deallocates Set, s.
*/

EXTERN Sets_Set Sets_KillSet (Sets_Set s);

/*
   DuplicateSet - returns a new duplicated set.
*/

EXTERN Sets_Set Sets_DuplicateSet (Sets_Set s);

/*
   ForeachElementInSetDo - for each element e in, s, call, p(e).
*/

EXTERN void Sets_ForeachElementInSetDo (Sets_Set s, SymbolKey_PerformOperation p);

/*
   IsElementInSet - returns TRUE if element, i, is in set, s.
*/

EXTERN bool Sets_IsElementInSet (Sets_Set s, unsigned int i);

/*
   NoOfElementsInSet - returns the number of elements in a set, s.
*/

EXTERN unsigned int Sets_NoOfElementsInSet (Sets_Set s);

/*
   ExcludeElementFromSet - excludes element, i, from set, s.
*/

EXTERN void Sets_ExcludeElementFromSet (Sets_Set s, unsigned int i);

/*
   IncludeElementIntoSet - includes element, i, into set, s.
*/

EXTERN void Sets_IncludeElementIntoSet (Sets_Set s, unsigned int i);

/*
   EqualSet - return TRUE if left = right.
*/

EXTERN bool Sets_EqualSet (Sets_Set left, Sets_Set right);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
