/* do not edit automatically generated by mc from M2Options.  */
/* M2Options.def initializes the user options.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2Options_H)
#   define _M2Options_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GSYSTEM.h"
#   include "GDynamicStrings.h"
#   include "Ggcctypes.h"

#   if defined (_M2Options_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

EXTERN bool M2Options_PPonly;
EXTERN bool M2Options_cflag;
EXTERN bool M2Options_Iso;
EXTERN bool M2Options_Pim;
EXTERN bool M2Options_Pim2;
EXTERN bool M2Options_Pim3;
EXTERN bool M2Options_Pim4;
EXTERN bool M2Options_PositiveModFloorDiv;
EXTERN bool M2Options_CompilerDebugging;
EXTERN bool M2Options_GenerateDebugging;
EXTERN bool M2Options_GenerateLineDebug;
EXTERN bool M2Options_Verbose;
EXTERN bool M2Options_Pedantic;
EXTERN bool M2Options_PedanticParamNames;
EXTERN bool M2Options_PedanticCast;
EXTERN bool M2Options_Statistics;
EXTERN bool M2Options_StyleChecking;
EXTERN bool M2Options_UnboundedByReference;
EXTERN bool M2Options_VerboseUnbounded;
EXTERN bool M2Options_OptimizeUncalledProcedures;
EXTERN bool M2Options_OptimizeBasicBlock;
EXTERN bool M2Options_OptimizeCommonSubExpressions;
EXTERN bool M2Options_WholeProgram;
EXTERN bool M2Options_NilChecking;
EXTERN bool M2Options_WholeDivChecking;
EXTERN bool M2Options_WholeValueChecking;
EXTERN bool M2Options_FloatValueChecking;
EXTERN bool M2Options_IndexChecking;
EXTERN bool M2Options_RangeChecking;
EXTERN bool M2Options_ReturnChecking;
EXTERN bool M2Options_CaseElseChecking;
EXTERN bool M2Options_VariantValueChecking;
EXTERN bool M2Options_CaseEnumChecking;
EXTERN bool M2Options_Quiet;
EXTERN bool M2Options_LineDirectives;
EXTERN bool M2Options_StrictTypeChecking;
EXTERN bool M2Options_StrictTypeAssignment;
EXTERN bool M2Options_StrictTypeReason;
EXTERN bool M2Options_CPreProcessor;
EXTERN bool M2Options_Xcode;
EXTERN bool M2Options_ExtendedOpaque;
EXTERN bool M2Options_DumpSystemExports;
EXTERN bool M2Options_GenerateSwig;
EXTERN bool M2Options_Exceptions;
EXTERN bool M2Options_UnusedVariableChecking;
EXTERN bool M2Options_UnusedParameterChecking;
EXTERN bool M2Options_UninitVariableChecking;
EXTERN bool M2Options_UninitVariableConditionalChecking;
EXTERN bool M2Options_LowerCaseKeywords;
EXTERN bool M2Options_DebugBuiltins;
EXTERN bool M2Options_AutoInit;
EXTERN bool M2Options_SaveTemps;
EXTERN bool M2Options_ScaffoldDynamic;
EXTERN bool M2Options_ScaffoldStatic;
EXTERN bool M2Options_ScaffoldMain;
EXTERN bool M2Options_GenModuleList;
EXTERN bool M2Options_SharedFlag;
EXTERN bool M2Options_ForcedLocation;
EXTERN bool M2Options_GenerateStatementNote;
EXTERN bool M2Options_Optimizing;
EXTERN bool M2Options_Coding;
EXTERN bool M2Options_Profiling;

/*
   SetM - set the MFlag.
*/

EXTERN void M2Options_SetM (bool value);

/*
   GetM - set the MFlag.
*/

EXTERN bool M2Options_GetM (void);

/*
   SetMM - set the MMFlag.
*/

EXTERN void M2Options_SetMM (bool value);

/*
   GetMM - set the MMFlag.
*/

EXTERN bool M2Options_GetMM (void);

/*
   SetMF - assigns MFarg to the filename from arg.
*/

EXTERN void M2Options_SetMF (void * arg);

/*
   GetMF - returns MFarg or NIL if never set.
*/

EXTERN void * M2Options_GetMF (void);

/*
   SetM2Prefix - assign arg to M2Prefix.
*/

EXTERN void M2Options_SetM2Prefix (void * arg);

/*
   GetM2Prefix - return M2Prefix as a C string.
*/

EXTERN void * M2Options_GetM2Prefix (void);

/*
   SetM2PathName - assign arg to M2PathName.
*/

EXTERN void M2Options_SetM2PathName (void * arg);

/*
   GetM2PathName - return M2PathName as a C string.
*/

EXTERN void * M2Options_GetM2PathName (void);

/*
   SetPPOnly - set the PPonly to value (on E, M, MM).
*/

EXTERN void M2Options_SetPPOnly (bool value);

/*
   GetPPOnly - get the PPonly (Preprocess only).
*/

EXTERN bool M2Options_GetPPOnly (void);

/*
   Setc - set the cflag (compile only flag -c) to value.
*/

EXTERN void M2Options_Setc (bool value);

/*
   Getc - get the cflag (compile only flag -c).
*/

EXTERN bool M2Options_Getc (void);

/*
   SetB - assigns Barg to arg.
*/

EXTERN void M2Options_SetB (void * arg);

/*
   GetB - returns argument to the -B option as a string or NIL if it were never set.
*/

EXTERN void * M2Options_GetB (void);

/*
   SetMD - set the MDFlag to value.
*/

EXTERN void M2Options_SetMD (bool value);

/*
   GetMD - return the MDFlag.
*/

EXTERN bool M2Options_GetMD (void);

/*
   SetMMD - set the MMDFlag to value.
*/

EXTERN void M2Options_SetMMD (bool value);

/*
   GetMMD - return the MMDFlag.
*/

EXTERN bool M2Options_GetMMD (void);

/*
   SetMQ - adds a quoted target arg to the DepTarget sentence.
*/

EXTERN void M2Options_SetMQ (void * arg);

/*
   GetMQ - returns a C string containing all the -MQ arg values.
*/

EXTERN void * M2Options_GetMQ (void);

/*
   SetMT - adds a target arg to the DepTarget sentence.
*/

EXTERN void M2Options_SetMT (void * arg);

/*
   GetMT - returns a C string containing all the -MT arg values.
*/

EXTERN void * M2Options_GetMT (void);

/*
   GetDepTarget - returns the DepTarget as a C string.
*/

EXTERN void * M2Options_GetDepTarget (void);

/*
   SetMP - set the MPflag to value.
*/

EXTERN void M2Options_SetMP (bool value);

/*
   GetMP - get the MPflag.
*/

EXTERN bool M2Options_GetMP (void);

/*
   SetObj - assigns given object file to arg.
*/

EXTERN void M2Options_SetObj (void * arg);

/*
   GetObj - returns the filename set for Object or NIL if it was never set.
*/

EXTERN void * M2Options_GetObj (void);

/*
   SetCpp - enables the source to be preprocessed and enables the
            recognition of C preprocessor line directives.
*/

EXTERN bool M2Options_SetCpp (bool value);

/*
   GetCpp - returns TRUE if the C preprocessor was used.
*/

EXTERN bool M2Options_GetCpp (void);

/*
   GetLineDirectives - returns TRUE if line directives are allowed.
*/

EXTERN bool M2Options_GetLineDirectives (void);

/*
   SetScaffoldDynamic - set the -fscaffold-dynamic flag.
*/

EXTERN void M2Options_SetScaffoldDynamic (bool value);

/*
   SetScaffoldStatic - set the -fscaffold-static flag.
*/

EXTERN void M2Options_SetScaffoldStatic (bool value);

/*
   GetScaffoldDynamic - get the -fscaffold-dynamic flag.
*/

EXTERN bool M2Options_GetScaffoldDynamic (void);

/*
   GetScaffoldStatic - get the -fscaffold-static flag.
*/

EXTERN bool M2Options_GetScaffoldStatic (void);

/*
   SetScaffoldMain - set the -fscaffold-main flag.
*/

EXTERN void M2Options_SetScaffoldMain (bool value);

/*
   SetRuntimeModuleOverride - set the override sequence used for module
                              initialization and finialization.
*/

EXTERN void M2Options_SetRuntimeModuleOverride (void * override);

/*
   GetRuntimeModuleOverride - return a string containing any user override
                              or the default module initialization override
                              sequence.
*/

EXTERN void * M2Options_GetRuntimeModuleOverride (void);

/*
   SetUselist - set the uselist flag to value and remember the filename.
*/

EXTERN void M2Options_SetUselist (bool value, void * filename);

/*
   GetUselist - return the uselist flag.
*/

EXTERN bool M2Options_GetUselist (void);

/*
   GetUselistFilename - return the uselist filename as a String.
*/

EXTERN DynamicStrings_String M2Options_GetUselistFilename (void);

/*
   SetWholeProgram - sets the WholeProgram flag (-fwhole-program).
*/

EXTERN void M2Options_SetWholeProgram (bool value);

/*
   SetAutoInit - set the auto initialization flag to value.  If the value
                 is true then all pointers are automatically
                 initialized to NIL.  TRUE is returned.
*/

EXTERN bool M2Options_SetAutoInit (bool value);

/*
   SetReturnCheck - set return statement checking in procedure functions
                    to value.  TRUE is returned.
*/

EXTERN bool M2Options_SetReturnCheck (bool value);

/*
   SetNilCheck - set access through NIL violation runtime checking to value.
*/

EXTERN bool M2Options_SetNilCheck (bool value);

/*
   SetCaseCheck - set else case checking to, value.
*/

EXTERN bool M2Options_SetCaseCheck (bool value);

/*
   SetCheckAll - set all runtime checking to, value.
*/

EXTERN bool M2Options_SetCheckAll (bool value);

/*
   SetVerboseUnbounded - sets the VerboseUnbounded flag to, value.
*/

EXTERN bool M2Options_SetVerboseUnbounded (bool value);

/*
   SetQuiet - sets the quiet flag to, value.
*/

EXTERN bool M2Options_SetQuiet (bool value);

/*
   SetCC1Quiet - sets the cc1quiet flag to, value.
*/

EXTERN void M2Options_SetCC1Quiet (bool value);

/*
   SetM2g - set the -fm2-g flag.
*/

EXTERN bool M2Options_SetM2g (bool value);

/*
   GetM2g - returns TRUE if the -fm2-g flags was used.
*/

EXTERN bool M2Options_GetM2g (void);

/*
   SetLowerCaseKeywords - set the lower case keyword flag and return the result.
*/

EXTERN bool M2Options_SetLowerCaseKeywords (bool value);

/*
   SetUnboundedByReference -
*/

EXTERN bool M2Options_SetUnboundedByReference (bool value);

/*
   SetSearchPath -
*/

EXTERN void M2Options_SetSearchPath (void * arg);

/*
   SetISO -
*/

EXTERN void M2Options_SetISO (bool value);

/*
   SetPIM -
*/

EXTERN void M2Options_SetPIM (bool value);

/*
   SetPIM2 -
*/

EXTERN void M2Options_SetPIM2 (bool value);

/*
   SetPIM3 -
*/

EXTERN void M2Options_SetPIM3 (bool value);

/*
   SetPIM4 -
*/

EXTERN void M2Options_SetPIM4 (bool value);

/*
   SetPositiveModFloor -
*/

EXTERN void M2Options_SetPositiveModFloor (bool value);

/*
   SetWholeDiv - sets the whole division flag.
*/

EXTERN void M2Options_SetWholeDiv (bool value);

/*
   SetIndex - sets the runtime array index checking flag.
*/

EXTERN void M2Options_SetIndex (bool value);

/*
   SetRange -  sets the runtime range checking flag.
*/

EXTERN void M2Options_SetRange (bool value);

/*
   SetExceptions -
*/

EXTERN void M2Options_SetExceptions (bool value);

/*
   SetStyle -
*/

EXTERN void M2Options_SetStyle (bool value);

/*
   SetPedantic -
*/

EXTERN void M2Options_SetPedantic (bool value);

/*
   SetPedanticParamNames -
*/

EXTERN void M2Options_SetPedanticParamNames (bool value);

/*
   SetPedanticCast -
*/

EXTERN void M2Options_SetPedanticCast (bool value);

/*
   SetExtendedOpaque -
*/

EXTERN void M2Options_SetExtendedOpaque (bool value);

/*
   SetXCode -
*/

EXTERN void M2Options_SetXCode (bool value);

/*
   SetCompilerDebugging - turn on internal compiler debugging.
                          Enabled via the command line option -fd.
*/

EXTERN void M2Options_SetCompilerDebugging (bool value);

/*
   SetQuadDebugging - display the quadruples (internal debugging).
*/

EXTERN void M2Options_SetQuadDebugging (bool value);

/*
   SetM2DebugTraceFilter - set internal debug flags.  The flags should be
                           specified as a comma separated list.  The full
                           list allowed is quad,line,token,tree.
*/

EXTERN void M2Options_SetM2DebugTraceFilter (bool value, void * filter);

/*
   SetDebugFunctionLineNumbers - set DebugFunctionLineNumbers.
*/

EXTERN void M2Options_SetDebugFunctionLineNumbers (bool value);

/*
   SetGenerateStatementNote - turn on generation of nops if necessary
                              to generate pedalogical single stepping.
*/

EXTERN void M2Options_SetGenerateStatementNote (bool value);

/*
   SetSources -
*/

EXTERN void M2Options_SetSources (bool value);

/*
   SetDumpSystemExports -
*/

EXTERN void M2Options_SetDumpSystemExports (bool value);

/*
   SetSwig -
*/

EXTERN void M2Options_SetSwig (bool value);

/*
   SetOptimizing -
*/

EXTERN void M2Options_SetOptimizing (unsigned int value);

/*
   OverrideLocation - possibly override the location value, depending upon
                      whether the -flocation= option was used.
*/

EXTERN location_t M2Options_OverrideLocation (location_t location);

/*
   SetForcedLocation - sets the location for the lifetime of this compile to, location.
                       This is primarily an internal debugging switch.
*/

EXTERN void M2Options_SetForcedLocation (location_t location);

/*
   SetUnusedVariableChecking - assigns the UnusedVariableChecking to value.
*/

EXTERN void M2Options_SetUnusedVariableChecking (bool value);

/*
   SetUnusedParameterChecking - assigns the UnusedParameterChecking to value.
*/

EXTERN void M2Options_SetUnusedParameterChecking (bool value);

/*
   SetStrictTypeChecking - assigns the StrictTypeChecking flag to value.
*/

EXTERN void M2Options_SetStrictTypeChecking (bool value);

/*
   SetStrictTypeAssignment - assigns the StrictTypeAssignment flag to value.
*/

EXTERN void M2Options_SetStrictTypeAssignment (bool value);

/*
   SetStrictTypeReason - assigns the StrictTypeReason flag to value.
*/

EXTERN void M2Options_SetStrictTypeReason (bool value);

/*
   setdefextension - set the source file definition module extension to arg.
                     This should include the . and by default it is set to .def.
*/

EXTERN void M2Options_setdefextension (void * arg);

/*
   setmodextension - set the source file module extension to arg.
                     This should include the . and by default it is set to .mod.
*/

EXTERN void M2Options_setmodextension (void * arg);

/*
   SetStatistics - turn on/off generate of compile time statistics.
*/

EXTERN void M2Options_SetStatistics (bool on);

/*
   SetVerbose - set the Verbose flag to, value.  It returns TRUE.
*/

EXTERN bool M2Options_SetVerbose (bool value);

/*
   CppArg - sets the option and arg in the cpp command line.
*/

EXTERN void M2Options_CppArg (void * opt, void * arg, bool joined);

/*
   CppCommandLine - returns the Cpp command line and all arguments.
*/

EXTERN DynamicStrings_String M2Options_CppCommandLine (void);

/*
   CppRemember - remember a string, s, as a cpp related argument.
                 The string, s, is not garbage collected.
*/

EXTERN void M2Options_CppRemember (DynamicStrings_String s);

/*
   GetISO - return TRUE if -fiso was present on the command line.
*/

EXTERN bool M2Options_GetISO (void);

/*
   GetPIM - return TRUE if -fpim was present on the command line.
*/

EXTERN bool M2Options_GetPIM (void);

/*
   GetPIM2 - return TRUE if -fpim2 was present on the command line.
*/

EXTERN bool M2Options_GetPIM2 (void);

/*
   GetPIM3 - return TRUE if -fpim3 was present on the command line.
*/

EXTERN bool M2Options_GetPIM3 (void);

/*
   GetPIM4 - return TRUE if -fpim4 was present on the command line.
*/

EXTERN bool M2Options_GetPIM4 (void);

/*
   GetPositiveModFloor - return TRUE if -fpositive-mod-floor was present
                         on the command line.
*/

EXTERN bool M2Options_GetPositiveModFloor (void);

/*
   GetFloatValueCheck - return TRUE if -ffloatvalue was present on the
                        command line.
*/

EXTERN bool M2Options_GetFloatValueCheck (void);

/*
   SetFloatValueCheck - set depending upon the -ffloatvalue.
*/

EXTERN void M2Options_SetFloatValueCheck (bool value);

/*
   GetWholeValueCheck - return TRUE if -fwholevalue was present on the
                        command line.
*/

EXTERN bool M2Options_GetWholeValueCheck (void);

/*
   SetWholeValueCheck - set depending upon the -fwholevalue.
*/

EXTERN void M2Options_SetWholeValueCheck (bool value);

/*
   SetWall - set all warnings to, value.
*/

EXTERN void M2Options_SetWall (bool value);

/*
   SetSaveTemps - turn on/off -save-temps.
*/

EXTERN void M2Options_SetSaveTemps (bool value);

/*
   SetSaveTempsDir - turn on/off -save-temps specifying the
                     directory.
*/

EXTERN void M2Options_SetSaveTempsDir (void * arg);

/*
   GetSaveTempsDir - return SaveTempsDir or NIL if -save-temps was not used.
*/

EXTERN DynamicStrings_String M2Options_GetSaveTempsDir (void);

/*
   SetDumpDir - Specify dump dir.
*/

EXTERN void M2Options_SetDumpDir (void * arg);

/*
   GetDumpDir - return DumpDir or NIL.
*/

EXTERN DynamicStrings_String M2Options_GetDumpDir (void);

/*
   SetGenModuleList - set the GenModuleList flag to value and pass
                      set GenModuleListFilename to filename.
*/

EXTERN void M2Options_SetGenModuleList (bool value, void * filename);

/*
   GetGenModuleFilename - returns the filename set by SetGenModuleList.
*/

EXTERN DynamicStrings_String M2Options_GetGenModuleFilename (void);

/*
   SetShared - sets the SharedFlag to value.
*/

EXTERN void M2Options_SetShared (bool value);

/*
   SetUninitVariableChecking - sets the UninitVariableChecking flag to value
                               or UninitVariableConditionalChecking to value.
                               Arg can be "known", "known,cond", "cond,known"
                               or "all".
*/

EXTERN int M2Options_SetUninitVariableChecking (bool value, void * arg);

/*
   SetCaseEnumChecking - sets the CaseEnumChecking to value.
*/

EXTERN void M2Options_SetCaseEnumChecking (bool value);

/*
   SetDebugBuiltins - sets the DebugBuiltins to value.
*/

EXTERN void M2Options_SetDebugBuiltins (bool value);

/*
   SetIBMLongDouble - enable/disable LONGREAL to map onto the
                      IBM long double 128 bit data type.
                      (Only available on the ppc).
*/

EXTERN void M2Options_SetIBMLongDouble (bool value);

/*
   GetIBMLongDouble - return the value of IBMLongDouble.
*/

EXTERN bool M2Options_GetIBMLongDouble (void);

/*
   SetIEEELongDouble - enable/disable LONGREAL to map onto the
                       IEEE long double 128 bit data type.
                       (Only available on the ppc).
*/

EXTERN void M2Options_SetIEEELongDouble (bool value);

/*
   GetIEEELongDouble - return the value of IEEELongDouble.
*/

EXTERN bool M2Options_GetIEEELongDouble (void);

/*
   GetDumpDeclFilename - returns the DumpLangDeclFilename.
*/

EXTERN DynamicStrings_String M2Options_GetDumpDeclFilename (void);

/*
   SetDumpDeclFilename - set DumpDeclFilename to filename.
*/

EXTERN void M2Options_SetDumpDeclFilename (bool value, void * filename);

/*
   GetDumpQuadFilename - returns the DumpQuadFilename.
*/

EXTERN DynamicStrings_String M2Options_GetDumpQuadFilename (void);

/*
   SetDumpQuadFilename - set DumpQuadFilename to filename.
*/

EXTERN void M2Options_SetDumpQuadFilename (bool value, void * filename);

/*
   GetDumpGimpleFilename - returns the DumpGimpleFilename.
*/

EXTERN DynamicStrings_String M2Options_GetDumpGimpleFilename (void);

/*
   SetDumpGimpleFilename - set DumpGimpleFilename to filename.
*/

EXTERN void M2Options_SetDumpGimpleFilename (bool value, void * filename);

/*
   SetM2DumpFilter - sets the filter to a comma separated list of procedures
                     and modules.
*/

EXTERN void M2Options_SetM2DumpFilter (bool value, void * filter);

/*
   GetM2DumpFilter - returns the dump filter.
*/

EXTERN void * M2Options_GetM2DumpFilter (void);

/*
   SetM2Dump - sets the dump via a comma separated list: quad,decl,gimple,all.
*/

EXTERN bool M2Options_SetM2Dump (bool value, void * filter);

/*
   GetDumpGimple - return TRUE if the dump gimple flag is set from SetM2Dump.
*/

EXTERN bool M2Options_GetDumpGimple (void);

/*
   GetDumpQuad - return TRUE if the dump quad flag is set from SetM2Dump.
*/

EXTERN bool M2Options_GetDumpQuad (void);

/*
   GetDumpDecl - return TRUE if the dump quad flag is set from SetM2Dump.
*/

EXTERN bool M2Options_GetDumpDecl (void);

/*
   GetDebugTraceQuad - return DebugTraceQuad.
*/

EXTERN bool M2Options_GetDebugTraceQuad (void);

/*
   GetDebugTraceTree - return DebugTraceTree.
*/

EXTERN bool M2Options_GetDebugTraceTree (void);

/*
   GetDebugTraceToken - return DebugTraceToken.
*/

EXTERN bool M2Options_GetDebugTraceToken (void);

/*
   GetDebugTraceLine - return DebugTraceLine.
*/

EXTERN bool M2Options_GetDebugTraceLine (void);

/*
   GetDebugFunctionLineNumbers - return DebugFunctionLineNumbers.
*/

EXTERN bool M2Options_GetDebugFunctionLineNumbers (void);

/*
   GetEnableForward - return EnableForward.
*/

EXTERN bool M2Options_GetEnableForward (void);

/*
   SetEnableForward - set EnableForward to value.
*/

EXTERN void M2Options_SetEnableForward (bool value);

/*
   SetFileOffsetBits - set the number of bits used by SYSTEM.COFF_T to bits.
*/

EXTERN bool M2Options_SetFileOffsetBits (bool value, unsigned int bits);

/*
   GetFileOffsetBits - return the number of bits used by SYSTEM.COFF_T.
*/

EXTERN unsigned int M2Options_GetFileOffsetBits (void);

/*
   FinaliseOptions - once all options have been parsed we set any inferred
                     values.
*/

EXTERN void M2Options_FinaliseOptions (void);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
