/* do not edit automatically generated by mc from M2BasicBlock.  */
/* M2BasicBlock.def converts a scope block into a list of basic blocks.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2BasicBlock_H)
#   define _M2BasicBlock_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GM2Scope.h"

#   if defined (_M2BasicBlock_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#if !defined (M2BasicBlock_BasicBlock_D)
#  define M2BasicBlock_BasicBlock_D
   typedef void *M2BasicBlock_BasicBlock;
#endif

typedef struct M2BasicBlock_BasicBlockProc_p M2BasicBlock_BasicBlockProc;

typedef void (*M2BasicBlock_BasicBlockProc_t) (M2BasicBlock_BasicBlock);
struct M2BasicBlock_BasicBlockProc_p { M2BasicBlock_BasicBlockProc_t proc; };


/*
   InitBasicBlocks - converts a list of quadruples as defined by
                     scope blocks into a set of basic blocks.
                     All quadruples within this list which are not
                     reachable are removed.
*/

EXTERN M2BasicBlock_BasicBlock M2BasicBlock_InitBasicBlocks (M2Scope_ScopeBlock sb);

/*
   InitBasicBlocksFromRange - converts a list of quadruples as defined by
                              start..end.
                              All quadruples within this list which are not
                              reachable are removed.
*/

EXTERN M2BasicBlock_BasicBlock M2BasicBlock_InitBasicBlocksFromRange (unsigned int ScopeSym, unsigned int start, unsigned int end);

/*
   KillBasicBlocks - destroys the list of Basic Blocks and assigns bb to NIL.
*/

EXTERN void M2BasicBlock_KillBasicBlocks (M2BasicBlock_BasicBlock *bb);

/*
   FreeBasicBlocks - destroys the list of Basic Blocks.
*/

EXTERN void M2BasicBlock_FreeBasicBlocks (M2BasicBlock_BasicBlock bb);

/*
   ForeachBasicBlockDo - for each basic block call procedure, p.
*/

EXTERN void M2BasicBlock_ForeachBasicBlockDo (M2BasicBlock_BasicBlock bb, M2BasicBlock_BasicBlockProc p);

/*
   GetBasicBlockScope - return the scope associated with the basic block.
*/

EXTERN unsigned int M2BasicBlock_GetBasicBlockScope (M2BasicBlock_BasicBlock bb);

/*
   GetBasicBlockStart - return the quad associated with the start of the basic block.
*/

EXTERN unsigned int M2BasicBlock_GetBasicBlockStart (M2BasicBlock_BasicBlock bb);

/*
   GetBasicBlockEnd - return the quad associated with the end of the basic block.
*/

EXTERN unsigned int M2BasicBlock_GetBasicBlockEnd (M2BasicBlock_BasicBlock bb);

/*
   IsBasicBlockFirst - return TRUE if this basic block is the first in the sequence.
*/

EXTERN bool M2BasicBlock_IsBasicBlockFirst (M2BasicBlock_BasicBlock bb);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
