/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;

public class ColorSpaceCMYK
extends ColorSpace {
    private static final long serialVersionUID = -6362864473145799405L;

    public ColorSpaceCMYK() {
        super(9, 4);
    }

    private float[] fromRGBtoCIEXYZ(float[] rgbvalue) {
        ColorSpace colorspaceRGB = ColorSpace.getInstance(1000);
        return colorspaceRGB.toCIEXYZ(rgbvalue);
    }

    private float[] fromCIEXYZtoRGB(float[] xyzvalue) {
        ColorSpace colorspaceXYZ = ColorSpace.getInstance(1001);
        return colorspaceXYZ.toRGB(xyzvalue);
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        if (colorvalue != null && colorvalue.length == 3) {
            return this.fromRGB(this.fromCIEXYZtoRGB(colorvalue));
        }
        return null;
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        if (rgbvalue != null && rgbvalue.length == 3) {
            float c = 1.0f - rgbvalue[0];
            float m = 1.0f - rgbvalue[1];
            float y = 1.0f - rgbvalue[2];
            float varK = 1.0f;
            float[] cmyk = new float[4];
            if (c < varK) {
                varK = c;
            }
            if (m < varK) {
                varK = m;
            }
            if (y < varK) {
                varK = y;
            }
            if (varK == 1.0f) {
                cmyk[2] = 0.0f;
                cmyk[1] = 0.0f;
                cmyk[0] = 0.0f;
            } else {
                cmyk[0] = (c - varK) / (1.0f - varK);
                cmyk[1] = (m - varK) / (1.0f - varK);
                cmyk[2] = (y - varK) / (1.0f - varK);
            }
            cmyk[3] = varK;
            return cmyk;
        }
        return null;
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        if (colorvalue != null && colorvalue.length == 4) {
            return this.fromRGBtoCIEXYZ(this.toRGB(colorvalue));
        }
        return null;
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        if (colorvalue != null && colorvalue.length == 4) {
            float k = colorvalue[3];
            float c = colorvalue[0] * (1.0f - k) + k;
            float m = colorvalue[1] * (1.0f - k) + k;
            float y = colorvalue[2] * (1.0f - k) + k;
            return new float[]{1.0f - c, 1.0f - m, 1.0f - y};
        }
        return null;
    }
}

