/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.apache.solr.common.MapSerializable;
import org.apache.solr.common.MapWriterMap;
import org.apache.solr.common.NavigableObject;
import org.apache.solr.common.util.Utils;
import org.noggit.JSONWriter;

public interface MapWriter
extends MapSerializable,
NavigableObject,
JSONWriter.Writable {
    @Deprecated
    public static final MapWriter EMPTY = new MapWriterMap(Collections.emptyMap());

    default public String jsonStr() {
        return Utils.toJSONString(this);
    }

    @Override
    default public Map<String, Object> toMap(Map<String, Object> map) {
        return Utils.convertToMap(this, map);
    }

    @Override
    default public void write(final JSONWriter writer) {
        writer.startObject();
        try {
            this.writeMap(new EntryWriter(){
                boolean first = true;

                @Override
                public EntryWriter put(CharSequence k, Object v) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        writer.writeValueSeparator();
                    }
                    writer.indent();
                    writer.writeString(k.toString());
                    writer.writeNameSeparator();
                    writer.write(v);
                    return this;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        writer.endObject();
    }

    public void writeMap(EntryWriter var1) throws IOException;

    @Deprecated
    default public MapWriter append(MapWriter another) {
        MapWriter m = this;
        return ew -> {
            m.writeMap(ew);
            another.writeMap(ew);
        };
    }

    public static interface EntryWriter {
        public EntryWriter put(CharSequence var1, Object var2) throws IOException;

        default public EntryWriter putNoEx(CharSequence k, Object v) {
            try {
                this.put(k, v);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        default public EntryWriter put(CharSequence k, Object v, BiPredicate<CharSequence, Object> p) throws IOException {
            if (p.test(k, v)) {
                this.put(k, v);
            }
            return this;
        }

        default public EntryWriter putIfNotNull(CharSequence k, Object v) throws IOException {
            if (v != null) {
                this.put(k, v);
            }
            return this;
        }

        default public EntryWriter putIfNotNull(CharSequence k, Supplier<Object> v) throws IOException {
            Object val;
            Object object = val = v == null ? null : v.get();
            if (val != null) {
                this.putIfNotNull(k, val);
            }
            return this;
        }

        default public EntryWriter put(CharSequence k, int v) throws IOException {
            this.put(k, (Object)v);
            return this;
        }

        default public EntryWriter put(CharSequence k, long v) throws IOException {
            this.put(k, (Object)v);
            return this;
        }

        default public EntryWriter put(CharSequence k, float v) throws IOException {
            this.put(k, Float.valueOf(v));
            return this;
        }

        default public EntryWriter put(CharSequence k, double v) throws IOException {
            this.put(k, (Object)v);
            return this;
        }

        default public EntryWriter put(CharSequence k, boolean v) throws IOException {
            this.put(k, (Object)v);
            return this;
        }

        default public EntryWriter put(CharSequence k, CharSequence v) throws IOException {
            this.put(k, (Object)v);
            return this;
        }

        default public BiConsumer<CharSequence, Object> getBiConsumer() {
            return (k, v) -> this.putNoEx((CharSequence)k, v);
        }
    }
}

