\name{RecursiveGaussianImageFilter}
\alias{RecursiveGaussianImageFilter}
\title{RecursiveGaussianImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Base class for computing IIR convolution with an approximation of a
Gaussian kernel.
RecursiveGaussianImageFilter}
\details{
 \deqn{ \frac{ 1 }{ \sigma \sqrt{ 2 \pi } } \exp{ \left( - \frac{x^2}{ 2 \sigma^2 } \right) } }
RecursiveGaussianImageFilter is the base class for recursive filters that approximate convolution
with the Gaussian kernel. This class implements the recursive
filtering method proposed by R.Deriche in IEEE-PAMI Vol.12, No.1,
January 1990, pp 78-87, "Fast Algorithms for Low-Level Vision"
Details of the implementation are described in the technical report: R.
Deriche, "Recursively Implementing The Gaussian and Its
Derivatives", INRIA, 1993, ftp://ftp.inria.fr/INRIA/tech-reports/RR/RR-1893.ps.gz
Further improvements of the algorithm are described in: G. Farnebäck &
C.-F. Westin, "Improving Deriche-style Recursive Gaussian Filters".
J Math Imaging Vis 26, 293–299 (2006). https://doi.org/10.1007/s10851-006-8464-z
As compared to itk::DiscreteGaussianImageFilter , this filter tends to be faster for large kernels, and it can take
the derivative of the blurred image in one step. Also, note that we
have itk::RecursiveGaussianImageFilter::SetSigma() , but itk::DiscreteGaussianImageFilter::SetVariance() .
See:
DiscreteGaussianImageFilter
RecursiveGaussian for the procedural interface
itk::RecursiveGaussianImageFilter for the Doxygen on the original ITK class.
RecursiveGaussianImageFilter}
%C++ includes: sitkRecursiveGaussianImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{unsigned int GetDirection() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetNormalizeAcrossScale() const:}{}
\item{OrderType GetOrder() const:}{
     Set/Get the Order of the Gaussian to convolve with.
ZeroOrder is equivalent to convolving with a Gaussian. This is the
default.
FirstOrder is equivalent to convolving with the first derivative of a
Gaussian.
SecondOrder is equivalent to convolving with the second derivative of
a Gaussian.
}
\item{double GetSigma() const:}{
Set/Get the Sigma, measured in world coordinates, of the Gaussian
kernel. The default is 1.0. An exception will be generated if the
Sigma value is less than or equal to zero.
}
\item{Self NormalizeAcrossScaleOff():}{}
\item{Self NormalizeAcrossScaleOn():}{
Set the value of NormalizeAcrossScale to true or false respectfully.
}
\item{ RecursiveGaussianImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetDirection(unsigned int Direction):}{}
\item{Self SetNormalizeAcrossScale(bool NormalizeAcrossScale):}{
     Set/Get the flag for normalizing the gaussian over scale-space.
This flag enables the analysis of the differential shape of features
independent of their size ( both pixels and physical size ). Following
the notation of Tony Lindeberg:
Let \deqn{ L(x; t) = g(x; t) \ast f(x) } be the scale-space representation of image \deqn{ f(x) } where \deqn{ g(x; t) = \frac{1}{ \sqrt{ 2 \pi t} } \exp{ \left( -\frac{x^2}{ 2 t } \right) } } is the Gaussian function and \deqn{\ast} denotes convolution. This is a change from above with \deqn{ t = \sigma^2 } .
Then the normalized derivative operator for normalized coordinates
across scale is:
 \deqn{ \partial_\xi = \sqrt{t} \partial_x }
The resulting scaling factor is \deqn{ \sigma^N } where N is the order of the derivative.
When this flag is ON the filter will be normalized in such a way that
the values of derivatives are not biased by the size of the object.
That is to say the maximum value a feature reaches across scale is
independent of the scale of the object.
For analyzing an image across scale-space you want to enable this
flag. It is disabled by default.
Not all scale space axioms are satisfied by this filter, some are only
approximated. Particularly, at fine scales ( say less than 1 pixel )
other methods such as a discrete Gaussian kernel should be considered.
}
\item{Self SetOrder(OrderType Order):}{
     Set/Get the Order of the Gaussian to convolve with.
ZeroOrder is equivalent to convolving with a Gaussian. This is the
default.
FirstOrder is equivalent to convolving with the first derivative of a
Gaussian.
SecondOrder is equivalent to convolving with the second derivative of
a Gaussian.
}
\item{Self SetSigma(double Sigma):}{
Set/Get the Sigma, measured in world coordinates, of the Gaussian
kernel. The default is 1.0. An exception will be generated if the
Sigma value is less than or equal to zero.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~RecursiveGaussianImageFilter():}{
Destructor
}
}
}
