/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.geospatial;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.geospatial.GeoJSONDataType;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GeoJSONData
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, GeoJSONData> {
    @Nonnull
    private final JsonData geometry;
    @Nonnull
    private final Map<String, JsonData> properties;
    @Nonnull
    private final GeoJSONDataType type;
    public static final JsonpDeserializer<GeoJSONData> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoJSONData::setupGeoJSONDataDeserializer);

    private GeoJSONData(Builder builder) {
        this.geometry = ApiTypeHelper.requireNonNull(builder.geometry, this, "geometry");
        this.properties = ApiTypeHelper.unmodifiable(builder.properties);
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static GeoJSONData of(Function<Builder, ObjectBuilder<GeoJSONData>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final JsonData geometry() {
        return this.geometry;
    }

    @Nonnull
    public final Map<String, JsonData> properties() {
        return this.properties;
    }

    @Nonnull
    public final GeoJSONDataType type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("geometry");
        this.geometry.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.properties)) {
            generator.writeKey("properties");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.properties.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGeoJSONDataDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::geometry, JsonData._DESERIALIZER, "geometry");
        op.add(Builder::properties, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "properties");
        op.add(Builder::type, GeoJSONDataType._DESERIALIZER, "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.geometry.hashCode();
        result = 31 * result + Objects.hashCode(this.properties);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoJSONData other = (GeoJSONData)o;
        return this.geometry.equals(other.geometry) && Objects.equals(this.properties, other.properties) && this.type.equals(other.type);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, GeoJSONData> {
        private JsonData geometry;
        @Nullable
        private Map<String, JsonData> properties;
        private GeoJSONDataType type;

        public Builder() {
        }

        private Builder(GeoJSONData o) {
            this.geometry = o.geometry;
            this.properties = Builder._mapCopy(o.properties);
            this.type = o.type;
        }

        private Builder(Builder o) {
            this.geometry = o.geometry;
            this.properties = Builder._mapCopy(o.properties);
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder geometry(JsonData value) {
            this.geometry = value;
            return this;
        }

        @Nonnull
        public final Builder properties(Map<String, JsonData> map) {
            this.properties = Builder._mapPutAll(this.properties, map);
            return this;
        }

        @Nonnull
        public final Builder properties(String key, JsonData value) {
            this.properties = Builder._mapPut(this.properties, key, value);
            return this;
        }

        @Nonnull
        public final Builder type(GeoJSONDataType value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public GeoJSONData build() {
            this._checkSingleUse();
            return new GeoJSONData(this);
        }
    }
}

