/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.evaluation.metrics;

import java.util.Objects;
import java.util.Optional;
import org.tribuo.Output;
import org.tribuo.evaluation.metrics.EvaluationMetric;

public class MetricTarget<T extends Output<T>> {
    private final T target;
    private final EvaluationMetric.Average avg;
    private static final MetricTarget<?> macroTarget = new MetricTarget(EvaluationMetric.Average.MACRO);
    private static final MetricTarget<?> microTarget = new MetricTarget(EvaluationMetric.Average.MICRO);

    public MetricTarget(T target) {
        this.target = target;
        this.avg = null;
    }

    public MetricTarget(EvaluationMetric.Average avg) {
        this.target = null;
        this.avg = avg;
    }

    public Optional<T> getOutputTarget() {
        return Optional.ofNullable(this.target);
    }

    public Optional<EvaluationMetric.Average> getAverageTarget() {
        return Optional.ofNullable(this.avg);
    }

    public String toString() {
        if (this.getOutputTarget().isPresent()) {
            return String.format("MetricTarget{output=%s}", this.getOutputTarget().get());
        }
        return String.format("MetricTarget{average=%s}", this.getAverageTarget().get().name());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricTarget that = (MetricTarget)o;
        return Objects.equals(this.target, that.target) && this.avg == that.avg;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.target, this.avg});
    }

    public static <U extends Output<U>> MetricTarget<U> macroAverageTarget() {
        return macroTarget;
    }

    public static <U extends Output<U>> MetricTarget<U> microAverageTarget() {
        return microTarget;
    }
}

