/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import morfologik.fsa.FSA;
import morfologik.fsa.FSA5;
import morfologik.fsa.FSAFlags;

public final class CFSA
extends FSA {
    public static final byte VERSION = -59;
    public static final int BIT_FINAL_ARC = 1;
    public static final int BIT_LAST_ARC = 2;
    public static final int BIT_TARGET_NEXT = 4;
    public byte[] arcs;
    public final int nodeDataLength;
    private final Set<FSAFlags> flags;
    public final int gtl;
    public final byte[] labelMapping;

    CFSA(InputStream stream) throws IOException {
        DataInputStream in = new DataInputStream(stream);
        in.readByte();
        in.readByte();
        byte hgtl = in.readByte();
        this.flags = EnumSet.of(FSAFlags.FLEXIBLE, FSAFlags.STOPBIT, FSAFlags.NEXTBIT);
        if ((hgtl & 0xF0) != 0) {
            this.nodeDataLength = hgtl >>> 4 & 0xF;
            this.gtl = hgtl & 0xF;
            this.flags.add(FSAFlags.NUMBERS);
        } else {
            this.nodeDataLength = 0;
            this.gtl = hgtl & 0xF;
        }
        this.labelMapping = new byte[32];
        in.readFully(this.labelMapping);
        this.arcs = CFSA.readRemaining(in);
    }

    @Override
    public int getRootNode() {
        int epsilonNode = this.skipArc(this.getFirstArc(0));
        return this.getDestinationNodeOffset(this.getFirstArc(epsilonNode));
    }

    @Override
    public final int getFirstArc(int node) {
        return this.nodeDataLength + node;
    }

    @Override
    public final int getNextArc(int arc) {
        if (this.isArcLast(arc)) {
            return 0;
        }
        return this.skipArc(arc);
    }

    @Override
    public int getArc(int node, byte label) {
        int arc = this.getFirstArc(node);
        while (arc != 0) {
            if (this.getArcLabel(arc) == label) {
                return arc;
            }
            arc = this.getNextArc(arc);
        }
        return 0;
    }

    @Override
    public int getEndNode(int arc) {
        int nodeOffset = this.getDestinationNodeOffset(arc);
        if (0 == nodeOffset) {
            throw new RuntimeException("This is a terminal arc [" + arc + "]");
        }
        return nodeOffset;
    }

    @Override
    public byte getArcLabel(int arc) {
        if (this.isNextSet(arc) && this.isLabelCompressed(arc)) {
            return this.labelMapping[this.arcs[arc] >>> 3 & 0x1F];
        }
        return this.arcs[arc + 1];
    }

    @Override
    public int getRightLanguageCount(int node) {
        assert (this.getFlags().contains((Object)FSAFlags.NUMBERS)) : "This FSA was not compiled with NUMBERS.";
        return FSA5.decodeFromBytes(this.arcs, node, this.nodeDataLength);
    }

    @Override
    public boolean isArcFinal(int arc) {
        return (this.arcs[arc] & 1) != 0;
    }

    @Override
    public boolean isArcTerminal(int arc) {
        return 0 == this.getDestinationNodeOffset(arc);
    }

    public boolean isArcLast(int arc) {
        return (this.arcs[arc] & 2) != 0;
    }

    public boolean isNextSet(int arc) {
        return (this.arcs[arc] & 4) != 0;
    }

    public boolean isLabelCompressed(int arc) {
        assert (this.isNextSet(arc)) : "Only applicable to arcs with NEXT bit.";
        return (this.arcs[arc] & 0xFFFFFFF8) != 0;
    }

    @Override
    public Set<FSAFlags> getFlags() {
        return Collections.unmodifiableSet(this.flags);
    }

    final int getDestinationNodeOffset(int arc) {
        if (this.isNextSet(arc)) {
            return this.skipArc(arc);
        }
        int r = 0;
        int i = this.gtl;
        while (--i >= 1) {
            r = r << 8 | this.arcs[arc + 1 + i] & 0xFF;
        }
        r = r << 8 | this.arcs[arc] & 0xFF;
        return r >>> 3;
    }

    private int skipArc(int offset) {
        offset = this.isNextSet(offset) ? (this.isLabelCompressed(offset) ? ++offset : (offset += 2)) : (offset += 1 + this.gtl);
        return offset;
    }
}

