# Generate Alembic migration script

```bash
alembic revision --autogenerate -m "Add HotSpot analysis"
```

# SQLite doesn't support drop column statement. Need to use batch operation instead

```python
from alembic import op, context
dialect_name = context.get_context().bind.engine.dialect.name
if dialect_name == "sqlite":
    with op.batch_alter_table('<table_name>') as batch_op:
        batch_op.drop_constraint('<constraint_name>', type_='foreignkey')
        batch_op.drop_column('<column_name>')
else:
    op.drop_constraint('<constraint_name>', '<table_name>', type_='foreignkey')
    op.drop_column('<column_name>', '<table_name>')
```
