/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class Function extends Resource {

	public Function(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the display name of the function
	 *
	 * @return the display name
	 * @throws Lib3MFException
	 */
	public String getDisplayName() throws Lib3MFException {
		Pointer bytesNeededDisplayName = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_function_getdisplayname.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededDisplayName, null}));
		int sizeDisplayName = bytesNeededDisplayName.getInt(0);
		Pointer bufferDisplayName = new Memory(sizeDisplayName);
		mWrapper.checkError(this, mWrapper.lib3mf_function_getdisplayname.invokeInt(new java.lang.Object[]{mHandle, sizeDisplayName, bytesNeededDisplayName, bufferDisplayName}));
		return new String(bufferDisplayName.getByteArray(0, sizeDisplayName - 1), StandardCharsets.UTF_8);
	}

	/**
	 * Sets the display name of the function
	 *
	 * @param displayName the display name
	 * @throws Lib3MFException
	 */
	public void setDisplayName(String displayName) throws Lib3MFException {
		byte[] bytesDisplayName = displayName.getBytes(StandardCharsets.UTF_8);
		Memory bufferDisplayName = new Memory(bytesDisplayName.length + 1);
		bufferDisplayName.write(0, bytesDisplayName, 0, bytesDisplayName.length);
		bufferDisplayName.setByte(bytesDisplayName.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_function_setdisplayname.invokeInt(new java.lang.Object[]{mHandle, bufferDisplayName}));
	}

	/**
	 * Add an input
	 *
	 * @param identifier the identifier of the input
	 * @param displayName the display name of the input
	 * @param type the type of the input
	 * @return The added input port
	 * @throws Lib3MFException
	 */
	public ImplicitPort addInput(String identifier, String displayName, Lib3MFWrapper.ImplicitPortType type) throws Lib3MFException {
		byte[] bytesIdentifier = identifier.getBytes(StandardCharsets.UTF_8);
		Memory bufferIdentifier = new Memory(bytesIdentifier.length + 1);
		bufferIdentifier.write(0, bytesIdentifier, 0, bytesIdentifier.length);
		bufferIdentifier.setByte(bytesIdentifier.length, (byte)0);
		byte[] bytesDisplayName = displayName.getBytes(StandardCharsets.UTF_8);
		Memory bufferDisplayName = new Memory(bytesDisplayName.length + 1);
		bufferDisplayName.write(0, bytesDisplayName, 0, bytesDisplayName.length);
		bufferDisplayName.setByte(bytesDisplayName.length, (byte)0);
		Pointer bufferPort = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_function_addinput.invokeInt(new java.lang.Object[]{mHandle, bufferIdentifier, bufferDisplayName, Lib3MFWrapper.EnumConversion.convertImplicitPortTypeToConst(type), bufferPort}));
		Pointer valuePort = bufferPort.getPointer(0);
		ImplicitPort port = null;
		if (valuePort == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Port was a null pointer");
		}
		port = mWrapper.PolymorphicFactory(valuePort, ImplicitPort.class);
		return port;
	}

	/**
	 * Retrieves the inputs
	 *
	 * @return iterator for the list of inputs
	 * @throws Lib3MFException
	 */
	public ImplicitPortIterator getInputs() throws Lib3MFException {
		Pointer bufferIterator = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_function_getinputs.invokeInt(new java.lang.Object[]{mHandle, bufferIterator}));
		Pointer valueIterator = bufferIterator.getPointer(0);
		ImplicitPortIterator iterator = null;
		if (valueIterator == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Iterator was a null pointer");
		}
		iterator = mWrapper.PolymorphicFactory(valueIterator, ImplicitPortIterator.class);
		return iterator;
	}

	/**
	 * Removes an input
	 *
	 * @param input The input to be removed
	 * @throws Lib3MFException
	 */
	public void removeInput(ImplicitPort input) throws Lib3MFException {
		Pointer inputHandle = null;
		if (input != null) {
			inputHandle = input.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Input is a null value.");
		}
		mWrapper.checkError(this, mWrapper.lib3mf_function_removeinput.invokeInt(new java.lang.Object[]{mHandle, inputHandle}));
	}

	/**
	 * Add an output
	 *
	 * @param identifier the identifier of the output
	 * @param displayName the display name of the output
	 * @param type the type of the input
	 * @return The added input port
	 * @throws Lib3MFException
	 */
	public ImplicitPort addOutput(String identifier, String displayName, Lib3MFWrapper.ImplicitPortType type) throws Lib3MFException {
		byte[] bytesIdentifier = identifier.getBytes(StandardCharsets.UTF_8);
		Memory bufferIdentifier = new Memory(bytesIdentifier.length + 1);
		bufferIdentifier.write(0, bytesIdentifier, 0, bytesIdentifier.length);
		bufferIdentifier.setByte(bytesIdentifier.length, (byte)0);
		byte[] bytesDisplayName = displayName.getBytes(StandardCharsets.UTF_8);
		Memory bufferDisplayName = new Memory(bytesDisplayName.length + 1);
		bufferDisplayName.write(0, bytesDisplayName, 0, bytesDisplayName.length);
		bufferDisplayName.setByte(bytesDisplayName.length, (byte)0);
		Pointer bufferPort = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_function_addoutput.invokeInt(new java.lang.Object[]{mHandle, bufferIdentifier, bufferDisplayName, Lib3MFWrapper.EnumConversion.convertImplicitPortTypeToConst(type), bufferPort}));
		Pointer valuePort = bufferPort.getPointer(0);
		ImplicitPort port = null;
		if (valuePort == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Port was a null pointer");
		}
		port = mWrapper.PolymorphicFactory(valuePort, ImplicitPort.class);
		return port;
	}

	/**
	 * Retrieves the outputs
	 *
	 * @return iterator for the outputs
	 * @throws Lib3MFException
	 */
	public ImplicitPortIterator getOutputs() throws Lib3MFException {
		Pointer bufferIterator = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_function_getoutputs.invokeInt(new java.lang.Object[]{mHandle, bufferIterator}));
		Pointer valueIterator = bufferIterator.getPointer(0);
		ImplicitPortIterator iterator = null;
		if (valueIterator == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Iterator was a null pointer");
		}
		iterator = mWrapper.PolymorphicFactory(valueIterator, ImplicitPortIterator.class);
		return iterator;
	}

	/**
	 * Removes an output
	 *
	 * @param output The output to be removed
	 * @throws Lib3MFException
	 */
	public void removeOutput(ImplicitPort output) throws Lib3MFException {
		Pointer outputHandle = null;
		if (output != null) {
			outputHandle = output.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Output is a null value.");
		}
		mWrapper.checkError(this, mWrapper.lib3mf_function_removeoutput.invokeInt(new java.lang.Object[]{mHandle, outputHandle}));
	}

	/**
	 * Retrieves an input
	 *
	 * @param identifier the identifier of the input
	 * @return the input port
	 * @throws Lib3MFException
	 */
	public ImplicitPort findInput(String identifier) throws Lib3MFException {
		byte[] bytesIdentifier = identifier.getBytes(StandardCharsets.UTF_8);
		Memory bufferIdentifier = new Memory(bytesIdentifier.length + 1);
		bufferIdentifier.write(0, bytesIdentifier, 0, bytesIdentifier.length);
		bufferIdentifier.setByte(bytesIdentifier.length, (byte)0);
		Pointer bufferInput = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_function_findinput.invokeInt(new java.lang.Object[]{mHandle, bufferIdentifier, bufferInput}));
		Pointer valueInput = bufferInput.getPointer(0);
		ImplicitPort input = null;
		if (valueInput == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Input was a null pointer");
		}
		input = mWrapper.PolymorphicFactory(valueInput, ImplicitPort.class);
		return input;
	}

	/**
	 * Retrieves an output
	 *
	 * @param identifier the identifier of the output
	 * @return the output port
	 * @throws Lib3MFException
	 */
	public ImplicitPort findOutput(String identifier) throws Lib3MFException {
		byte[] bytesIdentifier = identifier.getBytes(StandardCharsets.UTF_8);
		Memory bufferIdentifier = new Memory(bytesIdentifier.length + 1);
		bufferIdentifier.write(0, bytesIdentifier, 0, bytesIdentifier.length);
		bufferIdentifier.setByte(bytesIdentifier.length, (byte)0);
		Pointer bufferOutput = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_function_findoutput.invokeInt(new java.lang.Object[]{mHandle, bufferIdentifier, bufferOutput}));
		Pointer valueOutput = bufferOutput.getPointer(0);
		ImplicitPort output = null;
		if (valueOutput == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Output was a null pointer");
		}
		output = mWrapper.PolymorphicFactory(valueOutput, ImplicitPort.class);
		return output;
	}


}

