/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.multiproject;

import java.io.File;
import java.io.Serializable;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalModuleEntry;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryBase;
import org.jetbrains.kotlin.incremental.util.Either;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\n0\t2\u0006\u0010\u000b\u001a\u00020\u0003H\u0014J\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\n0\t2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryJs;", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryBase;", "rootProjectDir", "Ljava/io/File;", "modulesInfo", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;)V", "getBuildHistoryFilesForJar", "Lorg/jetbrains/kotlin/incremental/util/Either;", "", "jar", "abiSnapshot", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nModulesApiHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModulesApiHistory.kt\norg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryJs\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
public final class ModulesApiHistoryJs
extends ModulesApiHistoryBase {
    public ModulesApiHistoryJs(@NotNull File rootProjectDir, @NotNull IncrementalModuleInfo modulesInfo) {
        Intrinsics.checkNotNullParameter(rootProjectDir, "rootProjectDir");
        Intrinsics.checkNotNullParameter(modulesInfo, "modulesInfo");
        super(rootProjectDir, modulesInfo);
    }

    @Override
    @NotNull
    protected Either<Set<File>> getBuildHistoryFilesForJar(@NotNull File jar) {
        Intrinsics.checkNotNullParameter(jar, "jar");
        IncrementalModuleEntry moduleEntry = this.getModulesInfo().getJarToModule().get(jar);
        return moduleEntry != null ? (Either)new Either.Success<Set<File>>(SetsKt.setOf(moduleEntry.getBuildHistoryFile())) : (Either)new Either.Error("No module is found for jar " + jar);
    }

    @Override
    @NotNull
    public Either<Set<File>> abiSnapshot(@NotNull File jar) {
        Either either;
        Intrinsics.checkNotNullParameter(jar, "jar");
        Serializable serializable = this.getModulesInfo().getJarToModule().get(jar);
        if (serializable != null && (serializable = serializable.getAbiSnapshot()) != null) {
            Serializable it = serializable;
            boolean bl = false;
            either = new Either.Success<Set<IncrementalModuleEntry>>(SetsKt.setOf(it));
        } else {
            either = new Either.Error("Failed to find snapshot for file " + jar.getAbsolutePath());
        }
        return either;
    }
}

