/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.StringJoiner;

public class AllRequestHeadersAttribute
implements ExchangeAttribute {
    public static final AllRequestHeadersAttribute INSTANCE = new AllRequestHeadersAttribute();

    private AllRequestHeadersAttribute() {
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        MultiMap headers = exchange.request().headers();
        if (headers.isEmpty()) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        for (Map.Entry header : headers) {
            joiner.add((String)header.getKey() + ": " + (String)header.getValue());
        }
        return joiner.toString();
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Headers", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Headers";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals("%{ALL_REQUEST_HEADERS}")) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

