/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.api.statements;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ArrayFactory;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public interface GrVariable
extends PsiVariable,
GrNamedElement {
    public static final GrVariable[] EMPTY_ARRAY = new GrVariable[0];
    public static final ArrayFactory<GrVariable> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new GrVariable[count];

    @NlsSafe
    @NotNull
    public String getName();

    @Nullable
    public GrTypeElement getTypeElementGroovy();

    @Nullable
    default public PsiType getDeclaredType() {
        GrTypeElement typeElement = this.getTypeElementGroovy();
        return typeElement != null ? typeElement.getType() : null;
    }

    @Nullable
    public GrExpression getInitializerGroovy();

    @Nullable
    default public PsiType getInitializerType() {
        GrExpression initializer = this.getInitializerGroovy();
        return initializer == null ? null : initializer.getType();
    }

    default public boolean isUnnamed() {
        GrVariableDeclaration variableDeclaration;
        if (!GroovyConfigUtils.isAtLeastGroovy50(this)) {
            return false;
        }
        if (!this.getName().equals("_")) {
            return false;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GrVariableDeclaration && (variableDeclaration = (GrVariableDeclaration)parent).isTuple()) {
            return true;
        }
        PsiElement grandParent = parent.getParent();
        return parent instanceof GrParameterList && (grandParent instanceof GrLambdaExpression || grandParent instanceof GrClosableBlock);
    }

    @Nullable
    public PsiType getTypeGroovy();

    @Nullable
    public GrModifierList getModifierList();

    public boolean hasModifierProperty(@GrModifier.GrModifierConstant @NonNls @NotNull String var1);

    public void setType(@Nullable PsiType var1) throws IncorrectOperationException;

    public void setInitializerGroovy(@Nullable GrExpression var1) throws IncorrectOperationException;
}

