/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal;

import groovy.lang.Closure;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.Action;
import org.gradle.internal.file.RelativeFilePathResolver;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.dsl.internal.transform.ClosureBackedRuleFactory;
import org.gradle.model.dsl.internal.transform.RulesBlock;
import org.gradle.model.internal.core.DefaultNodeInitializerRegistry;
import org.gradle.model.internal.core.DeferredModelAction;
import org.gradle.model.internal.core.DirectNodeNoInputsModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.ModelTypeInitializationException;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;

@ThreadSafe
public class TransformedModelDslBacking {
    private final ModelRegistry modelRegistry;
    private final ClosureBackedRuleFactory ruleFactory;

    public TransformedModelDslBacking(ModelRegistry modelRegistry, RelativeFilePathResolver relativeFilePathResolver) {
        this.modelRegistry = modelRegistry;
        this.ruleFactory = new ClosureBackedRuleFactory(relativeFilePathResolver);
    }

    public void configure(String modelPathString, Closure<?> closure) {
        ModelPath modelPath = ModelPath.path((String)modelPathString);
        DeferredModelAction modelAction = this.ruleFactory.toAction(Object.class, closure);
        this.registerAction(modelPath, ModelType.UNTYPED, ModelActionRole.Mutate, modelAction);
    }

    public <T> void create(String modelPathString, Class<T> type, Closure<?> closure) {
        ModelPath modelPath = ModelPath.path((String)modelPathString);
        DeferredModelAction modelAction = this.ruleFactory.toAction(type, closure);
        ModelRuleDescriptor descriptor = modelAction.getDescriptor();
        ModelType modelType = ModelType.of(type);
        try {
            NodeInitializerRegistry nodeInitializerRegistry = (NodeInitializerRegistry)this.modelRegistry.realize(DefaultNodeInitializerRegistry.DEFAULT_REFERENCE.getPath(), DefaultNodeInitializerRegistry.DEFAULT_REFERENCE.getType());
            NodeInitializer nodeInitializer = nodeInitializerRegistry.getNodeInitializer(NodeInitializerContext.forType((ModelType)modelType));
            this.modelRegistry.register(ModelRegistrations.of((ModelPath)modelPath, (NodeInitializer)nodeInitializer).descriptor(descriptor).build());
        }
        catch (ModelTypeInitializationException e) {
            throw new InvalidModelRuleDeclarationException(descriptor, (Throwable)e);
        }
        this.registerAction(modelPath, modelType, ModelActionRole.Initialize, modelAction);
    }

    private <T> void registerAction(ModelPath modelPath, ModelType<T> viewType, final ModelActionRole role, final DeferredModelAction action) {
        ModelReference reference = ModelReference.of((ModelPath)modelPath, viewType);
        this.modelRegistry.configure(ModelActionRole.Initialize, DirectNodeNoInputsModelAction.of((ModelReference)reference, (ModelRuleDescriptor)action.getDescriptor(), (Action)new Action<MutableModelNode>(){

            public void execute(MutableModelNode node) {
                action.execute(node, role);
            }
        }));
    }

    public static boolean isTransformedBlock(Closure<?> closure) {
        Class<?> closureClass = closure.getClass();
        RulesBlock annotation = closureClass.getAnnotation(RulesBlock.class);
        return annotation != null;
    }
}

