/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.WorkerTestDefinitionProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.ClassFileExtractionManager;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.testng.TestNGDetector;
import org.gradle.api.internal.tasks.testing.testng.TestNGSpec;
import org.gradle.api.internal.tasks.testing.testng.TestNgTestDefinitionProcessorFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.api.tasks.testing.testng.TestNGOptions;
import org.gradle.internal.Factory;
import org.gradle.process.internal.worker.WorkerProcessBuilder;

public abstract class TestNGTestFramework
implements TestFramework {
    private TestNGDetector detector;
    private final DefaultTestFilter filter;
    private final Factory<File> testTaskTemporaryDir;
    private final Provider<Boolean> dryRun;
    private final DirectoryReport html;

    @Inject
    public TestNGTestFramework(DefaultTestFilter filter, Factory<File> testTaskTemporaryDir, Provider<Boolean> dryRun, DirectoryReport html) {
        this.filter = filter;
        this.testTaskTemporaryDir = testTaskTemporaryDir;
        this.detector = new TestNGDetector(new ClassFileExtractionManager(testTaskTemporaryDir));
        this.dryRun = dryRun;
        this.html = html;
        TestNGTestFramework.conventionMapOutputDirectory(this.getOptions(), html);
    }

    private static void conventionMapOutputDirectory(TestNGOptions options, DirectoryReport html) {
        new DslObject((Object)options).getConventionMapping().map("outputDirectory", () -> html.getOutputLocation().getAsFile().getOrNull());
    }

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Override
    public TestFramework copyWithFilters(TestFilter newTestFilters) {
        TestNGTestFramework newTestFramework = (TestNGTestFramework)this.getObjectFactory().newInstance(TestNGTestFramework.class, new Object[]{newTestFilters, this.testTaskTemporaryDir, this.dryRun, this.html});
        newTestFramework.getOptions().copyFrom(this.getOptions());
        return newTestFramework;
    }

    @Override
    public WorkerTestDefinitionProcessorFactory<?> getProcessorFactory() {
        List<File> suiteFiles = this.getOptions().getSuites((File)this.testTaskTemporaryDir.create());
        TestNGSpec spec = this.toSpec(this.getOptions(), this.filter);
        return new TestNgTestDefinitionProcessorFactory(this.getOptions().getOutputDirectory(), spec, suiteFiles);
    }

    private TestNGSpec toSpec(TestNGOptions options, DefaultTestFilter filter) {
        return new TestNGSpec(filter.toSpec(), options.getSuiteName(), options.getTestName(), options.getParallel(), options.getThreadCount(), ((Integer)options.getSuiteThreadPoolSize().get()).intValue(), options.getUseDefaultListeners(), options.getThreadPoolFactoryClass(), options.getIncludeGroups(), options.getExcludeGroups(), options.getListeners(), options.getConfigFailurePolicy(), options.getPreserveOrder(), options.getGroupByInstances(), ((Boolean)this.dryRun.get()).booleanValue());
    }

    @Override
    public Action<WorkerProcessBuilder> getWorkerConfigurationAction() {
        return workerProcessBuilder -> workerProcessBuilder.sharedPackages(new String[]{"org.testng"});
    }

    @Override
    @Nested
    public abstract TestNGOptions getOptions();

    @Override
    public TestNGDetector getDetector() {
        return this.detector;
    }

    @Override
    public int getAdditionalReportEntrySkipLevels() {
        return 2;
    }

    @Override
    public void close() throws IOException {
        this.detector = null;
    }

    @Override
    public String getDisplayName() {
        return "TestNG";
    }
}

